/*////////////////////////////////////////////////////////////////////////
Copyright (c) 2005 National Institute of Advanced Industrial Science and Technology (AIST)

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.
AIST MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	dl.c (Dynamic Linker)
Author:		Yutaka Sato <ysato@delegate.org>
Description:

History:
	050430	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include "ystring.h"
#include "log.h"

#ifdef __cplusplus
extern "C" {
#endif
void *dlopen(const char *path,int mode);
void *dlsym(void *handle,const char *symbol);
const char *dlerror(void);
int dlclose(void *handle);
/*
#define RTLD_LAZY ?
*/
#define RTLD_NOW  1
#ifdef __cplusplus
}
#endif

typedef struct {
  const	char *name;
	void *addr;
  const	char *opts;
} DLMap;

int dl_main(int ac,char *av[]){
	return 0;
}

static char *libpat[16] = {
#ifndef _MSC_VER
	"lib%s.so",
	"lib%s.dylib",
	"lib%s.so.1",
#endif
	"%s",
	0
};

/* DYLIB="lib*.so,lib*.dylib,lib*.so.1" */
void scan_DYLIB(PCStr(conf)){
	CStr(pats,2048);
	CStr(pat1,256);
	const char *patv[8];
	int pc,pi;

	strcpy(pats,conf);
	pc = list2vect(pats,',',8,patv);
	for( pi = 0; pi < pc && pi < elnumof(libpat); pi++ ){
		strcpy(pat1,patv[pi]);
		strsubst(AVStr(pat1),"*","%s");
		libpat[pi] = stralloc(pat1);
	}
	libpat[pc] = 0;
}

static int stab0(){
	fprintf(stderr,"--- dynamic link stab called ---\r\n");
	return 0;
}
static int do_exit(){
	fprintf(stderr,"--- dynamic link unknown function called ---\r\n");
	_exit(0);
	return -1;
}
int dl_library(const char *libname,DLMap *dlmap,const char *mode){
	CStr(libpath,1024);
	void *handle;
	void *addr;
	int i;
	DLMap *dl;
	const char *name;
	const char *pat1;
	int unknown = 0;
	int already = 0;

/*
	if( *(char**)dlmap[0].addr != 0 )
		return 0;
*/

	handle = 0;
	for( i = 0; pat1 = libpat[i]; i++ ){
		if( *pat1 == '!' || *pat1 == '-' ){
			pat1++;
			if( streq(pat1,libname) ){
				InitLog("## dont load %s\n",libname);
				return -1;
			}
		}
		if( strchr(pat1,'%') == 0 ){
			const char *dp;
			if( (dp = strstr(pat1,libname)) == 0 )
				continue;
			if( dp[strlen(libname)] != '.' )
				continue;
		}
		sprintf(libpath,pat1,libname);
		handle = dlopen(libpath,RTLD_NOW);
		InitLog("--- [%s] %X %s\n",libname,handle,libpath);
		if( handle != NULL )
			break;
	}
	if( handle == NULL ){
		InitLog("## cannot load %s\n",libname);
		return -1;
	}
	dl = dlmap;
	for( i = 0; name= dl[i].name; i++ ){
		addr = dlsym(handle,name);
		if( addr == 0
		 && *(char**)(dl[i].addr) != 0
		 && *(char**)(dl[i].addr) != (char*)do_exit
		){
			/*
			InitLog("in another module: %s\n",name);
			*/
			already++;
			continue;
		}
		if( addr == 0 && dl[i].opts && dl[i].opts[0] == '0' ){
			addr = (void*)stab0;
		}
		if( addr == 0 ){
			unknown++;
			/*
			InitLog("## unknown [%s] %s\n",libpath,name);
			*/
			*(char**)dl[i].addr = (char*)do_exit;
		}else{
			/*
			fprintf(stderr,"%X %X %s\n",dl[i].addr,addr,name);
			*/
			*(char**)dl[i].addr = (char*)addr;
		}
	}
InitLog("---- [%s] loaded %d syms, unknown=%d, already=%d\n",
libname,i,unknown,already);
	if( already ){
		InitLog("---- unknown = %d, already = %d / %d\n",
			unknown,already,i);
	}
	if( unknown )
		return -1;
	return 0;
}
