#include <fcntl.h>
/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1998-1999 Electrotechnical Laboratry (ETL), AIST, MITI
Copyright (c) 1998-1999 Yutaka Sato

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	nbio.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	980804	extracted from inets.c
//////////////////////////////////////////////////////////////////////#*/

#include <errno.h>
#include <stdio.h>
#include "ystring.h"
#include "vsocket.h"
#include "fpoll.h"

void msleep(int msec);
void Usleep(int);
int getNonblockingIO(int fd);
int setNonblockingIO(int fd,int on);

int file_issock(int fd);
int file_ISSOCK(int fd);
int IsAlive(int sock);
int sock_isconnected(int sock);

int IsSolaris();
int IsWindows95();
int IsBOW1_5();

int connectTO(int sock,SAP addr,int leng,int timeout)
{	int NB;
	int rcode;
	int nready;

	if( timeout == 0 )
		return connect(sock,addr,leng);

	NB = getNonblockingIO(sock);
	if( NB < 0 ){
		syslog_ERROR("connectTO: assume in non-blocking mode\n");
		NB = 0;
	}
	if( !NB ) rcode = setNonblockingIO(sock,1);

	errno = 0;
	rcode = connect(sock,addr,leng);

	if( rcode == 0 ){
		if( !NB ) setNonblockingIO(sock,0);
		return 0;
	}
	switch( errno ){
	  case ECONNREFUSED:
	  case ENETUNREACH:
	  case EHOSTUNREACH:
		syslog_ERROR("## connect[%d] refused (%d)\n",sock,errno);
		return -1;
	}

	if( !NB ) setNonblockingIO(sock,0);
	nready = PollOut(sock,timeout);

	if( nready <= 0 ){
		syslog_ERROR("## connect[%d] TIMEOUT(%d)\n",sock,timeout);
		errno = ETIMEDOUT;
		return -1;
	}

	if( !sock_isconnected(sock) ){
		syslog_ERROR("## connect[%d] failure (%d)\n",sock,errno);
		errno = ETIMEDOUT;
		return -1;
	}

	return 0;
}

void SetNonblockingIO(PCStr(what),int sock,int on)
{	int onbio,nnbio;

	if( sock < 0 )
		return;

	onbio = getNonblockingIO(sock);
	setNonblockingIO(sock,on);
	nnbio = getNonblockingIO(sock);
	if( onbio != nnbio )
		syslog_DEBUG("NBIO[%s][%d] %d -> %d\n",what,sock,onbio,nnbio);
}

/*
int recvX(int sock,PVStr(buff),int size,int flags){
	struct msghdr mh;
	struct iovec iov[1];
	int rcc;

	bzero(&mh,sizeof(mh));
	mh.msg_iov = iov;
	mh.msg_iov[0].iov_base = (char*)buff;
	mh.msg_iov[0].iov_len = QVSSize(buff,size);
	mh.msg_iovlen = 1;
	rcc = recvmsg(sock,&mh,flags);
	return rcc;
}
*/

int sendOOB(int sock,PCStr(buff),int size)
{
	return send(sock,buff,size,MSG_OOB);
}
int readyOOB(int sock){
	CStr(buff,1);
	return 0 < recv(sock,buff,1,MSG_OOB|MSG_PEEK);
}
int recvOOB(int sock,PVStr(buff),int size)
{
	alertVStr(buff,size);
	if( 0 < recv(sock,(char*)buff,size,MSG_OOB|MSG_PEEK) )
		return recv(sock,(char*)buff,size,MSG_OOB);
	else	return -1;
}
int recvOOBx(int sock,PVStr(buff),int size)
{	int rcode;

	alertVStr(buff,size);
	SetNonblockingIO("relayOOB",sock,1);
	rcode = recv(sock,(char*)buff,size,MSG_OOB);
	SetNonblockingIO("relayOOB",sock,0);
	return rcode;
}
/* relay OOB (maybe SYNCH signal of Telnet) */
int relayOOB(int in,int out)
{	CStr(buff,128);
	int rcc;
	int pi,nready;
	CStr(oobb,128);
	int oobx = 0;
	int noob = 0;

/*
	msleep(1);
	SetNonblockingIO("relayOOB",in,1);
	rcc = recvOOB(in,AVStr(buff),sizeof(buff));
	SetNonblockingIO("relayOOB",in,0);
	if( rcc != 1 )
		return 0;
*/
	SetNonblockingIO("relayOOB",in,1);
	oobx = 0;
	rcc = recv(in,buff,sizeof(buff),MSG_PEEK|MSG_OOB);
	if( 0 < rcc ){
		rcc = recv(in,oobb+oobx,sizeof(oobb)-oobx,MSG_OOB);
		oobx += rcc;
		while( 0 < withOOB(in) ){
			errno = 0;
			rcc = recv(in,buff,sizeof(buff),MSG_PEEK);
			/* recv() even with MSG_PEEK seems to clear
			 * "exceptfds" in select()
			 */
			if( rcc < 0 && errno == EAGAIN ){
				syslog_ERROR("relay OOB: EAGAIN\n");
				msleep(1);
			}else
			if( 0 < rcc && 0 < withOOB(in) ){
				/* maybe skipping non-OOB before OOB ... */
				CStr(vb,32);
				refQStr(vp,vb);
				int i;
				for( i = 0; i < rcc; i++ ){
					if( 0 < i ) setVStrPtrInc(vp,' ');
					sprintf(vp,"%02X",0xFF&buff[i]);
					vp += strlen(vp);
				}
				syslog_DEBUG("relay pre-OOB: %d [%s]\n",rcc,vb);
				rcc = recv(in,buff,sizeof(buff),0);
				noob += rcc;
				send(out,buff,rcc,0);
			}else{
				break;
			}
		}
	}
	if( 0 <= oobx ){
		send(out,oobb,oobx,MSG_OOB);
		syslog_DEBUG("relay OOB: [%d]->[%d] %dbytes (%02X)\n",
			in,out,oobx,oobb[0]&0xFF);
	}
	SetNonblockingIO("relayOOB",in,0);
	return oobx;


	syslog_DEBUG("relay OOB: [%d]->[%d] %dbytes (%x)\n",
		in,out,rcc,buff[0]&0xFF);
	sendOOB(out,buff,rcc);

	/* if the protocol is Telnet,
	 *  in-band data should be ignored until the MARK(242) ... */
	for( pi = 0; pi < 50; pi++ ){
		if( nready = PollIn(in,1) )
			break;
		msleep(10);
	}
	syslog_DEBUG("relay OOB: nready=%d after %dms\n",nready,pi*10);

	return 1;
}
int Peek1(int sock){
	CStr(buf,1);
	return recv(sock,buf,1,MSG_PEEK);
}

int Send(int s,PCStr(buf),int len)
{	int wcc;

	wcc = send(s,buf,len,0);
	return wcc;
}

/*
 * 991112 extracted from tcprelay.c
 */
int dump_tcprelay = 0;
static void bdump(int src,int dst,PCStr(buf),int rcc)
{	int rc,ch;

	printf("[%2d->%2d](%d) ",src,dst,rcc);
	for( rc = 0; rc < rcc; rc++ ){
		ch = buf[rc] & 0xFF;
		if( 0x21 <= ch && ch <= 0x7E )
			printf("%c",ch);
		else	printf(".");
	}
	printf(" ");
	for( rc = 0; rc < rcc; rc++ ){
		if( rc != 0 ) printf(" ");
		ch = buf[rc] & 0xFF;
		printf("%02x",ch);
	}
	printf("\n");
}

static int relay1(PCStr(arg),int src,int dst,int *rccp,int *wccp);
int simple_relayTimeout(int src,int dst,int timeout)
{	int rcc,wcc,rcc1,wcc1,nio;

	rcc = wcc = 0;
	for( nio = 0;; nio++ ){
		if( !IsWindows95() || file_ISSOCK(src) )
		if( timeout != 0 )
		if( PollIn(src,timeout) <= 0 )
			break;
		if( relay1(NULL,src,dst,&rcc1,&wcc1) <= 0 )
			break; 
		rcc += rcc1;
		wcc += wcc1;
	}
	syslog_ERROR("simple_relay [%d -> %d] = (%d -> %d) / %d\n",
		src,dst,rcc,wcc,nio);
	return rcc;
}

int simple_relayfTimeout(FILE *src,FILE *dst,int timeout)
{	int rcc,wcc,ch;

	for( rcc = 0; READYCC(src); rcc++ ){
		ch = getc(src);
		if( ch == EOF )
			return rcc;
		putc(ch,dst);
	}
	fflush(dst);
	syslog_ERROR("simple_relayf [%d -> %d] = %d\n",
		fileno(src),fileno(dst),rcc);
	return rcc + simple_relayTimeout(fileno(src),fileno(dst),timeout);
}

int relay_tee(PCStr(arg),int src,int dst1,int dst2,int *rccp,int *wccp1,int *wccp2)
{	int rcc,wcc,wc1;
	CStr(buf,0x4000);

	*wccp1 = 0;
	if( wccp2 ) *wccp2 = 0;

	rcc = read(src,buf,sizeof(buf));
	*rccp = rcc;
	if( rcc <= 0 )
		return rcc;

	if( dump_tcprelay )
		bdump(src,dst1,buf,rcc);

	wcc = 0;
	while( wcc < rcc ){
		wc1 = write(dst1,buf,rcc);
		if( wc1 <= 0 )
			break;
		wcc += wc1;
	}
	*wccp1 = wcc;
	if( dst2 < 0 || wc1 <= 0 )
		return wc1;

	wcc = 0;
	while( wcc < rcc ){
		wc1 = write(dst2,buf,rcc);
		if( wc1 <= 0 )
			break;
		wcc += wc1;
	}
	*wccp2 = wcc;
	return wc1;
}
static int relay1(PCStr(arg),int src,int dst,int *rccp,int *wccp)
{
	return relay_tee(arg,src,dst,-1,rccp,wccp,NULL);
}

#define IGN_EOF	1
int RELAYS_IGNEOF;

int SILENCE_TIMEOUT;

RelayCtrl relayCtrl;

void sigURG(int sig){
	fprintf(stderr,"------- got SIGURG\n");
}

void relaysx(int timeout,int sdc,int sdv[][2],int sdx[],int rccs[],IFUNCP funcv[],void *argv[])
{	int fi;
	int pc,pi,pfv[32],pxv[32];
	int fds[32],errv[32],rfds[32];
	int sdxb[32];
	int cntv[32];
	int rcode,rcc,wcc;
	IFUNCP funcvb[32];
	void *argvb[32];
	int nready;
	double Lastin[32],Now,Timeout,Idlest,Time();
	int timeouti;
	int prepi;
	int dobreak;

	RELAY_stat = 0;
	if( SILENCE_TIMEOUT )
	syslog_ERROR("relays(%d) start: TIMEOUT=io:%ds,silence:%ds\n",
		sdc,timeout/1000,SILENCE_TIMEOUT);
	else
	syslog_ERROR("relays(%d) start: timeout=%dmsec\n",sdc,timeout);

	if( funcv == NULL ){
		funcv = funcvb;
		for( fi = 0; fi < sdc; fi++ )
			funcv[fi] = NULL;
	}
	if( argv == NULL ){
		argv = argvb;
		for( fi = 0; fi < sdc; fi++ )
			argv[fi] = NULL;
	}

	Now = Time();
	for( fi = 0; fi < sdc; fi++ ){
/*
sv1log("#### NODELAY\n");
set_nodelay(sdv[fi][1],1);
*/
		fds[fi] = sdv[fi][0];
		errv[fi] = 0;
		rccs[fi] = 0;
		cntv[fi] = 0;
		Lastin[fi] = Now;
		if( funcv[fi] == NULL )
			funcv[fi] = (IFUNCP)relay1;

/*
fcntl(fds[fi],F_SETOWN,getpid());
signal(SIGURG,sigURG);
*/

		if( sdx == NULL ){
			sdxb[fi] = 0;
			if( RELAYS_IGNEOF ){
				if( file_issock(sdv[fi][0]) < 0 )
					sdxb[fi] |= IGN_EOF;
			}
		}
	}
	if( sdx == NULL )
		sdx = sdxb;

	RELAY_num_turns = 0;
	dobreak = 0;
	prepi = -1;
	for(;;){
	    pc = 0;
	    Idlest = Now = Time();
	    for( fi = 0; fi < sdc; fi++ ){
		if( errv[fi] == 0 ){
			pfv[pc] = fds[fi];
			pxv[pc] = fi;
			pc++;
		}
		if( Lastin[fi] < Idlest ){
			Idlest = Lastin[fi];
		}
	    }
	    if( pc == 0 )
		break;

	    errno = 0;
	    if( SILENCE_TIMEOUT ){
		timeouti = (int)(1000*(SILENCE_TIMEOUT - (Now-Idlest)));
		if( timeouti <= 0 )
			break;
		if( timeouti <= timeout ){
			nready = PollIns(timeouti,pc,pfv,rfds);
			goto POLLED;
		}
	    }

	    nready = PollIns(timeout,pc,pfv,rfds);
	/*
should ignore EINTR, by SIGSTOP/SIGCONT
	    if( nready < 0 && errno == EINTR ){
		continue;
	    }
	*/
POLLED:
/*
	    if( nready == 0 && errno == 0 ){
*/
	    if( nready == 0 && errno == 0 || gotOOB(-1) ){
		int fi,sync;

if(nready==0)
syslog_ERROR("---- nready==0 errno==%d OOB=%d\n",errno,gotOOB(-1));

		sync = 0;
		for( fi = 0; fi < sdc; fi++ )
			if( withOOB(sdv[fi][0]) )
			sync += relayOOB(sdv[fi][0],sdv[fi][1]);
		if( sync )
			continue;

		Usleep(1);
		nready = PollIns(1,pc,pfv,rfds);
		if( 0 < nready ){
			syslog_ERROR("## tcprelay: ignore OOB?\n");
			continue;
		}
	    }
	    if( nready <= 0 )
		break;

	    if( RELAY_half_dup ){
		if( nready < pc ){
			Usleep(1000);
			nready = PollIns(1,pc,pfv,rfds);
		}
		if( nready == pc ){
			if( 2 <= pc && IsAlive(pfv[0]) && IsAlive(pfv[1]) ){
			syslog_ERROR("## EXIT relaysx: not half_duplex\n");
			RELAY_stat = RELAY_NOTHALFDUP;
			goto EXIT;
			}
		}
	    }
	    for( pi = 0; pi < pc; pi++ ){
		if( 0 < rfds[pi] ){
			int pushed;
			fi = pxv[pi];
			if( pi != prepi ){
				RELAY_num_turns++;
			}
			if( RELAY_max_packintvl ){
				if( pi == prepi ){
					double intvl;
					intvl = Time() - Lastin[fi];
					if( RELAY_max_packintvl < intvl ){
						if( RELAY_num_turns <= 5 ){
				syslog_ERROR("## %d[%d] max-intvl<%d\n",
					RELAY_num_turns,pi,(int)(1000*intvl));
						}else
						{
						RELAY_packintvl = intvl;
						dobreak = 1;
				syslog_ERROR("## EXIT relaysx: max-intvl<%d\n",
					(int)(1000*intvl));
						}
					}
				}else{
					if( dobreak )
						goto EXIT;
				}
			}
			if( RELAY_max_turns && pi != prepi ){
				if( RELAY_max_turns < RELAY_num_turns ){
				syslog_ERROR("## EXIT relaysx: max_turns=%d\n",
					RELAY_num_turns);
					goto EXIT;
				}
			}
			prepi = pi;

			pushed = 0 <= top_fd(sdv[fi][0],0);
			rcode = (*funcv[fi])(argv[fi],sdv[fi][0],sdv[fi][1],&rcc,&wcc);
			Lastin[fi] = Time();
			rccs[fi] += wcc;
			cntv[fi] += 1;

			if( pushed && rcode == -1 && errno == EAGAIN ){
				syslog_ERROR("## relaysx() pop_fd:%d\n",
					sdv[fi][0]);
			}else
			if( rcode <= 0 ){
				syslog_ERROR(
					"relays[%d]: [%d->EOF] %d(%di+%do)\n",
					fi,fds[fi],rcode,rcc,wcc);
				if( sdx == NULL || (sdx[fi] & IGN_EOF) == 0 )
					goto EXIT;
				else	errv[fi] = 1;
			}
		}
	    }
	}
EXIT:
	for( fi = 0; fi < sdc; fi++ )
		syslog_ERROR("relays[%d]: [%d->%d] %d bytes / %d\n",fi,
			sdv[fi][0],sdv[fi][1],rccs[fi],cntv[fi]);
}
void relays(int timeout,int sdc,int sdv[][2],int rccs[])
{
	relaysx(timeout,sdc,sdv,NULL,rccs,NULL,NULL);
}
void tcp_relay2(int timeout,int s1,int d1,int s2,int d2)
{	int sdv[2][2];
	int rccs[2];

	sdv[0][0] = s1;
	sdv[0][1] = d1;
	sdv[1][0] = s2;
	sdv[1][1] = d2;
	relays(timeout,2,sdv,rccs);
}
void relay2_cntl(int timeout,int s1,int d1,int s2,int d2,int s3,int d3,IFUNCP cntlfunc,void *arg)
{	int sdv[3][2];
	int rccs[3];
	IFUNCP fnv[3]; /**/
	void *agv[3]; /**/

	sdv[0][0] = s1;
	sdv[0][1] = d1;
	fnv[0] = 0;
	agv[0] = 0;

	sdv[1][0] = s2;
	sdv[1][1] = d2;
	fnv[1] = 0;
	agv[1] = 0;

	sdv[2][0] = s3;
	sdv[2][1] = d3;
	fnv[2] = cntlfunc;
	agv[2] = arg;

	relaysx(timeout,3,sdv,NULL,rccs,fnv,agv);
}



#if defined(sun) && !defined(NC_TPI_CLTS)
#define SunOS4bin 1 /* this binary is compiled on SunOS4.X */
#else
#define SunOS4bin 0
#endif
int Getsockopt(int s,int level,int optname,char optval[],int *optlen)
{
	int rcode;

	if( IsBOW1_5() ){
		syslog_DEBUG("BOW1.5: ignore getsockopt(%d,%x)...\n",s,optname);
		return -1; /* avoid a bug of BOW1.5 ... */
	}
	rcode = getsockopt(s,level,optname,optval,optlen);
	if( rcode == 0 && optname == SO_TYPE && SunOS4bin && IsSolaris() ){
		switch( *(int*)optval ){
			case SOCK_DGRAM:  *(int*)optval = SOCK_STREAM; break;
			case SOCK_STREAM: *(int*)optval = SOCK_DGRAM;  break;
		}
	}
	return rcode;
}
int Setsockopt(int s,int level,int optname,PCStr(optval),int optlen)
{
	return setsockopt(s,level,optname,optval,optlen);
}
#define GETsockopt(s,l,o,v,n)	Getsockopt(s,l,o,(char*)v,n)
#define SETsockopt(s,l,o,v,n)	Setsockopt(s,l,o,(char*)v,n)

int getsocktype(int sock)
{	int type,len;

	len = sizeof(type);
	if( GETsockopt(sock,SOL_SOCKET,SO_TYPE,&type,&len) == 0 )
		return type;
	return -1;
}
int isUDPsock(int sock)
{	int type;

	type = getsocktype(sock);
	return type == SOCK_DGRAM;
}
int file_ISSOCK(int fd)
{
	return 0 <= getsocktype(fd);
}
int file_issock(int fd)
{	int ISSOCK;

	if( isatty(fd) || file_isreg(fd) )
		return -1;

	ISSOCK = file_ISSOCK(fd);
	if( 0 < ISSOCK )
		return ISSOCK;
	if( 0 < getsocktype(fd) )
		return 1;
	return -1;
}

void set_nodelay(int sock,int onoff)
{	int ooo,oon,len;

	len = sizeof(ooo);
	GETsockopt(sock,IPPROTO_TCP,TCP_NODELAY,&ooo,&len);
	SETsockopt(sock,IPPROTO_TCP,TCP_NODELAY,&onoff,sizeof(onoff));
	len = sizeof(oon);
	GETsockopt(sock,IPPROTO_TCP,TCP_NODELAY,&oon,&len);
	syslog_DEBUG("TCP_NODELAY[%d] %d -> %d\n",sock,ooo,oon);
}
void set_cork(int sock,int onoff){
	int ooo,oon,len;

#ifdef TCP_CORK
	len = sizeof(ooo);
	GETsockopt(sock,IPPROTO_TCP,TCP_CORK,&ooo,&len);
	SETsockopt(sock,IPPROTO_TCP,TCP_CORK,&onoff,sizeof(onoff));
	len = sizeof(oon);
	GETsockopt(sock,IPPROTO_TCP,TCP_CORK,&oon,&len);
	syslog_DEBUG("TCP_CORK[%d] %d -> %d\n",sock,ooo,oon);
#endif
}
void set_nopush(int sock,int onoff){
	int ooo,oon,len;

#ifdef TCP_NOPUSH
	len = sizeof(ooo);
	GETsockopt(sock,IPPROTO_TCP,TCP_NOPUSH,&ooo,&len);
	SETsockopt(sock,IPPROTO_TCP,TCP_NOPUSH,&onoff,sizeof(onoff));
	len = sizeof(oon);
	GETsockopt(sock,IPPROTO_TCP,TCP_NOPUSH,&oon,&len);
	syslog_DEBUG("TCP_NOPUSH[%d] %d -> %d\n",sock,ooo,oon);
#endif
}
int setsockSHARE(int sock,int onoff)
{
#ifdef SO_REUSEPORT
	return SETsockopt(sock,SOL_SOCKET,SO_REUSEPORT,&onoff,sizeof(onoff));
#else
	return -1;
#endif
}
void setsockREUSE(int sock,int onoff)
{
	SETsockopt(sock,SOL_SOCKET,SO_REUSEADDR,&onoff,sizeof(onoff));
}
int set_keepalive(int sock,int on)
{	int On = 1, No = 0;	
	int Ov = -1, len = sizeof(Ov);

	if( on)
		SETsockopt(sock, SOL_SOCKET, SO_KEEPALIVE, &On, sizeof(On));
	else	SETsockopt(sock, SOL_SOCKET, SO_KEEPALIVE, &No, sizeof(No));
	GETsockopt(sock, SOL_SOCKET, SO_KEEPALIVE, &Ov, &len);
	syslog_DEBUG("KeepAlive[%d] = %d\n",sock,Ov);
	return Ov;
}
int getsockbuf(int sock,int *in,int *out)
{	int len;
	int rcode;

	*in = 0;
	*out = 0;

	len = sizeof(int);
	rcode = GETsockopt(sock, SOL_SOCKET, SO_RCVBUF, in,&len);
	len = sizeof(int);
	rcode = GETsockopt(sock, SOL_SOCKET, SO_SNDBUF, out,&len);
	return rcode;
}
int setsockbuf(int sock,int in,int out)
{	int ois,is,oos,os;
	int len;

	if( 0 < in ){
		len = sizeof(ois);
		GETsockopt(sock, SOL_SOCKET, SO_RCVBUF, &ois,&len);
		is = in;
		SETsockopt(sock, SOL_SOCKET, SO_RCVBUF, &is,sizeof(is));
	}else	ois = is = 0;

	if( 0 < out ){
		len = sizeof(oos);
		GETsockopt(sock, SOL_SOCKET, SO_SNDBUF, &oos,&len);
		os = out;
		SETsockopt(sock, SOL_SOCKET, SO_SNDBUF, &os,sizeof(os));
	}else	oos = os = 0;
	syslog_DEBUG("setsockbuf[%d] in:%d->%d out:%d->%d\n",sock,ois,is,oos,os);
	return 0;
}
int expsockbuf(int sock,int in,int out)
{	int isize,osize;

	if( getsockbuf(sock,&isize,&osize) == 0 ){
		if( in  <= isize ) in = 0;
		if( out <= osize ) out = 0;
		if( in || out )
			return setsockbuf(sock,in,out);
		else	return 0;
	}
	return -1;
}
void set_linger(int sock,int secs)
{	struct linger sl,gl;
	int len,rcode;

	if( secs ){
		sl.l_onoff = 1;	/* on */
		sl.l_linger = secs;	/* seconds */
	}else{
#ifdef hpux
		sl.l_onoff = 1;
		sl.l_linger = 0;
#else
		sl.l_onoff = 0;
		sl.l_linger = 0;
#endif
	}
	rcode = SETsockopt(sock, SOL_SOCKET, SO_LINGER, &sl, sizeof(sl));
	if( rcode != 0 ){
		syslog_DEBUG("setsockopt(%d,LINGER) faield, errno=%d\n",sock,errno);
		return;
	}

	len = sizeof(gl);
	rcode = GETsockopt(sock, SOL_SOCKET, SO_LINGER, &gl, &len);
	if( rcode != 0 )
		syslog_DEBUG("getsockopt(%d,LINGER) failed, errno=%d\n",sock,errno);
	else	syslog_DEBUG("LINGER: [%d] %d %d{%d,%d}\n",sock,secs,
			len,gl.l_onoff,gl.l_linger);
}

int IsConnected(int sock,const char **reason)
{	int nready,rcc;
	CStr(buf,1);
	int len;
	VSAddr sab;

	len = sizeof(VSAddr);
	if( getpeername(sock,(SAP)&sab,&len) != 0 ){
		if(reason) *reason = "cant_getpeername";
		return 0;
	}

if(reason) *reason = "connected";
return 1;

/*
	nready = rPollIn(sock,1);
	if( nready < 0 ){
		if(reason) *reason = "peer_reset";
		return 0;
	}

	if( nready == 0 ){
		if(reason) *reason = "poll_none_ready";
		return 1;
	}

	rcc = recv(sock,buf,1,MSG_PEEK);
	if( rcc == 1 ){
		if(reason) *reason = "recv_ok";
		return 1;
	}

	if(reason) *reason = "cant_recv";
	return 0;
*/
}
int IsAlive(int sock){
	if( IsConnected(sock,NULL) ){
		if( PollIn(sock,1) == 0 || 0 < Peek1(sock) ) 
			return 1;
		else	syslog_ERROR("## left connected but dead [%d]\n",sock);
	}
	return 0;
}
