/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994-1999 Yutaka Sato
Copyright (c) 1994-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	ddi.c (DeleGate to DeleGate interface)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	950218	extracted from conf.c and service.c
//////////////////////////////////////////////////////////////////////#*/
#include "delegate.h"
#include "ystring.h"
#include "fpoll.h"
#include "file.h"
#include "proc.h"
#include "auth.h"
#include "url.h"
#define PEEKSIZE 0x2000

int DDI_readyCbuf(Connection *Conn);

int DDI_PollIn(Connection *Conn,FILE *fc,int timeout)
{	int nready;

	if( DDI_readyCbuf(Conn) )
		nready = 1;
	else	nready = fPollIn(fc,timeout);
	return nready;
}

void DDI_clearCbuf(Connection *Conn)
{
if( FromCpeak != FromCfill )
sv1log("#### CLEAR CBUF: %d %d\n",FromCpeak,FromCfill);

	if( FromCbuff != NULL ){
		free(FromCbuff);
		FromCbuff = NULL;
	}
	FromCpeak = 0;
	FromCfill = 0;
	FromCread = 0;
}

void DDI_pushCbuf(Connection *Conn,PCStr(req),int len)
{
	FromCfill = len;
	if( FromCbuff != NULL ){
		FromCbuff = (char*)realloc(FromCbuff,len+1);
	}else	FromCbuff = (char*)malloc(len+1);
	bcopy(req,FromCbuff,len); FromCbuff[len] = 0;
	FromCpeak = 0;
}
char *DDI_fgetsFromCbuf(Connection *Conn,PVStr(str),int size,FILE *fp)
{	char ch;
	int dx;

	if( size == 0 )
		return NULL;
	if( size == 1 ){
		setVStrEnd(str,0);
		return (char*)str;
	}

	dx = 0;
	if( FromCbuff && FromCpeak < FromCfill ){
		while( FromCpeak < FromCfill ){
			if( size-1 <= dx ){
sv1log("#### DDI_fgetsFromCbuf: over flow! %d / %d\n",dx,size);
				AbortLog();
				break;
			}
			ch = FromCbuff[FromCpeak++];
			setVStrElemInc(str,dx,ch); /**/
			if( ch == '\n' )
				break;
		}
		setVStrEnd(str,dx); /**/
		if( FromCpeak == FromCfill ){
			/* don't DDI_proceedFromC(Conn) for Solaris... */
		}
		return (char*)str;
	}
	return NULL;
}
int DDI_readyCbuf(Connection *Conn)
{
	return FromCbuff && FromCpeak < FromCfill;
}

int DDI_flushCbuf(Connection *Conn,PVStr(bbuff),int bsize,FILE *fc)
{	int bn;

	bn = 0;
	while( 0 < DDI_readyCbuf(Conn) ){
		if( DDI_fgetsFromCbuf(Conn,QVStr(bbuff+bn,bbuff),bsize-bn,fc) == NULL )
			break;
		bn += strlen(bbuff+bn);
	}
	return bn;
}

int PEEK_CLIENT_REQUEST = 0;

int DDI_proceedFromC(Connection *Conn,FILE *fp)
{	CStr(buff,PEEKSIZE);
	int len,rrc,rcc;
	int rcode = 0;

	if( 0 < FromCread ){
		len = FromCpeak;
		rrc = 0;
		while( 0 < len && 0 < ready_cc(fp) ){
			if( getc(fp) == EOF )
				break;
			len--;
			rrc++;
		}
		rcc = reads(fileno(fp),AVStr(buff),len);

		sv1log("-- discard %d+%d = %d /%d/%d Bytes of peeked request\n",
			rrc,rcc,FromCpeak,FromCfill,FromCread);

		if( rrc+rcc != FromCpeak ){
			sv1log("#### discard failed: %d + %d / %d\n",
				rrc,rcc,FromCpeak);
			rcode = -1;
		}
		DDI_clearCbuf(Conn);
	}
	return rcode;
}

int DDI_peekcFromC(Connection *Conn,FILE *fp)
{	int ch;

	if( FromCbuff && FromCpeak < FromCfill )
		return  FromCbuff[FromCpeak];

	if( PEEK_CLIENT_REQUEST )
		DDI_proceedFromC(Conn,fp);

	ch = getc(fp);
	if( ch != EOF ){
		CStr(buff,1);
		buff[0] = ch;
		DDI_pushCbuf(Conn,buff,1);
	}
	return ch;
}
char *DDI_fgetsFromC(Connection *Conn,PVStr(req),int size,FILE *fp)
{	const char *rcode;
	int len;
	CStr(buff,PEEKSIZE+1);
	int cc;

	if( size <= 0 ){
		sv1log("#### Negative size for DDI_fgetsFromC(%x,%d)\n",
			req,size);
		AbortLog();
		abort();
	}

	rcode = DDI_fgetsFromCbuf(Conn,AVStr(req),size,fp);
	if( rcode != NULL ){
		if( strchr(req,'\n') != NULL )
			return (char*)rcode;
		else{
			len = strlen(req);
			return DDI_fgetsFromC(Conn,QVStr(req+len,req),size-len,fp);
		}
	}

	cc = 0;
	if( ready_cc(fp) <= 0 )
	if( PEEK_CLIENT_REQUEST ){
		DDI_proceedFromC(Conn,fp);
		buff[0] = 0; /* a charm against Solaris2.X CC -O bug? */
		cc = recvPeekTIMEOUT(fileno(fp),AVStr(buff),sizeof(buff)-1);

		if( 0 < cc ){
			FromCread = cc;
			Verbose("++ peek %d Bytes of request.\n",cc);
		}
	}
/*
else
 if( 0 < PollIn(fileno(fp),2000) ){
	setNonblockingIO(fileno(fp),1);
	cc = readTIMEOUT(fileno(fp),buff,sizeof(buff)-1);
	setNonblockingIO(fileno(fp),0);
 }
*/
/* switching NonBlocking seems halmful... e.g. http://www.opentext.com */

	if( 0 < cc ){
		buff[cc] = 0;
		DDI_pushCbuf(Conn,buff,cc);
		return DDI_fgetsFromC(Conn,AVStr(req),size,fp);
	}

	rcode = fgetsTIMEOUT(AVStr(req),size,fp);
	if( rcode == NULL )
		return NULL;
	else	return (char*)rcode;
}

const char *CCV_TOCL = "tocl";
const char *CCV_TOSV = "tosv";
extern int CodeConv_x;
void CCV_clear(){ CodeConv_x = 0; }

void getGlobalCCX(CCXP ccx,int siz);
void reset_filters();
void ConnInit(Connection *Conn)
{
	if( Conn->xf_mounted )
		reset_filters();
	bzero((char*)Conn,sizeof(Connection));
	ClientSock = -1;
	ToS = ToSX = FromS = FromSX = -1;
	ToC = -1;
	RPORTsock = -1;
	getGlobalCCX(CCX_TOCL,CCX_SIZE);

	if( strcmp(iSERVER_PROTO,"tunnel1") == 0 )
		Conn->from_myself = 1;
}


void clear_DGreq(Connection *Conn);
void clear_DGheader(Connection *Conn);
void clear_DGinputs(Connection *Conn);

void ConnCopy(Connection *Conn,Connection *OrigConn)
{
	*Conn = *OrigConn;
	FromCbuff = NULL;
	headerX = 0;
	inputsX = 0;
	/*
	UTfree(&D_REQUESTtag);
	*/
if( D_REQUESTtag.ut_addr )
sv1log("#### ConnCopy: clearing D_REQUEST<%d> %d %X\n",
D_REQUESTtag.ut_strg,D_REQUESTtag.ut_size,D_REQUESTtag.ut_addr);
	UTclear(&D_REQUESTtag);
	LockedByClient = 0;
	clear_DGreq(Conn);
}

/*
 *	environment per client's connection
 */
void clear_DGconn(Connection *Conn)
{
	CLIF_HOSTPORT[0] = 0;
	CLIF_HOST[0]   = 0;
	CLIF_PORT      = 0;

	D_SERVER[0]    = 0;
	D_SELECTOR[0]  = 0;
	D_USER[0]      = 0;
	D_FROM[0]      = 0;
	D_PATH[0]      = 0;

	clear_DGreq(Conn);
}
/*
 *	environment per request
 */
void clear_DGreq(Connection *Conn)
{
	DDI_clearCbuf(Conn);
	if( headerX ) clear_DGheader(Conn);
	if( inputsX ) clear_DGinputs(Conn);
	InCharset[0] = 0;
	CCV_clear();
	reset_MOUNTconds();
	if( Conn->xf_mounted ){
		Conn->xf_mounted = 0;
		reset_filters();
	}
	Conn->sv_certauth.i_user[0] = 0;
	MO_Authorizer[0] = 0;
	GEN_VHOST[0]   = 0;

	MODIFIERS[0]   = 0;
	D_GTYPE[0]     = 0;
	D_HOPS         = 0;
	IAM_GATEWAY    = 0;

	DO_DELEGATE    = 0;
	IsMounted      = 0;
	IsVhost        = 0;

	ServerFlags    = 0;
	Conn->statcode = 0;
	ProxyControls[0] = 0;
	Conn->dg_putpart[0] = 0;
	ClientSession[0] = 0;
	Conn->xf_reqrecv = 0;

	Conn->cl.p_range[0] = 0;
	Conn->cl.p_range[1] = 0;
	Conn->sv.p_range[0] = 0;
	Conn->sv.p_range[1] = 0;
	Conn->sv.p_range[2] = 0;
	Conn->sv.p_range[3] = 0;
	Conn->sv_retry = 0;
}
void clear_DGclnt(Connection *Conn)
{
	ClientSock = -1;
	clear_DGreq(Conn);
}
/*
 *	constant through keep-alive
 */
void restoreConn(Connection *dst,Connection *src)
{
	dst->sv_dflt        = src->sv_dflt;
	dst->sv             = src->sv;

	dst->cl.p_wantKeepAlive = src->cl.p_wantKeepAlive;
	dst->cl.p_willKeepAlive = src->cl.p_willKeepAlive;
	dst->cl.p_whyclosed[0] = '-';
	dst->cl_nocache     = src->cl_nocache;
	dst->cl_reqbuf      = NULL;
	dst->cl_setccx      = 0;

	dst->ca_dontread    = src->ca_dontread;
	dst->ca_dontwrite   = src->ca_dontwrite;
	dst->ca_curoff      = 0;
	dst->ca_mtime       = 0;

	dst->co_setup       = 0;
	dst->co_nonet       = src->co_nonet;
	dst->co_nointernal  = src->co_nointernal;
	dst->fi_builtin     = 0;

	if( dst->xf_filters ){
		int pid;
		while( 0 < (pid = NoHangWait()) ){
			sv1log("CFI process [%d] done\n",pid);
		}
	}
	dst->xf_filters     = src->xf_filters;
	dst->xf_filtersCFI  = 0;
	dst->xf_clprocs     = 0;

	/* these lines could be unnecessary since sv.* would be reset as a whole ... */
	dst->sv.p_viaCc     = 0;
	dst->sv.p_viaSocks  = 0;
	dst->sv.p_viaVSAP   = 0;
	dst->sv.p_connType  = 0;

	dst->oc_proxy[0]    = 0;
	dst->oc_norewrite   = src->oc_norewrite; /* DONT_REWRITE */
	dst->co_internal    = 0;
	dst->mo_options     = 0;
	dst->mo_flags       = 0;

	dst->cl_noauth      = 0;
	dst->cl_auth.i_user[0] = 0;
	dst->no_dstcheck_proto = 0;
	dst->from_myself    = 0;
	dst->from_client    = 0;

	if( strcmp(iSERVER_PROTO,"tunnel1") == 0 )
		dst->from_myself = 1;

	/*
	CCXclear(dst->cl.p_ccxbuf);
	*/
	bcopy(src->cl.p_ccxbuf,dst->cl.p_ccxbuf,sizeof(dst->cl.p_ccxbuf));
	CCXclear((CCXP)dst->sv.p_ccxbuf);

	strcpy(dst->cl_baseurl,src->cl_baseurl);
	strcpy(dst->ma_SERVER,src->ma_SERVER); /* D_SERVER */
}

const char *add_DGheader(Connection *Conn,PCStr(head),PCStr(fmt),...)
{
	const char *cbuf;
	CStr(line,0x4000);
	MemFile MemF;
	VARGS(8,fmt);

#define PrintBuf(buf) { \
	sprintf(line,fmt,VA8); \
	FStrncpy(buf,line); \
	cbuf = buf; \
 }
	if( head == D_SERVER ){ PrintBuf(D_SERVER); }else
	if( head == D_FROM   ){ PrintBuf(D_FROM  ); }else
	if( head == D_USER   ){ PrintBuf(D_USER  ); }else
	if( head == D_PATH   ){ PrintBuf(D_PATH  ); }else
	if( head == D_EXPIRE ){ PrintBuf(D_EXPIRE); }else
	{
		str_sopen(&MemF,"add_DGheader",line,sizeof(line),0,"w");
		str_sprintf(&MemF,"%s ",head);
		str_sprintf(&MemF,fmt,VA8);
		str_sprintf(&MemF,"\r\n");
		cbuf = stralloc(line);

		if( headerX == DG_MAXHEAD-1 ){
			int i;
			for( i = 0; i < headerX; i++ )
			sv1log("#### generalist header overflow? %s",headerB[i]);
			sv1log("#### generalist header overflow? %s",cbuf);
		}
		if( headerX < DG_MAXHEAD )
			headerB[headerX++] = (char*)cbuf;
		else	sv1log("#### generalist header overflow: %s",cbuf);
	}
	return cbuf;
}
void clear_DGheader(Connection *Conn)
{	int hi;

	if( headerX ){
		for( hi = 0; hi < headerX; hi++ ){
			free((char*)headerB[hi]);
			headerB[hi] = 0;
		}
		headerX = 0;
	}
}
void clear_DGinputs(Connection *Conn)
{	int hi;

	if( inputsX ){
		for( hi = 0; hi < inputsX; hi++ )
		{
			free((char*)inputsB[hi]);
			inputsB[hi] = 0;
		}
		inputsX = 0;
	}
}

char *fgets_DGclient(Connection *Conn,PVStr(str),int size,FILE *fp)
{	const char *rcode;

	if( rcode = fgets(str,size,fp) )
		inputsB[inputsX++] = stralloc(str);
	return (char*)rcode;
}
void add_DGinputs(Connection *Conn,PCStr(fmt),...)
{	CStr(line,4096);
	MemFile MemF;
	VARGS(7,fmt);

	str_sopen(&MemF,"add_DGinputs",line,sizeof(line),0,"w");
	str_sprintf(&MemF,fmt,va[0],va[1],va[2],va[3],va[4],va[5],va[6]);
	Verbose("**** add_input: %s",line);
	inputsB[inputsX++] = stralloc(line);
}


/*
 *	Transfer the local SPECIALIST's environment to the remote GENERALIST
 *	to act as a SPECIALIST for the local one.
 */
void add_localheader(Connection *Conn,int proxy)
{	CStr(codeconv,128);

	if( proxy )
		add_DGheader(Conn,"LOCAL-PROXY","%d",1);

	if( !proxy ){
		CStr(myhp,1024);

		ClientIF_HP(Conn,AVStr(myhp));
		add_DGheader(Conn,"LOCAL-DELEGATE","%s",myhp);
	}
	if( DELEGATE_FLAGS[0] )
		add_DGheader(Conn,"LOCAL-FLAGS",   "%s",DELEGATE_FLAGS);

	/* why is this necessary? Gopher-Specialist DeleGate? */
	if( CTX_cur_codeconvCL(Conn,AVStr(codeconv)) )
		add_DGheader(Conn,"LOCAL-CHARCODE", "%s",codeconv);
}
void del_DGlocalheader(Connection *Conn)
{
	clear_DGheader(Conn);
}
void CTX_set_clientgtype(Connection *Conn,int gtype)
{
	D_GTYPE[0] = gtype;
}
int CTX_get_clientgtype(Connection *Conn)
{
	return D_GTYPE[0];
}

void setProtoOfClient(Connection *Conn,PCStr(proto))
{
	strcpy(CLIENTS_PROTO,proto);
}
void setProxyOfClient(Connection *Conn,int proxy_client,PCStr(url))
{
	if( proxy_client ){
		scan_URI_scheme(url,AVStr(CLIENTS_PROTO),sizeof(CLIENTS_PROTO));
		strcpy(CLIENTS_PROXY,MY_HOSTPORT());
	}else{
		ClientIF_HP(Conn,AVStr(CLIENTS_PROXY));
	}
}
const char *isSetProxyOfClient(Connection *Conn,PVStr(cl_proto))
{
	if( CLIENTS_PROXY[0] ){
		strcpy(cl_proto,CLIENTS_PROTO);
		return CLIENTS_PROXY;
	}else	return 0;
}

void DG_relayInput(Connection *Conn,int fd);
void initConnected(Connection *Conn,int svsock,int relay_input)
{
	if( relay_input ){
		DG_relayInput(Conn,svsock);
	}
	set_keepalive(svsock,1);
	FromS = ToS = svsock;
}

int OpenServer(PCStr(what),PCStr(proto),PCStr(host),int port)
{	const char *server;
	int svsock;

	if( server = strchr(host,'@') )
		server = server + 1;
	else	server = host;
	svsock = client_open("ConnectToServer",proto,server,port);
	/*
	sv1log("connected to %s://%s:%d\n",DFLT_PROTO,server,DFLT_PORT);
	*/
	return svsock;
}

extern int CONNERR_CANTRESOLV;
extern int CONNERR_TIMEOUT;
extern int CONNERR_REFUSED;
extern int CONNERR_UNREACH;

int ConnectToServer(Connection *Conn,int relay_input)
{	int svsock;

	CONNERR_CANTRESOLV = 0;
	CONNERR_TIMEOUT = 0;
	CONNERR_REFUSED = 0;
	CONNERR_UNREACH = 0;

	/* log for debug when REAL differs from DFLT ... */
	if( strcmp(DFLT_PROTO,REAL_PROTO)
	 || DFLT_PORT != REAL_PORT
	 || hostcmp(DFLT_HOST,REAL_HOST) != 0 )
	sv1log("ConnectToServer: DFLT=%s://%s:%d REAL=%s://%s:%d\n",
		DFLT_PROTO,DFLT_HOST,DFLT_PORT, REAL_PROTO,REAL_HOST,REAL_PORT);

	svsock = OpenServer("ConnectToServer",DST_PROTO,DST_HOST,DST_PORT);

	if( 0 <= svsock ){
		initConnected(Conn,svsock,relay_input);
		return svsock;
	}

	if( CONNERR_CANTRESOLV ) ConnError |= CO_CANTRESOLV;
	if( CONNERR_TIMEOUT    ) ConnError |= CO_TIMEOUT;
	if( CONNERR_REFUSED    ) ConnError |= CO_REFUSED;
	if( CONNERR_UNREACH    ) ConnError |= CO_UNREACH;
	return -1;
}
void DG_relayInput(Connection *Conn,int fd)
{	int hi;

	if( inputsX ){
		for( hi = 0; hi < inputsX; hi++ )
			write(fd,inputsB[hi],strlen(inputsB[hi]));
	}
}

const char *CTX_add_PATH(Connection *Conn,PCStr(me),PCStr(hostport),PCStr(teleport))
{	CStr(path,4096);
	refQStr(pp,path); /**/

	strcpy(path,me);
	pp = path+strlen(path);

	if( D_PATH[0] == 0 ){
		setVStrPtrInc(pp,'!');
		strcpy(pp,hostport);
		pp += strlen(pp);
	}

	if( teleport[0] ){
		setVStrPtrInc(pp,'[');
		strcpy(pp,teleport);
		pp += strlen(pp);
		setVStrPtrInc(pp,']');
	}

	setVStrPtrInc(pp,'!');
	if( D_PATH[0] ) /* D_PATH given from client DeleGate */
		strcpy(pp,D_PATH);
	else	sprintf(pp,"%s;%d",D_USER,time(0));

	strcpy(D_PATH,path);
	return D_PATH;
}
const char *CTX_get_PATH(Connection *Conn)
{
	return D_PATH;
}

static scanListFunc findPath1(PCStr(path1),PCStr(hostport))
{
	if( strcmp(path1,hostport) == 0 )
		return 1;
	return 0;
}
int CTX_findInPath(Connection *Conn,PCStr(host),int port)
{	const char *path;
	CStr(hostport,256);

	path = CTX_get_PATH(Conn);
	sprintf(hostport,"%s:%d",host,port);
	return scan_List(path,'!',0,scanListCall findPath1,hostport);
}

static scanListFunc match1(PCStr(path1),PCStr(user),int hlid)
{	CStr(host,1024);
	int port;

	if( Xsscanf(path1,"%[^:]:%d",AVStr(host),&port) == 2 )
	if( matchPath1(hlid,user,host,port) )
		return 1;
	return 0;
}
int CTX_matchPATH1(Connection *Conn,int hlid,PCStr(path),PCStr(user))
{
	if( path == NULL )
		path = D_PATH;
	return scan_List(path,'!',0,scanListCall match1,user,hlid);
}
static scanListFunc matchs(PCStr(path1),int hlid)
{	CStr(host,1024);
	int port;

	if( Xsscanf(path1,"%[^:]:%d",AVStr(host),&port) == 2 )
	if( matchPath1(hlid,"-",host,port) == 0 )
		return 1;
	return 0;
}
int CTX_matchPATHs(Connection *Conn,int hlid,PCStr(path))
{
	if( path == NULL )
		path = D_PATH;
	return scan_List(path,'!',0,scanListCall matchs,hlid) == 0;
}

void setFROM(Connection *Conn,PCStr(username),PCStr(hostaddr),int port)
{
	sprintf(D_FROM,"%s@[%s] (port=%d; DeleGate%s)",
		username,hostaddr,port,DELEGATE_ver());
}
int getFROM(Connection *Conn,PVStr(username),PVStr(hostaddr),PVStr(ver))
{	int port;

	setVStrEnd(hostaddr,0);
	setVStrEnd(username,0);
	Xsscanf(D_FROM,"%[^@]@[%[^]]] (port=%d; DeleGate%s)",AVStr(username),AVStr(hostaddr),&port,AVStr(ver));
	return port;
}

int matchAUTH(Connection *Conn,int hlid)
{
	if( ClientAuthUser[0] )
	if( matchPath1(hlid,ClientAuthUser,ClientAuthHost,ClientAuthPort) ){
		return 1;
	}
	return 0;
}
int matchFROM(Connection *Conn,int hlid)
{	CStr(user,256);
	CStr(host,256);
	CStr(ver,256);
	int port;

	if( port = getFROM(Conn,AVStr(user),AVStr(host),AVStr(ver)) )
		return matchPath1(hlid,user,host,port);
	return 0;
}

int CTX_VA_getOriginatorAddr(Connection *Conn,VAddr *Vaddr)
{	CStr(tmp,1024);
	CStr(ohost,256);
	const char *dp;
	int oport;

	strcpy(tmp,D_PATH);

	bzero(Vaddr,sizeof(VAddr));
	if( dp = strrchr(tmp,'!') ){
		truncVStr(dp);
		if( dp = strrchr(tmp,'!') ){
			if( Xsscanf(dp+1,"%[^:]:%d",AVStr(ohost),&oport) == 2 ){
				wordscanX(ohost,AVStr(Vaddr->a_name),sizeof(Vaddr->a_name));
				Vaddr->a_port = oport;
				return oport;
			}
		}
	}
	return 0;
}

void scan_header(Connection *Conn,int fromC,PCStr(name),PCStr(value))
{
	if( streq(name,"MEDIATOR") ){
		D_HOPS++;
		add_DGheader(Conn,name,"%s",value);
	}else
	if( streq(name,"FTPHOPS")){D_FTPHOPS = atoi(value); }else
	if( streq(name,"FROM")   ){add_DGheader(Conn,D_FROM,"%s",value); }else
	if( streq(name,"PATH")   ){add_DGheader(Conn,D_PATH,"%s",value); }else
	if( streq(name,"EXPIRE") ){add_DGheader(Conn,D_EXPIRE,"%s",value); }else
	if( streq(name,"LOCAL-GTYPE") ){
		sv1log("LOCAL-GTYPE: %s\n",value);
		CTX_set_clientgtype(Conn,*value);
	}else
	if( streq(name,"USER") ){
		CStr(user,256);
		wordScan(value,user);
		CLNT_USER = stralloc(user);
		add_DGheader(Conn,D_USER,"%s",user);
	}else
	if( streq(name,"CALLER") ){
		CStr(user,256);
		Xsscanf(value,"CALLER %s %s %d",AVStr(user),AVStr(CLNT_HOST),&CLNT_PORT);
		CLNT_USER = stralloc(user);
		add_DGheader(Conn,name,"%s",value);
	}else
	if( streq(name,"HOSTS") ){
		scan_HOSTS(Conn,value);
	}else
	{
		add_DGheader(Conn,name,"%s",value);
	}
}

/**/
void setREQUEST(Connection *Conn,PCStr(req))
{
	UTfree(&D_REQUESTtag);
	D_REQUESTtag = UTalloc(SB_CONN,strlen(req)+1,1);
	linescanX(req,AVStr(D_REQUESTtag.ut_addr),D_REQUESTtag.ut_size);
}


const char *CTX_clif_proto(Connection *Conn)
{
	return DFLT_PROTO[0] ? DFLT_PROTO : iSERVER_PROTO;
}
const char *CTX_clif_host(Connection *Conn)
{
	return CLIF_HOST;
}
int CTX_clif_port(Connection *Conn)
{
	return CLIF_PORT;
}
const char *CTX_clif_hostport(Connection *Conn)
{
	return CLIF_HOSTPORT;
}
const char *CTX_get_modifires(Connection *Conn)
{
	return MODIFIERS;
}
void CTX_set_modifires(Connection *Conn,PCStr(modifires))
{
	strcpy(MODIFIERS,modifires);
}
const char *CTX_get_baseurl(Connection *Conn)
{
	if( Conn->cl_baseurl[0] )
		return Conn->cl_baseurl;
	else	return 0;
}
int CTX_get_iserver(Connection *Conn,const char **proto,const char **host)
{
	*proto = iSERVER_PROTO;
	*host = iSERVER_HOST;
	return iSERVER_PORT;
}
void set_BASEURL(Connection *Conn,PCStr(url))
{	CStr(proto,128);
	CStr(site,128);
	CStr(path,1024);
	CStr(host,128);
	CStr(sport,128);
	CStr(hp,128);
	int port;

	strcpy(Conn->cl_baseurl,url);
	Verbose("BASEURL=%s\n",url);
	if( isFullURL(url) ){
		decomp_absurl(url,AVStr(proto),AVStr(site),AVStr(path),sizeof(path));
		if( *site == '-' ){
			ovstrcpy(site,site+1);
			Conn->my_vbase.u_pri = 1;
		}
		decomp_URL_site(site,AVStr(host),AVStr(sport));
		if( *sport )
			port = atoi(sport);
		else	port = serviceport(proto);

		Conn->my_vbase.u_proto = stralloc(proto);
		Conn->my_vbase.u_host = stralloc(host);
		Conn->my_vbase.u_port = port;
		Conn->my_vbase.u_path = stralloc(path);
		HostPort(AVStr(hp),proto,host,port);
		Conn->my_vbase.u_hostport = stralloc(hp);

		sv1log("BASEURL= %s :// %s : %d %s\n",
			Conn->my_vbase.u_proto,Conn->my_vbase.u_host,
			Conn->my_vbase.u_port,Conn->my_vbase.u_path);
	}
}
void scan_BASEURL(Connection *Conn,PCStr(url))
{
	xmem_push(Conn->cl_baseurl,strlen(Conn->cl_baseurl)+1,"BASEURLs",NULL);
	if( isFullURL(url) )
	xmem_push(&Conn->my_vbase,sizeof(Conn->my_vbase),"BASEURLx",NULL);
	set_BASEURL(Conn,url);
}

int strNetaddr(PCStr(host),PVStr(net));
int substCGIENV(Connection *Conn,PCStr(name),PVStr(out),int size);

char *strfConnX(Connection *Conn,PCStr(fmt),PVStr(str),int size)
{	const char *fp;
	CStr(tmp,1024);
	CStr(outb,1024);
	const char *outp;
	const char *dp;
	CStr(xfmt,1024);
	int rem,len;
	refQStr(sp,str); /**/

	setVStrEnd(str,0);
	rem = size - 1;

	if( strchr(fmt,'[') ){
		lineScan(fmt,xfmt);
		StrSubstDate(AVStr(xfmt));
		if( strcmp(fmt,xfmt) != 0 ){
			fmt = xfmt;
		}
	}
	for( fp = fmt; *fp; fp++ ){
		outp = 0;
		outb[0] = 0;
		outb[1] = 0;
		if( *fp == '\\' ){
			int ch = -1;
			switch( fp[1] ){
				case '\\': ch = '\\'; break;
				case 'r': ch = '\r'; break;
				case 'n': ch = '\n'; break;
				case 't': ch = '\t'; break;
				case 's': ch = ' '; break;
				case '0': ch = 0; break;
				case '$': ch = '$'; break;
				case '%': ch = '%'; break;
			}
			if( ch != -1 ){
				outb[0] = ch;
				fp++;
				goto xOUT;
			}
		}
		if( *fp != '%' ){
			outb[0] = *fp;
			goto xOUT;
		}
		if( fp[1] == '{' ){
			CStr(name,32);
			dp = wordscanY(fp+2,AVStr(name),sizeof(name),"^}");
			if( *dp == '}' ){
				fp = dp;
				if( !substCGIENV(Conn,name,AVStr(outb),sizeof(outb)) )
					syslog_ERROR("Undef %%{%s}\n",name);
				goto xOUT;
			}
		}
		if( *++fp == 0 )
			break;

		switch( *fp ){
		case '%':
			outb[0] = '%';
			break;

		case 'c':
			if( Conn->cl_cert[0] )
				outp = Conn->cl_cert;
			break;

		case 'C':
			if( Conn->sv_cert[0] )
				outp = Conn->sv_cert;
			break;

		case 'u':
			if( (outp = getClientUserC(Conn)) == 0 )
				outp = "-";
			break;

		case 'h':
			if( CLNT_HOST[0] )
				strcpy(outb,CLNT_HOST);
			else{
				getClientHostPort(Conn,AVStr(outb));
				if( *outb == 0 )
					outb[0] = '-';
			}
			if( TeleportHost[0] ){
				if( isinetAddr(TeleportHost) )
					addr2dom(TeleportHost,AVStr(tmp),sizeof(tmp));
				else	lineScan(TeleportHost,tmp);
				Xsprintf(TVStr(outb),".-.%s",tmp);
			}
			break;

		case 'p':
			sprintf(outb,"%d",getClientHostPort(Conn,AVStr(tmp)));
			break;

		case 'i':
			gethostNAME(ClientSock,AVStr(outb));
			break;

		case 'I':
			HTTP_ClientIF_HP(Conn,AVStr(outb));
			break;

		case 'd':
			getClientHostPort(Conn,AVStr(tmp));
			if( dp = strrchr(tmp,'.') )
				outp = dp+1;
			else	outp = tmp;
			break;

		case 'a':
			if( TeleportAddr[0] )
				sprintf(outb,"%s.-.",TeleportAddr);
			getClientHostPortAddr(Conn,VStrNULL,TVStr(outb));
			break;

		case 'n':
			getClientHostPortAddr(Conn,VStrNULL,AVStr(tmp));
			strNetaddr(tmp,AVStr(outb));
			break;

		case 'A':
			if( 0 <= find_CMAP(Conn,"authgen",AVStr(tmp)) ){
				strfConnX(Conn,tmp,AVStr(outb),sizeof(outb));
				if( strchr(tmp,':') == 0 )
					strcat(tmp,":");
			}
			break;

		case 'H':
			gethostname(outb,sizeof(outb));
			break;

		case 'M':
			outp = DELEGATE_ADMIN;
			break;

		case 'O':
			getUsername(getuid(),AVStr(outb));
			break;

		case 'F':
		case 'L':
		case 'D':
			if( HTTP_getRequestField(Conn,"From",AVStr(tmp),sizeof(tmp)) ){
				switch( *fp ){
				case 'F': Xsscanf(tmp,"%s",AVStr(outb)); break;
				case 'L': Xsscanf(tmp,"%[^@]",AVStr(outb)); break;
				case 'D': Xsscanf(tmp,"%*[^@]@%s",AVStr(outb)); break;
				}
			}
			if( outb[0] == 0 )
				outp = "-";
			break;

		case 'U':
		case 'P':
			{
			  AuthInfo ident;
			  if( HTTP_getAuthorization(Conn,1,&ident,2)
			   || HTTP_getAuthorization(Conn,0,&ident,2)
			   || HTTP_getAuthorization(Conn,0,&ident,0)
			  ){
			    switch( *fp ){
			      case 'U': outp = ident.i_user; break;
			      case 'P':
				if( strcaseeq(ident.i_atyp,"Digest") ){
					const char *host;
					if( ClientAuth.i_stat == AUTH_SET )
						host = ClientAuth.i_Host;
					else	host = "";
					getDigestPass(host,ident.i_user,AVStr(outb));
				}else	outp = ident.i_pass;
				break;
			    }
			  }
			}
			if( outb[0] == 0 && outp == 0 )
				outp = "-";
			break;

		case 'Q':
		if( HTTP_getRequestField(Conn,"Forwarded",AVStr(tmp),sizeof(tmp)) )
			if( dp = strstr(tmp," for ") )
				Xsscanf(dp+5,"%s",AVStr(outb));
			if( outb[0] == 0 )
				outp = "-";
			break;
		}
xOUT:
		if( outb[0] )
			outp = outb;
		if( outp ){
			len = strlen(outp);
			if( rem < len )
				len = rem;
			if( 0 < len ){
				QStrncpy(sp,outp,len+1);
				rem -= len;
				sp += strlen(sp);
			}
		}
	}
	return (char*)str+strlen(str);
}
void genheadf(PCStr(fmt),PVStr(out),int siz)
{	Connection ConnBuf,*Conn = &ConnBuf;

	bzero(Conn,sizeof(Connection));
	strfConnX(Conn,fmt,AVStr(out),siz);
}

void make_conninfo(Connection *Conn,PVStr(conninfo))
{	CStr(buff,1024);
	const char *proto;
	refQStr(sp,conninfo); /**/

	if( CLNT_PROTO[0] )
		proto = CLNT_PROTO;
	else	proto = DFLT_PROTO;
	sp = Sprintf(AVStr(sp),"Client-Protocol: %s\n",proto);
	sp = Sprintf(AVStr(sp),"Server-Protocol: %s\n",REAL_PROTO);

	sp = strfConnX(Conn,"Client-User-Ident: %u\n",AVStr(sp),64);
	sp = strfConnX(Conn,"Client-Host: %h\n",AVStr(sp),64);
	sp = strfConnX(Conn,"Client-Addr: %a\n",AVStr(sp),64);
	sp = strfConnX(Conn,"Client-User-Auth: %U\n",AVStr(sp),64);

	sp = Sprintf(AVStr(sp),"Server-Host: %s\n",DST_HOST);

	ClientIF_HP(Conn,AVStr(buff));
	sprintf(sp,"Client-IF-Host: %s\n",AVStr(buff));
	sp += strlen(sp);

	if( MountOptions ){
	sp = Sprintf(AVStr(sp),"Client-URL-Base: %s\n",MountVbase(MountOptions));
	sp = Sprintf(AVStr(sp),"Server-URL-Base: %s\n",MountRpath(MountOptions));
	}
}

int reverseMOUNT(Connection *Conn,PVStr(url),int siz)
{	const char *opts;
	const char *proto;
	CStr(hp,256);
	const char *path;
	const char *search;
	const char *dgproto;
	CStr(dghp,256);
	CStr(xurl,1024);
	CStr(protob,64);
	CStr(pathb,256);
	CStr(uhead,256);

	if( Conn == NULL )
		return 0;

	if( isFullURL(url) ){
		decomp_absurl(url,AVStr(protob),AVStr(hp),AVStr(pathb),sizeof(pathb));
		proto = protob;
		path = pathb;
		search = NULL;
	}else
	if( url[0] == '/' ){
		proto = DST_PROTO;
		sprintf(hp,"%s:%d",DST_HOST,DST_PORT);
		path = url + 1;
		search = NULL;
	}else{
		return 0;
	}

	dgproto = CLNT_PROTO;
	HTTP_ClientIF_HP(Conn,AVStr(dghp));
	opts = CTX_mount_url_fromL(Conn,AVStr(xurl),proto,hp,path,search,dgproto,dghp);

	if( opts ){
		sprintf(uhead,"%s://%s/",dgproto,dghp);
		if( strneq(xurl,uhead,strlen(uhead)) ) /* if partialize enabled */
			linescanX(xurl+strlen(uhead)-1,AVStr(url),siz);
		else	linescanX(xurl,AVStr(url),siz);
		Verbose("reverseMOUNT %s://%s/%s -> %s\n",proto,hp,path,url);
	}
	return opts != NULL;
}

/*
 * in current implementation, only FTOCL is supported to be
 * "mount-point-local" or "request-local" filter
 */
static int mount_filters(Connection *Conn,PCStr(opt))
{
	if( strncasecmp(opt,"FTOCL=",6) == 0 )
			/*
			scan_FTOCL(opt+6);
			*/
			scan_FTOCL(Conn,opt+6);
	else
	if( strncasecmp(opt,"FTOSV=",6) == 0 )
			/*
			scan_FTOSV(opt+6);
			*/
			scan_FTOSV(Conn,opt+6);
	else
	if( strncasecmp(opt,"FSV=",4) == 0 )
			/*
			scan_FSV(opt+4);
			*/
			scan_FSV(Conn,opt+4);
	else
	return 0;

	Conn->xf_mounted++;
	sv1log("#### MountOption %s\n",opt);
	return 1;
}

void setpathExt(PCStr(ext));
static scanListFunc opt1(PCStr(opt),Connection *Conn)
{	int leng;

	if( strncasecmp(opt,"CHARCODE=",9) == 0 ){
		if( Conn->cl_setccx && CCXactive(CCX_TOCL) ){
			/* CCX is set by client */
		}else{
			leng = CCXcreate("*",opt+9,CCX_TOCL);
			sv1log("#### MountOption CHARCODE=%s [%d]\n",opt+9,leng);
		}
	}else
	if( strncasecmp(opt,"FTOSV=-cc-",10) == 0 ){
		if( CCXactive(CCX_TOSV) == 0 ){
			leng = CCXcreate("*",opt+10,CCX_TOSV);
			sv1log("#### MountOption FTOSV=%s [%d]\n",opt+10,leng);
		}
	}else
	if( mount_filters(Conn,opt) ){
	}else
	if( strcasecmp(opt,"AUTH=none") == 0 ){
		NoAuth = 1;
		sv1log("#### NoAuth\n");
	}else
	if( strcasecmp(opt,"public") == 0 ){
		Conn->from_myself = 1;
	}else
/*
	if( strcasecmp(opt,"rident") == 0 ){
*/
	if( strcasecmp(opt,"rident") == 0
	 || strcasecmp(opt,"rident=server") == 0 ){
		ServerFlags |= PF_RIDENT;
	}else
	if( strcasecmp(opt,"rident:no") == 0 ){
		ServerFlags |= PF_RIDENT_OFF;
	}else
	if( strncasecmp(opt,"MASTER=",7) == 0 ){
		MO_MasterPort = scan_hostport("http",opt+7,AVStr(MO_MasterHost));
	} else
	if( strncasecmp(opt,"PROXY=",6) == 0 ){
		MO_ProxyPort = scan_hostport("http",opt+6,AVStr(MO_ProxyHost));
	}
	else
	if( strncasecmp(opt,"GENVHOST=",9) == 0 )
		strcpy(GEN_VHOST,opt+9);
	else
	if( strncasecmp(opt,"CACHE=NO",8) == 0 )
		DontUseCache = DontReadCache = DontWriteCache = 1;
	else
	if( strncasecmp(opt,"EXPIRE=",7) == 0 ){
		strcpy(D_EXPIRE,opt+7);
	}
	else
	if( strncasecmp(opt,"BASEURL=",8) == 0 ){
		strcpy(Conn->cl_baseurl,opt+8);
	}
	else
	if( strncasecmp(opt,"HTTPCONF=",9) == 0 ){
		extern int BREAK_STICKY;
		BREAK_STICKY = 1;
		scan_HTTPCONF(Conn,opt+9);
	}
	else
	if( strncasecmp(opt,"pathext=",8) == 0 ){
		setpathExt(opt+8);
	}
	return 0;
}
void eval_mountOptions(Connection *Conn,PCStr(opts))
{
	scan_commaList(opts,0,scanListCall opt1,Conn);
}
/* TODO...
 * evaluated mountOptions must be reset on the change of MOUNT point... 
 */

static Port *servPorts;
#define curServ	servPorts[0]
void minit_curServ()
{
	if( servPorts == 0 )
		servPorts = NewStruct(Port);
}

int DontKeepAliveServ(Connection *Conn,PCStr(what))
{
	if( RIDENT_SENT ){
		sv1log("#### RIDENT was sent, disable %s\n",what);
		return 1;
	}
	return 0;
}

int putServ(Connection *Conn,int tsfd,int fsfd)
{
	minit_curServ();

	if( DontKeepAliveServ(Conn,"HTTP putServ()") )
		return 0;

	if( ServKeepAlive )
	if( IsConnected(fsfd,NULL) )
	if( IsConnected(tsfd,NULL) )
	/*
	if( 0 < PollIn(fsfd,1) ){
	reduce delay by polling when doing Keep-Alive with the client
	*/
	if( !WillKeepAlive && 0 < PollIn(fsfd,1) ){
		sv1log("#HT11 putServ EOF or pending data from the server\n");
	}else
	{
		curServ = Conn->sv;
		strcpy(curServ.p_host,DST_HOST);
		curServ.p_port = DST_PORT;
		curServ.p_wfd = tsfd;
		curServ.p_rfd = fsfd;
		curServ.p_viaProxy = toProxy;
		curServ.p_viaMaster = toMaster;
		strcpy(curServ.p_viaMasterVer,MediatorVer);
		/*
		curServ.p_connTime = Time();
		*/
		if( curServ.p_connTime == 0 )
			curServ.p_connTime = CONN_DONE;
		curServ.p_saveTime = Time();
		curServ.p_connType = ConnType;
sv1log("#HT11 putServ(%d/%d) %s:%d\n",
curServ.p_wfd,curServ.p_rfd,curServ.p_host,curServ.p_port);
		return 1;
	}
	return 0;
}
void delServ(Connection *Conn,int tsfd,int fsfd)
{
	minit_curServ();

sv1log("##HT11 delServ(%d/%d): %s:%d (%d/%d)\n",
		tsfd,fsfd,
		curServ.p_host,curServ.p_port,curServ.p_wfd,curServ.p_rfd);

	curServ.p_host[0] = 0;
	if( tsfd == curServ.p_wfd )
		curServ.p_wfd = -1;
	if( fsfd == curServ.p_rfd )
		curServ.p_rfd = -1;
}
int getServ(Connection *Conn)
{	double age;
	double Now,idle;

	minit_curServ();

	if( curServ.p_host[0] == 0 )
		return 0;

	/*
	age = Time() - curServ.p_connTime;
	*/
	Now = Time();
	age = Now - curServ.p_connTime;
	idle = Now - curServ.p_saveTime;

	/*
	if( IsAlive(curServ.p_rfd)
	*/
	if( idle <= 3 || IsAlive(curServ.p_rfd)
	/* and service_permitted() */
	/* and (client dependent) filter is the common one ... */
	){
/*
		if( hostcmp(curServ.p_host,DST_HOST) == 0
7.4.1 can be bad when ther server is IIS with virtual-hosting
*/
		if( strcaseeq(curServ.p_host,DST_HOST)
		 && curServ.p_port == DST_PORT ){
			/*
			if( 0 < PollIn(curServ.p_rfd,1) ){
			*/
			if( 3 < idle && 0 < PollIn(curServ.p_rfd,1) ){
				sv1log("#HT11 getServ EOF or pending data from the server\n");
			}else{
			ServReqSerno = curServ.p_reqserno;
			incServReqSerno(Conn);

/*
daemonlog("E","#HT11 getServ %4.1fs*%d SERVER REUSE (%d/%d) [%s:%d] %s\n",
age,ServReqSerno,curServ.p_wfd,curServ.p_rfd,
*/
daemonlog("E","#HT11 getServ %5.2fs*%d SERVER REUSE (%d/%d) [%s:%d] %s\n",
age,curServ.p_reqserno+1,curServ.p_wfd,curServ.p_rfd,
curServ.p_host,curServ.p_port,DST_HOST);

			toProxy = curServ.p_viaProxy;
			toMaster = curServ.p_viaMaster;
			strcpy(MediatorVer,curServ.p_viaMasterVer);
			FromS = curServ.p_rfd;
			ToS = curServ.p_wfd;
			ToSX = curServ.p_wfdx;
			ToSF = curServ.p_wfdf;
			ServConnTime = Time();
			ConnDelay = 0;
			ConnType = curServ.p_connType;
			}

		}else{
daemonlog("E","#HT11 getServ %4.1fs*%d SERVER SWITCH[%s:%d]->[%s:%d]\n",
age,ServReqSerno,
curServ.p_host,curServ.p_port,DST_HOST,DST_PORT);
		}
	}else{
daemonlog("E","#HT11 getServ %4.1fs*%d SERVER TIMEOUT[%s:%d] %s:%d\n",
age,ServReqSerno,
curServ.p_host,curServ.p_port,DST_HOST,DST_PORT);
	}

	if( 0 <= FromS ){
		return ++curServ.p_reqserno;
	}else{
		curServ.p_host[0] = 0;
		close(curServ.p_wfd);
		close(curServ.p_rfd);

		if( 0 <= curServ.p_wfdx ){ /* ToSX */
			close(curServ.p_wfdx);
			if( 0 <= curServ.p_wfdf ) /* ToSF */
				close(curServ.p_wfdf);
			NoHangWait();
		}

		curServ.p_rfd = -1;
		curServ.p_wfd = -1;
		curServ.p_reqserno = 0;
		return 0;
	}
}
void setIsFunc(Connection *Conn,int fc)
{
	Conn->isFunc = fc;
}

