/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1995-1999 Yutaka Sato
Copyright (c) 1995-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	script.c (DeleGate Script)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
	"..."		... is literal
	'...'		... is literal
	\c		c is litelal
	#...		... is comment
	CASE case	included when in the case
	ESAC [case]	end the case
	+=URL[#case-list]
History:
	950615	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include "ystring.h"
#include "dglib.h"
#include "file.h"
#include "log.h"

FILE* fopenLIB(PCStr(file),PCStr(mode),PVStr(xpath));
const char *scan_arg1(PCStr(ext_base),PCStr(arg));

#define SELF	"_SELF_"
int SCRIPT_ASIS;

#define RELATIVEx "+"

typedef struct {
  const	char	*sf_furl;
  const	char	*sf_aurl;
	FILE	*sf_sfp;
	int	 sf_off;
} ScriptFile;
typedef struct {
  const	char *se_pathv[32]; /**/
	int   se_pathx;
   ScriptFile se_scripts[32]; /**/
	char  se_scriptx;
} ScriptEnv;
static ScriptEnv *scriptEnv;
#define pathv		scriptEnv->se_pathv
#define pathx		scriptEnv->se_pathx
#define scripts		scriptEnv->se_scripts
#define scriptx		scriptEnv->se_scriptx
void minit_script()
{
	if( scriptEnv == 0 )
		scriptEnv = NewStruct(ScriptEnv);
}

static scanListFunc inspath(PCStr(path1))
{
	if( elnumof(pathv) <= pathx ){
		return -1;
	}
	pathv[pathx++] = (char*)path1;
	return 0;
}
void scan_DGPATH(PCStr(path))
{	CStr(home,1024);
	CStr(xpath,2048);

	getHOME(getuid(),AVStr(home));
	strcpy(xpath,path);
	strsubst(AVStr(xpath),"${HOME}",home);
	DELEGATE_substfile(AVStr(xpath),"",VStrNULL,VStrNULL,VStrNULL);
	scan_List(xpath,':',1,scanListCall inspath);
}

static void eval_line(PCStr(file),PCStr(base),PCStr(line),PVStr(xline))
{	char ch;
	const char *sp;
	const char *dp;
	refQStr(command,xline); /**/
	FILE *fp;
	char lit = 0;
	refQStr(xp,xline); /**/
	const char *fix = xline;

	for( sp = line; ch = *sp; sp++ )
		if( ch != ' ' && ch != '\t' && ch != '\r' )
			break;

	while( ch = *sp ){
		assertVStr(xline,xp+1);
		if( ch == '\\' && sp[1] != 0  && lit == 0 ){
			setVStrPtrInc(xp,sp[1]);
			fix = xp;
			sp += 2;
		}else
		if( (ch == '"' || ch == '\'') && lit == 0 ){
			lit = ch;
			sp++;
		}else
		if( (ch == '"' || ch == '\'') && lit == ch ){
			lit = 0;
			sp++;
			fix = xp;
		}else
		if( ch == '`' && lit == 0 ){
			lit = ch;
			sp++;
			command = xp;
		}else
		if( ch == '`' && lit == ch ){
			lit = 0;
			sp++;
			setVStrEnd(xp,0);

			if( fp = popen(command,"r") ){
				fgets(command,256,fp);
				pclose(fp);
				if( dp = strpbrk(command,"\r\n") )
					truncVStr(dp);
				xp = command+strlen(command);
				fix = xp;
			}
		}else
		if( ch == '#' && lit == 0 ){
			break;
		}else{
			setVStrPtrInc(xp,*sp++);
			if( ch != ' ' && ch != '\t' && ch != '\r' )
				fix = xp;
		}
	}
	truncVStr(fix);
	if( lit != 0 )
		fprintf(stderr,"%s: unmatched (%c): %s\n",file,lit,line);
}

static scanListFunc case_match(PCStr(ccase),PCStr(tcase))
{
	return strcmp(ccase,tcase) == 0;
}
static int in_case(PCStr(cases),PCStr(case1))
{	int match;

	match = scan_List(cases,'+',0,scanListCall case_match,case1);
	return match;
}
int (*evalarg_func)(const char*,const char*);
static void eval_script(FILE *sfp,PCStr(name),PCStr(base),PCStr(url),PCStr(cases))
{	CStr(argb,0x4000);
	refQStr(argp,argb);
	refQStr(vp,argb); /**/
	CStr(valueb,4096);
	const char *dp;
	CStr(com,1024);
	ACStr(blocks,8,32);
	CStr(actives,8);
	CStr(block1,32);
	int blockx,bi;
	int nline;
	int active;

	if( name ){
		sprintf(argb,"%s",name);
		argp = argb + strlen(argb);
	}else	argp = argb;

	vp = (char*)argp;
	blockx = 0;

	active = !in_case(cases,SELF);

/*
if( active )
 fprintf(stderr,"%d %s\n",active,url);
*/

	for( nline = 1; fgets(valueb,sizeof(valueb),sfp) != NULL; nline++ ){
		if( lARGDUMP() )
			fprintf(stderr,"%s: %s",url,valueb);
		if( dp = strpbrk(valueb,"\r\n") )
			truncVStr(dp);

		if( SCRIPT_ASIS )
			strcpy(vp,valueb);
		else	eval_line(url,base,valueb,AVStr(vp));

		wordScan(vp,com);
		if( strcmp(com,"CASE") == 0 ){
			if( elnumof(actives) <= blockx ){
				break;
			}
			setVStrElem(actives,blockx,active); /**/
			Xsscanf(vp,"%*s %s",EVStr(blocks[blockx]));
			active = in_case(cases,blocks[blockx]);
			if( 0 < blockx )
				active &= actives[blockx];
			blockx++;
/*
if( active )
 fprintf(stderr,"%d [%d] %s\n",active,blockx,vp);
*/
		}else
		if( strcmp(com,"ESAC") == 0 ){
			block1[0] = 0;
			Xsscanf(vp,"%*s %s",AVStr(block1));
			if( block1[0] ){
			    for( bi = blockx - 1; 0 <= bi; bi-- ){
				if( strcmp(block1,blocks[bi]) == 0 ){
					blockx = bi;
					break;
				}
			    }
			    if( bi < 0 ){
				fprintf(stderr,"\"%s\":%d unmatched ESAC %s\n",
					url,nline,block1);
				break;
			    }
			}else	blockx--;
			active = actives[blockx];
/*
 fprintf(stderr,"%d [%d] %s\n",active,blockx,vp);
*/
		}else
		if( active ){
			if( *argp )
			{
				if( evalarg_func )
					(*evalarg_func)(url,argb);
				else
				scan_arg1(url,argb);
			}
		}
	}
}

FILE *openPurl(PCStr(base),PCStr(purl),PVStr(aurl))
{
	FILE *sfp,*psfp;
	int sfd;
	int ii;
	CStr(line,1024);

	if( purl[0] == 0 )
		strcpy(aurl,base);
	else
	if( base == NULL || purl[0] == '/' || isLoadableURL(purl) )
		strcpy(aurl,purl);
	else{
		strcpy(aurl,base);
		strcat(aurl,"/");
		strcat(aurl,purl);
	}
	StrSubstDate(AVStr(aurl));

	sfp = NULL;
	for( ii = 0; ii < scriptx; ii++ ){
	    if( strcmp(aurl,scripts[ii].sf_aurl) == 0 ){
		if( psfp = scripts[ii].sf_sfp ){
			sfd = dup(fileno(psfp));
			sfp = fdopen(sfd,"r");
			fseek(sfp,scripts[ii].sf_off,0);
		}
	    }
	}
	if( sfp == NULL ){
		if( isLoadableURL(aurl) ){
			sfp = TMPFILE("openPurl");
			URLget(aurl,1,sfp);
		}else	sfp = fopenLIB(aurl,"r",AVStr(aurl));
	}
	return sfp;
}
extern int ERROR_RESTART;
int SCRIPT_UNKNOWN;
int load_script(PCStr(name),PCStr(base),PCStr(purl))
{	FILE *sfp;
	const char *path1;
	CStr(purlb,1024);
	CStr(aurl,1024);
	CStr(furl,1024);
	const char *furl1;
	CStr(dir1,1024);
	CStr(cases,1024);
	const char *dp;
	int pi,ii,jj;

	if( strchr(purl,'?') ){
		strcpy(purlb,purl);
		purl = purlb;
		dp = strchr(purlb,'?');
		strcpy(cases,dp+1);
		truncVStr(dp);
	}else	cases[0] = 0;

	sfp = NULL;
	if( name == NULL && base == NULL && isFullpath(purl) ){
		sfp = fopen(purl,"r");
	}
	if( sfp == NULL )
	for( pi = 0; path1 = pathv[pi]; pi++ ){
		if( strcmp(path1,"+") == 0 ){
			if( base == NULL )
				continue;
			if( purl[0] == 0 )
				path1 = base;
			else
			if( strrchr(base,'/') ){
				strcpy(dir1,base);
				*strrchr(dir1,'/') = 0;
				path1 = dir1;
			}else	path1 = "";
		}
		if( (sfp = openPurl(path1,purl,AVStr(aurl))) != NULL )
			break;
	}
/*
	if( sfp == NULL ){
*/
	if( sfp == NULL || feof(sfp) ){
		SCRIPT_UNKNOWN++;
		fprintf(stderr,"Cannot open %s\n",aurl);
		return -1;
	}
	if( cases[0] )
		sprintf(furl,"%s#%s",aurl,cases);
	else	sprintf(furl,"%s",aurl);

	for( ii = 0; ii < scriptx; ii++ ){
		furl1 = scripts[ii].sf_furl;
		if( strcmp(furl1,furl) == 0 ){
			fprintf(stderr,
				"DeleGate ERROR: loop in script: %s -> %s\n",
				base,purl);
			for( jj = 0; jj < scriptx; jj++ )
				fprintf(stderr,"[%d] %s\n",jj,scripts[jj].sf_furl);
			fprintf(stderr,"[%d] %s\n",jj,furl);
			return -1;
		}
	}

	if( elnumof(scripts) <= scriptx ){
		fprintf(stderr,"ERROR: scripts nest too deep: %s -> %s\n",
			base,purl);
		return -1;
	}

	if( base != NULL && strcmp(aurl,base) == 0 ){
		if( cases[0] != 0 )
			strcat(cases,"+");
		strcat(cases,SELF);
	}
	scripts[scriptx].sf_aurl = aurl;
	scripts[scriptx].sf_furl = furl;
	scripts[scriptx].sf_sfp = sfp;
	scripts[scriptx].sf_off = ftell(sfp);

	scriptx++;
	eval_script(sfp,name,base,aurl,cases);
	scriptx--;

	fclose(sfp);
	return 0;
}
