/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	syslog.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	951029	created
//////////////////////////////////////////////////////////////////////#*/
#include <errno.h>
#include <stdio.h>
#include "ystring.h"
#include "dglib.h"
#include "yarg.h"

extern int SYSLOG_EMERG;
extern int SYSLOG_ALERT;
extern int SYSLOG_CRIT;
extern int SYSLOG_ERR;
extern int SYSLOG_WARNING;
extern int SYSLOG_NOTICE;
extern int SYSLOG_INFO;
extern int SYSLOG_DEBUG;
static int SYSLOG_DAEMON  = (3<<3);
extern int SYSLOG_PRIMASK;

void Syslog(int priority,PCStr(fmt),...)
{	int level;
	int se = errno;
	VARGS(14,fmt);

	level = priority & SYSLOG_PRIMASK;
	if( level <= SYSLOG_CRIT )
		sv1tlog(fmt,VA14);
	else
	if( level <= SYSLOG_INFO )
		sv1log(fmt,VA14);
	else	sv1vlog(fmt,VA14);
	errno = se;
}
int syslog_ERROR(PCStr(fmt),...)
{
	VARGS(14,fmt);
	Syslog(SYSLOG_ERR,fmt,VA14);
	return 0;
}
int syslog_DEBUG(PCStr(fmt),...)
{
	VARGS(14,fmt);
	Syslog(SYSLOG_DEBUG,fmt,VA14);
	return 0;
}

static void res_debug(PCStr(fmt),...)
{	CStr(msg,4096);
	VARGS(14,fmt);

	sprintf(msg,"{R} ");
	Xsprintf(TVStr(msg),fmt,VA14);
	sv1log("%s",msg);
}

extern iFUNCP RES_debugprinter;
iFUNCP DEBUG_printf = (iFUNCP)syslog_DEBUG;

void syslog_init(){
	RES_debugprinter = (iFUNCP)res_debug;
}


int service_syslog(DGC*ctx)
{
	return 0;
}

int LOG_syslog = -1;
int open_syslog(PCStr(url))
{	CStr(hostport,256);
	CStr(host,256);
	int port;
	CStr(msg,128);
	int wcc;

	if( Xsscanf(url,"syslog://%s",AVStr(hostport)) <= 0 )
	{	CStr(file,256);
		if( 0 < Xsscanf(url,"syslog:%s",AVStr(file)) ){
			LOG_syslog = UDP_client_open("syslog","syslog",file,0);
			if( 0 <= LOG_syslog )
				goto logstart;
			return LOG_syslog;
		}
		return -1;
	}

	port = scan_hostport("syslog",hostport,AVStr(host));
	LOG_syslog = UDP_client_open("syslog","syslog",host,port);

logstart:
	sprintf(msg,"<%d>DeleGate[%d] server started",
		SYSLOG_DAEMON|SYSLOG_NOTICE,getpid());
	wcc = write(LOG_syslog,msg,strlen(msg));
	return LOG_syslog;
}
void send_syslogX(PCStr(lclass),PCStr(log))
{	const char *logp;
	const char *dp;
	CStr(msg,0x4000);
	int wcc,hlen,flag;

	if( LOG_syslog < 0 )
		return;

	if( lclass && *lclass == 'F' )
		flag = SYSLOG_DAEMON|SYSLOG_NOTICE;
	else	flag = SYSLOG_DAEMON|SYSLOG_DEBUG;
	if( dp = strchr(log,'[') )
		logp = dp;
	else	logp = log;
	sprintf(msg,"<%d>DeleGate",flag);
	hlen = strlen(msg);
	linescanX(logp,QVStr(msg+hlen,msg),sizeof(msg)-hlen);
	wcc = write(LOG_syslog,msg,strlen(msg));
}
