/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1995 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	tcprelay.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	950701	extracted from service.c and iotimeout.c and merged
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include "delegate.h"
#include "fpoll.h"
#include "proc.h"
#include "file.h"
extern int dump_tcprelay;
extern int BREAK_STICKY;

int service_nbt(Connection *Conn)
{
	dump_tcprelay = 1;
	return relay_svcl(Conn,FromC,ToC,FromS,ToS);
}
void CTX_do_codeconv(Connection *Conn,PCStr(ccode),PCStr(src),PVStr(dst),PCStr(ctype));
int relay_svclX(Connection *Conn,int fromC,int toC,int fromS,int toS,int ins);
void CTX_relay_lines(Connection *Conn,int timeout,int flush,PCStr(C1),int S1,int D1,PCStr(C2),int S2,int D2);

int service_tcprelay(Connection *Conn)
{
	if( ToS < 0 && FromS < 0  ){
		if( isMYSELF(DST_HOST) ){
			ToS = fileno(stdout);
			FromS = fileno(stdin);
			BREAK_STICKY = 1;
			/*
			ToS = dup(fileno(stdout));
			FromS = dup(fileno(stdin));
			sv1log("TCPRELAY for stdin,stdout [%d,%d] <- [%d,%d]\n",
				FromS,ToS,fileno(stdout),fileno(stdin));
			*/
		}else	return -1;
	}

	if( CTX_cur_codeconvCL(Conn,VStrNULL) ){
		CTX_check_codeconv(Conn,1);
		CTX_relay_lines(Conn,0,0,
			CCV_TOCL,FromS,ToC,
			CCV_TOSV,FromC,ToS /*,NULL*/);
	}else{
		relay_svclX(Conn,FromC,ToC,FromS,ToS,1);
	}
	return 0;
}
extern int IO_TIMEOUT;
int in2sock(Connection *Conn,int infd,int *pidp);
void relays(int timeout,int sdc,int sdv[][2],int rccs[]);

int relay_svclX(Connection *Conn,int fromC,int toC,int fromS,int toS,int ins)
{	int sdv[2][2];
	int cnt[2];
	int pid0,pid1;

	if( ins ){
		pid0 = pid1 = 0;
		if( !INHERENT_fork() )
		{
			/* Win32: no poll/select for consol */
			if( !file_ISSOCK(fromC) ){
				fromC = in2sock(Conn,fromC,&pid0); 
			}
			if( !file_ISSOCK(fromS) ){
				fromS = in2sock(Conn,fromS,&pid1); 
			}
		}
	}

	sdv[0][0] = fromC; sdv[0][1] = toS;
	sdv[1][0] = fromS; sdv[1][1] = toC;
	relays(IO_TIMEOUT*1000,2,sdv,cnt);

	if( ins ){
		if( pid0 ) KillTERM(pid0);
		if( pid1 ) KillTERM(pid1);
	}
	return cnt[1];
}
int relay_svcl(Connection *Conn,int fromC,int toC,int fromS,int toS)
{
	return relay_svclX(Conn,fromC,toC,fromS,toS,0);
}
int relayf_svcl(Connection *Conn,FILE *fc,FILE *tc,FILE *fs,FILE *ts)
{	int cc;
	CStr(buf,512);

	while( 0 < (cc = fgetBuffered(AVStr(buf),sizeof(buf),fc)) )
		fputs(buf,ts);
	fflush(ts);
	while( 0 < (cc = fgetBuffered(AVStr(buf),sizeof(buf),fs)) )
		fputs(buf,tc);
	fflush(tc);
	return relay_svcl(Conn,fileno(fc),fileno(tc),fileno(fs),fileno(ts));
}

int simple_relayTimeout(int src,int dst,int timeout);
int simple_relayfTimeout(FILE *src,FILE *dst,int timeout);
int simple_relay(int src,int dst)
{
	return simple_relayTimeout(src,dst,IO_TIMEOUT*1000);
}
int simple_relayf(FILE *src,FILE *dst)
{
	return simple_relayfTimeout(src,dst,IO_TIMEOUT*1000);
}

void CTX_relay_lines(Connection *Conn,int timeout,int flush,PCStr(C1),int S1,int D1,PCStr(C2),int S2,int D2)
{	FILE *rfv[2]; /**/
	FILE *wfv[2]; /**/
	const char *ccv[2]; /**/
	char code;
	int wcv[2],rdv[2],nready;
	int fpc,fi;
	CStr(iline,1024);
	CStr(xline,4096);
	const char *oline;

	ccv[0] = C1; rfv[0] = fdopen(S1,"r"); wfv[0] = fdopen(D1,"w");
	ccv[1] = C2; rfv[1] = fdopen(S2,"r"); wfv[1] = fdopen(D2,"w");
	wcv[0] = wcv[1] = 0;
	fpc = 2;

	for(;;){
		nready = 0;
		for( fi = 0; fi < fpc; fi++ )
			if( 0 < ready_cc(rfv[fi]) )
				nready++;
		if( nready == 0 )
			for( fi = 0; fi < fpc; fi++ ){
				fflush(wfv[fi]);
				wcv[fi] = 0;
			}

		if( fPollIns(timeout,fpc,rfv,rdv) < 0 )
			break;

		for( fi = 0; fi < fpc; fi++ ){
		    if( 0 < rdv[fi] ){
			if( fgets(iline,sizeof(iline),rfv[fi]) == NULL )
				goto gotEOF;

			if( ccv[fi] == NULL )
				oline = iline;
			else{
				CTX_do_codeconv(Conn,ccv[fi],iline,AVStr(xline),"text/plain");
				oline = xline;
			}

			if( fputs(oline,wfv[fi]) == EOF )
				goto gotEOF;

			wcv[fi] += strlen(oline);
			if( 0 < flush && flush < wcv[fi] ){
				fflush(wfv[fi]);
				wcv[fi] = 0;
			}
		    }
		}
	}
gotEOF:
	for( fi = 0; fi < fpc; fi++ ){
		fclose(rfv[fi]);
		fclose(wfv[fi]);
	}
}

static void in2sock1(Connection *Conn,int clsock,int svsock,int ac,char *av[],PCStr(arg))
{	CStr(buf,256);
	int rcc,wcc;

	/* must watch disconnection of svsock while reading ... */
	while( 0 < (rcc = read(0,buf,sizeof(buf))) ){
		if( buf[0] == 'D'-0x40 ) /* control-D dose not cause EOF */
			break;
		wcc = write(svsock,buf,rcc);
		if( wcc <= 0 )
			break;
	}
}
int in2sock(Connection *Conn,int infd,int *pidp)
{	int sock[2];

	Socketpair(sock);
	setCloseOnExecSocket(sock[0]);
	*pidp = execFunc(Conn,-1,sock[1],(iFUNCP)in2sock1,"");
	clearCloseOnExecSocket(sock[0]);
	close(sock[1]);
	return sock[0];
}
