/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994-1999 Yutaka Sato
Copyright (c) 1994-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	service.c (DeleGatable services)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	940303	created
	940623	made per port restriction configurable
//////////////////////////////////////////////////////////////////////#*/
#include "vsocket.h"
#include "delegate.h"
#include "url.h"
#include "param.h" /* P_RES_VRFY */
#include "ystring.h"
#include "filter.h"
#include "fpoll.h"
#include "file.h"
#include "proc.h"
#include "auth.h"
#include "service.h"
extern Service services[];

int never_cache(Connection *Conn);
int setupConnect(Connection *Conn);
void set_SRCIF(Connection *Conn,PCStr(proto),PCStr(host),int port);

int tryCONNECT(Connection *Conn,int relay_input,int *svsockp);
int ConnectViaICP(Connection *Conn,PCStr(dsturl));
int connectToUpper(Connection *Conn,PCStr(where),PCStr(proto),PCStr(host),int port);
int ConnectViaSSLtunnel(Connection *Conn,PCStr(host),int port);

char D_SERVICE_BYPORT[] = "-";

extern int IamPrivateMASTER;
extern int myPrivateMASTER;
extern int BREAK_STICKY;
static void sv1mlog(PCStr(fmt),...)
{
	VARGS(7,fmt);

	if( IamPrivateMASTER || myPrivateMASTER )
		return;

	sv1log(fmt,va[0],va[1],va[2],va[3],va[4],va[5],va[6]);
}

void prservices(FILE *fp)
{	int si;
	Service *sp;

	for( si = 1; services[si].s_name; si++ ){
		sp = &services[si];
		if( 0 < sp->s_iport && sp->s_iport < 8000 )
		fprintf(fp,"%-15s %d\r\n",sp->s_name,sp->s_iport);
	}
}

static int servicex(PCStr(service))
{	int si;
	Service *sp;

	for( si = 1; services[si].s_name; si++ ){
		sp = &services[si];
		if( strcaseeq(sp->s_name,service) )
			return si;
	}
	return 0;
}

/*
 * SERVICE=name:[port[/udp]][:service]
 */
void scan_SERVICE(Connection *Conn,PCStr(desc))
{	int ic,ii,port,si,sn;
	CStr(ib,64);
	const char *iv[4]; /**/
	const char *equiv;
	const char *name;

	lineScan(desc,ib);
	ic = stoV(ib,3,iv,':');
	for( ii = ic; ii < 3; ii++ )
		iv[ii] = "";
	name = iv[0];
	port = atoi(iv[1]);
	equiv = iv[2];

	sn = servicex(name);
	if( sn == 0 ){
		for( sn = 1; sn < NSERVICES-1; sn++ )
			if( services[sn].s_name == 0 )
				break;
	}
	si = 0;
	if( equiv[0] ){
		si = servicex(equiv);
		if( si == 0 ){
			sv1log("ERROR: unknown service '%s'\n",equiv);
			return;
		}
	}
	if( sn != si && si != 0 ){
		services[sn] = services[si];
		services[sn].s_name = stralloc(name);
	}
	if( port ){
		services[sn].s_iport = port;
	}
	sv1log("[%d][%d] SERVICE=%s:%d:%s\n",sn,si,
		services[sn].s_name,services[sn].s_iport,equiv);
}
int protoeq(PCStr(proto1),PCStr(proto2))
{	int s1,s2;

	if( strcaseeq(proto1,proto2) == 0 )
		return 1;
	s1 = servicex(proto1);
	s2 = servicex(proto2);
	return services[s1].s_client == services[s2].s_client;
}
int foreach_eqproto(PCStr(proto),int (*func)(const void*,...),...)
{	int sn,sx,si;
	servFuncP svfunc;
	const char *name;

	sn = 0;
	if( sx = servicex(proto) )
	if( svfunc = services[sx].s_client ){
		VARGS(16,func);
		for( si = 1; name = services[si].s_name; si++ ){
			if( services[si].s_client == svfunc ){
				(*func)(name,VA16);
				sn++;
			}
		}
	}
	return sn;
}
int serviceport(PCStr(service))
{	int si;

	if( si = servicex(service) )
		return services[si].s_iport;
	else	return 0;
}
static int withcache(PCStr(proto))
{	int si;

	if( si = servicex(proto) )
		return services[si].s_withcache;
	else	return 0;
}

servFunc service_delegate;
static servFuncP get_servfunc(Connection *Conn,int clsock,int *withcachep,int *selfackp)
{	int si;
	Service *sp;
	const char *service;
	int iport;
	int byport;

	*withcachep = 0;
	*selfackp = 0;

	service = DFLT_PROTO;

	iport = DFLT_PORT;
	byport = streq(service,D_SERVICE_BYPORT);

	for( si = 1; services[si].s_name; si++ ){
	    sp = &services[si];
	    if( !byport && strcaseeq(sp->s_name,service)
	     ||  byport && iport && sp->s_iport == iport
	    ){
		if( byport )
			strcpy(DFLT_PROTO,sp->s_name);

		if( DFLT_PORT == 0 )
			DFLT_PORT = sp->s_iport;
		*withcachep = sp->s_withcache;
		*selfackp = sp->s_selfack;

		if( DFLT_HOST[0] == 0 )
			if( sp->s_Host )
				strcpy(DFLT_HOST,sp->s_Host);

		return sp->s_client;
	    }
	}
	return &service_delegate;
}

void scan_REJECT(Connection *Conn,PCStr(protolist))
{
	Conn->forreject = 1;
	scan_PERMIT(Conn,protolist);
	Conn->forreject = 0;
}
void scan_PERMITV(Connection *Conn,PCStr(list),const char *protov[]);
void scan_PERMIT(Connection *Conn,PCStr(protolist))
{	const char *pn;
	const char *pv[64]; /**/
	int si,pi;

	pi = 0;
	for( si = 1; pn = services[si].s_name; si++ ){
		if( elnumof(pv)-1 <= pi )
			break;
		pv[pi++] = (char*)pn;
	}
	pv[pi] = 0;
	scan_PERMITV(Conn,protolist,pv);
}

int permitted_readonly(Connection *Conn,PCStr(proto))
{
	if( method_permittedX(Conn,"readonly",NULL,0)
	 || method_permittedX(Conn,proto,".REJECT",0) == 0 /* explicitly defined */
	 && method_permittedX(Conn,proto,"readonly",0) != 0 ){
		sv1log("#### %s: READ-ONLY\n",proto);
		return 1;
	}
	return 0;
}

int DO_METHOD_FILTER;
int method_permitted(Connection *Conn,PCStr(proto),PCStr(method),int igncase)
{	int ok;

	if( DO_METHOD_FILTER == 0 )
		return 1;

	/* method filtering with password authentication for HTTP does
	 * not work in the current implementation... when the method is
	 * checked, HTTP authentication information is not set in
	 * Conn. structure... method checking should be done in
	 * service_permitted() in future implementation.
	 */
	ok = method_permittedX(Conn,proto,method,igncase);
	return ok;
}
int DELEGATE_permitM(Connection *Conn,PCStr(proto),PCStr(method),PCStr(dsthost),int dport,PCStr(srchost),int sport);
int DELEGATE_rejectM(Connection *Conn,PCStr(proto),PCStr(method),PCStr(dsthost),int dport,PCStr(srchost),int sport);

int method_permittedX(Connection *Conn,PCStr(proto),PCStr(method),int igncase)
{	CStr(shost,512);
	CStr(umethod,64);
	int sport;
	int acceptable;

	if( method != NULL && igncase ){
		strtoupper(method,umethod);
		method = umethod;
	}

	sport = getClientHostPort(Conn,AVStr(shost));
	CTX_pushClientInfo(Conn);
	acceptable = DELEGATE_permitM(Conn,proto,method,DST_HOST,DST_PORT,
			shost,sport /*,serviceport(proto)*/);
	if( acceptable ){
		if( DELEGATE_rejectM(Conn,proto,method,DST_HOST,DST_PORT,
			shost,sport /*,serviceport(proto)*/) )
				acceptable = 0;
	}
	HL_popClientInfo();
	return acceptable;
}

void logReject(Connection *Conn,int self,PCStr(shost),int sport);
void delayReject(Connection *Conn,int self,PCStr(method),PCStr(sproto),PCStr(shost),int sport,PCStr(dpath),PCStr(referer),PCStr(reason));
int PERMITTED_ACCESS(Connection *Conn,PCStr(shost),int sport,int stdport);

int service_permitted2(Connection *Conn,PCStr(service),int silent)
{	int clsock;
	int acceptable;
	CStr(shost,512);
	int sport;

	if( Conn->from_myself )
		return 1;

	clsock = ClientSock;
	sport = getClientHostPort(Conn,AVStr(shost));

	if( !IsInetaddr(shost) ) /* i.e. it's a reverse-resolved name */
	if( !hostIsResolvable(shost) ) /* but it cannot be resolved */
	{	CStr(addr,64);

		VA_inetNtoah(Client_VAddr,AVStr(addr));
		sv1log("### INCONSISTENT client host name: %s -> %s -> ?\n",
			addr,shost);
		if( DELEGATE_getEnv(P_RES_VRFY) )
			return 0;
		if( !IsInetaddr(addr) )
			return 0;
		strcpy(Client_Host,addr);
		strcpy(shost,addr);
	}
	if( sport == 0 ){
		sv1log("Cannot get peer name: fd=[%d]\n",clsock);
		return 0;
	}
	CTX_pushClientInfo(Conn);
	acceptable = PERMITTED_ACCESS(Conn,shost,sport,serviceport(service));
	HL_popClientInfo();

	if( acceptable && TeleportHost[0] ){
		strcpy(shost,TeleportHost);
		sport = TeleportPort;
		acceptable = PERMITTED_ACCESS(Conn,shost,sport,serviceport(service));
	}

	if( acceptable ){
		Verbose("PERMITTED: %s://%s\n",DST_PROTO,DST_HOST);
	}else{
		if( !silent ){
			logReject(Conn,1,shost,sport);
			delayReject(Conn,1,"DELEGATE",service,shost,sport,"","",
			"Forbidden by DeleGate");
		}
		ConnError = CO_REJECTED;
	}
	return acceptable;
}
void setOriginIdent(Connection *Conn,PCStr(sockname),PCStr(peername))
{
	Xsscanf(peername,"%[^:]:%d",AVStr(TeleportHost),&TeleportPort);
	strcpy(TeleportAddr,TeleportHost);
	gethostbyAddr(TeleportHost,AVStr(TeleportHost));
	Xsscanf(sockname,"%[^:]:%d",AVStr(TelesockHost),&TelesockPort);
}

int DELAY_REJECT_S = 60;
int DELAY_UNKNOWN_S = 60;
int DELAY_REJECT_P = 0;
int DELAY_UNKNOWN_P = 0;
int DELAY_ERROR = 30;
int DELAY_OVERLOOK = 5;

int server_open_localhost(PCStr(what),PVStr(path),int nlisten);
static void delayClose(PVStr(path),int clsock,int delay)
{	CStr(buf,1024);
	int start;
	int wsock;
	int fc,fv[2],rfv[2],nready;
	int ssec;

	fc = 0;
	fv[fc++] = clsock;

	wsock = server_open_localhost("doDelay",AVStr(path),1);
	if( 0 <= wsock )
		fv[fc++] = wsock;
	else	sv1log("#### doDelay: bind failed.\n");

	while( 0 < delay ){
		start = time(0L);
		if( 0 < (nready = PollIns(delay*1000,fc,fv,rfv)) )
		if( 1 < fc && 0 < rfv[1] ){
			sv1log("doDelay: pushed out.\n");
			break;
		}
		/*
		 * Maybe this is intended to detect disconnection of this
		 * client's connection (clsock) and stop delaying as soon
		 * as possible after the disconnection.
		 *
		 * Real reading of client data is harmful for delaying for
		 * connection oriented protocol like FTP, or keep-alived HTTP.
		 * But the disconnection may not be detected without draining
		 * queued input data if exist. (although it may be rare case,
		 * at least "QUIT command" may be waiting in the queue)
		 * Checking output ability (by PollOut()) for disconnection
		 * detection can be useful... but it might not be
		 * a bi-directional socket (although it's rare case)
		 *
		if( readTimeout(clsock,buf,sizeof(buf),1) <= 0 )
			break;
		*/
		if( !IsAlive(clsock) ){
			sv1log("#### doDelay: client seems disconnected.\n");
			break;
		}
		delay -= (time(0L) - start);
		if( delay <= 0 )
			break;

		/*
		 * interval to check the death of this client or arrival of
		 * another connection from the client which will be detected
		 * with "wsock".
		 */
		ssec = 2;
		if( delay < ssec )
			ssec = delay;
		if( 0 < ssec )
			sleep(ssec);
		delay -= ssec;
	}
	close(wsock);
	unlink(path);
}

void get_delaysock(PCStr(file),PVStr(path));
static void delaysockpath(Connection *Conn,PVStr(file),PVStr(path))
{	CStr(host,256);
	CStr(addr,256);

	getClientHostPortAddr(Conn,AVStr(host),AVStr(addr));
	sprintf(file,"%02d/%s:%s",FQDN_hash(host)%32,addr,host);
	get_delaysock(file,AVStr(path));
}

/*
 * wait by MD5 of given key ... MD5("name:value")
 * client:host
 * content-md5:md5
 */
void waitClientDelay(Connection *Conn,int ifd,int delay)
{	CStr(spath,1024);
	CStr(cpath,1024);
	CStr(file,256);
	int wsock,nfd,fdv[2],rdv[2],nready;

	delaysockpath(Conn,AVStr(file),AVStr(spath));
sv1log("##CALLBACK# SET DELAY[%s]\n",spath);
	wsock = client_open_localhost("doDelay",spath,1);
	if( 0 <= wsock ){
		sv1log("##[%s] push out previous delay (%ds)\n",
			file,time(0L)-File_mtime(spath));
		close(wsock);
	}
	wsock = server_open_localhost("doDelay",AVStr(spath),1);
	nfd = 0;
	if( 0 <= wsock )
		fdv[nfd++] = wsock;
	if( 0 <= ifd )
		fdv[nfd++] = ifd;
	nready = PollIns(delay,nfd,fdv,rdv);
}
int findClientDelay(Connection *Conn)
{	CStr(spath,1024);
	CStr(file,256);

	delaysockpath(Conn,AVStr(file),AVStr(spath));
	if( File_is(spath) ){
sv1log("##CALLBACK# GET DELAY[%s] = age:%d\n",spath,
time(0L)-File_mtime(spath));
		return time(0L)-File_mtime(spath);
	}
	return 0;
}

static int doDelay(Connection *Conn,PCStr(method),int maxdelay,PVStr(cpath),PVStr(spath),int *countp)
{	CStr(path,1024);
	CStr(file,256);
	/*
	CStr(host,256);
	CStr(addr,256);
	*/
	long count,mtime,age,dodelay;
	int delays;
	int wsock;

	if( maxdelay <= 0 )
		return 0;

	/* The client host may make next connection without waiting the
	 * closing of the current connection.  In such case, delaying all
	 * connection to close will make a pile of waiting process for the
	 * client.  Thus push out previous process if exists.
	 */
	/*
	getClientHostPortAddr(Conn,host,AVStr(addr));
	sprintf(file,"%02d/%s:%s",FQDN_hash(host)%32,addr,host);

	get_delaysock(file,spath);
	*/
	delaysockpath(Conn,AVStr(file),AVStr(spath));
	wsock = client_open_localhost("doDelay",spath,1);
	if( 0 <= wsock ){
		sv1log("doDelay: push out previous delay.\n");
		close(wsock);
	}

	/* peer count is not available ? */
	if( Conn->cl_count <= 0 )
		return 0;

	sprintf(path,"%s/%s",method,file);
	count = countUp(path,1,1,getpid(),&mtime,AVStr(cpath));

	/* error counter is not available ? */
	if( count <= 0 || mtime == 0 )
		return 0;

	/* overlook the first error */
/*
	if( count <= 1 )
*/
	if( count <= DELAY_OVERLOOK  )
		return 0;

	/* clear errors of long ago. */
	age = time(0L) - mtime;
	if( maxdelay < age ){
		sv1log("doDelay: clear old errors: count=%d,age=%d,delay=%d\n",
			count,age,maxdelay);
		count = countUp(path,1,0,getpid(),&mtime,AVStr(cpath));
		return 0;
	}

	/* Do delay when errors occured in rapid succession.
	 * The age of the error coutner shows the interval of errors.
	 * The minimum interval should be long if the desirable delay is
	 * long, the situation where error is serious.
	 */
	dodelay = age <= maxdelay / 4 + 1;
	Verbose("doDelay: %d count=%d, age=%d, delay=%d\n",
		dodelay,count,age,maxdelay);
	if( !dodelay )
		return 0;

	/* reach the maximum delay in 20 errors. */
	*countp = count;
/*
	delays = count * (maxdelay / 20 + 1);
*/
	delays = (count - DELAY_OVERLOOK) * (maxdelay / 20 + 1);
	if( maxdelay < delays )
		delays = maxdelay;
	return delays;
}
void logReject(Connection *Conn,int self,PCStr(shost),int sport)
{	const char *what;
	const char *direct;
	CStr(server,256);

	HostPort(AVStr(server),DST_PROTO,DST_HOST,DST_PORT);
	if( self ){
		what = "E-P: No permission";
		direct = "=>";
	}else{
		what = "E-R: Rejected";
		direct = "<=";
	}
/*
	daemonlog("F","%s: %s:%d %s %s://%s\n",
		what, shost,sport, direct, DST_PROTO,server);
*/
	daemonlog("F","%s: %s:%d %s %s://%s (%s)\n",
		what, shost,sport, direct, DST_PROTO,server,Conn->reject_reason);
}

void addRejectList(Connection *Conn,PCStr(what),PCStr(dpath),PCStr(referer),PCStr(auser),PCStr(apass),PCStr(reason));
void delayRejectX(Connection *Conn,int self,PCStr(sproto),PCStr(shost),int sport,int clsock);
void delayReject(Connection *Conn,int self,PCStr(method),PCStr(sproto),PCStr(shost),int sport,PCStr(dpath),PCStr(referer),PCStr(reason))
{
	addRejectList(Conn,method,dpath,referer,"","",reason);
	delayRejectX(Conn,self,sproto,shost,sport,FromC);
}
void delayRejectX(Connection *Conn,int self,PCStr(sproto),PCStr(shost),int sport,int clsock)
{	CStr(cpath,1024);
	CStr(spath,1024);
	int delays,count;
	int delay;

	if( self )
		delay = DELAY_REJECT_S;
	else	delay = DELAY_REJECT_P;
	delays = doDelay(Conn,"errors/reject",delay,AVStr(cpath),AVStr(spath),&count);
	if( delays == 0 )
		return;

	checkCloseOnTimeout(0);
	sv1log("doDelay: delaying reject*%d (%d/%dsecond) %s:%d[%d]\n",
		count, delays,delay, shost,sport,Conn->cl_count);
	ProcTitle(Conn,"(reject:%d)%s://%s/",delays,DST_PROTO,DST_HOST);
	delayClose(AVStr(spath),clsock,delays);
	File_touch(cpath,time(0));
}
void delayConnError(Connection *Conn,PCStr(req))
{	int delay;
	CStr(path,1024);
	CStr(msg,0x4000);

/*
The delay should be done just after accept() ...

	delay = DELAY_ERROR;
	if( !doDelay(Conn,"error/comm",delay,path) )
		return;

	checkCloseOnTimeout(0);
	sv1log("delaying on communication error (%d)\n",delay);
	ProcTitle(Conn,"(error:%d)%s://%s/",delay,DST_PROTO,DST_HOST);
	delayClose(FromC,delay);
	File_touch(path,time(0));
*/
}
void delayUnknown(Connection *Conn,int self,PCStr(req))
{	int delay;
	int delays,count;
	CStr(cpath,1024);
	CStr(spath,1024);
	CStr(shost,256);
	int sport;
	const char *eol;
	CStr(reqn,URLSZ);

	eol = strtailchr(req) == '\n' ? "" : "\n";
	sport = getClientHostPort(Conn,AVStr(shost));
/*
	daemonlog("F","%s: %s:%d %s %s%s",
		"E-U: Unknown",shost,sport,"=>",req,eol);
*/
	lineScan(req,reqn);
	daemonlog("F","%s: %s:%d %s %s [%s://%s:%d]\n","E-U: Unknown",
		shost,sport,"=>",reqn,DST_PROTO,DST_HOST,DST_PORT);

	if( self )
		delay = DELAY_UNKNOWN_S;
	else	delay = DELAY_UNKNOWN_P;
	delays = doDelay(Conn,"errors/unknown",delay,AVStr(cpath),AVStr(spath),&count);
	if( delays == 0 )
		return;

	checkCloseOnTimeout(0);

	sv1log("doDelay: delaying unknown*%d (%d/%dseconds) %s%s",
		count, delays,delay, req,eol);

	ProcTitle(Conn,"(unknown:%d)%s://%s/",delays,DST_PROTO,DST_HOST);
	delayClose(AVStr(spath),FromC,delays);
	File_touch(cpath,time(0));
}

int service_permitted(Connection *Conn,PCStr(service)/*,int silent*/)
{
	return service_permitted2(Conn,service,0);
}

const char *HelloWord(){ return "DeleGate-HELLO"; }
int isHelloRequest(PCStr(req))
{
	return strncmp(req,"DeleGate-HELLO",14) == 0;
}
static
int scanHelloVer(PCStr(resp),PVStr(ver))
{
	setVStrEnd(ver,0);
	return Xsscanf(resp,"DeleGate-HELLO %[^ \t\r\n]",AVStr(ver));
}

int vercmp(PCStr(ver1),PCStr(ver2))
{	int v1[3],v2[3],vi,diff;

	for( vi = 0; vi < 3; vi++ )
		v1[vi] = v2[vi] = 0;

	sscanf(ver1,"%d.%d.%d",&v1[0],&v1[1],&v1[2]);
	sscanf(ver2,"%d.%d.%d",&v2[0],&v2[1],&v2[2]);

	diff = 0;
	for( vi = 0; vi < 3; vi++ )
		if( diff = v1[vi] - v2[vi] )
			break;

	return diff;
}

extern int HELLO_TIMEOUT;
/*
 * -- HELLO_TIMEOUT COULD BE LONG ENOUGH IF NOT ALWAYS CHECKED
 * -- If already elapsed more than HELLO_TIMEOUT seconds since connection open
 * (= about since forked), then the client is no more waiting for HELLO reply,
 * and sending it is halmful for the client.
 */

static void returnHELO(Connection *Conn,FILE *tc);
static void gotHELLO(Connection *Conn,FILE *tc,PCStr(fieldname),PCStr(value))
{	CStr(version,64);
	CStr(control,64);
	const char *cp;

	cp = wordScan(value,version); lineScan(cp,control);
	sv1mlog("CLIENT says: %s %s [%s]\n",fieldname,version,control);

	strcpy(ClientVER,version);
	if( streq(control,"NOACK") )   NoACK = 1; else
	if( streq(control,"NOSYNC") )  RespNOSYNC = 1;

	returnHELO(Conn,tc);
}
static void toclnt(Connection *Conn,FILE *tc,PCStr(fmt),...)
{	CStr(msg,1024);
	VARGS(7,fmt);

	if( fileno(tc) == ClientSock ){
		fprintf(tc,fmt,va[0],va[1],va[2],va[3],va[4],va[5],va[6]);
		fflush(tc);
	}else{
		sprintf(msg,fmt,va[0],va[1],va[2],va[3],va[4],va[5],va[6]);
		write(ClientSock,msg,strlen(msg));
	}
}
static void respHELO(Connection *Conn,FILE *tc)
{
	toclnt(Conn,tc,"HELO DeleGate/%s\r\n",DELEGATE_ver());
}
static void returnHELO(Connection *Conn,FILE *tc)
{	CStr(host,128);
	CStr(seed,128);

	if( NoACK )
		return;

	if( SaidHello )
		sv1log("#### ignore duplicate HELLO response.\n");

	if( !SaidHello ){
		if( RespNOSYNC ){
			/* Say HELLO later */
			SayHello = 1;
		}else{
			GetHostname(AVStr(host),sizeof(host));
			sprintf(seed,"<%d.%d@%s>",getpid(),time(0),host);
			toclnt(Conn,tc,"%s %s %s\r\n",
				HelloWord(),DELEGATE_ver(),seed);
			SayHello = 0;
		}
		SaidHello = 1;
	}
	ReturnACK = 1;
}
static void returnAck(Connection *Conn,FILE *tc,PCStr(fmt),...)
{	CStr(msg,1024);
	VARGS(7,fmt);

	if( NoACK )
		return;

	sprintf(msg,fmt,va[0],va[1],va[2],va[3],va[4],va[5],va[6]);
	if( ReturnACK ){
		if( SayHello ){
			toclnt(Conn,tc,"%s %s\r\n",HelloWord(),DELEGATE_ver());
			SayHello = 0;
		}
		toclnt(Conn,tc,"%s",msg);
		ReturnACK = 0;
		sv1log("RETURNED ACK = %s",msg);
	}
}
void returnAckOK(Connection *Conn,FILE *tc,PCStr(reason))
{
	returnAck(Conn,tc,"200 OK: %s\r\n",reason);
}
void returnAckCONTINUE(Connection *Conn,FILE *tc,PCStr(reason))
{
	if( ReturnACK ){
		returnAck(Conn,tc,"201 CONTINUE: %s\r\n",reason);
		ReturnACK = 1;
	}
}
void returnAckLOOP(Connection *Conn,FILE *tc,PCStr(where))
{
	returnAck(Conn,tc,"601 LOOP: %s\r\n",where);
}
void returnAckDENIED(Connection *Conn,FILE *tc,PCStr(reason))
{
	returnAck(Conn,tc,"602 DENIED: %s\r\n",reason);
}
void returnAckUNKNOWN(Connection *Conn,FILE *tc,PCStr(host))
{
	returnAck(Conn,tc,"603 UNKNOWN_HOST: %s\r\n",host);
}
void returnAckCANTCON(Connection *Conn,FILE *tc,PCStr(host))
{
	returnAck(Conn,tc,"604 CANT_CONNECT: %s\r\n",host);
}
void returnAckBADREQ(Connection *Conn,FILE *tc,PCStr(reason))
{
	returnAck(Conn,tc,"605 BAD_REQUEST: %s\r\n",reason);
}

int portMap(Connection *Conn,PCStr(proto),PCStr(host),PCStr(portspec))
{	int port,ifport;

	switch( portspec[0] ){
		case '+':
			Conn->sv_portmap = atoi(portspec+1);
			break;
		case '-':
			Conn->sv_portmap = atoi(portspec);
			break;
	}
	if( Conn->sv_portmap == 0 )
	if( portspec[0] == '-' || portspec[0] == '+' )
		Conn->sv_portmap |= 0x40000000; /* add IS_PORTMAP */

	if( portspec[0] == '+' )
		port = atoi(portspec+1);
	else	port = atoi(portspec);

	if( !streq(proto,"file") ) /* and not other virtual protocols ... */
	if( 0 <= ClientSock )
	if( portspec[0] == '+' || portspec[0] == '-' ){
		ifport = VA_HostPortIFclnt(Conn,ClientSock,VStrNULL,VStrNULL,NULL);
		sv1log("### map accept port#%d to server#%d\n",
			ifport,ifport+port);
		port += ifport;
	}
	return port;
}

static int scan_server(Connection *Conn,PCStr(url),PVStr(proto),PVStr(host),int *portp,PVStr(upath))
{	CStr(xproto,1024);
	CStr(site,1024);
	CStr(userpasshost,1024);
	CStr(portspec,1024);
	int xport;

	xproto[0] = 0;
	xport = 0;
	setVStrEnd(upath,0);

	if( Xsscanf(url,"%s %s %d",AVStr(site),AVStr(xproto),&xport) < 2 ) /* DeleGate/1.X */
	if( decomp_absurl(url,AVStr(xproto),AVStr(site),AVStr(upath),1024) < 2 ){
		wordScan(url,xproto);
		if( 0 < serviceport(xproto) )
			strcpy(site,"-");
		else{
			sv1log("ERROR: cannot scan SERVER=%s\n",url);
			return 0;
		}
	}

	if( xproto[0] == 0 || site[0] == 0 ){
		sv1log("ERROR: cannot scan SERVER: %s\n",url);
		return 0;
	}
	strcpy(proto,xproto);
	decomp_URL_site(site,AVStr(userpasshost),AVStr(portspec));
	scan_hostport1X(userpasshost,AVStr(host),256);
	xport = portMap(Conn,proto,host,portspec);
	if( xport == 0 )
		xport = serviceport(proto);
	*portp = xport;
	return 1;
}
static void set_iserver(Connection *Conn,PCStr(upath))
{
	if( iSERVER_HOST[0] == 0 ){
		strcpy(iSERVER_PROTO,DFLT_PROTO);
		strcpy(iSERVER_HOST,DFLT_HOST);
		iSERVER_PORT = DFLT_PORT;
	}
	wordscanX(upath,AVStr(D_SELECTOR),sizeof(D_SELECTOR));
	ProcTitle(Conn,"%s://%s/",DFLT_PROTO,DFLT_HOST);
}
int scan_SERVER(Connection *Conn,PCStr(server))
{	CStr(sbuff,4096);
	refQStr(proto,sbuff); /**/
	refQStr(login,sbuff); /**/
	refQStr(upath,sbuff); /**/

	proto = sbuff;
	login = proto + 64;
	upath = login + 256;
	if( scan_server(Conn,server,AVStr(proto),AVStr(login),&DFLT_PORT,AVStr(upath)) ){
		wordscanX(login,AVStr(DFLT_SITE),sizeof(DFLT_SITE));
		wordscanX(proto,AVStr(DFLT_PROTO),sizeof(DFLT_PROTO));
		wordscanX(login,AVStr(DFLT_HOST),sizeof(DFLT_HOST));
		if( server != D_SERVER )
			add_DGheader(Conn,D_SERVER,"%s",server);
		set_iserver(Conn,upath);
		return 1;
	}
	return 0;
}
void set_SERVER(Connection *Conn,PCStr(proto),PCStr(host),int port)
{	const char *serv;

	/*
	if( port )
	*/
	if( 0 < port ) /* port number can be netative for pseudo protocols */
		serv = add_DGheader(Conn,D_SERVER,"%s://%s:%d",proto,host,port);
	else	serv = add_DGheader(Conn,D_SERVER,"%s://%s",proto,host);
	scan_SERVER(Conn,serv);
}
void set_realproto(Connection *Conn,PCStr(rproto))
{
	wordscanX(rproto,AVStr(REAL_PROTO),sizeof(REAL_PROTO));
}
void set_ClientSock(Connection *Conn,int sock,PCStr(remote),PCStr(local))
{
	Conn->from_myself = 0;
	ClientSock = sock;
	Client_Port = 0;
	VA_getClientAddr(Conn);
}
void set_USER(Connection *Conn,int clsock);
void set_realsite(Connection *Conn,PCStr(rproto),PCStr(rserver),int riport);
void set_realserver(Connection *Conn,PCStr(rproto),PCStr(rserver),int riport)
{
	set_realsite(Conn,rproto,rserver,riport);
	set_SERVER(Conn,REAL_PROTO,REAL_SITE,REAL_PORT);
	set_USER(Conn,FromC); /* maybe unnecessary */
}
void set_realsite(Connection *Conn,PCStr(rproto),PCStr(rserver),int riport)
{	int port;
	CStr(host,256);

	wordscanX(rproto,AVStr(REAL_PROTO),sizeof(REAL_PROTO));
	wordscanX(rserver,AVStr(REAL_SITE),sizeof(REAL_SITE));
	VSA_cto_(REAL_SITE);
	port = scan_Hostport1p(REAL_PROTO,REAL_SITE,host);
	wordscanX(host,AVStr(REAL_HOST),sizeof(REAL_HOST));
	REAL_PORT = riport ? riport : port;
}
void scan_realserver(Connection *Conn,PCStr(url),PVStr(upath))
{	CStr(sbuff,4096);
	refQStr(proto,sbuff); /**/
	refQStr(login,sbuff); /**/
	const char *dp;
	int riport;

	proto = sbuff;
	login = proto + 64;
	decomp_absurl(url,AVStr(proto),AVStr(login),AVStr(upath),1024);
	if( dp = strrchr(login,':') ){
		truncVStr(dp); dp++;
		riport = atoi(dp);
	}else	riport = 0;
	set_realsite(Conn,proto,login,riport);
	set_SERVER(Conn,REAL_PROTO,REAL_SITE,REAL_PORT);
}
void set_USER(Connection *Conn,int clsock)
{	CStr(clnthost,256);

	if( D_USER[0] == 0 ){
		if( getClientHostPort(Conn,AVStr(clnthost)) )
			add_DGheader(Conn,D_USER,"anonymous@%s",clnthost);
		else	add_DGheader(Conn,D_USER,"anonymous");
	}
}

static void Metamorphose(Connection *Conn,PCStr(proto),PCStr(host),PVStr(req),PCStr(crlf))
{
	Verbose("=======> Metamorphose: [%s]->[%s]://%s/\n",DFLT_PROTO,
		proto,host);

	ACT_SPECIALIST = 1;
	META_SPECIALIST = 1;
	set_SERVER(Conn,proto,host,0);
	if( crlf )
		strcat(req,crlf);
	DDI_pushCbuf(Conn,req,strlen(req));
}

static int isGopherRequest(Connection *Conn,PCStr(line))
{	CStr(req,128);
	CStr(flags,128);
	CStr(proto,128);
	CStr(host,128);
	CStr(path,128);
	int port;
	int gtype;

	wordScan(line,req);
	if( CTX_url_derefer(Conn,"?",AVStr(req),VStrNULL,AVStr(flags),AVStr(proto),AVStr(host),&port) )
		if( strcasecmp(proto,"gopher") == 0 )
			return 1;
	return 0;
}

int bindTeleportVehicle(int tx,int clsocks[],PCStr(host),int port,PCStr(tunnel),PCStr(invites));
static void beTeleportd(Connection *Conn,int fromC,int toC)
{	int iov[2];

	iov[0] = fromC;
	iov[1] = toC;
	ProcTitle(Conn,"teleportd");

	checkCloseOnTimeout(0);
	bindTeleportVehicle(0,iov,"private.vehicle",0,NULL,NULL);
}

int execGeneralist(Connection *Conn,int fromC,int toC,int svsock);
int execSpecialist(Connection *Conn,int fromC,FILE *tc,int toS);
void beGeneralist(Connection *Conn,FILE *fc,FILE *tc,PCStr(hello))
{	int fromC,toC;
	CStr(buf,0x4000);
	int len;

	BORN_SPECIALIST = 0;
	ACT_GENERALIST = 1;
	sv1log("BE GENERALIST[%s]: %s",DFLT_PROTO,hello);
	strcpy(buf,hello);
	len = strlen(buf);
	fgetBuffered(QVStr(buf+len,buf),sizeof(buf)-len,fc);
	DDI_pushCbuf(Conn,buf,strlen(buf));

	toC = fcloseFILE(tc);
	fromC = fcloseFILE(fc);

	DFLT_HOST[0] = 0;
	execGeneralist(Conn,fromC,toC,-1);
}

int get_shared(PVStr(buf),int size,FILE *fp);
int put_shared(PCStr(buf),int size,FILE *fp);
int add_params(Connection *Conn,FILE *tc,PCStr(command));
void setREQUEST(Connection *Conn,PCStr(req));
void scan_OVERRIDE(Connection *Conn,PCStr(ovparam));
static int obsoletecoms(Connection *Conn,FILE **tcp,int fromC,int toC,PCStr(fieldname),PCStr(value),int *do_exitp)
{	FILE *tc = *tcp;

	if( streq(fieldname,"RPORT") ){
		linescanX(value,AVStr(D_RPORTX),sizeof(D_RPORTX));
	}else
	if( streq(fieldname,"MASTER") ){
		scan_MASTER(Conn,value);
		add_DGheader(Conn,fieldname,"%s",value);
	}else
	if( streq(fieldname,"REQUEST") ){
		setREQUEST(Conn,value);
	}else
	if( streq(fieldname,"CLIENTS-PROXY") ){
		linescanX(value,AVStr(CLIENTS_PROXY),sizeof(CLIENTS_PROXY));
		Verbose("CLIENTS-PROXY: %d\n",1);
	}else
	if( streq(fieldname,"LOCAL-PROXY") ){
		ACT_TRANSLATOR = 1;
		/* no =@=, but only translator ... ?;-< */
	}else
	if( streq(fieldname,"LOCAL-DELEGATE") ){
		Verbose("LOCAL-DELEGATE: %s\n",value);
		DELEGATE_LPORT =
		scan_hostport1X(value,AVStr(DELEGATE_LHOST),sizeof(DELEGATE_LHOST));
		ACT_SPECIALIST = 1;
	}else
	if( streq(fieldname,"LOCAL-FLAGS") ){
		Verbose("LOCAL-FLAGS: %s\n",value);
		linescanX(value,AVStr(DELEGATE_FLAGS),sizeof(DELEGATE_FLAGS));
	}else
	if( streq(fieldname,"LOCAL-CHARCODE") ){
		Verbose("LOCAL-CHARCODE: %s\n",value);
		scan_CHARCODE(Conn,value);
	}else
	if( streq(fieldname,"CACHE") ){
		if( streq(value,"DONT_READ") ){
			Verbose("DontReadCache\n");
			DontReadCache = 1;
		}else
		if( streq(value,"DONT_WAIT") ){
			Verbose("DontWaitCache\n");
			DontWaitCache = 1;
		}else
		if( strncmp(value,"ONLY",4) == 0 ){
			CacheOnly = 1;
			CacheLastMod = atoi(value+5);
			Verbose("CacheOnly IfLastMod>%d\n",CacheLastMod);
		}else{
			/* DISABLE */

			DontUseCache = 1;
			DontWaitCache = 1;
			DontReadCache = 1;
			DontWriteCache = 1;
		}
		/* add_DGheader(Conn,fieldname,"%s",value); */
	}else
	if( streq(fieldname,"OVERRIDE") ){
		int ok;
		CStr(proto,64);
		strcpy(proto,DST_PROTO);
		Xstrcpy(EVStr(DST_PROTO),"override");
		ok = service_permitted(Conn,"override");
		Xstrcpy(EVStr(DST_PROTO),proto);

		if( ok ){
		CStr(nam,256);
		CStr(val,256);
		CStr(ov,1024);
		scan_namebody(value,AVStr(nam),sizeof(nam),"=",AVStr(val),sizeof(val),"\r\n");
			if( nam[0] ){
				sv1mlog("OVERRIDE %s %s\n",nam,val);
				sprintf(ov,"*:*:%s",value);
				scan_OVERRIDE(Conn,ov);

				if( streq(nam,"TIMEOUT") )
					scan_TIMEOUT(Conn,val);
				else
				if( streq(nam,"CONNECT") ){
					if( streq(val,"cache") ){
						scan_CONNECT(Conn,val);
						CacheOnly = 1;
					}
				}
			}
		}
	}else
	if( streq(fieldname,"TELEPORT") ){
		fflush(tc);
		beTeleportd(Conn,fromC,toC /*,value*/);
		Finish(0);
	}else
	if( streq(fieldname,"CPORT") ){
		CStr(hp,256);
		CStr(clhost,256);
		CStr(xclhost,256);
		const char *dp;
		int clport,xclport,csock;

		dp = wordScan(value,hp);
		clport = scan_hostport1X(hp,AVStr(clhost),sizeof(clhost));
		dp = wordScan(dp,hp);
		xclport = scan_hostport1X(hp,AVStr(xclhost),sizeof(xclhost));

		if( clhost[0] && sockFromMyself(fromC) ){
			sv1log("CPORT: %s:%d\n",clhost,clport);
			strcpy(TeleportHost,clhost);
			TeleportPort = clport;
			fprintf(tc,"200 Ok [%s:%d]\r\n",clhost,clport);
			fflush(tc);
		}
		if( xclhost[0] != 0 ){
			csock = client_open("CPORT","delegate",xclhost,xclport);
			if( 0 <= csock ){
				dup2(csock,toC);
				close(csock);
			}
		}
	}else
	if( strcaseeq(fieldname,"!SET") ){
		FILE *tc;
		tc = fdopen(toC,"w");
		*do_exitp = 1;
	}else
	if( streq(fieldname,"OUT") ){
		CStr(buff,2048);
		CStr(UserHost,256);
		if( getClientUserMbox(Conn,AVStr(UserHost)) ){
			sprintf(buff,"%s %s\r\n",UserHost,value);
			put_shared(buff,strlen(buff),NULL);
			fflush(tc);
			write(toC,buff,strlen(buff));
		}
	}else
	if( streq(fieldname,"IN") ){
		CStr(buff,2048);
		int rc;
		rc = get_shared(AVStr(buff),sizeof(buff),NULL);
		fflush(tc);
		write(toC,buff,rc);
	}else
	if( strcaseeq(fieldname,"PARAM") ){
		fflush(tc);
		add_params(Conn,tc,value);
		fflush(tc);
	}else{
		return 0;
	}
	*tcp = tc;
	return 1;
}

extern int IO_TIMEOUT;

void scan_header(Connection *Conn,int fromC,PCStr(name),PCStr(value));

static int execGeneralist0(Connection *Conn,FILE *tc,int fromC,int toC)
{	CStr(line,1024); /* the smaller the safer, but can be
			  * insufficient for HOSTS transfer ?
			  */
	const char *crlfp;
	CStr(crlf,4);
	const char *fieldname;
	const char *value;
	int lines;
	int do_exit = 0;

	lines = 0;
	for(;;){
		line[0] = 0;
		if( DDI_fgetsFromCbuf(Conn,AVStr(line),sizeof(line),NULL) == 0 )
		{
			if( PollIn(fromC,IO_TIMEOUT*1000) <= 0 ){
				sv1log("execGeneralist(): TIMEOUT\n");
				do_exit = 1;
				break;
			}
			if( RecvLine(fromC,line,sizeof(line)) < 0 )
				break;
		}
		crlf[0] = 0;
		if( crlfp = strpbrk(line,"\r\n") ){
			QStrncpy(crlf,crlfp,3);
			truncVStr(crlfp);
		}

		Verbose("DGHeader: %s\n",line);
		if( *line == 0 )
			break;

		if( lines == 0 ){
			if( HTTP_isMethod(line) ){
				Metamorphose(Conn,"http",SERV_HTTP,AVStr(line),crlf);
				set_USER(Conn,fromC);
				break;
			}

			if( !source_permitted(Conn) ){
				CStr(host,256);
				int port;
				port = getClientHostPort(Conn,AVStr(host));
				sv1log("E-P: Rejected MASTER usage < %s:%d\n",
					host,port);
				do_exit = 1;
				break;
			}
			if( VSAP_isMethod(line) ){
				Metamorphose(Conn,"vsap",MY_HOSTPORT(),AVStr(line),crlf);
				break;
			}
			if( strncmp(line,"whois://",8) == 0 ){
				Metamorphose(Conn,"whois",MY_HOSTPORT(),AVStr(line),crlf);
				set_USER(Conn,fromC);
				break;
			}
			if( isGopherRequest(Conn,line) ){
				Metamorphose(Conn,"gopher",MY_HOSTPORT(),AVStr(line),crlf);
				set_USER(Conn,fromC);
				break;
			}
			Verbose("ImMaster: act as a MASTER\n");
			ImMaster = 1;
		}

		lines++;
		if( value = strpbrk(line,"\r\n\t ") ){
			truncVStr(value); value++;
		}else	value = "";
		fieldname = line;


		if( streq(fieldname,"HELO") ){
			respHELO(Conn,tc);
		}else
		if( streq(fieldname,HelloWord()) ){
			gotHELLO(Conn,tc,fieldname,value);
		}else
		if( streq(fieldname,"SERVER") ){
			scan_SERVER(Conn,value);
			set_USER(Conn,fromC);
		}else
		if( strcaseeq(fieldname,"QUIT") ){
			do_exit = 1;
			break;
		}else
		if( obsoletecoms(Conn,&tc,fromC,toC,fieldname,value,&do_exit) ){
			if( do_exit )
				break;
		}else	scan_header(Conn,fromC,fieldname,value);
	}

	return do_exit;
}

void dynamic_config(Connection *Conn);
void execGeneralist1(Connection *Conn,int fromC,int toC,int svsock)
{	FILE *tc;

	set_keepalive(fromC,1);
	tc = fdopen(toC,"w");

	if( !strcaseeq(DFLT_PROTO,"delegate") )
	if( DFLT_HOST[0] ){
		/* then it is Specialized already */
		Verbose("execGeneralist->execSpecialist\n");
		execSpecialist(Conn,fromC,tc,svsock);
		goto EXIT;
	}

ProcTitle(Conn,"(delegate)");

	if( execGeneralist0(Conn,tc,fromC,toC) != 0 )
		goto EXIT;

	if( streq(DST_PROTO,"http") )
		dynamic_config(Conn);

	fflush(tc);
	execSpecialist(Conn,fromC,tc,svsock);

EXIT:
	if( 0 <= FromS && ToS != FromS ){ /* FFROMMD filter inserted ... */
		close(FromS);
		Verbose("close FromS:%d (ToS=%d)\n",FromS,ToS);
	}
	fclose(tc);
}

void DELEGATE_setenv(FILE *fc,FILE *tc,PCStr(line))
{
	fprintf(tc,"SET\r\n");
}

static int setServ(Connection *Conn,int svsock)
{
	/*Verbose("####setServ: %d %d\n",FromS,svsock);*/
	if( (Conn->xf_filters & XF_FTOMD) == 0 || (ToSX < 0 && ToS < 0) )
	ToS   = svsock;

	if( FromSX < 0 && FromS < 0 )
		FromS = svsock;
	return svsock;
}
static void setConn(Connection *Conn,int fromC,int toC,int fromS,int toS)
{
	/*Verbose("#### setConn: FromS:%d fromS:%d,toS:%d\n",FromS,fromS,toS);*/
	FromC = fromC;
	ToC   = toC;
	if( FromSX < 0 )
		FromS = fromS;
	ToS   = toS;
}

const char *CTX_get_PATH(Connection *Conn);
const char *CTX_add_PATH(Connection *Conn,PCStr(me),PCStr(hostport),PCStr(teleport));

int log_PATH(Connection *Conn,PCStr(where))
{	const char *path;
	CStr(teleport,512);
	CStr(dest,256);
	int loop;

	loop = 0;
	if( Conn->path_added == 0 ){
		CStr(me,256);
		CStr(hostport,256);
		int port;
		const char *dp;
		int len;

		if( TeleportHost[0] && TeleportPort ){
			sprintf(teleport,"%s:%d.-.%s:%d",TelesockHost,TelesockPort,
				TeleportHost,TeleportPort);
		}else	teleport[0] = 0;

		Conn->path_added = 1;
		gethostName(ClientSock,AVStr(me),PN_HOSTPORT);
		FStrncpy(Conn->cl_myhp,me);

		len = strlen(me);
		if( 0 < (port = getClientHostPort(Conn,AVStr(hostport))) )
			Xsprintf(TVStr(hostport),":%d",port);
		else	strcpy(hostport,"?:0");

		path = CTX_add_PATH(Conn,me,hostport,teleport);

if( !Conn->from_myself )
if( SERVER_PORT() != 0 ) /* FTP/TUNNEL mistaken as loop by "0.0.0.0:0" */
		if( !isMYSELF(DST_HOST) )
		if( dp = strstr(path+len,me) ){
		    if( dp[-1] == '!' && dp[len] == '!' ){
			loop = 1;
			sv1log("ERROR: loop found in PATH: %s!%s\n",me,path);
		    }
		}
	}else	path = CTX_get_PATH(Conn);

	if( DST_HOST[0] )
		sprintf(dest,"%s://%s:%d",DST_PROTO,DST_HOST,DST_PORT);
	else	sprintf(dest,"%s",DST_PROTO);

	if( where[0] == ':' && streq(DFLT_PROTO,"http") )
		Verbose("PATH%s %s!%s\n",where,dest,path);
	else	sv1tlog("PATH%s %s!%s\n",where,dest,path);
	return loop;
}

void setFROM(Connection *Conn,PCStr(username),PCStr(hostaddr),int port);
static void setClientInfo(Connection *Conn)
{	CStr(username,64);
	CStr(hostname,256);
	CStr(hostaddr,256);
	int cport;

	if( (cport = getClientHostPortAddr(Conn,AVStr(hostname),AVStr(hostaddr))) == 0 ){
		strcpy(hostname,"-");
		strcpy(hostaddr,"0.0.0.0");
	}

	strcpy(CLNT_PROTO,DFLT_PROTO);
	if( strcmp(CLNT_PROTO,iSERVER_PROTO) != 0 ){
		Verbose("CLNT_PROTO[%s] <- iSERVER_PROTO[%s]\n",
			CLNT_PROTO,iSERVER_PROTO);
		/* can be defferent on HTTP->Generalist metamo... */
	}

	if( D_FROM[0] == 0 ){
		getUsernameCached(getuid(),AVStr(username));
		setFROM(Conn,username,hostaddr,cport);
	}
}

int withCFI(int fiset);
void setConnX(Connection *Conn,int fromC,int toC,int fromS,int toS);
int connect_to_serv(Connection *Conn, int fromC,int toC, int relay_input);
int daemonControl(Connection *Conn,int fromC,FILE *tc,int timeout);
void mount_nodefaults(PCStr(iproto),int on);

int execSpecialist(Connection *Conn,int fromC,FILE *tc,int toS)
{	iFUNCP client;
	int clsock;
	int withcache,selfack;
	int fromS;
	int rcode;

	if( iSERVER_PROTO[0] && strcmp(iSERVER_PROTO,DFLT_PROTO) != 0 )
		mount_nodefaults(iSERVER_PROTO,1);

	fromS = -1;
	clsock = ClientSock;
	setClientInfo(Conn);

	if( log_PATH(Conn,":") != 0 ){
		returnAckLOOP(Conn,tc,"path loop found");
		return -1;
	}
	if( daemonControl(Conn,fromC,tc,10) ){
		fflush(tc);
		return -1;
	}

	client = (iFUNCP)get_servfunc(Conn,clsock,&withcache,&selfack);
	if( withcache == 0 && isMYSELF(DFLT_HOST) ){
		sv1log("Free proxy -- %s://%s/\n",DFLT_PROTO,DFLT_HOST);
		withcache = 1;
	}

	if( toS == -1 ){
	    if( isMYSELF(DFLT_HOST) && streq(DFLT_PROTO,"telnet") ){
	    }else
	    if( isMYSELF(DFLT_HOST) && (streq(DFLT_PROTO,"nntp") || streq(DFLT_PROTO,"news")) ){
	    }else
	    if( withcache ){
		/*
		should search caches here...
		 */
		if( ReturnACK ){
			if( !service_permitted(Conn,DFLT_PROTO) )
			{
				returnAckDENIED(Conn,tc,"access denied");
				return -1;
			}
			if( !HAS_MASTER )
			if( !IsResolvable(DFLT_HOST) )
			if( !isMYSELF(DFLT_HOST) && !streq(".",DFLT_HOST) )
			{
				sv1log("unknown host: %s [%d]\n",DFLT_HOST,HAS_MASTER);
				returnAckUNKNOWN(Conn,tc,DFLT_HOST);
				return -1;
			}
			/*
			if( connectOnlyCache )
			if( no-cache-available  )
				returnAckNOCACHE(Conn,tc,"cache unavailable\n");
			*/
		}
	    }else{
		toS = connect_to_serv(Conn,fromC,fileno(tc), 0);
		/*
		 * ToS and FromS may be set already differently by FTOSV
		 */
		if( 0 <= ToS && toS == ToSX && 0 <= FromS ){
			toS = ToS;
			fromS = FromS;
		}
		/* FromS may be set already */
		if( Conn->xf_filters & XF_FFROMSV ){
			fromS = FromS;
		}

		if( toMaster ){
Verbose("====> RETURN Ack <200 Ok.> from Mediator.\n");
			returnAckOK(Conn,tc,"connected to the master");

			/* ProcTitle(Conn,"(relay)"); */
			fflush(tc);
			if( withCFI(XF_SERVER|XF_MASTER|XF_CLIENT) ){
				if( Conn->xf_filters & XF_FTOMD )
				if( 0 <= ToS && 0 <= FromS )
				{
					toS = ToS;
					fromS = FromS;
				}
			}else{
			setConnX(Conn,fromC,fileno(tc),fromS,toS);
			ProcTitle(Conn,"%s://%s/(relay)",DST_PROTO,DST_HOST);
			relay_svcl(Conn,FromC,ToC,FromS,ToS /*,1,512*/);
			return -1;
			}
		}
	    }
	}

	if( !selfack || D_RPORTX[0] )
		returnAckOK(Conn,tc,"good");

	setConnX(Conn,fromC,fileno(tc),fromS,toS);
	ProcTitle(Conn,"%s://%s/",DST_PROTO,DST_HOST);

	fflush(tc);

	willSTLS_CL(Conn);

	rcode = (*client)(Conn,0,0,FromC,ToC,DST_PROTO,DST_HOST,DST_PORT,D_SELECTOR);

	/* close FFROMMD filter if exists */
	/* ... and if I'm not StickyServer ?? ... */
	if( 0 <= FromSX ){
		close(FromSX);
		FromSX = -1;
	}

	return rcode;
}

void insert_FPROTO(Connection *Conn,int *toCp,int toS,int *fromSp);
void setConnX(Connection *Conn,int fromC,int toC,int fromS,int toS)
{
	insert_FPROTO(Conn,&toC,toS,&fromS);
	setConn(Conn,fromC,toC,fromS,toS);
}

int RecvLineTIMEOUT(int sock,char buff[],int size,int timeout)
{
	if( 0 < PollIn(sock,timeout) )
 		return RecvLine(sock,buff,size);
	return -1;
}

/*
 *	get_masterserv() could use a persistent data file shared among
 *	delegateds of the same access right.
 */
int get_masterenv(int mx,const char **version,const char **server);
static int reuseMASTER(Connection *Conn,int mx,int msock,const char **version,const char **server)
{
	if( 0 <= RPORTsock )
		return 0;

	if( mx <= 0 )
		return 0;

	if( get_masterenv(mx,version,server) == 0 )
		return 0;

	if( vercmp(*version,"3.0.38") < 0 )
		return 0;

	return 1;
}

extern int CON_TIMEOUT;
void set_masterenv(int mx,PCStr(version),PCStr(server));
void insert_FMASTER(Connection *Conn,int msock);
void forward_RIDENT(Connection *Conn,int where,int svsock,PCStr(ident));
static void relayInput(Connection *Conn,FILE *mfp,int msock,int cache_only,int relay_input,int doflush);

static int connect_master(Connection *Conn,int mx,int msock,int cache_only,int relay_input)
{	FILE *mfpo;
	CStr(resp,128);
	int newver;
	int rcode = 0;
	int fromS;
	CStr(Hello,128);
	int nHello;
	int reuse;
	const char *version;
	const char *server;

	forward_RIDENT(Conn,'m',msock,NULL);

	set_keepalive(msock,1);
	reuse = reuseMASTER(Conn,mx,msock,&version,&server);

	if( reuse && strcmp(server,D_SERVER) == 0 ){
		sv1mlog("#### reuse MASTER[%d] Ver=%s SERVER=%s [NOACK]\n",
			mx,version,server);
		strcpy(MediatorVer,version);
		ToServ = fdopen(msock,"w");
		fprintf(ToServ,"%s %s NOACK\r\n",HelloWord(),DELEGATE_ver());
		relayInput(Conn,ToServ,msock,cache_only,relay_input,0);
		goto EXIT;
	}

	nHello = 0;
	Hello[0] = 0;
	mfpo = fdopen(dup(msock),"w");
	if( mfpo == NULL )
		return -1;

	if( reuse ){
		sv1log("#### reuse MASTER[%d] Ver=%s [NOSYNC]\n",mx,version);
		fprintf(mfpo,"%s %s NOSYNC\r\n",HelloWord(),DELEGATE_ver());
		strcpy(MediatorVer,version);
		newver = 1;
	}else{
		fprintf(mfpo,"%s %s\r\n",HelloWord(),DELEGATE_ver());
		fflush(mfpo);
		if( 0 < RecvLineTIMEOUT(msock,resp,sizeof(resp),HELLO_TIMEOUT*1000) ){
			sv1log("MASTER[%d] says(1): %s",mx,resp);
			strcpy(Hello,resp);
			scanHelloVer(Hello,AVStr(MediatorVer));
			nHello++;
			newver = 1;
		}else{
	sv1log("HELLO negotiation TIMEOUT: OLD version MASTER before 2.0 ?\n");
			strcpy(MediatorVer,"1");
			newver = 0;
		}
	}

	if( strncmp(D_SERVER,"https:",6) == 0 )
	if( vercmp(MediatorVer,"3.0.4") < 0 ){
		CStr(buff,1024);
		strcpy(buff,D_SERVER+6);
		sprintf(D_SERVER,"tcprelay:%s",buff);
		sv1log("#### https -> %s\n",D_SERVER);
	}
	else
	if( vercmp(MediatorVer,"5.3.5") < 0 ){
		CStr(buff,1024);
		strcpy(buff,D_SERVER+6);
		sprintf(D_SERVER,"http:%s",buff);
		sv1log("#### https -> %s\n",D_SERVER);
	}

	relayInput(Conn,mfpo,msock,cache_only,relay_input,1);

	if( newver ){
	getresp:
		if( RecvLineTIMEOUT(msock,resp,sizeof(resp),CON_TIMEOUT*1000) <= 0 ){
			sv1log("MASTER closed\n");
			rcode = -1;
		}else{
			sv1log("MASTER[%d] says(2): %s",mx,resp);
			rcode = atoi(resp);
			if( *resp == '6' )
				rcode = -rcode;

			if( isHelloRequest(resp) ){
				if( 1 < ++nHello )
				sv1log("#### got duplicate HELLO response.\n");
				strcpy(Hello,resp);
				goto getresp;
			}
		}
	}
	fclose(mfpo);

	if( reuse ){
		if( Hello[0] )
			scanHelloVer(Hello,AVStr(MediatorVer));

		if( strcmp(version,MediatorVer) != 0 ){
			sv1log("#### MASTER version [%s]->[%s]\n",
				version,MediatorVer);
			set_masterenv(mx,MediatorVer,"");
		}
	}

	if( rcode < 0 )
		return rcode;

	if( 0 <= mx && rcode == 200 )
		set_masterenv(mx,MediatorVer,D_SERVER);

EXIT:
	insert_FMASTER(Conn,msock);
	return 0;
}

void setToProxy(Connection *Conn,PCStr(proto),PCStr(host),int port)
{
	toProxy = 1;
	strcpy(GatewayProto,proto);
	strcpy(GatewayHost,host);
	GatewayPort = port;
}

int DELEGATE_forward(Connection *Conn,PCStr(proto),PCStr(dsthost),int dstport,PCStr(srchost),const char **rproto,const char **rhost,int *rport,const char **rpath);
int forwardit(Connection *Conn,int fromC,int relay_input)
{	CStr(clnt,128);
	int svaddr,claddr;
	int forw;
	const char *proto;
	const char *host;
	const char *path;
	int port;
	int msock;

	if( Conn->co_mask & CONN_NOPROXY )
		return 0;

	if( MO_ProxyHost[0] != 0 && MO_ProxyPort != 0 ){
		SetStartTime();
		msock = connectToUpper(Conn,"PROXYmo",
			iSERVER_PROTO,MO_ProxyHost,MO_ProxyPort);
		if( 0 < msock ){
			sv1log("PROXY=\"%s:%d\" by MountOption\n",
				MO_ProxyHost,MO_ProxyPort);
			FromS = ToS = msock;
host = MO_ProxyHost;
port = MO_ProxyPort;
			setToProxy(Conn,iSERVER_PROTO,host,port);
			return 1;
		}
	}

/* getpeerName(fromC,clnt,PN_HOST); */
if( getClientHostPort(Conn,AVStr(clnt)) == 0 )
	strcpy(clnt,"?");

	forw = DELEGATE_forward(Conn,DFLT_PROTO,DFLT_HOST,DFLT_PORT,clnt,&proto,&host,&port,&path);
	if( forw == 0 )
		return 0;

	if( CTX_findInPath(Conn,host,port) ){
		sv1log("don't make PROXY loop for %s:%d\n",host,port);
		return 0;
	}

	sv1log("ROUTE: %s://%s:%d/%s\n",proto,host,port,path);
	SetStartTime();
	if( streq(proto,"socks") ){
		msock = connectViaSocksX(Conn,host,port,path,DST_HOST,DST_PORT);
		if( 0 <= msock ){
			ConnType = 's';
			FromS = ToS = msock;
			return forw;
		}
		return 0;
	}
	msock = connectToUpper(Conn,"Forward",proto,host,port);
	if( 0 <= msock ){
		strcpy(GatewayProto,proto);
		GatewayPath = stralloc(path);
		FromS = ToS = msock;

		if( streq(proto,"http")
		 || streq(proto,"ftp")
		 || streq(proto,"telnet")
		){
			setToProxy(Conn,proto,host,port);
		}
		else /* if( streq(proto,"delegate")) */
		{
			if( connect_master(Conn,-1,msock,0,relay_input) == 0 )
				toMaster = 1;
			else{
				close(msock);
				FromS = ToS = msock = -1;
			}
		}
	}
	return forw;
}

extern double CFISTAT_TIMEOUT;
int ConnectViaVSAP(Connection *Conn,int relay_input);
int open_master(Connection *Conn,int try_direct,PCStr(server),int svport,int sendhead,int relay_input);
void poll_filterctls(Connection *Conn,int timeout);

static int connect_to_server(Connection *Conn,PCStr(proto),PCStr(host),int port, int fromC,int toC, int relay_input)
{	int svsock;
	double Start;

	poll_filterctls(Conn,(int)CFISTAT_TIMEOUT*1000);

	FromS = ToS = svsock = -1;
	FromSX = -1;
	toMaster = 0;
	Start = Time();

	/* internal protocol */
	if( port == 0 )
		return -1;

	if( isMYSELF(host) && strcaseeq(proto,"smtp") )
		return -1;

	if( strcaseeq(proto,"dump") || strcaseeq(proto,"pgps") )
		return -1;

	if( !service_permitted(Conn,proto) )
		return -1;

	setupConnect(Conn); /* setup the order of connection types */
	ProcTitle(Conn,"%s://%s/",DST_PROTO,DST_HOST);
	set_SRCIF(Conn,proto,host,port);

	SetStartTime();

	if( !streq(proto,"http")
	 && !streq(proto,"https")
	 && !tryProxyOnly
	 && connectToCache(Conn,"",&svsock) ){
		svsock = setServ(Conn,svsock);
		ConnType = 'R';
		goto CONNECTED;
	}else
	if( tryCONNECT(Conn,relay_input,&svsock) ){
		svsock = setServ(Conn,svsock);
		/* ConnType has been set in tryCONNECT() */
		goto CONNECTED;
	}else{
		if( 0 <= (svsock = ConnectViaICP(Conn,NULL)) ){
			if( toMaster
			 && connect_master(Conn,-1,svsock,0,relay_input) != 0 ){
				close(svsock);
			}else{
				svsock = setServ(Conn,svsock);
				ConnType = 'i';
				goto CONNECTED;
			}
		}

		if( forwardit(Conn,fromC,relay_input) ){
			svsock = ToS;
			if( toProxy )
				ConnType = 'p';
			else	ConnType = 'm';
			goto CONNECTED;
		}
		if( tryProxyOnly ){
			Verbose("tryProxyOnly:NO PROXY/MASTER\n");
			return -1;
		}

		if( 0 <= (svsock=open_master(Conn,1,host,port,1,relay_input))){
			svsock = setServ(Conn,svsock);
			ConnType = 'm';
			goto CONNECTED;
		}

		if( 0 <= (svsock = ConnectViaSSLtunnel(Conn,host,port)) ){
			svsock = setServ(Conn,svsock);
			ConnType = 'h';
			goto CONNECTED;
		}

		if( 0 <= (svsock = ConnectViaVSAP(Conn,relay_input)) ){
			ConnType = 'v';
			goto CONNECTED;
		}

		if( 0 <= (svsock = ConnectViaSocks(Conn,relay_input)) ){
			ConnType = 's';
			goto CONNECTED;
		}

		if( 0 <= (svsock=ConnectToServer(Conn,relay_input)) ){
			ConnType = 'd';
			goto CONNECTED;
		}

		/* V8.0.0 CONNECT=...,s,d by default
		if( 0 <= (svsock = ConnectViaSocks(Conn,relay_input)) ){
			ConnType = 's';
			goto CONNECTED;
		}
		*/
	}
	sv1log("ERROR: cannot connect to %s://%s:%d - %d\n",
		proto,host,port,svsock);
FAILED:
	return svsock;

CONNECTED:
	switch( ConnType ){
		case 'd':
		case 's':
			forward_RIDENT(Conn,ConnType,svsock,NULL);
			break;
	}
	ServConnTime = Time();

	/* Currently, ToServ is supported only in HTTP */
	if( ToServ && !streq(proto,"http") )
		fflush(ToServ);
	ConnDelay = ServConnTime - Start;

	return svsock;
}

void insert_FSERVER(Connection *Conn,int fromC);
int connect2server(Connection *Conn,PCStr(proto),PCStr(host),int port)
{	int sock;

	Conn->from_myself = 1;
	set_realserver(Conn,proto,host,port);
	sv1log("#### %s://%s:%d ...\n",proto,host,port);
	sock = connect_to_server(Conn,proto,host,port,-1,-1,0);
	sv1log("#### %s://%s:%d = %d\n",proto,host,port,sock);
	insert_FSERVER(Conn,-1);
	return sock;
}

/*
 *	DFLT_... should be replaced by DST_...
 */
extern int CONNERR_CANTRESOLV;
int connect_to_servX(Connection *Conn, int fromC,int toC, int relay_input, int do_filter)
{	int sock;

	CONNERR_CANTRESOLV = 0;
	sock = connect_to_server(Conn,DFLT_PROTO,DFLT_HOST,DFLT_PORT,
		fromC,toC,relay_input);

	if( sock < 0 && tryProxyOnly /* && no-other-alternative-left */ )
		return sock;

	if( ConnType != 'N' )
	if( sock < 0 ){
		const char *reason;
		CStr(server,1024);
		CStr(shost,256);
		int sport;

		if( ConnError == 0 ){
			if( CONNERR_CANTRESOLV ){
				ConnError |= CO_CANTRESOLV;
			}
			ConnError |= CO_NOROUTE;
		}
		reason = "?";
		if( ConnError & CO_CANTRESOLV ) reason = "unknown";
		if( ConnError & CO_TIMEOUT    ) reason = "timeout";
		if( ConnError & CO_REFUSED    ) reason = "refused";
		if( ConnError & CO_UNREACH    ) reason = "unreach";
		if( ConnError & CO_NOROUTE    ) reason = "noRoute";

		sport = getClientHostPort(Conn,AVStr(shost));
		HostPort(AVStr(server),DST_PROTO,DST_HOST,DST_PORT);
		daemonlog("F","%s: %s:%d %s %s://%s (%s)\n",
		"E-C: Can't connect",shost,sport,"=>",DST_PROTO,server,reason);
	}

	willSTLS_SV(Conn);

	if( do_filter )
	insert_FSERVER(Conn,fromC);
	return sock;
}
int connect_to_serv(Connection *Conn, int fromC,int toC, int relay_input)
{
	return connect_to_servX(Conn, fromC,toC, relay_input, 1);
}
/*
int connect_to(PCStr(proto),PCStr(host),int port)
{	Connection ConnBuff,*Conn = &ConnBuff;
	int sv;

	Conn->from_myself = 1;
	sv = connect_to_server(Conn,proto,host,port, -1,-1,0);
	return sv;
}
*/

void DG_relayInput(Connection *Conn,int fd);
int openMaster(Connection *Conn,int svsock,PCStr(server),int relay_input)
{	int msock,sv[2];
	FILE *mfp;

	if( svsock == -1 )
	if( 0 <= (msock = open_master(Conn,0,server,0,1,relay_input) ) )
		return msock;

	if( svsock != -1 && toMaster ){
		if( relay_input )
			DG_relayInput(Conn,svsock);
		return  svsock;
	}

	Socketpair(sv);
	if( Fork("openMaster") == 0 ){
		close(sv[1]);
		sv1log("PRIVATE MASTER[%d/%d] svsock=%d\n",sv[0],sv[1],svsock);
		DFLT_HOST[0] = 0;
		clear_DGconn(Conn);
		execGeneralist(Conn,sv[0],sv[0],svsock);
		Finish(0);
	}
	close(sv[0]);
	mfp = fdopen(dup(sv[1]),"w");
	relayInput(Conn,mfp,sv[1],0,relay_input,1);
	fclose(mfp);
	return sv[1];
}

extern int FromTeleport;
int fromTunnel(Connection *Conn,int sock)
{
	/*
	sv1log("#### fromTunnel(%d) ? proto=%s FromTeleport=%d\n",sock,
		iSERVER_PROTO,FromTeleport);
	*/
	if( streq(iSERVER_PROTO,"tunnel1") )
		return 1;
	return 0;
}
int toTunnel(Connection *Conn)
{
	return toMaster == 2;
}
int connectViaTunnel(Connection *xConn,PCStr(proto),PCStr(host),int port)
{	Connection ConnBuf, *Conn = &ConnBuf;
	int msock;
	CStr(req,1024);

	*Conn = *xConn;
	sprintf(D_SERVER,"%s://%s:%d",proto,host,port);
	msock = open_master(Conn,0,host,port,1,0);
	if( 0 <= msock && toMaster != 2 ){
		sv1log("[%d] not viaTunnel\n",msock);
		close(msock);
		msock = -1;
	}
	return msock;
}

int teleportOpen(int mx,PCStr(master),int mport,PCStr(target_server),int closefd);
int DELEGATE_Filter(int mi,PCStr(dstproto),PCStr(dsthost),int dstport);
int DELEGATE_master(int ms,const char **master,int *mport,int *teleport,int *cacheonly);

int open_master(Connection *Conn,int try_direct,PCStr(server),int svport,int sendhead,int relay_input)
{	int msock;
	int mi,mx;
	const char *master;
	int no_socks;
	int mport;
	int tport;
	int cache_only;
	const char *hp;

	if( Conn->co_mask & CONN_NOMASTER )
		return -1;

	if( MasterIsPrivate && ACT_GENERALIST )
		return -1;

	SetStartTime();

	if( hp = strchr(server,'@') )
		server = hp + 1;

	no_socks = MasterIsPrivate;

	msock = -1;

	for(mi = 0; ;mi++){
		if( (mx = DELEGATE_master(mi,&master,&mport,&tport,&cache_only)) == 0 ){
			msock = -1;
			goto EXIT;
		}

		if( master == NULL )
			continue;/* Teleport */

		if( cache_only ){
			if( DontReadCache )
				continue;
			if( !withcache(DST_PROTO) )
				continue;
		}

		if( DELEGATE_Filter(mx,DST_PROTO,server,svport) != 0 )
			continue;

		if( CTX_findInPath(Conn,master,mport) ){
			sv1log("don't make MASTER loop for %s:%d\n",
				master,mport);
			continue;
		}

		if( streq(master,"*") ){
			if( !try_direct )
				continue;

			msock = ConnectToServer(Conn,relay_input);
			if( 0 <= msock )
				goto EXIT;
		}

		if( tport )
			msock = teleportOpen(mx,master,mport,
				server,ClientSock);
		else
		if( !no_socks )
			msock = connectToUpper(Conn,"MasterOpen","delegate",
				master,mport);
		else	msock = connectServer("MasterOpen","delegate",
				master,mport/*,no_socks*/);

		if( 0 <= msock ){
			if( !sendhead ){
				if( tport ) toMaster = 2; else
				toMaster = 1;
				break;
			}

			if( connect_master(Conn,mx,msock,cache_only,relay_input) == 0 ){
				if( tport ) toMaster = 2; else
				toMaster = 1;
				break;
			}
			close(msock);
			msock = -1;
		}
	}
EXIT:
	if( msock < 0 && withTmpMaster() ){
		msock = connectServer("MO-MasterOpen","delegate",
			MO_MasterHost,MO_MasterPort/*,no_socks*/);
		if( 0 <= msock ){
			if( connect_master(Conn,-1,msock,0,relay_input) == 0 )
				toMaster = 1;
		}
	}

	if( 0 <= msock )
		set_keepalive(msock,1);
	else{
		/* something wrong in private master...  (may be replaced)
		 */
		if( myPrivateMASTER != 0 )
			BREAK_STICKY = 1;
	}
	return msock;
}

void initConnected(Connection *Conn,int svsock,int relay_input);
int ConnectViaVSAP(Connection *Conn,int relay_input)
{	int sock;
	CStr(sockname,256);
	CStr(peername,256);

	sockname[0] = 0;
	sprintf(peername,"%s:%d",DST_HOST,DST_PORT);
	if( 0 <= (sock = CTX_VSAPconnect(Conn,AVStr(sockname),AVStr(peername))) )
		initConnected(Conn,sock,relay_input);

	return sock;
}

void scan_OVERRIDE(Connection *Conn,PCStr(ovparam))
{	CStr(master,256);
	CStr(port,256);

	Xsscanf(ovparam,"%[^:]:%[^:]:%s",AVStr(master),AVStr(port),AVStr(D_OVERRIDE));
}

static void lfprintf(FILE *fp,PCStr(fmt),...)
{	CStr(line,4096);
	int wc = -1;
	VARGS(7,fmt);

	if( fp != NULL )
		wc = fprintf(fp,fmt,va[0],va[1],va[2],va[3],va[4],va[5],va[6]);

	strcpy(line,"<= ");
	Xsprintf(TVStr(line),fmt,va[0],va[1],va[2],va[3],va[4],va[5],va[6]);
	Verbose("%s",line);
}

static void relayInput(Connection *Conn,FILE *mfp,int msock,int cache_only,int relay_input,int doflush)
{	CStr(mhostport,256);
	CStr(me,256);
	CStr(dstaddr,512);
	int hi;

	getpeerName(msock,AVStr(mhostport),PN_HOSTPORT);
	sv1log("forwarding to [%d] %s://%s\n",msock,"delegate",mhostport);
	gethostnameIF(AVStr(me),sizeof(me));

	/* this should done before any name resolution occures */
	if( make_HOSTS(AVStr(dstaddr),DST_HOST,1) )
		lfprintf(mfp,"HOSTS %s\n",dstaddr);

			     lfprintf(mfp,"MEDIATOR %s\r\n",me);
	if(D_RPORT[0])       lfprintf(mfp,"RPORT %s\r\n",  D_RPORT);
	if(D_FTPHOPS )	     lfprintf(mfp,"FTPHOPS %d\r\n",D_FTPHOPS);
	if(D_SERVER[0])      lfprintf(mfp,"SERVER %s\r\n", D_SERVER);
	if(D_REQUESTtag.ut_addr)
			     lfprintf(mfp,"REQUEST %s\r\n",D_REQUESTtag.ut_addr);
	if(D_FROM[0]  )      lfprintf(mfp,"FROM %s\r\n",   D_FROM);
	if(D_USER[0]  )      lfprintf(mfp,"USER %s\r\n",   D_USER);
	if(D_PATH[0]  )      lfprintf(mfp,"PATH %s\r\n",   D_PATH);
	if(D_EXPIRE[0])      lfprintf(mfp,"EXPIRE %s\r\n", D_EXPIRE);
	if(D_GTYPE[0] )      lfprintf(mfp,"LOCAL-GTYPE %c\r\n",D_GTYPE[0]);
	if(never_cache(Conn))lfprintf(mfp,"CACHE DISABLE\r\n");
	if(DontReadCache)    lfprintf(mfp,"CACHE DONT_READ\r\n");
	if(DontWaitCache)    lfprintf(mfp,"CACHE DONT_WAIT\r\n");
	if(cache_only)       lfprintf(mfp,"CACHE ONLY %d\r\n",CacheLastMod);
	if(CLIENTS_PROXY[0]) lfprintf(mfp,"CLIENTS-PROXY %s\r\n",CLIENTS_PROXY);
	if(D_OVERRIDE[0])    lfprintf(mfp,"OVERRIDE %s\r\n",D_OVERRIDE);

	if( headerX ){
		for( hi = 0; hi < headerX; hi++ )
	        	lfprintf(mfp,"%s",headerB[hi]);
	}
	lfprintf(mfp,"\r\n");

	if(relay_input && inputsX ){
		for( hi = 0; hi < inputsX; hi++ )
			lfprintf(mfp,"%s",inputsB[hi]);
/*
Verbose("RelayInput: <= %d bytes\n%s\n",strlen(D_inputs),D_inputs);
*/
	}
	if( mfp != NULL && doflush )
		fflush(mfp);
}

void setConnStart(Connection *Conn){ CONN_START= Time(); }
void setConnDone(Connection *Conn){ CONN_DONE = Time(); }


/*
 * DELEGATE=host:port:"callback-protoList"
 * it resticts protocols to be redirected with "/-_-" notation.
 * it should be obsoleted by MOUNT="/-_-* * proto="!{callback-protoList}"
 */
static scanListFunc callback1(PCStr(proto))
{	int callback;
	int si;

	callback = 1;
	if( *proto == '-' ){
		callback = 0;
		proto++;
	}
	if( strcaseeq(proto,"all") ){
		for( si = 1; services[si].s_name; si++ )
			services[si].s_nocallback = !callback;
	}else
	if( si = servicex(proto) )
		services[si].s_nocallback = !callback;
	else	sv1log("CALLBACK: %s ?\n",proto);
	return 0;
}
void scan_CALLBACK(PCStr(protolist))
{	int si;

	for( si = 1; services[si].s_name; si++ )
		services[si].s_nocallback = 1;
	scan_commaList(protolist,0,scanListCall callback1);
}
int callback_it(PCStr(proto))
{	int si;

	if( si = servicex(proto) )
		return !services[si].s_nocallback;
	return 0;
}
