/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994-2000 Yutaka Sato and ETL,AIST,MITI
Copyright (c) 2001-2004 National Institute of Advanced Industrial Science and Technology (AIST)

Permission to use this material for evaluation, copy this material for
your own use, and distribute the copies via publically accessible on-line
media, without fee, is hereby granted provided that the above copyright
notice and this permission notice appear in all copies.
AIST MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	http.c (HTTP/1.0 proxy)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	940316	created
	99Aug	restructured
//////////////////////////////////////////////////////////////////////#*/
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include "delegate.h"
#include "fpoll.h"
#include "file.h"
#include "auth.h"
#include "proc.h"
#include "filter.h"
#include "http.h"
#include "vsignal.h"

int HTTP_STARTTLS_withCL(Connection *Conn,FILE *fc,FILE *tc);
int insertTLS_CL(Connection *Conn,int client,int server);
typedef const char *(*scanMetaFuncP)(Connection *Conn,PCStr(attr),PVStr(cont),PCStr(tagp),PVStr(contp),PCStr(nextp));
void scan_metahttp(Connection*ctx,PVStr(line),scanMetaFuncP func);

#define F_AccEncodeX	"X-Q-Accept-Encoding:"

int HttpGopher(Connection *Conn,int vno,int svsock,PCStr(server),int iport,int gtype,PCStr(path));
int HttpWais(Connection *Conn,int vno,int sv,PCStr(server),int iport,PCStr(path));
int service_whois(Connection *Conn);

int getMountExpires(Connection *Conn,PVStr(date),int size);
int HTTP_setRetry(Connection *Conn,PCStr(req),int rcode);
int HttpNews(Connection *Conn,int vno,FILE *fc,int sv,PCStr(host),int port,PCStr(groupanumsearch),PCStr(req),xPVStr(user),PVStr(pass),int KeepAlive,int *stcodep);
int httpftp_cached(Connection *Conn,FILE *tc,PCStr(user),PCStr(pass),PCStr(host),int port,PCStr(path),int *stcodep);
int httpftp(Connection *Conn,FILE *fc,FILE *tc,PCStr(ver),PCStr(method),int svsock,PCStr(auth),PCStr(uuser),PCStr(upass),PCStr(host),int port,int gtype,PCStr(path),int *stcodep);

void http_log(Connection *Conn,PCStr(proto),PCStr(server),int iport,PCStr(req),int rcode,PCStr(ctype),int rsize,int mtime,double ctime,double dtime);
int CTX_cache_remove(Connection *ctx,PCStr(proto),PCStr(host),int port,PCStr(path));

/*
int KeepAliveWithProxyClient = 0;
*/
#define KeepAliveWithProxyClient (HTTP_opts&HTTP_NOKEEPALIVEPROXY)==0
int HTTP11_toserver = 1;
int HTTP11_toclient = 1;
int HTTP11_clientTEST = 0;
#define CHUNKED_VER "6.0.0" /* DeleGate version when "chunked" is supported */
#define ENCODE_THRU	"-thru"
#define ENCODE_THRUGZIP	"-thrugzip"
const char *HTTP_accEncoding = ENCODE_THRUGZIP;
const char *HTTP_genEncoding = "gzip";

int HTTP09_reject = 0;

int HTTP_noXLocking = 1;
int HTTP_ignoreIf = 0;
int HTTP_warnApplet = 0;
int HTTP_rejectBadHeader = 0;
int HTTP_cacheopt = 0;

#define clntClose	HTTP_clntClose
#define getFieldValue(str,fld,buf,siz) getFieldValue2(str,fld,buf,siz)
#define getFV(str,fld,buf)             getFieldValue2(str,fld,AVStr(buf),sizeof(buf))

extern int MAX_BUFF_SOCKRECV;
extern int MAX_BUFF_SOCKSEND;
extern int RES_CACHE_DISABLE;
extern int IO_TIMEOUT;
extern int CACHE_TAKEOVER;
extern int TAGCONV_KILL;
extern int TAGCONV_JAVA;
extern int TAGCONV_APPLET;
extern int TAGCONV_nKILL;
extern int URICONV_nFULL;
extern int URICONV_nPARTIAL;
extern int DELEGATE_LastModified;

/*
 *	Connection: Keep-Alive
 */
int HTTP_CKA_PERCLIENT      = 8;
int HTTP_CKA_MAXREQ         = 10;
double HTTP_TOUT_CKA        = 5;
double HTTP_TOUT_CKA_MARGIN = 2;
int HTTP_CKA_CFI = 0;

double HTTP_TOUT_RESPLINE = 0;
double HTTP_WAIT_BADSERV = 3; /* max period to care bad protocol server */

double HTTP_WAIT_REQBODY = 30;
double HTTP_TOUT_IN_REQBODY = 15;
double HTTP_TOUT_BUFF_REQBODY = 5;
double HTTP_TOUT_QBODY = 120;

int HTTP_MAX_BUFF_REQBODY = 1024*1024;

int HTTP_MAXHOPS = 20;
int HTTP_MAX_REQLINE = (4*1024);
int HTTP_MAX_REQHEAD = (12*1024);
int HTTP_GW_MAX_REQLINE = 512;

double HTTP_TOUT_PACKINTVL = 0.30;

#define protoGopher(proto)	strcaseeq(proto,"gopher")

typedef struct {
	int	 on;
	int	 pid;
  const	char	*cpath;
	FILE	*cachefp;
	FILE	*tc;
     Connection *Conn;
} relaying;

static struct {
	int	 g_dontTruncate; /* keep the cache in the current state */
	relaying g_relaying;
  const	char	*g_where;
	int	 g_nsigPipe;
	int	 g_exiting;
} HTTP_current;

#define Relaying	HTTP_current.g_relaying
#define DontTruncate	HTTP_current.g_dontTruncate
#define Where		HTTP_current.g_where
#define nsigPIPE	HTTP_current.g_nsigPipe
#define exiting		HTTP_current.g_exiting

static void abortCache()
{	FILE *cachefp;

	cachefp = Relaying.cachefp;
	if( cachefp == NULL )
		return;

	if( Relaying.Conn && Relaying.cpath )
		stopDistribution(Relaying.Conn,cachefp,Relaying.cpath);

	/* discards the half done cache file */
	if( !DontTruncate ){
		sv1log("CACHE discards half written cache.\n");
		fflush(cachefp);
		Ftruncate(cachefp,0,0);
		fseek(cachefp,0,0);
	}
}
static void sigTERM(int sig)
{	int now;

	signal(sig,sigTERM);
	now = time(0);
	if( exiting ){
		sv1log("#### duplicate sigTERM in %d seconds\n",now-exiting);
		if( exiting && now-exiting < 10 )
			return;
		else	_Finish(0);
	}
	exiting = now;

	if( Relaying.on ){
		sv1log("HTTP SC got sigTERM(%d) %x\n",sig,Relaying.cpath);
		abortCache();
		if( Relaying.tc != NULL )
			fcloseLinger(Relaying.tc);
		Finish(0); /* flush outputs and exit */
	}else{
		sv1log("HTTP CS got sigTERM(%d)\n",sig);
		_Finish(0);
	}
}
static void setRelaying(Connection *Conn,FILE *tc,FILE *cachefp,PCStr(cpath))
{
	if( Conn == NULL ){
		Relaying.on = 0;
	}else{
		Relaying.on = 1;
		Relaying.pid = getpid();
		Relaying.tc = tc;
		Relaying.cachefp = cachefp;
		Relaying.cpath = cpath;
		Relaying.Conn = Conn;
		Vsignal(SIGTERM,sigTERM);
	}
}
static void abortHTTP(PCStr(msg))
{
	sv1log("#### EMERGENCY EXIT (%s)\n",msg);
	abortCache();
	_Finish(-1);
}
static void sigPIPE(int sig)
{
	signal(SIGPIPE,SIG_IGN); /* sv1log may cause SIGPIPE ... */
	if( nsigPIPE++ % 10 == 0 )
		sv1log("## got SIGPIPE [%d] in HTTP: %s\n",
			nsigPIPE,Where?Where:"");
	signal(SIGPIPE,sigPIPE);
	if( 10 < nsigPIPE ){
		/* to avoid a rush of SIGPIPE ... */
		msleep(10);
	}
}
static void setClientEOF(Connection *Conn,FILE *tc,PCStr(fmt),...)
{	CStr(where,256);
	VARGS(8,fmt);

	ClientEOF = 1;
	if( fmt ){
		sprintf(where,fmt,VA8);
		sv1log("ClientEOF: %s\n",where);
	}
}
static int checkClientEOF(Connection *Conn,FILE *tc,PCStr(where))
{	const char *conn_stat;

	if( ClientEOF )
		return ClientEOF;
	if( Conn->from_myself )
		return 0;

	if( ClientSock < 0 ){
		/* maybe this is a internal ResponseFilter process on Win32
		 * spawned without inherited Client-Socket ...
		 */
		return 0;
	}

	if( IsConnected(ClientSock,&conn_stat) )
		return 0;

	if( where ){
		clntClose(Conn,"p:premature client EOF (%s)",where);
		sv1log("## premature client close: %s (%s)\n",where,conn_stat);
	}

	detachFile(tc);
	setClientEOF(Conn,tc,where);

	return 1;
}
static void fclosesTIMEOUT(FILE *ff,FILE *ft)
{	int df,dt;

	df = fileno(ff);
	dt = fileno(ft);

	fcloseTIMEOUT(ff);
	if( df != dt )
		fcloseTIMEOUT(ft);
	else	fclose(ft);
}

static void UAspecific(Connection *Conn,PCStr(UA),int direct)
{	const char *dp;

	if( dp = strstr(UA,"MSIE ") )
		appletFilter = 1;

	if( direct ){
		if( dp = strstr(UA,"MSIE ") ){
			if( dp[5] < '3'
			 || strncmp(dp+5,"3.0",3) == 0 && atoi(dp+8) < 1 )
				clntClose(Conn,"o:old MSIE");
		}else
		if( dp = strstr(UA,"Mozilla/") ){
			if( dp[8] < '2' )
				FlushHead = 50;
			else
			if( dp[8] < '3' && WillKeepAlive )
				FlushIfSmall = 1;
		}
	}

	if( dp = strstr(UA,"MSIE ") )
	if( dp[5] < '3' || strncmp(dp+5,"3.0",3)==0 && atoi(dp+8) < 1 )
		SimpleContType = 1;

	if( dp = strstr(UA,"MSIE ") )
	if( REQ_URL[0] != '/' ) /* acting as an origin HTTP server */
	if( URL_toMyself(Conn,REQ_URL) == NULL )
		ProxyAuth = 1;

	if( dp = strstr(UA,"Mosaic") )
	if( dp = strstr(dp,"/") )
	if( strcmp(dp+1,"2.6") < 0 )
		SimpleContType = 1;

	if( dp = strstr(UA,"Lynx") )
	if( dp = strstr(dp,"/") )
		SimpleContType = 1;
}

static
void getFileUID(PVStr(fileId),PCStr(path)/*,char *peerver*/)
{	CStr(host,256);
	CStr(fileid,URLSZ);
	const char *addr;

	/* if the file is on NFS, should use the name of NFS server */
	GetHostname(AVStr(host),sizeof(host));

	/* if( peerver < 5.3.1 ) */
		sprintf(fileId,"%s:%s",gethostaddr(host),path);
	/*
	else{
		strcpy(fileid,"file://");
		strcat(fileid,host);
		strcat(fileid,"/");
		strcat(fileid,path);
		toMD5(fileid,fileId);
		sv1log("%s = %s\n",fileId,fileid);
	}
	*/
}
static void getCacheID(PVStr(cid),PCStr(path))
{
	sprintf(cid,"%x/%x",File_ctime(cachedir()),File_ctime(path));
}
#define withConversion(Conn,checkxf) withConversionX(Conn,checkxf,0)
static int withConversionX(Connection *Conn,int checkxf,int woURI)
{
	if( !woURI ){
	/* URL CONVERSIONS */
/*
	if( DO_DELEGATE || IsMounted || URICONV_nFULL || URICONV_nPARTIAL )
URICONV_nPARTIAL alone does not indicate Conversion...
*/
	if( DO_DELEGATE || IsMounted || URICONV_nFULL )
		return 1;

	if( NOJAVA || TAGCONV_nKILL )
		return 1;

	/* CHARACTER CODE CONVERSION */
	if( CCXactive(CCX_TOCL) || CTX_cur_codeconvCL(Conn,VStrNULL) )
		return 1;

	/* HTML CONVERSIONS */
	}

	/* EXTERNAL FILTERS */
	if( checkxf && Conn->xf_filters )
		return 1;

	return 0;
}
/*
 * Check if some setup of proxy for some conversion have changed
 * after the client cached the data.  If so, whole data should be sent
 * as the response regardless of the modification of original data.
 * So ignore If-Modified-Since to get the body if cache is not.
 * and ignore 304 Not Modified response when the cache is.
 */
static int forceBodyResponse(Connection *Conn)
{
	if( !withConversion(Conn,1) )
		return 0;

	if( 0 < ClntIfModClock )
	if( ClntIfModClock < DELEGATE_LastModified ){
		sv1log("DeleGated is Modified after the data: %d > %d\n",
			DELEGATE_LastModified,ClntIfModClock);
		return 1;
	}
	return 0;
}
static const char *CacheID;
static int LockedByC(Connection *Conn,PCStr(cpath),FILE *fc)
{	CStr(fileId,URLSZ);

	if( cpath == NULL || cpath[0] == 0 )
		return -1;

	if( CacheID ){
		getCacheID(AVStr(fileId),cpath);
		if( isinList(CacheID,fileId) ){
			goto LOCKED;
		}
	}

	if( LockedByClient == 0 )
		return 0;

	getFileUID(AVStr(fileId),cpath);
	if( streq(LockedByClient,fileId) ){
LOCKED:
		sv1log("--- cache is locked by client: %s\n",cpath);
		DontUseCache = 1;
		DontReadCache = DontWriteCache = DontWaitCache = 1;
		return 1;
	}
	return 0;
}
/*
 * generate `If-Modified-Since: cdate' if not specified by the client.
 */
static void genIfModified(Connection *Conn,FILE *cachefp,PCStr(cpath),int cdate)
{	CStr(scdate,64);
	CStr(mod,64);
	int lastmod;

	if(forceBodyResponse(Conn)
	 && cachefp == NULL
	 && !LockedByC(Conn,cpath,NULL)){
		/* need data anyway to produece the body response regardless
		 *  of the modified date, so ignore and don't produce If-Mod.
		 */
		sv1log("ignore and don't produce If-Modified-Since\n");
		return;
	}
	if(cpath==NULL||cdate==-1||cachefp==NULL||DontUseCache||DontReadCache){
		/* local cache is not useful, pass Client's request as is */
		if( ClntIfMod[0] )
			RFC822_addHeaderField(AVStr(REQ_FIELDS),ClntIfMod);
		return;
	}

	/*
	 * local cache file is available
	 */
	lastmod = HTTP_getLastModInCache(AVStr(scdate),sizeof(scdate),cachefp,cpath);

	if( ClntIfMod[0] && lastmod <= ClntIfModClock ){
		RFC822_addHeaderField(AVStr(REQ_FIELDS),ClntIfMod);
		CacheLastMod = ClntIfModClock;
		return;
	}

	if( lastmod == 0 )
		lastmod = HTTP_genLastMod(AVStr(scdate),sizeof(scdate),cachefp,cpath);
	CacheLastMod = lastmod;

	sprintf(mod,"If-Modified-Since: %s\r\n",scdate);
	RFC822_addHeaderField(AVStr(REQ_FIELDS),mod);
	Verbose("+ %s",mod);
}
static void setReferer(Connection *Conn,PCStr(proto),PCStr(host),int port,PCStr(req),Referer *referer,PVStr(refbuf))
{
	const char *bp;
	const char *up;
	refQStr(rp,refbuf); /**/

	referer->r_cType = 0;
	referer->r_tagctx.r_curscript[0] = 0;
	referer->r_tagctx.r_curstyle[0] = 0;
	referer->r_tagctx.r_curtag[0] = 0;

	referer->r_my.u_hostport = rp;
	HTTP_ClientIF_HP(Conn,AVStr(rp));
	rp += strlen(rp) + 1;

	referer->r_my.u_proto = CLNT_PROTO;
	referer->r_my.u_host = rp;
	referer->r_my.u_port = HTTP_ClientIF_H(Conn,AVStr(rp));
	rp += strlen(rp) + 1;

	if( REMOTE_HOST[0] ){
		proto = REMOTE_PROTO;
		host = REMOTE_HOST;
		port = REMOTE_PORT;
	}

	referer->r_sv.u_proto = rp;
	strcpy(rp,proto);
	rp += strlen(rp) + 1;

	referer->r_sv.u_host = rp;
	strcpy(rp,host);
	rp += strlen(rp) + 1;

	referer->r_sv.u_port = port;

	referer->r_sv.u_hostport = rp;
	HostPort(AVStr(rp),proto,host,port);
	rp += strlen(rp) + 1;

	referer->r_sv.u_method = rp;
	up = wordscanX(req,AVStr(rp),32);
	rp += strlen(rp) + 1;
	
	referer->r_sv.u_path = rp;
	wordscanX(up,AVStr(rp),1024);
	/*if( toProxy )*/
	strip_urlhead(AVStr(rp),VStrNULL,VStrNULL);
	rp += strlen(rp) + 1;

 {	int blen;
	referer->r_sv.u_base = rp;
	up = referer->r_sv.u_path;
	if( *up == '/' )
		up++;
	blen = url_upathbaselen(up,strlen(up));
	Bcopy(up,rp,blen); XsetVStrEnd(AVStr(rp),blen);
	rp += blen + 2;
 }

	referer->r_my.u_path = rp;
	strcpy(rp,Conn->cl_baseurl);
	rp += strlen(rp) + 1;

	referer->r_vb = Conn->my_vbase; /* when BASEURL is a FULL-URL */

	setQStr(referer->r_altbuf,rp,UTail(refbuf)-rp+1);
}

typedef struct {
	Connection *q_Conn;
	int	q_cpid;
	int	q_totalc;
	int	q_rcode;
	int	q_hcode; /* HTTP response code */
	int	q_tsfd;
	int	q_fsfd;

  const	char   *q_proto;
  const	char   *q_site;
	MStr(	q_site_buf,256);
	int	q_port;
  const	char   *q_upath;

	int	q_useCache;
	int	q_expire;
	MStr(	q_cpath,1024);
	FILE   *q_cachefp;
	int	q_cdate;
	int	q_cacheRemove;

	int	q_range[2];
	MStr(	q_accEncoding,32);
	MStr(	q_upgrade,32);
} QueryContext;

#define QX_Conn		QX->q_Conn
#define QX_cpid		QX->q_cpid
#define QX_totalc	QX->q_totalc
#define QX_rcode	QX->q_rcode
#define QX_hcode	QX->q_hcode
#define QX_tsfd		QX->q_tsfd
#define QX_fsfd		QX->q_fsfd

#define QX_proto	QX->q_proto
#define QX_site		QX->q_site
#define QX_site_buf	QX->q_site_buf
/**/
#define QX_port		QX->q_port
#define QX_upath	QX->q_upath

#define QX_useCache	QX->q_useCache
#define QX_expire	QX->q_expire
#define QX_cpath	QX->q_cpath
/**/
#define QX_cachefp	QX->q_cachefp
#define QX_cdate	QX->q_cdate
#define QX_cacheRemove	QX->q_cacheRemove

#define QX_range	QX->q_range
#define QX_accEnc	QX->q_accEncoding
#define QX_upgrade	QX->q_upgrade

/*###################################### RESPONSE */
typedef struct {
	FILE   *t_fp;		/* FILE pointer */
	int	t_fd;		/* file descriptor */
	int	t_EOF;		/* (soft) EOF reached */
	int	t_buffered;	/* bytes in buffer */
	int	t_nready;	/* I/O ready */
	int	t_lastRcc;	/* bytes read in the last */

	int	t_contLeng;	/* Content-Length got / put */
	int	t_contLengGot;	/* Content-Length is got */
	int	t_headTotal;	/* transferred header size */
	int	t_bodyTotal;	/* transferred body size */
	int	t_keepAlive;	/* Connection: keep-alive or HTTP/1.1 */

	int	t_remsize;	/* remaining (input) body size */
	MStr(	t_buffer,IBUFSIZE+1);

	int	t_chunked;	/* is chunked */
	int	t_chunk_ser;	/* serial number of the current chunk */
	int	t_chunk_siz;	/* size of the current chunk */
	int	t_chunk_rem;	/* remaining bytes of the current chunk */
} TransCode;

typedef struct {
	Connection *r_Conn;
	Referer *r_referer;
	int	r_ovw;

	int	r_qWithHeader;
	MStr(	r_qmethod,128);	/* method of the request */
	int	r_reqHEAD;	/* qmethod is HEAD */

   HttpResponse	r_status;		/* decomposed status line */
	MStr(	r_connection,256);	/* Connection: */
	MStr(	r_ctype,256);		/* Content-Type: */
	MStr(	r_ctypeline,256);	/* Content-Type: with parameters */
	MStr(	r_servername,256);	/* Server: */
	MStr(	r_cencoding,256);	/* Content-Encoding: */
	int	r_cencoded;		/* with Content-Encoding: */
	MStr(	r_tencoding,256);	/* Transfer-Encoding: */
	MStr(	r_setCookie,2048);	/* Set-Cookie: */
	MStr(	r_cachecontrol,256);	/* Cache-Control: */
	MStr(	r_lastVia,256);		/* Via: */
	int	r_guessCharset;		/* guessing charset */

	MStr(	r_expires,64);	/* Expires: */
	int	r_lastMod;	/* with Last-Modified: */
	int	r_lastModTime;	/* Last-Modified: */

	int	r_errori;
	int	r_tryKeepAlive;

	int	r_convChar;	/* with character conversion */
	int	r_deEnt;	/* decode char. entitiy encoding &xx; */
	int	r_putPRE;	/* with <PRE> body </PRE> insertion */

	Partf	r_partf;

	int	r_noBody;	/* response without body */
	int	r_inHeader;	/* processing header part of resp. */
	int	r_isText;	/* type of text */
	int	r_isBin;	/* body is binary data */
	int	r_woURI;	/* no URI to be rewriten is included */

	int	r_bodyLines;	/* line# of text body got from server */
	int	r_txtLen;
	int	r_binLen;

	double	r_Start;	/* begining of response relay */
	double	r_Resp1;	/* first response */
	double	r_firstResp;
	double	r_connDelay;

	int	r_nflush;	/* flush count */
	int	r_ninput;
	int	r_noutput;
	int	r_nsigreport;

	int	r_fromcache;
	TransCode r_fsx;	/* transfer coding from server */
	TransCode r_tcx;	/* to client */
	int	r_xrdLen;	/* content length after gunzip */

  const	char   *r_tmpFileId;
	FILE   *r_respBuff;	/* tmporary file to receive response */
	FILE   *r_tc_sav;	/* saved original FILE to client */

	int	r_niced;
	FILE   *r_cachefp;
  const	char   *r_cpath;
	struct {
	  int	d_start;
	  MStr(	d_cpath,URLSZ);
	  FILE *d_fp;
	  int	d_ready;
	} r_dcx;
	UTag	r_Anchor_rem;
		/* Pushed back fragment of anchor tag which is folded
		 * into multiple lines.
		 * Should be treated in general way in the input buffer
		 * operation... (-_-;
		 */
	UTag	r_line0t;
	UTag	r_line1t;
} ResponseContext;

#define RX_Conn		RX->r_Conn
#define RX_referer	RX->r_referer
#define RX_ovw		RX->r_ovw
#define RX_qWithHeader	RX->r_qWithHeader
#define RX_qmethod	RX->r_qmethod
#define RX_reqHEAD	RX->r_reqHEAD

#define RX_status	RX->r_status
#define RX_isHTTP09	RX->r_status.hr_isHTTP09
#define RX_ver		RX->r_status.hr_ver
#define RX_code		RX->r_status.hr_rcode
#define RX_reason	RX->r_status.hr_reason

#define RX_connection	RX->r_connection
/**/
#define RX_ctype	RX->r_ctype
#define RX_ctypeline	RX->r_ctypeline
#define RX_servername	RX->r_servername
#define RX_cencoding	RX->r_cencoding
#define RX_cencoded	RX->r_cencoded
#define RX_tencoding	RX->r_tencoding
#define RX_setCookie	RX->r_setCookie
#define RX_cachecontrol	RX->r_cachecontrol
#define RX_lastVia	RX->r_lastVia
/**/

#define RX_expires	RX->r_expires
#define RX_lastMod	RX->r_lastMod
#define RX_lastModTime	RX->r_lastModTime

#define RX_errori	RX->r_errori
#define RX_tryKeepAlive	RX->r_tryKeepAlive

#define RX_convChar	RX->r_convChar
#define RX_deEnt	RX->r_deEnt
#define RX_putPRE	RX->r_putPRE

#define RX_noBody	RX->r_noBody
#define RX_inHeader	RX->r_inHeader
#define RX_isText	RX->r_isText
#define RX_isBin	RX->r_isBin
#define RX_woURI	RX->r_woURI

#define RX_bodyLines	RX->r_bodyLines
#define RX_txtLen	RX->r_txtLen
#define RX_binLen	RX->r_binLen

#define RX_Start	RX->r_Start
#define RX_Resp1	RX->r_Resp1
#define RX_firstResp	RX->r_firstResp
#define RX_connDelay	RX->r_connDelay

#define RX_nflush	RX->r_nflush
#define RX_ninput	RX->r_ninput
#define RX_noutput	RX->r_noutput
#define RX_nsigreport	RX->r_nsigreport

#define RX_fromcache	RX->r_fromcache
#define RX_fsx		RX->r_fsx
#define RX_fsp		RX->r_fsx.t_fp
#define RX_fsd		RX->r_fsx.t_fd
#define RX_rdBuff	RX->r_fsx.t_buffer
/**/
#define RX_rdContLen	RX->r_fsx.t_contLeng
#define RX_xrdLen	RX->r_xrdLen
#define RX_rdContLenGot	RX->r_fsx.t_contLengGot
#define RX_emptyBody	( RX_rdContLenGot && RX_rdContLen == 0 )
#define RX_rdHeadTotal	RX->r_fsx.t_headTotal
#define RX_rdTotal	RX->r_fsx.t_bodyTotal
#define RX_remsize	RX->r_fsx.t_remsize
#define RX_guessCharset	RX->r_guessCharset

#define RX_tc_sav	RX->r_tc_sav
#define RX_tmpFileId	RX->r_tmpFileId
#define RX_respBuff	RX->r_respBuff

#define RX_tcx		RX->r_tcx
#define RX_tcp		RX->r_tcx.t_fp
#define RX_tcd		RX->r_tcx.t_fd
#define RX_wrbufed	RX->r_tcx.t_buffered
#define RX_wrHeadTotal	RX->r_tcx.t_headTotal
#define RX_wrContLen	RX->r_tcx.t_contLeng
#define RX_wrTotal	RX->r_tcx.t_bodyTotal
#define RX_niced	RX->r_niced

#define RX_cachefp	RX->r_cachefp
#define RX_cpath	RX->r_cpath
#define RX_dcx		RX->r_dcx
#define Line0t		RX->r_line0t
#define Line1t		RX->r_line1t
#define Anchor_rem	RX->r_Anchor_rem.ut_addr
/**/

static void url_abs_delegateS(Connection *Conn,int do_delegate,Referer *referer,PCStr(src),PVStr(dst),PVStr(rem))
{	struct {
		MStr(e_buf,RESP_LINEBUFSZ);
		char *ptr; /**/
	} buf;
	TagCtx stagctx;

	stagctx = referer->r_tagctx;
	buf.ptr = buf.e_buf;
	/*if( do_delegate || something-MOUNTed )*/
		url_absoluteS(referer,src,QVStr(buf.ptr,buf.e_buf),AVStr(rem));
	referer->r_tagctx = stagctx;

/*
	CTX_url_delegateS(Conn,referer,buf.ptr,dst,do_delegate?Conn:NULL);
*/
	CTX_url_delegateS(Conn,referer,buf.ptr,AVStr(dst),do_delegate);
	referer->r_tagctx = stagctx;

	/*
	if( DO_DELEGATE || IsMounted )
	*/
	if( DO_DELEGATE || IsMounted || ToInternal )
	if( URICONV_nPARTIAL )
	if( RespCode != 301 && RespCode != 302 )
	if( url_partializeS(referer,dst,QVStr(buf.ptr,buf.e_buf)) )
		strcpy(dst,buf.ptr);
}
static void redirect_HTMLS(Connection *Conn,int dont_rewrite,int do_delegate,Referer *referer,PCStr(src),PVStr(dst),PVStr(rem))
{
	if( dont_rewrite )
		url_absoluteS(referer,src,AVStr(dst),AVStr(rem));
	else	url_abs_delegateS(Conn,do_delegate,referer,src,AVStr(dst),AVStr(rem));
}
void HTTP_redirect_HTML0(Connection *Conn,PCStr(proto),PCStr(host),int port,PCStr(req),PCStr(src),PVStr(dst))
{	Referer referer;
	CStr(refbuf,URLSZ);

	setReferer(Conn,proto,host,port,req,&referer,AVStr(refbuf));
	redirect_HTMLS(Conn,DONT_REWRITE,DO_DELEGATE,&referer,src,AVStr(dst),VStrNULL);
}

static const char *metahttp(Connection *Conn,PCStr(attr),PVStr(cont),PCStr(tagp),PVStr(contp),PCStr(nextp))
{	const char *cs;
	CStr(charset,64);
	int len;

	charset[0] = 0;
	if( strcaseeq(attr,"Content-Type") )
/*
	if( len = erase_charset_param(cont,NULL) ){
*/
	if( len = erase_charset_param(AVStr(cont),AVStr(charset)) ){
		const char *ccxout = 0;
		/* set the charset into CCX as the hint on input-charset */
		if( CCXwithJP(CCX_TOCL) == 0 )
		if( charset[0] && CCXcharsetcmp(charset,"ISO-2022-JP") != 0 ){
			sv1log("set CCX in-charset[%s]\n",charset);
			CCX_setincode(CCX_TOCL,charset);
		}

		/* don't erase charset=... if the charset is not changed */
		if( CCXactive(CCX_TOCL) )
		if( CCXoutcharset(CCX_TOCL,&ccxout) )
		if( ccxout != 0 && CCXcharsetcmp(ccxout,charset) == 0 ){
			sv1log("thru chaset=%s in HTTP-EQUIV\n",charset);
			return nextp;
		}

		if( CCXguessing(CCX_TOCL) ){ /* CHARSET=guess */
			sv1log("thru chaset=%s in HTTP-EQUIV (CHARSET=guess)\n",
				charset);
			Xstrcpy(FVStr(InCharset),charset);
			return nextp;
		}

		len = erase_charset_param(AVStr(contp),AVStr(charset));
		sv1log("removed charset in HTTP-EQUIV[%s][%s]\n",cont,charset);
		return nextp - len;
	}
	return nextp;
}

#define Line(line0,ln)	((ln)==0?line0:((ln)%2==0?Line0t.ut_addr:Line1t.ut_addr))
#define Cline	Line(line0,linex+0)
#define Nline	Line(line0,linex+1)

static char *rewriteResponse(Connection *Conn,ResponseContext *RX,Referer *referer,PVStr(line0),PCStr(ctype),int doconv,int deent,FILE *tc)
{	int linex;

	dumpstacksize("rewriteResponse","");
	linex = 0;

	if( !RelayTHRU )
	if( BORN_SPECIALIST || ACT_SPECIALIST ){
		if( referer->r_cType ){
			ctype = referer->r_cType;
		}
		if( ctype == NULL )
			ctype = "message/rfc822";

	/*
	    if( RX_inHeader || RX_isText == TX_HTML ){
	*/

	    if( RX_inHeader
	     || RX_isText == TX_HTML
	     || RX_isText == TX_CSS
	     || RX_isText == TX_XML
	     || RX_isText == TX_JAVASCRIPT
	    ){
		if( Anchor_rem[0] ){
			Xstrcpy(ZVStr(Nline,RESP_LINEBUFSZ),Anchor_rem);
			Xstrcat(ZVStr(Nline,RESP_LINEBUFSZ),Cline);
			linex++;
			setVStrEnd(Anchor_rem,0);
		}
		if( !DONT_REWRITE || URICONV_nFULL )
		if( html_nextTagAttrX(referer,Cline,ctype,AVStr(Anchor_rem),NULL,NULL,NULL) ){
			redirect_HTMLS(Conn,DONT_REWRITE,DO_DELEGATE,referer,Cline,ZVStr(Nline,RESP_LINEBUFSZ),AVStr(Anchor_rem));
			linex++;
		}
		if( NOJAVA || TAGCONV_nKILL ){
			int uconv = 0;
			if( NOJAVA & RELAY_OBJECT ) uconv |= TAGCONV_JAVA;
			if( NOJAVA & RELAY_APPLET ) uconv |= TAGCONV_APPLET;
			if( TAGCONV_nKILL ) uconv |= TAGCONV_KILL;

			if( java_conv(Cline,ZVStr(Nline,RESP_LINEBUFSZ),uconv) )
				linex++;
		}
		if( deent ){
			decode_entities(Cline,ZVStr(Nline,RESP_LINEBUFSZ));
			linex++;
		}
	    }
		if( doconv ){
			scan_metahttp(Conn,ZVStr(Cline,RESP_LINEBUFSZ),metahttp);
			if( CCXactive(CCX_TOCL) )
				CCXexec(CCX_TOCL,Cline,strlen(Cline),
					ZVStr(Nline,RESP_LINEBUFSZ),RESP_LINEBUFSZ);
			else	CTX_line_codeconv(Conn,Cline,ZVStr(Nline,RESP_LINEBUFSZ),ctype);
			linex++;
		}
	}
	return (char*)Cline;
}

static const char *GETRESPTXT(Connection *Conn,ResponseContext *RX,int fromcache)
{	int timeout;
	int remleng;
	int niced = RX_niced;
	FILE *fs = RX_fsp;
	MrefQStr(line,RX_rdBuff); /**/
	int byline = RX_inHeader || (HTTP_opts & HTTP_LINEBYLINE);
	int size = RX_remsize + 1;
	int *lengp = &RX_fsx.t_lastRcc;
	int *isbinp = &RX_isBin;
	int cc;
	const char *rcode;

	if( !RX_inHeader && RX_emptyBody && RX_rdTotal == 0 )
		timeout = 100;
	else
	if( HTTP_TOUT_RESPLINE )
		timeout = (int)(HTTP_TOUT_RESPLINE * 1000);
	else	timeout = (int)(IO_TIMEOUT * 1000);

	if( !RX_inHeader && 0 < RX_rdContLen ){
		if( RX_xrdLen )
			remleng = RX_xrdLen - RX_rdTotal;
		else
		remleng = RX_rdContLen - RX_rdTotal;
		if( !fromcache ){
			if( remleng <= 0 )
				timeout = 3*1000;
		}
	}else	remleng = RX_remsize;

	rcode = fgetsByBlock(AVStr(line),size,fs,niced,timeout,byline,fromcache,
		remleng,lengp,isbinp);
	cc = *lengp;
	if( RESP_SAV ){
		if( RESP_MSGFP != NULL || RESP_SIZ == 0 || RESP_SIZ < RESP_LEN+cc+1 ){
			if( RESP_MSGFP == NULL ){
				RESP_MSGFP = TMPFILE("RESP_MSG");
			}
			fputs(line,RESP_MSGFP);
		}else{
			bcopy(line,(char*)RESP_MSG+RESP_LEN,cc+1);
			RESP_LEN += cc;
		}
	}
	return rcode;
}

/*
fflush after the header is put makes separated header/body and let
the server on Solaris2.X be slower...  But, this is necessary in
BSDI-1.x to avoid the header from being put after the body X-<
*/
#ifdef __bsdi__
#include <sys/param.h>
#if !defined(_BSDI_VERSION) || _BSDI_VERSION < 199501
#define HeadFlush 1
#endif
#endif
#ifndef HeadFlush
#define HeadFlush 0
#endif

static int flushHead(Connection *Conn,FILE *tc,int length)
{
/*
	if( 0 < length && length < 1024 )
*/
 	if( !HeadFlush && !FlushHead )
		return 0;

	if( fflush(tc) == EOF ){
		setClientEOF(Conn,tc,"flushHead");
		return EOF;
	}

	Verbose("HeadFlush:%d, FlushHead:%d(msec)\n",HeadFlush,FlushHead);
	if( FlushHead )
		msleep(FlushHead);

	return 0;
}
static int guessCharset(Connection *Conn,PCStr(ctype))
{ 
	if( strcasestr(ctype,"text/html") || strcasestr(ctype,"text/plain") )
	if( strcasestr(ctype,"charset=") == 0 )
	if( CCXactive(CCX_TOCL) )
	if( CCXguessing(CCX_TOCL) ) /* CHARSET=guess */
		return 1;
	return 0;
}
static void setGuessedCharset(Connection *Conn,PVStr(line))
{	int fnlen;
	const char *xcharset;

	if( fnlen = STRH(line,F_ContType) )
	if( guessCharset(Conn,line+fnlen) ){
		if( xcharset = CCXident(CCX_TOCL) ){
			if( strcaseeq(xcharset,"US-ASCII") )
				xcharset = InCharset;
			if( !strcaseeq(xcharset,"US-ASCII") ){
				replace_charset(AVStr(line),xcharset);
				sv1log("charset guessed:%s",line+fnlen);
			}
		}
	}
	else
	if( CCXactive(CCX_TOCL) ){
		if( xcharset = HTTP_outCharset(Conn) ){
			if( !strcaseeq(xcharset,"US-ASCII") ){
				CStr(sline,128);
				strcpy(sline,line);
				replace_charset(AVStr(line),xcharset);
				if( strcmp(sline,line) != 0 )
				sv1log("---- set charset:%s",line+fnlen);
			}
		}
	}
}

#define DGC_SVCC	"DeleGate-Control-SVCC"
extern const char *TIMEFORM_COOKIE;
static void putProxyCookie(Connection *Conn,FILE *tc,PCStr(svcc)){
	const char *xcharset;
	if( CCXactive(CCX_TOCL) ){
		xcharset = svcc;
		if( xcharset[0] == 0 )
			xcharset = CCXident(CCX_TOCL);
		if( xcharset == NULL )
			xcharset = "";
		if( !strcaseeq(xcharset,"US-ASCII") ){
			CStr(params,1024);
			CStr(path,1024);
			CStr(ex,64);
			int exp;
			/* the path should be the MOUNT point ... */
			strcpy(path,"/");
/*
			exp = time(0) + 10*60;
			StrftimeGMT(AVStr(ex),sizeof(ex),TIMEFORM_COOKIE,exp,0);
			sprintf(params,"%s=%s; Expires=%s",DGC_SVCC,xcharset,ex);
*/
			sprintf(params,"%s=%s",DGC_SVCC,xcharset);
			fprintf(tc,"Set-Cookie: %s\r\n",params);

			exp = time(0) + 24*60*60;
			StrftimeGMT(AVStr(ex),sizeof(ex),TIMEFORM_COOKIE,exp,0);
			sprintf(params,"%s=%s; Expires=%s",DGC_SVCC,xcharset,ex);
			fprintf(tc,"Set-Cookie: %s; Path=%s\r\n",params,path);

			sv1log("---- set SVCC[%s] %s\n",xcharset,path);
		}
	}
}
void getProxyCookie(Connection *Conn,PVStr(field)){
	CStr(svcc,128);
	if( CCXactive(CCX_TOSV) == 0 )
	if( extractParam(AVStr(field),"Cookie",DGC_SVCC,AVStr(svcc),sizeof(svcc),1) ){
		if( svcc[0] ){
			CCXcreate("*",svcc,CCX_TOSV);
			sv1log("---- got SVCC[%s]\n",svcc);
		}
	}
}

/*
 * rewriting/adding header field based on body
 * other than Content-Length
 */
static int genHeadByBody(Connection *Conn,PCStr(phead))
{	CStr(ctype,256);

	if( getFV(phead,"Content-Type",ctype) == 0 )
		return 0;

	if( guessCharset(Conn,ctype) )
		return 1;

	return 0;
}

int HTTP_putMIMEmsg(Connection *Conn,FILE *in,FILE *out)
{	CStr(line,1024);
	int hsize,msize;
	int chunked = 0;
	int oleng,nleng,wleng;
	/* SHOULD rewrite "Line:" header also */
	int fnlen;
	FILE *zip;
	int cencoded = 0;
	CStr(cencode,32);

	oleng = 0;
	cencode[0] = 0;
	for(;;){
		if( fgets(line,sizeof(line),in) == NULL ) break;
		if( line[0] == '\r' || line[0] == '\n' ) break;
		if( fnlen = STRH(line,F_ContLeng) )
			oleng = atoi(line+fnlen);
		else
		if( fnlen = STRH(line,F_TransEncode) ){
			if( strcasestr(line+fnlen,"chunked") )
				chunked = 1;
			sv1log("#HT11 chunked=%d %s\n",chunked,line);
		}
		else
		if( fnlen = STRH(line,F_ContEncode) ){
			cencoded = 1;
		}
		else
		if( fnlen = STRH(line,F_AccEncodeX) ){
			wordScan(line+fnlen,cencode);
		}
	}
	msize = file_size(fileno(in));
	hsize = ftell(in);
	nleng = msize - hsize;

	zip = 0;
	if( !chunked && !cencoded && cencode[0] ){
		if( isinList(cencode,"gzip") || isinList(cencode,"x-gzip") ){
			int ci,ch,isbin;

			isbin = 0;
			for( ci = 0; ci < 256; ci++ ){
				ch = getc(in);
				if( ch == EOF )
					break;
				if( ch == 0 ){
					isbin = 1;
					break;
				}
			}
			if( isbin ){
			  /* might be GIF in malinformed text/html */
			  Verbose("#CEcl is-binary data(%d), don't gzip\n",ci);
			}

			if( !isbin ){
			/* flush input buffer before sending it to system() */
				{
					fseek(in,0,0);
					fseek(in,hsize,0);
				}
				if( zip = Gzip(cencode,in) ){
					fseek(zip,0,0);
					nleng = file_size(fileno(zip));
					msize = hsize + nleng;
				}
			}
		}
	}
	sv1log("Content-Length: %d -> %d (%d - %d)\n",oleng,nleng,msize,hsize);

	fseek(in,0,0);
	for(;;){
		if( fgets(line,sizeof(line),in) == NULL ) break;
		if( line[0] == '\r' || line[0] == '\n' ){
			if( Conn ){
			putProxyCookie(Conn,out,"");
			}
			if( zip ){
			  sv1log("#CEcl put Content-Encoding:%s\n",cencode);
			  fprintf(out,"%s %s\r\n",F_ContEncode,cencode);
			  fprintf(out,"%s %s\r\n",F_Vary,"Accept-Encoding");
			}
			if( !chunked )
			fprintf(out,"%s %d\r\n",F_ContLeng,nleng);
			fputs(line,out);
			break;
		}
		if( fnlen = STRH(line,F_ContLeng) ) continue;
		if( fnlen = STRH(line,F_AccEncodeX) ) continue;
		if( Conn ){
			setGuessedCharset(Conn,AVStr(line));
		}
		fputs(line,out);
	}

	if( Conn && flushHead(Conn,out,nleng) != 0 ){
 sv1log("## stop relay-3: flush()=EOF, client seems dead\n");
		/*
		return -1;
		*/
		wleng = -1;
	}else{
		if( zip ){
			in = zip;
		}
		wleng = copy_fileTIMEOUT(in,out,NULL);
		if( wleng != nleng ){
 sv1log("## stop relay-4: FWRITE(%d)=%d, SIGPIPE=%d, client seems dead\n",
 nleng,wleng,nsigPIPE);
			/*
			return -1;
			*/
			wleng = -1;
		}
	}
	if( zip ){
		fclose(zip);
		if( Conn ) Conn->xf_clprocs |= XF_FTOCL;
	}
	return wleng;
}
static void attach_respbuff(Connection *Conn,ResponseContext *RX)
{
	RX_respBuff = getTmpFile(RX_tmpFileId/*,Conn*/);
	RX_tc_sav = RX_tcp;
	RX_tcp = RX_respBuff;
	RX_tcd = -1;
}
static FILE *detach_respbuff(Connection *Conn,FILE *tc_buf,FILE *tc,int checkHead,PCStr(reason))
{	CStr(field,1024);
	CStr(fname,1024);
	CStr(fbody,1024);

	sv1log("detach respBuff: %s\n",reason);

	fflush(tc_buf);
	Ftruncate(tc_buf,0,1);
	fseek(tc_buf,0,0);

	if( checkClientEOF(Conn,tc,"detach_respbuff") )
		httpStat = CS_EOF;

	/* copy header removing Connection: Keep-Alive */
	if( checkHead )
	while( fgets(field,sizeof(field),tc_buf) ){
		if( STRH_Connection(field) ){
			scan_field1(field,AVStr(fname),sizeof(fname),AVStr(fbody),sizeof(fbody));
			if( strncasecmp(fbody,"keep-alive",10) == 0 )
				clntClose(Conn,"b:temp. buff. detached (%s)",
					reason);
			sprintf(field,"%s: close\r\n",fname);
			SentKeepAlive = 0;
		}
		if( STRH(field,F_AccEncodeX) ) continue;
		if( STRH(field,F_ContLeng) ){
			/* remove wrong Content-Length if with some conv. */
			if( HTTP_opts & HTTP_DELWRONGCONTLENG )
			if( withConversion(Conn,0) ){
				continue;
			}
		}
		setGuessedCharset(Conn,AVStr(field));

		if( !ClientEOF )
		if( fputs(field,tc) == EOF )
			setClientEOF(Conn,tc,"detach_respbuff-1");

		if( field[0] == '\r' || field[0] == '\n' )
			break;
	}

	if( !ClientEOF ){
		copy_fileTIMEOUT(tc_buf,tc,NULL);
		if( feof(tc) )
			setClientEOF(Conn,tc,"detach_respbuff-2");
	}
	fclose(tc_buf);
	return tc;
}
static int lastmtime(PCStr(line))
{	CStr(scdate,1024);

	lineScan(line,scdate);
	return scanHTTPtime(scdate);
}
static void scanRespHead1(Connection *Conn,ResponseContext *RX,PCStr(line))
{	int fnlen;

	if( fnlen = STRH(line,F_ContEncode) )
	{
		wordScan(line+fnlen,RX_cencoding);
		RX_cencoded = 1;
	}
	else
	if( fnlen = STRH(line,F_ContLeng) )
	{
		RX_rdContLen = atoi(line+fnlen);
		RX_rdContLenGot = 1;
	}
	else
	if( fnlen = STRH(line,F_ContRange) ){
		sv1log("#HT11 %s",line);
	}else
	if( fnlen = STRH(line,F_LastMod) ){
		RX_lastMod = 1;
		RX_lastModTime = lastmtime(line+fnlen);
	}else
	if( fnlen = STRH(line,F_ContType) ){
		const char *pp;
		lineScan(line+fnlen,RX_ctypeline);
		wordScan(line+fnlen,RX_ctype);
		if( pp = strchr(RX_ctype,';') )
		{   const char *cp;
		    if( cp = strstr(pp+1,"charset=") )
		    wordscanY(cp+8,AVStr(SVRespCharset),sizeof(SVRespCharset),"^;");
			truncVStr(pp);
		}
		if( strncaseeq(RX_ctype,"text/",5) ){
			if( strcaseeq(RX_ctype,"text/plain") ){
				if( plain2html() ){
					RX_isText = TX_HTML;
					RX_putPRE = 1;
				}else	RX_isText = TX_PLAIN;
			}else
			if( strcaseeq(RX_ctype,"text/html") )
				RX_isText = TX_HTML;
			else
			if( strcaseeq(RX_ctype,"text/css") )
				RX_isText = TX_CSS;
			else
			if( strcaseeq(RX_ctype,"text/xml") )
				RX_isText = TX_XML;
			else
			if( strcaseeq(RX_ctype,"text/x-component")
			 || strcaseeq(RX_ctype,"text/javascript") )
				RX_isText = TX_JAVASCRIPT;
			else	RX_isText = TX_MISC;
		}else{
			if( strcaseeq(RX_ctype,"application/x-javascript") )
				RX_isText = TX_JAVASCRIPT;
		}
		if( guessCharset(Conn,line) ){
			RX_guessCharset = 1;
		}
	}else
	if( fnlen = STRH(line,F_Server) ){
		lineScan(line+fnlen,RX_servername);
if(LOG_GENERIC){
fputLog(Conn,"Server","%s://%s:%d; version=%s\n",
DST_PROTO,DST_HOST,DST_PORT,RX_servername);
}
	}else
	if( fnlen = STRH(line,F_Pragma) ){
		if( RX_cachecontrol[0] == 0 )
		lineScan(line+fnlen,RX_cachecontrol);
	}else
	if( fnlen = STRH(line,F_CacheControl) ){
		lineScan(line+fnlen,RX_cachecontrol);
	}else
	if( line[0] == '\r' || line[0] == '\n' ){
		RX_inHeader = 0;
	}
	if( RX_errori )
	if( RX_code != 404 )
		sv1log("HTTP error header: %s",line);
}

static int appendVia(Connection *Conn,int isreq,PVStr(fields),int fsize)
{	CStr(via,256);
	CStr(vb,256);
	refQStr(ovia,fields); /**/
	const char *nvia;

	HTTP_genVia(Conn,isreq,AVStr(via));
	if( *via == 0 )
		return 0;

	if( ovia = findFieldValue(fields,"Via") ){
		for(;;){
			if( ovia = strpbrk(ovia,"\r\n") ){
				/* find the last Via */
				if( nvia = findFieldValue(ovia,"Via") ){
					ovia = (char*)nvia;
					continue;
				}
			}
			break;
		}
	}
	if( ovia ){
		sprintf(vb,", %s",via);
		Strins(AVStr(ovia),vb);
	}else{
		sprintf(vb,"Via: %s\r\n",via);
		RFC822_addHeaderField(AVStr(fields),vb);
	}
	return 1;
}

static void setServKeepAlive(Connection *Conn,ResponseContext *RX)
{
	ServKeepAlive = 0;
	if( !RX_fromcache )
	if( !(toMaster && vercmp(MediatorVer,CHUNKED_VER) < 0) )
	if( streq(RX_ver,"HTTP/1.1") && strncasecmp(RX_connection,"close",6) != 0
	 || strncasecmp(RX_connection,"keep-alive",10) == 0
	){
		ServKeepAlive = 1;
		RX_fsx.t_keepAlive = 1;
		sv1log("#HT11 server KEEP-ALIVE\n");
	}
}

/*
 * do something before ending response header
 * with empty CRLF line
 */
static void endRespHead(Connection *Conn,ResponseContext *RX)
{	CStr(via,256);
	CStr(head,256);

	if( !ClientEOF && RX_qWithHeader ){
		head[0] = 0;
		if( HTTP_genhead(Conn,AVStr(head),KH_OUT|KH_RES) )
			fputs(head,RX_tcp);
	}
	if( !ImResponseFilter ){
		if( !ClientEOF && RX_qWithHeader ){
			appendVia(Conn,0,AVStr(RX_lastVia),sizeof(RX_lastVia));
			if( HTTP_opts & HTTP_SESSION ){
				if( genSessionCookie(Conn,AVStr(head)) )
					fputs(head,RX_tcp);
			}
			refreshDigestNonce(Conn,RX_tcp);
			if( RESP_ADD[0] ){
				fputs(RESP_ADD,RX_tcp);
			}
		}
	}
	if( RX_lastVia[0] ){
		if( !HTTP_head2kill(RX_lastVia,KH_OUT|KH_RES) )
			fputs(RX_lastVia,RX_tcp);
	}
	if( RX_expires[0] ){
		if( !ImResponseFilter )
		if( !HTTP_head2kill(F_Expires,KH_OUT|KH_RES) ){
			getMountExpires(Conn,AVStr(RX_expires),sizeof(RX_expires));
			fprintf(RX_tcp,"Expires: %s\r\n",RX_expires);
		}
	}

	HTTP_editResponseHeader(Conn,RX_tcp);
	sv1log("#HT11 SERVER ver[%s] conn[%s]\n",RX_ver,RX_connection);

	setServKeepAlive(Conn,RX);
	/*
	ServKeepAlive = 0;
	if( !(toMaster && vercmp(MediatorVer,CHUNKED_VER) < 0) )
	if( streq(RX_ver,"HTTP/1.1") && strncasecmp(RX_connection,"close",6) != 0
	 || strncasecmp(RX_connection,"keep-alive",10) == 0
	){
		ServKeepAlive = 1;
		RX_fsx.t_keepAlive = 1;
		sv1log("#HT11 server KEEP-ALIVE\n");
	}
	*/

	/* asked Keep-Alive in the request, so must reply
	 * int the respose.
	 */
	if( !ClientEOF && ClntKeepAlive ){
		if( !RX_noBody )
			HTTP_modifyConnection(Conn,RX_rdContLen);

		if( RX_tryKeepAlive ){
/*
if( !RX_noBody && RX_tcp != RX_respBuff && RX_rdContLen==0 )
clntClose(Conn,"u:unbound length data");
*/
			if( RX_errori )
				clntClose(Conn,"s:bad status: %d",RX_errori);

			if( !HTTP_CKA_CFI )
			if( Conn->xf_filters & (XF_FTOCL|XF_FCL) )
				if( doKeepAliveWithSTLS(Conn) ){
					Verbose("Keep-Avlie with TLS (A)\n");
				}else
				clntClose(Conn,"x:external filter");

			/*if( HTTP_opts & HTTP_STOPKA_CONT0 )*/
			if( RX_fsx.t_chunked == 0 && RX_rdContLen == 0 )
			if( 0 < fPollIn(RX_fsp,1) )
			if( 0 < READYCC(RX_fsp) || 0 < Peek1(fileno(RX_fsp)) )
			{
				/* chunked encoding with client is suppressed
				 * when guessed as "emptyBody" (why?). But
				 * here, going to relay a non-empty body
				 * which will break the message boundary for
				 * keep-alived connection with the client.
				 */
				clntClose(Conn,"0:Content-Length: 0");
			}
		}
		putKeepAlive(Conn,RX_tcp);
	}

	if( !ClientEOF ){
		if( RX_emptyBody ){
		}else
		if( RX_tcx.t_chunked && !RX_noBody ){
			sv1log("#HT11 --putChunk-Header: %s chunked\r\n",
				F_TransEncode);
			fprintf(RX_tcp,"%s chunked\r\n",F_TransEncode);
		}
	}
}
/*
static putChunk(RX,buff,leng)
*/
#define putChunk(RX,buff,leng)	putChunkX(Conn,RX,buff,leng)
static int putChunkX(Connection *Conn,ResponseContext *RX,PCStr(buff),int leng)
{	int wcc,chunked;

	if( RX_emptyBody ){
		chunked = 0;
	}else
	if( RX_isHTTP09 )
		chunked = 0;
	else	chunked = !RX_inHeader && RX_tcx.t_chunked;
	if( chunked ){
		RX_tcx.t_chunk_ser += 1;
		Verbose("#HT11 --putChunk[%d] %d\n",RX_tcx.t_chunk_ser,leng);
		fprintf(RX_tcp,"%x\r\n",leng);
	}
	if( 0 < leng )
		wcc = fwriteTIMEOUT(buff,1,leng,RX_tcp);
	else	wcc = 0;
	if( chunked ){
		fputs("\r\n",RX_tcp);
		if( HTTP_opts & HTTP_FLUSHCHUNK ){
			fflush(RX_tcp);
			sv1log("#HT11 -- flush-chunk #%d %d/%d\n",
				RX_tcx.t_chunk_ser,wcc,leng);
		}
	}

	if( !RX_inHeader )
	if( (HTTP_opts & HTTP_NOFLUSHCHUNK) == 0 ){
		if( HTTP_opts & HTTP_DUMPSTAT ){
			if( RX_wrTotal == 0 ){
				int elps;
				elps = (int)(1000*(Time()-CONN_DONE));
				if( RX_fromcache )
					elps -= 1000;
			fprintf(stderr,"[%d]%c 1stFlushChunk(%4dms) %5d %s\n",
				getpid(),RX_fromcache?'H':' ',
				elps,wcc,REQ_URL);
			}
		}
		fflush(RX_tcp);
	}
	return wcc;
}
static int getChunk(ResponseContext *RX)
{	CStr(line,1024);

	if( 0 < RX_fsx.t_chunk_ser ){
		while( fgets(line,sizeof(line),RX_fsp) != NULL ){
			Verbose("#HT11 --getChunk[%d] footer: %s",
				RX_fsx.t_chunk_ser,line);
			if( *line == '\r' ) /* CRLF */
				break; 
				/* entitiy-headers in the last chunk */
		}
		if( RX_fsx.t_chunk_siz == 0 )
			return -1;
	}
	line[0] = 0;
	fgets(line,sizeof(line),RX_fsp);
	RX_fsx.t_chunk_rem = 0;
	sscanf(line,"%x",&RX_fsx.t_chunk_siz);
	RX_remsize = RX_fsx.t_chunk_siz;
	if( sizeof(RX_rdBuff)-1 < RX_remsize )
		RX_remsize = sizeof(RX_rdBuff)-1;
	RX_fsx.t_chunk_rem = RX_fsx.t_chunk_siz; 
	RX_fsx.t_chunk_ser++;

	Verbose("#HT11 --getChunk[%d] header: (%d) %s",RX_fsx.t_chunk_ser,
		RX_fsx.t_chunk_siz,line);
	return RX_fsx.t_chunk_ser;
}
static int fputsResponseChunk(Connection *Conn,ResponseContext *RX,PVStr(line),PCStr(ctype),int doconv,int deent)
{	const char *oline;
	int leng,wcc;

	if( RelayTHRU || !BORN_SPECIALIST && !ACT_SPECIALIST ){
		oline = line;
		leng = strlen(line);
	}else{
		if( !RX_inHeader && Conn->dg_putpart[0] ){
			if( Partfilter(Conn,&RX->r_partf,AVStr(line),IBUFSIZE) == 0 )
				return 0;
		}
	oline = rewriteResponse(Conn,RX,RX_referer,AVStr(line),ctype,doconv,deent,RX_tcp);
	leng = strlen(oline);
	}

	if( 0 < leng ){
		wcc = putChunk(RX,oline,leng);
		if( wcc < leng ){
			setClientEOF(Conn,RX_tcp,"fputsResponse");
			return 0;
		}else	return wcc;
	}else{
		sv1log("#HT11 fputsResponse(leng=%d)\n",leng);
		return leng;
	}
}
#define FPUTS(line,ctype,doconv,deent) \
	fputsResponseChunk(Conn,RX,line,RX_inHeader?0:ctype,doconv,deent)

static int fwriteResponseChunk(Connection *Conn,ResponseContext *RX,PCStr(buff),int leng)
{	int wcc;

	if( leng <= 0 )
		return leng;
	return putChunk(RX,buff,leng);
}
/*
static void log_codeconv(Connection *Conn)
*/
static void log_codeconv(Connection *Conn,ResponseContext *RX)
{	const char *xcharset;

	if( CCXactive(CCX_TOCL) ){
		if( xcharset = HTTP_outCharset(Conn) )
			sv1log("Code Conversion [CHARCODE=%s][%s]\n",xcharset,RX_ctype);
			/*
			sv1log("Code Conversion [CHARCODE=%s]\n",xcharset);
			*/
	}else{
		CTX_check_codeconv(Conn,1);
	}
}

static void filterApplet(Connection *Conn,ResponseContext *RX,PVStr(line))
{	FILE *tmp;
	refQStr(dp,line); /**/
	CStr(userAgent,64);
	CStr(warn,URLSZ);
	int rcc;

	dp = strcasestr(line,"<APPLET ");
	if( dp == NULL )
		return;

	if( strstr(proxyCookie,"APPLET") ){
		sv1log("#DONT CHECK APPLET: Cookie=%s\n",proxyCookie);
		return;
	}

	strcpy(userAgent,"UA-TEST");
	tmp = TMPFILE("AppletWarning");
	putBuiltinHTML(Conn,tmp,"AppletWarning","applet.dhtml",NULL,
		(iFUNCP)DHTML_printConn,NULL);
	fflush(tmp); fseek(tmp,0,0);
	rcc = fread(warn,1,sizeof(warn),tmp);
	if( rcc < 0 )
		rcc = 0;
	warn[rcc] = 0;
	fclose(tmp);
	Strins(AVStr(dp),warn);
	daemonlog("E","#Inserted Warning for APPLET\n");
}

static int NoRelayField(Connection *Conn,ResponseContext *RX,PCStr(field))
{	int fnlen;
	CStr(val,64);

	if( RESP_DoUNZIP ){
		if( fnlen = STRH(field,F_ContEncode) ){
			wordScan(field+fnlen,val);
			if( strcaseeq(val,"gzip") )
				return 1;
		}
		if( fnlen = STRH(field,F_Vary) ){
			wordScan(field+fnlen,val);
			if( strcaseeq(val,"Accept-Encoding") )
				return 1;
		}
	}
	return 0;
}

static void relayTxtResp1(Connection *Conn,ResponseContext *RX,QueryContext *QX,PCStr(req))
{	int wcc;
	MrefQStr(line,RX_rdBuff); /**/
	int fnlen;
	CStr(buf,1024);
	refQStr(out,buf); /**/

	if( !RX_inHeader ){
		if( HTTP_warnApplet )
		if( appletFilter )
			filterApplet(Conn,RX,AVStr(line));

		wcc = FPUTS(AVStr(line),RX_ctype,!RX_inHeader && RX_convChar,RX_deEnt);
		RX_wrTotal += wcc;
		return;
	}

	if( SimpleContType && STRH(line,F_ContType) ){
		refQStr(dp,line); /**/
		if( dp = strchr(line,';') ){
			sv1log("Discard Parameter -- %s",dp);
			strcpy(dp,"\r\n");
		}
	}

	if( RX_deEnt && STRH(line,F_DGVer) )
		RX_deEnt = 0;

	/*
	 * the charset should be rewritten only when
	 * the code conversion in the body is made ...
	 */
	/*
	if( RX_convChar && !SimpleContType && STRH(line,F_CtypeText) ){
	*/
	if( RX_convChar && !SimpleContType )
	if( fnlen = STRH(line,F_ContType) ){
		const char *xcharset;
		CStr(ctype,32);

		Xsscanf(line+fnlen," %[a-zA-Z0-9/-]",AVStr(ctype));
		if( STRH(line,F_CtypeText)
		 || streq(ctype,"application/x-javascript") )
		if( xcharset = HTTP_outCharset(Conn) )
		{
			replace_charset(AVStr(line),xcharset);
		}
	}

	if( NoRelayField(Conn,RX,line) ){
		Verbose("#CEsv DONT relay %s",line);
		return;
	}else
	if( line[0] == '\r' || line[1] == '\n' ){
		if( RESP_DoZIP )
		if( RX_isText ){
			/* if without non-CFI FTOCL */
			if( (Conn->xf_filters & XF_FTOCL) == 0
			 || (Conn->xf_filtersCFI & XF_FTOCL) != 0
			)
			if( RX_noBody ){
				/* don't generate X-Q-Accept-Encoding for
				 * head only response (HEAD or 304)
				 */
			}else
			{
				/*
				sprintf(buf,"%s %s\r\n",F_AccEncodeX,"gzip");
				*/
				sprintf(buf,"%s %s\r\n",F_AccEncodeX,QX_accEnc);
				wcc = strlen(buf);
				fputs(buf,RX_tcp);
				RX_wrHeadTotal += wcc;
			}
		}else{
			/* detach_respbuff() if it's just for DoZIP */
		}
	}else
	if( fnlen = STRH(line,F_ContLeng) ){
		if( RX_tcx.t_chunked ){
			if( HTTP_opts & HTTP_DELWRONGCONTLENG ){
				sv1log("#HT11 chunked, skip %s",line);
				return;
			}
			sv1log("#HT11 chunked, should skip: %s",line);
		}
	}else
	if( fnlen = STRH(line,F_SetCookie) ){
		lineScan(line+fnlen,RX_setCookie);
		MountCookieResponse(Conn,req,QVStr(line+fnlen,RX_rdBuff));
		if( RX_cachefp ){
			Ftruncate(RX_cachefp,0,0);
			fseek(RX_cachefp,0,0);
			RX_cachefp = NULL;
			QX_cacheRemove = R_PRIVATE;
		}
	}else
	if( fnlen = STRH(line,F_Location) ){
		if( RX_code == 301 || RX_code == 302 ){
			sv1log("%s",line);
			if( isMovedToSelf(Conn,line+fnlen) ){
				RX_errori = R_MOVED_LOOP;
				sv1log("#### don't cache MOVED loop\n");
			}
			if( WillKeepAlive && isMovedToAnotherServer(Conn,line+fnlen) )
				clntClose(Conn,"m:moved to another server");
		}
	}

	out = NULL;
	if( HTTP_ignoreIf && (
	    (fnlen = STRH(line,F_Etag))
	 || (fnlen = STRH(line,F_LastMod))
	)){
		sv1log("IGNORE IF-: %s",line);
	}else
	if( fnlen = STRH(line,F_KeepAlive) ){
		sv1log("HCKA:[R] %s",line);
		strcpy(RX_connection,"Keep-Alive");
	}else
	if( fnlen = STRH(line,F_Upgrade) ){
		sv1log("IGNORE response: %s",line);
	}else
	if( fnlen = STRH_Connection(line) ){
		Verbose("HCKA:[R] %s",line);
		lineScan(line+fnlen,RX_connection);
	}else
	if( fnlen = STRH(line,F_TransEncode) ){
		wordScan(line+fnlen,RX_tencoding);
		if( strcaseeq(RX_tencoding,"chunked") ){
			sv1log("#HT11 --getChunk-Header: %s",line);
			RX_fsx.t_chunked = 1;
		}
	}else
	if( fnlen = STRH(line,F_Expires) ){
		lineScan(line+fnlen,RX_expires);
	}else
	if( fnlen = STRH(line,"Via:") ){
		if( RX_lastVia[0] ){
			FStrncpy(buf,RX_lastVia);
			cpyQStr(out,buf);
		}
		FStrncpy(RX_lastVia,line);
	}else
	if( RX_qWithHeader && plain2html() && STRH(line,F_CtypePlain) ){
		sprintf(buf,"%s\r\n",F_CtypeHTML);
		cpyQStr(out,buf);
	}else
	if( RX_qWithHeader ){
		cpyQStr(out,line);
	}
	if( out && !ClientEOF && !HTTP_head2kill(out,KH_OUT|KH_RES) ){
		wcc = FPUTS(AVStr(out),RX_ctype,!RX_inHeader && RX_convChar,RX_deEnt);
		RX_wrHeadTotal += wcc;
	}
}
static int GETRESPBIN(Connection *Conn,ResponseContext *RX,int fromcache,int nready)
{	int rcc;
	MrefQStr(buff,RX_rdBuff); /**/

	if( fromcache ){
		rcc = fread((char*)buff,1,RX_remsize,RX_fsp);
		return RX_fsx.t_lastRcc = rcc;
	}
	if( rcc = fgetBuffered(AVStr(buff),RX_remsize,RX_fsp) ){
		Verbose("buffered(%d)\n",rcc);
		return RX_fsx.t_lastRcc = rcc;
	}

	/* MASTER-DeleGate (5.X) may keep connection even after said
	 * "Connection:close" ...
	  if( RX_rdTotal == RX_rdContLen )
	  if( nready == 0 && (nready = PollIn(fileno(RX_fsp),1000)) == 0 ){
		sv1log("#### SOFT EOF %d/%d %s,%s\n",RX_rdTotal,RX_rdContLen,
			RX_ver,RX_connection);
		RX_fsx.t_EOF = 1;
		return RX_fsx.t_lastRcc = 0;
	  }
	 */

	if( nready == 0 && (nready = PollIn(fileno(RX_fsp),2000)) == 0 ){
		if( RX_tcp == RX_respBuff ){
			RX_tcp = detach_respbuff(Conn,RX_tcp,RX_tc_sav,
				RX_qWithHeader,"flush slow binary body.");
		}else
		if( !ClientEOF ){
			RX_nflush++;
			if( fflushTIMEOUT(RX_tcp) == EOF )
				setClientEOF(Conn,RX_tcp,"binary");
		}
	}

	Verbose("#HT11 READ-BIN: %d [%d/%d]\n",
		RX_remsize,RX_rdTotal,RX_rdContLen);

	if( nready == 0 )
		rcc = readTIMEOUT(fileno(RX_fsp),AVStr(buff),RX_remsize);
	else	rcc = read(fileno(RX_fsp),(char*)buff,RX_remsize);

	if( rcc <= 0 )
		RX_fsx.t_EOF = 1;
	else
	while( rcc < RX_remsize ){
	    if( 0 < PollIn(fileno(RX_fsp),10) ){
		int rcc1;
		rcc1 = read(fileno(RX_fsp),(char*)buff+rcc,RX_remsize-rcc);
		if( rcc1 <= 0 ){
			RX_fsx.t_EOF = 1;
			break;
		}else{
			rcc += rcc1;
			RX_ninput++;
		}
	    }else	break;
	}
	return RX_fsx.t_lastRcc = rcc;
}

static void fflushKeepAlive(Connection *Conn,PCStr(where),FILE *fc,FILE *tc,int wtotal)
{	int nready;

	if( fc == NULL ){
		if( fflushTIMEOUT(tc) == EOF )
			setClientEOF(Conn,fc,"%s-fflushKeepAlive-1",
				where);
	}else
	/*
	if( wtotal == 0 || 1024*8 < wtotal ){
	this code is introduced on 4.0.7 to reduce flush() for pipelined
	responses, but it rearly occurs while it causes usual delay.
	*/
	{
		/*
		nready = fPollIn(fc,1);
		*/
		nready = ready_cc(fc);
		if( 0 < nready )
			sv1log("%s-fflushKeepAlive-PipelinedRequest",where);
		else
		if( nready < 0 )
			setClientEOF(Conn,fc,"%s-fflushKeepAlive-2-RESET",
				where);
		else
		if( nready == 0 ){
			set_nodelay(fileno(tc),1);
			if( fflushTIMEOUT(tc) == EOF )
				setClientEOF(Conn,fc,"%s-fflushKeepAlive-3",
					where);
			else	set_nodelay(fileno(tc),0);
		}
	}
}
static void abortKeepAlive(Connection *Conn,ResponseContext *RX)
{
	if( ClientEOF ){
	clntClose(Conn,"r:by client (response EOF) %d/%d (%d/%d)",
		RX_wrTotal,RX_wrContLen,RX_rdTotal,RX_rdContLen);
	}else
	if( !RX_tcx.t_chunked && !RX_noBody && RX_wrTotal != RX_wrContLen ){
	clntClose(Conn,"l:##FATAL:inconsistent body length %d/%d (%d/%d)",
		RX_wrTotal,RX_wrContLen,RX_rdTotal,RX_rdContLen);
	}else
	if( RX_errori ){
	clntClose(Conn,"s:##FATAL:bad status(%d) %d/%d (%d/%d)",
		RX_errori,RX_wrTotal,RX_wrContLen,RX_rdTotal,RX_rdContLen);
	}
}

static void releaseRespbuf(Connection *Conn,ResponseContext *RX)
{
	fflush(RX_tcp);
	Ftruncate(RX_tcp,0,1);
	fseek(RX_tcp,0,0);

	if( checkClientEOF(Conn,RX_tcp,"flush_respbuff") ){
		httpStat = CS_EOF;
		RX_wrTotal = RX_wrContLen = 0;
	}else
	if( 0 < (RX_wrTotal = HTTP_putMIMEmsg(Conn,RX_tcp,RX_tc_sav)) ){
		RX_wrContLen = RX_wrTotal;
	}else{
		sv1log("## HTTP RESPONSE CLOSE: NO (client dead)\n");
		setClientEOF(Conn,RX_tcp,"flush_respbuff.FAILED");
		freeTmpFile(RX_tmpFileId /*,Conn*/);
	}
	fclose(RX_tcp);
	RX_tcp = RX_tc_sav;
}
static int relayBinResp1(Connection *Conn,ResponseContext *RX,int rcc)
{	int wcc;
	const char *buff = RX_rdBuff;

	if( rcc <= 0 ){
		Verbose("read(%d) = %d\n",RX_remsize,rcc);
		return -1;
	}

	RX_rdTotal += rcc;

	if( RX_cachefp ){
		wcc = fwrite(buff,1,rcc,RX_cachefp);
		sendDistribution(Conn,RX_cachefp,RX_fsp,RX_tcp,buff,rcc);
		RX_binLen += wcc;

		if( wcc == 0 || RX_rdContLen+0x100000 < RX_binLen ){
			sv1log("discard cache: wcc=%d leng=%d/%d %s\n",
				wcc,RX_binLen,RX_rdContLen,RX_cpath);
			Ftruncate(RX_cachefp,0,0);
			fseek(RX_cachefp,0,0);
			RX_cachefp = NULL;
		}
	}

	if( !ClientEOF ){
	    wcc = fwriteResponseChunk(Conn,RX,buff,rcc);
	    RX_wrTotal += wcc;
	    if( wcc == 0 ){
		/* don't break to relay response data into the cache */
 sv1log("## HTTP out to client TIMEOUT[%d]\n",fileno(RX_tcp));
		/*fcloseTIMEOUT(RX_tcp);*/
		setClientEOF(Conn,RX_tcp,"binary flush-1");
	    }
	    if( wcc < rcc ){
		if( !ClientEOF )
			setClientEOF(Conn,RX_tcp,"binary flush-2");
 sv1log("## HTTP ERROR incomplete fwrite(%d)=%d %d/%d, SIGPIPE=%d\n",
 rcc,wcc,RX_rdTotal,RX_rdContLen,nsigPIPE);
		if( RX_tcp == RX_respBuff )
		{
			fclose(RX_tcp);
			abortHTTP("disk full?");
		}

		if( RX_cachefp == NULL ){
 sv1log("## stop relay-2: FWRITE(%d)=%d, SIGPIPE=%d, no cache & no recipient\n",
 rcc,wcc,nsigPIPE);
			return -1;
		}
	    }
	    RX_noutput++;

	    Verbose("read %d / %d bytes / %d blocks; %d flush.\n",
		rcc,RX_rdTotal,RX_ninput,RX_nflush);
	}
	return wcc;
}

static void distFromCacheSetup(Connection *Conn,ResponseContext *RX,PCStr(cpath),FILE *cachefp)
{	CStr(scdate,256);
	int lastmod;
	MrefQStr(dcpath,RX_dcx.d_cpath); /**/

	lock_sharedNB(fileno(cachefp));
	stopDistribution(Conn,cachefp,cpath);

/*
 * copying too large file (larger than 1M bytes ?) should be avoided not to
 * make slower response to ther client and headvy load the the server...
 */

	dcpath = RX_dcx.d_cpath;
	RX_dcx.d_cpath[0] = 0;
	RX_dcx.d_fp = NULL;
	RX_dcx.d_ready = 0;
	RX_dcx.d_start = time(0);

	lastmod = HTTP_getLastModInCache(AVStr(scdate),sizeof(scdate),cachefp,cpath);
	if( lastmod ){
		sprintf(dcpath,"%s#%d",cpath,lastmod);
		RX_dcx.d_fp = fopen(dcpath,"r");
		if( RX_dcx.d_fp != NULL ){
			lock_unlock(fileno(cachefp));
			Verbose("distFromCache: share %s\n",dcpath);
			RX_dcx.d_ready = 1;
		}else{
			RX_dcx.d_fp = dirfopen("distFromCache",QVStr(dcpath,RX_dcx.d_cpath),"w+");
			Verbose("distFromCache: created %s\n",dcpath);
		}
	}
	if( RX_dcx.d_fp == NULL ){
		RX_dcx.d_fp = TMPFILE("distFromCache");
		if( RX_dcx.d_fp == NULL ){
			RX_dcx.d_fp = fdopen(dup(fileno(cachefp)),"r");
			Verbose("distFromCache: WITHOUT-LOCK %s\n",cpath);
			RX_dcx.d_ready = -1;
		}
	}
	if( RX_dcx.d_ready == 0 ){
		copyfile1(cachefp,RX_dcx.d_fp);
		fflush(RX_dcx.d_fp);
		fseek(RX_dcx.d_fp,0,0);
		lock_unlock(fileno(cachefp));
	}
}
static void distFromCacheDone(Connection *Conn,ResponseContext *RX)
{
	if( RX_dcx.d_ready )
		lock_unlock(fileno(RX_cachefp));
	lock_unlock(fileno(RX_dcx.d_fp));
	fclose(RX_dcx.d_fp);

	if( RX_dcx.d_cpath[0] ){
		int ucode;
		ucode = unlink(RX_dcx.d_cpath);
		Verbose("dcxFromCache: %d unlink=%d [%ds] %s\n",
			RX_dcx.d_ready,ucode,
			time(0)-RX_dcx.d_start,RX_dcx.d_cpath);
	}
}
static int cacheReadOK(FILE *cachefp)
{
	if( cachefp == NULL )
		return 0;
	if( file_size(fileno(cachefp)) <= 0 )
		return 0;
	return 1;
}
static void logCookie(Connection *Conn,ResponseContext *RX,PCStr(resCookie))
{	CStr(reqCookie,URLSZ);

	if( withCookie || *resCookie ){
		getFV(REQ_FIELDS,"Cookie",reqCookie);
		sv1log("[Cookie:%s][Set-Cookie:%s][Cache-Control:%s]\n",
			reqCookie,resCookie,RX_cachecontrol);
	}
}

static void Fpurge(FILE *tc)
{	int cfd,sfd;
	int tfd;
	FILE *tmp;

	if( tc == NULL )
		return;

	/*
	tmp = fopen("/dev/null","w");
	*/
	tfd = open("/dev/null",1); tmp = fdopen(tfd,"w");

	if( tmp == NULL )
		tmp = tmpfile();
	if( tmp == NULL )
		return;
	cfd = fileno(tc);
	sfd = dup(cfd);
	dup2(fileno(tmp),cfd);
	fclose(tmp);
	fflush(tc);
	dup2(sfd,cfd);
	close(sfd);
	Ftruncate(tc,0,0);
}

extern const char *TIMEFORM_mdHMS;
int modwatch_enable;
const char *modwatch_notify;
int modwatch_approver;
static int modwatchHead(Connection *Conn,ResponseContext *RX)
{	CStr(md5,64);
	CStr(mdpath,URLSZ);
	CStr(appath,URLSZ);
	CStr(approver,URLSZ);
	CStr(acap,128);
	CStr(old,URLSZ);
	CStr(xnew,URLSZ);
	refQStr(cp,xnew); /**/
	CStr(msg,URLSZ);
	CStr(lmtime,64);
	CStr(event,URLSZ);
	refQStr(ep,event); /**/
	const char *op;
	CStr(omtime,64);
	CStr(ctime,64);
	CStr(lpath,URLSZ);
	CStr(url,URLSZ);
	CStr(req,URLSZ);
	FILE *afp,*log;
	int rcc,len,osize,oapproved;


	HTTP_originalURLx(Conn,AVStr(url),sizeof(url));
	sprintf(req,"%s/%s %s",REQ_METHOD,REQ_VER,url);
	/* should use REQ_URL + Host: filed ? */
	toMD5(req,md5);
	Strins(QVStr(md5+2,md5),"/");

	sprintf(appath,"${ADMDIR}/approved/%s",md5);
	DELEGATE_substfile(AVStr(appath),"",VStrNULL,VStrNULL,VStrNULL);
	sprintf(mdpath,"${ADMDIR}/modified/%s",md5);
	DELEGATE_substfile(AVStr(mdpath),"",VStrNULL,VStrNULL,VStrNULL);

	afp = dirfopen("modwatchHead",AVStr(appath),"r+");
	if( afp != NULL ){
		oapproved = 1;
	}else{
		oapproved = 0;
		afp = dirfopen("modwatchHead",AVStr(mdpath),"r+");
	}
	if( afp != NULL ){
		rcc = fread(old,1,sizeof(old),afp);
		old[rcc] = 0;
		fseek(afp,0,0);
	}else{
		afp = dirfopen("modwatchHead",AVStr(mdpath),"w");
		if( afp == NULL )
			return 0;
		rcc = 0;
		old[rcc] = 0;
	}
	StrftimeLocal(AVStr(lmtime),sizeof(lmtime),TIMEFORM_mdHMS,RX_lastModTime,0);
	for( op = lmtime; *op; op++ )
		if( *op == ' ' )
			*(char*)op = '-';

	setVStrEnd(xnew,0);
	cp += strlen(cp); sprintf(cp,"RQ=\"%s/%s %s\";",REQ_METHOD,REQ_VER,url);
	cp += strlen(cp); sprintf(cp,"CT=%s;",RX_ctype);
	cp += strlen(cp); sprintf(cp,"CL=%d;",RX_rdContLen);
	cp += strlen(cp); sprintf(cp,"MT=%s;",lmtime);
	cp += strlen(cp);
	len = cp - xnew;

	makeClientLog(Conn,AVStr(approver));
	StrftimeLocal(AVStr(ctime),sizeof(ctime),TIMEFORM_mdHMS,time(0),0);
	cp += strlen(cp); sprintf(cp,"AT=%s;",ctime);
	cp += strlen(cp); sprintf(cp,"AU=%s;",approver);

	if(  strncmp(old,xnew,len) == 0 ){
		fclose(afp);
		return 0;
	}

	sprintf(lpath,"${ADMDIR}/modified.log");
	DELEGATE_substfile(AVStr(lpath),"",VStrNULL,VStrNULL,VStrNULL);
	log = dirfopen("modified.log",AVStr(lpath),"a");

	if( strstr(old+len,"DT=") == NULL ){
		/* the first detection of modification */
		if( old[0] )
			fseek(afp,-1,2);
		fprintf(afp,"DT=%s;\n",ctime);
		Ftruncate(afp,0,1);
		fseek(afp,0,0);

		ep = event;
		if( old[0] )
			sprintf(event,"modified: ");
		else	sprintf(event,"detected: ");
		ep += strlen(ep); sprintf(ep,"%s [%s]%d",url,lmtime,
			RX_rdContLen);
		ep += strlen(ep);
		if( old[0] ){
			osize = 0;
			if( op = strstr(old,"CL=") )
				sscanf(op,"CL=%d",&osize);
			omtime[0] = 0;
			if( op = strstr(old,"MT=") )
				Xsscanf(op,"MT=%[^;]",AVStr(omtime));
			sprintf(ep," %d[%s]",osize,omtime);
		}
		sprintf(msg,"\tFILE:%s\n\tWHAT:%s\n\tOLD:%s\tNEW:%s\n",
			mdpath,event,old[0]?old:"\n",xnew);
		if( log ){
			fseek(log,0,2);
			fprintf(log,"-%s\n%s",event,msg);
			fflush(log);
		}
		if( modwatch_notify ){
			for( op = msg; *op; op++ )
				if( *op == '\t' )
					*(char*)op = ' ';
			notify_ADMINX(Conn,modwatch_notify,event,msg);
		}
	}

	if( modwatch_approver == 0 ){
		if( log != NULL )
			fclose(log);
		goto APPROVED;
	}

	ep = event;
	sprintf(event,"approved: ");
	ep += strlen(ep); sprintf(ep,"%s [%s]%d",url,lmtime,RX_rdContLen);
	ep += strlen(ep); sprintf(ep," %s",old[0]?"M":"D");
	ep += strlen(ep); sprintf(ep," [%s][%d]",approver,getpid());
	sprintf(msg,"\tFILE:%s\n\tWHAT:%s\n\tOLD:%s\tNEW:%s\n",
		mdpath,event,old[0]?old:"\n",xnew);

	if( old[0] )
	if( find_CMAP(Conn,CMAP_APPROVER,AVStr(acap)) < 0
		 /* the client is not an approver */
	 /* && age < 1week ? */
	){
		Fpurge(RX_tc_sav);
		Fpurge(RX_tcp);
		fprintf(RX_tcp,"HTTP/%s 503 Service Unavailable\r\n",
			MY_HTTPVER);
		fprintf(RX_tcp,"\r\n");
		fprintf(RX_tcp,"Service Unavailable\r\n");
		fflush(RX_tcp);
		RespCode = RX_code = 503;

		if( oapproved ){
			renameRX(appath,mdpath);
		}
		if( log ){
			fseek(log,0,2);
			fprintf(log,"-un%s\n",event);
			fclose(log);
		}
		fclose(afp);
		return -1;
	}
	if( log ){
		fseek(log,0,2);
		fprintf(log,"-%s\n%s",event,msg);
		fclose(log);
	}
	if( modwatch_notify ){
		for( op = msg; *op; op++ )
			if( *op == '\t' )
				*(char*)op = ' ';
		notify_ADMINX(Conn,modwatch_notify,event,msg);
	}
	if( !oapproved ){
		renameRX(mdpath,appath);
	}
	sv1tlog("modwatch-old: %s",old);
	sv1tlog("modwatch-new: %s",xnew);

APPROVED:
	fprintf(afp,"%s\n",xnew);
	Ftruncate(afp,0,1);
	fclose(afp);
	return 0;
}

static int checkServ(Connection *Conn)
{
	if( 0 < CheckServ ) return 1;
	if( CheckServ < 0 ) return 0;

	if( 1024 <= DST_PORT ){
		CheckServ = -1;
		return 0;
	}
	if( DST_PORT == 80 || DST_PORT == 443 )
	if( BadRequest == 0 && Normalized == 0 ){
		CheckServ = -1;
		return 0;
	}

	CheckServ = 1;
	return 1;
}

#define BS_CONNECT	0
#define BS_QLINE	1
#define BS_QHEAD	2
#define BS_QBODY	3
#define BS_RHEAD	4


static const char *rvers;
void HTTP_setRespVers(PCStr(vers))
{
	rvers = stralloc(vers);
}
int HTTP_accRespVer(PCStr(statline))
{	CStr(ver,16);
	int acc;

	if( rvers ){
		wordScan(statline,ver);
		if( strcmp(rvers,"*") == 0 ){
			sv1log("Accepted: %s",statline);
			return 1;
		}
		if( acc = isinList(rvers,ver) ){
			sv1log("Accepted: %s",statline);
			return acc;
		}
	}
	return 0;
}
static int badServ(Connection *Conn,PCStr(where),int whid,FILE *ts,FILE *fs,PCStr(statline))
{	CStr(buf,128);
	int rcc,timeout;

	if( 0 < BadServ ) return 1;
	if( BadServ < 0 ) return 0;

	if( BS_RHEAD <= whid && !HTTP_reqWithHeader(Conn,REQ) ){
		BadServ = -1;
		return 0;
	}

	if( statline != NULL ){
		rcc = strlen(statline);
		goto check;
	}
	if( !checkServ(Conn) )
		return 0;

	if( file_isreg(fileno(fs)) ){ /* maybe NULLFP() */
		BadServ = -1;
		return 0;
	}

	if( ts != NULL )
		fflush(ts);
	if( (HTTP_WAIT_BADSERV*1000) < WaitServ )
		return 0;

	if( whid == BS_QBODY ){
		if( DST_PORT == 80 || DST_PORT == 443 )
			timeout = 10;
		else	timeout = 500;
	}else
	if( BadRequest || Normalized ){
		if( DST_PORT == 80 || DST_PORT == 443 )
			timeout = 100;
		else	timeout = 500;
	}else{
		if( DST_PORT == 80 || DST_PORT == 443 )
			timeout = 1;
		else	timeout = 10;
	}

	WaitServ += timeout;
	if( fPollIn(fs,timeout) <= 0 )
		return 0;
	rcc = fgetBuffered(AVStr(buf),sizeof(buf),fs);
	if( rcc == 0 )
		rcc = recvPeekTIMEOUT(fileno(fs),AVStr(buf),sizeof(buf)-1);
	if( rcc <= 0 )
		return 0;
	buf[rcc] = 0;
	statline = buf;
	sv1log("## badServer? %s: BQ=%d+%d %d: %s",
		where,BadRequest,Normalized,rcc,statline);

check:
	if( statline[0] == 0 ){
		return 0;
	}
/*
	if( strncmp(statline,"HTTP/",5) == 0 ){
*/
	if( strncmp(statline,"HTTP/",4) == 0 ){
		BadServ = -1;
		return 0;
	}
	if( HTTP_accRespVer(statline) ) {
		BadServ = -1;
		return 0;
	}

	sv1log("## badServer! %s: BQ=%d+%d %d: %s",
		where,BadRequest,Normalized,rcc,statline);
	lineScan(where,BadServDetected);
	lineScan(statline,BadServResponse);
	httpStat = CS_BADREQUEST;
	BadServ = 1;
	return 1;
}
static void putBadRequest(Connection *Conn,FILE *tc,PCStr(reason))
{
	if( reason ){
		sv1log("## badRequest: [%s] Request[%s]\n",reason,OREQ_MSG);
	}else{
	sv1log("## badRequest: Server[%s/%dms][%s] Request[%d+%d][%s]\n",
		BadServDetected,WaitServ,
		BadServResponse,BadRequest,Normalized,OREQ_MSG);
	}

	fprintf(tc,"HTTP/%s 400 Bad Request\r\n",MY_HTTPVER);
	fprintf(tc,"Content-Type: text/plain\r\n");
	fprintf(tc,"Connection: close\r\n");
	fprintf(tc,"\r\n");
	fprintf(tc,"<plaintext>\r\n");
	if( reason )
		fprintf(tc,"Bad Request: %s\r\n",reason);
	else	fprintf(tc,"Bad Request\r\n");
	fprintf(tc,"%s",OREQ_MSG);
	http_Log(Conn,400,CS_BADREQUEST,REQ,0);
}
static void putBadResponse(Connection *Conn,FILE *tc)
{
	sv1log("## badServer: Server[%s/%dms][%s] Request[%d+%d][%s]\n",
		BadServDetected,WaitServ,BadServResponse,
		BadRequest,Normalized,OREQ_MSG);

	fprintf(tc,"HTTP/%s 502 Bad Response\r\n",MY_HTTPVER);
	fprintf(tc,"Content-Type: text/plain\r\n");
	fprintf(tc,"Connection: close\r\n");
	fprintf(tc,"\r\n");
	fprintf(tc,"<plaintext>\r\n");

	fprintf(tc,"Bad Response:\r\n%s\r\n\r\n",BadServResponse);
	fprintf(tc,"Original Request:\r\n%s\r\n\r\n",OREQ_MSG);
	http_Log(Conn,502,CS_BADREQUEST,REQ,0);
}

int relay_responseX(Connection *Conn,QueryContext *QX,int cpid,PCStr(proto),PCStr(server),int iport,PCStr(req),PCStr(acpath),int fromcache, FILE *afs,FILE *atc,FILE *afc,FILE *acachefp,int cache_rdok, ResponseContext *RX,PVStr(refbuf));

/**/
static int relay_response(Connection *Conn,QueryContext *QX,int cpid,PCStr(proto),PCStr(server),int iport,PCStr(req),PCStr(acpath),int fromcache,FILE *afs,FILE *atc,FILE *afc,FILE *acachefp,int cache_rdok)
{	UTag RXut;
	UTag refbufut;
	int rcode;
	ResponseContext *RX;

	RXut = UTalloc(SB_CONN,sizeof(ResponseContext),8);
	refbufut = UTalloc(SB_CONN,URLSZ,1);
	RX = (ResponseContext*)RXut.ut_addr;
	RX->r_line0t = UTalloc(SB_CONN,RESP_LINEBUFSZ,1);
	RX->r_line1t = UTalloc(SB_CONN,RESP_LINEBUFSZ,1);
	RX->r_Anchor_rem = UTalloc(SB_CONN,1024,1);
	setVStrEnd(Anchor_rem,0);

	rcode =
	relay_responseX(Conn,QX,cpid,proto,server,iport,req,acpath,fromcache,
		afs,atc,afc,acachefp,cache_rdok,
		(ResponseContext*)RXut.ut_addr,AVStr(refbufut.ut_addr));

	UTfree(&RX->r_Anchor_rem);
	UTfree(&RX->r_line1t);
	UTfree(&RX->r_line0t);
	UTfree(&RXut);
	UTfree(&refbufut);
	return rcode;
}
int HTTP_relay_response(Connection *Conn,int cpid,PCStr(proto),PCStr(server),int iport,PCStr(req),PCStr(acpath),int fromcache, FILE *afs,FILE *atc,FILE *afc,FILE *acachefp,int cache_rdok)
{	QueryContext QXbuf, *QX = &QXbuf;

	bzero(QX,sizeof(QueryContext));
	return
  relay_response(Conn,QX,cpid,proto,server,iport,req,acpath,fromcache,
afs,atc,afc,acachefp,cache_rdok);
}

static int NoCacheField(Connection *Conn,ResponseContext *RX,PCStr(field)) 
{
	if( STRH(field,F_DGVer)       ) return 1;
	if( STRH(field,F_TransEncode) ) return 1;
	if( STRH(field,F_KeepAlive)   ) return 1;
	if( STRH_Connection(field)    ) return 1;
	if( STRH(field,F_ContLeng) ){
		if( RX_cencoded ){
			/* don't cache Content-Length for Content-Encoding */
			return 1;
		}
	}
	return 0;
}

FILE *recvHTTPbody(Connection *Conn,ResponseContext *RX,FILE *fp)
{   int rcc,wcc,lastRcc;
    ResponseContext RXbuf;
	double Now,Next = 0;

    if( RX_ovw == 0 ){
    RXbuf = *RX;
    RX = &RXbuf;
    }
    RX_tcp = fp;

    for(;;){
	/* 8.1.0: detect connection reset from client during buffering.  It
	 * shold be PollIns([fileno(fsp),ClientSock]) to reduce overhead
	 * for checking.
	 */
	if( 0 < ClientSock ){
	Now = Time();
	if( Next <= Now )
	if( READYCC(fp) <= 0 ){ /* to reduce checking (no buffered chunks) */
		/* this READYCC(fp) seems to have been READYCC(RX_fsp),
		 * but seems not to work well to reduce checking, anyway ... */
		if( 0 <= ClientSock && IsAlive(ClientSock) == 0 ){
			setClientEOF(Conn,RX_tcp,"recvHTTPbody");
			break;
		}
		Next = Now + 1;
	}
	}

	if( RX_fsx.t_EOF )
		break;
	if( feof(RX_fsp) )
		break;
	if( RX_fsx.t_chunked ){
		lastRcc = RX_fsx.t_lastRcc;
		if( RX_fsx.t_chunk_ser && 0 < lastRcc ){
			Verbose("#HT11 --getChunk[%d] data  : %d / %d / %d\n",
				RX_fsx.t_chunk_ser,lastRcc,
				RX_fsx.t_chunk_rem,RX_fsx.t_chunk_siz);

			RX_fsx.t_chunk_rem -= lastRcc;
			RX_remsize = RX_fsx.t_chunk_rem;
			if( sizeof(RX_rdBuff)-1 < RX_remsize )
				RX_remsize = sizeof(RX_rdBuff) -1;
		}
		if( RX_fsx.t_chunk_rem == 0 ){
			if( getChunk(RX) < 0 )
				break;
			RX_fsx.t_lastRcc = 0;
			continue;
		}
	}else
	if( RX_fsx.t_keepAlive && 0 < RX_rdContLen ){
		RX_remsize = RX_rdContLen - RX_rdTotal;
		if( sizeof(RX_rdBuff)-1 < RX_remsize )
			RX_remsize = sizeof(RX_rdBuff)-1;
		Verbose("#HT11 --Length=%d = %d + %d\n",
			RX_rdContLen,RX_rdTotal,RX_remsize);
		if( RX_rdContLen <= RX_rdTotal )
			break;
	}
	rcc = GETRESPBIN(Conn,RX,0,RX_fsx.t_nready);
	RX_rdTotal += rcc;
	wcc = fwrite(RX_rdBuff,1,rcc,RX_tcp);
	if( wcc < rcc ){
		fclose(RX_tcp);
		abortHTTP("disk full in recvHTTPbody?");
		break;
	}
	RX_wrTotal += wcc;
	RX_noutput++;
    }
    return RX_tcp;
}
int recvHTTPbodyX(Connection *Conn,int chunked,FILE *in,FILE *out){
	ResponseContext RXbuf,*RX = &RXbuf;

	bzero(RX,sizeof(RXbuf));
	RX_ovw = 1;
	RX_fsp = in;
	RX_fsx.t_chunked = chunked;
	recvHTTPbody(Conn,RX,out);
	return RX_wrTotal;
}

#define RF_CACHED	1
#define RF_DECODED	2

static void flushSlowResponse(Connection *Conn,ResponseContext *RX,int fromcache)
{	CStr(flush,128);

	flush[0] = 0;

	if( (fromcache & RF_DECODED) == 0 )
        if( WillKeepAlive )
        if( RX_tcp == RX_respBuff && !RX_inHeader && !ClientEOF )
	{
		if( 1024*1024 < RX_rdContLen
		 && !(RX_guessCharset && RX_rdTotal==0) )
			sprintf(flush,"too large ContLen: %d",RX_rdContLen);
		else
		if( 1024*1024 < RX_rdTotal )
			sprintf(flush,"too much read: %d",RX_rdTotal);
		else
		if( 8 < Time()-CONN_DONE )
			sprintf(flush,"too long time:%d",(int)Time()-CONN_DONE);
		else
		if( !fromcache
		 && 5 < Time()-CONN_DONE
		 && RX_fsx.t_nready == 0
		 && (RX_fsx.t_nready = fPollIn(RX_fsp,100)) == 0 )
		/*
		 && (RX_fsx.t_nready = fPollIn(RX_fsp,100)) == 0
		 && 5 < Time()-CONN_DONE )
		*/
			sprintf(flush,"time out: %d",(int)Time()-CONN_DONE);
	}
	if( flush[0] ){
		sv1log("#### flushResp: %s\n",flush);
		RX_tcp = detach_respbuff(Conn,RX_tcp,RX_tc_sav,
			RX_qWithHeader,"flush slow response.");
	}
}

/*
 * set the original charset in Set-Cookie
 */
static void setSVCC(Connection *Conn,ResponseContext *RX,PVStr(rhead)){
	CStr(rcharset,64); /* peeked charset */
	if( CCXactive(CCX_TOCL) == 0 ){
		/* not necessary, charset will not be converted */
		return;
	}
	if( RX_tcx.t_chunked == 0 ){
		/* not necessary, charset will be set in putMIME_msg() */
		return;
	}
	rcharset[0] = 0;
	extractParam(AVStr(rhead),"Content-Type","charset",AVStr(rcharset),
		sizeof(rcharset),0);
	if( rcharset[0] == 0 ){
		/* should try scan_metahttp "HTTP-EQUIV Content-Type charset" */
		CStr(tmp,512);
		CCXexec(CCX_TOCL,rhead,strlen(rhead),AVStr(tmp),sizeof(tmp));
	}
	putProxyCookie(Conn,RX_tcp,rcharset);
}

int relay_responseX(Connection *Conn,QueryContext *QX,int cpid,PCStr(proto),PCStr(server),int iport,PCStr(req),PCStr(acpath),int fromcache, FILE *afs,FILE *atc,FILE *afc,FILE *acachefp,int cache_rdok, ResponseContext *RX,PVStr(refbuf))
{	Referer refererb;
	vfuncp osigpipe;
	int lastRcc;
	MrefQStr(line,RX_rdBuff); /**/
	const char *got1;
	int rcc;
	int mytype;
	FILE *tmp_fsp = 0;
	CStr(rhead,512); /* peeked response header */
	int ifd = fileno(afs);
	double Now,Next = 0;
	int SWF_MOUNT = 0;
	int isText = 0;
	int fromcacheX = fromcache;

	RX_woURI = 0;
	RX_cencoded = 0;
	rhead[0] = 0;
	/*
	if( ready_cc(afs) <= 0 ){
		int ifd = fileno(afs);
	*/
	if( ready_cc(afs) <= 0 || file_isreg(ifd) ){
		if( file_isreg(ifd) ){
			int off;
			off = ftell(afs);
			rcc = fread(rhead,1,sizeof(rhead)-1,afs);
			fseek(afs,off,0);
		}else
		if( file_ISSOCK(ifd) ){
			int timeout;
			if( HTTP_TOUT_RESPLINE )
				timeout = (int)(1000 * HTTP_TOUT_RESPLINE);
			else	timeout = (int)(1000 * IO_TIMEOUT);
			if( PollIn(ifd,timeout) == 0 ){
			sv1log("HTTP relay_response: TIMEOUT at resp. peek\n");
				http_Log(Conn,500,CS_TIMEOUT,req,0);
				return R_EMPTY_RESPONSE;
			}
			/* blocked on FTOSV error (request is not sent) */
			rcc = RecvPeek(ifd,rhead,sizeof(rhead)-1);
		}else{
			rcc = -1;
		}
		if( 0 < rcc ){
			int hi,isbin,iszip,istxt;
			char ch;
			const char *val;
			/*
			CStr(cenc,8);
			*/
			CStr(cenc,16);
			rhead[rcc] = 0;

			istxt = 0;
			iszip = 0;
			isbin = 0;

			if( val = findFieldValue(rhead,"Content-Type") ){
				if( strncasecmp(val,"image/",6) == 0
				){
					RX_woURI = 1;
				}
				if( strncasecmp(val,"text/",5) == 0 ){
					istxt = 1;
					isText = 1;
				}
				if( strncasecmp(val,"text/css",8) == 0 ){
					/* for Mozilla/4.7 */
					sv1log("#CEcl no gzip for CSS\n");
					RESP_DoZIP = 0;
				}
				if( URL_SEARCH & URL_IN_SWF )
		if( strncasecmp(val,"application/x-shockwave-flash",29)==0 )
					SWF_MOUNT = 1;
			}
			if( val = findFieldValue(rhead,"Content-Encoding") ){
				RX_cencoded = 1;
				wordScan(val,cenc);
				if( isinList("gzip,deflate",cenc) ){
					iszip = 1;
				}
			}
			for( hi = 0; hi < rcc; hi++ ){
				ch = rhead[hi];
				if( ch == 0 ){
					isbin = 1;
					break;
				}
			}
			if( RESP_DoZIP ){
				if( !istxt ){
					Verbose("#CEcl no gzip for non text\n");
					RESP_DoZIP = 0;
				}else
				if( istxt && isbin && !iszip ){
					/* mal-typed binary ? */
					Verbose("#CEcl no gzip for binary\n");
					RESP_DoZIP = 0;
				}
			}
		}
	}
	if( RESP_DoUNZIP || RESP_DoZIP ){
		/* thru .gz file for efficiency of relay and cache */
		if( strtailstr(REQ_URL,".gz") )
		/*
		if( !isText )
		the type might be text for binary data...
		*/
		{
			sv1log("#CEcl thru %d/%d %s\n",RESP_DoUNZIP,RESP_DoZIP,
				REQ_URL);
			RESP_DoUNZIP = 0;
			RESP_DoZIP = 0;
		}
	}

	RX_Conn = Conn;
	RX_tmpFileId = "HTTP-respBuff";
	RX_ovw = 0;
	RX_cachefp = acachefp;
	RX_cpath = (char*)acpath;
	RX_referer = &refererb;
	RX_inHeader = 1;

	RX_tc_sav = 0;
	RX_tcp = atc;
	RX_fromcache = fromcache;
	RX_fsp = afs;
	RX_fsx.t_EOF = 0;
	RX_fsx.t_lastRcc = 0;
	RX_fsx.t_chunked = 0;
	RX_fsx.t_chunk_ser = 0;
	RX_fsx.t_chunk_siz = 0;
	RX_fsx.t_chunk_rem = 0;
	RX_fsx.t_keepAlive = 0;
	RX_remsize = sizeof(RX_rdBuff) - 1;

	line = RX_rdBuff;

	if( HTTP_opts & HTTP_NOCHUNKED ){
		RX_tcx.t_chunked = 0;
	}else
	if( ClntAccChunk && RESP_DoZIP ){
		Verbose("#CEcl disable chunk for Content-Encoding\n");
		RX_tcx.t_chunked = 0;
	}else
	if( SWF_MOUNT )
		RX_tcx.t_chunked = 0;
	else
	if( Conn->xf_filters & (XF_FCL|XF_FTOCL) )
		RX_tcx.t_chunked = 0;
	else
	if( RX_fromcache && !withConversionX(Conn,0,RX_woURI) ){
		RX_tcx.t_chunked = 0;
	}
	else	RX_tcx.t_chunked = ClntAccChunk;
	RX_tcx.t_chunk_ser = 0;

	RX_Start = Time();
	RX_qWithHeader = HTTP_reqWithHeader(Conn,req);
	wordScan(req,RX_qmethod);
	RX_reqHEAD = strcasecmp(RX_qmethod,"HEAD") == 0;

	RX_tryKeepAlive = 0;
	if( ClntKeepAlive ){
		if( strcaseeq(RX_qmethod,"GET")||strcaseeq(RX_qmethod,"HEAD") )
			RX_tryKeepAlive = 1;
		else
		clntClose(Conn,"M:Method is ``%s'' cpid=[%d]",RX_qmethod,cpid);
	}

	QX_hcode = 0;
	for(;;){
		got1 = GETRESPTXT(Conn,RX,fromcache);
		/* 8.11.2: test for badServ
		sprintf(line,"<html>\r\n");
		*/

		if( !fromcache && badServ(Conn,"RESP",BS_RHEAD,NULL,afs,line) )
			return R_EMPTY_RESPONSE;

		lastRcc = RX_fsx.t_lastRcc;
		RespCode = decomp_http_status(line,&RX_status);
		RX_Resp1 = Time();

		if( RX_code == 100 ){
			sv1log("#HT11 [%s] Skip %s",REQ_VER,line);
			if( 0 <= vercmp(REQ_VER,"1.1") )
				fputs(line,RX_tcp);
			while( got1 = GETRESPTXT(Conn,RX,fromcache) ){
				if( 0 <= vercmp(REQ_VER,"1.1") )
					fputs(line,RX_tcp);
				sv1log("#HT11 [%s] Skip %s",REQ_VER,line);
				if( line[0] == '\r' || line[0] == '\n' )
					break;
			}
			if( feof(RX_fsp) ){
				sv1log("#HT11 Skip ... EOF\n");
			}else{
				fflush(RX_tcp);
				continue;
			}
		}
		if( RX_code == 101 ){
			/* Connection upgrade ... */
		}
		break;
	}
	QX_hcode = RX_code;

	if( RX_code != 1200 )
	if( RX_tcx.t_chunked ){
		if( strcmp(RX_ver,"HTTP/1.1") < 0 ){ 
			sv1log("#HT11 resp version: %s -> %s\n",RX_ver,"1.1");
			sprintf(line,"HTTP/1.1 %d %s\r\n",RX_code,RX_reason);
			lastRcc = RX_fsx.t_lastRcc = strlen(line);
		}
	}

	if( cpid )
		Kill(cpid,SIGTERM);
	if( got1 == NULL ){
		sv1log("HTTP relay_response: EOF at start\n");
		http_Log(Conn,500,CS_EOF,req,0);
		return R_EMPTY_RESPONSE;
	}

	if( RX_cachefp != NULL && 500 <= RX_code ){
		if( cache_rdok ){
			sv1log("HTTP temporary error ? %s",line);
			http_Log(Conn,RX_code,CS_EOF,req,0);
			copy_fileTIMEOUT(RX_fsp,NULLFP(),NULL);
			return R_EMPTY_RESPONSE;
		}
		RX_cachefp = NULL;
		DontTruncate = 1;
	}

	if( RX_cachefp != NULL ){
		Verbose("CacheMtime: %d : %d\n",CacheMtime,
			file_mtime(fileno(RX_cachefp)));

		if( CacheMtime != file_mtime(fileno(RX_cachefp)) ){
			int fd;

			sv1log("## !!! Cache is updated by someone else.\n");
/*
RX_cachefp = NULL;
*/
			fd = open(RX_cpath,0);
			dup2(fd,fileno(RX_cachefp));
			close(fd);
			DontTruncate = 1;
		}
	}

	/*
	 *	If the transmission speed from the server is slow,
	 *	do flush frequently.
	 */
	if( fromcache ){
		RX_connDelay = 0;
	}else{
		int delay;

		RX_connDelay = CONN_DONE - CONN_START;
		RX_firstResp = Time() - CONN_DONE;
		daemonlog("D","connDelay:%5.2fsec, firstResp:%5.2fsec\n",
			RX_connDelay,RX_firstResp);
	}

	if( checkClientEOF(Conn,RX_tcp,"start_response") ){
		httpStat = CS_EOF;
		return R_UNSATISFIED;
	}

	RX_noBody = RX_reqHEAD;

/*
	if( ToMyself )
*/
	if( ToMyself || IsMounted )
		mytype = 0;
	else
	if( DO_DELEGATE )
		mytype = RELAY_DELEGATE;
	else	mytype = RELAY_PROXY;

	NOJAVA = 0;
	if( do_RELAY(Conn,mytype|RELAY_APPLET) == 0 )
		NOJAVA |= RELAY_APPLET;
	if( do_RELAY(Conn,mytype|RELAY_OBJECT) == 0 )
		NOJAVA |= RELAY_OBJECT;

	RX_errori = 0;
	RX_isText = 0;
	RX_isBin = 0;
	RX_rdHeadTotal = 0;
	RX_rdTotal = 0;
	RX_wrTotal = 0;
	RX_wrHeadTotal = 0;
	RX_wrbufed = 0;
	RX_putPRE = 0;
	clearPartfilter(&RX->r_partf);
	RX_isHTTP09 = 0;
	RX_lastMod = 0;
	RX_lastModTime = 0;
	RX_setCookie[0] = 0;
	RX_cachecontrol[0] = 0;
	RX_lastVia[0] = 0;

	RX_ctype[0] = 0;
	RX_connection[0] = 0;
	RX_expires[0] = 0;
	RX_cencoding[0] = 0;
	RX_servername[0] = 0;
	RX_tencoding[0] = 0;
	RX_rdContLen = 0;
	RX_rdContLenGot = 0;
	RX_xrdLen = 0;
	RX_txtLen = 0;
	RX_binLen = 0;
	RX_bodyLines = 0;
	RX_nflush = 0;
	RX_noutput = 0;
	RX_niced = 0;
	RX_respBuff = NULL;
	RX_guessCharset = 0;

	if( 400 <= RX_code ){
		HTTP_setRetry(Conn,req,RX_code);
	}
	if( Conn->sv_retry != 0 ){
		sv1log("ERROR (%d) to be RETRYed\n",RX_code);
		RX_tcp = NULLFP();
		/* RX_tcp must not be fclose() ... */
	}else
	if( RX_code == 403 )
		HTTP_delayReject(Conn,req,line,0);
	else
	if( RX_code == 404 )
	{
		if( streq(REQ_URL,"/favicon.ico") ){
			sv1log("DONT DELAY [%s]\n",REQ_URL);
		}else
		delayUnknown(Conn,DO_DELEGATE||IsMounted,OREQ);
	}

/* This will not work well when the client is DeleGate with cache
 * and  its cache is newer than the cache of this DeleGate.
 */
	if( RX_code == 304 ){
		int cacheOk;
		int forceBody;

		cacheOk = cacheReadOK(RX_cachefp);
		sv1log("HTTP status: %d %s => %x/%d\n",
			RX_code,RX_reason,RX_cachefp,cacheOk);

		if( cacheOk ){
			ftouch(RX_cachefp,time(0));
			forceBody = forceBodyResponse(Conn);
		}else{
			forceBody = 0;
			sv1log("No-Cache to reuse\n");
		}

		if( ClntIfMod[0] && !forceBody && CacheLastMod<=ClntIfModClock){
			Verbose("%d is relayed to the client.\n",RX_code);
			if( RX_cachefp ){
				Verbose("DontWriteCache 304 not modified.\n");
				/*fclose(RX_cachefp);*/
				RX_cachefp = NULL;
				DontTruncate = 2;
			}
		}else
		if( RX_cachefp ){
/*
 * 304 should be passed thru to the client if it is a delegated
 * with cache file which is very same with this delegated.
 */
			while( GETRESPTXT(Conn,RX,fromcache) != NULL ){
				int fnlen;
				if( *line == '\r' || *line == '\n' )
					break;
				if( fnlen = STRH_Connection(line) ){
					Verbose("HCKA:[R] %s",line);
					lineScan(line+fnlen,RX_connection);
				}
			}

			sv1log("HTTP <=+= %d [%s] %s",RespCode,RX_cpath,req);
			httpStat = CS_STABLE;

			distFromCacheSetup(Conn,RX,RX_cpath,RX_cachefp);
			RX_code = relay_response(Conn,QX,0,proto,server,iport,req,
				RX_dcx.d_cpath,1,RX_dcx.d_fp,RX_tcp,NULL,NULL,1);
			distFromCacheDone(Conn,RX);

			setServKeepAlive(Conn,RX);
			return RX_code;
		}
		RX_noBody = 1;
		RX_lastMod = 1;
	}else{
		if( DontReadCache ){
			httpStatX = CS_RELOAD;
		}else
		if( RX_cachefp != NULL && cache_rdok )
			httpStat = CS_OBSOLETE;
	}

	if( RX_code == 1200 ){
		CStr(xline,64);

		RX_rdTotal = lastRcc;
		RX_isHTTP09 = 1;
		RX_inHeader = 0;

		if( strchr(line,'\n') )
			RX_isText = TX_HTML; /* HTML is assumed */

		XStrncpy(AVStr(xline),line,sizeof(xline)-8);
		if( strtailchr(xline) != '\n' )
			strcat(xline," ...\n");

		sv1log("No header (HTTP/0.9) : %s assumed : [%x][%x]%s",
			(RX_isText?"text":"binary"), xline[0],xline[1],xline);
	}else{
		RX_rdHeadTotal = lastRcc;
		switch( RX_code ){
		case 200:
		case 301:
		case 302: /* OK and cachable */
			break;
		case 303:
			if( vercmp(REQ_VER,"1.1") < 0 ){
				refQStr(dp,line); /**/
				sv1log("#HT11 303 resp. converted to 302\n");
				RX_code = 302;
				if( dp = strstr(line,"303") )
					Bcopy("302",dp,3);
			}
			break;
		case 304:
			break;
		case 305:
		case 306:
			break;
		case 206:
		case 207: /* WebDAV */
			if( RX_cachefp == NULL )
				break;
			sv1log("-- %d is NOT error but no-cache ...\n",RX_code);
		default:
			sv1log("HTTP error request: %s",req);
			sv1log("HTTP error status: %d %s\n",RX_code,RX_reason);
			RX_errori = -RX_code;
		}
	}

	setReferer(Conn,proto,server,iport,req,RX_referer,AVStr(refbuf));

	RX_convChar = CTX_cur_codeconvCL(Conn,VStrNULL) || CCXactive(CCX_TOCL);
	RX_deEnt = toProxy && protoGopher(DST_PROTO);

	/*
	if( (RX_code==305 || RX_code==306) && (ConnType=='p' || ConnType=='m') ){
	*/
	if( (RX_code==305 || RX_code==306) && (ConnType=='p' || ConnType=='m') 
	 || (RX_code==401 || RX_code==407) && (HTTP_opts & HTTP_DOAUTHCONV)
	){
		RESP_SAV = 1;
		/* RX_tcp = NULLFPW(); */
		RX_tcp = TMPFILE("RESP_MSG");
		strcpy(RESP_MSG,line);
		RESP_LEN = strlen(line);
	}else{
		if( !RX_inHeader && RX_isText==TX_HTML ){
			RX_wrTotal += FPUTS(AVStr(line),"text/html",!RX_inHeader && RX_convChar,RX_deEnt);
		}else{
			if( RX_qWithHeader || !RX_inHeader )
				RX_wrHeadTotal += fwrite(line,1,lastRcc,RX_tcp);
		}

		if( !RX_isHTTP09 && RX_inHeader ){
			if( !ImResponseFilter )
			if( RX_qWithHeader )
				HTTP_putDeleGateHeader(Conn,RX_tcp,fromcache);
				/* also X-Request-XXX is echoed */
		}

		if( RX_cachefp ){
			fwrite(line,1,lastRcc,RX_cachefp);
			sendDistribution(Conn,RX_cachefp,RX_fsp,RX_tcp,line,lastRcc);
		}
	}


	if( !ClientEOF )
	if( 0 < DELEGATE_LINGER )
		set_linger(fileno(RX_tcp),DELEGATE_LINGER);
	if( fromcache )
		RX_fsd = -1;
	else	RX_fsd = fileno(RX_fsp);
	RX_tcd = fileno(RX_tcp);

	if( WillKeepAlive ){
		if( CKA_RemAlive <= 1 )
			clntClose(Conn,"f:finished lifetime");
		else
		if( RX_errori != 0 )
			clntClose(Conn,"s:bad status: %d",RX_errori);
	}

	if( RX_code == 206 ){
		sv1log("#HT11 NO-response-buffering: 206 Partial\n");
	}else
	if( RESP_DoZIP
	 && (Conn->xf_filters&(XF_FTOCL))==0
	 && !ClientEOF
	 && !RX_noBody && !RX_isHTTP09 && RX_qWithHeader ){
		Verbose("#CEcl DO-response-buffering for Content-Encoding\n");
		attach_respbuff(Conn,RX);
	}else
	if( SWF_MOUNT ){
		Verbose("DO-response-buffering for SWF MOUNT\n");
		attach_respbuff(Conn,RX);
	}else
/*
	if( RX_tcx.t_chunked ){
*/
	if( RX_tcx.t_chunked && !genHeadByBody(Conn,rhead) ){
		sv1log("#HT11 NO-response-buffering: chunked mode\n");
	}else
	if( !ClientEOF )
	if( !RX_noBody && !RX_isHTTP09 && RX_qWithHeader )
	/*
	if( withConversion(Conn,0)
	*/
	if( withConversionX(Conn,0,RX_woURI)
	 || WillKeepAlive && (!fromcache || fromcache && !HTTP_ContLengOk(RX_fsp)) ){
		attach_respbuff(Conn,RX);
		/*
		RX_respBuff = getTmpFile(RX_tmpFileId,Conn);
		RX_tc_sav = RX_tcp;
		RX_tcp = RX_respBuff;
		RX_tcd = -1;
		*/
	}

	RX_nsigreport = 0;
	nsigPIPE = 0;
	osigpipe = Vsignal(SIGPIPE,sigPIPE);
	Where = "header";

	for( RX_ninput = 0;;RX_ninput++ ){
	    if( !RX_inHeader && RX_noBody ){
		sv1log("#HT11 NO-BODY: remsize=%d\n",RX_remsize);
		break;
	    }
	    if( RX_fsx.t_EOF )
		break;
	    if( feof(RX_fsp) )
		break;
	    if( nsigPIPE ){
		if( !ClientEOF )
			setClientEOF(Conn,RX_tcp,"relay_response.SIGPIPE");
		if( RX_nsigreport++ % 100 == 0 ){
			sv1log(
"## (%d) SIGPIPE * %d: the recipient seems to be dead, Ctype:%s\n",
			RX_nsigreport,nsigPIPE, RX_ctype);
		}
	    }
	    Now = Time();
	    if( !ClientEOF && RX_tcp == RX_respBuff && Next < Now ){
		if( ClientSock < 0 && Conn->from_myself ){
			/* No client originally */
		}else
		if( 0 <= ClientSock && !IsAlive(ClientSock /*,NULL*/) ){
			setClientEOF(Conn,RX_tcp,"client-reset");
		}
		Next = Now + 1;
	    }
	    if( ClientEOF && RX_cachefp == NULL ){
 sv1log("## stop relay-1: no recipient & no cache\n");
		break;
	    }
	    if( ClientEOF && RX_cachefp != NULL && CACHE_TAKEOVER ){
		if( CACHE_TAKEOVER < time(0) - RX_Start ){
			sv1log("CACHE_TAKEOVER: TIMEOUT=takeover:%d\n",
				time(0)-(int)RX_Start);
			break;
		}
	    }

	    if( 10 < RX_ninput )
	    if( 8*1024 < RX_rdContLen - RX_rdTotal )
		RX_niced = doNice("HTTPresponse",RX_fsd,RX_fsp,RX_tcd,RX_tcp,
			RX_niced,RX_rdTotal,RX_ninput,RX_Resp1);

 	/*
 	 * stop buffering for Keep-Alive when the response data is large
 	 * or response speed is slow.
 	 */
	RX_fsx.t_nready = 0;

	/*
	 if( (fromcache & RF_DECODED) == 0 )
         if( WillKeepAlive )
         if( RX_tcp == RX_respBuff && !RX_inHeader && !ClientEOF )
         if( 1024*1024 < RX_rdContLen
	 || 1024*1024 < RX_rdTotal
	 || 8 < Time()-CONN_DONE
 	 || !fromcache
	 && RX_fsx.t_nready == 0 && (RX_fsx.t_nready = fPollIn(RX_fsp,100)) == 0
	 && 5 < Time()-CONN_DONE )
                 RX_tcp = detach_respbuff(Conn,RX_tcp,RX_tc_sav,
                         RX_qWithHeader,"flush slow response.");
	*/
	flushSlowResponse(Conn,RX,fromcacheX);
	/*
	if( RX_fsx.t_nready < 0 ){
		sv1log("Polling server response failed, maybe EOF\n");
		break;
	}
	*/

	    if( !RX_inHeader && RX_fsx.t_chunked ){
		lastRcc = RX_fsx.t_lastRcc;
		if( RX_fsx.t_chunk_ser && 0 < lastRcc ){
			Verbose("#HT11 --getChunk[%d] data  : %d / %d / %d\n",
				RX_fsx.t_chunk_ser,lastRcc,
				RX_fsx.t_chunk_rem,RX_fsx.t_chunk_siz);

			RX_fsx.t_chunk_rem -= lastRcc;
			RX_remsize = RX_fsx.t_chunk_rem;
			if( sizeof(RX_rdBuff)-1 < RX_remsize )
				RX_remsize = sizeof(RX_rdBuff) -1;
		}
		if( RX_fsx.t_chunk_rem == 0 ){
			if( getChunk(RX) < 0 )
				break;
			RX_fsx.t_lastRcc = 0;
			continue;
		}
	    }else
	    if( !fromcacheX )
	    if( !RX_inHeader && RX_fsx.t_keepAlive && 0 < RX_rdContLen ){
		RX_remsize = RX_rdContLen - RX_rdTotal;
		if( sizeof(RX_rdBuff)-1 < RX_remsize )
			RX_remsize = sizeof(RX_rdBuff)-1;
		Verbose("#HT11 --Length=%d = %d + %d\n",
			RX_rdContLen,RX_rdTotal,RX_remsize);
		if( RX_rdContLen <= RX_rdTotal )
			break;
	    }
 
	    if( RX_inHeader || RX_isText ){
		if( !RX_inHeader && RX_bodyLines == 0 ){
			RX_convChar = CTX_cur_codeconvCL(Conn,VStrNULL)
				   || CCXactive(CCX_TOCL);
			log_codeconv(Conn,RX);
			/*
			log_codeconv(Conn);
			*/

			if( !ClientEOF && RX_putPRE == 1 ){
				RX_wrTotal += FPUTS(CVStr("\n<PRE>"),RX_ctype,
					RX_convChar,0);
				RX_putPRE = 2;
			}
		}
		if( !RX_inHeader && !fromcacheX && !ClientEOF
		 && RX_fsx.t_nready == 0 && (RX_fsx.t_nready = fPollIn(RX_fsp,200)) == 0 ){
			RX_noutput++;
			if( fflushTIMEOUT(RX_tcp) == EOF )
				setClientEOF(Conn,RX_tcp,"text flush-1");
			else
			if( RX_rdContLen == 0 && RX_tcp == RX_respBuff ){
				RX_tcp = detach_respbuff(Conn,RX_tcp,RX_tc_sav,
					RX_qWithHeader,"flush endless text.");
			}
		}

		if( GETRESPTXT(Conn,RX,fromcacheX) == NULL ){
textEOF:
			if( !ClientEOF && !RX_inHeader )
			if( !RX_noBody )
			{
				setVStrEnd(line,0); /* could be target of rewriting */
				RX_wrTotal += FPUTS(AVStr(line),RX_ctype,RX_convChar,0);
				/*
				RX_wrTotal += FPUTS(CVStr(""),RX_ctype,RX_convChar,0);
				*/
			}
			break;
		}
		lastRcc = RX_fsx.t_lastRcc;

		if( RX_inHeader && (line[0] == '\r' || line[0] == '\n') )
		{
/*
using rhead for charset guessing is not good when it is GZIPed
 */
			setSVCC(Conn,RX,AVStr(rhead));
			endRespHead(Conn,RX);
		}

		if( !RX_inHeader && RX_isText && RX_isBin ){ /* RX_isBin is set in GETRESPTXT() */
			sv1log("non-text in text type resp.(%d/%d)\n",RX_rdTotal,RX_ninput);
			RX_errori = R_NONTEXT_INTEXT;
			rcc = lastRcc;
			Where = "binaryBody";
			RX_isText = 0;
			goto GOT_BINARY;
		}

		/* let space in header be canonical ... */
		if( RX_inHeader ){
			refQStr(sp,line); /**/
			const char *dp;
			char ch,nch;
		    for( sp = line; ch = *sp; sp++ ){
		      if( ch == ':' ){
			nch = *++sp;
			if( nch == '\t' ){
				sv1log("##LWS replace: %s",line);
				nch = ' ';
				setVStrElem(sp,0,' ');
			}
			if( nch == ' ' ){
				for( dp = sp; dp[1]==' '||dp[1]=='\t'; dp++ );
				if( dp != sp ){
					sv1log("##LWS delete: %s",line);
					ovstrcpy((char*)sp+1,dp+1);
				}
			}else
			if( nch != '\r' && nch != '\n' ){
				sv1log("##LWS insert: %s",line);
				Strins(QVStr(sp,RX_rdBuff)," ");
			}
			break;
		    }
		  }
		}

		/* output to the cache should be
		 * before "FPUTS()" which may rewrite input line
		 * after "goto GOT_BINARY" to cache binary line with fwrite()
		 */
		if( RX_cachefp && !RX_isHTTP09 ){
			if( !(RX_inHeader && NoRelayField(Conn,RX,line)) )
			if( !(RX_inHeader && NoCacheField(Conn,RX,line)) ){ 
				fputs(line,RX_cachefp);
				sendDistribution(Conn,RX_cachefp,RX_fsp,RX_tcp,line,lastRcc);
			}
			if( !RX_inHeader )
				RX_txtLen += lastRcc;
		}

		relayTxtResp1(Conn,RX,QX,req);
		if( !RX_inHeader ){
			RX_rdTotal += lastRcc;
			RX_bodyLines += 1;

			/* don't cause automatic flush at
			 * non line boundary.  */
			if( OBUFSIZE <= RX_wrbufed+lastRcc
			|| !fromcacheX && READYCC(RX_fsp) == 0 ){ 
				if( RX_tcx.t_chunked ){
					/* flushing before the last chunk "0"
					 * is halmful for NS6.X
					 */
				}else
				if( !ClientEOF && fflushTIMEOUT(RX_tcp) == EOF )
					setClientEOF(Conn,RX_tcp,"text flush-2");
				RX_noutput++;
				RX_wrbufed = lastRcc;
			}else{
				RX_wrbufed += lastRcc;
				/* should be length of converted string. */
			}
		}

		if( RX_inHeader ){
			RX_rdHeadTotal += lastRcc;
			scanRespHead1(Conn,RX,line);
			if( !RX_inHeader ){

 sv1log("%s %d Content-{Type:%s Encoding:[%s/%s] Leng:%d} Server:%s\n",
 RX_ver,RX_code,RX_ctype,RX_cencoding,RX_tencoding,RX_rdContLen,RX_servername);

				if( RX_emptyBody && RX_fsx.t_keepAlive )
				if( RX_tencoding[0] == 0 )
				if( READYCC(RX_fsp) == 0 ){
					break;
				}

				if( !RX_noBody )
				if( modwatch_enable )
				if( modwatchHead(Conn,RX) != 0 )
					break;

				Where = "headerFlush";
				if( !ClientEOF && RX_tcp != RX_respBuff )
					flushHead(Conn,RX_tcp,RX_rdContLen);
				RX_noutput++;

				if( RX_reqHEAD )
					break;

				if( RX_isText )
					Where = "textBody";
				else	Where = "binaryBody";

				switch( RX_isText ){
				   case TX_CSS:
					refererb.r_cType = "text/css";
					break;
				   case TX_XML:
					refererb.r_cType = "text/xml";
					break;
				   case TX_JAVASCRIPT:
					refererb.r_cType = "text/javascript";
					break;
				}

				if( RX_cencoding[0] )
				if( RESP_DoUNZIP ){
/*
				  if( RX_fsx.t_keepAlive || RX_fsx.t_chunked ){
*/
					FILE *tmp;
					tmp = TMPFILE("recvHTTPbody");
					recvHTTPbody(Conn,RX,tmp);
					if( ClientEOF ){
						fclose(tmp);
						break;
					}
					fflush(tmp);
					fseek(tmp,0,0);
					tmp_fsp = Gunzip(RX_cencoding,tmp);
					if( tmp_fsp != tmp )
						fclose(tmp);
				  	RX_fsp = tmp_fsp;
					RX_xrdLen = file_size(fileno(RX_fsp));
					RX_fsx.t_keepAlive = 0;
					RX_fsx.t_chunked = 0;
/*
				  }else{
					tmp_fsp = Gunzip(RX_cencoding,RX_fsp);
					if( tmp_fsp == RX_fsp )
						tmp_fsp = 0;
				  	else	RX_fsp = tmp_fsp;
				  }
*/
				  if( RX_fsp == tmp_fsp ){
				  /* 8.1.0: probably be intended to disable
				   * flushSlowResponse -> detach_respbuff
				   * to adjust Content-Length
				   */
					fromcacheX |= RF_DECODED;
				  }
				}
				if( HTTP_opts & HTTP_SUPPCHUNKED )
				if( RX_tcx.t_chunked && !WillKeepAlive ){
				sv1log("#HT11 less-chunked / non-KeepAlive\n");
					RX_tcx.t_chunked = 0;
				}
			}
		}
		if( RX_rdContLen+0x100000 < RX_txtLen ){
			if( RX_tcp == RX_respBuff ){
				RX_tcp = detach_respbuff(Conn,RX_tcp,RX_tc_sav,
					RX_qWithHeader,"huge data");
			}
			if( RX_cachefp ){
				sv1log("discard cache: leng=%d/%d %s\n",
					RX_txtLen,RX_rdContLen,RX_cpath);
				Ftruncate(RX_cachefp,0,0);
				fseek(RX_cachefp,0,0);
				RX_cachefp = NULL;
			}
		}
	    }else{
		if( RX_tcp == RX_respBuff && !WillKeepAlive ){
			RX_tcp = detach_respbuff(Conn,RX_tcp,RX_tc_sav,
				RX_qWithHeader,"non-text data, non keep-alive");
		}
		rcc = GETRESPBIN(Conn,RX,fromcacheX,RX_fsx.t_nready);
GOT_BINARY:
		if( relayBinResp1(Conn,RX,rcc) < 0 )
			break;
	    }
	}
	if( Anchor_rem[0] ){
		putChunk(RX,Anchor_rem,strlen(Anchor_rem));
		setVStrEnd(Anchor_rem,0);
	}

	if( !RX_noBody ){
		putChunk(RX,"",0);
		Where = "bodyFlush";

		/* 3.0.56: removal of cache of inconsistent length shold be
		 * tried anytime except when it is read from cache incompletely
		 * where rdTotal does not show the length of the content
		if( !(fromcache && ClientEOF) )
		 */
		if( !fromcache /* not reading from cache */
		 || !ClientEOF /* or read cache completely */
		)
		if( RX_rdTotal < RX_rdContLen )
			RX_errori = R_UNSATISFIED;

		if( !ClientEOF ){
			if( RX_putPRE == 2 ){
			RX_wrTotal += FPUTS(CVStr("</PRE>\n"),RX_ctype,RX_convChar,0);
			}
		}
	}

	RX_wrContLen = RX_rdContLen;
	if( RX_tcp == RX_respBuff )
	{
		if( SWF_MOUNT ){
			FILE *tmp;
			tmp = TMPFILE("SWF");
			fflush(RX_tcp);
			fseek(RX_tcp,0,0);
			{
				CStr(line,1024);
				while( fgets(line,sizeof(line),RX_tcp) ){
					fputs(line,tmp);
					if( *line == '\r' || *line == '\n' )
						break;
				}
			}
			swfFilter(Conn,RX_tcp,tmp,"");
			fflush(tmp);
			fclose(RX_tcp);
			RX_tcp = tmp;
		}
		releaseRespbuf(Conn,RX);
	}

	if( RX_errori == R_NONTEXT_INTEXT )
		if( RX_rdTotal == RX_rdContLen )
			RX_errori = 0;

	if( WillKeepAlive )
		abortKeepAlive(Conn,RX);

	if( file_isreg(fileno(RX_tcp)) ){
		sv1log("DON'T CLOSE RESPONSE:(%d) %s\n",
			reqRobotsTxt(Conn),REQ_URL);
	}else
	if( RESP_SAV )
		fclose(RX_tcp);
	else
	if( checkClientEOF(Conn,RX_tcp,"flush_body") ){
		httpStat = CS_EOF;
	}else{
		Verbose("HTTP RESPONSE FLUSH: DO (HCKA=%d)\n",WillKeepAlive);
		if( WillKeepAlive ){
			fflushKeepAlive(Conn,"flush_response",
				afc,RX_tcp,RX_wrHeadTotal+RX_wrTotal);
			if( nsigPIPE || ClientEOF )
				clntClose(Conn,"p:premature EOF on flush");
			if( nsigPIPE && !ClientEOF )
				setClientEOF(Conn,RX_tcp,"flush_response.SIGPIPE");
			if( ClientEOF )
				httpStat = CS_EOF;
		}else{
			tcCLOSED = 1;
			/*
			if( tmp_fsp || (Conn->xf_filters & XF_FTOCL) ){
			*/
			if( tmp_fsp
			 || (Conn->xf_filters & XF_FTOCL)
			 || (Conn->xf_clprocs & XF_FTOCL)
			){
				/* force shutdown() to avoid system() for
				 * filter program from keeping the client-side
				 * socket open after finished on Win32
				 */
				fshutdown(RX_tcp,1);
			}else
			fshutdown(RX_tcp,0);
			if( fcloseTIMEOUT(RX_tcp) == EOF )
				httpStat = CS_EOF;
			setClientEOF(Conn,RX_tcp,NULL);
		}
	}

	if( RX_cachefp )
		fflush(RX_cachefp);

	Vsignal(SIGPIPE,osigpipe);

	http_log(Conn,proto,server,iport,req,RX_code,RX_ctype,RX_rdTotal,
		RX_lastModTime,CONN_DONE-CONN_START,Time()-CONN_DONE);

sprintf(line,"HTTP transmitted: %dhead+%d/%dbody=>%dtxt+%dbin->%d/%d, %di/%do/%df/%3.1f",
		RX_rdHeadTotal,RX_rdTotal,RX_rdContLen,
		RX_txtLen,RX_binLen,
		RX_wrTotal,RX_wrContLen,
		RX_ninput,RX_noutput,RX_nflush,
		Time()-RX_Start);
 	sv1log("%s\n",line);

	if( withCookie || *RX_setCookie )
		logCookie(Conn,RX,RX_setCookie);

	if( tmp_fsp ){
		fclose(tmp_fsp);
	}

	if( RX_errori == R_UNSATISFIED )
		return RX_errori;

	if( RX_lastMod == 0 ){
		if( RX_code == 302 ){
			/* relatively shorter expire time is desired ? */
		}else{
			Verbose("No Last-Modified:\n");
#ifndef CACHE_NOLM
			return R_GENERATED;
#endif
		}
	}

	return RX_errori;
}

static int HTTP_relayCachedHeader(Connection *Conn,FILE *cache,FILE *tc,HttpResponse *resx)
{	CStr(line,1024);
	CStr(buff,1024);
	int lines;
	int total;

	total = 0;
	for(lines = 0;;lines++){
		if( fgets(line,sizeof(line),cache) == NULL )
			break;
		if( lines == 0 ){
			if( strncasecmp(line,F_HTTPVER,F_HTTPVERLEN) == 0 ){
				decomp_http_status(line,resx);
				continue;
			}
		}
		if( strncasecmp(line,"Date:",5) == 0 ){
			StrftimeGMT(AVStr(buff),sizeof(buff),TIMEFORM_RFC822,time(0),0);
			replaceFieldValue(AVStr(line),"Date",buff);
		}
		else
		if( strncasecmp(line,"Content-",8) == 0 ){
			if( strncasecmp(line,"Content-Location",16) != 0 )
				continue;
		}

		if( line[0] == '\r' || line[0] == '\n' )
		{
			buff[0] = 0;
			appendVia(Conn,0,AVStr(buff),sizeof(buff));
			fputs(buff,tc);
			total += strlen(buff);
			total += putKeepAlive(Conn,tc);
		}

		total += strlen(line);
		fputs(line,tc);
		if( line[0] == '\r' || line[0] == '\n' )
			break;
	}
	return total;
}
static int relay_response_fromCache(Connection *Conn,QueryContext *QX,PCStr(proto),PCStr(server),int iport,PCStr(req),PCStr(cpath),FILE *cachefp,FILE *tc,FILE *fc)
{	int rcode;
	int mycache;
	CStr(scdate,256);
	int rtotal;
	HttpResponse resx;

	httpStat = CS_HITCACHE;
	ConnType = 'c';

	if( reqRobotsTxt(Conn) ){
		rtotal = putRobotsTxt(Conn,tc,cachefp,1);
		http_log(Conn,proto,server,iport,req,200,"text/plain",rtotal,0,
			-1.0,Time()-CONN_DONE);
		return 0;
	}

	if( 0 < ClntIfModClock && !forceBodyResponse(Conn) ){
		mycache = HTTP_getLastMod(AVStr(scdate),sizeof(scdate),cachefp,cpath);
		if( mycache <= ClntIfModClock ){
			CStr(ctype,128);

			/* dont send the same or older resource */
			fprintf(tc,"HTTP/1.0 304 Not Modified (cached)\r\n");
			rtotal = HTTP_relayCachedHeader(Conn,cachefp,tc,&resx);
			flushHead(Conn,tc,0);
			sv1log("HTTP <=S= %d [%s] %s",resx.hr_rcode,cpath,req);

			ctype[0] = 0;
			http_log(Conn,proto,server,iport,req,304,ctype,rtotal,0,
				-1.0,Time()-CONN_DONE);
			return 0;
		}
	}
	rcode = relay_response(Conn,QX,0,proto,server,iport,req,cpath,1,
		cachefp,tc,fc,NULL,1);

	sv1log("HTTP <=-= %d [%s] %s",RespCode,cpath,req);

	if( rcode < 0 || /*rcode == 304 ||*/ RespCode == 304 ){
		if( rcode==R_GENERATED && (HTTP_cacheopt&CACHE_NOLASTMOD)
		){
		}else{
		sv1log("----------- UNLINK:%d:%d:%s\n",rcode,RespCode,cpath);
		unlink(cpath);
		}
		return rcode;
	}
	if( /*rcode == 304*/ RespCode == 304 ){
		sv1log("ERROR  304 Not modified messages was cached?\n");
		return 304;
	}
	return 0;
}


/*###################################### REQUEST */
static void editRequestHeader(Connection *Conn,FILE *fs)
{
}
static int HTTP_repairRequest(PVStr(req))
{	int nsp,repaired;
	CStr(xreq,URLSZ);
	refQStr(dp,xreq); /**/
	const char *xp = &xreq[sizeof(xreq)-1];
	const char *sp;
	char sc;

	nsp = 0;
	repaired = 0;
	for( sp = req; sc = *sp; sp++ ){
		if( xp <= dp+3 )
			break;
		if( sc == ' ' || sc == '\t' ){
			nsp++;
			if( 2 <= nsp && strncmp(sp+1,F_HTTPVER,F_HTTPVERLEN) != 0 ){
				sprintf(dp,"%%%02x",sc);
				dp += strlen(dp);
				repaired++;
				continue;
			}
		}
		setVStrPtrInc(dp,sc);
	}
	setVStrEnd(dp,0);
	if( repaired ){
		strcpy(req,xreq);
		sv1log("REQUEST REPAIRED: %s",xreq);
	}
	return repaired;
}

#define SPorHT(ch)	(ch == ' ' || ch == '\t')
#define CRorLF(ch)	(ch == '\r' || ch == '\n')
static const char *fgets822FromC(Connection *Conn,PVStr(buff),int size,FILE *fc,int normalize)
{	const char *rcode;
	const char *rcode1;
	refQStr(bp,buff); /**/
	const char *hp;
	int rsize,ch;

	rcode = 0;
	rsize = size;
	while( 1 < rsize ){
		rcode1 = DDI_fgetsFromC(Conn,QVStr(bp,buff),rsize,fc);
		if( bp == buff )
			rcode = rcode1;
		if( rcode == NULL || !normalize )
			break;
		ch = buff[0];
		if( CRorLF(ch) )
			break;

		if( bp != buff && normalize ){
			for( hp = bp; ch = *hp; hp++ )
				if( !SPorHT(ch) )
					break;
			if( hp != bp + 1 ){
				sv1log("##HHu reduce leading spaces<<%s",bp);
				Xstrcpy(QVStr(bp+1,buff),hp);
				Normalized++;
			}
		}
		if( strtailchr(bp) != '\n' )
			break;
		ch = DDI_peekcFromC(Conn,fc);
		if( ch == EOF )
			break;
		if( !SPorHT(ch) )
			break;

		sv1log("##HHu unfold header<<%s",bp);
		hp = bp;
		for( bp += strlen(bp) - 1; buff < bp; bp-- ){
			ch = *bp;
			if( normalize && SPorHT(ch) ){
				sv1log("##HHu reduce trail spaces<<%s<<\n",hp);
				setVStrEnd(bp,0);
			}else
			if( !CRorLF(ch) ){
				bp++;
				break;
			}
		}
		rsize = size - (bp - buff); 
		Normalized++;
	}
	return rcode;
}
/*
 * this function will not detect nor fix multiple anomaly in a line ...
 */
static void check_header(Connection *Conn,PVStr(head))
{	char ch;
	refQStr(wp,head); /**/
	const char *hp;
	CStr(tmp,URLSZ);
	int nctl,nbin,leng;
	int bad = 0;

	nctl = 0;
	nbin = 0;
	for( hp = head; ch = *hp; hp++ ){
		if( ch & 0x80 )
			nbin++;
		else
		if( ch < 0x20 && ch != '\t' && ch != '\r' &&  ch != '\n' )
			nctl++;
	}
	leng = hp - head;
	if( nctl || nbin || 256 < leng ){
		strfConnX(Conn,"%h",AVStr(tmp),sizeof(tmp));
		daemonlog("F",
		"Suspicious HTTP header [%s][CTL=%d,BIN=%d,LEN=%d] %s\n",
			tmp,nctl,nbin,hp-head,head);
	}

	for( hp = &head[leng]; head+1 < hp && CRorLF(hp[-1]); hp-- );
	if( head+1 < hp && CRorLF(*hp) ){
		wp = (char*)hp - 1;
		if( SPorHT(*wp) ){
			for( ; head+1 < wp && SPorHT(wp[-1]); wp-- );
			sv1log("##HHn remove space before CRLF<<%s",head);
			ovstrcpy((char*)wp,hp);
		}
	}

	ch = head[0];
	if( CRorLF(ch) ){
		/* End of header */
	}else
	if( SPorHT(ch) ){
		sv1log("##HHe bad space at the top of header<<%s",head);
		bad =
		BadRequest = 1;
	}else
	if( ch == ':' ){
		sv1log("##HHe empty field-name<<%s",head);
		bad =
		BadRequest = 2;
	}else{
	  for( hp = head; ch = *hp; hp++ ){
	    if( ch == ':' ){
		wp = (char*)++hp;
		while( SPorHT(*hp) )
			hp++;
		if( *hp == '\r' || *hp == '\n' ){
			/* empty body */
		}else
		if( hp == wp ){
			sv1log("##HHn insert space after ':'<<%s",head);
			strcpy(tmp,hp);
			sprintf(wp," %s",tmp);
			Normalized++;
		}else
		if( hp != wp + 1 ){
			sv1log("##HHn reduce space after ':'<<%s",head);
			ovstrcpy((char*)wp+1,hp);
			Normalized++;
		}
		break;
	    }
	    if( CRorLF(ch) ){
		sv1log("##HHe lacking ':field-value'<<%s",head);
		bad =
		BadRequest = 3;
		break;
	    }
	    if( SPorHT(ch) ){
		wp = (char*)hp;
		while( ch = *++hp )
			if( !SPorHT(ch) )
				break;
		if( ch == ':' ){
			sv1log("##HHn remove space before ':'<<%s",head);
			ovstrcpy((char*)wp,hp);
			Normalized++;
		}else{
			sv1log("##HHe multi-tokens as a field-name<<%s",head);
			bad =
			BadRequest = 4;
		}
		break;
	    }
	  }
	}

	if( bad && !HTTP_rejectBadHeader ){
		sv1log("##HHn remove bad-header<<%s",head);
		setVStrEnd(head,0);
	}
}

#include <ctype.h>
static void escape_request(Connection *Conn,PVStr(request),int size)
{	refQStr(hostport,request); /**/
	const char *hp;
	MrefQStr(dp,OREQ_MSG); /**/
	const char *xp = &OREQ_MSG[sizeof(OREQ_MSG)-1];
	unsigned char hc;
	int encode;
	refQStr(up,request); /**/

	if( HTTP_urlesc )
	if( up = strchr(request,' ') ){
		up++;
		url_unescape(AVStr(up),AVStr(up),size,HTTP_urlesc);
		encode = url_escapeX(up,AVStr(up),size,HTTP_urlesc," \t\r\n");
	}

	hostport = strstr(request,"://");
	if( hostport == NULL )
		return;

	hostport += 3; 
	encode = 0;
	for( hp = hostport; hc = *hp; hp++ ){
		if( xp <= dp+3 )
			break;
		if( hc == 0 || hc == ' ' || hc == '\r' || hc == '\n'
		 || hc == '/' || hc == '?' )
			break;
		if( isalnum(hc) || hc == '-' || hc == '.' || hc == ':'
		 || hc == '@' || hc == '%' || strchr("$_!~*'(),;&=+#",hc) ){
			setVStrPtrInc(dp,hc);
		}else{
			encode = 1;
			sprintf(dp,"%%%02x",hc);
			dp += 3;
		}
	}
	if( encode == 0 )
		return;
	strcpy(dp,hp); /* OREQ_MSG is terminated here */
	strcpy(hostport,OREQ_MSG);
	sv1log("## pre-escape request with URL including unsafe char.\n");
}

static const char *fgetsRequest(Connection *Conn,PVStr(buff),int size,FILE *fc,int normalize)
{	const char *rcode;
	int len;

	if( 0 < OREQ_LEN )
	if( 30 < IO_TIMEOUT )
	if( WillKeepAlive )
	if( strncasecmp(OREQ_MSG,"POST",4) == 0 )
	{
		/* Mozilla/3.? stops sending in the middle of a POST
		 * request header after the connection is broken which
		 * is notified as Proxy-Connection: keep-alive ...
		 */
		int timeout;
		timeout = 5 * 1000;
		if( DDI_PollIn(Conn,fc,timeout) <= 0 ){
			sv1log("#### fgetsRequest: TIMEOUT\n");
			return NULL;
		}
	}

	rcode = fgets822FromC(Conn,AVStr(buff),size,fc,normalize);

	if( rcode != NULL ){
		refQStr(dp,buff); /**/
		dp = strtail(buff);
		if( *dp == '\n' ){
			if( dp == buff || dp[-1] != '\r' ){
				sv1log("##HHn replaced LF to CRLF: %s",buff);
				strcpy(dp,"\r\n");
			}
		}
	}

	if( rcode != NULL && OREQ_LEN == 0 )
		escape_request(Conn,AVStr(buff),size);

	if( rcode != NULL && strtailchr(buff) != '\n' ){
		CStr(tmp,64);
		FStrncpy(tmp,buff);
		sv1log("##HHe bad header ending without LF (leng=%d) [%s]...\n",
			strlen(buff),tmp);
		setVStrEnd(buff,0);
		rcode = NULL;
	}
	if( rcode != NULL && normalize )
		check_header(Conn,AVStr(buff));

	if( rcode != NULL ){
		if( OREQ_LEN == 0 )
		if( HTTP_isMethod(buff) )
			HTTP_repairRequest(AVStr(buff));
		len = strlen(buff);
		if( OREQ_LEN + len < sizeof(OREQ_MSG) ){
			Xstrncpy(NVStr(OREQ_MSG) OREQ_MSG+OREQ_LEN,buff,len+1);
			OREQ_LEN += len;
		}
	}
	return rcode;
}
static void clientAskedKeepAlive(Connection *Conn,PCStr(fname),PCStr(value))
{
	FStrncpy(ConnFname,fname);
	if( strcasecmp(value,"keep-alive") == 0 ){
		ClntKeepAlive = 1; /* client requests so */
		if( !strcaseeq(REQ_METHOD,"POST")
		 && !DontKeepAlive && 1 < CKA_RemAlive )
			WillKeepAlive = 1; /* I will do so */
		else	WillKeepAlive = 0;
	}else
	if( strcasecmp(value,"close") == 0 ){
		clntClose(Conn,"c:client's will");
		ClntKeepAlive = 0;
		WillKeepAlive = 0;
	}
}
static char *addBuf(PVStr(sp),PCStr(xp),PCStr(str))
{	int len;

	len = strlen(str);
	if( xp <= sp + len ){
		sv1log("##FATAL: addBuf over flow: %s\n",str);
		return (char*)sp;
	}
	strcpy(sp,str);
	return (char*)sp + len;
}

static int rewriteRequestBody(Connection *Conn,FILE *ts,PCStr(req),PCStr(fields),PCStr(body),int blen);

/*
 * relayRequest in background is to simplify implementation of request
 * relay without knowing whether or not the request method has request body
 * which EOF could not be determined without knowledge, thus difficult to be
 * done in foreground before relaying the response.
 * HINT: HTTP header can be relayed in foreground without any knowledge :-D
 */
static int relayRequestBodyX(Connection *Conn,FILE *fc,FILE *ts,FILE *fs,PCStr(req),PCStr(fields),int bleng)
{	int bsize;
	int ch;
	int bn;
	defQStr(bbuff); /*alloc*/
	int nready;
	int start,lastflush,now;
	int buffered;

#define fflushbbuff(why) { \
	buffered = 0; \
	fputs(req,ts); \
	fputs(fields,ts); \
	fwrite((char*)bbuff,1,bn,ts); \
	free((char*)bbuff); \
	now = time(0); \
	sv1log("#### [%s] detach reqBuff: (%dB/%dB) / (%ds/%ds)\n", \
		why,bn,bleng,now-lastflush,now-start); \
 }

	bsize = bleng + 1024;
	if( HTTP_MAX_BUFF_REQBODY < bsize )
		bsize = HTTP_MAX_BUFF_REQBODY + 1024;
	setQStr(bbuff,(char*)malloc(bsize),bsize);

	bn = DDI_flushCbuf(Conn,AVStr(bbuff),bsize,NULL);
	DDI_proceedFromC(Conn,fc); /* it clears Cbuf ... */

	if( checkServ(Conn) ){
		buffered = 0;
		if( *req ){
			if( badServ(Conn,"beforeREQLINE",BS_QLINE,ts,fs,NULL) )
				ts = NULLFP();
			fputs(req,ts);
			fflush(ts);
		}
		if( *fields ){
			if( badServ(Conn,"beforeREQHEAD",BS_QHEAD,ts,fs,NULL) )
				ts = NULLFP();
			fputs(fields,ts);
			fflush(ts);
		}
		if( badServ(Conn,"beforeREQBODY",BS_QBODY,ts,fs,NULL) )
			ts = NULLFP();

		fwrite(bbuff,1,bn,ts);
		free((char*)bbuff);
	}else{
		buffered = 1;
	}
	start = lastflush = time(0);

	for( ; bn < bleng || 0 < READYCC(fc); bn++ ){
		if( bn < bleng && READYCC(fc) <= 0 ){
			nready = fPollIn(fc,(int)(HTTP_TOUT_IN_REQBODY*1000));
			if( nready <= 0
			 || HTTP_TOUT_BUFF_REQBODY < time(0) - lastflush
			){
				now = time(0);
				if( buffered ){
					fflushbbuff("timeout");
				}
				fflush(ts);
				lastflush = now;
			}
			if( nready < 0 )
				setClientEOF(Conn,fc,"relayRequestBody-1");
			if( nready <= 0 ){
			sv1log("#### ERROR: IMMATURE REQUEST BODY (%d/%d)\n",
				bn, bleng);
				break;
			}
		}
		ch = getc(fc);
		if( ch == EOF ){
			setClientEOF(Conn,fc,"relayRequestBody-2");
			break;
		}
		if( buffered ){
			if( HTTP_MAX_BUFF_REQBODY <= bn ){
				fflushbbuff("bufsize");
			}
		}
		if( buffered ){
			if( bsize <= bn ){
				bsize += 1024;
				setQStr(bbuff,(char*)realloc((char*)bbuff,bsize),bsize);
			}
			setVStrElem(bbuff,bn,ch);
		}else{
			putc(ch,ts);
		}
		if( OREQ_LEN < sizeof(OREQ_MSG) )
		OREQ_MSG[OREQ_LEN++] = ch;

		if( ch == '\n' ){
			if( badServ(Conn,"inBODY",BS_QBODY,ts,fs,NULL) )
				ts = NULLFP();
		}
	}
	if( OREQ_LEN < sizeof(OREQ_MSG) )
	OREQ_MSG[OREQ_LEN] = 0;

	if( buffered ){
		setVStrEnd(bbuff,bn);
		/* do necessary rewriting for the body, the header fields
		 * and request line here, or return body data to the caller
		 * of this function without sending to the server.
		 */
		if( rewriteRequestBody(Conn,ts,req,fields,bbuff,bn) == 0 ){
		fputs(req,ts);
		fputs(fields,ts);
		fwrite(bbuff,1,bn,ts);
		}
		free((char*)bbuff);
	}

	fflush(ts);
	sv1log("relayRequestBody1 done (%d/%d)\n",bn,bleng);
	return bn;
}
static int relaydata(Connection *Conn,FILE *fc,FILE *ts,FILE *fs,int timeout)
{
	return relayRequestBodyX(Conn,fc,ts,fs,"","",0);
}
static int relayRequestBody1(Connection *Conn,FILE *fc,FILE *ts,FILE *fs,PCStr(req),PCStr(fields))
{	CStr(cleng,128);
	int bleng;

	if( getFV(fields,"Content-Length",cleng) == 0 )
		return 0;
	bleng = atoi(cleng);
	relayRequestBodyX(Conn,fc,ts,fs,req,fields,bleng);
	return 1;
}
/*
 * This should be splited into relayRequestHead() and relayRequestBody()
 */
static int relay_request(Connection *Conn,QueryContext *QX,PCStr(request),PVStr(fields),FILE *fc,FILE *ts,FILE *fs,int headonly,int in_header,PCStr(cpath),int cdate)
{	CStr(req,URLSZ);
	CStr(value,256);
	int lines;
	int bytes;
	int sentFrom;
	int tsEOF;
	refQStr(tail,fields); /**/
	const char *tx;
	CStr(UA,1024);
	CStr(ViaBuf,2048);
	refQStr(vp,ViaBuf); /**/
	const char *vx;
	CStr(connection,256);
	CStr(fname,256);
	int fnlen;

	if( headonly && !in_header )
		return 0;

	sentFrom = 0;
	ClntIfMod[0] = 0;
	ClntIfModClock = -1;
	if( LockedByClient ){ free((char*)LockedByClient); LockedByClient = 0; }
	if( CacheID){ free((char*)CacheID); CacheID = 0; }
	tsEOF = 0;
	lines = bytes = 0;
	if( tail ){
		tx = tail + (sizeof(REQ_FIELDS) - 1);
	}
	D_HOPS = 0;
	UA[0] = 0;
	REQ_UA[0] = 0;
	ViaBuf[0] = 0;
	vx = ViaBuf + sizeof(ViaBuf);
	connection[0] = 0;
	QX_upgrade[0] = 0;

	if( in_header )
	for(;;){
		if( fgetsRequest(Conn,AVStr(req),sizeof(req),fc,1) == NULL ){
			setClientEOF(Conn,fc,"relay_request");
			break;
		}
		lines += 1;
		bytes += strlen(req);

		value[0] = 0;
		if( STRH(req,F_KeepAlive) ){
			sv1log("IGNORE request: %s",req);
			continue;
		}else
/*
		if( STRH(req,F_Upgrade) ){
			sv1log("IGNORE request: %s",req);
*/
		if( fnlen = STRH(req,F_Upgrade) ){
			lineScan(req+fnlen,QX_upgrade);
			sv1log("Upgrade: %s\n",QX_upgrade);
			continue;
		}else
		if( STRH_Connection(req) ){
			scan_field1(req,AVStr(fname),sizeof(fname),AVStr(value),sizeof(value));
			clientAskedKeepAlive(Conn,fname,value);

			if( connection[0] != 0 )
				strcat(connection,",");
			strcat(connection,value);
			continue;
		}else
		if( fnlen = STRH(req,F_AccEncode) ){
			CStr(enc,64);
			extern int withGzip;
			lineScan(req+fnlen,enc);

			/* if without non-CFI FTOCL */
			if( (Conn->xf_filters & XF_FTOCL) == 0
			 || (Conn->xf_filtersCFI & XF_FTOCL) != 0
			)
			if( !reqRobotsTxt(Conn)  )
			if( withGzip )
			if( (HTTP_opts & HTTP_NOGZIP ) == 0 )
			if( isinList(HTTP_genEncoding,"gzip") )
			if( isinList(enc,"gzip") || isinList(enc,"x-gzip") )
			{
				Verbose("#CEcl prepare ContEncoding:%s\n",enc);
				lineScan(enc,QX_accEnc);
				RESP_DoZIP = 1;
				/*
				should set DoUNZIP=1 too ?
				*/
			}
		}else
		if( strncasecmp(req,"Host:",5) == 0 ){
		}else
		if( strncasecmp(req,"From:",5) == 0 ){
			sv1log("%s",req);
			if( strpbrk(req,"/(") )
				vp = addBuf(AVStr(vp),vx,req);
		}else
		if( strncasecmp(req,"Forwarded:",10) == 0 ){
			vp = addBuf(AVStr(vp),vx,req);
			D_HOPS++;
		}else
		if( strncasecmp(req,"Via:",4) == 0 ){
			vp = addBuf(AVStr(vp),vx,req);
			D_HOPS += num_ListElems(req+4,',');
		}else
		if( strncasecmp(req,"User-Agent:",11) == 0 ){
			lineScan(req+11,UA);
			lineScan(req+11,REQ_UA);
		}else
		if( strncasecmp(req,"Referer:",8) == 0 ){
			/*sv1log("%s",req);*/
			/*stripDeleGate(Conn,req+8);*/
		}else
		if( strncasecmp(req,"Authorization:",14) == 0 ){
		}else
		if( strncasecmp(req,"Accept-Language:",16) == 0 ){
			HTTP_scanAcceptCharcode(Conn,AVStr(req));
			if( *req == 0 )
				continue;
		}else
		if( HTTP_ignoreIf && strncasecmp(req,"If-",3) == 0 ){
			sv1log("IGNORE IF-: %s",req);
			continue;
		}else
		if( strncasecmp(req,"If-Modified-Since:",18) == 0 ){
			wordscanY(req,AVStr(ClntIfMod),sizeof(ClntIfMod),"^");
			lineScan(ClntIfMod+18,value);
			ClntIfModClock = scanHTTPtime(value);
			sv1log("= (%d) %s",ClntIfModClock,req);
			continue;
		}else
		if( strncasecmp(req,"Cookie:",7) == 0 ){
			CStr(cookie,256);
			getProxyCookie(Conn,AVStr(req));
			lineScan(req+7,cookie);
			if( strncmp(cookie,"DeleGate-Control=",17) == 0 ){
				sv1log("#Proxy-Cookie: %s",req);
				lineScan(cookie+17,proxyCookie);
			}
			extractParam(AVStr(req),"Cookie",DeleGateId(),
				AVStr(ClientSession),sizeof(ClientSession),1);
		}else
		if( strncasecmp(req,"Pragma:",7) == 0 ){
			Verbose("%s",req);
			wordScan(req+7,value);
			if( strcaseeq(value,"no-cache")){
				DontReadCache = 1;
				PragmaNoCache = 1;
				RES_CACHE_DISABLE = 1;
			}else
			if( strcaseeq(value,"cache-readonly") ){
				DontWriteCache = 1;
				continue;
			}else
			if( strcaseeq(value,"cache-only") ){
				CacheOnly = 1;
				DontWriteCache = 1;
				continue;
			}
		}else
		if( STRH(req,F_CacheControl) ){
			if( strcasestr(req,"max-age=0")
			 || strcasestr(req,"no-cache") ){
				DontReadCache = 1;
				PragmaNoCache = 1;
				RES_CACHE_DISABLE = 1;
			}
		}else
		if( STRH(req,F_Range) ){
			sscanf(req,"%*s bytes=%d-%d",&QX_range[0],&QX_range[1]);
			Conn->cl.p_range[0] = QX_range[0];
			Conn->cl.p_range[1] = QX_range[1];
			sv1log("#HT11 (%d) %s",QX_range[1]-QX_range[0]+1,req);
			DontReadCache = 1;
			DontWriteCache = 1;
		}else
		if( strncmp(req,"X-Locking: ",11) == 0 ){
			lineScan(req+11,value);
			LockedByClient = stralloc(value);
			continue;
		}else
		if( strncmp(req,"X-Cache-ID: ",12) == 0 ){
			lineScan(req+12,value);
			CacheID = stralloc(value);
			continue;
		}

		if( *req == '\r' || *req == '\n' ){
			/* Append some fields at the end of header fields */
			if( !sentFrom ){
				sentFrom = 1;
/*
This should be the E-mail address of proxy for security consideration.
if( tail )tail = Sprintf(tail,"From: %s\r\n",D_FROM);
if( ts != NULL ) fprintf(ts,  "From: %s\r\n",D_FROM);
*/
			}
		}

		if( tail ){
			if( tx <= tail+strlen(req) ){
				daemonlog("F",
					"request header overflow: %d/%d: %s",
					bytes,lines,req);
			}else{
				QStrncpy(tail,req,tx-tail);
				tail += strlen(tail);
			}
		}

if( ts != NULL ){
			if( fputs(req,ts) == EOF ){
				tsEOF = 1;
				break;
			}
		}

		if( *req == '\r' || *req == '\n' ){
			if( AcceptLanguages && AcceptLanguages[0] )
				Verbose("Accept-Language: %s\n",AcceptLanguages);
			Verbose("HTTP Relay_request_head (%d bytes/%d lines)\n",
				bytes,lines);
			break;
		}
	}

	if( in_header ){
		const char *user;
		CStr(host,256);
		CStr(UaVia,4096);
		const char *dp;
		int port,direct;

		strcpy(host,"-");
		port = getClientHostPort(Conn,AVStr(host));

		for( dp = ViaBuf; *dp; dp++ ){
			switch( *dp ){
				case '\r': *(char*)dp = ';'; break;
				case '\n': *(char*)dp = ' '; break;
			}
		}
		direct = ViaBuf[0] == 0 && strstr(UA," via ") == NULL;
		sprintf(UaVia,"host=%s; User-Agent: %s; %s",host,UA,
			direct?"DIRECT":ViaBuf);
		if( !LOG_GENERIC || !fputLog(Conn,"Proxy","%s\n",UaVia) )
			    sv1log("Proxy: %s\n",UaVia);
		if( LOG_GENERIC ){
			if( (user = getClientUserC(Conn)) == NULL )
				user = "-";
			fputLog(Conn,"Client","%s@%s; agent=%s\n",user,host,UA);
		}

		if( connection[0] && RequestSerno == 0 )
		sv1log("HCKA:[%d] %s; host=%s; (%sUser-Agent: %s)\n",
			RequestSerno,connection,host,ViaBuf,UA);

		if( WillKeepAlive ){
			if( ImMaster ){
				if( vercmp(ClientVER,CHUNKED_VER) < 0 )
					clntClose(Conn,"v:via old DeleGate");
			}else
			if( !direct ){
				if( KeepAliveWithProxyClient ){
					sv1log("HCKA: Via=%s\n",ViaBuf);
				}else	clntClose(Conn,"v:via proxy");
			}
		}

		/* if this is the front most DeleGate for the client ... */
		if( !ImMaster )
			UAspecific(Conn,UA,direct);
	}

	if( ts != NULL && !tsEOF ){
		if( !ClientEOF && !headonly ){
			lines = 0;
			DDI_proceedFromC(Conn,fc);
			bytes = relaydata(Conn,fc,ts,fs,(int)HTTP_TOUT_QBODY);
		}
		fflush(ts);
	}

	Verbose("HTTP Relay_request done (%d bytes/%d lines)\n",bytes,lines);
	return lines;
}
static void relayBuffered(FILE *in,FILE *out)
{	int rcc;
	CStr(buf,1024);

	fflush(out);
	while( rcc = fgetBuffered(AVStr(buf),sizeof(buf),in) ){
		if( Fwrite(buf,1,rcc,out) <= 0 )
			return;
	}
	while( 0 < PollIn(fileno(in),1000) ){
		rcc = read(fileno(in),buf,sizeof(buf));
		if( rcc <= 0 )
			break;
		if( write(fileno(out),buf,rcc) != rcc )
			break;
	}
}
static void genProxyReqFields(Connection *Conn,PVStr(fields),PCStr(cpath))
{	refQStr(gfp,fields); /**/
	CStr(forwarded,256);
	CStr(received_by,256);
	const char *auth;
	CStr(atype,128);
	CStr(genauth,256);
	CStr(buf,1024);
	CStr(buf2,1024);
	const char *dp;
	int withAuth;
	CStr(cacheid,256);

	setVStrEnd(gfp,0);

	if( findFieldValue(REQ_FIELDS,"From") == NULL )
	if( makeFrom(Conn,AVStr(buf)) ){
		Verbose("## GEN From: %s\n",buf);
		gfp = Sprintf(AVStr(gfp),"From: %s\r\n",buf);
	}
	if( makeForwarded(Conn,AVStr(forwarded) )){
		Verbose("## GEN Forwarded: %s\n",forwarded);
		gfp = Sprintf(AVStr(gfp),"Forwarded: %s\r\n",forwarded);
	}

	withAuth = 0;
	if( auth = findFieldValue(REQ_FIELDS,"Authorization") )
	if( HTTP_decompAuth(auth,AVStr(atype),sizeof(atype),AVStr(buf),sizeof(buf)) ){
		if( buf[0] == 0 || buf[0] == ':' )
			sv1log("## ignore empty Authorization [%s]\n",buf);
		else{
			Verbose("## PASS Authorization: %s %s\n",atype,"");
			withAuth = 1;
		}
	}
	if( IsMounted && strchr(REAL_SITE,'@') ){
		strcpy(buf2,REAL_SITE);
		*strchr(buf2,'@') = 0;
		str_to64(buf2,strlen(buf2),AVStr(buf),sizeof(buf),1);
		if( dp = strpbrk(buf,"\r\n") )
			truncVStr(dp);
		strcpy(atype,"Basic");
		sprintf(genauth,"%s %s",atype,buf);
		sv1log("## MOUNT Authorization: %s [%s]\n",genauth,buf2);
		gfp = Sprintf(AVStr(gfp),"Authorization: %s\r\n",genauth);
	}else
	if( withAuth == 0 )
	if( makeAuthorization(Conn,AVStr(genauth),0) ){
		HTTP_decompAuth(genauth,AVStr(atype),sizeof(atype),AVStr(buf2),sizeof(buf2));
		sv1log("## GEN Authorization: %s [%s]\n",genauth,buf2);
		gfp = Sprintf(AVStr(gfp),"Authorization: %s\r\n",genauth);
	}

	if( toProxy /* or ConnType != 'h'(i.e. SSLTUNNEL/HTTP) */ )
	if( makeAuthorization(Conn,AVStr(genauth),1) ){
		HTTP_decompAuth(genauth,AVStr(atype),sizeof(atype),AVStr(buf2),sizeof(buf2));
		sv1log("## GEN Proxy-Authorization: %s [%s]\n",genauth,buf2);
		gfp = Sprintf(AVStr(gfp),"Proxy-Authorization: %s\r\n",genauth);
	}

	if( CacheID )
		lineScan(CacheID,cacheid);
	else	cacheid[0] = 0;

	if( cpath != NULL )
	if( toProxy || toMaster )
	{	CStr(fileId,URLSZ);
		refQStr(dp,cacheid); /**/

		if( !HTTP_noXLocking ){
			getFileUID(AVStr(fileId),cpath);
			gfp = Sprintf(AVStr(gfp),"X-Locking: %s\r\n",fileId);
		}
		if( cacheid[0] ){
			dp = cacheid + strlen(cacheid);
			setVStrPtrInc(dp,',');
		}else	dp = cacheid;
		getCacheID(AVStr(dp),cpath);
	}
	if( cacheid[0] ){
		gfp = Sprintf(AVStr(gfp),"X-Cache-ID: %s\r\n",cacheid);
	}
}
static void codeconv_reqhead(Connection *Conn)
{	const char *method;
	const char *ver;
	HttpRequest reqx;
	CStr(url1,URLSZ);
	CStr(url2,URLSZ);
	refQStr(sp1,url1); /**/
	int oc;

	if( CCXactive(CCX_TOSV) == 0 )
		return;

	decomp_http_request(REQ,&reqx);
	method = reqx.hq_method;
	strcpy(url1,reqx.hq_url);
	ver = reqx.hq_ver;
	

	if( sp1 = strchr(url1,'?') ){
		strcpy(url2,sp1+1);
		sprintf(sp1,"-_-_-%s",url2);
	}
	nonxalpha_unescape(url1,AVStr(url2),0);
	oc = CCXexec(CCX_TOSV,url2,strlen(url2),AVStr(url1),sizeof(url1));
	CCXexec(CCX_TOSV,"",0,QVStr(url1+oc,url1),sizeof(url1)-oc);

	if( strcmp(url1,url2) != 0 ){
		refQStr(sp2,url2);
		nonxalpha_escapeX(url1,AVStr(url2),sizeof(url2));
		if( sp2 = strstr(url2,"-_-_-") )
			sprintf(sp2,"?%s",sp2+5);
		sprintf(url1,"%s %s HTTP/%s\r\n",method,url2,ver);
		sv1log("applied char. code conv. for request header (%d<-%d)\n",
			strlen(url1),strlen(REQ));
		strcpy(REQ,url1);
		Verbose(">> %s",REQ);
	}
}
static int rewriteRequestBody(Connection *Conn,FILE *ts,PCStr(req),PCStr(fields),PCStr(body),int blen){
	CStr(ctype,128);
	CStr(cleng,32);
	defQStr(xbody);
	defQStr(ybody);
	defQStr(xfields);
	int bsiz;
	int hsiz;
	int oc;
	const char *cs;

	if( getFV(fields,"Content-Type",ctype) ){
	  if( CCXactive(CCX_TOSV) ){
	    if( streq(ctype,"application/x-www-form-urlencoded") ){
		bsiz = blen * 2;
		setQStr(xbody,malloc(bsiz),bsiz);
		setQStr(ybody,malloc(bsiz),bsiz);
		nonxalpha_unescape(body,AVStr(xbody),1);

		oc = CCXexec(CCX_TOSV,xbody,strlen(xbody),AVStr(ybody),bsiz);
		CCXexec(CCX_TOSV,"",0,QVStr(ybody+oc,ybody),bsiz-oc);
		nonxalpha_escapeX(ybody,AVStr(xbody),bsiz);
		sprintf(cleng,"%d",strlen(xbody));

		hsiz = strlen(fields) + 128;
		setQStr(xfields,malloc(hsiz),hsiz);
		strcpy(xfields,fields);
		replaceFieldValue(AVStr(xfields),"Content-Length",cleng);
		sv1log("applied char. code conv. for request body (%s<-%d)\n",
			cleng,blen);
		cs = CCXcharset(CCX_TOSV);
		if( cs == 0 )
			cs = "";
		sv1log("CCX to[%s] from[%s]\n",cs,CCXident(CCX_TOSV));

		fputs(req,ts);
		fputs(xfields,ts);
		fputs(xbody,ts);
		return 1;
	    }
	  }
	}
	return 0;
}

static int ReqVer(PCStr(req1),int v1,PVStr(req2),int v2)
{	const char *ver; /**/

	if( ver = strstr(req1," HTTP/1.") )
	if( ver[8] == v1 )
	if( streq(ver+9,"\r\n") || streq(ver+9,"\n") )
	{
		ver += 8;
		if( req1 != req2 ){
			strcpy(req2,req1);
			ver = (char*)req2 + (ver - req1);
		}
		if( *ver != v2 ){
			*(char*)ver = v2;
			Verbose("#HT11 1.%c -> 1.%c: %s",v1,v2,req2);
		}
		if( streq(ver+1,"\n") ){
			Xstrcpy(QVStr((char*)ver+1,req2),"\r\n");
			sv1log("##HHn replaced LF to CRLF: %s",req2);
		}
		return 1;
	}
	return 0;
}

static int setAcceptEncoding(Connection *Conn,QueryContext *QX,PVStr(head))
{	extern int withGzip;
	int rewrite;
	CStr(cencb,128);
	const char *cenc;
	CStr(ehead,128);
	const char *denc;

	denc = HTTP_accEncoding;

	if( streq(denc,ENCODE_THRU) )
		return 0;

	if( streq(denc,"gzip") || streq(denc,"x-gzip") ){
		Verbose("#CEsv SEND Accept-Encoding:%s\n",denc);
		goto ACCGZIP;
	}

	rewrite = QX_cpath[0]
	 || withConversion(Conn,0)
	 || (Conn->xf_filters & (XF_FFROMSV|XF_FTOCL));
	if( !rewrite )
		return 0;

	if( (Conn->xf_filters & XF_FFROMSV) != 0
	 && (Conn->xf_filtersCFI & XF_FFROMSV) == 0 ){
		replaceFieldValue(AVStr(head),"Accept-Encoding","identity");
		return 1;
	}

	cenc = getFV(head,"Accept-Encoding",cencb);
	if( streq(denc,ENCODE_THRUGZIP) ){
		if( cenc ){
			if( isinList(cenc,"gzip") || isinList(cenc,"x-gzip") ){
				Verbose("#CEsv THRU Accept-Encoding:%s\n",cenc);
				denc = "gzip";
				goto ACCGZIP;
			}
			Verbose("#CEsv KILL Accept-Encoding:%s\n",cenc);
			removeFields(AVStr(head),"Accept-Encoding",0);
			return 1;
		}
		return 0;
	}

	replaceFieldValue(AVStr(head),"Accept-Encoding",denc);
	return 0;

ACCGZIP:
	if( withGzip == 0 ){
		denc = "identity";
		Verbose("#CEsv SEND Accept-Encoding:%s (NO gzip)\n",denc);
	}
	replaceFieldValue(AVStr(head),"Accept-Encoding",denc);
	RESP_DoUNZIP = 1;
	return 1;
}

void savReqAuthorization(Connection *Conn,PCStr(head));

static int relayRequest(Connection *Conn,QueryContext *QX,PCStr(cpath),int cdate,FILE *fc,FILE *ts,FILE *fs)
{	register int ppid,cpid;
	CStr(method,128);
	int in_header;
	int with_reqbody;
	CStr(genfields,0x8000);
	CStr(req,URLSZ);

	if( badServ(Conn,"beforeREQ",BS_CONNECT,ts,fs,NULL) )
		ts = NULLFP();

	if( CCXactive(CCX_TOSV) )
		codeconv_reqhead(Conn);

	if( toProxy ){
		makeProxyRequest(Conn /*,REQ,REQ*/);
	}

	if( !HTTP_reqWithHeader(Conn,REQ) ){
		fputs(REQ,ts);
		if( !HTTP_isMethod(REQ) ){
			relayBuffered(fc,ts);
			/* should be relayed by parallel thread/process */
		}
		fflush(ts);
		return 0;
	}

	wordScan(REQ,method);
	with_reqbody = HTTP_methodWithBody(method);

	genProxyReqFields(Conn,AVStr(genfields),cpath);
	MountReferer(Conn,AVStr(REQ_FIELDS));
	strcat(genfields,REQ_FIELDS);
	appendVia(Conn,1,AVStr(genfields),sizeof(genfields));
	HTTP_killhead(AVStr(genfields),KH_OUT|KH_REQ);
	HTTP_genhead(Conn,AVStr(genfields),KH_OUT|KH_REQ);
	if( !REQ_ASIS )
		rewriteReqBasicToDigest(Conn,AVStr(genfields));
	savReqAuthorization(Conn,genfields);

	/*
	if( cpath || withConversion(Conn,0)
	 || (Conn->xf_filters & (XF_FFROMSV|XF_FTOCL))
	){
		replaceFieldValue(genfields,"Accept-Encoding",HTTP_accEncoding);
	}
	*/
	setAcceptEncoding(Conn,QX,AVStr(genfields));

	if( with_reqbody ){
		if( relayRequestBody1(Conn,fc,ts,fs,REQ,genfields) )
			return 0;
		if( ClientEOF )
			return 0;

		ppid = getpid();
		if( cpid = Fork("relayRequest") ){
			if( cpid == -1 ){
				/* should send TOO BUSY message to the client */
				sv1tlog("CANNOT FORK\n");
				Finish(1);
			}
			return cpid;
		}
		setRelaying(NULL,NULL,NULL,NULL);
		Vsignal(SIGTERM,sigTERM);
	}

	if( badServ(Conn,"beforeREQLINEx",BS_QLINE,ts,fs,NULL) )
		ts = NULLFP();

	if( toMaster && vercmp(MediatorVer,CHUNKED_VER) < 0 ){
		/* DeleGate/5.9.3 or older don't support HTTP/1.1 but
		 * don't rewrite HTTP/1.1 to HTTP/1.0 when acting as
		 * a MASTER DeleGate.
		 */
		if( ReqVer(REQ,'1',AVStr(req),'0') ){
			fputs(req,ts);
			sv1log("#HT11 FORCE HTTP/1.0 for MASTER-DeleGate/5\n");
		}else	fputs(REQ,ts);
	}else
	if( HTTP11_toserver && ReqVer(REQ,'0',AVStr(req),'1') ){
		fputs(req,ts);
		fputs("Connection: keep-alive\r\n",ts);
		sv1log("#HT11 FORCE HTTP/1.1 or Connection:keep-alive\n");
	}else{
		fputs(REQ,ts);
	}
	if( badServ(Conn,"beforeREQHEADx",BS_QHEAD,ts,fs,NULL) )
		ts = NULLFP();
	fputs(genfields,ts);

	if( badServ(Conn,"beforeREQBODYx",BS_QBODY,ts,fs,NULL) )
		ts = NULLFP();
	Verbose("HTTP relayed request %dhead\n",strlen(REQ_FIELDS));

	if( with_reqbody ){
		relay_request(Conn,QX,REQ,VStrNULL,fc,ts,fs,0,0,cpath,-1);
		if( feof(fc) ){
			sv1log("Kill (%d/%d, SIGTERM)\n",ppid,getppid());
			Kill(ppid,SIGTERM);
		}else{
			Verbose("C-S relay TIMEOUT\n");
		}
		Finish(0);
	}else{
		if( ts != NULL )
			fflush(ts);
		return 0;
	}
	return 0;
}

static void recvRequestFields(Connection *Conn,QueryContext *QX,FILE *fc)
{
	if( REQ_FIELDS[0] != 0 ){
		/* already got */
		return;
	}
	if( HTTP_reqIsHTTP(Conn,REQ) ){
		if( HTTP_reqWithHeader(Conn,REQ) )
			relay_request(Conn,QX,REQ,AVStr(REQ_FIELDS),fc,NULL,NULL,1,1,NULL,-1);
		else	DontWriteCache = 1;
	}else{
		/* a Gopher request without such request fields */
	}
}

static int decomp_gopherURL(Connection *Conn,PCStr(req),PVStr(rpath))
{	int gtype;
	HttpRequest reqx;
	MrefQStr(path,reqx.hq_url); /**/

	if( decomp_http_request(req,&reqx) ){
	/* Gopher/HTTP where path is URL with gtype */
		/* from client expecting proxy */
		if( path[0] == '/' && path[1] != 0 ){
			/* this should be gtype in URL */
			gtype = path[1];
			ovstrcpy((char*)path,path+2);
		}else
		/* from client without proxy support */
	    		gtype = get_gtype(path,AVStr(path));

		if( rpath ) strcpy(rpath,path);
		CTX_set_clientgtype(Conn,gtype);
		return gtype;
	}else{
	/* Gopher/Gopher */
		linescanX(req,AVStr(path),sizeof(reqx.hq_url));
	    	gtype = get_gtype(path,AVStr(path));
		if( rpath ) strcpy(rpath,path);
		CTX_set_clientgtype(Conn,gtype);
		return 0;
	}
}
static const char *rewrite_request(Connection *Conn,FILE *fp)
{	MrefQStr(url,REQ); /**/
	const char *urltop;
	CStr(rproto,256);
	CStr(rhost,512);
	int riport;
	const char *cproto;
	const char *rcode = REQ;
	int dgurl;
	const char *ver;

	sv1log("REQUEST %s %s",BORN_SPECIALIST?"-":"=",REQ);

strcpy(rproto,"http");
riport = 80;
rhost[0] = 0;

	if( BORN_SPECIALIST || ACT_SPECIALIST ){
		if( 0 < REQ_VNO ){
			url = REQ + strlen(REQ_METHOD);
			while( *url == ' ' || *url == '\t' )
				url++;
			cproto = "http";
		}else{
			url = REQ;
			cproto = "gopher";
		}
		urltop = url;

		getProxyControlPart(Conn,AVStr(url));

		/*
		 * This stuff should be passed multiple times
		 * for indirect MOUNT, but it should be executed
		 * only for the first original reuqest URL.
		 */
		if( CLIENTS_PROXY[0] == 0 ){
			if( fromProxyClient(url) ){
				setProxyOfClient(Conn,1,url);
				DONT_REWRITE = 1;
			}else	setProxyOfClient(Conn,0,NULL);
		}

		MountRequestURL(Conn,AVStr(url));
		rhost[0] = 0;
		dgurl = 0;

/*
 * How to treat a request sent form a proxy client like "http://proxy/-_-URL"
 * should be cleary defined... (^_^;
 *
 * 951113: such URL (and optional flags) sould be passed through to the
 * target Proxy in the form  /-_-=flags=URL  because the flags should be
 * used in the Proxy (DeleGate).
 */

		if( strncasecmp(url,"pop://",6) == 0
		 && strchr(" \t\r\n",url[6]) ){
			strcpy(rproto,"pop");
			strcpy(rhost,"*");
			riport = 110;
			set_realserver(Conn,rproto,rhost,riport);
		}else
		if( strncasecmp(url,"news:",5) == 0
		 && strncmp(url+5,"//",2) != 0 ){
			strcpy(rproto,"nntp");
			strcpy(rhost,"*");
			riport = 119;
			set_realserver(Conn,rproto,rhost,riport);
		}else
		if( URL_toMyself(Conn,url) == NULL ){
			Verbose("To another server or proxy, THRU >>> %s",url);
		}else
		if( CTX_url_derefer(Conn,cproto,AVStr(url),AVStr(Modifier),AVStr(DELEGATE_FLAGS),AVStr(rproto),AVStr(rhost),&riport) ){
			dgurl = 1;
			url_delport(AVStr(url),&riport);
			set_realserver(Conn,rproto,rhost,riport);
			if( !IsMounted )
			if( !do_RELAY(Conn,RELAY_DELEGATE) ){
				sv1log("Forbidden: RELAY DELEGATE\n");
				RelayForbidden |= RELAY_DELEGATE;
				sprintf(Conn->reject_reason,"NO RELAY=delegate");
/*
 * can't strictly forbid the relaying if some host is allowed ...
 * (it's not problem if the restriction is all or nothing way)
 *
 * It's so expensive to check all of URLs in the RESPONSE about whether or
 * not they are RELAYable.  So all of them are rewritten if the URL in the
 * REQUEST is RELAYable, thus access to them will visit the delegated again.
 * And they should be relayed because they are directed to the delegated by
 * the delegated.
 * But RESPONSE to them will not rewritten if they are not RELAYable, thus
 * the recursive relay by URL rewriting of delegated will stop there.
 */
			}else	DO_DELEGATE = 1;
		}

		if( url_deproxy(Conn,AVStr(REQ),AVStr(url),AVStr(rproto),AVStr(rhost),&riport) ){
			url_delport(AVStr(url),&riport);
			set_realserver(Conn,rproto,rhost,riport);
			if( !IsMounted )
			if( !do_RELAY(Conn,RELAY_PROXY) ){
				RelayForbidden |= RELAY_PROXY;
				sv1log("Forbidden: RELAY PROXY\n");
				sprintf(Conn->reject_reason,"NO RELAY=proxy");
			}
		}

		/*
		 * cancel `DONT_REWRITE' if the URL is in form http://myself/-_-url
		 */
		if( ToMyself && dgurl )
			DONT_REWRITE = 0;

		if( rhost[0] == 0 )
			ToMyself = 1;

		if( strchr(" \t\r\n",url[0]) ){
			Strins(AVStr(url),"/");
			Verbose("HTTP EMPTY URL to %s",REQ);
		}

		if( REAL_HOST[0] )
			Verbose("REMOTE > %s",REQ);

		wordScan(urltop,REQ_URL);
	}

	if( rproto[0] == 0 ){
		sv1log("What? %s",REQ);
		return NULL;
	}

	if( !strcaseeq(rproto,"https") )
	if( !strcaseeq(rproto,"http") ){
		IAM_GATEWAY = 1;

		add_localheader(Conn,DONT_REWRITE);
		add_DGinputs(Conn,"%s",REQ);
		sv1log("HTTP GateWay > %s://%s:%d/%s",rproto,rhost,riport,REQ);

		if( protoGopher(rproto) )
			decomp_gopherURL(Conn,REQ,VStrNULL);
	}

	return rcode;
}

static FILE *insertFTOCL_X(Connection *Conn,FILE *tc)
{	int toC;
	FILE *ntc;

	toC = ToC;
	setConnX(Conn,FromC,ToC,FromS,ToS);
	if( RESP_DoZIP ){
		if( (Conn->xf_filters & XF_FTOCL) ){
			/* maybe inserted FTOCL as a MountOption */
			sv1log("Cancelled DoZIP filter:%X\n",Conn->xf_filters);
			RESP_DoZIP = 0;
		}
	}
	if( ToC == toC ){
		/* filter is not inserted */
		return tc;
	}else{
		ntc = fdopen(ToC,"w");
		/* if( fileno(tc) != ClientSock )
		/* fclose(tc); */
		return ntc;
	}
}


#define FORWARD_AUTH "forward-auth"
static scanListFunc strmatch(PCStr(s1),PCStr(s2)){ return strcmp(s1,s2) == 0; }
static int forwardOK(Connection *Conn,PCStr(what),PCStr(fname))
{	CStr(forw,1024);

	if( 0 <= find_CMAP(Conn,what,AVStr(forw)) ){
		if( scan_commaList(forw,0,scanListCall strmatch,fname) )
			return 1;
	}
	return 0;
}
/*
 * reply 302 Moved "/-_-proto://server/" to the "/-_-proto://server" request
 */
static int delegate_moved(Connection *Conn,FILE *tc)
{	const char *dp;
	CStr(url,URLSZ);
	int totalc;

	if( dp = strchr(REQ,' ') )
	if( dp[1] == '/' && strchr(" \t\r\n",dp[2]) )
	if( dp = strchr(OREQ_MSG,' ') ){
		wordScan(dp+1,url);
		if( strtailchr(url) != '/' ){
			strcat(url,"/");
			totalc = putMovedTo(Conn,tc,url);
			http_Log(Conn,302,CS_INTERNAL,REQ,totalc);
			return 1;
		}
	}
	return 0;
}

static void CacheClose(QueryContext *QX)
{
	if( QX_cachefp ){
		fflush(QX_cachefp);
		lock_unlock(fileno(QX_cachefp));
		stopDistribution(QX_Conn,QX_cachefp,QX_cpath);
		fclose(QX_cachefp);
		QX_cachefp = NULL;
	}
}
static void decompREQUEST(Connection *Conn,QueryContext *QX)
{
	if( REAL_HOST[0] ){
		QX_proto  = REAL_PROTO;
		QX_site = REAL_HOST;
		QX_port  = REAL_PORT;

		if( REAL_SITE[0] == 0 ){
			HostPort(AVStr(QX_site_buf),REAL_PROTO,REAL_HOST,REAL_PORT);
			sv1log("#### REAL_SITE = empty => [%s]\n",QX_site_buf);
		}else	strcpy(QX_site_buf,REAL_SITE);
		QX_site = QX_site_buf;

		log_PATH(Conn,">");
	}else{
		if( ImMaster )
			log_PATH(Conn,">");
		QX_proto = "http";
	}

	ProcTitle(Conn,"%s://%s/)",QX_proto,QX_site);
	sv1log("REQUEST = %s[%s://%s:%d/] %s",PragmaNoCache?"(no-cache)":"",
		QX_proto,QX_site,QX_port,REQ);
}
static void lookCacheOnly(Connection *Conn,QueryContext *QX,FILE *tc,FILE *fc)
{	const char *proto;
	const char *host;
	int port;
	const char *req;
	const char *method;
	const char *url;
	const char *ver;
	HttpRequest reqx;
	CStr(uproto,64);
	CStr(usite,256);
	CStr(upath,1024);
	CStr(cpath,URLSZ);
	int useCache;
	FILE *cachefp;
	int expire,cdate;
	CStr(smtime,URLSZ);
	int mtime;

	cachefp = NULL;

	if( DontReadCache ){
		returnAckCANTCON(Conn,tc,"don't read cache");
		return;
	}

	proto = DFLT_PROTO;
	host = DFLT_HOST;
	port = DFLT_PORT;
	req = D_REQUESTtag.ut_addr;
	if( req == NULL ){
		sv1log("lookCacheOnly: no D_REQUEST set.\n");
		return;
	}

	decomp_http_request(req,&reqx);
	method = reqx.hq_method;
	url = reqx.hq_url;
	ver = reqx.hq_ver;
	decomp_absurl(url,AVStr(uproto),AVStr(usite),AVStr(upath),sizeof(upath));

	sv1log("#### [%s][%s][%d] [%s][%s][%s]\n",
		proto,host,port, method,url,ver);

	if( !service_permitted(Conn,proto) ){
		returnAckDENIED(Conn,tc,"not permitted");
		return;
	}

	useCache = CTX_cache_path(Conn,proto,host,port,upath,AVStr(cpath));
	expire = 0x7FFFFFFF;

	if( useCache )
	if( cachefp = cache_fopen_rd("HTTP",AVStr(cpath),expire,&cdate) )
	if( lock_sharedNB(fileno(cachefp)) == 0 )
	{
		if( CacheLastMod != 0 ){
			mtime = HTTP_getLastMod(AVStr(smtime),sizeof(smtime),cachefp,cpath);
			sv1log("LastModified: %d <= %d ?\n",
				CacheLastMod,mtime);
			if( mtime <= CacheLastMod ){
				returnAckCANTCON(Conn,tc,"cache is obsolete");
				goto EXIT;
			}
		}
		returnAckOK(Conn,tc,"found in cache");
		relay_response_fromCache(Conn,QX,proto,host,port,req,cpath,cachefp,tc,fc);
		goto EXIT;
	}
	returnAckCANTCON(Conn,tc,"not found in cache");
EXIT:
	if( cachefp != NULL )
		fclose(cachefp);
}

#define MOUNT_AUTHORIZER	4
static int authOK;
static int doauth(Connection *Conn,FILE *tc)
{	AuthInfo ident;
	int pauth = REQ_FLAGS & HQF_ISPROXY;
	int cc;

	/* if Authorization is not given
	 * or if it is not successfully authenitcated
	 * (or if it does not sutisfy permission, if required)
	if( HTTP_getAuthorization(Conn,pauth,&ident,0) == 0
	 || doAuth(Conn,&ident) < 0
	 || source_permitted(Conn) == 0
	){
	 */
	if( HTTP_getAuthorization(Conn,pauth,&ident,0) == 0 ){
		/* the ident structure must be marked as
		 * "without authentication info." if distinguishing it
		 * from "empty username & password" is necessary
		 */
	}
	if( doAuth(Conn,&ident) < 0 || source_permitted(Conn) == 0 ){

/*
if( -a appear in RELIABLE or in PERMIT )
if( service_permitted2(Conn,DST_PROTO,1) ){
	sv1log("######### NOT AUTHOZIED but PERMITTED\n");
	return 0;
}
*/
		REQ_AUTH = ident;
		if( REQ_AUTH.i_error & AUTH_ENOAUTH )
			doAuth(Conn,&REQ_AUTH); /* get Basic realm */

		if( ident.i_error & AUTH_ENOSERV ){
			cc = putConfigError(Conn,tc,"Authentication");
			return -1;
		}
		cc = putNotAuthorized(Conn,tc,REQ,pauth,NULL,"");
		http_Log(Conn,Conn->statcode,CS_AUTHERR,REQ,cc);
		clntClose(Conn,"a:authentication failure");
		return -2;
	}
	REQ_AUTH = ident;
	REQ_AUTH.i_stype = pauth ? AUTH_APROXY : AUTH_AORIGIN;
	if( pauth )
		HTTP_delRequestField(Conn,"Proxy-Authorization");
	else	HTTP_delRequestField(Conn,"Authorization");
	return 0;
}
static int checkAUTH(Connection *Conn,QueryContext *QX,FILE *fc,FILE *tc,PCStr(proto),PCStr(site),int port,int mandatory)
{	int auth,pauth;
	int totalc;

	if( !Conn->from_myself && NotREACHABLE(Conn,proto,site,port) ){
		service_permitted2(Conn,proto,0); /* cause delayReject */
		totalc = putHttpRejectmsg(Conn,tc,proto,site,port,AVStr(REQ));
		http_Log(Conn,403,CS_AUTHERR,REQ,totalc);
		return -1;
	}
	if( authOK ){
		return 0;
	}
	if( ClientAuthUser[0] != 0 )
	if( ClientAuth.i_stat & AUTH_MAPPED )
	{
		syslog_ERROR("??? AUTHORIZED ALREADY %X (%s)(%s)\n",
			ClientAuth.i_stat,ClientAuth.i_user,ClientAuth.i_Host);
/*
		return 0;
*/
	}

	 auth = auth_proxy_auth() || auth_origin_auth(/*Conn*/);
	pauth = auth_proxy_pauth();
	if( getMountAuthorizer(Conn,VStrNULL,0) ){
		auth |= MOUNT_AUTHORIZER;
	}
	if( mandatory && (auth || pauth) ){
		if(  auth && !findFieldValue(REQ_FIELDS,"Authorization")
		 || pauth && !findFieldValue(REQ_FIELDS,"Proxy-Authorization")
		)	goto FAILED;
	}

if( (auth & MOUNT_AUTHORIZER) == 0 )
	if( service_permitted2(Conn,proto,1) )
		return 0;

	if( auth || pauth ){
		if(HTTP_proxyAuthorized(Conn,REQ,REQ_FIELDS,pauth,tc)){
			const char *fname;
			if( pauth )
				fname = "Proxy-Authorization";
			else	fname = "Authorization";
			if( !forwardOK(Conn,FORWARD_AUTH,fname) )
				HTTP_delRequestField(Conn,fname);
			return 0;
		}

		if( !auth && pauth )
		if( WillKeepAlive && RequestSerno )
		{
			/* reuse Proxy-Authorization ? */
		}
	}

FAILED:
	service_permitted2(Conn,proto,0); /* cause delayReject */
	if( auth || pauth ){
		/*
		totalc = putNotAuthorized(Conn,tc,REQ,pauth,"</>","");
		*/
		totalc = putNotAuthorized(Conn,tc,REQ,pauth,NULL,"");
		http_Log(Conn,Conn->statcode,CS_AUTHERR,REQ,totalc);
/*
		http_Log(Conn,401,CS_AUTHERR,REQ,totalc);
*/
	}else{
		totalc = putHttpRejectmsg(Conn,tc,proto,site,port,AVStr(REQ));
		http_Log(Conn,403,CS_AUTHERR,REQ,totalc);
	}
	return -1;
}

int doACCEPT(Connection *Conn,QueryContext *QX,FILE *fc,FILE *tc)
{	int rcc;

	if( !strcaseeq(REQ_METHOD,"ACCEPT") )
		return 0;

	set_realserver(Conn,"tcprelay","-",0);
	if( checkAUTH(Conn,QX,fc,tc,"tcprelay","-",0,0) != 0 )
		return -1;
	rcc = HTTP_ACCEPT(Conn,REQ,REQ_FIELDS,fc,tc);
	return 1;
}

static int fpoll2(int timeout,FILE *fc,FILE *fs)
{	FILE *fpv[2];
	int rdv[2],nready,mask;

	fpv[0] = fc;
	fpv[1] = fs;
	nready = fPollIns(timeout,2,fpv,rdv);
	mask = 0;
	if( rdv[0] != 0 ) mask |= 1;
	if( rdv[1] != 0 ) mask |= 2;
	return mask;
}

static void put_forbidden(Connection*,QueryContext*,FILE*,int);
static int doCONNECT(Connection *Conn,QueryContext *QX,FILE *fc,FILE *tc)
{	const char *rproto;
	CStr(rhost,256);
	int rport;
	CStr(ctype,128);
	FILE *ts,*fs;
	int vno;
	CStr(genfields,0x8000);
	CStr(shost,512);
	int sport;
	int relayany;

	if( strncasecmp(REQ,"CONNECT",7) != 0 )
		return 0;

	DDI_proceedFromC(Conn,fc);

	rport = scan_hostportX("",REQ+8,AVStr(rhost),sizeof(rhost));
	if( rport <= 0 ){
		sv1log("CONNECT: Unknown Request? %s",REQ);
		return -1;
	}

	rproto = "ssltunnel";
	set_realserver(Conn,rproto,rhost,rport);

	if( !do_RELAY(Conn,RELAY_PROXY) ){
		strcpy(Conn->reject_reason,"NO RELAY=proxy");
		put_forbidden(Conn,QX,tc,1);
		return -1;
	}

	relayany = service_permitted2(Conn,rproto,1);
	if( !relayany )
		rproto = "https";

	set_realserver(Conn,rproto,rhost,rport);
	if( checkAUTH(Conn,QX,fc,tc,rproto,rhost,rport,0) != 0 )
		return -1;

	/* close ServPort because it might not be released for long time
	 * in relay_svcl()
	 */
	checkCloseOnTimeout(0);
	stopStickyServer("httpCONNECT");

	Conn->from_myself = 1; /* permission already checked by checkAUTH() */
	Conn->from_client = 1;
	set_realserver(Conn,"https",rhost,rport);
	setConnStart(Conn);

	if( connect_to_serv(Conn,FromC,ToC,0) < 0 ){
		putHttpCantConnmsg(Conn,tc,rproto,rhost,rport,OREQ);
		http_Log(Conn,500,CS_CONNERR,REQ,0);
		return -1;
	}

if( 0 <= ToSX )
	set_nodelay(ToSX,1);
else	set_nodelay(ToS,1);
set_nodelay(ClientSock,1);

	setConnDone(Conn);
	genProxyReqFields(Conn,AVStr(genfields),NULL);

	fs = fdopen(FromS,"r");
	if( toMaster || toProxy ){
		if( ToServ )
			ts = ToServ;
		else	ts = fdopen(ToS,"w");
		fputs(REQ,ts);
		fputs(genfields,ts);
		fputs(REQ_FIELDS,ts);
		fflush(ts);
		{	CStr(line,256);
			while( fgets(line,sizeof(line),fs) != NULL ){
				if( HTTP11_toclient == 0 )
				if( strncmp(line,"HTTP/1.",7) == 0 )
				if( line[7] != '0' )
					line[7] = '0';
				fputs(line,tc);
				if( line[0] == '\r' || line[0] == '\n' )
					break;
			}

			/*
			 * Ignore surplus CRLF after header generated by an
			 * upstream DeleGate of old version (6.1.5 to 7.8.3)
			 */
			if( !feof(fs) && ready_cc(fs) ){
				int ch;
				ch = getc(fs);
				if( ch != '\r' ){
					ungetc(ch,fs);
				}else{
					ch = getc(fs);
					if( ch != '\n' ){
						ungetc(ch,fs);
						ungetc('\r',fs);
					}else{
				sv1log("##IGNORED surplus CRLF from server.\n");
					}
				}
			}
/*
This is not good with buggy upstream DeleGate which returns duplicate
CRLFs as Connection:close<CRLF><CRLF><CRLF>
			fflush(tc);
			... 8.9.1: this fflush() become harmless by skipping
			surplus CRLF like above, and become necessary not to
			freeze on detection of greeting message
			from non-HTTP servers (since 8.8.8)
*/
			fflush(tc);
		}
	}else{
		ts = fdopen(ToS,"w");
		vno = HTTP_reqIsHTTP(Conn,REQ);
		if( 100 <= vno ){
			CStr(line,256);
			fprintf(tc,"HTTP/%s 200 Connection established.\r\n",
				HTTP11_toclient==0 ? "1.0":
				MY_HTTPVER);
			clntClose(Conn,"C:CONNECT method");
			if( getKeepAlive(Conn,AVStr(line)) )
				fputs(line,tc);
/*
This code generates a surplus <CRLF>
				fprintf(tc,"%s\r\n",line);
*/
			fprintf(tc,"\r\n");
			fflush(tc);
		}
	}

	sport = getClientHostPort(Conn,AVStr(shost));

	/* if( DST_PORT == 443 ) */
	if( fpoll2(10*1000,fc,fs) & 2 ){
		/* response from the server before sending request */
		daemonlog("F","WARNING: //%s:%d seems not HTTPS <=%s:%d\n",
			DST_HOST,DST_PORT,shost,sport);
		if( !relayany ){
			http_Log(Conn,403,CS_AUTHERR,REQ,0);
			strcpy(Conn->reject_reason,"server seems not HTTPS");
			HTTP_delayReject(Conn,REQ,"",1);
			return -1;
		}
	}

	ProcTitle(Conn,"https://%s:%d/)",rhost,rport);
	ctype[0] = 0;

	RELAY_ctrl = 0;
	if( relayany ){
		if( HTTP_opts & HTTP_NOPIPELINE )
			RELAY_ctrl |= RELAY_HALFDUP;
		if( HTTP_opts & HTTP_TOUTPACKINTVL )
			RELAY_max_packintvl = HTTP_TOUT_PACKINTVL;
	}else{
		RELAY_ctrl |= RELAY_HALFDUP;
		RELAY_max_packintvl = HTTP_TOUT_PACKINTVL;
		RELAY_max_turns = 4 + HTTP_CKA_MAXREQ*2;
		/* should check the handshake of SSL here ... */
	}

	if( strcaseeq(CLNT_PROTO,"https") )
	if( rport == 80 )
	if( HTTP_STARTTLS_withCL(Conn,fc,tc) ){
		/* seems to be relaying https://serv:80 to http://serv
		/* so the request/response should be rewritten
		 * with MOUNT="https://host:80/* http://host/*
		 */
		sv1log("## HTTPS client to HTTP server\n");
	}

	QX_totalc = relayf_svcl(Conn,fc,tc,fs,ts);
	if( RELAY_max_turns && RELAY_max_turns <= RELAY_num_turns ){
		daemonlog("E","WARNING: %d/%d turns / CONNECT %s:%d <= %s:%d\n",
			RELAY_num_turns,RELAY_max_turns,
			DST_HOST,DST_PORT,shost,sport);
	}
	RELAY_max_turns = 0; 
	if( RELAY_max_packintvl && RELAY_max_packintvl <= RELAY_packintvl ){
	daemonlog("E","WARNING: %f/%f tout-pack-intvl / CONNECT %s:%d <= %s:%d\n",
			RELAY_packintvl,RELAY_max_packintvl,
			DST_HOST,DST_PORT,shost,sport);
	}
	RELAY_max_packintvl = 0; 
	if( RELAY_ctrl & RELAY_HALFDUP ){
		if( RELAY_stat != 0 ){
		daemonlog("F","WARNING: non-half-dup CONNECT %s:%d <= %s:%d\n",
			DST_HOST,DST_PORT,shost,sport);
			strcpy(Conn->reject_reason,"non-half-dup CONNECT");
			HTTP_delayReject(Conn,REQ,"",1);
		}
		RELAY_ctrl = 0;
	}

	httpStat = CS_WITHOUTC;
	http_log(Conn,rproto,rhost,rport,REQ,200,ctype,QX_totalc,0,
		CONN_DONE-CONN_START,Time()-CONN_DONE);
	close(ToS);
	close(FromS);
	return 1;
}

void HTTP_reject(Connection *Conn,PCStr(why),PCStr(how));
static int nonHTTP(Connection *Conn,FILE *ftc[2],PVStr(request))
{	CStr(method,32);
	CStr(methods,256);
	refQStr(dp,request); /**/
	char dc;
	FILE *fc,*tc;
	const char *errmsg;
	CStr(erequest,URLSZ);

	fc = ftc[0];
	tc = ftc[1];
	errmsg = "not in HTTPCONF=methods";

	dp = wordScan(request,method);
	dc = *dp;
	if( dc != 0 && dc != ' ' && dc != '\t' && dc != '\r' && dc != '\n' )
		goto non_http;

	if( strcaseeq(method,"XECHO") ){
		if( isspace(*dp) )
			dp++;
		doXECHO(tc,dp);
		return 1;
	}

	if( strcaseeq(method,"X-CACHE-GET") ){
		GET_CACHE = 1;
		ovstrcpy((char*)request,request+8);
		return 0;
	}
	/* destination is not set yet ...
	if( !method_permitted(Conn,"http",method,1) ){
		if( Conn->reject_reason[0] )
			errmsg = Conn->reject_reason;
		else	errmsg = "forbidden method";
		sv1log("forbidden HTTP/%s (%s)\n",method,errmsg);
		goto non_http;
	}
	*/

	if( HTTP_allowMethod1(Conn,request) )
		return 0;

	if( strcaseeq(method,"!SET") ){
		DELEGATE_setenv(fc,tc,request);
		return 1;
	}

	if( isHelloRequest(request)
	 || VSAP_isMethod(request)
	 || streq(method,"HELO")
	 || streq(method,"CPORT")
	 || streq(method,"PARAM")
	 || streq(method,"FTPGET")
	){
		sv1log("---- WARNING! HTTP switched to GENERALIST[%s]\n",
			method);
		signal(SIGPIPE,SIG_DFL);
		DDI_proceedFromC(Conn,fc);
		beGeneralist(Conn,fc,tc,request);
		ftc[0] = ftc[1] = 0; /* fclose() in beGeneralist() */
		return 1;
	}

non_http:
/*
	sv1log("#### Method Not Allowed: %s",request);
*/
	HTTP_reject(Conn,"Method not allowed",errmsg);
	fprintf(tc,"HTTP/%s 405 Method Not Allowed\r\n",MY_HTTPVER);
	HTTP_allowMethods(Conn,AVStr(methods));
	fprintf(tc,"Allow: %s\r\n",methods);
	fprintf(tc,"Connection: close\r\n");
	fprintf(tc,"\r\n");
	url_escapeX(request,AVStr(erequest),sizeof(erequest),"","\r\n");
	fprintf(tc,"Method Not Allowed: %s\r\n",erequest);
	return 1;
}
void HTTP_reject(Connection *Conn,PCStr(why),PCStr(how))
{	CStr(shost,256);
	CStr(req,128);
	int sport;

	sport = getClientHostPort(Conn,AVStr(shost));
	lineScan(REQ,req);
	daemonlog("F","E-P: %s: %s:%d => %s (%s)\n",why,shost,sport,req,how);
}

static void gotNullRequest(Connection *Conn,QueryContext *QX,FILE *fc,FILE *tc)
{	CStr(clhost,256);

	if( getClientHostPort(Conn,AVStr(clhost)) == 0 )
		strcpy(clhost,"?");
	sv1log("HTTP empty_request ? from %s (%d)\n",clhost,Conn->cl_count);
	http_Log(Conn,500,CS_ERROR,"ERR /empty_request",0);
	delayConnError(Conn,REQ);
}
static int rewriteRequest(Connection *Conn,QueryContext *QX,FILE *fc,FILE *tc)
{ 
	if( rewrite_request(Conn,fc) == NULL ){
		gotNullRequest(Conn,QX,fc,tc);
		return -1;
	}
	return 0;
}
static int checkCookie(Connection *Conn)
{	MrefQStr(val,REQ_FIELDS); /**/

	if( val = findFieldValue(REQ_FIELDS,"Cookie") ){
		MountCookieRequest(Conn,OREQ,AVStr(val));
		if( (HTTP_cacheopt & CACHE_COOKIE) == 0 ){
			DontReadCache = 1;
			DontWriteCache = 1;
		}
		withCookie = 1;
	}else	withCookie = 0;
	return 0;
}
static int DELAY_RESPCLOSE = 0;
static int doMyself(Connection *Conn,QueryContext *QX,FILE *fc,FILE *tc,FILE *ftc[2])
{	int stcode;
	int mtime;
	CStr(ctype,256);
	double start;

	if( isMYSELF(QX_site) )
		ToMyself = 1;

	if( strstr(REQ,"?-_-") )
		ToMyself = 1;

	if( !ToMyself )
		return 0;

/*
	if( auth_origin_auth(Conn) ){
*/
	if( auth_origin_auth(/*Conn*/)
	 || getMountAuthorizer(Conn,VStrNULL,0)
	){
		if( checkAUTH(Conn,QX,fc,tc,QX_proto,QX_site,QX_port,1) != 0 )
			return 1;
	}

	/* is public thus permission is not necessary? */
	stcode = 200;
	start = Time();
	mtime = 0;

	if( (Conn->xf_filters & XF_FTOCL) == 0 ){
		if( sav_FTOCL )
			setFTOCL(sav_FTOCL);
		tc = insertFTOCL_X(Conn,tc);
		ftc[1] = tc;
		setFTOCL(NULL);
	}

	if( QX_totalc = HttpToMyself(Conn,AVStr(REQ),REQ_FIELDS,fc,tc,&stcode) ){
		CONN_DONE = CONN_START = start;
		if( httpStat == 0 )
			httpStat = CS_INTERNAL;
		ctype[0] = 0;
		http_log(Conn,DST_PROTO,DST_HOST,DST_PORT,REQ,
			stcode,ctype,QX_totalc,mtime, 0.0,Time()-start);
		if( DELAY_RESPCLOSE ){
			fflush(tc);
			sv1log("## SLEEP BEFORE CLOSE: %d\n",DELAY_RESPCLOSE);
			sleep(DELAY_RESPCLOSE);
		}
		return 1;
	}

	return 0;
}
static const char *getuserpass(Connection *Conn,PCStr(site),PVStr(uuser),PVStr(upass),xPVStr(auth),int asiz)
{	const char *host;
	const char *dfltuser;
	CStr(authb,512);
	CStr(myauth,256);
	CStr(myauthx,1024);

	/*
	 * HTTPCONF=dfltuser-ftp:name might be necessary...
	 */

	if( CTX_with_auth_anonftp(Conn) ) /* AUTH=anonftp */
		dfltuser = "anonymous";
	else	dfltuser = "";
	host = scan_url_userpass(site,AVStr(uuser),AVStr(upass),dfltuser);

	if( asiz == 0 ){
		asiz = sizeof(authb);
		setPStr(auth,authb,sizeof(authb)); /* for cache hit */
	}
	HTTP_authuserpass(Conn,AVStr(auth),asiz);

	if( get_MYAUTH(Conn,AVStr(myauth),"ftp",DST_HOST,DST_PORT) ){
		strfConnX(Conn,myauth,AVStr(myauthx),sizeof(myauthx));
		scan_field1(myauthx,AVStr(uuser),64,AVStr(upass),64);
	}

	if( strcmp(uuser,"-auth") == 0
	 || *uuser == 0 && auth == authb /* for cache hit */
	){
		scan_field1(auth,AVStr(uuser),256,AVStr(upass),256);
	}
	if( *uuser == 0 ){
		if( *auth )
			wordscanY(auth,AVStr(uuser),256,"^:");
		if( *uuser == 0 )
			strcpy(uuser,"anonymous");
	}
	return host;
}

static int HttpFtp(Connection *Conn,QueryContext *QX,FILE *fc,FILE *tc,int svsock,PCStr(server),int iport,PCStr(req),int *stcodep)
{	const char *method;
	const char *ver;
	HttpRequest reqx;
	MrefQStr(path,reqx.hq_url); /**/
	CStr(gpath,1024);
	char gtype;
	CStr(user,256);
	CStr(pass,256);
	CStr(auth,512);
	const char *host;

	Conn->body_only = !HTTP_reqWithHeader(Conn,req);
	decomp_http_request(req,&reqx);
	method = reqx.hq_method;
	ver = reqx.hq_ver;

	lineScan(path,gpath);
	gtype = get_gtype(gpath,AVStr(path));

/*
	host = scan_url_userpass(server,user,pass,"anonymous");
	HTTP_authuserpass(Conn,auth,sizeof(auth));
*/
	host = getuserpass(Conn,server,AVStr(user),AVStr(pass),AVStr(auth),sizeof(auth));

	return httpftp(Conn,fc,tc,ver,method,svsock,
		auth,user,pass,host,iport,gtype,path,stcodep);
}
static int HttpFinger(Connection *Conn,int vno,int sv,PCStr(server),int iport,PCStr(path))
{
	if( sv == -1 )
		return 0;
	return httpfinger(Conn,sv,server,iport,path,vno);
}
static void http_gateway(Connection *Conn,QueryContext *QX,FILE *fc,FILE *tc,int sv)
{	const char *proto = QX_proto;
	const char *server = QX_site;
	int iport = QX_port;
	MrefQStr(req,REQ); /**/
	const char *method;
	HttpRequest reqx;
	MrefQStr(path,reqx.hq_url); /**/
	const char *ver;
	CStr(user,256);
	CStr(pass,256);
	CStr(request,URLSZ);
	CStr(rserver,256);
	CStr(hostport,256);
	AuthInfo ident;
	int vno;
	int msock;
	int rcode,rtotal;
	CStr(ctype,128);
	char gtype;
	const char *dp;
	int qlen;

	Where = "Gatewaying";
	nsigPIPE = 0;

	vno = decomp_http_request(req,&reqx);
	method = reqx.hq_method;
	ver = reqx.hq_ver;
	HostPort(AVStr(hostport),proto,server,iport);

	rcode = 200;
	ctype[0] = 0;
	rtotal = 0;
	setConnStart(Conn);
	msock = -1;
	DDI_proceedFromC(Conn,fc);

	qlen = strlen(OREQ);
	if( HTTP_GW_MAX_REQLINE < qlen ){
		sv1log("## HTTPCONF=%s:%d<%d -- %s",
			HTTP_GW_MAX_REQLINE_sym,HTTP_GW_MAX_REQLINE,qlen,OREQ);
		putBadRequest(Conn,tc,"request-line-too-long");
		return;
	}

	/* if( strcaseeq(proto,"ftp") || strcaseeq(proto,"file") ) */
	if( strcaseeq(proto,"ftp") ){
		setConnDone(Conn);
		get_gtype(path,AVStr(path));
		rtotal = HttpFtp(Conn,QX,fc,tc,sv,server,iport,req,&rcode);
		sprintf(request,"%s %s://%s%s%s HTTP/%s",method,proto,hostport,
			(*path=='/'?"":"/"),path,ver);
		goto EXIT;
	}

	sprintf(request,"GET %s://%s",proto,hostport);
	if( *path == '/' )
		strcat(request,path);
	Xsprintf(TVStr(request)," HTTP/%s",ver);

	if( strcaseeq(proto,"wais") ){
		setConnDone(Conn);
		rtotal = HttpWais(Conn,vno,sv,server,iport,path);
		/*goto EXIT;*//* log was done in HttpWais */
		return;
	}
	if( strcaseeq(proto,"finger") ){
		setConnDone(Conn);
		rtotal = HttpFinger(Conn,vno,sv,server,iport,path);
		goto EXIT;
	}
	if( strcaseeq(proto,"news") || strcaseeq(proto,"nntp")
	 || strcaseeq(proto,"pop") ){
		setConnDone(Conn);
		if( path[0] == '/' )
			ovstrcpy((char*)path,path+1);
		else
		if( strncasecmp(path,"news:",5) == 0 )
			ovstrcpy((char*)path,path+5);

		HTTP_getAuthorization(Conn,0,&ident,0);
		rtotal = HttpNews(Conn,vno,fc,sv,server,iport,path,request,
				AVStr(ident.i_user),AVStr(ident.i_pass),
				ClntKeepAlive&&WillKeepAlive,&rcode);

		if( dp = strchr(ident.i_user,'@') ){
			server = dp + 1;
		}
		goto EXIT;
	}
	if( strcaseeq(proto,"whois") ){
		if( 100 <= vno ){
			putHEAD(Conn,tc,200,"Whois/HTTP gateway",NULL,
				"text/plain",NULL,0,-1,-1);
			fputs("\r\n",tc);
			fflush(tc);
		}
		sprintf(req,"whois://%s?%s\r\n",hostport,*path=='/'?path+1:path);
		DDI_pushCbuf(Conn,req,strlen(req));
		service_whois(Conn);
		goto EXIT;
	}

	if( protoGopher(proto) ){
		if( gtype = decomp_gopherURL(Conn,req,AVStr(path)) ){
			vno = HTTP_reqIsHTTP(Conn,req);
			rtotal = HttpGopher(Conn,vno,sv,server,iport,gtype,path);
			sprintf(request,"GET %s://%s/%s",proto,hostport,path);
			goto EXIT;
		}
	}
	sprintf(request,"GET %s://%s/%s",proto,hostport,path);

	if( 0 <= (msock = openMaster(Conn,sv,server,1)) ){
		setConnDone(Conn);
		if( protoGopher(proto) )
			rtotal = relay_svcl(Conn,-1,ToC,msock,-1 /*,1,512*/);
		else	rtotal = relay_svcl(Conn,FromC,ToC,msock,msock /*,1,512*/);
	}else{
		sv1log("ERROR: cannot connect to a MASTER\n");
		rcode = 403;
		rtotal = 0;
	}

EXIT:
	if( Conn->statcode )
		rcode = Conn->statcode;

	if( 0 < Conn->sv.p_range[0] ){
		rcode = 206;
		rtotal = Conn->sv.p_range[1] - Conn->sv.p_range[0] + 1;
	}

	http_log(Conn,proto,server,iport,request,rcode,ctype,rtotal,0,
		CONN_DONE-CONN_START,Time()-CONN_DONE);

	if( nsigPIPE ){
		clntClose(Conn,"p:premature client EOF on gatewaying");
		setClientEOF(Conn,tc,"gatewaying_%s.SIGPIPE",proto);
	}
}
static int doFtpCached(Connection *Conn,QueryContext *QX,FILE *fc,FILE *tc)
{	const char *method;
	const char *path;
	const char *ver;
	HttpRequest reqx;
	CStr(user,256);
	CStr(pass,256);
	const char *host;
	int vno;
	int rc;

	vno = decomp_http_request(REQ,&reqx);
	method = reqx.hq_method;
	path = reqx.hq_url;
	ver = reqx.hq_ver;

	if( vno < 100 )
		return 0;
	if( !streq(method,"GET") )
		return 0;

/*
	host = scan_url_userpass(QX_site,user,pass,"anonymous");
*/
	host = getuserpass(Conn,QX_site,AVStr(user),AVStr(pass),VStrNULL,0);
	if( is_anonymous(user) && *pass == 0 ){
		AuthInfo ident;
		if( HTTP_getAuthorization2(Conn,&ident,0) )
			textScan(ident.i_pass,pass);
		if( *pass == 0 )
			strcpy(pass,"-");
	}

	rc = 200;
	if( QX_totalc = httpftp_cached(Conn,tc,user,pass,host,QX_port,path,&rc) ){
		http_Log(Conn,rc,CS_HITCACHE,REQ,QX_totalc);
		return 1;
	}
	return 0;
}
static int doCache(Connection *Conn,QueryContext *QX,FILE *fc,FILE *tc)
{	int cretry;
	int dontWaitCache;

	if( QX_useCache == 0 )
		return 0;

	cretry = 0;
	set_DG_EXPIRE(Conn,QX_expire);
	dontWaitCache = DontWaitCache;

retry_read:
	if( QX_cachefp != NULL )
		CacheClose(QX);
	QX_cdate = -1;
	if( 5 < cretry++ )
		return 0;

	if( !DontReadCache )
	if( QX_cachefp = cache_fopen_rd("HTTP",AVStr(QX_cpath),QX_expire,&QX_cdate) ){
		CStr(val,128);
		if( fgetsHeaderField(QX_cachefp,"Vary",AVStr(val),sizeof(val)) ){
			sv1log("ignore cache with Vary: %s\n",val);
			CacheClose(QX);
			return 0;
		}

		if( LockedByC(Conn,QX_cpath,fc) ){ CacheClose(QX); return 0; }
		if( lock_for_rd("HTTP",cretry,QX_cpath,QX_cachefp) != 0 ){
			sleep(CACHE_RDRETRY_INTERVAL);
			goto retry_read;
		}
		if( HTTP_selfExpired(QX_cachefp) && !Conn->co_nonet ){
			CacheClose(QX);
		}else{
			setConnStart(Conn);
			CONN_DONE = CONN_START - 1;
			/* minus value represent no connection ... */

			if( relay_response_fromCache(Conn,QX,
			    QX_proto,QX_site,QX_port,REQ,
			    QX_cpath,QX_cachefp,tc,fc) != 0 )
			{
				/* sent something wrong to client X-< */
			}
			return 1;
		}
	}

	if( !DontWriteCache )
	if( QX_cachefp = cache_fopen_rw("HTTP",AVStr(QX_cpath)) ){
		if( LockedByC(Conn,QX_cpath,fc) ){ CacheClose(QX); return 0; }
		if( file_lock_wr("HTTP",QX_cachefp) != 0 ){
			FILE *rfp;
			int updated;

			rfp = recvDistribution(Conn,QX_cpath,&updated);
			if( updated )
				goto retry_read;

			if( rfp != NULL ){
				setConnStart(Conn);
				CONN_DONE = CONN_START;
				relay_response(Conn,QX,0,QX_proto,QX_site,QX_port,
					REQ,NULL,0,rfp,tc,fc,NULL,0);
				fclose(rfp);
				return 1;
			}
			if( !DontReadCache && !dontWaitCache ){
				sleep(CACHE_WRRETRY_INTERVAL);
				goto retry_read;
			}
			CacheClose(QX);
		}else{
			makeDistribution(Conn,QX_cachefp,QX_cpath);
			DontWaitCache = 1;
		}
	}else{
		/* readable but not writable */
		if( QX_cdate != -1 )
			QX_cdate = -1;
	}
	return 0;
}
static int doMaxHops(Connection *Conn,QueryContext *QX,FILE *fc,FILE *tc)
{
	if( HTTP_MAXHOPS < D_HOPS ){
		sv1log("#### MAX_HOPS %d < %d HOPS\n",HTTP_MAXHOPS,D_HOPS);
		fprintf(tc,"HTTP/%s 502 too many hops\r\n",MY_HTTPVER);
		fprintf(tc,"\r\n");
		fprintf(tc,"Too many hops: %d\r\n",D_HOPS);
		return 1;
	}
	return 0;
}
static void pollRequestBody(Connection *Conn,QueryContext *QX,FILE *fc,FILE *tc)
{	CStr(cleng,128);
	int nready;
	int timeout;

	if( getFV(REQ_FIELDS,"Content-Length",cleng) )
	if( 0 < atoi(cleng) )
	if( DDI_PollIn(Conn,fc,100) == 0 ){
		timeout = (int)(HTTP_WAIT_REQBODY * 1000);
		sv1log("#### start polling body of %s %dms\n",REQ_METHOD,
			timeout);
		nready = DDI_PollIn(Conn,fc,timeout);
		sv1log("#### polling done: %d\n",nready);
	}
}

static int tryICP(Connection *Conn,QueryContext *QX,FILE *fc,FILE *tc)
{	CStr(msg1,64);
	CStr(msg2,64);

	if( select_icpconf(Conn,VStrNULL) )
		connect_to_serv(Conn,FromC,ToC,0);
	if( FromS < 0 )
		return 0;

	sprintf(msg1,"ConnType=%c%s%s%s%s",
		ConnType?ConnType:'?',
		IAM_GATEWAY?"/GateWay":"",
		toProxy?"/Proxy":"",
		toMaster?"/Master":"",
		0<=Conn->ca_objsize?"/HIT_OBJ":"");

	if( ConnType == 'i' ){
		if( 0 <= Conn->ca_objsize ){
			sprintf(msg2,"RECEIVED HIT_OBJ=%d",
				Conn->ca_objsize);
		}else
		if( toProxy ){
			ConnType = 'p';
			strcpy(msg2,"FORWARDING to HTTP proxy");
			IAM_GATEWAY = 0;
			connected_to_proxy(Conn,REQ,FromS);
		}else
		if( toMaster ){
			ConnType = 'm';
			strcpy(msg2,"FORWARDING to MASTER DeleGate");
		}else{
			strcpy(msg2,"FORWARDING to ORIGIN server");
		}
	}else{
		msg2[0] = 0;
		if( toProxy ){
			ConnType = 'p';
			strcpy(msg2,"FORWARDING to HTTP proxy");
			IAM_GATEWAY = 0;
			connected_to_proxy(Conn,REQ,FromS);
		}
	}
	sv1log("(ICP) %s{%s}(%s:%d) %s",msg1,msg2,QX_site,QX_port,REQ);

	if( IAM_GATEWAY ){
		http_gateway(Conn,QX,fc,tc,FromS);
		return -1;
	}
	return 0;
}
static int tryConnects(Connection *Conn,QueryContext *QX,FILE *fc,FILE *tc)
{
	if( tryICP(Conn,QX,fc,tc) < 0 )
		return -1;

	if( streq(QX_proto,"nntp") || streq(QX_proto,"news")
	 || streq(QX_proto,"pop")
	 || streq(QX_proto,"ftp" ) || streq(QX_proto,"file") ){
		/* don't try direct routes, just check PROXY.  */
		tryProxyOnly = 1;
	}
	if( FromS < 0 ){
		connect_to_serv(Conn,FromC,ToC,0);
	}
	tryProxyOnly = 0;

	if( IAM_GATEWAY && !toProxy ){
		int comask;

		comask = Conn->co_mask;
		Conn->co_mask |= CONN_NOPROXY;
		http_gateway(Conn,QX,fc,tc,FromS);
		Conn->co_mask = comask;
		return -1;
	}
	if( FromS < 0 ){
		sv1log("cannot connect to server: %s://%s:%d\n",
			DST_PROTO,DST_HOST,DST_PORT);

		if( checkClientEOF(Conn,tc,"cant_connect") ){
			http_Log(Conn,500,CS_CONNERR,REQ,0);
		}else
		if( QX_cachefp != NULL && QX_cdate != -1 ){
			setConnDone(Conn);
			sv1log("makeshift with old cache (A).\n");
			httpStat = CS_MAKESHIFT;
			relay_response(Conn,QX,0,QX_proto,QX_site,QX_port,
				REQ,QX_cpath,1,QX_cachefp,tc,NULL,NULL,1);
		}else{
			QX_totalc = putHttpCantConnmsg(Conn,tc,
				QX_proto,QX_site,QX_port,OREQ);

			/* when Pragma: no-cache */
			if( QX_cachefp != NULL && 0 < file_size(fileno(QX_cachefp)) ){
				int ooff = ftell(QX_cachefp);
				fseek(QX_cachefp,0,2);
				sv1log("preserved old cache (%d->%d) %s\n",
					ooff,ftell(QX_cachefp),QX_cpath);
			}
			http_Log(Conn,500,CS_CONNERR,REQ,0);
			HTTP_delayCantConn(Conn,REQ,"500 cannot connect\r\n",1);
		}
		if( QX_cachefp != NULL && file_size(fileno(QX_cachefp)) <= 0 )
			QX_cacheRemove = 1;
		return -1;
	}

/*
set_nodelay(ToC,1);
set_nodelay(ToS,1);
*/

	if( toMaster ){
		sv1log("HTTP -> (%s:%d) %s",QX_site,QX_port,REQ);
	}else{
		std_setsockopt(ToS);
		sv1log("HTTP => (%s:%d) %s",QX_site,QX_port,REQ);
	}

	if( checkClientEOF(Conn,tc,"connected") ){
		http_Log(Conn,500,CS_EOF,REQ,0);
		return -1;
	}

	/* do getsockopt(client) immediately after EOF check */
	expsockbuf(ToC,0,MAX_BUFF_SOCKSEND);

	set_keepalive(FromS,1);
	expsockbuf(FromS,MAX_BUFF_SOCKRECV,0);
	setConnDone(Conn);
	return 0;
}
static void doTruncateCache(Connection *Conn,QueryContext *QX,FILE *fc,FILE *tc)
{
	if( QX_rcode == R_EMPTY_RESPONSE && QX_cdate != -1 ){
		sv1log("makeshift with old cache (B).\n ");
		Verbose("cache-file: %s\n",QX_cpath);

		lock_sharedNB(fileno(QX_cachefp));
		relay_response(Conn,QX,0,QX_proto,QX_site,QX_port,
			REQ,QX_cpath,1,QX_cachefp,tc,fc,NULL,QX_cdate != -1);
	}else
	if( DontTruncate ){
		Verbose("DontTruncate: rcode=%d ftell:%d\n",
			QX_rcode,ftell(QX_cachefp));
	}else
	if( QX_rcode < 0 ){
		if( QX_hcode == 404 && (HTTP_cacheopt & CACHE_404) ){
		}else
		if( QX_rcode==R_GENERATED && (HTTP_cacheopt&CACHE_NOLASTMOD) ){
			CStr(url,URLSZ);
			url[0] = 0;
			HTTP_originalURLx(Conn,AVStr(url),sizeof(url));
			sv1log("WARNING:cached without Last-Modified:%s\n",url);
		}else{
		sv1log("rcode=%d unlink %s (%d)\n",QX_rcode,QX_cpath,
			File_size(QX_cpath));
		QX_cacheRemove = 1;
		}
	}else{
		if( httpStat == CS_STABLE ){
		}else{
			sv1log("%d bytes written to [%s]\n",
				ftell(QX_cachefp),QX_cpath);
			Ftruncate(QX_cachefp,0,1);
		}
	}
}
static void closeServ(Connection *Conn,QueryContext *QX,FILE *ts,FILE *fs)
{
	delServ(Conn,fileno(ts),fileno(fs));
	fclose(ts);
	fclose(fs);
	FromS = -1;
	if( 0 < QX_cpid ){
		Kill(QX_cpid,SIGTERM);
		wait(0);
		QX_cpid = 0;
	}
	Conn->sv_reusing = 0;
}

static int forbiddenMethod(Connection *Conn)
{ 
	if( HTTP_opts & HTTP_NOMETHODCHECK )
		return 0;

	if( method_permitted(Conn,"http",REQ_METHOD,1) )
		return 0;

	if( strcmp(DST_PROTO,"http") != 0 )
	if( method_permitted(Conn,DST_PROTO,REQ_METHOD,1) )
		return 0;

	sprintf(Conn->reject_reason,"forbidden method:%s",REQ_METHOD);
	return 1;
}

static void put_forbidden(Connection *Conn,QueryContext *QX,FILE *tc,int delay)
{
	QX_totalc = putHttpRejectmsg(Conn,tc,QX_proto,QX_site,QX_port,AVStr(REQ));
	http_Log(Conn,403,CS_AUTHERR,REQ,QX_totalc);
	if( delay )
		HTTP_delayReject(Conn,REQ,"",1);
}
static void service_http2X(Connection *Conn,FILE *ftc[2],QueryContext *QX)
{	FILE *ts,*fs;
	FILE *respFile,*tc_sav;
	int chunksav;
	FILE *fc,*tc;
	int qlen;

	authOK = 0;

	fc = ftc[0];
	tc = ftc[1];

	httpStat = 0;
	httpStatX = 0;

	QX_Conn = Conn;
	QX_site = DFLT_HOST;
	QX_port = DFLT_PORT;

	QX_cpath[0] = 0;
	QX_cachefp = NULL;
	QX_cdate = -1;
	QX_cacheRemove = 0;

	QX_range[0] = QX_range[1] = -1;
	Conn->cl.p_range[0] = Conn->cl.p_range[1] = -1;

	PragmaNoCache = 0;
	DontTruncate = 0;
	ToMyself = 0;

	CheckServ = 0;
	WaitServ = 0;
	BadServ = 0;

	if( ImMaster && CacheOnly ){
		lookCacheOnly(Conn,QX,tc,fc);
		goto EXIT;
	}

	/*
	 * This code is introduced in 6.1.0 to forbid relaying by (origin)
	 * HTTP-DeleGate (with SERVER=http) with RELAY=no after metamo. to
	 * MASTER-DeleGate (indicated by ACT_GENERALIST=1).
	 */
	if( ImMaster && ACT_GENERALIST ){ /* metamo. */
		if( !do_RELAY(Conn,RELAY_DELEGATE)
		 && !do_RELAY(Conn,RELAY_VHOST)
		 && !do_RELAY(Conn,RELAY_PROXY) ){ 
			sv1log("Forbidden: RELAY by switch to GENERALIST\n");
			returnAckDENIED(Conn,tc,"relay forbidden");
			goto EXIT;
		}
	}

	returnAckOK(Conn,tc,"http");

	REQ[0] = 0;
	if( fgetsRequest(Conn,AVStr(REQ),sizeof(REQ),fc,0) == NULL || REQ[0] == 0 ){
		if( RequestSerno ){
			clntClose(Conn,"q:by client (request EOF-8)");
			setClientEOF(Conn,fc,"request-EOF-8");
			goto EXIT;
		}
		gotNullRequest(Conn,QX,fc,tc);
		goto EXIT;
	}
	qlen = strlen(REQ);
	if( HTTP_MAX_REQLINE < qlen ){
		sv1log("## HTTPCONF=%s:%d<%d -- %s",
			HTTP_MAX_REQLINE_sym,HTTP_MAX_REQLINE,qlen,REQ);
		putBadRequest(Conn,tc,"request-line-too-long");
		goto EXIT;
	}

	if( nonHTTP(Conn,ftc,AVStr(REQ)) )
		goto NHEXIT;

	if( HTTP09_reject && !HTTP_reqWithHeader(Conn,REQ) ){
		sv1log("## rejected HTTP/0.9 non-header message\n");
		putBadRequest(Conn,tc,"ver-0.9-not-allowed");
		goto EXIT;
	}

	if( HTTP11_clientTEST && ReqVer(REQ,'0',AVStr(REQ),'1') ){
		sv1log("#HT11 emulate HTTP/1.1 client's request.\n");
	}

	HTTP_decompRequest(Conn);
	strcpy(OREQ,REQ);
	Xstrcpy(ZVStr(OREQ_HOST,OREQ_HOST_SIZ),DFLT_HOST);
	OREQ_PORT = DFLT_PORT;

	if( ReqVer(REQ,'1',AVStr(REQ),HTTP11_toserver?'1':'0') ){
		if( HTTP11_toclient )
		ClntAccChunk = 1;
		clientAskedKeepAlive(Conn,"Connection","keep-alive");
		if( HTTP11_toclient == 0 )
			WillKeepAlive = 0;
		/* This set-up for keep-alive must be done before interpreting
		 * Request-Header (Connection: field)
		 */
	}
	if( HTTP_opts & HTTP_NOKEEPALIVE ){
		WillKeepAlive = 0;
	}

	BadRequest = 0;
	Normalized = 0;
	recvRequestFields(Conn,QX,fc);

	HL_setClientAgent(REQ_UA);
	SVREQ_ATYP[0] = 0;
	Conn->xf_reqrecv = 1;

	if( needSTLS(Conn) ){
		if( strcaseeq(QX_upgrade,"TLS/1.0") ){
			fprintf(tc,"HTTP/1.1 101 Switching Protocol\r\n");
			fprintf(tc,"Upgrade: TLS/1.0, HTTP/1.1\r\n");
			fprintf(tc,"Connection: upgrade\r\n");
			fprintf(tc,"\r\n");
			fflush(tc);
			{
				int fcl;
				fcl = insertTLS_CL(Conn,ClientSock,-1);
				dup2(fcl,ClientSock);
				close(fcl);
			}
		}else{
			http_Log(Conn,426,CS_ERROR,REQ,0);
			strcpy(Conn->reject_reason,"Not with SSL");
			HTTP_delayReject(Conn,REQ,"",1);

			fprintf(tc,"HTTP/1.1 426 Upgrade Required\r\n");
			fprintf(tc,"Upgrade: TLS/1.0, HTTP/1.1\r\n");
			fprintf(tc,"Connection: Upgrade\r\n");
			fprintf(tc,"Content-Type: text/html\r\n");
			fprintf(tc,"\r\n");
			fprintf(tc,"protocol error, must be in HTTPS/SSL.\r\n");
			goto EXIT;
		}
	}

	if( HTTP_opts & HTTP_SESSION ){
		if( ClientSession[0] == 0 ){
			genSessionID(Conn,AVStr(ClientSession),0);
		}
	}

	if( HTTP_MAX_REQHEAD < OREQ_LEN ){
		sv1log("## HTTPCONF=%s:%d<%d -- %s%s",
			HTTP_MAX_REQHEAD_sym,HTTP_MAX_REQHEAD,
				OREQ_LEN,REQ,REQ_FIELDS);
		putBadRequest(Conn,tc,"request-head-too-long");
		goto EXIT;
	}
	if( 0 <= QX_range[0] ){
		sv1log("#HT11 Don't use chunked encoding for Range: %d-%d\n",
			QX_range[0],QX_range[1]);
		ClntAccChunk = 0;
	}

	if( BadRequest && HTTP_rejectBadHeader ){
		sv1log("##HHe ILLEGAL HEADER##\n");
		if( HTTP_methodWithBody(REQ_METHOD) ){
			FILE *xs = NULLFP();
			relayRequestBody1(Conn,fc,xs,xs,REQ,REQ_FIELDS);
		}
		lineScan("beforeConnnect",BadServDetected);
		lineScan("NOT-CONNECTED",BadServResponse);
		httpStat = CS_BADREQUEST;
		putBadRequest(Conn,tc,NULL);
		goto EXIT;
	}

	bzero(&REQ_AUTH,sizeof(AuthInfo));

	/*
	8.9.6 data: should be interpreted after rewriting by MOUNT
	if( strncmp(REQ_URL,"data:",5) == 0 ){
		HTTP_putData(Conn,tc,REQ_VNO,REQ_URL+5);
		goto EXIT;
	}
	*/
	/*
	 * parse request to set destination info. REAL_{PROTO,HOST,PORT}
	 * before applying AUTHORIZER with ConnMap
	 */
	HTTP_getHost(Conn,REQ,REQ_FIELDS);
	if( rewriteRequest(Conn,QX,fc,tc) < 0 )
		goto EXIT;
	if( streq(REQ_METHOD,"CONNECT") ){
		int port;
		CStr(host,256);
		port = scan_hostport1X(REQ_URL,AVStr(host),sizeof(host));
		if( port == 443 )
			set_realsite(Conn,"https",host,port);
		else	set_realsite(Conn,"tcprelay",host,port);
	}

#if 0
	if( CTX_auth(Conn,NULL,NULL) ) /* with AUTHORIZER */
#endif
	if( CTX_withAuth(Conn) )
	if( ClientAuthUser[0] == 0 )
	{
		if( doauth(Conn,tc) < 0 )
			goto EXIT;
		else	authOK = 1;
	}

	if( doCONNECT(Conn,QX,fc,tc) )
		goto EXIT;

RETRY:
	if( Conn->sv_retry == SV_RETRY_DO ){
		sv1log("RETRYing with [%s]...\n",REQ_URL);
		sprintf(REQ,"%s %s HTTP/%s\r\n",REQ_METHOD,REQ_URL,REQ_VER);
		if( rewriteRequest(Conn,QX,fc,tc) < 0 )
			goto EXIT;
		Conn->sv_retry |= SV_RETRY_DONE;

		/* for ImMaster, IsMyself will not be set in rewrite_request
		 * then doMyself() is not called thus substituting with a URL
		 * MOUNTed to builtin/local will never succeed...
		 */
	}

	{
	/* 8.10.4: in 8.9.6-pre8, MountMoved() came to be applied after
	 MountRequest() which could rewrite {DFLT,REAL}_PROTO as its
	 side effect when MOUNT for the same vURL without "moved" exists,
	 but DFLT_PROTO is used for MOUNT for MountMoved() as the
	 implicit protocol name for MOUNT="... //host", so it must be
	 left as the original one (iSERVER_PROTO) here.
	 It should be fixed not to rewrite DFLT_PROTO,
	 or to suppress retrying MOUNT both for with/without VHOST,
	 by returning "FOUND as unmatch" when MOVED_TO is found
	 during search for non-MOVED_TO MOUNT
	fprintf(stderr,"-- [%s][%s][%s]\n",iSERVER_PROTO,DFLT_PROTO,REAL_PROTO);
	*/
	CStr(dflt,256);
	strcpy(dflt,DFLT_PROTO); strcpy(DFLT_PROTO,iSERVER_PROTO);
	if( MountMoved(Conn,tc /*,REQ,REQ_URL*/) )
		goto EXIT;
	strcpy(DFLT_PROTO,dflt);
	}

	if( MountSpecialResponse(Conn,tc) )
		goto EXIT;
	if( doMaxHops(Conn,QX,fc,tc) )
		goto EXIT;


	/*
	8.9.6 unified into CTX_auth() above.
	if( withMountAUTHORIZER(Conn) )
	if( ClientAuthUser[0] == 0 )
	{
		if( doauth(Conn,tc) < 0 )
			goto EXIT;
		else	authOK = 2;
	}
	*/
	if( strncmp(REQ_URL,"data:",5) == 0 ){
		HTTP_putData(Conn,tc,REQ_VNO,REQ_URL+5);
		goto EXIT;
	}

	if( DO_DELEGATE && delegate_moved(Conn,tc) )
		goto EXIT;

	setREQUEST(Conn,REQ);
	decompREQUEST(Conn,QX);

	if( doACCEPT(Conn,QX,fc,tc) )
		goto EXIT;

	if( RelayForbidden || HTTP_forgedAuthorization(Conn,REQ_FIELDS) ){
		put_forbidden(Conn,QX,tc,RelayForbidden);
		goto EXIT;
	}

	setupConnect(Conn);
	if( Conn->co_nonet ){
		DontReadCache = 0;
		DontWriteCache = 1;
	}

/*
 if( 1 ){
CStr(head,1024);
CStr(body,1024);
sprintf(body,"Upgrade to TLS/1.0 ...\r\n");
head[0] = 0;
Xsprintf(TVStr(head),"HTTP/1.1 426\r\n");
Xsprintf(TVStr(head),"Upgrade: TLS/1.0, HTTP/1.1\r\n");
Xsprintf(TVStr(head),"Connection: upgrade\r\n");
Xsprintf(TVStr(head),"Content-Type: text/plain\r\n");
Xsprintf(TVStr(head),"Content-Length: %d\r\n",strlen(body));
Xsprintf(TVStr(head),"\r\n");
 fprintf(tc,"%s%s",head,body);
fflush(tc);
sv1log("##### CONNECITION UPGRADE TEST:\n%s%s\n%s%s\n",
	REQ,REQ_FIELDS,head,body);
sleep(1);
SentKeepAlive = 1;
goto EXIT;
 }
*/

	/*
	if( doMyself(Conn,QX,fc,tc) )
	*/
	if( doMyself(Conn,QX,fc,tc,ftc) )
		goto EXIT;
	if( Conn->sv_retry == SV_RETRY_DO ){
		goto RETRY;
	}

	/* this check should be applied to doMyself() too, but access to
	 * local "/-/..." etc. might be better to be exempted...
	 * because representation of "self" in access control is not clear. 
	 */
	if( forbiddenMethod(Conn) ){
		put_forbidden(Conn,QX,tc,1);
		goto EXIT;
	}

	if( ImMaster ){
		/* MASTER receives HTTP request for an origin server */
	}else
	if( !IsMounted && !DO_DELEGATE && IsVhost )
	if( !do_RELAY(Conn,RELAY_VHOST) ){
		sv1log("relaying to virtual host is not allowed\n");
		sprintf(Conn->reject_reason,"\"vhost\" is not in RELAY");
		RelayForbidden |= RELAY_VHOST;
		put_forbidden(Conn,QX,tc,1);
		goto EXIT;
	}

	if( checkAUTH(Conn,QX,fc,tc,QX_proto,QX_site,QX_port,0) != 0 )
		goto EXIT;

	if( findFieldValue(REQ_FIELDS,"Authorization") ){
		AuthInfo ident;
		if( streq(DST_PROTO,"ftp")
		 && HTTP_getAuthorization2(Conn,&ident,1)
		 && is_anonymous(ident.i_user) ){
			Verbose("Authorzation: Do-Cache for %s\n",ident.i_user);
		}else{
		sv1log("Authorization: Dont-Read/Write-Cache ON\n");
		DontReadCache = 1;
		DontWriteCache = 1;
		}
	}
	if( checkCookie(Conn /*,QX,fc,tc*/) < 0 )
		goto EXIT;

	if( (Conn->xf_filters & XF_FTOCL) == 0 ){
	if( sav_FTOCL )
		setFTOCL(sav_FTOCL);
	tc = insertFTOCL_X(Conn,tc);
	ftc[1] = tc;
	setFTOCL(NULL);
	}

	if( IAM_GATEWAY && ClntKeepAlive )
		if( !strcaseeq(DST_PROTO,"nntp")
		 && !strcaseeq(DST_PROTO,"news")
		 && !strcaseeq(DST_PROTO,"pop") )
			clntClose(Conn,"g:gateway for: %s",DST_PROTO);

		/* should do ReadCache if the reason is with Range: filter */
	if( !DontReadCache && streq(QX_proto,"ftp") ){
		if( doFtpCached(Conn,QX,fc,tc) )
			goto EXIT;
	}

	if( GET_CACHE ){
		int tfd;
		/*fclose(tc);*/
		/*
		tc = fopen("/dev/null","w");
		*/
		tfd = open("/dev/null",1); tc = fdopen(tfd,"w");
	}

	if( QX_upath = strchr(REQ,'/') )
		QX_upath = QX_upath + 1;
	else	QX_upath = "?";

	if( IAM_GATEWAY
	 || 512 < (int)strlen(REQ)
	 || without_cache()
	 || strncasecmp(REQ,"GET ",4) != 0 ){
		QX_useCache = 0;
		QX_cpath[0] = 0;
		httpStat = CS_WITHOUTC;
	}else{
		QX_useCache =
		CTX_cache_path(Conn,QX_proto,QX_site,QX_port,QX_upath,AVStr(QX_cpath));
		if( QX_useCache )
			httpStat = CS_NEW;
		else	httpStat = CS_WITHOUTC;
	}
	if( CacheOnly )
		QX_expire = 0x7FFFFFFF;
	else
	if( Conn->co_nonet )
		QX_expire = 0x7FFFFFFF;
	else	QX_expire = http_EXPIRE(Conn,QX_site);

	if( IAM_GATEWAY ){
	}else{
		if( doCache(Conn,QX,fc,tc) )
			goto EXIT;
		if( QX_cachefp == NULL )
			httpStat = CS_WITHOUTC;
		if( !reqRobotsTxt(Conn)  )
			genIfModified(Conn,QX_cachefp,QX_cpath,QX_cdate);
	}
	if( HTTP_reqWithHeader(Conn,REQ) ){
		HTTP_setHost(Conn,AVStr(REQ_FIELDS));
	}
	if( HTTP_methodWithBody(REQ_METHOD) )
		pollRequestBody(Conn,QX,fc,tc);

	if( QX_cachefp != NULL )
		CacheMtime = file_mtime(fileno(QX_cachefp));

	setConnStart(Conn);
if( 0 <= FromS && strcmp(iSERVER_PROTO,"vsap") == 0 )
sv1log("##### HTTP/VSAP: %d/%d\n",ToS,FromS);
else
	FromS = -1;

	Conn->sv_reusing = 0;
	if( FromS < 0 ){
		if( Conn->sv_reusing = getServ(Conn) ) /* FromS is set ... */
			setConnDone(Conn);
	}

CONNECT_RETRY:

	if( FromS < 0 && tryConnects(Conn,QX,fc,tc) < 0 )
	{
		if( Conn->sv_retry == SV_RETRY_DO )
			goto RETRY;
		goto EXIT;
	}

	fs = fdopen(FromS,"r");
	if( fs == NULL ){
		sv1log("##FATAL: fdopen(FromS=%d)=NULL errno=%d\n",FromS,errno);
		if( Conn->sv_reusing ){
			Conn->sv_reusing = 0;
			FromS = -1;
			goto CONNECT_RETRY;
		}else{
			goto EXIT;
		}
	}
	if( ToServ )
		ts = ToServ;
	else{
		ts = fdopen(ToS,"w");
		if( ts == NULL ){
			sv1log("##FATAL: fdopen(ToS=%d) failed\n",ToS);
			goto EXIT;
		}
	}

	if( 0 <= Conn->ca_objsize && ConnType == 'i' ){
		/* response data is got by HIT_OBJ of ICP */
		QX_cpid = 0;
		QX_tsfd = -1;
		QX_fsfd = -1;
	}else{
		const char *cpath = (QX_cachefp == NULL) ? NULL : QX_cpath;
		QX_tsfd = dup(fileno(ts));
		QX_fsfd = dup(fileno(fs));
		QX_cpid = relayRequest(Conn,QX,cpath,QX_cdate,fc,ts,fs);
		if( ferror(ts) || feof(fs) ){
			if( Conn->sv_reusing ){
			sv1log("#### SERVER REUSE: closed after request\n");
				closeServ(Conn,QX,ts,fs);
				goto CONNECT_RETRY;
			}
		}
		if( 0 < BadServ ){
			/* this check should be after EOF check on server reusing */
			goto SVEXIT;
		}

		/* let non-CFI FTOSV filter detect the end of req. message */
		if( Conn->xf_filters & XF_FTOSV ){
			fflush(ts);
			close(QX_tsfd); QX_tsfd = -1;
			close(QX_fsfd); QX_fsfd = -1;
			QX_cpid = 0;
			closeFDs(ts,ts);
		}
	}

	if( DontWriteCache && QX_cachefp != NULL )
		CacheClose(QX);

	if( reqRobotsTxt(Conn) ){
		respFile = TMPFILE("HTTP-Reponse");
		tc_sav = tc;
		tc = respFile;
		chunksav = ClntAccChunk;
		ClntAccChunk = 0;
	}else	respFile = NULL;

	setRelaying(Conn,tc,QX_cachefp,QX_cpath);
	QX_rcode = relay_response(Conn,QX,
			QX_cpid,
			QX_proto,QX_site,QX_port,
			REQ,
			QX_cpath,
			0,fs,tc,fc,
			QX_cachefp,
			QX_cdate != -1);

	if( respFile ){
		ClntAccChunk = chunksav;
		tc = tc_sav;
		fflush(respFile);
		fseek(respFile,0,0);
		if( QX_rcode != R_EMPTY_RESPONSE ){
			if( reqRobotsTxt(Conn) ){
				putRobotsTxt(Conn,tc_sav,respFile,1);
			}
		}
		fclose(respFile);
		respFile = 0;
	}

	if( QX_rcode == R_EMPTY_RESPONSE ){
		if( Conn->sv_reusing ){
			sv1log("#### SERVER REUSE: got empty response\n");
			closeServ(Conn,QX,ts,fs);
			goto CONNECT_RETRY;
		}
	}

	Verbose("relay_response()=%d, cache=%x, httpStat=%c DontTruncate=%d\n",
		QX_rcode,QX_cachefp,httpStat,DontTruncate);

	if( QX_cachefp != NULL )
		doTruncateCache(Conn,QX,fc,tc);

SVEXIT:
	if( 0 <= QX_tsfd ){
		int svkeep;
		if( 0 < BadServ )
			svkeep = 0;
		else
		/*
		if( httpStat == CS_EOF || 0 < fPollIn(fs,1) ){
		*/
		if( httpStat == CS_EOF
		 || feof(fs)
		 || ferror(ts)
		 || 0 < fPollIn(fs,1)
		){
			int ch;
			if( httpStat != CS_EOF )
				ch = getc(fs);
			if( httpStat == CS_EOF || ch == EOF )
				sv1log("#HT11 EOF from the server\n");
			else
 sv1log("#HT11 pending data from the server, httpStat=%c [%X]\n",httpStat,ch);
			svkeep = 0;
		}else
		if( !feof(fs) && !ferror(ts) )
			svkeep = putServ(Conn,QX_tsfd,QX_fsfd);
		else	svkeep = 0;
		if( svkeep == 0 ){
			sv1log("#HT11 close svsokcs[%d,%d]\n",QX_tsfd,QX_fsfd);
			close(QX_tsfd);
			close(QX_fsfd);
			if( Conn->sv_reusing ){
				sv1log("#### SERVER REUSE: got EOF\n");
				delServ(Conn,fileno(ts),fileno(fs));
			}
		}
	}

	/* don't do shutdown() for keep-alive connection to server */
	fclosesTIMEOUT(fs,ts);
	if( QX_cpid )
		wait(0);

	if( Conn->sv_retry == SV_RETRY_DO ){
		goto RETRY;
	}

EXIT:
	if( 0 < BadServ ){
		if( tcCLOSED ){
			/* 8.11.2: tc was closed */
		}else{
		httpStat = CS_BADREQUEST;
		putBadResponse(Conn,tc);
		}
	}

NHEXIT: /* NOTE:
	 * CurEnv might be released already after metamo. to Generalist
	 */

	ToServ = NULL;
	CacheClose(QX); /* unlock and remove AF_UNIX socket */
	if( QX_cpath[0] && File_size(QX_cpath) == 0 ){
		sv1log("unlink empty cache: %s\n",QX_cpath);
		QX_cacheRemove = 1;
	}
	if( QX_cacheRemove )
		CTX_cache_remove(Conn,QX_proto,QX_site,QX_port,QX_cpath);
	setRelaying(NULL,NULL,NULL,NULL);
	Where = 0;
}
extern int DGLEV;
static void service_http2(Connection *Conn,FILE *ftc[2])
{	UTag QXut;

	DGLEV = SB_SERV;
	QXut = UTalloc(SB_CONN,sizeof(QueryContext),8);
	service_http2X(Conn,ftc,(QueryContext*)QXut.ut_addr);
	UTfree(&QXut);
	mem_pops(SB_SERV);
	DGLEV = SB_CONN;
}

static void flushRESP(Connection *Conn,FILE *ftc[2])
{
	fputs(RESP_MSG,ftc[1]);
	if( RESP_MSGFP ){
		fflush(RESP_MSGFP);
		fseek(RESP_MSGFP,0,0);
		copyfile1(RESP_MSGFP,ftc[1]);
		fclose(RESP_MSGFP);
		RESP_MSGFP = NULL;
	}
}

void savReqAuthorization(Connection *Conn,PCStr(head))
{	const char *fvp;
	CStr(up,128);

	if( fvp = findFieldValue(head,"Authorization") ){
		HTTP_decompAuthX(fvp,AVStr(SVREQ_ATYP),sizeof(SVREQ_ATYP),
			AVStr(up),sizeof(up),NULL);
	}
}
static void retryAuth(Connection *Conn,FILE *ftc[2])
{ 	CStr(resauth,1024);
	CStr(ratyp,32);
	const char *dgv;
	const char *rfname;
	const char *qfname;
	const char *fvp;
	MrefQStr(qp,OREQ_MSG); /**/
	refQStr(rp,RESP_MSG);
	CStr(reqauth,URLSZ);
	CStr(qatyp,32);
	const char *nqatyp;
	CStr(user,64);
	CStr(pass,64);
	CStr(up,128);
	AuthInfo seed,qauth;
	CStr(resp_add,256);
	int req_asis = 0;

	if( !RESP_SAV ){
		return;
	}

	/*
	 * hop-by-hop header must be removed from RESP_MSG
	 */
	removeFields(AVStr(RESP_MSG),"Connection",0);
	removeFields(AVStr(RESP_MSG),"Transfer-Encoding",0);

	resp_add[0] = 0;
	if( RespCode == 401 ){
		rfname = "WWW-Authenticate";
		qfname = "Authorization";
	}else
	if( RespCode == 407 ){
		rfname = "Proxy-Authenticate";
		qfname = "Proxy-Authorization";
	}else{
		flushRESP(Conn,ftc);
		return;
	}

	user[0] = 0;
	pass[0] = 0;
	bzero(&qauth,sizeof(AuthInfo));
	if( fvp = findFieldValue(OREQ_MSG,qfname) ){
		HTTP_decompAuthX(fvp,AVStr(qatyp),sizeof(qatyp),AVStr(up),sizeof(up),&qauth);
		if( strcaseeq(qatyp,"Digest") ){
			flushRESP(Conn,ftc);
			return;
		}
	}

	if( getFV(RESP_MSG,rfname,resauth) == NULL ){
		sv1log("retryAuth: NO %s field\n",rfname);
		flushRESP(Conn,ftc);
		return;
	}
	dgv = wordScan(resauth,ratyp);

	if( strcaseeq(ratyp,"Basic")
	 && (HTTP_opts & HTTP_AUTHBASIC_DELAY_SV) ){
		/* Basic was blocked not to send cleartext password
		 * for Digest server */
		if( strcaseeq(qatyp,"Basic") ){
			req_asis = 1;
			nqatyp = "Basic";
			if( getDigestInCookie(AVStr(OREQ_MSG),NULL) )
				resetDigestInCookie(Conn,AVStr(resp_add));
			goto RETRY;
		}
	}
	if( !strcaseeq(ratyp,"Digest") ){
		flushRESP(Conn,ftc);
		return;
	}
	nqatyp = "Digest";

	if( qauth.i_user[0] ){
		wordScan(qauth.i_user,user);
		wordScan(qauth.i_pass,pass);
		removeFields(AVStr(OREQ_MSG),qfname,0);
		OREQ_LEN = strlen(OREQ_MSG);
	}
	bzero(&seed,sizeof(AuthInfo));
	scanDigestParams((char*)dgv,&seed,VStrNULL,0);
	if( strcaseeq(SVREQ_ATYP,"Digest") ){
		if( seed.i_error & AUTH_ESTALE ){
			sv1log("retryAuth: STALE\n");
		}else{
			/* don't retry if new Digest is the same with old ...*/
		}
	}
	setDigestInCookie(Conn,&seed,AVStr(resp_add));

	if( user[0] == 0 ){
		if( (HTTP_opts&HTTP_THRUDIGEST_CL) == 0 )
		if( (HTTP_opts&HTTP_FORCEBASIC_CL) || UAwithoutDigest(Conn) ){
			sprintf(resauth,"Basic realm=\"%s\"",seed.i_realm);
			replaceFieldValue(AVStr(RESP_MSG),rfname,resauth);
		}
		if( resp_add[0] ){
			if( rp = strSeekEOH(RESP_MSG) )
				RFC822_addHeaderField(AVStr(rp),resp_add);
		}
		RESP_LEN = strlen(RESP_MSG);
		flushRESP(Conn,ftc);
		return;
	}

	genAuthDigest(Conn,"Authorization",AVStr(reqauth),sizeof(reqauth),&seed,
		user,pass);
	if( sizeof(OREQ_MSG) <= OREQ_LEN+strlen(reqauth) ){
		sv1log("retryAuth: too large request.\n");
		flushRESP(Conn,ftc);
		return;
	}
	if( qp = strSeekEOH(OREQ_MSG) )
		RFC822_addHeaderField(QVStr(qp,OREQ_MSG),reqauth);
	OREQ_LEN += strlen(reqauth);

RETRY:

	sv1log("retryAuth: client:%s -> server:[%s -> %s]\n",
		qatyp,SVREQ_ATYP[0]?SVREQ_ATYP:"NULL",nqatyp);

	ConnType = 0;
	DDI_pushCbuf(Conn,OREQ_MSG,OREQ_LEN);
	resetHTTPenv(Conn,CurEnv);

	REQ_ASIS = req_asis;
	Xstrcat(AVStr(RESP_ADD),resp_add);
	service_http2(Conn,ftc);

	if( RespCode == 401 || RespCode == 407 ){
		if( resp_add[0] ){
			if( rp = strSeekEOH(RESP_MSG) )
				RFC822_addHeaderField(AVStr(rp),resp_add);
			RESP_LEN = strlen(RESP_MSG);
		}
		flushRESP(Conn,ftc);
	}
}
/*
 * To cope with 305/306 response, current DeleGate implements it like this:
 * Whole request message including message body must be kept for
 * transparent automatic retry by the proxy, and two transactions
 * will occur always.
 * One another way is recording a triple (method,URL,proxy) for each
 * 305/306 response to be looked by succeeding proxy processes to decide
 * their routing.  But, it seems expensive too.
 */
static void proxyRedirect(Connection *Conn,FILE *ftc[2])
{	int redirects;
	CStr(proxy,1024);
	int comask;
	HtResp htResp;

	htResp = CurEnv->r_resp;
	for( redirects = 0; redirects < 4; redirects++ ){
		if( RespCode != 305 && RespCode != 306 )
			break;
		if( getFV(RESP_MSG,"Set-Proxy",proxy) == NULL )
			break;
		if( sizeof(OREQ_MSG) <= OREQ_LEN )
			break; /* incompletely buffered */
		if( strncasecmp(proxy,"DIRECT",5) == 0 ){
			sv1log("#### must be accessed without proxy: %s",OREQ);
			if( ConnType == 'p' || ConnType == 'm' ){
				ConnType = 0;
				DDI_pushCbuf(Conn,OREQ_MSG,OREQ_LEN);
				comask = Conn->co_mask;
				Conn->co_mask = (CONN_NOPROXY | CONN_NOMASTER);
				resetHTTPenv(Conn,CurEnv);
				service_http2(Conn,ftc);
				Conn->co_mask = comask;
				continue;
			}
		}
		break;
	}
	if( RESP_LEN == 0 ) /* redirection might be aborted */
		CurEnv->r_resp = htResp;

	if( RespCode == 305 || RespCode == 306 || ConnType == 0 )
	{
		flushRESP(Conn,ftc);
		/*
		fputs(RESP_MSG,ftc[1]);
		if( RESP_MSGFP ){
			fflush(RESP_MSGFP);
			fseek(RESP_MSGFP,0,0);
			copyfile1(RESP_MSGFP,ftc[1]);
			fclose(RESP_MSGFP);
			RESP_MSGFP = NULL;
		}
		*/
	}

	/*
	 * if Proxy-Authorization is required, retry with it... ?
	 */
}

void service_httpY(Connection *Conn,HTTP_env *httpEnvp);
void service_httpX(Connection *Conn)
{	HTTP_env httpEnv;

	httpEnv.r_resp.r_msg = UTalloc(SB_CONN,1024,1);
	httpEnv.r_i_buff = UTalloc(SB_CONN,URLSZ,1);
	httpEnv.r_o_buff = UTalloc(SB_CONN,OBUFSIZE,1);
	httpEnv.r_savConn = UTalloc(SB_CONN,sizeof(Connection),8);
	httpEnv.r_acclangs = UTalloc(SB_CONN,1024,1);
	httpEnv.r_ohost = UTalloc(SB_CONN,1024,1);

	service_httpY(Conn,&httpEnv);

	UTfree(&httpEnv.r_ohost);
	UTfree(&httpEnv.r_acclangs);
	UTfree(&httpEnv.r_savConn);
	UTfree(&httpEnv.r_o_buff);
	UTfree(&httpEnv.r_i_buff);
	UTfree(&httpEnv.r_resp.r_msg);
}
int timeoutWait(int to);
void WaitShutdown(Connection *Conn,FILE *tc,int force);
void service_httpY(Connection *Conn,HTTP_env *httpEnvp)
{	FILE *fc,*tc;
	FILE *ftc[2];
	vfuncp osigint = NULL;
	vfuncp osigterm = NULL;
	vfuncp osigpipe = NULL;
	int keepAlive,clntKeepAlive,Serno,tm0;
	int nka;
	int timeout,timeout1,timeout2,rtimeout,ptimeout,nready,till;
	const char *FTOCL;
	FTOCL = getFTOCL(Conn);

	if( HTTP_opts & HTTP_NODELAY )
		set_nodelay(ClientSock,1);

	tc = fdopen(ToC,"w");
	if( tc == 0 ){
	http_Log(Conn,500,CS_ERROR,"ERR cannot_fdopen(to_client)",0);
	Exit(-1,"fdopen(ToC=%d) failed\n",ToC);
	}
	tcCLOSED = 0;

	fc = fdopen(FromC,"r");
	if( fc == NULL ){
	http_Log(Conn,500,CS_ERROR,"ERR cannot_fdopen(from_client)",0);
	Exit(-1,"fdopen(FromC=%d) failed\n",FromC);
	}

	ftc[0] = fc;
	ftc[1] = tc;

	/* setbuff tc after for IRIX-5.3 ... ?_? */
	setbuffer(fc,(char*)httpEnvp->r_i_buff.ut_addr,httpEnvp->r_i_buff.ut_size);
	setbuffer(tc,(char*)httpEnvp->r_o_buff.ut_addr,httpEnvp->r_o_buff.ut_size);
	if( HTTP_STARTTLS_withCL(Conn,fc,tc) ){
		syslog_ERROR("**** delayed detection of SSL\n");
	}

	osigint = Vsignal(SIGINT,sigTERM);
	osigterm = Vsignal(SIGTERM,sigTERM);
	osigpipe = Vsignal(SIGPIPE,sigPIPE);

	Conn->sv_dfltsav = Conn->sv_dflt;
	*(Connection*)httpEnvp->r_savConn.ut_addr = *Conn;
	keepAlive = 0;
	clntKeepAlive = 0;
	Serno = 0;
	WhyClosed[0] = 0;

	timeout = (int)HTTP_TOUT_CKA;
	CKA_RemAlive = HTTP_CKA_MAXREQ;

	if( HTTP_opts & HTTP_NOKEEPALIVE ){
		sprintf(WhyClosed,"H:HTTPCONF=bugs:no-keepalive");
		CKA_RemAlive = 0;
	}else
	if( 0 < CKA_RemAlive && Conn->cl_count > HTTP_CKA_PERCLIENT ){
		CStr(clhost,256);
		if( getClientHostPort(Conn,AVStr(clhost)) == 0 )
			strcpy(clhost,"?");
		Verbose("HCKA: too many connections %d/%d for %s\n",
			Conn->cl_count,HTTP_CKA_PERCLIENT,clhost);
		sprintf(WhyClosed,"X:too many Keep-Alive (%s*%d)",clhost,Conn->cl_count);
		CKA_RemAlive = 0;
	}else
	if( 0 < CKA_RemAlive && Conn->cl_count == 1 && 1 < HTTP_CKA_PERCLIENT ){
		timeout = timeout * 10;
		if( timeout < 20 ) timeout = 20;
		if( 60 < timeout ) timeout = 60;
		CKA_RemAlive = CKA_RemAlive * 10;
		if( CKA_RemAlive < 20 ) CKA_RemAlive = 20;
		if( HTTP_CKA_MAXREQ < 60 )
		if( 60 < CKA_RemAlive ) CKA_RemAlive = 60;
	}
	rtimeout = (int)(timeout + HTTP_TOUT_CKA_MARGIN);
	ptimeout = 20;
	if( rtimeout <= ptimeout ){
		timeout1 = rtimeout;
		timeout2 = 0;
	}else{
		timeout1 = ptimeout;
		timeout2 = rtimeout - ptimeout;
	}

	nka = 0;
	do {
		if( keepAlive ){
			/* second or later request in Keep-Alive mode */
			if( DDI_proceedFromC(Conn,fc) < 0 ){
				/* Flush possibly bufferd previous request in
				 * input buff. not read but peeked only.
				 * This must be done before clear_DGref() which
				 * will clear control data of the peeking.
				 */
				clntClose(Conn,"d:by client(request EOF-0)");
				setClientEOF(Conn,fc,"request-EOF-0");
				break;
			}
			clear_DGreq(Conn);
			restoreConn(Conn,(Connection*)httpEnvp->r_savConn.ut_addr);
		}
		setHTTPenv(Conn,httpEnvp);
		sav_FTOCL = FTOCL;
		if( 0 < CKA_RemAlive ){
			setKeepAlive(Conn,timeout);
		}
		if( keepAlive ){
			if( feof(fc) ){
				clntClose(Conn,"d:by client(request EOF-1)");
				setClientEOF(Conn,fc,"request-EOF-1");
				break;
			}
			if( checkClientEOF(Conn,tc,"keep_alive") ){
				clntClose(Conn,"d:by client(request EOF-2)");
				break;
			}

			fflushKeepAlive(Conn,"request-EOF-3",fc,tc,0);
			if( ClientEOF ){
				clntClose(Conn,"d:by client(request EOF-3)");
				break;
			}
			/* if the flush of the response to the client is
			 * postponed here, it must be flushed when
			 * the connection to or the response from
			 * the next server is blocked... (may be in 
			 * service_http2())
			 */

			till = time(0) + timeout;

			tm0 = time(0);
			nready = DDI_PollIn(Conn,fc,timeout1*1000);
			if( nready < 0 ){
				clntClose(Conn,"d:by client(request EOF-4)");
				setClientEOF(Conn,fc,"request-EOF-4");
				break;
			}

			if( nready == 0 && 0 < timeout2 ){
				ProcTitle(Conn,"(HTTP:keep-alive=%02d:%02d)",
					(till%3600)/60,till%60);

				/* close ServPort not to block other clients
				 */
				checkCloseOnTimeout(0);
				LOG_flushall();
				nready = fPollIn(fc,timeout2*1000);
			}

			if( nready < 0 ){
				clntClose(Conn,"d:by client(request EOF-5)");
				setClientEOF(Conn,fc,"request-EOF-5");
				break;
			}
			if( nready == 0 ){
				clntClose(Conn,"t:timeout: %d",time(0)-tm0);
				break;
			}
			if( READYCC(fc) == 0 )
			if( Peek1(fileno(fc)) < 1 ){
				clntClose(Conn,"d:by client(request EOF-6)");
				setClientEOF(Conn,fc,"request-EOF-6");
				break;
			}

			/* close ServPort because this delegated may be
			 * devoted to a single client
			 */
			checkCloseOnTimeout(0);
		}

		strcpy(REQ_METHOD,"?");
		if( keepAlive )
			WhyClosed[0] = '-';
		else
		if( WhyClosed[0] == 0 )
			WhyClosed[0] = '?';
		SentKeepAlive = 0;
		ClntAccChunk = 0;
		setFTOCL(NULL);
		service_http2(Conn,ftc);
		if( ftc[0] == NULL || ftc[1] == NULL )
			break;

		if( RespCode == 305 || RespCode == 306 )
			proxyRedirect(Conn,ftc);
		else
		if( RespCode == 401 || RespCode == 407 )
			retryAuth(Conn,ftc);

		CKA_RemAlive--;
		clntKeepAlive |= ClntKeepAlive;
		RES_CACHE_DISABLE = 0;

		if( tcCLOSED || ClientEOF )
			break;

		if( fflushTIMEOUT(tc) == EOF ){
			clntClose(Conn,"d:by client(request EOF-7)");
			setClientEOF(Conn,fc,"request-EOF-7");
			break;
		}

		if( 0 < CKA_RemAlive ){
			if( !streq(REQ_METHOD,"?") ) /* not empty request */
				Serno = incRequestSerno(Conn);
			if( keepAlive || WillKeepAlive )
				Verbose("HCKA:[%d] KeepAlive: %s %c =>%d\n",
					Serno,REQ_METHOD,httpStat,WillKeepAlive);
		}
		keepAlive = WillKeepAlive && SentKeepAlive;
		if( keepAlive )
			nka++;
	} while( keepAlive && 0 < CKA_RemAlive );
	setHTTPenv(Conn,NULL);

	if( clntKeepAlive && 1 < HTTP_CKA_MAXREQ ){
		if( streq(WhyClosed,"-") && CKA_RemAlive == 0 )
			strcpy(WhyClosed,"Max-KeepAlive");
		http_logplus(Conn,WhyClosed[0]);
		sv1log("HCKA:[%d] closed -- %s\n",RequestSerno,WhyClosed);
	}
	if( HTTP_opts & HTTP_DUMPSTAT )
	fprintf(stderr,"[%d][%2d]%2d %s\n",getpid(),nka,CKA_RemAlive,WhyClosed);

	Where = "closeClient";

	if( ftc[0] == NULL || ftc[1] == NULL ){
		sv1log("fclose() already: fc=%X/%d tc=%X/%d\n",
			fc,ftc[0],tc,ftc[1]);
	}else
	if( tcCLOSED )
		fclose(fc);
	else{
		if( ftc[1] != 0 && ftc[1] != tc ) /* with on-demand FTOCL */
		{
			fclose(ftc[1]);
			timeoutWait(100);
		}

		if( checkClientEOF(Conn,tc,NULL) ){
			int fd = fileno(tc);
			close(fd);
			Verbose("## [%d] don't flush to cause SIGPIPE\n",fd);
		}else{
			if( 0 < DELEGATE_LINGER )
				set_linger(fileno(tc),DELEGATE_LINGER);
		}
		/*
		fshutdown(tc,0);
		*/
		WaitShutdown(Conn,tc,0);
		fclosesTIMEOUT(tc,fc); /* close tc first */
	}
	Vsignal(SIGPIPE,osigpipe);
	Vsignal(SIGTERM,osigterm);
	Vsignal(SIGINT,osigint);

	setFTOCL(FTOCL);
}

#undef fshutdown
/*
 * Wait child processes before doing shutdown() the client side connection.
 * Client side filter process might not have been finished (not wait()ed)
 * at this point because of bugs.  An existed example of the problem:
 *  1) FSV process for FTP by FTP/HTTP-gw. finishes
 *  2) wait(0) for respFilter -> detects the exit of FSV instead of respFilter
 *  3) FILE *tc points not to filter but to original ClientSock in this case,
 *     thus fshutdown(tc) of the connection truncated the response data.
 */
int NumBits(int i32);
#define nbits NumBits
void WaitShutdown(Connection *Conn,FILE *tc,int force)
{	int x,xpid,nproc,xproc;

	nproc = nbits(Conn->xf_filters & ~XF_CLIENT)
	      + nbits(Conn->xf_clprocs)
	      + nbits(Conn->fi_builtin);

	if( nproc ){
	    xproc = 0;
	    if( ServKeepAlive && (Conn->xf_filters & XF_SERVER) )
		nproc--;

	    for( x = 0; x < 10; x++ ){
		xpid = NoHangWait();
		syslog_DEBUG("WaitShutdown %d/%d[bi=%X xf=0x%X cl=0x%X] = %d\n",
			xproc,nproc,
			Conn->fi_builtin,Conn->xf_filters,Conn->xf_clprocs,
			xpid);
		if( xpid < 0 )
			break;
		if( 0 < xpid )
			++xproc;
		if( nproc <= xproc )
			break;
		msleep(10);
	    }
	}
	fshutdown(tc,force);
}
int timeoutWait(int to)
{	int i,tot,to1,pid;

	to1 = 0;
	pid = 0;
	for( tot = 0; tot < to; tot += to1 ){
		pid = NoHangWait();
		if( pid != 0 )
			break;
		to1 += 1;
		msleep(to1);
	}
	return pid;
}
