/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994-1999 Yutaka Sato
Copyright (c) 1994-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	misc.c (miscellaneous functions)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	March94	creatd
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include <stdlib.h>
#include "ystring.h"
#include "dglib.h"
#include "fpoll.h"
#include "yarg.h"
#include "file.h"

/*
 * fclose(FILE *fp) without closing fileno(FILE *fp)
 */
int fcloseFILE(FILE *fp)
{	int fd,fdsav;

	fd = fileno(fp);
	fdsav = dup(fd);
	fclose(fp);
	close(fd); /* do closesocket() on Win32 */
	dup2(fdsav,fd);
	close(fdsav);
	return fd;
}

/*
 * close(fileno(FILE *fp)) without closing FILE *fp
 */
void closeFDs(FILE *ifp,FILE *ofp)
{	int xfd,ofd,ifd;

	xfd = dup(fileno(NULLFP()));
	ofd = -1;
	if( ofp != NULL ){
		ofd = fileno(ofp);
		close(ofd);
		dup2(xfd,ofd);
	}
	ifd = -1;
	if( ifp != NULL && fileno(ifp) != ofd ){
		ifd = fileno(ifp);
		close(ifd);
		dup2(xfd,ifd);
	}
	sv1vlog("###### closeFDs(%d/%X,%d/%X) %d\n",
		ifd,ifp,ofd,ofp,xfd);
	close(xfd);
}

int copy_file(FILE *sfp,FILE *dfp,FILE *cfp)
{	int rcc;
	CStr(buff,1023);
	int totalc;

	totalc = 0;
	for(;;){
		rcc = fread(buff,1,sizeof(buff),sfp);
		if( rcc == 0 )
			break;
		totalc += rcc;
		if( cfp ){ if(fwrite(buff,1,rcc,cfp)==0) break; }
		if( dfp ){ if(fwrite(buff,1,rcc,dfp)==0) break; }
		if( dfp && ready_cc(sfp) == 0 )
			if( fflushTIMEOUT(dfp) == EOF )
				break;
	}
	if( dfp ) fflush(dfp);
	if( cfp ) fflush(cfp);
	return totalc;
}
int copy_fileTIMEOUT(FILE *sfp,FILE *dfp,FILE *cfp)
{	int rcc;
	CStr(buff,1024);
	int totalc;

	totalc = 0;
	for(;;){
		if( feof(sfp) )
			break;
		rcc = freadTIMEOUT(AVStr(buff),1,sizeof(buff),sfp);
		if( rcc == 0 )
			break;
		totalc += rcc;
		if( dfp ){ if(fwriteTIMEOUT(buff,1,rcc,dfp)==0) break; }
		if( dfp ){ if(fflushTIMEOUT(dfp) == EOF) break; }
		if( cfp ){ if(fwriteTIMEOUT(buff,1,rcc,cfp)==0) break; }
	}
	if( dfp ) fflushTIMEOUT(dfp);
	if( cfp ) fflushTIMEOUT(cfp);
	return totalc;
}

int Fprintf(FILE *fp,PCStr(fmt),...)
{	CStr(buf,0x10000);
	VARGS(14,fmt);

	sprintf(buf,fmt,va[0],va[1],va[2],va[3],va[4],va[5],va[6],va[7],va[8],va[9],va[10],va[11],va[12],va[13]);
	fputs(buf,fp);
	return strlen(buf);
}

static int cmpstr(char **s1p,char **s2p)
{
	return strcmp(*s1p,*s2p);
}
static int cmpstr_reverse(char **s1p,char **s2p)
{
	return strcmp(*s2p,*s1p);
}

void sort_file(FILE *src,FILE *dst,int rev)
{	FILE *tmp;
	CStr(line,4096);
	const char *lines[0x10000]; /**/
	int nlines,li;

	if( src == dst )
		tmp = dst = TMPFILE("SORT");
	else	tmp = NULL;

	fseek(src,0,0);
	for( nlines = 0; fgets(line,sizeof(line),src); nlines++ ){
		if( elnumof(lines) <= nlines ){
			break;
		}
		lines[nlines] = stralloc(line);
	}

	if( rev )
		qsort(lines,nlines,sizeof(char*),(sortFunc)cmpstr_reverse);
	else	qsort(lines,nlines,sizeof(char*),(sortFunc)cmpstr);

	fseek(dst,0,0);
	for( li = 0; li < nlines; li++ ){
		fputs(lines[li],dst);
		free((char*)lines[li]);
	}
	fflush(dst);

	if( tmp != NULL ){
		fseek(src,0,0);
		fseek(tmp,0,0);
		copy_file(tmp,src,NULL);
		fclose(tmp);
		fflush(src);
	}
}

void doXECHO(FILE *tc,PCStr(msg))
{	const char *ip;
	char *op = (char*)msg; /**/

	for( ip = msg; *ip; ip++ ){
		if( *ip == '\\' ){
			switch( ip[1] ){
				case 'r': *op++ = '\r'; ip++; continue;
				case 'n': *op++ = '\n'; ip++; continue;
			}
		}
		if( op != ip )
			*op++ = *ip;
		else	op++;
	}
	if( *op != 0 ) *op = 0;
	fputs(msg,tc);
}
