/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1999 Yutaka Sato
Copyright (c) 1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	loadstat.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	991206	created
ToDo:
	- describe the total format of ps-title
	- display the server in keep-alive if exist
	- common symbol which indicates process status (Polling, *Running, ...)
//////////////////////////////////////////////////////////////////////#*/
#include "ystring.h"
#include "file.h"
#include <stdio.h>
int Lseek(int fd,int off,int wh);
int clearCloseOnExec(int fd);

#define ST_ACC	0
#define ST_DONE	1

const char *mainProcTitleFmt = "RPM=%L(%l)%?i[,IDLE=%is]%?c[,ACT=%c]";
const char *loadaveFmt = "%l";

int NUM_CHILDREN;
int NUM_PEERS;
int alive_peers(){ return NUM_PEERS; }
int TOTAL_SERVED;
int START_TIME1;
int START_TIME;
int DELEGATE_LastModified;

/*
 * long range counter by hour, day, week, ...
 * and possibly dumped into persistent file and reload on restart...
 */


#define LSWIN	15	/* 1/4 minute */
#define LSSIZE	60	/* 15 minutes */
typedef struct {
	int	s_time;
	int	s_qmin; /* 1/4 minute */
	int	s_done;
} LoadStat;

typedef struct {
	int	le_TotalCount[2];
	int	le_TotalLast[2];
    LoadStat	le_loadStats[2][LSSIZE];
	MStr(	le_Stime,64);
	FILE   *le_loadStatFp;
} LoadStatEnv;
static LoadStatEnv *loadStatEnv;
#define loadStats	loadStatEnv->le_loadStats
#define TotalCount	loadStatEnv->le_TotalCount
#define TotalLast	loadStatEnv->le_TotalLast
#define Stime		loadStatEnv->le_Stime
/**/
#define loadStatFp	loadStatEnv->le_loadStatFp

void minit_loadstat()
{
	if( loadStatEnv == 0 )
		loadStatEnv = NewStruct(LoadStatEnv);
}
int put_svstat()
{	int fd,wcc;

	minit_loadstat();
	if( loadStatFp == NULL ){
		loadStatFp = TMPFILE("LoadStat");
		fd = fileno(loadStatFp);
		clearCloseOnExec(fd);
	}
	if( loadStatFp && 0 <= (fd = fileno(loadStatFp)) ){
		Lseek(fd,0,0);
		wcc = write(fd,loadStatEnv,sizeof(LoadStatEnv));
		return fd;
	}
	return -1;
}
void get_svstat(int fd)
{	int rcc;

	if( fd < 0 ){
		return;
	}
	minit_loadstat();
	Lseek(fd,0,0);
	rcc = read(fd,loadStatEnv,sizeof(LoadStatEnv));
}

void putLoadStat(int what,int done)
{	int now,qmin,idx;
	LoadStat *lsp;

	now = time(NULL);
	qmin = now / LSWIN;
	idx = qmin % LSSIZE;
	lsp = &loadStats[what][idx];
	if( lsp->s_qmin != qmin ){
		lsp->s_time = now;
		lsp->s_qmin = qmin;
		lsp->s_done = 0;
	}
	lsp->s_done += done; 
	TotalCount[what] += done;
	TotalLast[what] = now;
}
double getLoadStat(int what,int now,int mrange)
{	int qmin,qmin0,idx,cur;
	LoadStat *lsp;
	double cum,elp;

	qmin = now / LSWIN;
	qmin0 = qmin - mrange*(60/LSWIN);
	cum = 0;
	cur = 0;
	for( idx = 0; idx < LSSIZE; idx++ ){
		lsp = &loadStats[what][idx];
		if( lsp->s_qmin == qmin ){
			elp = now - lsp->s_time;
			if( elp <= 0 )
				elp = 1;
			cum += lsp->s_done * (LSWIN/elp);
		}else
		if( qmin0 < lsp->s_qmin && lsp->s_qmin < qmin )
			cum += lsp->s_done;
	}
	return cum;
}
char *strfLoadStat(PVStr(str),int size,PCStr(fmt),int now)
{	const char *fp;
	char fc;
	refQStr(sp,str); /**/
	const char *sx;
	refQStr(pp,str); /**/
	const char *tp;
	CStr(subfmt,256);
	double load;
	int cond;
	int last,idle,elp,done;
	double loadv[4]; /**/

	sx = str + size - 1;
	cpyQStr(sp,str);
	fp = fmt;
	while( fc = *fp++ ){
		if( sx <= sp )
			break;

		if( fc != '%' ){
			setVStrPtrInc(sp,fc);
			setVStrEnd(sp,0);
			continue;
		}
		cond = 0;
		for(;;){
			switch( fc = *fp++ ){
				case 0: goto EXIT;
				case '?': cond = 1; continue;
			}
			break;
		}

		cpyQStr(pp,sp);
		switch( fc ){
			case '%':
				setVStrPtrInc(sp,fc);
				setVStrEnd(sp,0);
				break;
			case 'i':
				last = TotalLast[ST_ACC];
				if( last == 0 )
					last = START_TIME;
				idle = now - last;
				if( 1 < idle )
					sp = Sprintf(AVStr(sp),"%d",idle);
				break;
			case 'c':
				if( 0 < NUM_CHILDREN )
					sp = Sprintf(AVStr(sp),"%d",NUM_CHILDREN);
				break;
			case 'l':
				loadv[0] = getLoadStat(ST_ACC,now,1);
				loadv[1] = getLoadStat(ST_ACC,now,5) / 5;
				loadv[2] = getLoadStat(ST_ACC,now,15) / 15;
				sp = Sprintf(AVStr(sp),"%3.1f %3.1f %3.1f",
					loadv[0],loadv[1],loadv[2]);
				break;
			case 'L':
				elp = now - START_TIME;
				done = TotalCount[ST_ACC];
				if( elp <= 0 )
					elp = 1;
				loadv[0] = done / (elp/60.0);
				sp = Sprintf(AVStr(sp),"%4.2f",loadv[0]);
				break;
		}
		if( cond ){
			fc = *fp++;
			if( fc == 0 )
				break;
			if( fc = '[' ){
				if( tp = strchr(fp,']') ){
					Bcopy(fp,subfmt,tp-fp);
					subfmt[tp-fp] = 0;
					fp = tp + 1;
				}else	break;
			}else{
				subfmt[0] = *fp++;
				subfmt[1] = 0;
			}
			if( pp < sp )
				sp = strfLoadStat(QVStr(pp,str),size-(sp-str),subfmt,now);
		}
	}
EXIT:
	return (char*)sp;
}

const char *start_time()
{
	if( Stime[0] == 0 )
		StrftimeLocal(AVStr(Stime),sizeof(Stime),TIMEFORM_HTTPD,START_TIME,0);
	return Stime;
}
