/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994-2000 Yutaka Sato and ETL,AIST,MITI
Copyright (c) 2001-2004 National Institute of Advanced Industrial Science and Technology (AIST)

Permission to use this material for evaluation, copy this material for
your own use, and distribute the copies via publically accessible on-line
media, without fee, is hereby granted provided that the above copyright
notice and this permission notice appear in all copies.
AIST MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	delegated (DeleGate Server)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	940303	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdlib.h>
#include <errno.h>
#include <stdio.h>
#include "ystring.h"
#include "hostlist.h"
#include "config.h"
#include "vsignal.h"
#include "yselect.h"
#include "credhy.h"
#include "fpoll.h"
#include "file.h"
#include "proc.h"
#include "delegate.h"
#include "param.h"
#include "auth.h"
#include <fcntl.h>

int create_service(int ac,const char *av[],PCStr(port));
int delete_service(int ac,const char *av[],PCStr(port),PCStr(arg));
int restart_service(PCStr(port),int ac,const char *av[]);
int setDGROOT();
int xrealpath(PCStr(path),PVStr(rpath),int size);

char *STACK_BASE;
char *STACK_PEAK;
unsigned int STACK_SIZE;

#define SIGHUPTERM	(0 < SIGHUP ? SIGHUP : SIGTERM)
extern int RAND_TRACE;
DeleGateEnv *deleGateEnv;

extern char DGAUTHpro[];
extern char DGAUTHdom[];
int DGLEV = SB_PROC;

int SERNO();
int SERNO_MINOR();
extern int CHILD_SERNO;
extern int CHILD_SERNO_MULTI;
extern int CHILD_SERNO_SINGLE;

extern int SERVER_RESTART;
extern int SERVER_TIMEOUT;
extern int VSAP_TIMEOUT;
extern int TOTAL_SERVED;
extern int NUM_CHILDREN;
extern int NUM_PEERS;
extern int START_TIME;
extern int PEEK_CLIENT_REQUEST;
extern int RES_localdns;
extern int RESOLV_UNKNOWN;
extern int SCRIPT_UNKNOWN;
extern int ERROR_RESTART;

typedef struct {
	short	p_stat;
	short	p_pid;	/* process id on Unix, process handle on Win32 */
	int	p_xid;	/* zero on Unix, process id on Win32 */
} Proc;

typedef struct {
	int	me_NUM_HUPS;
	int	me_ServerPID;
	int	me_myPrivateMASTER;
	int	me_MASTERisPrivate;
	int	me_IamPrivateMASTER;
	int	me_restartPrivateMASTER;
	int	me_IamCGI;

	int	me_TeleportPID;
	MStr(	me_PrivateMasterOwnerPort,64);
  const	char   *me_workFiles[16]; /**/
	int	me_workFileX;
	jmp_buf me_exec_env;
	int	me_idle_timer;

	int	me_inINITIALIZATION;
	int	me_INTERRUPT_STICKY;
	int	me_StickyMAX_PARA;/* max. parallel Stickies */
	int	me_StickyMAX_LIFE;/* max. services by a Sticky */
	int	me_StickyTIMEOUT; /* standby seconds. (users' click interval) */
	int	me_StickyTIMEOUT1;
	/*
	int    *me_StickyProcs;
	*/
	Proc   *me_StickyProcs;
	int	me_StickyActive;
	int	me_StickyReport[2];
	int	me_StickyLastAccept;
	int	me_StickyNaccepted;
	int	me_StickyNserved;
	int	me_StickyDone;
	int	me_ACC_BYMAIN_INTERVAL; /* retry after blocked by Stickies */
	int	me_ACC_REJECTED;
	int	me_MainLastAccept;
	int	me_MainNaccepted;
	int	me_MainNserved;
  const	char   *me_originWD;

	/*
	int	me_MAX_SERVICE;
	*/
	int	me_gotSIGTERM;
	int	me_terminating;
	int	me_doSIGCHLDpid;
	int	me_numSIGCHLD;
	int	me_LOG_type_got;
	int	me_include_next;
	int	me_dont_check_param;
    Connection *me_mainConn;
	int	me_CLsock;
  const	char   *me_execSPECIAL;
	defQStr(me_Serverurl0);
  const	char   *me_servermount_proto;
	int	me_mount_done;
  const	char  **me_direnv_environ;
	int	me_scannedGlobal;
	int	me_scanDirDefsX;
	defQStr(me_hostid_PATH);
	int	me_IDLE_TIMEOUT;
  const	char   *me_ABMwhere;
	Efd    *me_clientSocks;
	int	me_ACC_NONE_TIMEOUT;
	int	me_lockedoutN;
	int	me_lockedoutT;
	int	me_lastserveN;
	int	me_lastdoneN;
	int	me_Ntimeout;
  const	char   *me__workdir;
	int	me_init_HOSTS;

  const	char	*me_PrivateMasterOwner;
  const	char	*me_DeleGate1;
  const	char	*me_FuncFunc;
	int	 me_isFuncFunc;
  const	char	*me_FuncSTICKY;
  const	char	*me_FuncFILTER;
	int	 me_Fopt;	/* arg[Fopt] == "-F..." */
	int	 me_isFunc;

	int	 me_restart;
	/*
	int	 me_maxerestart;
	*/
	MStr(	 me_src_socks,128);
	int	 me_ekeyFd;
	int	 me_deleGateId;
	int	 me_privateDGAuth;
	MStr(	 me_curCHROOT,128);

} MainEnv;

static MainEnv *mainEnv;
#define ME mainEnv[0]
#define NUM_HUPS	ME.me_NUM_HUPS
/*
#define MAX_ERESTART	ME.me_maxerestart
*/
#define ServerPID	ME.me_ServerPID
#define myPrivateMASTER	ME.me_myPrivateMASTER
#define MASTERisPrivate	ME.me_MASTERisPrivate
#define IamPrivateMASTER	ME.me_IamPrivateMASTER
#define restartPrivateMASTER	ME.me_restartPrivateMASTER
#define IamCGI		ME.me_IamCGI

#define TeleportPID	ME.me_TeleportPID
#define PrivateMasterOwnerPort	ME.me_PrivateMasterOwnerPort
/**/
#define workFiles	ME.me_workFiles
#define workFileX	ME.me_workFileX
#define exec_env	ME.me_exec_env
#define idle_timer	ME.me_idle_timer

#define inINITIALIZATION	ME.me_inINITIALIZATION
#define INTERRUPT_STICKY	ME.me_INTERRUPT_STICKY
#define StickyMAX_PARA	ME.me_StickyMAX_PARA
#define StickyMAX_LIFE	ME.me_StickyMAX_LIFE
#define StickyTIMEOUT	ME.me_StickyTIMEOUT
#define StickyTIMEOUT1	ME.me_StickyTIMEOUT1
#define StickyProcs	ME.me_StickyProcs
#define StickyActive	ME.me_StickyActive
#define StickyReport	ME.me_StickyReport
#define StickyLastAccept	ME.me_StickyLastAccept
#define StickyNaccepted	ME.me_StickyNaccepted
#define StickyNserved	ME.me_StickyNserved
#define StickyDone	ME.me_StickyDone
#define ACC_BYMAIN_INTERVAL	ME.me_ACC_BYMAIN_INTERVAL
#define ACC_REJECTED	ME.me_ACC_REJECTED
#define MainLastAccept	ME.me_MainLastAccept
#define MainNaccepted	ME.me_MainNaccepted
#define MainNserved	ME.me_MainNserved
#define originWD	ME.me_originWD

/*
#define MAX_SERVICE	ME.me_MAX_SERVICE
*/
#define gotSIGTERM	ME.me_gotSIGTERM
#define terminating	ME.me_terminating
#define doSIGCHLDpid	ME.me_doSIGCHLDpid
#define numSIGCHLD	ME.me_numSIGCHLD
#define LOG_type_got	ME.me_LOG_type_got
#define include_next	ME.me_include_next
#define dont_check_param	ME.me_dont_check_param
#define mainConn	ME.me_mainConn
#define CLsock		ME.me_CLsock
#define execSPECIAL	ME.me_execSPECIAL
#define Serverurl0	ME.me_Serverurl0
/**/
#define servermount_proto	ME.me_servermount_proto
#define mount_done	ME.me_mount_done
#define direnv_environ	ME.me_direnv_environ
#define scannedGlobal	ME.me_scannedGlobal
#define scanDirDefsX	ME.me_scanDirDefsX
#define hostid_PATH	ME.me_hostid_PATH
/**/
#define IDLE_TIMEOUT	ME.me_IDLE_TIMEOUT
#define ABMwhere	ME.me_ABMwhere
#define clientSocks	ME.me_clientSocks
#define ACC_NONE_TIMEOUT	ME.me_ACC_NONE_TIMEOUT
#define lockedoutN	ME.me_lockedoutN
#define lockedoutT	ME.me_lockedoutT
#define lastserveN	ME.me_lastserveN
#define lastdoneN	ME.me_lastdoneN
#define Ntimeout	ME.me_Ntimeout
#define _workdir	ME.me__workdir
#define init_HOSTS	ME.me_init_HOSTS

#define PrivateMasterOwner	ME.me_PrivateMasterOwner
#define DeleGate1	ME.me_DeleGate1
#define FuncFunc	ME.me_FuncFunc
#define isFuncFunc	ME.me_isFuncFunc
#define FuncSTICKY	ME.me_FuncSTICKY
#define FuncFILTER	ME.me_FuncFILTER
#define Fopt		ME.me_Fopt
#define isFunc		ME.me_isFunc
#define ekeyFd		ME.me_ekeyFd
#define deleGateId	ME.me_deleGateId
#define privateDGAuth	ME.me_privateDGAuth
#define curCHROOT	ME.me_curCHROOT

int MAX_ERESTART = 1;
int MAX_SERVICE;
void minit_main()
{
	if( mainEnv == 0 ){
		mainEnv = NewStruct(MainEnv);

		ACC_BYMAIN_INTERVAL = 200;
		ACC_NONE_TIMEOUT = 60;
		IDLE_TIMEOUT = 10*60;
		StickyTIMEOUT1 = 10;
		/*
		MAX_ERESTART = 1;
		*/

		CLsock = -1;
		StickyReport[0] = StickyReport[1] = -1;

		ABMwhere = "";
		PrivateMasterOwner = "(private-MASTER for ";
		DeleGate1	= "DeleGate";
		FuncFunc	= "(Function)";
		FuncSTICKY	= "(Sticky)";
		FuncFILTER	= "(Filter)";

		deleGateEnv = NewStruct(DeleGateEnv);
		clientSocks = NewStruct(Efd);
		ekeyFd = -1;
	}
}

extern int STANDBY_MAX;
extern int STANDBY_TIMEOUT;
extern int FDSET_MAX;
extern int BREAK_STICKY;

extern int DELEGATE_PAUSE;

#define ST_ACC	0
#define ST_DONE	1

extern int   LOG_sockio[2];
extern int   LOG_sock_enable;
extern const char *DELEGATE_LOGCENTER;
extern int   LOG_center;
extern const char *DELEGATE_ERRORLOG;
extern const char *DELEGATE_TRACELOG;
extern int   MAX_DELEGATE;
extern int   DELEGATE_LastModified;

extern char **environ;
extern int  main_argc;
extern const char **main_argv;
extern int  param_file;

#define getEnv(name)		DELEGATE_getEnv(name)
#define scanEnv(Conn,name,func)	DELEGATE_scanEnv(Conn,name,func)
#define pushEnv(name,value)	DELEGATE_pushEnv(name,value)

#define cronExit	DELEGATE_cronExit
#define sched_execute	DELEGATE_sched_execute
#define sched_action	DELEGATE_sched_action
int DELEGATE_cronExit(int pid);
void DELEGATE_sched_action(Connection *Conn,PCStr(action));

void compatV5info(PCStr(fmt),...)
{	CStr(msg,1024);
	VARGS(8,fmt);

	sprintf(msg,fmt,VA8);
	Verbose("##DeleGate/6.X: %s will make it compatible with former versions.\n",
		msg);
}

int serverPid(){ return ServerPID ? ServerPID : getpid(); }
int iamServer(){ return getpid() == ServerPID; }

static void setLastModified()
{	FILE *tmp,*fp;
	const char *form;
	int modified;

	tmp = TMPFILE("setLastModified");
	DELEGATE_dumpEnv(tmp,0,IamPrivateMASTER);
	fflush(tmp);
	fseek(tmp,0,0);

	modified = 1;
	form = DELEGATE_PARAMFILE;
	if( fp = LOG_openLogFile(form,"r") ){
		if( fcompare(tmp,fp) == 0 ){
			modified = 0;
			DELEGATE_LastModified = file_mtime(fileno(fp));
		}
		fclose(fp);
	}
	if( modified ){
		DELEGATE_LastModified = time(0);
		if( fp = LOG_openLogFile(form,"w") ){
			copy_file(tmp,fp,NULL);
			fclose(fp);
		}
	}
	fclose(tmp);
	sv0log("DELEGATE_Modified[%d]: %x\n",modified,DELEGATE_LastModified);
}

void SetStopService(PCStr(reason));
void childStopService(PCStr(where),int sig,int pid)
{	CStr(reason,256);

	switch( sig ){
		case SIGSEGV:
		case SIGBUS:
		case SIGILL:
			sprintf(reason,"[%s SIG%d in child %d]",where,sig,pid);
			SetStopService(reason);
			break;
	}
}
int checkChildAbort1(PCStr(where))
{	int pid,sig;

	pid = NoHangWaitX(&sig);
	if( pid <= 0 )
		return pid;
	if( sig ){
		sv0log("ChildAbort[%s] PID=%d SIG=%d\n",where,pid,sig);
		childStopService(where,sig,pid);
	}
	return pid;
}
void checkChildAbort(PCStr(where))
{	int pid;

	for(;;){
		if( (pid = checkChildAbort1(where)) <= 0 )
			break;
	}
}
static void sigPIPE(int sig){
	sv0log("abort: caught SIGPIPE\n");
	checkChildAbort("sigPIPE");
	Finish(-1);
}
static void sigURG(int sig){
	sv0log("abort: caught SIGURG\n");
	Finish(-1);
}

void deleteWORKDIR();
int ClientCountDown();
int ClientCountUp(PCStr(user),PCStr(host),PCStr(addr),int port);

void exitFATAL(int sig);
void DELEGATE_sigFATAL(int sig){
	CStr(cwd,1024);
	signal(sig,SIG_IGN);
	daemonlog("F","E-A: ABORT: caught SIG%s [%d]\n",sigsym(sig),sig);
	ClientCountDown();
/* this AbortLog() will flush the logfile which should be used in abort() */
	AbortLog();
	getcwd(cwd,sizeof(cwd));
	daemonlog("F","E-A: core will be at %s\n",cwd);
	abort();
}
#define sigFATAL DELEGATE_sigFATAL

int cleanup_zombis(int log);
static void sigTERM(int sig)
{
	dumpCKey(0);
	gotSIGTERM = sig;
	signal(SIGTERM,SIG_IGN);
	sv0log("DeleGate SERVER EXITS: caught SIG%s [%d]\n",sigsym(sig),sig);
	if( getpid() != ServerPID ){
		fprintf(stderr,"\nDeleGate[%d] got SIGTERM(%d) for server=%d\n",
			getpid(),sig,ServerPID);
		Finish(-1);
		_exit(-1);
	}
	closeServPorts();
	Killpg(getpid(),SIGTERM);
	signal(SIGTERM,SIG_DFL);

	cleanup_zombis(0);
	if( NUM_CHILDREN )
		sv0log("Left children: %d\n",NUM_CHILDREN);

	notify_ADMIN(NULL,"stop");

	deleteWORKDIR();
	LOG_deletePortFile();

	sv0log("FINISH.\n");
	Finish(0);
	fprintf(stderr,"*** exit() on SIGTERM(%d) failed.1\n",sig);
	_exit(0);
}
static void sigTERM1(int sig)
{
	Finish(0);
	fprintf(stderr,"*** exit() on SIGTERM(%d) failed.2\n",sig);
	_exit(0);
}


typedef struct {
	short	s_stat;
	short	s_done;
	int	s_pid;
} SReport;
#define SR_STICKY	1
#define SR_ACCEPT	2
#define SR_DETACH	4
#define SR_FINISH	8

extern int LastCpid;
void putLoadStat(int what,int done);
static void StickyAdd(int pid)
{
	/*
	StickyProcs[StickyActive++] = pid;
	*/
	StickyProcs[StickyActive].p_stat = SR_STICKY;
	StickyProcs[StickyActive].p_xid = LastCpid;
	StickyProcs[StickyActive++].p_pid = pid;
}
static void getStickyReports()
{	unsigned char nserv;
	SReport SR;
	int rcc;

	/*
	while( readTimeoutBlocked(StickyReport[0],&nserv,1,1) == 1 ){
	*/
	for(;;){
		rcc = readTimeoutBlocked(StickyReport[0],GVStr(&SR),sizeof(SR),1);
		if( rcc != sizeof(SR) ){
			break;
		}
		nserv = SR.s_done;

		if( nserv == 0 ){
			StickyNaccepted += 1;
			putLoadStat(ST_ACC,1);
			StickyLastAccept = time(NULL);
			Verbose("## getStickyReport: GOT ACCEPT REPORT #%d (+%d)\n",
				StickyNaccepted,MainNaccepted);
		}else{
			StickyNserved += nserv;
			putLoadStat(ST_DONE,nserv);
		}
		if( SR.s_stat & SR_DETACH ){
			int si;
			for( si = 0; si < StickyActive; si++ ){
				if( StickyProcs[si].p_pid == SR.s_pid
				 || StickyProcs[si].p_xid == SR.s_pid ){
					StickyProcs[si].p_stat = SR_DETACH;
				}
			}
		}
	}
}
static void StickyDel(int pid)
{	int si;

	for( si = 0; si < StickyActive; si++ ){
		/*
		if( StickyProcs[si] == pid ){
		}*/
		if( StickyProcs[si].p_pid == pid ){
			for(; si < StickyActive; si++)
				StickyProcs[si] = StickyProcs[si+1];
			StickyActive--;
			StickyDone++;
			break;
		}
	}
	getStickyReports();
}
static int StickyKill(int sig)
{	int si,pid,rcode;
	int nkill;

	nkill = 0;
	for( si = 0; si < StickyActive; si++ ){
		if( StickyProcs[si].p_stat & SR_DETACH )
			continue; 
		/*
		pid = StickyProcs[si];
		*/
		pid = StickyProcs[si].p_pid;
		rcode = Kill(pid,sig);
		if( rcode == 0 )
			nkill++;
	}
	sv1log("StickyKill(%d): %d/%d killed\n",sig,nkill,StickyActive);
	return nkill;
}

int kill_CC();
int num_CC();
void set_CC();
void del_CC(int pid,PCStr(how));

static void dec_nproc(int pid)
{
	if( pid == myPrivateMASTER ){
		myPrivateMASTER = 0;
		sv1log("#### privateMASTER[%d] dead\n",pid);
		if( getpid() == ServerPID )
			restartPrivateMASTER = 1;
		else	BREAK_STICKY = 1;
	} else
	if( pid == TeleportPID ){
		sv1log("Teleport Closed.\n");
		sigTERM(SIGTERM);
	}else
	if( cronExit(pid) ){
	}else{
		StickyDel(pid);
		del_CC(pid,"byWait");
		if( 0 < NUM_CHILDREN )
			NUM_CHILDREN--;
		else{
			sv1log("previous server's child ? %d\n",pid);
			TraceLog("grand child ? %d\n",pid);
		}
		Verbose("(%d) process [%d] dead\n",NUM_CHILDREN,pid);
	}
}

extern int doTracePid;
extern iFUNCP doTraceLog;
vfuncp signalRESTART(int sig,vfuncp func);

static void sigCHLD(int sig)
{
	if( getpid() != doSIGCHLDpid ){
		TraceLog("#### received unexpected SIGCHLD (1)\n");
		signal(SIGCHLD,SIG_DFL);
		return;
	}
	if( lSIGCHLD() == 0 ){
		TraceLog("#### received unexpected SIGCHLD (2)\n");
		signal(SIGCHLD,SIG_DFL);
		return;
	}
	++numSIGCHLD;
	if( lTRVERB() )
		TraceLog("SIGCHLD*%d\n",numSIGCHLD);
	cleanup_zombis(0);
	signalRESTART(SIGCHLD,sigCHLD);
}
void setWatchChild()
{	int size;

	if( lTRACE() ){
		doTracePid = getpid();
		doTraceLog = (iFUNCP)TraceLog;
		/*
		 * expand fdset for OS like Slaris which read child process's
		 * status via file like "/proc/*"
		 */
		size = expand_fdset(FDSET_MAX+MAX_DELEGATE*3);
		TraceLog("START tracing children, FD_SETSIZE=%d\n",size);
	}
	if( lSIGCHLD() ){
		doSIGCHLDpid = getpid();
		sigblock(sigmask(SIGCHLD));
		signalRESTART(SIGCHLD,sigCHLD);
		TraceLog("START accepting SIGCHLD\n");
	}
}
int ptraceTraceMe();
void setNoExec()
{	int rcode;

	if( lTRACE() == 0 )
		return;
	rcode = ptraceTraceMe();
	if( rcode == 0 )
		signal(SIGTRAP,SIG_IGN);
}
static void logChild(PCStr(what),int inc)
{
	if( lTRACE() == 0 || lTRTERSE() )
		return;
	TraceLog("= %d (%s%d:%s)\n",
		NUM_CHILDREN,0<inc?"+":"",inc,what);
}

int cleanup_zombis(int log)
{	int pid;
	int ndead;

	ndead = 0;
	/*
	while( 0 < (pid = NoHangWait()) ){
	*/
	while( 0 < (pid = checkChildAbort1("zomb")) ){
		ndead++;
		dec_nproc(pid);
	}
	if( MAX_DELEGATE && MAX_DELEGATE + num_CC() <= NUM_CHILDREN ){
		int start = time(0);

		sv1tlog("MAX_DELEGATE: %d + %d <= %d\n",
			MAX_DELEGATE,num_CC(),NUM_CHILDREN);
		TraceLog("MAX_DELEGATE=%d < children=%d+%d\n",
			MAX_DELEGATE,NUM_CHILDREN,num_CC());

		while( MAX_DELEGATE + num_CC() <= NUM_CHILDREN ){
			if( 0 < (pid = NoHangWait()) ){
				ndead++;
				dec_nproc(pid);
			}else{
				if( gotSIGTERM )
					break;
				sleep(1);
			}
		}
		sv1tlog("MAX_DELEGATE: %d < %d + %d (%d seconds) finished=%d\n",
			NUM_CHILDREN,MAX_DELEGATE,num_CC(),time(0)-start, pid);
	}
	if( ndead )
		logChild("cleanup",-ndead);
	return ndead;
}


/*
 *	temporary argument to be removed after got
 */
#define TMP_SYM		"++"
#define TMP_SYM_LEN	(sizeof(TMP_SYM)-1)

static int killChildren()
{	int nproc;

	nproc = 0;
	if( 0 < myPrivateMASTER ){
		if( Kill(myPrivateMASTER,SIGTERM) == 0 ){
			svlog("Killed private-MASTER [%d]\n",myPrivateMASTER);
			myPrivateMASTER = 0;
			++nproc;
		}
	}
	return nproc;
}

int ServSock();
int isServSock(int sock);
static void send_socks(PVStr(socks),int cpid);
void LOG_checkAged(int renew);
int PortLockFd();
int spawnv_self(int aac,const char *aav[]);

static int inSIGHUP;
static void sigHUPX(int sig,PCStr(execpath),const char *argv[])
{	const char *nargv[MAX_ARGC]; /**/
	const char *arg;
	CStr(path,1024);
	CStr(port,128);
	CStr(nchild,32);
	CStr(wd,1024);
	int ai,ac,portset;
	int nproc;
	CStr(orig_av0,1024);
	int svclose_restart = 0;

 if( execpath == NULL ){
	strcpy(path,EXEC_PATH);
	wordScan(main_argv[0],orig_av0);/*av[0] may be expanded for ps_title*/
 }

	if( getpid() != ServerPID ){
		fprintf(stderr,"\nDeleGate[%d] got SIGHUP(%d) for server=%d\n",
			getpid(),sig,ServerPID);
		exit(1);
	}

	signal(SIGHUP,SIG_IGN);
	alarm(0);
	sigsetmask(0);
	LOG_sock_enable = 1;

	dumpCKey(1);

 {
 CStr(lpath,1024);
 CStr(host,256);
 FILE *logfp;
 int port;
 int lsock;

 sprintf(lpath,"/tmp/delegate/restart/%d",getpid());
 if( logfp = fopen(lpath,"r") ){
	CStr(buf,1024);
	if( fgets(buf,sizeof(buf),logfp) != NULL )
	if( Xsscanf(buf,"%[^:]:%d",AVStr(host),&port) == 2 ){
		fclose(logfp);
		lsock = client_open("LOG","http",host,port);
		fprintf(stderr,"#### %s : %d [%d]\n",host,port);
		write(lsock,"(^_^)\n",6);
		sleep(5);
		close(lsock);
	}
 }
 }

	sv0log("DeleGate SERVER RESTART: %s\n",
		sig==0?"timeout":"caught SIGHUP");

 {
 int fd;
 fd = openNull(0);
 sv0log("NUM_HUPS=%d FD=[%d]\n",NUM_HUPS+1,fd);
 if( 0 < fd )
 close(fd);
 }

	printServPort(AVStr(port),"-P",1);

	if( sig == -1 ){
		sv0log("REOPEN PORT: %s\n",port);
		printServPort(AVStr(port),"-P",0);
		closeServPorts();
		svclose_restart = 1;
	}

	if( !INHERENT_fork() ){ /* try not to kill active Sticky ... */
		sv1log("## StickyActive=%d\n",StickyActive);
		if( 0 < StickyActive ){
			int ti,tx;
			int shlock,rcode,etime;
			tx = 15;
			shlock = PortLockFd();
			if( 0 <= shlock ){
				/* block new request to be accepted by Sticky */
				rcode = lock_exclusiveTO(shlock,tx*1000,&etime);
				sv1log("## StickyActive lockout=%d (%d)\n",
					rcode,etime);
			}
			for( ti = 0; 0 < StickyActive && ti < tx; ti++ ){
				cleanup_zombis(0);
				sv1log("## StickyActive=%d %d/%d\n",
					StickyActive,ti+1,tx);
				sleep(1);
			}
		}
		/* ServPorts should be passed (duplicated) to the restarted
		 * DeleGate keeping the backlog...
		 */
		if( !svclose_restart ){
		printServPort(AVStr(port),"-P",-1);
		}
		/*
		closeServPorts();
		*/
	}

	nproc = killChildren();
	StickyKill(SIGHUPTERM);

	LOG_deletePortFile();
	deleteWORKDIR();
	if( originWD ) chdir(originWD);

	LOG_checkAged(1);
	sv0log("DeleGate SERVER RESTART in progress...\n");
	strcpy(wd,"?");
	getcwd(wd,sizeof(wd));
	sv0log("PWD: %s\n",wd);
if( execpath == NULL )
	sv0log("EXEC: %s\n",path);
	LOG_closeall();

	close(StickyReport[0]); StickyReport[0] = -1;
	close(StickyReport[1]); StickyReport[0] = -1;

	if( 0 < nproc || NUM_CHILDREN )
		msleep(100);
	cleanup_zombis(0);
/*
	sprintf(nchild,"%s%d/%d/%d/%d",TMP_SYM,++NUM_HUPS,NUM_CHILDREN,
		LOG_sockio[0],LOG_sockio[1]);
*/
	sprintf(nchild,"HUPENV=%d/%d/%d/%d",++NUM_HUPS,NUM_CHILDREN,
		LOG_sockio[0],LOG_sockio[1]);

 if( execpath != NULL ){
	const char *ppid;
	CStr(dgpid,32);
	CStr(dgargs,1024);
	/* maybe restarting DeleGate via shell script or so.  */
	ppid = getenv("DELEGATE_PID");
	sv1log("#### parent DELEGATE_PID=%s\n",ppid?ppid:"NULL");
	if( ppid == NULL || atoi(ppid) != getpid() ){
		/* the shell (parent) process may be waiting exit code
		 * from this process rathar than "exec" this process.
		 */
		if( INHERENT_fork() ){
			if( Fork("execmain") != 0 )
				exit(0);
		}
	}
	sprintf(dgpid,"DELEGATE_PID=%d",getpid());
	putenv(dgpid);
	sprintf(dgargs,"DELEGATE_ARGS=%s %s",port,nchild);
	putenv(dgargs);
	sv1log("#### %s %s\n",dgpid,dgargs);
	Execvp("execmain",execpath,argv);
	Finish(-1);
 }

	nargv[0] = orig_av0;
	ac = 1;
	portset = 0;

	if( getEnv(P_DGROOT) == 0 ){
		CStr(dgroot,1024);
		sprintf(dgroot,"DGROOT=%s",DELEGATE_DGROOT);
		nargv[ac++] = dgroot;
		sv1log("## set %s\n",dgroot);
	}

	for( ai = 1; ai < main_argc; ai++ ){
		if( elnumof(nargv)-3 <= ac ){
			sv1log("#### ignored too many args [%d -]\n",ac);
			break;
		}
		arg = main_argv[ai];
		if( arg[0]=='-' && arg[1]=='-' )
			continue;
		if( strncmp(arg,TMP_SYM,TMP_SYM_LEN) == 0 )
			continue;
		if( strncmp(arg,"HUPENV=",7) == 0 )
			continue;
		if( arg[0]=='-' && arg[1]=='P' ){
			if( !portset ){
				portset = 1;
				nargv[ac] = port;
			}
		}else	nargv[ac] = (char*)arg;
		ac++;
	}
	if( !portset )
		nargv[ac++] = port;
	nargv[ac++] = nchild;
	nargv[ac] = 0;

	if( !INHERENT_fork() ){
/*
		sprintf(nchild,"%s%d/%d/%d/%d",TMP_SYM,NUM_HUPS,NUM_CHILDREN,
			-1,-1);
*/
		sprintf(nchild,"HUPENV=%d/%d/%d/%d",NUM_HUPS,NUM_CHILDREN,
			-1,-1);

		if( isatty(fileno(stdin)) ){
			int fd,logfd,ssfd,rcode;
			int bgpid,pid,si;
			printf("NUM_HUPS=%d FD=[%d]\n",NUM_HUPS+1,
				dup(fileno(stderr)));

			logfd = curLogFd();
			ssfd = SessionFd();
			si = 0;
/*
			for( fd = 0; fd < 256; fd++ ){
*/
			for( fd = 0; fd < FD_SETSIZE; fd++ ){
				if( fd == logfd
				 || fd == ssfd
				 || fd == fileno(stdin)
				 || fd == fileno(stdout)
				 || fd == fileno(stderr) )
					continue;
				if( isServSock(fd) ){
					setrsvdsock(si++,fd);
					continue;
				}
				/*
				rcode = setCloseOnExec(fd);
				*/
				rcode = close(fd);
			}
			if( logfd != fileno(stdout) )
			if( logfd != fileno(stderr) )
				close(logfd);

			/*
			setserversock(ServSock());
			*/
			bgpid = Spawnvp("HUP",path,nargv);
			closeServPorts();
			if( NUM_HUPS <= 1 ){
				signal(SIGHUP,(vfuncp)sigHUPX);
				while( pid = wait(0) ){
					if( pid == bgpid ){
						break;
					}
				}
			}else{
				/* wait chld to get environment ? */
				sleep(5);
			}
			/*
			Execvp("HUP",path,nargv);
			*/
		}else{
			int pid;
			extern int LastCpid;

			if( !svclose_restart ){
			ac = 0;
			nargv[ac++] = "-Fsleep"; /* to hold socket */
			nargv[ac++] = "10";
			nargv[ac] = 0;
			pid = spawnv_self(ac,nargv);
			sprintf(nchild,"HUPENV=%d/%d/%d/%d/",
				NUM_HUPS,NUM_CHILDREN,-1,-1);
			send_socks(TVStr(nchild),LastCpid);
			}

			/*
			nargv[0] = "-Fkill-hup";
			nargv[1] = port;
			nargv[2] = 0;
			spawnv_self(2,nargv);
			*/
			inSIGHUP = 1;
			ac = 0;
			nargv[ac++] = "-Fkill-hup";
			nargv[ac++] = port;
			if( !svclose_restart ){
			nargv[ac++] = nchild;
			}
			nargv[ac] = 0;

			sv1log("RESTART %s ...\n",port);
			spawnv_self(ac,nargv);
			sv1log("RESTART WAITING to be STOPPED ...\n");
			sleep(15);
			sv1log("RESTART ERROR: not have been STOPPED\n");
		}
		Finish(0);
	}

	Execvp("sigHUP",path,nargv);
}
int recv_sock(int spid,int ssock,int closesrc);
int send_sock(int dpid,int fd,int closesrc);
static void recv_socks(){
	int pid,si,sock,fd;
	const char *dp;
	CStr(num,32);

	if( ME.me_src_socks[0] == 0 )
		return;

	sv1log("#### %s\n",ME.me_src_socks);
	dp = ME.me_src_socks;
	dp = wordscanY(dp,AVStr(num),sizeof(num),"^,");
	if( *dp == ',' )
		dp++;
	pid = atoi(num);

	for( si = 0; *dp; si++ ){
		dp = wordscanY(dp,AVStr(num),sizeof(num),"^,");
		if( *dp == ',' )
			dp++;
		sock = atoi(num);
		if( sock <= 0 )
			break;
		fd = recv_sock(pid,sock,1);
		sv1log("#### recv_sock(pid=%d,fd=%d) port=%d\n",
			pid,sock,sockPort(fd));
	}
	ME.me_src_socks[0] = 0;
}
static void send_socks(PVStr(socks),int cpid)
{	refQStr(dp,socks); /**/
	int fd,sock;

	sprintf(dp,"%d",cpid);
	dp += strlen(dp);

	for( fd = 0; fd < FD_SETSIZE; fd++ ){
		if( !isServSock(fd) )
			continue;
		sock = send_sock(cpid,fd,1);
		sprintf(dp,",%d",sock);
		dp += strlen(dp);
		sv1log("#### send_sock(pid=%d,fd=%d) port=%d\n",
			cpid,sock,sockPort(fd));
	}
	sv1log("#### %s\n",socks);
}
static void sigHUP(int sig)
{
	sigHUPX(sig,NULL,NULL);
}
void DELEGATE_execmain(PCStr(command))
{	CStr(argb,1024);
	const char *av[128]; /**/
	int ac;

	ac = decomp_args(av,128,command,AVStr(argb));
	sigHUPX(0,av[0],av);
}

extern int  AF_UNIX_DISABLE;
int acceptExclusive();

static void setupForSolaris()
{
	/* LOG_type is given by the parent in private-MASTER in the av[] */
	if( LOG_type_got )
		return;

	if( acceptExclusive() ){
		Verbose("ACCEPT EXCLUSION is ON by default.\n");
		if( (LOG_type & (L_FORK|L_EXEC)) == 0 ){
			if( LOG_type & L_LOCK )
				LOG_type &= ~L_LOCK;
			else	LOG_type |=  L_LOCK;
		}
	}
}
/*
 *	This function should be called after the process's real OWNER
 *	is set so that the directry is writable for the process itself.
 */
int IsSolaris();
static void mkdirForSolaris()
{
	if( IsSolaris() )
		AF_UNIX_DISABLE = 1;
}

#define LOAD_SYM	"-="
#define LOAD_SYM_LEN	(sizeof(LOAD_SYM)-1)

extern int DEBUG_FILE;

void makeWorkFile(PVStr(path),PCStr(type),PCStr(file));
static int subst_argurl(PCStr(base),PCStr(url),PCStr(arg),PVStr(xarg))
{	CStr(aurl,1024);
	CStr(path,1024);
	CStr(param,1024);
	FILE *sfp,*dfp;
	int size;

	sfp = openPurl(base,url,AVStr(aurl));
	if( sfp == NULL ){
		ERRMSG("Cannot load: %s\n",url);
		return -1;
	}

	param[0] = 0;
	Xsscanf(arg,"%[^=]",AVStr(param));
	makeWorkFile(AVStr(path),"mirror",param);

	dfp = dirfopen(param,AVStr(path),"w");
	if( dfp == NULL ){
		ERRMSG("Cannot create: %s\n",path);
		fclose(sfp);
		return -1;
	}

	copyfile1(sfp,dfp);
	fclose(sfp);
	fflush(dfp);
	size = file_size(fileno(dfp));
	fclose(dfp);

	sprintf(xarg,"%s=%s",param,path);
	/*fprintf(stderr,"Argument substituted [%s] -> [%s](%dbytes)\n",
		arg,xarg,size);*/
	return 0;
}

void scanServPort(PCStr(portspecs));
const char *scan_arg1(PCStr(ext_base),PCStr(arg))
{	const char *list;
	const char *val;
	int num;
	const char *as;
	const char *dp;
	CStr(xarg,1024);

	if( dp = strchr(arg,'=') ){
		dp++;
		if( strncmp(dp,LOAD_SYM,LOAD_SYM_LEN) == 0 ){
			dp += LOAD_SYM_LEN;
			if( subst_argurl(ext_base,dp,arg,AVStr(xarg)) == 0 )
				arg = stralloc(xarg);
		}
	}

	/* inherited on SIGHUP */
	if( strncmp(arg,"HUPENV=",7) == 0 ){
		Xsscanf(arg+7,"%d/%d/%d/%d/%s",&NUM_HUPS,&NUM_CHILDREN,&LOG_sockio[0],&LOG_sockio[1],AVStr(ME.me_src_socks));
	}else
/*
	if( strncmp(arg,TMP_SYM,TMP_SYM_LEN) == 0 && arg[TMP_SYM_LEN] != 0 ){
		sscanf(arg+2,"%d/%d/%d/%d",&NUM_HUPS,&NUM_CHILDREN,&LOG_sockio[0],&LOG_sockio[1]);
	}else
*/
	if( include_next ){
		include_next = 0;
		load_script(NULL,ext_base,arg);
	}else
	if( strncmp(arg,INC_SYM,INC_SYM_LEN) == 0 ){
		if( arg[INC_SYM_LEN] == 0 )
			include_next = 1;
		else	load_script(NULL,ext_base,arg+INC_SYM_LEN);
	}else
	if( strncmp(arg,"-e",2) == 0 ){
		putenv(StrAlloc(arg+2));
	}else
	if( list = strchr(arg,'=') ){
		if( !dont_check_param ){
			check_param(arg,1);
		}

		list++;
		if( strncmp(list,INC_SYM,INC_SYM_LEN) != 0 )
		if( dp = strstr(arg,":+=") )
			list = dp+1;
		else
		if( dp = strstr(arg,",+=") )
			list = dp+1;

		if( strncmp(list,INC_SYM,INC_SYM_LEN) == 0 ){
			CStr(name,128);
			extern int SCRIPT_ASIS;
			int asis;

			QStrncpy(name,arg,list-arg+1);
			asis = SCRIPT_ASIS;
			SCRIPT_ASIS = script_asis(name);
			load_script(name,ext_base,list+INC_SYM_LEN);
			SCRIPT_ASIS = asis;
		}else
		if( ext_base != NULL )
			DELEGATE_addEnvExt(arg);
	}else
	if( strncmp(arg,PrivateMasterOwner,strlen(PrivateMasterOwner)) == 0 ){
		PrivateMasterOwnerPort[0] = 0;
		Xsscanf(arg+strlen(PrivateMasterOwner),"%[^)]",AVStr(PrivateMasterOwnerPort));
	}else
	switch( arg[0] ){
	    case '-':
	    val = &arg[2];
	    switch( arg[1] ){
		case 'F':
			/* function selector */
			break;

		case 'P': /* server port */
			svlog("PORT> %s\n",arg);

			/* this code seems to be introduced at 4.0.4 maybe for
			 * passing server-socket to Sticky process on Win32,
			 * but seems not to have been used...
			 */{int sock;
			    if( 0 < (sock = getserversock()) ){
				char *ap = (char*)malloc(strlen(arg)+16);
				defQStr(dp); /*alloc*//**/
				arg = (char*)memcpy(ap,arg,strlen(arg)+1);
				setQStr(dp,(char*)arg,strlen(arg)+16);
				val = &arg[2];
				if( (dp = strchr(arg,'/')) == 0 )
					dp = (char*)&arg[strlen(arg)];
				sprintf(dp,"/%d",sock);
			    }
			}
			if( strncmp(arg,"-P0/",4) == 0 )
				IamPrivateMASTER = getppid();
			scanServPort(val);
			break;

		case 'c':
			switch( arg[2] ){
			    case 'e': pushEnv(P_CHARCODE,"EUC"); break;
			    case 'j': pushEnv(P_CHARCODE,"JIS"); break;
			    case 's': pushEnv(P_CHARCODE,"SJIS"); break;
			}
			break;

		case 'C':
			DELEGATE_CONFIG = stralloc(val);
			break;

		case 'L':
			LOG_type_got = 1;
			sscanf(val,"0x%x",&LOG_type);
			break;

		case 'd':
			switch( arg[2] ){
			case 'f': LOG_type |= L_FILETRACE; break;
			case 'h': LOG_type |= L_HOSTMATCH; break;
			case 'm': LOG_type |= L_MEMPUSH; break;
			case 's': LOG_type |= L_SOCKET; break;
			case 'M': LOG_type |= L_MOUNT; break;
			default:
			LOG_type |= L_ARGDUMP;
			}
			break;

		case 'l':
			LOG_type |= L_LOCK;
			break;
		case 'p':
			PEEK_CLIENT_REQUEST = 1;
			break;

		case 'f':
			LOG_type |= L_FG;
			break;
		case '1':
			LOG_type |= L_SYNC | L_TTY;
			break;
		case 't':
			LOG_type |= L_TTY;
			break;
		case 's':
			LOG_type |= L_FORK;
			break;
		case 'x':
			LOG_type |= L_EXEC;
			break;

		case 'R':
			RAND_TRACE = 1;
			LOG_type |= L_RAND_TRACE;
			break;

		case 'S':
			if( SIGCHLD < 0 ){
				fprintf(stderr,"#### -S NOT SUPPORTED: %s\n",
					"SIGCHLD signal is not available");
				break;
			}
			LOG_type |= L_SIGCHLD;
			break;
		case 'T': /* trace / trap */
			if( !INHERENT_ptrace() ){
				fprintf(stderr,"#### -T NOT SUPPORTED: %s\n",
					"ptrace system call is not available");
				break;
			}
			LOG_type |= L_TRACE | L_SIGCHLD;
			for( as = arg+2; *as; as++ ){
			    switch( *as ){
				case 'x': LOG_type |= L_NOEXEC; break;
				case 's': LOG_type &= ~L_SIGCHLD; break;
				case 't': LOG_type |= L_TRTERSE; break;
				case 'd': LOG_type |= L_TRVERB; break;
			    }
			}
			break;

		case 'v':
			if( arg[2] == 0 ){
				LOG_type |= L_FG|L_TTY;
			}else
			for( as = arg+2; *as; as++ ){
			    switch( *as ){
				case  's': LOG_type |= L_SILENT; break;
				case  't': LOG_type |= L_TERSE; break;
				case  'u': /* usual */
					LOG_type &= ~(L_SILENT|L_TERSE|L_VERB);
					LOG_VERBOSE = 0;
					break;
				case  'v': LOG_type |= L_FG|L_TTY|L_VERB; break;
				case  'd': LOG_type |= L_VERB; break;
				case  'a': LOG_type |= L_VERBABORT; break;
				case  'm': LOG_type |= L_MEMPUSH; break;

				case  '2':
				case  '3':
				case  '4':
				{	int lev;
					lev = *as - '0';
					LOG_type = LOG_type & ~L_LEVEL | lev;
					break;
				}
			    }
			}
			break;
		case 'w':
			if( arg[2] == 0 )
				LOG_type |= 1;
			else
			if( arg[2] == 'H' ){
				PollIn_HUP(0);
				fprintf(stderr,"POLLHUP disabled\n");
			}else
			if( '0' <= arg[2] && arg[2] <= '9' )
				LOG_type = (LOG_type & ~0xF) | (arg[2]-'0');
			break;

		case 'r':
			ME.me_restart = 1;
			break;
		case 'i':
			LOG_type |= L_REINIT;
			break;
		}
		break;
	}
	LOG_VERBOSE = lVERB() ? 1 : 0;
	return arg;
}
#define scan_args(ac,av)	DELEGATE_scan_args(ac,av)

static scanListFunc scanopt1(PCStr(arg))
{
	scan_arg1(NULL,arg);
	return 0;
}
void scan_DGOPTS(Connection *Conn,PCStr(arg))
{
	scan_ListL(arg,';',1,scanListCall scanopt1);
}
int add_condarg(PCStr(arg));
int scan_args(int ac,const char *av[])
{	int ai;
	int dgopt;
	const char *arg;

	if( lVERB() || lARGDUMP() ){
		for( ai = 0; ai < ac; ai++ )
			fprintf(stderr,"[%d] %s\n",ai,av[ai]);
	}

	dgopt = 0;
	for( ai = 0; ai < ac; ai++ )
	{	arg = av[ai];

		if( add_condarg(arg) )
			continue;

		/* ignoring options for -Ffunction */
		if( Fopt && ai < Fopt ){
			/* delegated -dgopt -dgopt ... -Ffunc -fopt -fopt ... */
		}else
		if( Fopt || isFunc ){
			/* ... -fopt -fopt -- -dgopt -dgopt ... */
			if( strcmp(arg,TMP_SYM) == 0 ){
				dgopt = 1;
				continue;
			}
			if( dgopt == 0 && arg[0] == '-' ){
				if( strchr("P",arg[1]) == 0 )
					continue;
			}else
			if( strchr(arg,'=') == 0 ){
				continue;
			}
		}
		av[ai] = scan_arg1(NULL,av[ai]);
	}

	if( lVERB() )
		LOG_VERBOSE = 1;

	setupForSolaris();
	return ac;
}

/*
 * redirect output from child process to standard out/err to logfile.
 */
FILE *LOG_open(Logfile *logF);
Logfile *LOG_create(PCStr(proto),PCStr(filters),PCStr(logform),PCStr(pathform),PCStr(mode),int dolock);;

void setSTDLOG()
{
	LOG_open(LOG_create("stdout","STDOUTLOG","-","stdout.log","a",0));
}
/*
setSTDLOG()
{	FILE *logfp;
	int logfd;

	logfp = LOG_openLogFile("stdout.log","a");
	if( logfp != NULL ){
		sv1log("Redirect {stdout,stderr} to LOGDIR/stdout.log\n");
		logfd = fileno(logfp);
		dup2(logfd,fileno(stderr));
		dup2(logfd,fileno(stdout));
	}
}
*/

void put_identification(FILE *out);
static void ScanFileDefs(Connection *Conn);
int askADMIN(FILE *out,FILE *in,PVStr(admin),int size);
int checkCACHEDIR(Connection *Conn);
int CTX_evalMountCond(Connection *ctx,PCStr(opts),PCStr(user),PCStr(chost),int cport,PCStr(ihost),int iport);

static void beDaemon(Connection *Conn)
{	const char *av[MAX_ARGC]; /**/
	CStr(port,128);
	CStr(param,128);
	int ac,ai;
	const char *admin;
	CStr(admbuff,128);
	CStr(parambuff,128);
	CStr(logtype,32);

	if( !INHERENT_spawn() ){
		if( Fork("daemon") != 0 )
			_Finish(0);
		setsid();
		return;
	}

	ac = 0;	
	av[ac++] = EXEC_PATH;
	ac += copy_param(NULL,MAX_ARGC-ac-8,&av[ac],(const char**)environ);
	ac += copy_param("*+",MAX_ARGC-ac-8,&av[ac],&main_argv[1]);
	printServPort(AVStr(port),"",1);
	sprintf(param,"-P%s",port);
	av[ac++] = param;
	sprintf(logtype,"-L0x%x",LOG_type);
	av[ac++] = logtype;
	for( ai = 0; ai < main_argc; ai++ ){
		if( elnumof(av)-2 <= ac ){
			fprintf(stderr,"too many arguments -- ignored\n");
			break;
		}
		if( streq(main_argv[ai],"-SERVICE") ){
			av[ac++] = "-SERVICE";
			break;
		}
		if( strncmp(main_argv[ai],"-W",2) == 0 ){
			av[ac++] = main_argv[ai];
		}
		if( strncmp(main_argv[ai],"-d",2) == 0 )
			av[ac++] = main_argv[ai];
	}
	av[ac] = 0;

	put_identification(stdout);
	admin = getADMIN1();
	fprintf(stderr,"DGROOT=%s\r\n",DELEGATE_DGROOT);
	fprintf(stderr,"ADMIN=%s\r\n",admin?admin:"");

	if( admin == NULL || *admin == 0 ){
		printf("CAUTION: ADMIN is not specified.\r\n");
		printf("You must declare your E-mail address.\r\n");

		admbuff[0] = 0;
		if( askADMIN(stdout,stdin,AVStr(admbuff),sizeof(admbuff)) != 0 )
			Finish(0);
		if( admbuff[0] == 0 ){
			printf("EXIT: You must declare ADMIN\r\n");
			Finish(0);
		}
		sprintf(parambuff,"ADMIN=%s",admbuff);
		av[ac++] = parambuff;
		av[ac] = NULL;
	}
	ScanFileDefs(Conn);
	if( checkCACHEDIR(Conn) != 0 )
		Finish(-1);

	dumpCKey(1);
	if( create_service(ac,av,port) )
		exit(0);

	sv1log("#### DO NOT FORK TO BE DAEMON\n");
}


extern int START_TIME1;
extern const char *hostmatch_withauth;

static void scan_serverspec(Connection *Conn,PCStr(serverspec),PVStr(url),PVStr(hostlist))
{	const char *hl;
	CStr(map,256);
	CStr(type,16);
	refQStr(op,url); /**/

	/*
	 * strip "URI[:-:srcList]" postfix first
	 */
	if( hl = strstr(serverspec,":-:") ){
		strcpy(url,serverspec);
		hl = strstr(url,":-:");
		truncVStr(hl);
		strcpy(hostlist,hl+3);
	}else{
		strcpy(url,serverspec);
		strcpy(hostlist,"");
	}
	if( strchr(url,':') == NULL )
	{
		if( op = strstr(url,",-") ){
			/* SERVER=telnet,-in -> SERVER=telnet://-/,-in */
			Strins(AVStr(op),"://-/");
		}else
		strcat(url,"://-/");
	}

	/* ex. SERVER=telnet://host,-in */
	if( op = strstr(url,",-") ){
		wordscanY(op+2,AVStr(type),sizeof(type),"^,(:");
		/*
		Xsprintf(TVStr(hostlist),",%s",hostmatch_withauth);
		*/
		if( hostlist[0] )
			strcat(hostlist,",");
		strcat(hostlist,hostmatch_withauth);
		sprintf(map,"{%s}:vp_%s:*:%s",url,type,hostlist);
		sv1log("XSERVER: %s\n",map);
		scan_CMAP2(Conn,"XSERVER",map);
	}

	/* ex. SERVER=sockmux:commin@/tmp/com1 */
	if( strstr(url,"://") == 0 )
	if( op = strstr(url,":") ){
	const char *dp = wordscanY(op+1,AVStr(type),sizeof(type),"^@:/?");
		if( *dp == '@' )
		if( type[0] ){
			sprintf(map,"{%s}:vp_%s:*:%s",url,type,hostlist);
			sv1log("XSERVER: %s\n",map);
			scan_CMAP2(Conn,"XSERVER",map);
			Strins(QVStr(op+1,url),"//-/");
			/* sockmux://-/commin@/tmp/...  */
		}
	}
}
/*
 *  DEST=host:port:srcList     -> SERVER=tcprelay://host:port,-in
 *  DEST=host:port/udp:srcList -> SERVER=udprelay://host:port,-in
 */
static void scan_DEST(Connection *Conn,PCStr(dest))
{	CStr(destb,256);
	const char *proto;
	const char *av[4]; /**/
	const char *dp;
	CStr(map,256);

	lineScan(dest,destb);
	av[2] = "*";
	if( list2vect(destb,':',3,av) < 2 ){
		sv1log("error DEST=%s\n",dest);
		return;
	}
	proto = "tcprelay";
	if( (dp = strchr(av[1],'/')) || (dp = strchr(av[1],'.')) ){
		truncVStr(dp); dp++;
		if( streq(dp,"udp") ) 
			proto = "udprelay";
	}
	sprintf(map,"{%s://%s:%s}:vp_in:*:%s",proto,av[0],av[1],av[2]);
	sv1log("DEST=%s -> XSERVER: %s\n",dest,map);
	scan_CMAP2(Conn,"XSERVER",map);
}

static int server2(Connection *Conn,PCStr(serverspec),PVStr(serverurl))
{	CStr(hostlist,1024);
	CStr(chost,256);
	CStr(ihost,256);
	int cport,iport;
	int match;
	const char *user;

	/*
	scan_serverspec(serverspec,serverurl,hostlist);
	*/
	scan_serverspec(Conn,serverspec,AVStr(serverurl),AVStr(hostlist));
	if( hostlist[0] == 0 ){
		strcpy(Serverurl0,serverurl);
		return 0;
	}
	if( !Conn->cl.p_connected )
		return 0;

	iport = gethostNAME(ClientSock,AVStr(ihost));
	cport = getClientHostPort(Conn,AVStr(chost));
	user = getClientUser(Conn);
	if( user == NULL )
		user = "-";

	/* to setup for matching SERVER=url:-:-Pxxxx */
	HL_setClientIF(ihost,iport,0);

	match = CTX_evalMountCond(Conn,hostlist,user,chost,cport,ihost,iport);

	if( match ){
		Verbose("OK [%s] [%s][%s]\n",serverurl,chost,hostlist);
		scan_SERVER(Conn,serverurl);
		Conn->cl.p_bound = 1;
		return 1;
	}else{
		Verbose("NO [%s] [%s][%s]\n",serverurl,chost,hostlist);
		return 0;
	}
}

static int server1(Connection *Conn,PCStr(serverspec))
{	CStr(serverurl,1024);

	if( Conn->cl.p_bound )
		return 1;

	if( server2(Conn,serverspec,AVStr(serverurl)) )
		return 1;

	return 0;
}

static int REUSE_ENV();
static const char *Scan_SERVER(Connection *Conn)
{	const char *proto;
	CStr(url,1024);

	setQStr(Serverurl0,url,UTail(url)-url+1);
	setVStrEnd(Serverurl0,0);
	scanEnv(Conn,P_SERVER,(scanPFUNCP)server1);

	if( !Conn->cl.p_bound && Serverurl0[0] )
		if( scan_SERVER(Conn,Serverurl0) == 0 )
			Exit(-1,"ERROR: %s=%s\n",P_SERVER,Serverurl0);

	/* V8.0.1 SERVER=http by default and SERVER=delegate to be Generalist */
	/* V8.0.4 SERVER=delegate with REMITTABLE={http*} by default */
	if( strcmp(DFLT_PROTO,"delegate") == 0 ){
		DFLT_PROTO[0] = 0;
		DFLT_HOST[0] = 0;
	}else
	if( getEnv(P_SERVER) == NULL ){
		/*
		scan_SERVER(Conn,"http");
		*/
	}

	if( DFLT_PROTO[0] ){
		BORN_SPECIALIST = 1;
		proto = DFLT_PROTO;
		if( !REUSE_ENV() )
		Verbose("SPECIALIST: %s\n",proto);
	}else{
		Verbose("GENERALIST\n");
		BORN_SPECIALIST = 0;
		proto = "delegate";
	}
	return proto;
}

int isHTTP(PCStr(proto))
{
	return strcaseeq(proto,"http") || strcaseeq(proto,"https");
}
static void servermount1(Connection *Conn,PCStr(serverspec))
{	CStr(serverurl,1024);
	CStr(hostlist,1024);
	CStr(mountopt,1024);
	CStr(mount,1024);
const char *proto;
proto = servermount_proto;

	/*
	scan_serverspec(serverspec,serverurl,hostlist);
	*/
	scan_serverspec(Conn,serverspec,AVStr(serverurl),AVStr(hostlist));
	if( hostlist[0] )
		if( strchr(hostlist,'=') )
			sprintf(mountopt,"%s",hostlist);
		else	sprintf(mountopt,"via=%s",hostlist);
	else	strcpy(mountopt,"");

	/* V8.0.0 forbid non-RELIABLE hosts to access internal pages */
	set_MOUNT_ifndef(Conn,"/-/builtin/icons/*","=","default");
	set_MOUNT_ifndef(Conn,"/-/*","=","forbidden,from=!.RELIABLE,default");

	if( isHTTP(proto) ){
		/* if SERVER=http://server then this should be "%s/*" */
		sprintf(mount,"%s*",serverurl);
		set_MOUNT_ifndef(Conn,"/-*","=",mountopt);
		set_MOUNT_ifndef(Conn,"/=*","=",mountopt);

		if( strstr(serverspec,"://") )
		set_MOUNT_ifndef(Conn,"/*",mount,mountopt);
		else{
			/* MOUNT="/* //-/*" causes virtual hosting,
			 * "//-" in right hand is interpreted so ... */
		}
	}
	if( streq(proto,"nntp") || streq(proto,"news") ){
		sprintf(mount,"%s*",serverurl);
		set_MOUNT_ifndef(Conn,"=",mount,mountopt);
	}
	if( streq(proto,"ftp") ){
		set_MOUNT_ifndef(Conn,"//*","=",mountopt);
		if( !isMYSELF(DFLT_HOST) )
		if( getEnv(P_MOUNT) != NULL || strchr(serverurl,'@') ){
			sprintf(mount,"%s*",serverurl);
			set_MOUNT_ifndef(Conn,"/*",mount,mountopt);
		}
	}
	if( streq(proto,"pop") || streq(proto,"imap") )
		set_MOUNT_ifndef(Conn,"//*","=",mountopt);
}

static void mount_all(Connection *Conn,PCStr(proto))
{	const char *env;

	if( mount_done )
		return;
	mount_done = 1;

	scanEnv(Conn,P_MOUNT,scan_MOUNT);

servermount_proto = proto;
	scanEnv(Conn,P_SERVER,servermount1);

	init_mtab();
}

static const char *defaultPERMIT(Connection *Conn)
{	CStr(remitable,128);

	if( BORN_SPECIALIST ){
		if( streq(DFLT_PROTO,"telnet") )
		if( iSERVER_PORT != 0 ){
			sprintf(remitable,"%s/%d",iSERVER_PROTO,iSERVER_PORT);
			sv1log("REMITTABLE bound by SERVER: %s\n",remitable);
			return stralloc(remitable);
		}
		if( streq(DFLT_PROTO,"tunnel1") )
			return DELEGATE_G_PERMIT;

		if( isHTTP(DFLT_PROTO) || streq(DFLT_PROTO,"icp") )
			return DELEGATE_HTTP_PERMIT;
		else
		if( streq(DFLT_PROTO,"socks") )
			return DELEGATE_SOCKS_PERMIT;
		else
		if( streq(DFLT_PROTO,"telnet") )
			return DELEGATE_TELNET_PERMIT;
		else	return DELEGATE_S_PERMIT;
/*
	}else	return DELEGATE_G_PERMIT;
*/
	}else{
		/* V8.0.4 SERVER=delegate with REMITTABLE={http*} by default */
		if( getEnv(P_SERVER) == 0 )
			return DELEGATE_HTTP_PERMIT;
		else	return DELEGATE_G_PERMIT;
	}
}
static void scan_PERMITX(Connection *Conn,PCStr(proto))
{	CStr(extproto,1024);

	if( num_ListElems(proto,':') == 1 ){
		PERMIT_GLOBAL++;
		if( *proto == '+' ){
			sprintf(extproto,"%s%s",defaultPERMIT(Conn),proto+1);
			proto = extproto;
		}
	}else{
		if( PERMIT_GLOBAL == 0 ){
			scan_PERMIT(Conn,defaultPERMIT(Conn));
			PERMIT_GLOBAL++;
		}
	}
	scan_PERMIT(Conn,proto);
}

void httplog_head(Connection *Conn,int time,FILE *fp)
{	CStr(host,256);
	const char *user;
	CStr(date,64);

	strcpy(host,"-");
	getClientHostPort(Conn,AVStr(host));
	if( (user = getClientUserC(Conn)) == NULL )
		user = "-";
	StrftimeLocal(AVStr(date),sizeof(date),TIMEFORM_HTTPD,time,0);
	fprintf(fp,"%s %s %s [%s] ",host,user,"-",date);
}

Logfile *LOG_which(PCStr(proto),PCStr(filter1),int options);
void LOG_printf(Logfile *logF,PCStr(fmt),...);
int fputLog(Connection *Conn,PCStr(filter),PCStr(fmt),...)
{	CStr(date,64);
	Logfile *Log;
	VARGS(8,fmt);

	if( Log = LOG_which(DFLT_PROTO,filter,0) ){
		StrftimeLocal(AVStr(date),sizeof(date),TIMEFORM_HTTPD,time(0),0);
		LOG_printf(Log,"[%s]{%d+%d} %s: ",
			date,CHILD_SERNO,CHILD_SERNO_MULTI,filter);
		LOG_printf(Log,fmt,VA8);
		return 1;
	}
	return 0;
}
void scan_LOG(Connection *Conn,PCStr(log))
{	CStr(proto,64);
	CStr(filters,256);
	CStr(logform,256);
	CStr(pathform,1024);
	int ni;

	proto[0] = filters[0] = logform[0] = pathform[0] = 0;
	ni = Xsscanf(log,"%[^:]:%[^:]:%[^:]:%s",AVStr(proto),AVStr(filters),AVStr(logform),AVStr(pathform));
	if( ni != 4 ){
		ERRMSG("ERROR LOG=%s\n",log);
		return;
	}
	LOG_create(proto,filters,logform,pathform,"a",0);
}
static const char *logfile()
{	const char *logfile;

	if( (logfile = getEnv(P_LOGFILE)) == 0 )
		logfile = DELEGATE_LOGFILE;
	return logfile;
}

static char *primaryPort(PVStr(port))
{
	if( IamPrivateMASTER )
		sprintf(port,"%s++",PrivateMasterOwnerPort);
	else	printPrimaryPort(AVStr(port));
	return (char*)port;
}
static void strsubstDE(PVStr(spath),PCStr(path),PCStr(root),PCStr(var))
{
	strcpy(spath,path);
	strsubstDirEnv(AVStr(spath),root,var);
}

int substEXECDIR(PCStr(fpath),PVStr(opath),int osize);
int substEXECNAME(PCStr(fpath),PVStr(opath),int osize);

#define substfile DELEGATE_substfile
#define substFile(f) substfile(AVStr(f),"",VStrNULL,VStrNULL,VStrNULL)

void substfile(PVStr(file),PCStr(proto),PVStr(rvardir),PVStr(rlogdir),PVStr(ractdir))
{	CStr(port,256);
	CStr(pid,64);
	const char *vardir;
	const char *etcdir;
	const char *admdir;
	const char *logdir;
	const char *actdir;
	const char *TMPDIR;
	const char *WORKDIR;
	const char *CACHEDIR;
	const char *dgroot;
	const char *libdir;
	CStr(alogdir,1024);

	if( (dgroot = getEnv(P_DGROOT)) == 0 ) dgroot = DELEGATE_DGROOT;
	if( (libdir = getEnv(P_LIBDIR)) == 0 ) libdir = DELEGATE_LIBDIR;
	if( (vardir = getEnv(P_VARDIR)) == 0 ) vardir = DELEGATE_VARDIR;
	if( (etcdir = getEnv(P_ETCDIR)) == 0 ) etcdir = DELEGATE_ETCDIR;
	if( (admdir = getEnv(P_ADMDIR)) == 0 ) admdir = DELEGATE_ADMDIR;
	if( (logdir = getEnv(P_LOGDIR)) == 0 ) logdir = DELEGATE_LOGDIR;
	if( (actdir = getEnv(P_ACTDIR)) == 0 ) actdir = DELEGATE_ACTDIR;
	if( (TMPDIR = getEnv(P_TMPDIR)) == 0 ) TMPDIR = DELEGATE_TMPDIR;
	if( (WORKDIR = getEnv(P_WORKDIR)) == 0 ) WORKDIR = DELEGATE_WORKDIR;
	if( (CACHEDIR = getEnv(P_CACHEDIR)) == 0 ) CACHEDIR = DELEGATE_CACHEDIR;

	primaryPort(AVStr(port));
	sprintf(pid,"%d",getpid());

	if( !isBoundpath(logdir) ){
		strcpy(alogdir,logdir);
		strsubstDirEnv(AVStr(alogdir),dgroot,vardir);
		if( !isBoundpath(alogdir) )
			sprintf(alogdir,"%s/%s",vardir,logdir);
		logdir = alogdir;
	}

	/*
	if( lARGDUMP() )
	*/
	if( lFILETRACE() )
		fprintf(stderr,"[%d]< %s\n",getpid(),file);

	if( strstr(file,"${STARTDIR}") ){
		const char *startdir;
		if( startdir = getenv("STARTDIR") )
			strsubst(AVStr(file),"${STARTDIR}",startdir);
	}
	if( strstr(file,"${EXECDIR}") ){
		CStr(execdir,1024);
	const char *dp;
/*
		if( 0 < readlink(EXEC_PATH,execdir,sizeof(execdir)) ){
			CStr(cwd,1024);
			if( !isFullpath(execdir) ){
				getcwd(cwd,sizeof(cwd));
				chdir_cwd(cwd,execdir,0);
				strcpy(execdir,cwd);
			}
		}else
*/
		strcpy(execdir,EXEC_PATH);
		if( (dp= strrchr(execdir,'/')) || (dp= strrchr(execdir,'\\')) )
			truncVStr(dp);
		else	strcpy(execdir,".");
		strsubst(AVStr(file),"${EXECDIR}",execdir);
	}

	strsubst(AVStr(file),"${LIBDIR}",libdir);
	strsubst(AVStr(file),"${ETCDIR}",etcdir);
	strsubst(AVStr(file),"${ADMDIR}",admdir);
	strsubst(AVStr(file),"${LOGDIR}",logdir);
	strsubst(AVStr(file),"${ACTDIR}",actdir);
	strsubst(AVStr(file),"${TMPDIR}",TMPDIR);
	strsubst(AVStr(file),"${WORKDIR}",WORKDIR);
	strsubst(AVStr(file),"${CACHEDIR}",CACHEDIR);

	strsubstDirEnv(AVStr(file),dgroot,vardir);
	strsubst(AVStr(file),"${PROTO}",proto);
	strsubst(AVStr(file),"${PORT}",port);
	strsubst(AVStr(file),"${PID}",pid);

	{
		Connection *Conn = mainConn;
		if( Conn ){
			if( Client_Host[0] )
				strsubst(AVStr(file),"${CLIENTHOST}",Client_Host);
			else	strsubst(AVStr(file),"${CLIENTHOST}","");
		}
	}

	/*
	if( lARGDUMP() )
	*/
	if( lFILETRACE() )
		fprintf(stderr,"[%d]> %s\n",getpid(),file);

	if( rvardir != NULL ) strsubstDE(AVStr(rvardir),vardir,dgroot,vardir);
	if( rlogdir != NULL ) strsubstDE(AVStr(rlogdir),logdir,dgroot,vardir);
	if( ractdir != NULL ) strsubstDE(AVStr(ractdir),actdir,dgroot,vardir);

	/* might be referred in ${xxxDIR} via ${DGROOT} */
	if( strstr(file,"${EXECDIR}") ){
		substEXECDIR(file,AVStr(file),1024);
	}
	if( strstr(file,"${EXECNAME}") ){
		substEXECNAME(file,AVStr(file),1024);
	}
}

int substEXECDIR(PCStr(fpath),PVStr(opath),int osize)
{	CStr(xpath,4096);
	CStr(rpath,4096);
	CStr(xdir,4096);
	const char *dp;

	if( main_argv == 0 )
		return 0;

	toFullpathENV("PATH",main_argv[0],"r",AVStr(xpath),sizeof(xpath));
	if( xrealpath(xpath,AVStr(rpath),sizeof(rpath)) )
		lineScan(rpath,xpath);

	if( dp = strrpbrk(xpath,"/\\") ){
		truncVStr(dp);
		lineScan(fpath,xdir);
		strsubst(AVStr(xdir),"${EXECDIR}",xpath);
		setVStrEnd(opath,0);
		chdir_cwd(AVStr(opath),xdir,0); /* reduce redundant "." and ".." */
		return 1;
	}
	return 0;
}
int substEXECNAME(PCStr(fpath),PVStr(opath),int osize)
{	const char *name;

	if( main_argv == 0 )
		return 0;

	if( strstr(fpath,"${EXECNAME}") ){
		if( name = strrpbrk(main_argv[0],"/\\") )
			name += 1;
		else	name = main_argv[0];
		linescanX(fpath,AVStr(opath),osize);
		strsubst(AVStr(opath),"${EXECNAME}",name);
		return 1;
	}
	return 0;
}
void loadDefaultConf(){
	CStr(conf1,1024);
	CStr(conf,1024);

	substEXECDIR(DELEGATE_CONF,AVStr(conf1),sizeof(conf1));
	substEXECNAME(conf1,AVStr(conf),sizeof(conf));
	if( File_is(conf) ){
		load_script(NULL,NULL,conf);
	}
}

static scanListFunc shared1(PCStr(pathpat))
{	CStr(xpathpat1,1024);
	CStr(xpathpat2,1024);

	if( !isBoundpath(pathpat) ){
		strcpy(xpathpat1,pathpat);
		substFile(xpathpat1);
		if( isBoundpath(xpathpat1) )
			pathpat = xpathpat1;
		else{
			sprintf(xpathpat2,"${DGROOT}/%s",pathpat);
			substFile(xpathpat2);
			if( isBoundpath(xpathpat2) )
				pathpat = xpathpat2;
		}
	}
	if( isBoundpath(pathpat) )
		setSHARE(pathpat);
	else	ERRMSG("Not absolute path: SHARE=%s\n",pathpat);
	return 0;
}
void scan_SHARE(Connection*_,PCStr(pathpats))
{
	if( *pathpats == 0 )
		setSHARE("*");
	else	scan_commaList(pathpats,0,scanListCall shared1);
}
static void _setTMPDIR(PCStr(dir))
{	CStr(tmpdir,1024);

	if( dir == NULL )
		dir = DELEGATE_TMPDIR;
	if( dir == NULL || *dir == 0 )
		return;

	strcpy(tmpdir,dir);
	substFile(tmpdir);
	if( !fileIsdir(tmpdir) )
		mkdirRX(tmpdir);
	setTMPDIR(tmpdir);
}

static char *putDirEnv1(PVStr(buf),PCStr(name))
{	CStr(param,32);
	refQStr(ep,buf); /**/

	if( getEnv(name) == NULL )
		return 0;

	sprintf(ep,"%s=",name);
	ep += strlen(ep);
	sprintf(param,"${%s}",name);
	strcpy(ep,param);
	substfile(AVStr(ep),"",VStrNULL,VStrNULL,VStrNULL);
	if( strcmp(param,ep) == 0 )
		return 0;

	return (char*)ep + strlen(ep) + 1;
}
static const char *direnvs[] = {
	P_DGROOT,
	P_ACTDIR,
	P_ADMDIR,
	P_ETCDIR,
	P_TMPDIR,
	P_LOGDIR,
	P_VARDIR,
	P_WORKDIR,
	P_CACHEDIR,
	0
};
static int insenv(int mac,const char **ev,PCStr(estr))
{	int ei,len;
	char ec;
	const char *env1;

	for( len = 0; ec = estr[len]; len++ ){
		if( ec == '=' ){ 
			len++;
			break;
		}
	}
	for( ei = 0; env1 = ev[ei]; ei++ ){
		if( strncmp(env1,estr,len) == 0 )
			break;
	}
	if( mac-1 <= ei ){
		return -1;
	}
	ev[ei] = (char*)estr;
	return ei;
}
const char **addDirEnv(const char *const*oenv)
{	const char *env;
	const char *nenv[256]; /**/
	CStr(nenvb,4096);
	refQStr(ep,nenvb); /**/
	const char *xp;
	const char *name;
	int ei,ej,di;

	ej = 0;
	for( ei = 0; env = oenv[ei]; ei++ ){
		if( elnumof(nenv)-1 <= ej )
			break;
		nenv[ej++] = (char*)env;
	}

	for( di = 0; name = direnvs[di]; di++ ){
		if( elnumof(nenv)-1 <= ej)
			break;
		if( xp = putDirEnv1(AVStr(ep),name) ){
			nenv[ej++] = ep;
			ep = (char*)xp;
		}
	}

	sprintf(ep,"%s=%s",P_LIBPATH,DELEGATE_LIBPATH);
	substfile(AVStr(ep),"",VStrNULL,VStrNULL,VStrNULL);
	nenv[ej] = 0;
	if( insenv(256,nenv,ep) == ej )
		ej++;

	nenv[ej] = 0;
	return dupv(nenv,0);
}
int ExecSpawnvpDirenv(PCStr(what),PCStr(execpath),const char*const*av,int spawn)
{	int pid;
	const char *const*oenv;
	const char *tmpenv[1024]; /**/
	const char *e1;
	int ei,ec;

	if( direnv_environ == 0 ){
		tmpenv[0] = 0;
		direnv_environ = addDirEnv(tmpenv);
	}
	ec = 0;
	for( ei = 0; e1 = environ[ei]; ei++ ){
		if( elnumof(tmpenv)-1 <= ec ){
			break;
		}
		tmpenv[ec++] = (char*)e1;
	}
	for( ei = 0; e1 = direnv_environ[ei]; ei++ ){
		tmpenv[ec] = 0;
		if( insenv(1024,tmpenv,e1) == ec )
			ec++;
	}
	tmpenv[ec] = 0;
	oenv = (char const*const*)environ;
	environ = (char**)tmpenv;

	if( spawn ){
		pid = Spawnvp(what,execpath,av);
		environ = (char**)oenv;
		return pid;
	}else{
		Execvp(what,execpath,av);
		return -1;
	}
}
int ExecvpDirenv(PCStr(what),PCStr(execpath),const char*const*av)
{
	return ExecSpawnvpDirenv(what,execpath,av,0);
}
int SpawnvpDirenv(PCStr(what),PCStr(execpath),const char*const*av)
{	
	return ExecSpawnvpDirenv(what,execpath,av,1);
}

static const char *logfmtpart(PCStr(path))
{	const char *dp;

	if( dp = strrchr(path,':') )
		if( strchr(dp,'%') )
			return dp;
	return NULL;
}

extern int HTTP_ftpXferlog;
static void set_PROTOLOG(Connection *Conn,PCStr(proto))
{	const char *env;
	CStr(logspec,1024);
	const char *path;
	const char *fmt;
	CStr(tmp,1024);
	const char *dp;

	if( ( env = getEnv(P_PROTOLOG)) == 0 )
		env = DELEGATE_PROTOLOG;

	/*
	 *   PROTOLOG=[//host:port][/path][:format]
	 */

	strcpy(logspec,env);
	path = logspec;

	if( fmt = (char*)logfmtpart(logspec) ){
		truncVStr(fmt); fmt++;
		if( path[0] == 0 ){
			strcpy(tmp,DELEGATE_PROTOLOG);
			path = tmp;
			if( dp = logfmtpart(path) )
				truncVStr(dp);
		}
	}else	fmt = "";

	if( !BORN_SPECIALIST || isHTTP(proto) )
		LOG_create("http",LF_PROTOLOG,fmt,path,"a",1);
	if( !BORN_SPECIALIST || streq(proto,"ftp") || HTTP_ftpXferlog )
		LOG_create("ftp", LF_PROTOLOG,"-",path,"a",1);
}

void setAbortLog(PCStr(form));
int open_syslog(PCStr(url));

static void ScanLogs(Connection *Conn,PCStr(proto))
{	const char *env;

	_setTMPDIR(getEnv(P_TMPDIR));

	if( env = getEnv(P_SYSLOG) )
		open_syslog(env);

	if( ( env = getEnv(P_LOGFILE) ) == 0 )
		env = DELEGATE_LOGFILE;
	LOG_create("delegate",LF_LOGFILE,"-",env,"a",0);

	if( ( env = getEnv(P_ERRORLOG) ) == 0 )
		env = DELEGATE_ERRORLOG;
	LOG_create(LP_NOTTY,LF_ERRORLOG,"-",env,"a",0);

	if( lTRACE() ){
		if( ( env = getEnv(P_TRACELOG) ) == 0 )
			env = DELEGATE_TRACELOG;
		LOG_create(LP_NOTTY,LF_TRACELOG,"-",env,"a",0);
	}

	if( ( env = getEnv(P_ABORTLOG) ) == 0 )
		env = DELEGATE_ABORTLOG;
	setAbortLog(env);

	if( !IamPrivateMASTER && execSPECIAL == 0 ){
		set_PROTOLOG(Conn,proto);
		scanEnv(Conn,P_LOG,scan_LOG);
	}
	LOG_openall();
}

int MAXCONN_PCH;

void scan_SMTPSERVER(PCStr(smtpserver));
void scan_MIMECONV(PCStr(convspec));
void scan_SSLTUNNEL(PCStr(spec));
void scan_FILTERS(Connection *Conn);
int scan_CGIENV(Connection *Conn,PCStr(envlist));
void scan_OVERRIDE(Connection *Conn,PCStr(ovparam));
void setURICONVdefault(int force);
void downloadCCXTabs(Connection *Conn);
void getGlobalCCX(CCXP ccx,int siz);
int PERMIT_withSrc();

extern const char *DELEGATE_SMTPGATE;
int rescanGlobal;

#define ScanGlobal(Conn,proto) DELEGATE_ScanGlobal(Conn,proto)
void ScanGlobal(Connection *Conn,PCStr(proto))
{	const char *env;

	if( scannedGlobal && !rescanGlobal )
		return;
	rescanGlobal = 0;
	scannedGlobal = 1;

	if( env = getEnv(P_ADMIN ) )
		DELEGATE_ADMIN = env;
	else
	if( env = getEnv(P_MANAGER) ){
		sv1log("##DeleGate/6.X: %s should not be used. Use %s instead.\n",
			P_MANAGER,P_ADMIN);
		DELEGATE_ADMIN = env;
	}

	scanEnv(Conn,P_HOSTLIST,scan_HOSTLIST);

	scanEnv(Conn,P_TIMEOUT, scan_TIMEOUT);
	scanEnv(Conn,P_MAXIMA,  scan_MAXIMA);
	scanEnv(Conn,P_CHARCODE,scan_CHARCODE);
	scanEnv(Conn,P_CHARSET,scan_CHARCODE);
	getGlobalCCX(CCX_TOCL,CCX_SIZE); /* globalCCX to CCX_TOCL */

	if( env = getEnv(P_MIMECONV) )
		scan_MIMECONV(env);
	else
	if( getEnv(P_CHARCODE) == 0 ){
		scan_MIMECONV("thru");
		compatV5info("MIMECONV=thru is set by default. MIMECONV=\"\"");
	}

	scanEnv(Conn,P_PORT,  scan_PORT);
	scanEnv(Conn,P_VSAP,  scan_VSAP);

	scanEnv(Conn,P_SERVICE, scan_SERVICE);
	scanEnv(Conn,P_CMAP,  scan_CMAP);
	scanEnv(Conn,P_STLS,  scan_STLS);
	scanEnv(Conn,P_TLS,   scan_STLS);
	ScanLogs(Conn,proto);
	scanEnv(Conn,P_ROUTE, scan_ROUTE);
	scanEnv(Conn,P_FORWARD,scan_FORWARD);
	scanEnv(Conn,P_MASTER,scan_MASTER);
	scanEnv(Conn,P_PROXY, scan_PROXY);
	scanEnv(Conn,P_FTPTUNNEL,(scanPFUNCP)scan_FTPTUNNEL);
	if( env = getEnv(P_SSLTUNNEL) )
		scan_SSLTUNNEL(env);
	scanEnv(Conn,P_ICPCONF,scan_ICPCONF);
	scanEnv(Conn,P_ICP,   scan_ICP);

	if( env = getEnv(P_SMTPSERVER) )
		scan_SMTPSERVER(env);

	/*
	 * SERVER=socks MASTER=... SOCKS=-.- means using MASTER as SOCKS server
	 */
	if( strcaseeq(proto,"socks") ){
		if( getEnv(P_MASTER) ){
			if( getEnv(P_SOCKS) == 0 ){
				scan_SOCKS(Conn,"-.-");
			}
		}
	}
	scanEnv(Conn,P_DEST,  scan_DEST);

	NotifyPltfrmHosts(); /* initialize Notify-Platform table */
	scanEnv(Conn,P_OWNER,(scanPFUNCP)scan_OWNER);
	scanEnv(Conn,P_AUTH,scan_AUTH);
	scanEnv(Conn,P_AUTHORIZER,scan_AUTHORIZER);
	scanEnv(Conn,P_MYAUTH,scan_MYAUTH);
	scanEnv(Conn,P_PGP, (scanPFUNCP)scan_PGP);
	scanEnv(Conn,P_PAMCONF, scan_PAMCONF);

	if( env = getEnv(P_REMITTABLE) )
		scanEnv(Conn,P_REMITTABLE,scan_PERMITX);
	if( env = getEnv(P_PERMIT) )
		scanEnv(Conn,P_PERMIT,scan_PERMITX);
	if( getEnv(P_REMITTABLE) == NULL && getEnv(P_PERMIT) == NULL )
		scan_PERMIT(Conn,defaultPERMIT(Conn));
	scanEnv(Conn,P_REJECT,scan_REJECT);

	if( getEnv(P_RELIABLE) )
		scanEnv(Conn,P_RELIABLE,scan_RELIABLE);
	else{
		if( PERMIT_withSrc() == 0 )
			scan_RELIABLE(Conn,DELEGATE_RELIABLE);
		/* Allow expanding permission by PERMIT=proto:dst:extraSrcList
		 * without adding RELIABLE=extraSrcList.
		 * The default DELEGATE_RELIABLE is added to PERMIT without
		 * srcHostList.
		 * Like REMITTABLE is expanded for dstHost of MOUNT, RELIABLE
		 * could be expanded for the any srcHost in PERMIT...
		 */
	}
	scanEnv(Conn,P_REACHABLE,scan_REACHABLE);

	if( env = getEnv(P_RELAY) )
		scanEnv(Conn,P_RELAY,scan_RELAY);
	else	scan_RELAY(Conn,DELEGATE_RELAY);

	scanEnv(Conn,P_FILETYPE,(scanPFUNCP)scan_FILETYPE);
	scanEnv(Conn,P_HTTPCONF,scan_HTTPCONF);
	if( HTTP_ftpXferlog ){
		set_PROTOLOG(Conn,proto);
		LOG_openall();
	}
	scanEnv(Conn,P_NNTPCONF,scan_NNTPCONF);
	scanEnv(Conn,P_FTPCONF, scan_FTPCONF);
	scanEnv(Conn,P_DNSCONF, scan_DNSCONF);
	scanEnv(Conn,P_SOXCONF, scan_SOXCONF);
	scanEnv(Conn,P_TELNETCONF, scan_TELNETCONF);

	scanEnv(Conn,P_SMTPCONF,scan_SMTPCONF);
	if( strcaseeq(proto,"smtp") ){
		if( env = getEnv(P_SMTPGATE) )
			scan_SMTPGATE(Conn,env);
		else	scan_SMTPGATE(Conn,DELEGATE_SMTPGATE);
	}

	if( env = getEnv(P_CGIENV) )
		scan_CGIENV(Conn,env);

	if( env = getEnv(P_DELAY) )
		scanEnv(Conn,P_DELAY,scan_DELAY);

	scan_FILTERS(Conn);
	scanEnv(Conn,P_HTMLCONV,(scanPFUNCP)scan_HTMLCONV);
	scanEnv(Conn,P_URICONV,(scanPFUNCP)scan_URICONV);
	setURICONVdefault(0); /* initialize URICONV table if not set */

	/*
	if( env = getEnv(P_OVERRIDE) )	scan_OVERRIDE(Conn,env);
	*/
	scanEnv(Conn,P_CRON,scan_CRON);
	scanEnv(Conn,P_CRONS,scan_CRONS);

	downloadCCXTabs(Conn);
}
void downloadCCXTabs(Connection *Conn)
{	CStr(path,1024);
	CStr(url,1024);
	FILE *tmp,*fp;
	const char *charset;
	const char *map;

	if( getEnv(P_CHARSET) || getEnv(P_CHARCODE) )
	if( (charset = CCXcharset(CCX_TOCL)) && strcmp(charset,"UTF-8") == 0 ){
		if( 0 < UCSinit() )
			return;
		tmp = TMPFILE("CCXtab");
		if( tmp == NULL )
			return;

		map = "JIS0208.TXT";
		sprintf(url,"%s/codemap/%s",DELEGATE_homepage(),map);
		URLget(url,0,tmp); /* global CHARSET should be disabled ... */
		if( !feof(tmp) && 0 < file_size(fileno(tmp)) ){
			sprintf(path,"${LIBDIR}/%s",map);
			substFile(path);
			if( fp = dirfopen("CCXMAP",AVStr(path),"w") ){
				copyfile1(tmp,fp);
				fclose(fp);
				UCSreset();
				UCSinit();
			}
		}
		fclose(tmp);
	}
}

static void scan_HOSTS0(Connection *Conn)
{	CStr(hosts,0x10000);

	if( init_HOSTS == 0 ){
		init_HOSTS = 1;
/*
		scan_HOSTS(Conn,"localhost/127.0.0.1");
*/
		scanEnv(Conn,P_HOSTS,scan_HOSTS);
		scan_HOSTS(Conn,"localhost/127.0.0.1");
		scan_HOSTS(Conn,"localhost/__1");
		sprintf(hosts,"%s/%s",VSA_hostlocal(),VSA_hostlocaladdr());
		scan_HOSTS(Conn,hosts);
		dump_HOSTS(AVStr(hosts));
		Verbose("scanned HOSTS=%s\n",hosts);
	}
}

static void ScanEachConn(Connection *Conn)
{	const char *env;

	HAS_MASTER = getEnv(P_PROXY) || getEnv(P_MASTER) || getEnv(P_TUNNEL);

	if( env = getEnv(P_BASEURL) )
		set_BASEURL(Conn,env);

	if( env = getEnv(P_DELEGATE) )
		scan_DELEGATE(Conn,env);

	if( env = getEnv(P_OVERRIDE) )
		scan_OVERRIDE(Conn,env);
}

static int DGROOT_SUBST;
static void ScanDirDefs(Connection *Conn)
{	const char *env;
	int created;
	int scanX = inINITIALIZATION ? scanDirDefsX++ : 0;

	created = setDGROOT();
/*
	if( strstr(DELEGATE_DGROOT,"${EXECDIR}") ){
		CStr(path,1024);
		if( substEXECDIR(DELEGATE_DGROOT,AVStr(path),sizeof(path)) ){
			DELEGATE_DGROOT = stralloc(path);
			DGROOT_SUBST = 1;
		}
	}
*/
	if( getEnv(P_SHARE) )
		scanEnv(Conn,P_SHARE,scan_SHARE);
	else
	if( inINITIALIZATION && scanX == 0 )
		compatV5info("created directory/file will be non-sharable. SHARE=\"\"");

	if( created )
		chmodShared(DELEGATE_DGROOT);
	if( env = getEnv(P_LIBPATH) )
		DELEGATE_LIBPATH = stralloc(env);
	if( env = getEnv(P_DATAPATH) )
		DELEGATE_DATAPATH = stralloc(env);

	if( env = getEnv(P_VARDIR)   )	DELEGATE_VARDIR = stralloc(env);
	if( env = getEnv(P_LOGFILE)  )	DELEGATE_LOGFILE = stralloc(env);
	if( env = getEnv(P_ERRORLOG) )	DELEGATE_ERRORLOG = stralloc(env);
	if( env = getEnv(P_TRACELOG) )	DELEGATE_TRACELOG = stralloc(env);
	if( env = getEnv(P_PIDFILE)  )  DELEGATE_PIDFILE = stralloc(env);
	if( env = getEnv(P_PROTOLOG) ){
		CStr(logspec,1024);
		const char *fmt;
		if( env[0] == ':' ){
			/* PROTOLOG="[Path]:Form" - Path part is omitted */
			strcpy(logspec,DELEGATE_PROTOLOG);
			if( fmt = logfmtpart(logspec) )
				truncVStr(fmt);
			strcat(logspec,env);
			env = logspec;
		}
		DELEGATE_PROTOLOG = stralloc(env);
	}
}

void scan_CACHE(Connection *Conn,PCStr(spec));
void scan_CACHEDIR(PCStr(dirs));
void scan_CACHEFILE(PCStr(file));

static void ScanFileDefs(Connection *Conn)
{	const char *env;

	ScanDirDefs(Conn);
	if( env = getEnv("IMAGEDIR") )	DELEGATE_IMAGEDIR = stralloc(env);

	if( env = getEnv(P_CACHEDIR) )	scan_CACHEDIR(stralloc(env));
	if( env = getEnv(P_CACHEFILE))	scan_CACHEFILE(stralloc(env));
	if( env = getEnv(P_CACHE)    )	scan_CACHE(Conn,env);

	if( scannedGlobal )
	/* Resolvy must be used after it is initialized,
	 * and after socket initialization in DO_INITIALIZE in Win32
	 */
	{
	if( env = getEnv(P_EXPIRE)   )  scanEnv(Conn,P_EXPIRE,scan_EXPIRE);
	}
}

static int REUSE_ENV()
{
	return (1 < CHILD_SERNO_MULTI);
}
#define config(Conn,csock)	DELEGATE_config(Conn,csock)
void DELEGATE_configx(Connection *Conn,int force);
void config(Connection *Conn,int csock)
{
	if( REUSE_ENV() || lSYNC() ){
		Scan_SERVER(Conn);
		ScanEachConn(Conn);
		return;
	}
/*
if( env = getEnv(P_EXPIRE) )	scanEnv(Conn,P_EXPIRE,scan_EXPIRE);
- should clear dynamically added CMAP (using peak index of static CMAPs ?)
*/
	DELEGATE_configx(Conn,0);
}
void DELEGATE_configx(Connection *Conn,int force)
{	const char *proto;
	const char *env;

	if( force ){
		mount_done = 0;
	}

	scan_HOSTS0(Conn);
	proto = Scan_SERVER(Conn);

	scanEnv(Conn,P_CONNECT,scan_CONNECT);
	ScanGlobal(Conn,proto);
	ScanEachConn(Conn);
	ScanFileDefs(Conn);
	mount_all(Conn,proto);
}

int LOG_createPortFile(PCStr(file),int stayopen);
static void PutPortFile(int stayopen)
{	const char *file;

	if( (file = getEnv(P_PIDFILE)) == 0 )
		file = DELEGATE_PIDFILE;
	if( LOG_createPortFile(file,stayopen) != 0 ){
		if( lLOCK() ){
			CStr(path,1024);
			strcpy(path,file);
			substFile(path);
			fprintf(stderr,"DeleGate: could not create lock.\n");
 fprintf(stderr,"DeleGate could not start because it failed creating '%s'\n",
path);
			Finish(-1);
		}
	}
}
static void get_pidfile(PVStr(path))
{	const char *file;

	if( (file = getEnv(P_PIDFILE)) == 0 )
		file = DELEGATE_PIDFILE;
	strcpy(path,file);
	substFile(path);
}
static int killServer(PCStr(killspec),int warn)
{	CStr(signame,64);
	CStr(path,1024);
	FILE *fp;
	int sig,pid,rcode;

	get_pidfile(AVStr(path));
	if( (fp = fopen(path,"r")) == NULL ){
		if( warn )
		fprintf(stderr,"\"%s\": no active server on the port.\n",path);
		return -1;
	}

	signame[0] = 0;
	Xsscanf(killspec,"-%s",AVStr(signame));
	if( strcaseeq(signame,"HUP") ) sig = SIGHUP; else
	if( strcaseeq(signame,"INT") ) sig = SIGINT; else
	sig = SIGTERM;

	pid = 0;
	fscanf(fp,"%d",&pid);
	fclose(fp);
	printf("\"%s\": kill(%d,SIG%s) = ",path,pid,sigsym(sig));
	fflush(stdout);

	if( 1 < pid ){
		errno = 0;
		rcode = Kill(pid,sig);
		if( rcode == 0 )
			printf("%d (%d) ** OK **",rcode,errno);
		else	printf("%d (%d) ** ERROR **",rcode,errno);
	}
	printf("\n");
	return rcode;
}

static void kill_predecessor(int ac,const char *av[],PCStr(sigtype),int warn)
{	CStr(port,128);
	const char *hav[2]; /**/
	CStr(hab,128);
	const char *env;
	int hac;
	int isHUP,killed = 0;

	if( env = getEnv("HUPENV") ){
		hac = 1;
		hav[0] = hab;
		hav[1] = 0;
		sprintf(hab,"HUPENV=%s",env);
	}else{
		hav[0] = 0;
		hac = 0;
	}
	isHUP = streq(sigtype,"-hup");

	printServPort(AVStr(port),"",1);
	/*
	if( !INHERENT_fork() && strcmp(sigtype,"-hup") == 0
	 && restart_service(port,hac,hav) ){
	*/
	if( !INHERENT_fork() && isHUP && restart_service(port,hac,hav) ){
		printf("restarted service: %s\n",port);
	}else
	if( delete_service(ac,av,port,sigtype) ){
		printf("stopped service: %s\n",port);
		msleep(100);
		killed = 1;
	}else{
		/*
		killServer(sigtype,warn);
		*/
		if( killServer(sigtype,warn) == 0 )
			killed = !isHUP;
	}

	/* make sure the finish of predecessor */
	/*
	if( strcmp(sigtype,"-hup") != 0 ){
	*/
	if( killed ){
		CStr(path,1024);
		int xtry,pfd;

		get_pidfile(AVStr(path));
		for( xtry = 0; xtry < 50; xtry++ ){
			pfd = open(path,0);
			if( pfd < 0 )
				break;
			close(pfd);
			if( 0 < xtry )
			fprintf(stderr,"Waiting predecessor to exit: %s...\n",
				path);
			msleep(100);
		}
	}
}

extern int CACHE_READONLY;

static void initConn(Connection *Conn,int csock)
{
	ConnInit(Conn);
	Conn->cl.p_connected = 1;
	ClientSock = csock;
	CLsock = csock;
	Conn->ma_private = myPrivateMASTER | MASTERisPrivate;
	clear_DGconn(Conn);

	if( 0 <= csock ){
	CLIF_PORT = VA_HostPortIFclnt(Conn,csock,AVStr(CLIF_HOST),VStrNULL,NULL);
	sprintf(CLIF_HOSTPORT,"%s:%d",CLIF_HOST,CLIF_PORT);
	}else{
		/* maybe just cleaning ... */
	}

	if( CACHE_READONLY )
		DontWriteCache = 1;
}

int ipno(PVStr(path),PCStr(addr));

extern const char *DELEGATE_HOSTID;
int HostId(PCStr(addr))
{	CStr(path,2048);

	if( hostid_PATH == NULL ){
		strcpy(path,DELEGATE_HOSTID);
		substFile(path);
		setQStr(hostid_PATH,stralloc(path),strlen(path)+1);
	}
	return ipno(AVStr(hostid_PATH),addr);
}

void flush_publiclog(PCStr(route));
static void put_publiclog(PCStr(addr))
{	CStr(route,256);

	/*sprintf(route,"%d/%d",HostId(myaddr),HostId(addr));*/
	sprintf(route,"%d",HostId(addr));
	flush_publiclog(route);
}

void HL_setClientInfo(VAddr *peerhost);
void setOriginIdent(Connection *Conn,PCStr(sockname),PCStr(peername));
int set_OWNER(Connection *Conn,PCStr(host),int port,PCStr(user));

static int setClientInfo(Connection *Conn,Efd *clSock,PVStr(addr),PVStr(clntinfo))
{	int port;
	CStr(host,256);
	const char *user;

	if( VA_getClientAddr(Conn) ){
		if( (user = getClientUserC(Conn)) == NULL )
			user = "-";
		strcpy(host,Client_Host);
		VA_inetNtoah(Client_VAddr,AVStr(addr));
		port = Client_Port;
		Conn->cl_count = ClientCountUp(user,host,addr,port);
		HL_setClientInfo(Client_VAddr);
	}else{
		user = "-";
		strcpy(host,"-");
		strcpy(addr,"0.0.0.0");
		port = 0;
		Conn->cl_count = 0;
	}
	sprintf(clntinfo,"%s@[%s]%s:%d",user,addr,host,port);

	if( clSock->_remote ){
		setOriginIdent(Conn,SocknameOf(clSock),PeernameOf(clSock));
	}
	if( TeleportHost[0] )
		Xsprintf(TVStr(clntinfo),".-.%s:%d",
			TeleportHost,TeleportPort);

	daemonlog("E","(%d) accepted [%d] %s (%5.3fs)(%d)\n",
		NUM_PEERS+NUM_CHILDREN,
		getEfd(clSock),clntinfo, Time()-ACCEPT_TIME,Conn->cl_count);

	if( set_OWNER(Conn,host,port,user) < 0 )
		return -1;

	return 0;
}
void xmem_push(void *addr,int size,PCStr(what),iFUNCP func)
{
	if( SB_PROC < DGLEV ){
		mem_push(DGLEV,(char*)addr,size,what,func);
	}
}

int IsWindows95();
int have_publiclog();
static int ExecGeneralist(Connection *Conn,int fromC,int toC);
void beginGeneralist(Connection *Conn,int clsock);
void scan_condargs(Connection *Conn);
int RIDENT_recv(int clsock,PVStr(sockname),PVStr(peername));
void close_filterctls(Connection *Conn);

static void call_client1(Connection *Conn,Efd *clSock)
{	int clsock = getEfd(clSock);
	CStr(addr,512);
	CStr(clntinfo,512);
	int count;

	if( *PeernameOf(clSock) == 0 ){
		int remote;
		CStr(sockname,512);
		CStr(peername,512);

		remote = RIDENT_recv(clsock,AVStr(sockname),AVStr(peername));
		if( remote < 0 ){
			close(clsock);
			return;
		}
		setEfd(clSock,clsock,sockname,peername,remote);
	}

	if( execSPECIAL )
	sv1log(">>>>>>>> %s\n",execSPECIAL);

DGLEV = SB_CONN;
	beginGeneralist(Conn,clsock);

	ACC_REJECTED = 0;
	if( setClientInfo(Conn,clSock,AVStr(addr),AVStr(clntinfo)) == 0 ){
scan_condargs(Conn);
		if( 0 < MAXCONN_PCH && MAXCONN_PCH < Conn->cl_count ){
			ACC_REJECTED = 1;
			sv1log("Too many connections(%d) %s\n",
				Conn->cl_count,clntinfo);
		}else	ExecGeneralist(Conn,clsock,clsock);
		count = ClientCountDown();
	}else	count = -1;
mem_pops(SB_CONN);
DGLEV = SB_PROC;

	daemonlog("E","disconnected [%d] %s (%5.3fs)(%d)\n",
		clsock,clntinfo, Time()-ACCEPT_TIME,count);

	/*
	 * wait children to die if possible
	 * This seems be necessary to make the TCP connections to client
	 * be normally closed on Windows95/98 ...
	 */
	if( Conn->xf_filters ){
		int pid,wi,done;
		int nch,mask;

		close_filterctls(Conn);

		nch = 0;
		for( mask = 0; mask < 32; mask++ )
			if( (1 << mask) & Conn->xf_filters )
				nch++;

		done = 0;
		if( IsWindows95() )
		for( wi = 0; done < nch && wi < 5; wi++ ){
			while( 0 < (pid = NoHangWait()) ){
				done++;
				sv1log("CFI process [%d] done (%d/%d BEF-%d)\n",
					pid,done,nch,wi);
			}
			if( done < nch )
				msleep(100);
		}
		closeEfd(clSock);
		if( done < nch )
		for( wi = 0; done < nch && wi < 10; wi++ ){
			while( 0 < (pid = NoHangWait()) ){
				done++;
				sv1log("CFI process [%d] done (%d/%d AFT-%d)\n",
					pid,done,nch,wi);
			}
			if( done < nch )
				msleep(100);
		}
		if( done < nch )
			sv1log("CFI process remaining (%d/%d)\n",
				nch-done,nch);
	}

/* when `clsock' is closed in execGeneralist(), LOG_flushall() will reuse
 * the fd slot, then the slot will be closed in main as `clsock'.
 * Therefore call closeEfd() to avoid it... X-<
 */
	closeEfd(clSock);
	LOG_flushall();

	if( 0 <= LOG_center )
	if( have_publiclog() )
		put_publiclog(addr);
}

int func_inetd(void *Conn,int clsock);
void set_USER(Connection *Conn,int clsock);

void beginGeneralist(Connection *Conn,int clsock)
{
	START_TIME1 = time(0);
	initConn(Conn,clsock);
	if( func_inetd(Conn,clsock) )
		rescanGlobal = 1;
	config(Conn,clsock);
	if( BORN_SPECIALIST )
		set_USER(Conn,clsock);
}
void initDelegate1(Connection *Conn,int fromC,int toC)
{
	START_TIME1 = time(0);
	initConn(Conn,fromC);
	config(Conn,fromC);
}

void callDelegate1(int clsock,PCStr(imsg),PCStr(telehost),int teleport)
{	Connection ConnBuf, *Conn = &ConnBuf;

	initConn(Conn,clsock);
	config(Conn,clsock);
	DFLT_HOST[0] = 0; /* be Generalist ;-) */

	strcpy(TeleportHost,telehost);
	TeleportPort = teleport;

	if( imsg != NULL )
		DDI_pushCbuf(Conn,imsg,strlen(imsg));

	ExecGeneralist(Conn,clsock,clsock);
}

int callSelf(int clsock)
{	Connection ConnBuf, *Conn = &ConnBuf;

	initConn(Conn,clsock);
	config(Conn,clsock);
	Conn->from_myself = 1;
	return execGeneralist(Conn,clsock,clsock,-1);
}

int inShutdown(Connection *Conn,int toC);
int insert_FCLIENTS(Connection *Conn,int *fromCp,int *toCp);

static int ExecGeneralist(Connection *Conn,int fromC,int toC)
{	int fpid;
	int mypid;
	int rcode;

	if( inShutdown(Conn,toC) != 0 )
		return -1;

	mypid = getpid();
	fpid = insert_FCLIENTS(Conn,&fromC,&toC);
	rcode = execGeneralist(Conn,fromC,toC,-1);
	if( 0 < fpid ){
		if( mypid == getpid() )
			Kill(fpid,SIGTERM);
		else{
			/* can be a NNTPCC process with FFROMCL ... */
			sv1log("NNTPCC ? PID=(%d -> %d) XF=%x\n",mypid,getpid(),
				Conn->xf_filters);
			Conn->xf_filters = 0;
		}
		NoHangWait();
	}
	return rcode;
}

int put_svstat();
int gethostnameIFIF(PVStr(host),int size);

static void env2str(PVStr(seqno),int size,int svsock,Efd *clSock)
{	int logfd;
	CStr(svhost,256);
	int statfd;

	gethostnameIFIF(AVStr(svhost),sizeof(svhost));

	logfd = curLogFd();

	/* statdata as a TMPFILE may not inherited to grand child on Win32 */
	if( iamServer() )
		statfd = put_svstat();
	else	statfd = -1;

snprintf((char*)seqno,size,
"%x/%d/%d/%d/%d/%d/%d/%d/%d/%d,%d/%d/%d/%d/%d/%d/%d/%d/%d/%d,%s/%s/%s/",
		deleGateId,
		SERVER_PORT(),
		ServerPID,
		IamPrivateMASTER,
		svsock,
		param_file,
		clSock->_fd,
		TOTAL_SERVED,
		SERNO(),
		NUM_CHILDREN,

		StickyReport[1],
		DELEGATE_LINGER,
		logfd,
		LOG_type,
		statfd,
		ekeyFd,
		myPrivateMASTER,
		AF_UNIX_DISABLE,
		RES_localdns,
		clSock->_remote,

		svhost,
		SocknameOf(clSock),
		PeernameOf(clSock)
	);
}

int ViaVSAPassociator(int sock);
int DELEGATE_copyEnv(int mac,const char *av[],int ac,PCStr(path),PVStr(abuff));
void sendReservedPorts();

static int EXEC_client1(Connection *Conn,PCStr(path),PCStr(func),int svsock,Efd *clSock)
{	int clsock = getEfd(clSock);
	CStr(from,1024);
	CStr(seqno,256);
	CStr(stime,32);
	CStr(alive,32);
	CStr(abuff,MAX_ARGB);
	const char *av[MAX_ARGC]; /**/
	CStr(logtype,32);
	int ac,ai;
	int port;
	int rcode;
	const char *cpath;
	int pid;
	int pass_svsock;

	pass_svsock = func != NULL &&
		(  streq(func,FuncSTICKY) && !ViaVSAPassociator(-1)
		|| streq(func,FuncFunc) );

	env2str(AVStr(seqno),sizeof(seqno),svsock,clSock);
	sendReservedPorts();
	Verbose("SEQNO: %s\n",seqno);

	ac = 0;
	av[ac++] = (char*)DeleGate1;
	av[ac++] = seqno;
	if( func != NULL ){
		av[ac++] = (char*)func;
	}else{
		scan_HOSTS0(Conn);
		strcpy(from,"src=");

/* getpeerName(clsock,from+4,PN_HOSTPORT); */
Conn->cl.p_connected = 1;
ClientSock = clsock;
if( port = getClientHostPort(Conn,QVStr(from+4,from)) )
Xsprintf(TVStr(from),":%d",port);

		Verbose("%s\n",from);
		av[ac++] = from;
	}

	sprintf(stime,"%s=%d",P_START_TIME,START_TIME);
	av[ac++] = stime;
	sprintf(alive,"%s=%d",P_ALIVE_PEERS,NUM_CHILDREN);
	av[ac++] = alive;
	ac = DELEGATE_copyEnv(MAX_ARGC-1,av,ac,path,AVStr(abuff));
	sprintf(logtype,"-L0x%x/%d",LOG_type,curLogFd());
	av[ac++] = logtype;
	av[ac] = 0;

	if( func != NULL && streq(func,FuncFunc) ){
		for( ai = 0; ai < ac; ai++ ){
			if( strncmp(av[ai],"-F",2) == 0 ){
				ac = ai;
				av[ac] = 0;
				break;
			}
		}
	}

	if( !INHERENT_fork() ){
		setclientsock(clsock);
		if( pass_svsock )
			setserversock(svsock);
		return Spawnvp("EXEC_client1",path,av);
	}else{
		if( !pass_svsock )
			closeServPorts();
		Execvp("EXEC_client1",path,av);
		return -1;
	}
}

static void idleTIMEOUT()
{
	longjmp(exec_env,-1);
}
void setTimeout()
{
	setTimer(idle_timer,IDLE_TIMEOUT);
}
static void EXEC_client(Connection *Conn,PCStr(path),PCStr(func),Efd *clSock)
{
	idle_timer = pushTimer("EXEC_client",(vfuncp)idleTIMEOUT,0);
	if( setjmp(exec_env) == 0 ){
		if( lSYNC() ){
			call_client1(Conn,clSock);
		}else
		if( !lEXEC() && func == NULL ){
			call_client1(Conn,clSock);
		}else	EXEC_client1(Conn,path,func,-1,clSock);
		closedups(0);
	}else{
		sv1log("TIMEOUT of idling.\n");
	}
	popTimer(idle_timer);
}

/*
 *	fork private MASTER if MASTER is not specified.
 *	this will be used for caching on {Gopher,FTP}/HTTP,
 *	and Connection Cache.
 */
int DELEGATE_copyEnvPM(int mac,const char *dav[],PCStr(name));
static int fork_MASTER(PVStr(hostport),int frominetd)
{	int svsock;
	int svport;
	CStr(svhost,256);
	const char *av[MAX_ARGC]; /**/
	int ai,ac;
	register int pid;
	const char *env;
	CStr(logtype,32);
	CStr(logfile,1024);
	CStr(port,128);
	CStr(oport,128);
	CStr(what,128);
	CStr(master,1024);
	CStr(permit,128);
	const char *name;
	CStr(epath,1024);
	int closestdIO;

	svhost[0] = 0;
	svport = 0;
	Xsscanf(hostport,"%[^:]:%d",AVStr(svhost),&svport);
	if( svhost[0] == 0 )
		GetHostname(AVStr(svhost),sizeof(svhost));
	svsock = server_open("delegate",AVStr(svhost),svport,1);
	if( svsock < 0 )
		return -1;

	svport = sockPort(svsock);
	sprintf(hostport,"%s:%d",svhost,svport);

	printServPort(AVStr(oport),"",0);

	ac = 0;
	if( name = strrpbrk(EXEC_PATH,"/\\") )
		name = name + 1;
	else	name = EXEC_PATH;
	av[ac++] = name;

	sprintf(what,"%s%s)",PrivateMasterOwner,oport);
	av[ac++] = what;
	sprintf(port,"-P0/%d",svsock);
	av[ac++] = port; 

	sprintf(logtype,"-L0x%x",LOG_type);
	av[ac++] = logtype;
	sprintf(logfile,"%s=%s++",P_LOGFILE,oport);
	av[ac++] = logfile; 

	ac += DELEGATE_copyEnvPM(MAX_ARGC-ac,&av[ac],NULL);

	if( getEnv(P_MASTERP) )
		ac += DELEGATE_copyEnvPM(MAX_ARGC-ac,&av[ac],P_MASTER);

	sprintf(permit,"%s=*:*:{.,localhost}",P_PERMIT);
	av[ac++] = permit;
	sprintf(epath,"%s=%s",P_EXEC_PATH,EXEC_PATH);
	av[ac++] = epath;
	av[ac] = 0;

	if( closestdIO = frominetd || IamCGI ){
		sv1log("## private-MASTER: frominetd=%d IamCGI=%d (%d,%d,%d)\n",
			frominetd,IamCGI,
			fileno(stdin),fileno(stdout),fileno(stderr));
	}

	if( !INHERENT_fork() ){
		if( closestdIO ){
			av[ac++] = "CLOSE-STDIO";
			av[ac] = 0;
		}
		setserversock(svsock);
		pid = Spawnvp("fork_MASTER",EXEC_PATH,av);
	}else{
		pid = Fork("private-MASTER");
		if( pid == 0 ){
			LOG_closeall();
			if( closestdIO ){
				fclose(stdin);
				fclose(stdout);
				fclose(stderr);
			}
			closeServPorts();
			Execvp("fork_MASTER",EXEC_PATH,av);
		}
	}
	close(svsock);
	return pid;
}

static int unsetEnv(int mac,const char *dav[],const char *const sav[],PCStr(what))
{	const char *arg;
	int len,ai,ac;

	len = strlen(what);
	ac = 0;
	for( ai = 0; sav[ai]; ai++ ){
		if( dav != sav )
		if( mac <= ac )
			break;
		arg = sav[ai];
		if( strncmp(arg,what,len) == 0 )
			if( arg[len] == '=' || arg[len] == 0 )
				continue;
		dav[ac++] = (char*)arg;
	}
	dav[ac] = 0;
	return ac;
}

/*
 * Using private-MASTER even when connecting to HTTP might be
 * useful to control connection cache and keep-alive...
 */
static int filterEnv(int mac,const char *dav[],const char *sav[])
{	const char *arg;
	int ai,ac;

	ac = 0;
	for( ai = 0; sav[ai]; ai++ ){
		if( dav != sav )
		if( mac <= ac )
			break;
		arg = sav[ai];
		/* CONNECT and MASTER must be used in the private-MASTER. */
		if( strncmp(arg,"CONNECT=",8) == 0 ) continue;
		if( strncmp(arg,"MASTER=",7) == 0 ) continue;
		/* not to repeat execWithPrivateMASTER() */
		if( strncmp(arg,"MASTERP=",8) == 0 ) continue;
		/* -P with socket fd is set */
		if( strncmp(arg,"-P",2) == 0 ) continue;
		dav[ac++] = sav[ai];
	}
	dav[ac] = 0;
	return ac;
}
static void execWithPrivateMaster(Connection *Conn,PCStr(MasterP),int frominetd)
{	const char *av[MAX_ARGC]; /**/
	CStr(port,128);
	CStr(master,128);
	CStr(masterp,128);
	CStr(hostport,256);
	int ac;

	strcpy(hostport,MasterP);
	myPrivateMASTER = fork_MASTER(AVStr(hostport),frominetd);
	if( myPrivateMASTER == 0 )
		return;

	ac = 0;
	if( 1 <= main_argc )
		av[ac++] = main_argv[0];
	av[ac++] = port; printServPort(AVStr(port),"-P",1);
	av[ac++] = master; sprintf(master,"%s=%s",P_MASTER,hostport);
	av[ac++] = masterp; sprintf(masterp,"_masterp=%d",myPrivateMASTER);

	filterEnv(elnumof(av)-ac,&av[ac],&main_argv[1]);
	filterEnv(0,(const char**)environ,(const char**)environ);

	if( !INHERENT_fork() ){
		setserversock(ServSock());
		Spawnvp("with-private-MASTER",EXEC_PATH,av);
		ServerPID = 0;
		closeServPorts();
		wait(0);
	}else{
		Execvp("with-private-MASTER",EXEC_PATH,av);
	}
	sv1log("private-MASTER forked: %s [%d]\n",hostport,myPrivateMASTER);
}

static void finalize()
{
	killChildren();
	StickyKill(SIGHUPTERM);
	kill_CC();
	deleteWORKDIR();
}

int killchildren();
void closeReservedPorts();
static void _TERMINATE()
{
	terminating = 1;
	sv1log("TERMINATE...\n");
	dumpCKey(0);
	/*
	doing it here activates PollIn in main thread then termination
	(removing PortFile for -r restart) might not be completed successfully
	closeServPorts();
	*/
	finalize();
	LOG_deletePortFile();
	cleanup_zombis(0);
	if( !inSIGHUP ){
	/* can be Killpg(), don't kill processes to inherit sockets on Win32 */
	killchildren();
	}
	closeReservedPorts();
	closeServPorts();
	sv1log("TERMINATED.\n");
}
void (*DELEGATE_TERMINATE)() = _TERMINATE;

#define ACC_FAILED	-1
#define ACC_TIMEOUTED	-2

static void _main(int ac,const char *av[]);
static int _start(int ac,const char *av[])
{ 
	_main(ac,av);
	sv1log("_main() done\n");
	return 0;
}
int (*DELEGATE_MAIN)(int ac,const char *av[]) = _start;

static void sigALRM(int sig)
{
	sv1log("AcceptByMain: Frozen (%s) ? try restart...\n",ABMwhere);
	sigHUP(0);
	Finish(-1);
}

/* do substitution for ${xxx} like ${VARDIR} ? */
const char *absPathParam(PCStr(param),PCStr(prefix))
{	CStr(name,128);
	const char *vp;
	const char *rpath;
	CStr(apath,2048);
	const char *dp;
	CStr(xparam,2048);
	int nonexist;

	if( (vp = strchr(param,'=')) == 0 )
		return 0;
	Xsscanf(param,"%[^=]",AVStr(name));
	rpath = vp + 1;
	if( *rpath == 0 )
		return 0;

	if( isFullpath(rpath) )
		return 0;

	{	CStr(cwd,1024);
		const char *PATHSEP = "/";
		getcwd(cwd,sizeof(cwd));
		sprintf(apath,"%s%s%s",cwd,PATHSEP,rpath);
	}

	sprintf(xparam,"%s%s=%s",prefix,name,apath);
	if( nonexist = !File_is(apath) ){
		if( dp = strpbrk(apath," \t") ){
			truncVStr(dp);
			nonexist = !File_is(apath);
		}
		if( nonexist )
			fprintf(stderr,"CAUTION: nonexistent \"%s\"\n",xparam);
	}
	return stralloc(xparam);
}
void substArgvAbstpath(int ac,const char *av[])
{	int ai;
	const char *a1;
	const char *xa;

	for( ai = 0; ai < ac; ai++ ){
		a1 = av[ai];
		if( strchr(a1,'=') == 0 )
			continue;
		xa = 0;
		if( strncmp(a1,  "+/",2) == 0 ) xa = absPathParam(a1+2,""); else
		if( strncmp(a1,"-e+/",4) == 0 ) xa = absPathParam(a1+4,"-e");
		if( xa )
			av[ai] = (char*)xa;
	}
}
static void setSTARTDIR()
{	CStr(cwd,1024);

	if( getenv("STARTDIR") )
		return;

	*cwd = 0;
	getcwd(cwd,sizeof(cwd));
	if( *cwd != 0 )
		PutEnv("STARTDIR",cwd);
}
static void setLIBPATH()
{	CStr(libpath,1024);

	if( getenv(P_LIBPATH) )
		return;

	lineScan(DELEGATE_LIBPATH,libpath);
	substFile(libpath);
	PutEnv(P_LIBPATH,libpath);
}

extern const char *BINSHELL;
static void setBINSHELL()
{	const char *sh;
	CStr(path,1024);

	sh = getenv("BINSHELL");
	if( sh == NULL ){
		if( curCHROOT[0] == 0 )
			return;
		sh = "sh";
	}

	if( fullpathCOM(sh,"r",AVStr(path)) ){
		if( strcmp(BINSHELL,path) != 0 ){
			BINSHELL = stralloc(path);
		}
	}
	if( !isFullpath(BINSHELL) ){
		BINSHELL = "/bin/sh";
	}
}

static void putDGROOT(PVStr(dgmsg));
static void noargs()
{	CStr(yn,128);
	CStr(dgmsg,1024);

	put_identification(stderr);

	setDGROOT();
	putDGROOT(AVStr(dgmsg));
	fprintf(stderr,"--\r\n%s",dgmsg);

	fprintf(stderr,"Do configuration ? y / [n] : ");
	fflush(stderr);
	fgets(yn,sizeof(yn),stdin);
	if( yn[0] != 'y' && yn[0] != 'Y' )
		exit(0);

	fprintf(stderr,"-------------------------\n");
	fprintf(stderr,"INTERACTIVE CONFIGURATION\n");
	fprintf(stderr,"-------------------------\n");
	fprintf(stderr,"## see http://www.delegate.org/delegate/tutorial/\n");
}
static void scan_DELEGATE_ARGS()
{	const char *dgargs;
	const char *dgav[128]; /**/
	CStr(dgargb,1024);
	int dgac,dgai;

	if( dgargs = getenv("DELEGATE_ARGS") ){
		sv1log("DELEGATE_ARGS=%s\n",dgargs);
		dgac = decomp_args(dgav,128,dgargs,AVStr(dgargb));
		scan_args(dgac,dgav);
	}
}
static void set_eRESTART(int rtime){
	CStr(reason,128);
	refQStr(rp,reason); /**/
	reason[0] = 0;

	if( RESOLV_UNKNOWN ){
		sprintf(rp,"(%d unknown host)",RESOLV_UNKNOWN);
		rp += strlen(rp);
	}
	if( SCRIPT_UNKNOWN ){
		sprintf(rp,"(%d unknown script)",SCRIPT_UNKNOWN);
		rp += strlen(rp);
	}
	sv1log("eRESTART in %d sec %s config err.\n",rtime,reason);
}

void copyFileAndStat(PCStr(src),PCStr(dst))
{	FILE *sfp,*dfp;
	CStr(xnew,1024);
	CStr(sav,1024);
	CStr(dir,1024);
	const char *dp;

	lineScan(dst,dir);
	if( dp = strrchr(dir,'/') ){
		truncVStr(dp);
		if( !File_is(dir) ){
			mkdirRX(dir);
		}
	}

	if( File_isreg(src) ){
		if( sfp = fopen(src,"r") ){
			sprintf(xnew,"%s-new",dst);
			if( dfp = fopen(xnew,"w") ){
				copyfile1(sfp,dfp);
				fclose(dfp);
				File_copymod(src,xnew);
			fprintf(stderr,"#### copied %s to %s\n",src,dst);
			}else{
				fprintf(stderr,"#### cannot open %s\n",dst);
			}
			fclose(sfp);
			if( File_is(dst) ){
				sprintf(sav,"%s-old",dst);
				rename(dst,sav);
			}
			rename(xnew,dst);
		}
	}else{
		CStr(path,1024);
		if( fullpathSUCOM("dgcpnod","r",AVStr(path)) == 0 ){
			fprintf(stderr,"#### ERROR: %s not found.\n","dgcpnod");
		}else{
			if( fork() == 0 ){
				execlp(path,path,src,dst,NULL);
				exit(0);
			}
			wait(0);
		}
	}
}

static const char *sysfiles[] = {
	"/etc/resolv.conf",
	"/etc/localtime",
	"/etc/nsswitch.conf",
	"/etc/hosts",
	"/etc/passwd",
	"/dev/null",
	"/dev/urandom",
	0
};
static void copy_sysfiles(PCStr(rootpath))
{	const char *file;
	CStr(dgpath,1024);
	int fi;

	for( fi = 0; file = sysfiles[fi]; fi++ ){
		sprintf(dgpath,"%s/%s",rootpath,file);
		if( File_is(dgpath) == 0 )
			copyFileAndStat(file,dgpath);
	}
}

#define OLDCHROOT	"--CHROOT."
int Chroot(PCStr(rootpath),int ac,const char *av[])
{	int rcode,off,ai,nac;
	const char *nav[MAX_ARGC]; /**/
	CStr(xcompath,1024);
	CStr(dgrpath,1024);
	CStr(dgpath,1024);
	CStr(sdgpath,1024);
	CStr(chrootok,1024);
	const char *env;
	int withDGROOT,setDGROOT;
	int ei,ec;
	const char *dgd;
	CStr(me,256);
	CStr(hosts,256);
	CStr(path,4096);

	setDGROOT = 0;
	if( *rootpath == 0 || strcmp(rootpath,"/") == 0 ){
		/* DGROOT=/path + CHROOT=/ -> CHROOT=/path + DGROOT=/ */
		rootpath = DELEGATE_DGROOT;
		setDGROOT = 1;
	}

	for( ai = 0; ai < ac; ai++ ){
		if( strncmp(av[ai],OLDCHROOT,strlen(OLDCHROOT)) == 0 ){
			goto CHROOT_OK;
		}
	}
	rcode = chroot(rootpath);
	if( rcode == 0 )
		goto CHROOT_OK;

	if( fullpathSUCOM("dgchroot","r",AVStr(xcompath)) == 0 ){
		fprintf(stderr,"ERROR: %s not found\n","dgchroot");
		exit(-1);
	}

	if( env = getenv("PATH") ){
		strcpy(path,"PATH=subin:");
		linescanX(env,TVStr(path),sizeof(path)-strlen(path));
		putenv(stralloc(path));
	}

	copy_sysfiles(rootpath);

	if( dgd = strrpbrk(av[0],"/\\") )
		dgd++;
	else	dgd = av[0];
	sprintf(dgrpath,"subin/%s",dgd);
	if( fullpathLIB(av[0],"r",AVStr(sdgpath)) == 0 )
	if( fullpathCOM(av[0],"r",AVStr(sdgpath)) == 0 ){
		fprintf(stderr,"ERROR: %s not found\n",av[0]);
		exit(-1);
	}
	sprintf(dgpath,"%s/%s",rootpath,dgrpath);
	if( File_is(dgpath) == 0 
	 || File_mtime(dgpath) != File_mtime(sdgpath) ){
		copyFileAndStat(sdgpath,dgpath);
	}

	withDGROOT = 0;
	nac = 0;
	nav[nac++] = xcompath;
	nav[nac++] = (char*)rootpath;
	nav[nac++] = dgrpath; /* exec path */
	nav[nac++] = dgrpath; /* av[0] */
	for( ai = 1; ai < ac; ai++ ){
		if( strncmp(av[ai],"CHROOT=",7) == 0 ){
			continue;
		}
		if( strncmp(av[ai],"DGROOT=",7) == 0 ){
			if( setDGROOT ){
 fprintf(stderr,"#### ignore original DGROOT\n");
				continue;
			}
			withDGROOT = 1;
		}
		if( elnumof(nav)-4 <= nac ){
			break;
		}
		nav[nac++] = av[ai];
	}
	if( withDGROOT == 0 ){
		nav[nac++] = "DGROOT=/";
	}
	sprintf(chrootok,"%s%s",OLDCHROOT,rootpath);
	nav[nac++] = chrootok;

	gethostname(me,sizeof(me));
	strcpy(hosts,"HOSTS=");
	make_HOSTS(TVStr(hosts),me,0);
	nav[nac++] = hosts;
	nav[nac] = 0;

	ec = 0;
	for( ei = 0; env = environ[ei]; ei++ ){
		if( strncmp(env,"CHROOT=",7) == 0 ){
			continue;
		}
		if( ei != ec ){
			environ[ec] = environ[ei];
		}
		ec++;
	}
	if( ei != ec )
		environ[ec] = 0;

	execvp(xcompath,(char*const*)nav);
	fprintf(stderr,"ERROR: failed %s for CHROOT=%s, errno=%d\n",
		xcompath,rootpath,errno);
	exit(-1);

CHROOT_OK:
	if( setDGROOT ){
		DELEGATE_DGROOT = "/";
	}
	return 0;
}

const char *DeleGateId(){
	static CStr(id,32);
	CStr(key,128);
	CStr(port,128);
	CStr(uniq,128);

	if( deleGateId == 0 ){
		NonceKey(AVStr(key));
		printPrimaryPort(AVStr(port));
		sprintf(uniq,"%s.%s",key,port);
		deleGateId = strCRC32(uniq,strlen(uniq));
	}
	sprintf(id,"DG%08x",deleGateId);
	return id;
}
/*
 * make the key be shared by the children, in a temporary file
 */
void setCKey(PCStr(ekey),int elen)
{	CStr(skey,64);
	CStr(epass,128);
	int len,wcc;
	FILE *cfp;

	if( 0 <= ekeyFd ){
		cfp = fdopen(ekeyFd,"r+");
		fseek(cfp,0,0);
	}else{
		cfp = TMPFILE("CRYPT");
		ekeyFd = fileno(cfp);
		clearCloseOnExec(ekeyFd);
	}
	/*
	sprintf(skey,"%x.%d.%d",setCKey,serverPid(),file_ino(ekeyFd));
	serverPid() changes before and after beDaemin()
	*/
	sprintf(skey,"%x.%d",setCKey,file_ino(ekeyFd));
	aencrypty(skey,strlen(skey),ekey,elen,epass);
	wcc = fwrite(epass,1,strlen(epass),cfp);
	fflush(cfp);
	fcloseFILE(cfp);
}
int getCKey(PVStr(ekey),int ksiz)
{	CStr(skey,64);
	CStr(epass,128);
	int klen,len;

	if( ekeyFd < 0 ){
		setVStrEnd(ekey,0);
		return 0;
	}
	Lseek(ekeyFd,0,0);
	klen = read(ekeyFd,epass,sizeof(epass));
	if( klen <= 0 )
		return 0;

	setVStrEnd(epass,klen);
	/*
	sprintf(skey,"%x.%d.%d",setCKey,serverPid(),file_ino(ekeyFd));
	*/
	sprintf(skey,"%x.%d",setCKey,file_ino(ekeyFd));
	len = adecrypty(skey,strlen(skey),epass,klen,(char*)ekey);
	return len;
}
void dumpCKeyPath(PVStr(path))
{	CStr(ports,256);
	CStr(md5,64);

	if( privateDGAuth )
		strcpy(ports,"P0");
	else	printServPort(AVStr(ports),"P",0);
	toMD5(ports,md5);
	sprintf(path,"${ADMDIR}/authorizer/%s/save/%s",md5,DGAUTHdom);
	substFile(path);
	path_escchar(AVStr(ports));
}

int newPath(PVStr(path))
{	int len;

	if( File_is(path) )
		return 0;
	if( curCHROOT[0] == 0 )
		return 0;

	len = strlen(curCHROOT);
	if( strncmp(path,curCHROOT,len) == 0 ){
		if( File_is(path+len) ){
			ovstrcpy((char*)path,path+len);
			return 1;
		}
	}
	return -1;
}

void minits();
void syslog_init();
void DO_INITIALIZE(int ac,const char *av[]);
void DO_STARTUP(int ac,const char *av[]);
void set_textconvCTX(Connection *Conn);

static void delegate_main(int ac,const char *av[])
{	Connection MainConn;
	int code;
	const char *root;
	int ai;

	minits();
	mainConn = &MainConn; set_textconvCTX(mainConn);

	setSTARTDIR();

	main_argc = ac;
	main_argv = dupv(av,0);
	LOG_stdlogfile = logfile;
	LOG_substfile  = substfile;
	syslog_init();
	loadDefaultConf();

	for( ai = 0; ai < ac; ai++ ){
		if( strncmp(av[ai],OLDCHROOT,strlen(OLDCHROOT)) == 0 ){
			lineScan(av[ai]+9,curCHROOT);
 fprintf(stderr,"#### save CHROOT=%s\n",curCHROOT);
		}
	}

	if( streq(av[0],DeleGate1) )
	/* setup the logging environment inherited via spawn() */
	{	int lfd;
		const char *env;
		int ai;
		/*
		if( 1 < ac && strncmp(av[ac-1],"-L0x",4) == 0 ){
			sscanf(&av[ac-1][4],"%x/%d",&LOG_type,&lfd);
		*/
		for( ai = ac-1; 0 < ai; ai-- ){
		    if( strncmp(av[ai],"-L0x",4) == 0 ){
			lfd = -1;
			sscanf(&av[ai][4],"%x/%d",&LOG_type,&lfd);
			if( 0 <= lfd )
			fdopenLogFile(lfd);
			break;
		    }
		}
		LOG_type |= L_ISCHILD;
		if( env = getEnv(P_RES_DEBUG) )
			RES_debug(env);
		if( LOG_type & L_RAND_TRACE )
			RAND_TRACE = 1;
	}
	DO_STARTUP(ac,av); /* setup sessionfd() and WSAstartup() on Win32.
	 * It must be done as immediate as possible after invocation,
	 * not to let wait the parent DeleGate to finish spawn procedure, and
	 * not to use DNS (which may take seconds, use socket)
	 * before it is initizlied...
	 */

	substArgvAbstpath(ac,av);
	ScanFileDefs(mainConn);

	if( getEnv(P_DYLIB) ){
		scan_DYLIB(getEnv(P_DYLIB));
		/* and do link before chroot() ? */
	}

	if( root = getEnv(P_CHROOT) ){
		if( Chroot(root,ac,av) != 0 ){
			fprintf(stderr,"DeleGate: chroot(%s) failed.\n",root);
			exit(-1);
		}
	}

	DO_INITIALIZE(ac,av);
	if( terminating ){
		/* a service on Win, started and terminated in DO_INITIALIZE */
		Finish(0);
	}
	(*DELEGATE_MAIN)(ac,av);
	Finish(0);
}

void gotoWORKDIR();
void mainProcTitle(Connection *Conn);
void Exec_client(Connection *Conn,int ac,const char *av[]);
void setStickyParams(Connection *Conn,PCStr(proto));
void setTeleportMASTER(Connection *Conn);
int execOnetimeFilter(Connection *Conn,Efd *clSock);
static void putREADY(int isafilter,int istunnel1);
static int AcceptByMain(Connection *Conn,int timeout,int *svsockp,Efd *clSock);
int forkOnetimeServer(Connection *Conn,int svsock,Efd *clSock,int isafilter);
int forkStickyServer(Connection *Conn,int svsock,Efd *clSock);
void setLOGCENTER(PCStr(center));
void setEXEC_PATH();
void putSTART(PCStr(what),int frominetd);
int logTimeout();
void load_params(Connection *Conn);
int pollServPort(int timeout,int *rsockv,int *udpv,int *optv);
void dumpHTMLCONV();
void RshWatcher(int ninvoke,int port);
void udp_relayX(Connection *Conn,int csc,int csv[]);
int getServPorts(int sc,int sv[]);
int sox_main(int ac,const char *av[],Connection *ctx,int svsock,int svport);
int service_domain(Connection *Conn,int sock,int port);
void dns_init();
int service_icp(Connection *Conn,int sock,int port);
int service_cuseeme(Connection *Conn,int svsock,int myport);
int TeleportServer(PCStr(tunnel),PCStr(invites));
int checkDGAuthConfig();
int set_Owner(int real,PCStr(aowner),int file);
void makeEntrance();
void setServUDP();
void setSERVER_PORT(PCStr(host),int port,int sock);
int activeServPort();
int withDGAuth(Connection *Conn);
void scan_CRYPT(Connection *Conn,int clnt);
void init_resolv(PCStr(resolv),PCStr(conf),PCStr(ns),PCStr(types),PCStr(verify),PCStr(rr),PCStr(debug),PCStr(log));
void inetdServPort();
int authRsh();
int fromRsh();
int fromInetd();
void new_param_file(PCStr(path));
FILE *new_shared();
void reopenLogFile();
void scan_DGPATH(PCStr(path));
void editconf1(int *acp,const char **avp[],FILE *in,FILE *out);
int DELEGATE_subfunc(Connection*Conn,int ac,const char *av[],PCStr(func),int _Fopt,int type);

static void _main(int ac,const char *av[])
{	FILE *fp;
	int clsock;
	Efd *clSock = clientSocks;
	register int pid;
	const char *name;
	const char *func;
	const char *ext;
	const char *env;
	const char *proto;
	Connection *Conn = mainConn;
	int xcode;
	int frominetd,isafilter,isteleportd;
	int issockmux;
	int istunnel1;
	int cnt;
	int restart;
	int reinit = 0;
	int IamServer;
	int ai;
	int isDaemon = 0;
	int OPTSscan = 0;
	int withDGA;

	if( main_argc == 1 && 1 < ac ){
		/* started as a service on Windows, main() receives no
		 * arguments, then _main() receives real arguments via
		 * the ServiceStart. Thus DGROOT which was initialized
		 * in delegate_main() must be reinitialized here after. 
		 */
		DELEGATE_DGROOT = "";
		isDaemon = 1;
	}
	main_argc = ac;
	main_argv = dupv(av,0);

	ACCEPT_TIME = Time();
	signal(SIGHUP,SIG_IGN);

	if( isFullpath(av[0]) )
		strcpy(EXEC_PATH,av[0]);
	else	wordscanX(av[0],AVStr(EXEC_PATH),1024);

	/* set LIBPATH for library.a (ex. JIS.c)
	 * this must be done after EXEC_PATH is set.
	 */
	setLIBPATH();
	setBINSHELL();

	if( name = strrpbrk(EXEC_PATH,"/\\") )
		name = name + 1;
	else	name = EXEC_PATH;

	istunnel1 = 0;
	if( (func = getEnv(P_FUNC)) == 0 )
		func = name;
	for( ai = 1; ai < ac; ai++ ){
		if( strncmp(av[ai],"-F",2) == 0 ){
			func = &av[ai][2];
			Fopt = ai;
		}else
		if( strncmp(av[ai],"SERVER=tunnel1",14) == 0 ){
			istunnel1 = 1;
		}
	}

	if( (ext = strcasestr(func,".exe")) && ext[4] == 0 ){
		func = StrAlloc(func);
		*strcasestr(func,".exe") = 0;
	}

	if( strstr(func,"cgi") )
		IamCGI = 1;

	START_TIME1 = time(0);

	if( strncmp(func,"kill",4) == 0 ){
		scan_args(ac,av);
		kill_predecessor(ac,av,func+4,1);
		Finish(0);
	}

	ConnInit(Conn); /* set RPORTsock=-1 before -Ffunc */
	dont_check_param = 1;
	isFunc = DELEGATE_subfunc(Conn,ac,av,func,Fopt,0);
	dont_check_param = 0;

	frominetd = fromInetd();
	isafilter = 0;
	isteleportd = streq(func,"teleportd");
	issockmux = strcaseeq(func,"sockmux");
	IamPrivateMASTER = 0;

	if( SERVER_PORT() == 0 )
	if( !isFunc && !isteleportd )
	if( ac < 2 && !frominetd && !IamCGI ){
		noargs();
		editconf1(&ac,&av,stdin,stderr);
	}

	if( IamCGI ){
		setEXEC_PATH();
		if( env = getEnv(P_DGPATH) )
			DELEGATE_DGPATH = env;
		scan_DGPATH(DELEGATE_DGPATH);
		ac = scan_args(ac,av);
	}

	/*
	if( !isFunc || isteleportd )
	*/
	if( !isFunc || isteleportd || issockmux )
	if( !IamCGI )
	if( !streq(EXEC_PATH,DeleGate1) ) /* is the parent delegated */
	{
		ERROR_RESTART = 0;

		setEXEC_PATH();
		if( env = getEnv(P_DGPATH) )
			DELEGATE_DGPATH = env;
		scan_DGPATH(DELEGATE_DGPATH);

		ac = scan_args(ac,av);
		scan_DELEGATE_ARGS();

		scanEnv(Conn,P_DGOPTS,scan_DGOPTS); /* for DGOPTS=-r */
		OPTSscan = 1;

		if( ME.me_restart ){
			kill_predecessor(ac,av,"",0);
			ME.me_restart = 0;
		}

		reopenLogFile(); /* reopen LOGFILE with a proper PORT number */

		_setTMPDIR(getEnv(P_TMPDIR));
		if( !IamPrivateMASTER ){
			new_shared();
			if( env = getEnv(P_INPARAM) )
				new_param_file(env);

			if( !frominetd ){
				if( fromRsh() ){
					if( authRsh() != 0 )
						Finish(-1);
				}
			}
			if( istunnel1 ){
				setTeleportMASTER(Conn);
			}
			if( frominetd ){
				isafilter = 1;
				inetdServPort();
			}
		}
	}
	if( OPTSscan == 0 )
	scanEnv(Conn,P_DGOPTS,scan_DGOPTS);

	if( getEnv(P_INETD) ){
		scanEnv(Conn,P_INETD,scan_INETD);
		/* "port stream tcp nowait owner SERVER=exec XFIL=... */
		/* "port stream tcp nowait owner SERVER=exec XCOM=... */
		/* "port stream tcp wait owner SERVER=... */
		/* PollIns(ports) */
		/* wait -- don't accept, just exec */
		/* nowait -- accept and exec */
	}

/*
	set_LOCKFILE();
*/
	scan_HOSTS0(Conn); /* gethostname() and "localhost" for init_myname() */
	init_resolv(getEnv(P_RESOLV),
		getEnv(P_RES_CONF),getEnv(P_RES_NS),
		getEnv(P_RES_AF),getEnv(P_RES_VRFY),
		getEnv(P_RES_RR),getEnv(P_RES_DEBUG),getEnv(P_RES_LOG));
	scanEnv(Conn,P_SOCKOPT,scan_SOCKOPT);
	scanEnv(Conn,P_IPV6,scan_IPV6);
	scanEnv(Conn,P_SOCKS,scan_SOCKS);
	scanEnv(Conn,P_SRCIF,scan_SRCIF);
	/*
	scan_RIDENT(getEnv(P_RIDENT));
	*/
	scan_RIDENT(Conn,getEnv(P_RIDENT));
	isFunc = DELEGATE_subfunc(Conn,ac,av,func,Fopt,1);

	if( streq(EXEC_PATH,DeleGate1) )
	{
		scanEnv(Conn,P_DGSIGN,scan_DGSIGN);
		_setTMPDIR(getEnv(P_TMPDIR));/* for Resolvy cache originally */
		signal(SIGTERM,sigTERM1);
		signal(SIGINT, sigTERM1);
		signal(SIGHUP, sigTERM1);
		Exec_client(Conn,ac,av);
		Finish(0);
		fprintf(stderr,"\n[%d] DeleGate: exit from DeleGate1 failed.\n",
			getpid());
		return;
	}
	/* if( with filter params ) */{
		extern int CFI_SHARED_FD;
		CStr(env,32);
		FILE *fp;
		fp = TMPFILE("CFI_SHARED");
		CFI_SHARED_FD = fileno(fp);
		clearCloseOnExec(fileno(fp));
		sprintf(env,"CFI_SHARED_FD=%d",fileno(fp));
		putenv(stralloc(env));
	}

	/*
	if( !IamPrivateMASTER ){
		checkADMIN(Conn,proto);
		validateEmailAddr(getADMIN1(),0);
	}
	*/
	notify_ADMIN(Conn,"start");

	if( LOG_sockio[0] < 0 ){
		Socketpair(LOG_sockio);
		setNonblockingIO(LOG_sockio[1],1);
		expsockbuf(LOG_sockio[1],0,MAX_ARGB*2);
	}

	LOG_sock_enable = 1;
	inINITIALIZATION = 1;
	putSTART("START",frominetd);
	sv1log("BINSHELL=%s\n",BINSHELL);

	START_TIME = time(0);

	scan_HOSTS0(Conn);
	if( env = getEnv(P_TIMEOUT)) scanEnv(Conn,P_TIMEOUT,scan_TIMEOUT);
	if( env = getEnv(P_MAXIMA))  scanEnv(Conn,P_MAXIMA,scan_MAXIMA);

/* check UDP before mkEntrance */
proto = Scan_SERVER(Conn);
if( streq(proto,"cuseeme") ) DELEGATE_LISTEN = -1;
if( streq(proto,"udprelay") ) DELEGATE_LISTEN = -1;
if( streq(proto,"icp") ) DELEGATE_LISTEN = -1;
if( streq(proto,"dns") ) DELEGATE_LISTEN = -1;
if( streq(proto,"teleport") ) isteleportd = 1;

	withDGA = 0;
	ScanDirDefs(Conn); /* ADMDIR is necessary as service on Win32 */
	if( streq(proto,DGAUTHpro) ){
		if( SERVER_PORT() == 0 ){
			privateDGAuth = 1;
		}
		scan_CRYPT(Conn,0);
		withDGA = 1;
	}else
	if( withDGAuth(Conn) || getEnv(P_CRYPT) ){
		scan_CRYPT(Conn,1);
		withDGA = 1;
	}

	if( !isteleportd )
	if( env = getEnv(P_LOGCENTER) )
		setLOGCENTER(env);

	/* 940930 beDaemon() moved before the TUNNEL_open to let
	 *        PGID of TUNNEL processes to be that of delegated.
	 */
	if( !lFG() && !lSYNC() )
	if( !IamPrivateMASTER )
	if( !istunnel1 )
	if( !issockmux )
	if( !IamCGI )
	if( activeServPort() == 0 )
	{
		beDaemon(Conn);
		isDaemon = 1;
	}

	if( SERVER_PORT() == 0 )
	{
		if( isteleportd ){
			/* for compatibility with "teleportd" program */
			setSERVER_PORT("",8000,-1);
		}
	}
	if( streq(proto,DGAUTHpro) ){
		int sock,port;
		CStr(host,256);
		sock = DGAuth_port(1,AVStr(host),&port);
		if( 0 <= sock ){
			setSERVER_PORT("localhost",port,sock);
		}
	}

	if( streq(proto,"udprelay1") ){
		extern int IO_TIMEOUT;
		IO_TIMEOUT = 60;
		if( getEnv(P_CONNECT) == NULL )
			scan_CONNECT(Conn,"udp");
		setServUDP();
	}

	/*
	 * makeEntrance() is here to, may be(-_-;, to avoid giving
	 * SVsock to TUNNEL processes.
	 */
	scanEnv(Conn,P_VSAP,scan_VSAP);
	if( !ViaVSAPassociator(-1) ) /* NOT to accept at remote associator */
	if( !IamCGI )
	if( getEnv("_masterp") == 0 )/* NOT in execWithPrivateMASTER() */
	{
		recv_socks();
		makeEntrance();
		putREADY(isafilter,istunnel1);
	}
	RES_isself(ServSock());

	/*
	 * makeEntrance() should be before set_Owner() to use privireged port.
	 */
	if( set_Owner(1,getEnv(P_OWNER),curLogFd()) < 0 )
		Finish(-1);
	mkdirForSolaris(); /* should be after set_Owner() */
	proto = Scan_SERVER(Conn);

	/* These should be done after "SERVER" scanned
	 * (to use DFLT_PROTO in defaultPERMIT() ?)
	 */
	ScanGlobal(Conn,proto);
	if( withDGA ) /* after AUTHORIZER is scanned in ScanGlobal() */ {
		if( checkDGAuthConfig() != 0 ){
			/* Finish(-1); */
		}
	}

	if( !IamPrivateMASTER ){
		checkADMIN(Conn,proto);
		ScanFileDefs(Conn);
		if( checkCACHEDIR(Conn) != 0 )
			Finish(-1);
	}

	if( env = getEnv("LINGER") ) DELEGATE_LINGER = atoi(env);
	ServerPID = getpid();
	DeleGateId();
	gotoWORKDIR();
	mount_all(Conn,proto);


	if( env = getEnv(P_TUNNEL) ){
		sv1log("SET TUNNEL AS MASTER: %s\n",env);
		scan_MASTER(Conn,"tty7:0/teleport");
	}

	if( IamPrivateMASTER ){
		int ai;
		for( ai = 0; ai < ac; ai++ )
			svlog("> arg[%d] %s\n",ai,av[ai]);
		/*
		somthing wrong (accept lock failure?)(at NNTP/HTTP proxy?)
		3.0.59: YES. lLOCK() was turned off in setupForSolaris()
		*/
		setStickyParams(Conn,proto);

	}else{
		if( env = getEnv("_masterp") ){
			myPrivateMASTER = atoi(env);
		}else
		if( env = getEnv(P_MASTERP) ){
			execWithPrivateMaster(Conn,env,frominetd);
		}else
		if( streq(proto,"http") ){
			compatV5info("No default private-MASTER. MASTERP=\"\"");
		}

		if( !lFORK() )
			setStickyParams(Conn,proto);

		ScanFileDefs(Conn);
		ScanEachConn(Conn);
		/*load_resources(Conn);*/
	}

	if( !isteleportd )
	if( IamPrivateMASTER || myPrivateMASTER == 0 )
		TeleportPID = TeleportServer(getEnv(P_TUNNEL),getEnv(P_INVITE));

	if( istunnel1 ){
		sv1log("TeleportPID = %d\n",TeleportPID);
		while( 0 < (pid = wait(0)) ){
			sv1log("child dead: pid=%d\n",pid);
			if( pid == TeleportPID )
				break;
		}
		goto EXIT;
	}

	if( streq(proto,"http") || BORN_SPECIALIST == 0 ){
		int size;
		size = expand_stack(2*1024*1024);
		STACK_SIZE = size;
		sv1log("#### stack size limit = %X (%d)\n",size,size);
	}

	if( !streq(proto,"http") )
		PEEK_CLIENT_REQUEST = 0;

	if( 0 < StickyMAX_PARA )
		PutPortFile(1);
	else	PutPortFile(0);

	signal(SIGURG, sigURG);
	signal(SIGBUS, sigFATAL);
	signal(SIGSEGV,sigFATAL);
	signal(SIGILL, sigFATAL);
	signal(SIGPIPE,sigPIPE);
	signal(SIGTERM,sigTERM);
	signal(SIGINT, sigTERM);
	if( istunnel1 )
		signal(SIGHUP, sigTERM);
	else	signal(SIGHUP, sigHUP);
	setWatchChild();

	if( StickyReport[0] < 0 || StickyReport[1] < 0 )
		Socketpair(StickyReport);

	pid = 0;
	DELEGATE_dumpEnv(NULL,1,IamPrivateMASTER);
	setLastModified();

	Verbose("Accept-LOCK: %d\n",LOG_type & L_LOCK);
	StickyProcs = (Proc*)StructAlloc((StickyMAX_PARA+1)*sizeof(Proc));

	putSTART("DONE",frominetd);
	scanEnv(Conn,P_DGSIGN,scan_DGSIGN);
	LOG_sock_enable = 0;
	inINITIALIZATION = 0;

	if( streq(proto,"cuseeme") ){
		service_cuseeme(Conn,ServSock(),SERVER_PORT());
		Finish(0);
	}
	if( streq(proto,"icp") ){
		service_icp(Conn,ServSock(),SERVER_PORT());
		Finish(0);
	}
	if( streq(proto,"dns") ){
		signal(SIGBUS, exitFATAL);
		signal(SIGSEGV,exitFATAL);
		dns_init(/*SERVER_PORT()*/);
		service_domain(Conn,ServSock(),SERVER_PORT());
		Finish(0);
	}
	/*
	if( streq(proto,"sockmux") ){
	*/
	if( issockmux
	 || streq(proto,"sockmux") &&
	  ( SERVER_PORT() <= 0 /* without -Pxxx */
	  || *iSERVER_HOST && !isMYSELF(iSERVER_HOST) /* SERVER=sockmux://H:P */
	  )
	){
		scanEnv(Conn,P_CONNECT,scan_CONNECT);
		sox_main(ac,av,Conn,ServSock(),SERVER_PORT());
		Finish(0);
	}
	isFunc = DELEGATE_subfunc(Conn,ac,av,func,Fopt,2);
	if( DELEGATE_LISTEN <= 0 ){
		int fdc,fdv[64];
		fdc = getServPorts(64,fdv);

		if( getEnv(P_CONNECT) )
			scanEnv(Conn,P_CONNECT,scan_CONNECT);
		else	scan_CONNECT(Conn,"None");

		udp_relayX(Conn,fdc,fdv);
		goto EXIT;
	}

	if( isafilter )
	if(!istunnel1 ){
		if( execOnetimeFilter(Conn,clSock) == 0 )
			goto EXIT;
	}

	if( !IamPrivateMASTER && getpid() == ServerPID ){
		if( myPrivateMASTER ){
			/* wait the private-MASTER ready */
		}
		if( fromRsh() && SERVER_PORT() != 0 ){
			RshWatcher(NUM_HUPS,SERVER_PORT());
		}
	}

	MainLastAccept = time(0);

	/*
	if( ERROR_RESTART )
	*/
	if( 0 < MAX_ERESTART )
	if( RESOLV_UNKNOWN || SCRIPT_UNKNOWN ){
		/*
		SERVER_RESTART = (NUM_HUPS+1)*(NUM_HUPS+1)*ERROR_RESTART;
		sv1log("SERVER_RESTART=%d (%d)\n",SERVER_RESTART,NUM_HUPS);
		*/
		if( NUM_HUPS <  MAX_ERESTART && 0 < ERROR_RESTART ){
		SERVER_RESTART = ERROR_RESTART;
		set_eRESTART(ERROR_RESTART);
		}
		if( NUM_HUPS == MAX_ERESTART && 0 < ERROR_RESTART
		 || NUM_HUPS == 0 && ERROR_RESTART == 0
		){
			sv1log("#### restarting is set on config err.\n");
			reinit = 1;
		}
	}
	if( SERVER_RESTART ){
		int now;
		CStr(date,64);

		now = time(0);
		if( 3600*24 <= SERVER_RESTART )
			restart = timeBaseDayLocal(now) + SERVER_RESTART;
		else	restart = ((now/SERVER_RESTART)+1) * SERVER_RESTART;
		StrftimeLocal(AVStr(date),sizeof(date),TIMEFORM_HTTPD,restart,0);
		sv1log("RESTART at %s\n",date);
	}

	IamServer = (getpid() == ServerPID);
	if( IamServer ){
		set_CC();
	}

	if( frominetd ){
		/* NDELAY may be left ON by former user of the socket */
		SetNonblockingIO("svsock",ServSock(),0);
		/*
		repetitive listen() is fatail at least in Solaris2.6
		set_listenX(ServSock(),DELEGATE_LISTEN);
		*/
	}

	if( IamServer && LOG_VERBOSE && getEnv(P_URICONV) ) dumpHTMLCONV();

	signal(SIGALRM,sigALRM);

	/*
	if( LOG_type & L_REINIT && NUM_HUPS == 0 ){
	*/
	if( ViaVSAPassociator(-1) == 0 ) /* no local connect with -Pxxx@vsap */
	if( reinit || (LOG_type & L_REINIT) && NUM_HUPS == 0 ){
		int nready,sockv[FD_SETSIZE],udpv[FD_SETSIZE];
		sv1log("#### wait the first contact...\n");
		nready = pollServPort(0,sockv,udpv,NULL);
		sv1log("#### got the first contact\n");
		sigHUP(0);
	}

	if( isDaemon ){
		fflush(stdout);
		fflush(stderr);
		setSTDLOG();
	}

	for(cnt = 1;;cnt++){
		int idle,timeout,logtimeout,svsock;
		int now,sched_next;

		cleanup_zombis(0);
		if( restartPrivateMASTER ){
			restartPrivateMASTER = 0;
			if( IamServer ){
				sigHUP(0);
				break;
			}
		}

		load_params(Conn);

		TOTAL_SERVED = CHILD_SERNO_SINGLE + StickyNserved; 

		if( IamPrivateMASTER && getppid() != IamPrivateMASTER ){
			sv1log("private-MASTER DONE: OWNER seems dead. %d/%d\n",
				getppid(),IamPrivateMASTER);
			break;
		}

		if( MAX_SERVICE ){
			if( MAX_SERVICE <= TOTAL_SERVED ){
				sv1log("MAX_SERVICE done: %d\n",MAX_SERVICE);
				break;
			}
		}

		now = time(0);
		if( SERVER_TIMEOUT ){
			idle = now - MainLastAccept;
			if(  SERVER_TIMEOUT < idle ){
				sv1log("SERVER_TIMEOUT: %d seconds.\n",idle);
				break;
			}
		}

		mainProcTitle(Conn);
		logtimeout = logTimeout();
		if( 0 < NUM_CHILDREN || IamPrivateMASTER ){
			timeout = 60;
			if( logtimeout != 0 && logtimeout < timeout )
				timeout = logtimeout;
		}else{
			timeout = logtimeout;
			if( timeout <= 0 )
				timeout = 0;
		}

		if( SERVER_RESTART ){
			int rstimeout;

			rstimeout = restart - now;
			if( timeout == 0 || rstimeout < timeout ){
				timeout = rstimeout;
				if( timeout <= 0 ){
					sigHUP(0);
					break;
				}
			}
		}

		if( SERVER_TIMEOUT )
		if( timeout == 0 || SERVER_TIMEOUT < timeout )
			timeout = SERVER_TIMEOUT;

if( !IamPrivateMASTER && IamServer )
if( timeout <= 0 || 15 < timeout )
timeout = 15;

sched_next = sched_execute(now,(iFUNCP)sched_action,Conn);
if( now < sched_next && sched_next-now < timeout )
	timeout = sched_next-now;

if( RESTART_NOW ){
	RESTART_NOW = 0;
	sigHUP(0);
	break;
}

		/*putStatus("Accept(%d,1,%d): nch=%d\n",ServSock(),timeout,
			NUM_CHILDREN);*/

		if( DELEGATE_PAUSE ){
			sleep(10);
			continue;
		}

		if( 0 < SIGALRM ) alarm(300);
		clsock = AcceptByMain(Conn,timeout,&svsock,clSock);
		if( 0 < SIGALRM ) alarm(0);

		if( clsock < 0 ){
			if( terminating ){
				sv1log("main loop break on TERMINATE.\n");
				return;
			}
			/*putStatus("TIMEOUT\n");*/
			LOG_checkAged(0);
			if( clsock != ACC_TIMEOUTED )
				msleep(ACC_BYMAIN_INTERVAL);
			continue;
		}else{
			putLoadStat(ST_ACC,1);
			MainNaccepted++;
			if( lSYNC() ){ 
				CHILD_SERNO_MULTI++;
			}else	CHILD_SERNO++;
		}

		MainLastAccept = time(0);
		/*putStatus("Accepted[%d]\n",CHILD_SERNO);*/

		if( lSYNC() ){
			StickyNserved++;
			EXEC_client(Conn,EXEC_PATH,NULL,clSock);
			initConn(Conn,-1);
		}else
		if( !lEXEC() && StickyActive < StickyMAX_PARA ){
			pid = forkStickyServer(Conn,svsock,clSock);
/*
if( pid <= 0 ){
	sv1tlog("CANNOT FORK Sequential, (%d children)\n",StickyActive);
	cleanup_zombis(0);
	pid = forkStickyServer(Conn,svsock,clSock);
and set MAXIMA=delegated automatically temporalily ?
}
*/
			if( pid <= 0 ){
				TraceLog("? cannot fork Sticky (%d)\n",errno);
				sv1tlog("CANNOT FORK Sequential (%d)\n",errno);
			}else{
				StickyAdd(pid);
				NUM_CHILDREN++;
				logChild("StickyServer",1);
			}
		}else{
			pid = forkOnetimeServer(Conn,svsock,clSock,isafilter);
			if( pid == -1 ){
				TraceLog("? cannot fork Onetime (%d)\n",errno);
				sv1tlog("CANNOT FORK Onetime (%d)\n",errno);
			}else{
				NUM_CHILDREN++;
				logChild("OntimeServer",1);
				CHILD_SERNO_SINGLE++;
				putLoadStat(ST_DONE,1);
				MainNserved++; /* must be done at wait() ... */ 
			}
			if( pid == -1 ){
				sleep(10);
			}
		}
		closeEfd(clSock);
	}

EXIT:
	if( 0 < StickyActive )
		WaitX(0);
	finalize();
	notify_ADMIN(Conn,"stop");
	Exit(0,"");
}

void StickyServer(Connection *Conn,Efd *clSock,int max);
int forkStickyServer(Connection *Conn,int svsock,Efd *clSock)
{	int clsock = getEfd(clSock);
	int pid;

	if( !INHERENT_fork() ){
		setcontrolsock(StickyReport[1]);
		pid = EXEC_client1(Conn,EXEC_PATH,FuncSTICKY,svsock,clSock);
		return pid;
	}

	if( pid = Fork("SequentialServer") )
		return pid;
	setNoExec();

	close(StickyReport[0]); StickyReport[0] = -1;
	NUM_PEERS = NUM_CHILDREN;
	StickyServer(Conn,clSock,StickyMAX_LIFE);
	Finish(0);
	return -1;
}

void setProcTitleHead(PCStr(arg0),int ac,const char *av[]);
int forkOnetimeServer(Connection *Conn,int svsock,Efd *clSock,int isafilter)
{	int clsock = getEfd(clSock);
	int pid;

	if( !INHERENT_fork() ){
		pid = EXEC_client1(Conn,EXEC_PATH,NULL,-1,clSock);
		return pid;
	}

	if( pid = Fork("OnetimeServer") )
		return pid;
	setNoExec();

	if( !isafilter )
		closeServPorts();
	close(StickyReport[0]); StickyReport[0] = -1;
	setProcTitleHead(DeleGate1,main_argc,main_argv);
	NUM_PEERS = NUM_CHILDREN;
	EXEC_client(Conn,EXEC_PATH,NULL,clSock);
	Finish(0);
	return -1;
}

void putSTART(PCStr(what),int frominetd)
{	CStr(uname,128);
	CStr(inetd,128);
	CStr(rsh,128);

	Uname(AVStr(uname));
	if( frominetd )
		sprintf(inetd,"[viaInetd]");
	else	inetd[0] = 0;
	if( fromRsh() )
		sprintf(rsh,"[viaRsh]");
	else	rsh[0] = 0;

	sv0log("--INITIALIZATION %s: %s on %s--%s%s\n",
		what,DELEGATE_ver(),uname,inetd,rsh);
}
static void putDGROOT(PVStr(dgmsg))
{	const char *dgroot;

	setVStrEnd(dgmsg,0);
	dgroot = getEnv(P_DGROOT);
	if( *DELEGATE_DGROOT ){
		if( dgroot == 0 ){
		compatV5info("DGROOT=%s is set automatically. DGROOT=\"\"",
				DELEGATE_DGROOT);
		}
		if( DGROOT_SUBST == 0 )
		if( dgroot && strcmp(dgroot,DELEGATE_DGROOT) != 0 )
			sprintf(dgmsg,"NOT-USED DGROOT=%s\n",dgroot);
		Xsprintf(TVStr(dgmsg),"DGROOT=%s\r\n",DELEGATE_DGROOT);
	}else{
		if( dgroot != 0 )
			sprintf(dgmsg,"FAILED DGROOT=%s\n",dgroot);
		else	sprintf(dgmsg,"FATAL!!!! NO DGROOT !!!!\n");
	}
}
static void putREADY(int isafilter,int istunnel1)
{	CStr(msg,1024);
	CStr(port,128);
	CStr(dgmsg,1024);
	const char *admin;

	putDGROOT(AVStr(dgmsg));
	if( *dgmsg )
		sv1log("%s",dgmsg);
	admin = getADMIN1();
	Xsprintf(TVStr(dgmsg),"ADMIN=%s\r\n",admin?admin:"");

	printServPort(AVStr(port),"-P",0);
	sprintf(msg,"<DeleGate/%s> [%d] %s READY\r\n",DELEGATE_ver(),
		getpid(),port);
	svlog("%s",msg);
	if( istunnel1 ){
		fputs(msg,stdout);
		fflush(stdout);
	}else
	if( !isafilter )/* suppress the banner if from inetd */
	if( isatty(fileno(stderr)) || fromRsh() ){
		fputs(msg,stderr);
		fputs(dgmsg,stderr);
		fprintf(stderr,"%s\r\n",DELEGATE_copyright());
	}

	printServPort(AVStr(port),"",1);
	if( istunnel1 )
		sv1log("PORT= 0 TeleportTunnel dummy=%s\n",port);
	else{
		CStr(ftpport,64);
		int porti;
		if( (porti = atoi(port)) == 0 )
			sscanf(port,"%*[^:]:%d",&porti);
		sprintf(ftpport,"%d,%d",porti/256,porti%256);
		sv1log("PORT= %s (%s)\n",port,ftpport);
	}
}
int service_tunnel1(Connection *Conn)
{
	sv1log("#### service_tunnel\n");
	return -1;
}
void setEXEC_PATH()
{	const char *env;

	if( env = getEnv(P_EXEC_PATH) )
		strcpy(EXEC_PATH,env);
	else	FullpathOfExe(AVStr(EXEC_PATH));
}
void setLOGCENTER(PCStr(center))
{	CStr(host,256);
	CStr(ifhost,256);
	CStr(hostport,256);
	int port;

	if( *center == 0 )
		center = DELEGATE_LOGCENTER;
	port = 8000;
	Xsscanf(center,"%[^:]:%d",AVStr(host),&port);
	gethostnameIFIF(AVStr(ifhost),sizeof(ifhost));
	LOG_center = UDP_client_open1("frog","frog",host,port,
			ifhost,SERVER_PORT());
	setCloseOnExec(LOG_center);

	/*
	gethostName(LOG_center,hostport,PN_ADDRPORT);
	put_publiclog("I","DeleGate.Start %s\n",hostport);
	*/
}
int execOnetimeFilter(Connection *Conn,Efd *clSock)
{	CStr(hostn,256);
	int port;
	int clsock,fds[3];
	int pid,xpid;

	port = getpeerNAME(0,AVStr(hostn));
	if( port <= 0 )
		return -1;

	/* connected, in nowait mode from inetd */

	if( lTRACE() ){
		if( pid = Fork("FilterTrace") ){
			TraceLog("tracing OnetimeFilter... %d\n",pid);
			xpid = WaitX(0);
			TraceLog("tracing OnetimeFilter DONE: %d\n",xpid);
			return 0;
		}
		setNoExec();
	}

	clsock = randfd(0);
	fds[0] = fds[1] = fds[2] = -1;
	if( 0 < clsock ){ fds[0] = open("/dev/null",0); }
	if( peerPort(1) == port ){ fds[1] = dup2(curLogFd(),1); }
	if( peerPort(2) == port ){ fds[2] = dup2(curLogFd(),2); }
	svlog("ONE-TIME SERVER(in nowait from inetd)[%d]%d,%d,%d\n",
		clsock,fds[0],fds[1],fds[2]);
	setEfd(clSock,clsock,"","",0);
	EXEC_client(Conn,EXEC_PATH,NULL,clSock);
	if( lTRACE() ){
		Finish(0);
		return -1;
	}else	return 0;
}
void setTeleportMASTER(Connection *Conn)
{	CStr(master,256);

	sprintf(master,"tty7:0/teleport:!*");
	scan_MASTER(Conn,master);
	pushEnv(P_INVITE,"*");
}

static void breakStickies(int shlock)
{	int idle;
	int timeout;
	int ndead;

	if( ndead = cleanup_zombis(1) )
	sv1log("AcceptByMain: Sticky*%d/%d cleared before trying ex-lock\n",
		ndead,StickyActive);

	ABMwhere = "breaking";
	timeout = StickyTIMEOUT;
	if( timeout < 10 ) timeout = 10; else
	if( 60 < timeout ) timeout = 60;
/*
 * timeout *= 1000;
 * because timeout in lock_exclusiveTO() is in milli-seconds.
 */

	sv1log("AcceptByMain: Wait Frozen Sticky*%d become active ...\n",
			StickyActive);

	if( lock_exclusiveTO(shlock,timeout,NULL) == 0 ){
		lock_unlock(shlock);
		idle = time(0) - lockedoutT;
		sv1log("AcceptByMain: Frozen Sticky*%d become active (%ds)\n",
			StickyActive,idle);
		return;
	}

	/* Try normal termination first.  Sending SIGHUP is not harmful
	 * for Stickies because they are blocking the signal during
	 * the execution of its service for a client.
	 */
	if( ndead = cleanup_zombis(1) )
	sv1log("AcceptByMain: Sticky*%d/%d cleared before sending SIGHUP\n",
		ndead,StickyActive);

	if( StickyKill(SIGHUP) ){
		sleep(5);
		while( 0 < (ndead = cleanup_zombis(1)) ){
			sv1log("AcceptByMain: Sticky*%d/%d cleaned by SIGHUP\n",
				ndead,StickyActive);
			sleep(1);
		}
	}

	sv1log("AcceptByMain: Wait Frozen Sticky*%d cleaned by SIGHUP ...\n",
		StickyActive);

	if( lock_exclusiveTO(shlock,timeout,NULL) == 0 ){
		lock_unlock(shlock);
		idle = time(0) - lockedoutT;
		sv1log("AcceptByMain: Frozen Sticky*%d were cleaned (%ds)\n",
			StickyActive,idle);
		return;
	}

	idle = time(0) - lockedoutT;
	sv1log("AcceptByMain: KILL Frozen Sticky*%d (%ds) %d/%d\n",
		StickyActive, idle, StickyNserved,StickyDone);

	daemonlog("F","E-F: kill Frozen Sticky*%d (%ds)\n",StickyActive,idle);
	if( StickyKill(SIGKILL) ){
		sleep(5);
		cleanup_zombis(1);
	}

	idle = time(0) - lockedoutT;
	if( lock_exclusiveTO(shlock,timeout,NULL) == 0 ){
		sv1log("AcceptByMain: Frozen Sticky*%d were KILLED (%ds)\n",
			StickyActive,idle);
	}else{
		sv1log("AcceptByMain: couldn't KILL Frozen Sticky*%d (%ds)\n",
			StickyActive,idle);
		sv1log("AcceptByMain: #### restarting may fail... ####\n");
	}

	if( fromInetd() )
		sigTERM(0);
	else	sigHUP(0);
	Finish(-1);
}
static void locked_out(int shlock)
{	int now,idle,nserved,ndone,reset;
	int (*LF)(PCStr(fmt),...);

	now = time(0);
	reset = 0;
	if( ndone = StickyDone - lastdoneN ){
		lastdoneN = StickyDone;
		lockedoutT = now;
		reset = 1;
	}
	if( nserved = StickyNserved - lastserveN ){
		lastserveN = StickyNserved;
		lockedoutT = now;
		reset = 1;
	}
	if( lockedoutN == 0 ){
		lockedoutT = now;
		reset = 1;
	}
	if( lockedoutT < StickyLastAccept ){
		sv1log("## lockedoutT:%d < StickyLastAccept:%d\n",
			lockedoutT,StickyLastAccept);
		lockedoutT = StickyLastAccept;
	}

	idle = now - lockedoutT;
	if( ++lockedoutN % 10 == 0 || reset )
		LF = svlog;
	else	LF = svvlog;
	(*LF)("AcceptByMain: locked out*%d/%d by Sticky*%d %d/%d\n",
		lockedoutN,idle,StickyActive,nserved,ndone);

	/*
	 * A Sticky server possibly frozen in accept() ...
	 * Kill them and restart emulating SIGHUP.
	 */
	if( ACC_NONE_TIMEOUT < idle ){
		breakStickies(shlock);
		lockedoutT = time(0);
	}
}

int ACCEPT1(int sock,int isServer,int lockfd,int timeout,PVStr(sockname));
int AcceptByMain1(int timeout,int exlock,int svsock,PVStr(sockname))
{	int clsock;
	int shlock;
	int ocsock,nvfd;
	CStr(vfd,2048);

	shlock = PortLockFd();

	if( 0 < StickyActive && 0 <= shlock ){
		ABMwhere = "locking";
		if( lock_exclusiveNB(shlock) != 0 ){
			locked_out(shlock);
			return ACC_FAILED;
		}
		lockedoutN = 0;

		if( PollIn(svsock,1) <= 0 ){
			sv1log("AcceptByMain: yielded to a Sticky (%d)\n",
				StickyActive);
			lock_unlock(shlock);
			return ACC_FAILED;
		}
	}

	ABMwhere = "accepting1";
	clsock = ACCEPT1(svsock,1,exlock,1,AVStr(sockname));
	ocsock = clsock;
	clsock = randfd(clsock);
	if( lTRVERB() ){
		nvfd = valid_fdl(AVStr(vfd));
		TraceLog("accepted %d -> %d (%d child, %d act-fds)\n",
			ocsock,clsock,NUM_CHILDREN,nvfd);
	}
	ACCEPT_TIME = Time();
	if( clsock < 0 )
		sv1log("AcceptByMain[%d]: taken by a Sticky (%d)?\n",svsock,
			StickyActive);

	if( StickyActive && 0 <= shlock )
		lock_unlock(shlock);

	return clsock;
}
static int pollServPortAndSticky(int timeout,int *sockv,int *udpv)
{	int rtimeout;
	int optv[2],nready,si,sock1;
	double Start;

	optv[0] = StickyReport[0];
	optv[1] = -1;

	for( rtimeout = timeout; ; rtimeout -= (int)(1000*(Time()-Start)) ){
		if( rtimeout <= 0 ){
			sv1log("AcceptByMain: polling timeout = %d / %d\n",
				rtimeout,timeout);
			break;
		}
		Start = Time();
		nready = pollServPort(rtimeout,sockv,udpv,optv);
		if( nready <= 0 )
			break;
		for( si = 0; si < nready; si++ ){
			sock1 = sockv[si];
			if( sock1 == StickyReport[0] ){
Verbose("AcceptByMain: got Sticky REPORT 1/%d\n",nready);
				getStickyReports();
				cleanup_zombis(0);
				sockv[si] = -1;
				nready--;
			}
		}
		if( 0 < nready )
			break;
	}
	return nready;
}

int CTX_VSAPbindaccept(Connection *Conn,int timeout,int priority,PVStr(sockname),PVStr(peername));
static int AcceptByMain(Connection *Conn,int timeout,int *svsockp,Efd *clSock)
{	int clsock;
	int sx,nready,sockv[FD_SETSIZE],udpv[FD_SETSIZE];
	int exlock,sock1;
	CStr(primport,256);
	CStr(sockname,256);
	CStr(peername,256);
	int remote;

	if( ViaVSAPassociator(-1) ){
		if( VSAP_TIMEOUT ) timeout = VSAP_TIMEOUT;
		ABMwhere = "VSAPbind-accept";
		clsock = CTX_VSAPbindaccept(Conn,timeout,1,AVStr(sockname),AVStr(peername));
		if( 0 <= clsock ){
			setEfd(clSock,clsock,sockname,peername,1);
		sv1log("AcceptByMain: VSAP[%s<-%s]\n",sockname,peername);
			return clsock;
		}
		ABMwhere = "VSAPbind-accept-failed";
		sleep(5);
		return -1;
	}

	ABMwhere = "polling";
	gotSIGTERM = 0;
	if( lSIGCHLD() ){
		int rtimeout,ntry;
		double Start,Elps;

		Start = Time();
		rtimeout = timeout * 1000;
		sigsetmask(sigblock(0) & ~sigmask(SIGCHLD));
		for( ntry = 0;; ntry++ ){
			errno = 0;
			nready = pollServPortAndSticky(rtimeout,sockv,udpv);
			Elps = Time() - Start;
			rtimeout = (int)(timeout*1000 - Elps*1000);
			if( lTRVERB() ){
TraceLog("AcceptByMain: poll*%d nready=%d errno=%d ELP=%d %d/%d\n",
				ntry,nready,errno,
				(int)(Elps*1000),rtimeout,timeout*1000);
			}
			if( 0 < nready || errno != EINTR || rtimeout <= 0 )
				break;
			mainProcTitle(Conn);
			if( lTRVERB() ){
TraceLog("AcceptByMain: retry poll*%d nready=%d timeout=%d/%d\n",
				ntry,nready,rtimeout,timeout);
			}
		}
		sigsetmask(sigblock(0) |  sigmask(SIGCHLD));
		if( lTRVERB() ){
TraceLog("AcceptByMain: poll SIGCHLD END SD=%d,LD=%d,SN=%d,LN=%d,LO=%d\n",
				StickyDone,lastdoneN,
				StickyNserved,lastserveN,lockedoutN);
		}
	}else{
		nready = pollServPortAndSticky(timeout*1000,sockv,udpv);
	}
	if( nready <= 0 ){
		if( terminating ){
			sv1log("AcceptByMain: break on TERMINATE.\n");
			return ACC_FAILED;
		}
		if( getpid() == ServerPID ){
			int port;

			port = sockPort(ServSock());
			if( port <= 1 ){
				sv1log("RESTART ON RESUME ? -P%d SIGTERM=%d\n",
					port,gotSIGTERM);
				if( gotSIGTERM )
					return ACC_FAILED;
				sleep(1);
				sigHUP(-1);
			}
		}
		if( Ntimeout == 0 )
		svvlog("AcceptByMain: TIMEOUT(children=%d, timeout=%d)\n",
			NUM_CHILDREN,timeout);
		Ntimeout++;
		return ACC_TIMEOUTED;
	}
	Ntimeout = 0;

	ABMwhere = "accepting";
	primaryPort(AVStr(primport));
	for( sx = 0; sx < nready; sx++ ){
/*
if connected, then it is from VSAP server
 */
		sock1 = sockv[sx];
		if( lLOCK() )
			exlock = PortLocks(primport,0,VStrNULL);
		else	exlock = -1;

		if( udpv[sx] ){
			clsock = UDPaccept(sock1,exlock,timeout);
			/* parallel accept of UDP does not work without
			 * SO_REUSEPORT.  So it must not inherited to
			 * StickyProcess...
			 */
			StickyMAX_PARA = 0;
		}else	clsock = AcceptByMain1(timeout,exlock,sock1,AVStr(sockname));
		if( 0 <= clsock ){
			setEfd(clSock,clsock,sockname,"",0);
			*svsockp = sockv[sx];
			return clsock;
		}
	}

	return ACC_FAILED;
}

static int AcceptBySticky1(Connection *Conn,int timeout,int shlock,int exlock,Efd *clSock)
{	int clsock = -1;
	int sx,nready,sockv[FD_SETSIZE],udpv[FD_SETSIZE];
	CStr(sockname,256);
	CStr(peername,256);
	int remote;

	if( ViaVSAPassociator(-1) ){
		if( VSAP_TIMEOUT ) timeout = VSAP_TIMEOUT;
		clsock = CTX_VSAPbindaccept(Conn,timeout,0,AVStr(sockname),AVStr(peername));
		if( 0 <= clsock ){
			setEfd(clSock,clsock,sockname,peername,1);
		sv1log("AcceptBySticky: VSAP[%s<-%s]\n",sockname,peername);
			return clsock;
		}
		sleep(5);
		return -1;
	}

	if( 0 <= shlock )
	if( lock_sharedTO(shlock,timeout*1000,NULL) != 0 ){
		sv1log("AcceptBySticky: lock timeout\n");
		return -1;
	}

	/*
	 * can poll with StickyReport[1] to check if closed on
	 * the death of the parent ...
	 */
	nready = pollServPort(timeout*1000,sockv,udpv,NULL);

	if( nready <= 0 )
		goto EXIT;

	for( sx = 0; sx < nready; sx++ ){
		if( udpv[sx] )
			clsock = UDPaccept(sockv[sx],exlock,timeout);
		else	clsock = ACCEPT(sockv[sx],1,exlock,timeout);
		if( 0 <= clsock )
			break;
	}
	clsock = randfd(clsock);
	ACCEPT_TIME = Time();
EXIT:
	if( 0 <= shlock )
		lock_unlock(shlock);

	if( 0 <= clsock ){
		remote = RIDENT_recv(clsock,AVStr(sockname),AVStr(peername));
		if( remote < 0 ){
			close(clsock);
			clsock = -1;
		}else{
			setEfd(clSock,clsock,sockname,peername,remote);
		}
	}
	return clsock;
}
static int AcceptBySticky(Connection *Conn,int timeout,int shlock,int exlock,Efd *clSock)
{	int clsock;
	int timeout1,rtimeout;

	Verbose("StickyServer: start accept()\n");
	for( rtimeout = timeout; 0 < rtimeout; rtimeout -= timeout1 ){
		ProcTitle(Conn,"*standby=%ds",rtimeout);
		if( StickyTIMEOUT1 < rtimeout )
			timeout1 = StickyTIMEOUT1;
		else	timeout1 = rtimeout;
		clsock = AcceptBySticky1(Conn,timeout1,shlock,exlock,clSock);
		if( 0 < clsock )
			break;
	}
	if( 0 <= clsock ){
		CStr(accReport,1);
		SReport SR;
		Verbose("## AcceptBySticky: SEND ACCEPT REPORT\n");
		/*
		accReport[0] = 0;
		write(StickyReport[1],accReport,1);
		*/
		SR.s_stat = SR_ACCEPT;
		SR.s_done = 0;
		SR.s_pid = getpid();
		write(StickyReport[1],&SR,sizeof(SR));
	}
	return clsock;
}

static int start0;
static int nreq;
static void reportNserv(PCStr(stat),int start,int nreq)
{	char nconn;
	vfuncp osig;
	SReport SR;

	if( StickyReport[1] < 0 )
		return;

	/* might get SIGALRM in accept(), free accept lock immediately */
	if( PortLockFd() != -1 )
		close(PortLockFd());

	nconn = CHILD_SERNO_MULTI + nreq;

	SR.s_stat = SR_FINISH;
	if( BREAK_STICKY & SR_DETACH )
		SR.s_stat |= SR_DETACH;
	SR.s_done = nconn;
	SR.s_pid = getpid();

	osig =
	signal(SIGPIPE,SIG_IGN);
	/*
	write(StickyReport[1],&nconn,1);
	*/
	write(StickyReport[1],&SR,sizeof(SR));
	close(StickyReport[1]);
	StickyReport[1] = -1;
	signal(SIGPIPE,osig);

	sv1log("StickyServer done [%s] %d req / %d conn / %d sec\n",
		stat,CHILD_SERNO_MULTI+nreq,CHILD_SERNO_MULTI,time(0)-start);
	/*
	Finish(0);
	*/
}
void stopStickyServer(PCStr(why))
{
	BREAK_STICKY = SR_DETACH;
	reportNserv(why,start0,nreq+1);
}
static void sigHUPforAbort(int sig){
	closeServPorts();
	sv1log("StickyServer SIGHUPed after %d services.\n",CHILD_SERNO_MULTI);
	Finish(0);
}
static int isStickyProto(Connection *Conn)
{	int nntps,otimeout;
	const char *proto;

	if( IsInternal ) return 1;

	proto = DFLT_PROTO;
	if( strcaseeq(iSERVER_PROTO,"socks") )  return 1;
	if( strcaseeq(proto,"tcprelay") )  return 1;
	if( strcaseeq(proto,"vsap") )  return 1;
	if( strcaseeq(proto,"http") )	return 1;
	if( strcaseeq(proto,"gopher") )	return 1;
	if( strcaseeq(proto,"ftp") && IsAnonymous ) return 1;
	if( strcaseeq(proto,DGAUTHpro) ) return 1;

	if( localPathProto(proto) && IsLocal )
	if( streq(iSERVER_PROTO,"http") )
		return 1;

	if( strcaseeq(proto,"nntp") || strcaseeq(proto,"ftp") )
	if( streq(iSERVER_PROTO,"http") && !ACT_GENERALIST )
		 return 1;

	return 0;
}
void setStickyParams(Connection *Conn,PCStr(proto))
{
	if( 0 < STANDBY_MAX )
	if( streq(proto,"http")
/*	 || streq(proto,"https") */ /* should be enabled ... */
	 || streq(proto,"icap")
	 || streq(proto,"vsap")
	 || streq(proto,"socks")
	 || streq(proto,"tcprelay")
	 || streq(proto,DGAUTHpro)
	 || BORN_SPECIALIST == 0 ){
		StickyMAX_PARA = MAX_DELEGATE;
		StickyMAX_LIFE = STANDBY_MAX * 4;
		StickyTIMEOUT  = STANDBY_TIMEOUT;
	}
}

int PortLockReopen();
void setCloseOnTimeout(int timeout);

void StickyServer(Connection *Conn,Efd *clSock,int max)
{	int clsock;
	int omask;
	int timer;
	int mypid,ppid,ouid,ogid;
	const char *stat;
	int shlock,exlock,madelock;
	/*
	int start0,start,now;
	int nreq;
	*/
	int start,now;
	int sx;
	CStr(tmp,512);

	mypid = getpid();
	ppid = getppid();
	ouid = getuid();
	ogid = getgid();

	signal(SIGHUP,sigHUPforAbort);
	NUM_CHILDREN = 0;
	nreq = 0;

	start = start0 = time(0);
	omask = sigblock(sigmask(SIGHUP));
	{
		CHILD_SERNO_MULTI = 1;
		setProcTitleHead(DeleGate1,main_argc,main_argv);
		setCloseOnTimeout(StickyTIMEOUT);
		EXEC_client(Conn,EXEC_PATH,NULL,clSock);
		closeEfd(clSock);
	}
	sigsetmask(omask);

	madelock = 0;
	for(;;){
		if( 0 < REQUEST_SERNO ){
			nreq += REQUEST_SERNO - 1;
			REQUEST_SERNO = 0;
		}
		if( max <= CHILD_SERNO_MULTI ){
			stat = "natural";
			break;
		}
		if( INTERRUPT_STICKY ){
			stat = "interrupted";
			break;
		}
		if( BREAK_STICKY ){
			stat = "broken";
			break;
		}
		if( !ACC_REJECTED && !isStickyProto(Conn) ){ /* generalist */
			stat = "nonStickyProtocol";
			sprintf(tmp,"%s(%s:%s:%s)",stat,
				iSERVER_PROTO,DFLT_PROTO,DST_PROTO);
			stat = tmp;
			break;
		}
		if( getpid() != mypid ){
			/* may be forkd in sendDistribution() */
			sv1log("#### not the Sticky server process, EXIT.\n");
			Finish(0);
		}
		if( getppid() != ppid || getuid() != ouid || getgid() != ogid ){
			stat = "parentChanged";
			break;
		}
		if( !ViaVSAPassociator(-1) )
		if( activeServPort() == 0 ){
			stat = "serverSocketClosed";
			break;
		}

		now = time(0);
		if( 120 < (now - start) ){
			stat = "lifeSpan1";
			break;
		}
		start = now;

		initConn(Conn,-1);
		if( !madelock ){
			madelock = 1;
			shlock = PortLockReopen();
			if( lLOCK() )
				exlock = PortLocks(primaryPort(AVStr(tmp)),0,VStrNULL);
			else	exlock = -1;
		}
		clsock=AcceptBySticky(Conn,StickyTIMEOUT,shlock,exlock,clSock); 

		if( clsock < 0 ){
			stat = "acceptFailed";
			break;
		}

		omask = sigblock(sigmask(SIGHUP));
		{
			CHILD_SERNO_MULTI++;
			setCloseOnTimeout(StickyTIMEOUT);
			EXEC_client(Conn,EXEC_PATH,NULL,clSock);
			closeEfd(clSock);
			cleanup_zombis(1);
		}
		sigsetmask(omask);
	}
	reportNserv(stat,start0,nreq);
	Finish(0);
}

void get_svstat(int fd);
static int str2env(PCStr(seqno),int *svsockp,Efd *clSock,int *lfdp)
{	int ac,port;
	int isock;
	int clsock;
	CStr(svhost,256);
	CStr(sockname,256);
	CStr(peername,256);
	CStr(seq1,256);
	CStr(seq2,256);
	CStr(seq3,256);
	int remote;
	int statfd;

	clsock = -1;
	*svsockp = -1;
	statfd = -1;
	svhost[0] = 0;
	sockname[0] = peername[0] = 0;

	seq1[0] = seq2[0] = seq3[0] = 0;
	Xsscanf(seqno,"%[^,],%[^,],%[^\n]",AVStr(seq1),AVStr(seq2),AVStr(seq3));

	ac = sscanf(seq1,"%x/%d/%d/%d/%d/%d/%d/%d/%d/%d",
		&deleGateId,
		&port,
		&ServerPID,
		&IamPrivateMASTER,
		svsockp,
		&param_file,
		&clsock,
		&TOTAL_SERVED,
		&CHILD_SERNO,
		&NUM_PEERS
	);
	ac += sscanf(seq2,"%d/%d/%d/%d/%d/%d/%d/%d/%d/%d",
		&StickyReport[1],
		&DELEGATE_LINGER,
		lfdp,
		&LOG_type,
		&statfd,
		&ekeyFd,
		&MASTERisPrivate,
		&AF_UNIX_DISABLE,
		&RES_localdns,
		&remote
	);
	ac += Xsscanf(seq3,"%[^/]/%[^/]/%[^/]",
		AVStr(svhost),
		AVStr(sockname),
		AVStr(peername)
	);
	LOG_type |= L_ISCHILD;
	get_svstat(statfd);

	if( lVERB() )
		LOG_VERBOSE = 1;

	if( 0 < (isock = getclientsock()) )
		clsock = isock;
	if( 0 <= clsock )
	setEfd(clSock,clsock,sockname,peername,remote);

	if( 0 < (isock = getserversock()) )
		*svsockp = isock;

	if( 0 < (isock = getcontrolsock()) )
		StickyReport[1] = isock;

	if( isFuncFunc ){
		/* passed svsock is not the socket to accept client
		 * but a socket connected to the server
		 */
		setSERVER_PORT(svhost,port,-1);
	}else
	/*
	 * svhost derived from -Phostname:port is necessary to be set as
	 * the PrimayPort to generate ${PORT}, "Location:", etc.
	 */
	setSERVER_PORT(svhost,port,*svsockp);

	return ac;
}

static int recvEnv(Connection *Conn,int ac,const char *av[],int *svsockp,Efd *clSock)
{	int av1ac;
	int lfd;
	const char *env;

	lfd = -1;
	if( (av1ac = str2env(av[1],svsockp,clSock,&lfd)) < 3 ){
		if( env = getEnv(P_EXEC_ENV) )
			av1ac = str2env(env,svsockp,clSock,&lfd);
		else	av1ac = 0;
	}
	if( 0 <= lfd )
	fdopenLogFile(lfd);
	return av1ac;
}

int callFilter(Connection *Conn,int ac,const char *av[]);
static int callFunc(Connection *Conn,int ac,const char *av[],Efd *clSock,int svsock);
void Exec_client(Connection *Conn,int ac,const char *av[])
{	int av1ac;
	int svsock;
	Efd *clSock = clientSocks;
	const char *env;

	if( 2 < ac ){
		if( streq(av[2],FuncFunc) ) isFuncFunc = 1;
	}
	if( 1 < ac && streq(av[1],FuncFILTER) )
		av1ac = 0;
	else
	av1ac = recvEnv(Conn,ac,av,&svsock,clSock);

	if( env = getEnv(P_EXEC_PATH)  ) strcpy(EXEC_PATH,env);
	if( env = getEnv(P_START_TIME) ) START_TIME = atoi(env);
	if( env = getEnv(P_ALIVE_PEERS)) NUM_CHILDREN = atoi(env);

	if( 1 < ac ){
	  if( streq(av[1],FuncFILTER) )    Finish(callFilter(Conn,ac,av));
	  if( streq(av[2],FuncSTICKY) ){
		scanEnv(Conn,P_MAXIMA,  scan_MAXIMA);
		setStickyParams(Conn,DFLT_PROTO);
		StickyServer(Conn,clSock,StickyMAX_LIFE);
		closeEfd(clSock);
		Finish(0);
	  }
	  if( streq(av[2],FuncFunc)) Finish(callFunc(Conn,ac,av,clSock,svsock));
	}

	if( av1ac < 3 )
		Exit(-1,"cannot get socket argument.\n");
	else{
		call_client1(Conn,clSock);
		closeEfd(clSock);
	}
}

void gotoWORKDIR()
{	const char *wd;
	const char *pp;
	CStr(wdir,1024);
	CStr(cwd,1024);
	CStr(var,1024);
	CStr(tmp,1024);
	FILE *fp;

	wd = (char*)getEnv(P_WORKDIR);
	if( wd == 0 ){
		if( lFG() || lSYNC() )
			return;
		else	wd = DELEGATE_WORKDIR;
	}
	strcpy(wdir,wd);
	substfile(AVStr(wdir),"PROTOCOL",AVStr(var),VStrNULL,VStrNULL);

	if( !isBoundpath(wdir) ){
		strcpy(tmp,wdir);
		sprintf(wdir,"%s/%s",var,tmp);
		/*
		if( lARGDUMP() )
		*/
		if( lFILETRACE() )
			fprintf(stderr,"WORKDIR=%s\n",wdir);
	}

	path_escchar(AVStr(wdir));
	mkdirRX(wdir);
	getcwd(cwd,sizeof(cwd));
	originWD = StrAlloc(cwd);

	if( chdir(wdir) == 0 ){
		CStr(pid,64);

		sv1log("%s=%s\n",P_WORKDIR,wdir);
		_workdir = stralloc(wdir);
		sprintf(pid,"%d",getpid());
		if( fp = dirfopen("WORKFILE",AVStr(pid),"w") )
			fclose(fp);
	}else{
		sv1log("ERROR can't goto %s=%s\n",P_WORKDIR,wdir);
	}
}
void makeWorkFile(PVStr(path),PCStr(type),PCStr(file))
{
	sprintf(path,"${ACTDIR}/%s/%d.%s",type,getpid(),file);
	substFile(path);
	if( elnumof(workFiles)-1 <= workFileX ){
		syslog_ERROR("ignored too many work-files -- %s\n",path);
		return;
	}
	workFiles[workFileX++] = stralloc(path);
}
void deleteWORKDIR()
{	int pid;
	CStr(pidfile,1024);
	const char *workfile;
	const char *dp;
	int tx;

	pid = getpid();
	if( _workdir ){
		sprintf(pidfile,"%s/%d",_workdir,pid);
		if( unlink(pidfile) == 0 ){
			sv1log("unlinked %s\n",pidfile);
			chdir("..");
			if( rmdir(_workdir) == 0 )
				sv1log("removed %s/\n",_workdir);
			else	sv1log("remove failed, errno=%d, %s\n",
					errno,_workdir);
		}
		_workdir = NULL;
	}
	for( tx = 0; workfile = workFiles[tx]; tx++ ){
		if( dp = strrpbrk(workfile,"/\\") )
			if( atoi(dp+1) == pid )
				unlink(workfile);
	}
}

FILE *openStatusFile(PCStr(pathform));
void putStatus(PCStr(fmt),...)
{	const char *file;
	FILE *fp;
	VARGS(8,fmt);

	if( file = getEnv("STATFILE") )
	if( fp = openStatusFile(file) ){
		/* fseek(fp,0,0); */
		fprintf(fp,"%d ",time(0));
		fprintf(fp,fmt,VA8);
		fflush(fp);
		/* Ftruncate(fp,0,1); */
	}
}

static void printXdisplay(PVStr(pxdisplay),PCStr(pxhost),int pxport,int scrnum)
{	const char *pxaddr;

	if( pxaddr = gethostaddr(pxhost) )
		sprintf(pxdisplay,"%s:%d.%d",pxaddr,pxport-6000,scrnum);
	else	sprintf(pxdisplay,"%s:%d.%d",pxhost,pxport-6000,scrnum);
	sv1log("Xproxy -- %s:%d.%d -- %s\n",pxhost,pxport,scrnum,pxdisplay);
}
int makeXproxy(Connection *Conn,PVStr(pxdisplay),PCStr(display),PVStr(pxhost),PCStr(relhost),PCStr(me),int timeo)
{	const char *av[32]; /**/
	CStr(port,256);
	CStr(timeout,256);
	CStr(server,256);
	CStr(permit,256);
	CStr(desc,256);
	const char *env;
	CStr(conn,256);
	CStr(vardir,1024);
	CStr(logdir,1024);
	CStr(logfile,1024);
	CStr(disphost,128);
	int dispport,dispsock;
	int pxsock,pxport;
	int ac;
	int pid;
	int dispnum,scrnum;
	CStr(cachepath,2048);
	FILE *cachefp;
	CStr(hosts,0x4000);
	CStr(clientid,256);

	dispnum = scrnum = 0;
	Xsscanf(display,"%[^:]:%d.%d",AVStr(disphost),&dispnum,&scrnum);
	dispport = 6000+dispnum;

	sprintf(clientid,"pid-port-%s",relhost);
	if( CTX_cache_path(Conn,"X",disphost,dispnum,clientid,AVStr(cachepath)) ){
		CStr(line,256);

		sv1log("##[%s][%s] %s\n",display,relhost,cachepath);
		if( cachefp = fopen(cachepath,"r+") ){
			fgets(line,sizeof(line),cachefp);
			fclose(cachefp);

			/* cleanup zombis of previous X-proxy to make kill()==0
			 * work to sense the existence of the process */
			while( 0 < NoHangWait() )
				;

			if( sscanf(line,"%d %d",&pid,&pxport) == 2 )
			if( Kill(pid,SIGHUP) == 0 )
			{
				sv1log("REUSE X-PROXY for %s: port=%d pid=%d\n",
					relhost,pxport,pid);
				printXdisplay(AVStr(pxdisplay),pxhost,pxport,scrnum);
				return pid;
			}
			/* should add "xhost" */
		}
	}

	pxsock = -1;
	for( pxport = 6010; pxport < 6100; pxport++ ){
		pxsock = server_open("Xpxdisplay",AVStr(pxhost),pxport,1);
/*
DEBUG: bind with wildcard interface
		pxsock = server_open("Xpxdisplay","",pxport,1);
*/
		if( 0 < pxsock )
			break;
	}
	if( pxsock < 0 )
		return 0;

	pxport = sockPort(pxsock);

	if( (pid = Fork("Xpxdisplay")) != 0 ){
		close(pxsock);
		printXdisplay(AVStr(pxdisplay),pxhost,pxport,scrnum);
		return pid;
	}

	if( cachepath[0] ){
		if( cachefp = dirfopen("X-Proxy",AVStr(cachepath),"w") ){
			fprintf(cachefp,"%d %d\n",getpid(),pxport);
			fclose(cachefp);
		}
		/* should read "xhost" and set it to PERMIT */
	}

	if( fromInetd() ){
		close(0);
		close(1);
	}
	closeServPorts();
	close(ToS);
	close(FromS);
	close(ToC);
	close(FromC);

	ac = 0;
	av[ac++] = EXEC_PATH;

	sprintf(port,"-P%d/%d",pxport,pxsock);
	av[ac++] = port;

	Xsscanf(display,"%[^:]:%d",AVStr(disphost),&dispport);
	sprintf(server,"%s=X://%s:%d/",P_SERVER,disphost,6000+dispport);
	av[ac++] = server;

	if( timeo ){
		sprintf(timeout,"%s=daemon:%ds",P_TIMEOUT,timeo);
		av[ac++] = timeout;
	}

	unsetEnv(0,(const char**)environ,(const char*const*)environ,P_PERMIT);
	unsetEnv(0,(const char**)environ,(const char*const*)environ,P_RELIABLE);
	unsetEnv(0,(const char**)environ,(const char*const*)environ,P_REACHABLE);
	sprintf(permit,"%s=X:%s:%s",P_PERMIT,disphost,relhost);
/*
DEBUG: don't check X-client host
	sprintf(permit,"%s=X:%s:*",P_PERMIT,disphost);
*/
	av[ac++] = permit;

	if( env = getEnv(P_CONNECT) ){
		sprintf(conn,"%s=%s",P_CONNECT,env);
		av[ac++] = conn;
	}

	if( lVERB() )
		av[ac++] = "-vv";
	if( env = getEnv(P_VARDIR) ){
		sprintf(vardir,"%s=%s",P_VARDIR,env);
		av[ac++] = vardir;
	}
	if( env = getEnv(P_LOGDIR) ){
		sprintf(logdir,"%s=%s",P_LOGDIR,env);
		av[ac++] = logdir;
	}
	if( env = getEnv(P_LOGFILE) ){
		sprintf(logfile,"%s=%s",P_LOGFILE,env);
		av[ac++] = logfile;
	}

	sprintf(desc,"(X proxy for %s)",me);
	av[ac++] = desc;

	strcpy(hosts,"HOSTS=");
	dump_HOSTS(TVStr(hosts));
	av[ac++] = hosts;

	av[ac] = 0;
	Execvp("Xproxy",EXEC_PATH,av);
	Finish(0);
	return -1;
}



void fdcheck(PCStr(msg),int waits)
{	CStr(fds,256);
	refQStr(fdp,fds); /**/
	int fd;

	for( fd = 0; fd < 64; fd++ ){
		if( 0 <= file_uid(fd) ){
			sprintf(fdp,"[%2d]",fd);
			fdp += strlen(fdp);
		}
	}
	setVStrEnd(fdp,0);
	fprintf(stderr,"####[%d]%s ACTIVE FD: %s\n",getpid(),msg,fds);

	if( waits ){
		signal(SIGHUP, sigHUP);
		fprintf(stderr,"#### (%s) SLEEPING\n",msg);
		sleep(waits);
	}
}

static int callFunc(Connection *Conn,int ac,const char *av[],Efd *clSock,int svsock)
{	const char *env;
	iFUNCP func;
	const char *funcenv;
	const char *arg;
	int clsock;

	clsock = getEfd(clSock);
	config(Conn,clsock);

	funcenv = getenv("FUNCADDR");
	sscanf(funcenv,"%x",&func);
	arg = getenv("FUNCARG");
	Verbose("EXEC START: %d %d func=%x arg[%s]\n",
		clsock,svsock,func,arg);
	(*func)(Conn,clsock,svsock,ac,av,arg);
	Finish(0);
	return -1;
}
int execFunc(Connection *Conn,int clsock,int svsock,iFUNCP func,PCStr(arg))
{	Efd clSockb,*clSock = &clSockb;
	CStr(funcenv,32);
	CStr(argenv,4098);
	int pid;

	if( INHERENT_fork() )
		if( pid = fork() )
			return pid;

	if( Conn == NULL )
		Conn = mainConn;

	sprintf(funcenv,"FUNCADDR=%x",func); putenv(funcenv);
	sprintf(argenv,"FUNCARG=%s",arg); putenv(argenv);

	Verbose("START EXEC: %d %d func=%x arg[%s]\n",
		clsock,svsock,func,arg);

	setEfd(clSock,clsock,"","",0);

	if( 0 <= clsock ) setclientsock(clsock);
	if( 0 <= svsock ) setserversock(svsock);
	pid = EXEC_client1(Conn,EXEC_PATH,FuncFunc,svsock,clSock);
	return pid;
}

extern const char *mainProcTitleFmt;
void mainProcTitle(Connection *Conn)
{	CStr(stat,256);

	strfLoadStat(AVStr(stat),sizeof(stat),mainProcTitleFmt,time(NULL));
	ProcTitle(Conn,stat);
}

#define PSTITLE_END "--"
extern struct { defQStr(p); } pstitle_area;
extern int   pstitle_size;
extern int   pstitle_lengmax;
extern int   pstitle_leng; /* length of original arguments */
static char *pstitle_head;
static char *pstitle_tail;
static int   pstitle_tailleng;

void setProcTitleHead(PCStr(arg0),int ac,const char *av[])
{	CStr(buff,1024);
	const char *arg;
	int ai,bi,len,dispend;

	if( lEXEC() ){
		/* don't show internal parameters for internal exec (-x) */
		return;
	}
	wordScan(arg0,buff);
	Strdup(&pstitle_head,buff);

	bi = 0;
	dispend = 0;
	for( ai = 1; ai < ac; ai++ ){
		arg = av[ai];
		len = strlen(arg);
		if( strncmp(arg,PSTITLE_END,strlen(PSTITLE_END)) == 0 ){
			dispend = ai;
			break;
		}
		if( sizeof(buff) <= bi + len )
			break;
		setVStrElemInc(buff,bi,' ');
		Xstrcpy(DVStr(buff,bi),arg);
		bi += len;
	}
	if( dispend == 0 )
		bi = 0;
	setVStrEnd(buff,bi);
	pstitle_tailleng = bi;
	Strdup(&pstitle_tail,buff);
}
void ProcTitle(Connection *Conn,PCStr(fmt),...)
{	CStr(buff,4096);
	refQStr(sp,buff); /**/
	const char *tail;
	int bsize,minleng;
	VARGS(8,fmt);

	if( Conn == NULL )
		return;
	if( pstitle_head == NULL )
		return;

	/*
	 * ps-title string set as argv[0] should be long enough
	 * so that possibly cached argv[1-] string is not shown
	 */
	minleng = 80;

	bsize = pstitle_lengmax;
	if( sizeof(buff) < bsize )
		bsize = sizeof(buff);
	if( bsize < minleng )
		minleng = bsize;

	if( IsMacOSX() )
		sp = Sprintf(AVStr(sp),"%s= -{",pstitle_head);
	else	sp = Sprintf(AVStr(sp),"%s -{",pstitle_head);
	if( Getpid() != ServerPID ){
		sp = Sprintf(AVStr(sp),"%03d+%02d",CHILD_SERNO,CHILD_SERNO_MULTI);
		if( RequestSerno || ServReqSerno )
			sp = Sprintf(AVStr(sp),"/%03d",RequestSerno);
		if( ServReqSerno )
			sp = Sprintf(AVStr(sp),"/%03d",ServReqSerno);
	}else{
		sp = Sprintf(AVStr(sp),"%03d",CHILD_SERNO);
		if( StickyDone || CHILD_SERNO_SINGLE )
			sp = Sprintf(AVStr(sp),":");
		if( 0 < StickyDone )
			sp = Sprintf(AVStr(sp),"%03d/%03d",StickyNserved,StickyDone);
		if( 0 < CHILD_SERNO_SINGLE )
			sp = Sprintf(AVStr(sp),"+%03d",CHILD_SERNO_SINGLE);
	}
	if( 0 < ClientSock ){
		sp = Sprintf(AVStr(sp),":");
		if( getClientHostPort(Conn,AVStr(sp)) )
			sp += strlen(sp);
	}

	sp = Sprintf(AVStr(sp),"}[");
	sp = Sprintf(AVStr(sp),fmt,VA8);
	sp = Sprintf(AVStr(sp),"]-P");
	primaryPort(AVStr(sp));
	sp += strlen(sp);
	sp = Sprintf(AVStr(sp),pstitle_tail);
	sp = Sprintf(AVStr(sp)," -- ");

	if( sp - buff < minleng ){
		tail = buff + minleng -1;
		while( sp < tail )
			setVStrPtrInc(sp,'-');
		setVStrPtrInc(sp,0);
	}

	if( bsize <= sp-buff){
		sv1tlog("ProcTitle overflow: %d\n",sp-buff);
		setVStrEnd(buff,bsize-1);
		sv1tlog("ProcTitle overflow: %s\n",buff);
		Finish(-1);
	}
	proc_title("%s",buff);
}
void LOG_makeTime(MemFile *MemF,int now,int usec)
{	CStr(tms,1024);

	StrftimeLocal(AVStr(tms),sizeof(tms),TIMEFORM_mdHMS,now,0);
	str_sprintf(MemF,"%s.%02d [%d] %d+%d",
		tms,usec/10000,Getpid(),SERNO(),SERNO_MINOR());
	if( REQUEST_SERNO || SERVREQ_SERNO )
		str_sprintf(MemF,"/%d",REQUEST_SERNO);
	if( SERVREQ_SERNO )
		str_sprintf(MemF,"/%d",SERVREQ_SERNO);
	str_sprintf(MemF,": ");
}
void LOG_putTime(FILE *fp)
{	int now,usec;
	CStr(tms,1024);

	now = Gettimeofday(&usec);
	StrftimeLocal(AVStr(tms),sizeof(tms),TIMEFORM_mdHMS,now,0);
	fprintf(fp,"%s.%02d [%d] %d+%d",
		tms,usec/10000,getpid(),SERNO(),SERNO_MINOR());
	if( REQUEST_SERNO )
		fprintf(fp,"/%d",REQUEST_SERNO);
	fputs(": ",fp);
}
int incRequestSerno(Connection *Conn)
{
	return REQUEST_SERNO = ++RequestSerno;
}
int incServReqSerno(Connection *Conn)
{
	return SERVREQ_SERNO = ++ServReqSerno;
}


void minit_logs();
void minit_main();
void minit_resconf();
void minit_tmpfile();
void minit_html();
void minit_timer();
void minit_socks5();
void minit_hostlist();
void minit_ports();
void minit_inets();
void minit_access();
void minit_mount();
void minit_loadstat();
void minit_envs();
void minit_script();
void minit_socks();
void minit_ccache();
void minit_filetype();
void minit_textconv();
void minit_cron();
void minit_ftp();
void minit_smtp();
void minit_vsapcl();
void minit_url();

void minits(){
	minit_logs();
	minit_main();

	minit_resconf();
	minit_tmpfile();
	minit_html();
	minit_timer();
	minit_socks5();
	minit_hostlist();
	minit_ports();
	minit_inets();
	minit_access();
	minit_mount();
	minit_loadstat();
	minit_envs();
	minit_script();
	minit_socks();
	minit_ccache();
	minit_filetype();
	minit_textconv();
	minit_cron();
	minit_ftp();
	minit_smtp();
	minit_vsapcl();
	minit_url();
}

void dumpstacksize(PCStr(what),PCStr(fmt),...)
{	char *top;

	if( (char*)STACK_PEAK < (top = (char*)&what)){
		STACK_PEAK = top;
		if( LOG_type & L_RAND_TRACE ){
			CStr(buf,1024);
			VARGS(8,fmt);
			sprintf(buf,fmt,VA8);
			sv1log("{Rstack}%6d %s %s\n",STACK_BASE-top,what,buf);
		}
	}
}

extern int RANDSTACK_RANGE;
extern int RANDSTACK_UNIT;
void mainX(int ac,const char *av[])
{	int ai;
	const char *arg;
	const char *areap;
	int areal,areas;

	STACK_BASE = (char*)(((long int)&ac) | 0xFFFFF);

	for( ai = 0; ai < ac; ai++ ){
		arg = av[ai];
		if( *arg == '-' && arg[1] == 'R' )
		{
			RAND_TRACE = 1;
			LOG_type |= L_RAND_TRACE;
		}
	}
	areap = 0;
	av = (const char**)move_envarg(ac,av,&areap,&areal,&areas);
	if( areap ){
		pstitle_leng = areal;
		setQStr(pstitle_area.p,(char*)areap,areas);
		pstitle_size = areas;
	}
	setProcTitleHead(av[0],ac,av);
	if( INHERENT_alloca() ){
		RANDSTACK_RANGE = 1024;
		RANDSTACK_UNIT = 96;
	}
	randstack_call(SB_PROC,(iFUNCP)delegate_main,ac,av);
	/* do not return to possibly mushed stack */
	exit(-1);
}
void checkstdlog(PCStr(msg)){
	int fd;
	for( fd = 0; fd < 256; fd++ )
		if( file_cmp(1,fd) == 0 )
			fprintf(stderr,"###[%s] SAME %d\n",msg,fd);
}

