#!/bin/sh

DGROOT=`../src/delegated -Fdump DGROOT`
echo "#####################################################################"
echo "# installing {$*} at DGROOT/subin/" where
echo "#   DGROOT=$DGROOT"
echo "# if above DGROOT is not appropriate, then set it as environment"
echo "# variable before doing 'make install'"
echo "#####################################################################"
set -x
LIBDIR=$DGROOT/lib
ETCDIR=$DGROOT/etc
BINDIR=$DGROOT/bin
SUBINDIR=$DGROOT/subin

if [ ! -d "$LIBDIR" ]; then mkdir "$LIBDIR"; fi
if [ ! -d "$ETCDIR" ]; then mkdir "$ETCDIR"; fi
if [ ! -d "$BINDIR" ]; then mkdir "$BINDIR"; fi
if [ ! -d "$SUBINDIR" ]; then mkdir "$SUBINDIR"; fi

if [ -d $LIBDIR ]; then
	cp -p /etc/resolv.conf $ETCDIR
#	cp -p `which /usr/bin/gzip` $BINDIR
	cp -p /lib/ld*so* $LIBDIR
	cp -p /lib/libc.so* $LIBDIR
	cp -p /lib/libdl.so* $LIBDIR
	cp -p /lib/libnsl.so* $LIBDIR
	cp -p /lib/libpam.so* $LIBDIR
	cp -p /lib/libnss*.so* $LIBDIR
	cp -p /lib/libcript*.so* $LIBDIR
	cp -p /lib/libssl.so* $LIBDIR
	(cd $SUBINDIR; rm -f $*)
	mv $* $SUBINDIR
	cd $SUBINDIR

	echo "#### setting the owner of $*"

	### sudo for MacOS X
	sudo sh -c "chown root $*; chmod 6550 $*"

	if [ $? != 0 ]; then
		su root -c "chown root $*; chmod 6550 $*"
	fi

	set +x
	if [ $? = 0 ]; then
		echo "################################"
		echo "#  OK, installed successfully  #"
		echo "################################"
		pwd
		ls -l $*
	fi
fi

#
# gdb delegated
# (gdb) break main
# (gdb) run
# (gdb) info sharedlibrary
#
# Linux: man ld.so
# LD_BIND_NOW=on
# LD_TRACE_LOADED_OBJECTS=on
#
# MacOS X: man dyld
# DYLD_BIND_AT_LAUNCH=
# DYLD_PRINT_LIBRARIES=
#
# OSF/1: man loader
# _RLD_ARGS=-trace
#
# SunOS5: man ld (/usr/lib/ld.so.1)
# LD_PRELOAD
# LD_DEBUG
