/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994-1999 Electrotechnical Laboratry (ETL), AIST, MITI
Copyright (c) 1994-1999 Yutaka Sato

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	inets.c (INET Socket manipulation)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	March94	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include "ystring.h"
#include "vsignal.h"
#include "vsocket.h"
#include "vaddr.h"
#include "dglib.h"
#include "fpoll.h"
#include "file.h"
#include "proc.h"
#include "log.h"

char *IPV4MAPV6 = "__0";

#define SETsockopt(s,l,o,v,n)	Setsockopt(s,l,o,(char*)v,n)
#define Recvfrom(s,b,z,f,n,l)	recvfrom(s,b,z,f,n,l)

int RES_order(PCStr(order),xPVStr(porder));
int RES_next_res(PCStr(where),int ri,PVStr(res),PVStr(arg));
int RES_conf(PCStr(path));
int RES_ns(PCStr(nslist));
void RES_af(PCStr(af));
void RES_verify(PCStr(verify));
void RES_roundrobin(PCStr(hosts));
int RES_timeout(int timeout);

int isWindows();
int hostlocal2path(PCStr(host),PVStr(path),int size);
void inetNtoa(int addr,PVStr(saddr));
int VSA_comp(VSAddr *vsa1,VSAddr *vsa2);
void inet_itoaV4(int iaddr,PVStr(saddr));
int setsockSHARE(int sock,int onoff);
int connectTO(int sock,SAP addr,int leng,int timeout);

int server_open_un(PCStr(what),PVStr(path),int nlisten);
int client_open_un(PCStr(what),PCStr(path),int timeout);
int client_open_unX(PCStr(what),int sock,PCStr(path),int timeout);

int ViaVSAPassociator(int sock);
int VSAPgetsockname(int rsock,PVStr(sockname));
int CTX_VSAPbind(DGC*Conn,PVStr(sockname),int nlisten);

int fromTunnel(DGC*Conn,int sock);
int connectViaTunnel(DGC*xConn,PCStr(proto),PCStr(host),int port);
int VSA_getViaSocks(DGC*Conn,PCStr(host),int port,VSAddr *vlocal);
int toTunnel(DGC*Conn);
int SRCIFfor(DGC*Conn,PCStr(proto),PCStr(rhost),int rport,PVStr(lhost),int *lport);

#if _MSC_VER
#define CONNECT_POLLOUT
#endif

#define NHOSTS 128
typedef struct {
	int	hc_index;
	int	hc_freq;
	int	hc_predef;
	int	hc_mtime;
	int	hc_shuffled; /* initial shuffling done */
 struct hostent	hc_hostent;
} Hostent;

#define NIFTO	32
typedef struct {
	VAddr	if_dest;
	VAddr	if_mask;
	VAddr	if_ifto;
} IfTo;

#ifdef NONEMPTYARRAY
#define ie_inets_errmsgBASE	ie_inets_errmsg
#define ie_myFQDN_unknownBASE	ie_myFQDN_unknown
#endif

typedef struct {
	xMStr(	ie_inets_errmsg,1024);
     sigjmp_buf	ie_jmpEnv;
	int	ie_NHosts;
       Hostent *ie_HostsCache[NHOSTS]; /**/
  const	char   *ie_myFQDN;
	xMStr(	ie_myFQDN_unknown,32);
	int	ie_ADDRLIST_RR;
	AMStr(	ie_inAddrs,8,64);
	int	ie_inAddrx;
	FILE   *ie_res_logf;
	int	ie_gotsig;
  const	char   *ie_SRCHOST;
	int	ie_SRCPORT;
	IfTo  **ie_iftoV;
	int	ie_iftoN;
	int	ie_CACHE_ONLY;
	int	ie_HOSTS_PREDEF;
	double	ie_resStart;
	int	ie_REUSE;
	int	ie_REUSEPORT;
	int	ie_SHUTDOWN;
	int	ie_DO_SHUFFLE; /* round-robin in the current implementation */
} InetsEnv;
static InetsEnv *inetsEnv;
#define IE	inetsEnv[0]

#define inets_errmsg	IE.ie_inets_errmsg
/**/
#define jmpEnv		IE.ie_jmpEnv
#define NHosts		IE.ie_NHosts
#define HostsCache	IE.ie_HostsCache
#define myFQDN		IE.ie_myFQDN
#define myFQDN_unknown	IE.ie_myFQDN_unknown
/**/
#define ADDRLIST_RR	IE.ie_ADDRLIST_RR
#define inAddrs		IE.ie_inAddrs
/**/
#define inAddrx		IE.ie_inAddrx
#define res_logf	IE.ie_res_logf
#define gotsig		IE.ie_gotsig
#define SRCHOST		IE.ie_SRCHOST
#define SRCPORT		IE.ie_SRCPORT
#define iftoV		IE.ie_iftoV
#define iftoN		IE.ie_iftoN
#define CACHE_ONLY	IE.ie_CACHE_ONLY
#define HOSTS_PREDEF	IE.ie_HOSTS_PREDEF
#define resStart	IE.ie_resStart
#define REUSE		IE.ie_REUSE
#define REUSEPORT	IE.ie_REUSEPORT
#define SHUTDOWN	IE.ie_SHUTDOWN
#define DO_SHUFFLE	IE.ie_DO_SHUFFLE

void minit_inets(){
	if( inetsEnv == 0 ){
		inetsEnv = NewStruct(InetsEnv);
		REUSE = 1;
		SHUTDOWN = 1;
	}
}

int addrIsWildcard(PCStr(addr)){
	if( strcaseeq(addr,"__") ) return 1;
	if( strcaseeq(addr,"0.0.0.0") ) return 1;
	if( strcaseeq(addr,IPV4MAPV6) ) return 1;
	return 0;
}

#define sv1log syslog_ERROR

#define RESOLVERS_SIZ	512

extern struct { defQStr(resolv_errmsg); } resolv_errmsg;

static scanListFunc conf1(PCStr(conf))
{	const char *name;
	CStr(nameb,32);
	const char *val;
	int neg;

	val = wordscanY(conf,AVStr(nameb),sizeof(nameb),"^:");
	if( *val == ':' )
		val++;
	if( strncasecmp(nameb,"no",2) == 0 ){
		neg = 1;
		name = nameb + 2;
	}else{
		neg = 0;
		name = nameb;
	}
	if( strcaseeq(name,"reuse") ){
		REUSE = !neg;
	}else
	if( strcaseeq(name,"share") ){
		REUSEPORT = !neg;
	}
	else
	if( strcaseeq(name,"shut") ){
		SHUTDOWN = !neg;
	}
	return 0;
}
int setREUSEADDR(int on)
{	int reuse;

	reuse = REUSE;
	REUSE = on;
	return reuse;
}
void scan_SOCKOPT(DGC*ctx,PCStr(conf))
{
	scan_commaList(conf,0,scanListCall conf1);
}

extern int IPV6_unify4mapped;
int IPV6_v6also = 0;
int IPV6_v4also = 0;
static scanListFunc ipconf1(PCStr(conf))
{	const char *name;
	CStr(nameb,32);
	const char *val;
	int neg;

	val = wordscanY(conf,AVStr(nameb),sizeof(nameb),"^:");
	if( *val == ':' )
		val++;
	if( streq(nameb,"4map") ){
		if( streq(val,"no") )
			IPV6_unify4mapped = 0;
		else	IPV6_unify4mapped = 1;
	}else
	if( streq(nameb,"6also") ){
		if( streq(val,"no") )
			IPV6_v6also = 0;
		else	IPV6_v6also = 1;
	}else
	if( streq(nameb,"4also") ){
		if( streq(val,"no") )
			IPV6_v4also = 0;
		else	IPV6_v4also = 1;
	}
	return 0;
}
void scan_IPV6(DGC*ctx,PCStr(conf))
{
	scan_commaList(conf,0,scanListCall ipconf1);
}


/*###################### LIBRARY BEGIN ################################*/

int getFQDN(PCStr(name),PVStr(fqdn))
{	CStr(porder,RESOLVERS_SIZ);
	struct hostent *hp;

	/* SPECIAL HOST NAME IN DeleGate */
	if( strcmp(name,"-")==0 || strcmp(name,"-.-")==0 ){
		Xovstrcpy(AVStr(fqdn),name);
		return 0;
	}
	if( strcmp(name,"localhost") == 0 ){
		Xovstrcpy(AVStr(fqdn),name);
		return 1;
	}
	RES_order("D",AVStr(porder));
	hp = gethostbyname(name);
	RES_order(porder,VStrNULL);
	if( hp != NULL ){
		strcpy(fqdn,hp->h_name);
		return 1;
	}
	if( name != fqdn )
		strcpy(fqdn,name);
	return 0;
}
int gethostFQDN(PVStr(fqdn),int size)
{	CStr(host,1024);

	gethostname(host,sizeof(host));
	return getFQDN(host,AVStr(fqdn));
}
void getPrimName(PCStr(host),PVStr(prim))
{	struct hostent *hp;

	/* SPECIAL HOST NAME IN DeleGate */
	if( strcmp(host,"-")==0 || strcmp(host,"-.-")==0 )
		strcpy(prim,host);
	else
	if( hp = gethostbyname(host) )
		strcpy(prim,hp->h_name);
	else	strcpy(prim,host);
}

int fshutdown(FILE *fp,int force)
{
	if( SHUTDOWN == 0 && force == 0 )
		return -1;

	if( !file_ISSOCK(fileno(fp)) )
		return -1;

	fflush(fp);
	shutdown(fileno(fp),1);
	/* close(fileno(fp)); ... to do closesocket() on Win32 */
	return 0;
}

/*###################### LIBRARY END ##################################*/

#ifndef LIBRARY

int LIN_TIMEOUT = 30;
int DNS_TIMEOUT = 10;
int ACC_TIMEOUT = 10;
int CON_TIMEOUT = 10;

int CONNERR_TIMEOUT;
int CONNERR_CANTRESOLV;
int CONNERR_UNREACH;
int CONNERR_REFUSED;

static int HOSTS_CACHE_LIFE_MIN = 10;
static int HOSTS_CACHE_LIFE_MAX = 0;
extern int RES_CACHE_DISABLE;
extern int RES_HC_EXPIRE;

static void sigALRM(int sig){ siglongjmp(jmpEnv,SIGALRM); }
static void sigPIPE(int sig){ siglongjmp(jmpEnv,SIGPIPE); }

#ifdef CONNECT_POLLOUT
int Bconnect(int s,VSAddr *name,int namelen)
{	int rcode;
	double Start,Elapse;
	CStr(hp,512);

	Start = Time();
	rcode = connectTO(s,(SAP)name,namelen,CON_TIMEOUT*1000);
	if( rcode != 0 && errno == ETIMEDOUT ){
		Elapse = Time() - Start;
		daemonlog("E","*** CON_TIMEOUT: %4.2f/%ds -> %s\n",
			Elapse,CON_TIMEOUT,VSA_xtoap(name,AVStr(hp),sizeof(hp)));
	}
	return rcode;
}
#else
int Bconnect(int s,VSAddr *name,int namelen)
{	int rcode;
	int timer;
	double Start;
	CStr(hp,512);

	if( CON_TIMEOUT ){
		timer = pushTimer("Bconnect",sigALRM,CON_TIMEOUT);
		Start = Time();
		if( sigsetjmp(jmpEnv,1) != 0 ){
			daemonlog("E","*** CON_TIMEOUT: %4.2f/%ds -> %s\n",
				Time()-Start,CON_TIMEOUT,
				VSA_xtoap(name,AVStr(hp),sizeof(hp)));
			popTimer(timer);
			CONNERR_TIMEOUT = 1;
			errno = ETIMEDOUT;
			return -1;
		}
	}

	rcode = connect(s,(SAP)name,namelen);

	if( CON_TIMEOUT )
		popTimer(timer);

	return rcode;
}
#endif

int RESOLV_UNKNOWN;
extern int ERROR_RESTART;
struct hostent *Dgethostbyname(PCStr(name))
{	struct hostent *ht;
	int fd;

	if( name[0] == 0 )
		return NULL;
	if( strncmp(name,"--",2) == 0 ) /* --Cant-GetPeerName */
		return NULL;

if( strchr(name,'%') ){
	CStr(xname,512);
	sv1log("## unescape host-name before gethostbyname: %s\n",name);
	nonxalpha_unescape(name,AVStr(xname),0);
	name = xname;
}

	/*
	if( inet_addrV4(name) != -1 ){
		sv1log("#### simulate INCONSISTENT DNS\n");
		return NULL;
	}
	*/

	/* SPECIAL HOST NAME IN DeleGate */
	if( strcmp(name,"-")==0 || strcmp(name,"-.-")==0 )
		return NULL;
	if( strcmp(name,"*")==0 )
		return NULL;

	fd = nextFD();
	ht = NULL;

	if( ht == NULL ){
		Verbose("gethostbyname(%s).\n",name);
		ht = gethostbyname(name);
	}
	if( ht == NULL ){
		RESOLV_UNKNOWN++;
		if( ERROR_RESTART )
		sv1log("eRESTART unknown*%d gethostbyname(%s)\n",
			RESOLV_UNKNOWN,name);
	}
	usedFD(fd);
	return ht;
}
struct hostent *Dgethostbyaddr(PCStr(addr),int len,int type)
{	struct hostent *ht;
	int fd;

	if( *(int*)addr == 0 || *(int*)addr == -1 )
		return NULL;

	fd = nextFD();
	ht = gethostbyaddr(addr,len,type);

	usedFD(fd);
	return ht;
}
static struct hostent *Dgethostbynameaddr(PCStr(name),PCStr(addr),int len,int type)
{
	if( name != NULL )
		return Dgethostbyname(name);
	else	return Dgethostbyaddr(addr,len,type);
}

static scanListFunc order1(PCStr(typespec),PVStr(order) /*,char *servers[]*/)
{	CStr(type,128);
	CStr(arg,256);

	type[0] = arg[0] = 0;
	Xsscanf(typespec,"%[^:]:%s",AVStr(type),AVStr(arg));

	if( strcasecmp(type,"cache") == 0 )
		strcat(order,"C");
	else
	if( strcasecmp(type,"file") == 0 )
	{
		strcat(order,"F");
		newPath(AVStr(arg));
	}
	else
	if( strcasecmp(type,"nis") == 0 )
		strcat(order,"N");
	else
	if( strcasecmp(type,"dns") == 0 )
		strcat(order,"D");
	else
	if( strcasecmp(type,"sys") == 0 )
		strcat(order,"S");

	if( arg[0] )
		Xsprintf(TVStr(order),":%s,",arg);
	return 0;
}

extern int (*RES_log)(int,...);
static void res_log(int which,int byname,PCStr(name),char *rv[],PCStr(cname))
{	double Now;

	Now = Time();
	if( which == 0 )
		resStart = Now;
	else{
		fprintf(res_logf,"%.3f %.4f %d %c %s\n",
			Now,Now-resStart,Getpid(),which,name);
		fflush(res_logf);
	}
}

void RES_prorder(PCStr(resolvers),PVStr(resolv))
{	int ri;
	const char *res;
	CStr(res1,128);
	CStr(arg,128);
	refQStr(rp,resolv); /**/

	for( ri = 0; ri = RES_next_res(resolvers,ri,AVStr(res1),AVStr(arg)); ){
		switch( res1[0] ){
		case 'C': res = "cache"; break;
		case 'F': res = "file"; break;
		case 'N': res = "nis"; break;
		case 'D': res = "dns"; break;
		case 'S': res = "sys"; break;
		default: res = res1; break;
		}
		if( rp != resolv )
			setVStrPtrInc(rp,',');
		strcpy(rp,res);
		rp += strlen(rp);
	}
	setVStrEnd(rp,0);
}

void init_myname(PCStr(RESOLV));
void init_resolv(PCStr(resolv),PCStr(conf),PCStr(ns),PCStr(af),PCStr(verify),PCStr(rr),PCStr(debug),PCStr(log))
{
	if( debug != NULL )
		RES_debug(debug);
	if( rr != NULL )
		RES_roundrobin(rr);
	if( af != 0 )
		RES_af(af);

	if( log != NULL ){
		if( res_logf = fopen(log,"a") ){
			setCloseOnExec(fileno(res_logf));
			RES_log = (int(*)(int,...))res_log;
		}
	}

	if( resolv != NULL ){
		CStr(order,RESOLVERS_SIZ);
		CStr(porder,RESOLVERS_SIZ);
		order[0] = 0;
		scan_commaList(resolv,0,scanListCall order1,AVStr(order));
		RES_order(order,AVStr(porder));
		if( *resolv == 0 )
			CACHE_ONLY = 1;
	}
	if( conf != NULL )
		RES_conf(conf);
	if( ns != NULL )
		RES_ns(ns);
	if( verify != NULL )
		RES_verify(verify);

	init_myname(resolv);
}

static void shuffle_addrlist(struct hostent *hp)
{	const char *haddr;
	const char *haddr0;
	int hi;

	if( hp->h_addr_list[0] == NULL || hp->h_addr_list[1] == NULL )
		return;

	if( ADDRLIST_RR ){
		haddr0 = hp->h_addr_list[0];
		for( hi = 0; haddr = hp->h_addr_list[hi+1]; hi++ )
			hp->h_addr_list[hi] = hp->h_addr_list[hi+1];
		hp->h_addr_list[hi] = (char*)haddr0;
	}
}
extern int CHILD_SERNO;
static void shift_addrlist(struct hostent *hp)
{	int na,sn,si;

	for( na = 0; hp->h_addr_list[na]; na++ )
		;
	if( na < 2 )
		return;
	sn = CHILD_SERNO % na;
	if( sn == 0 )
		return;
	for( si = 0; si < sn; si++ )
		shuffle_addrlist(hp);
}

static int findName1(struct hostent *hp,PCStr(name))
{	const char *name1;
	int ai;

	if( hp->h_name )
		if( strcasecmp(name,hp->h_name) == 0 )
			return 1;

	if( hp->h_aliases )
	for( ai = 0; name1 = hp->h_aliases[ai]; ai++ )
		if( strcasecmp(name,name1) == 0 )
			return 1;
	return 0;
}
static int findAddr1(struct hostent *hp,PCStr(addr),int len,int type)
{	int ai;
	const char *addr1;

	for( ai = 0; addr1 = hp->h_addr_list[ai]; ai++ )
		if( memcmp(addr,addr1,len) == 0 )
			return 1;
	return 0;
}
static Hostent *findHostCache(PCStr(name),PCStr(addr),int len,int type)
{	int hi,ai,freq;
	Hostent *Hp;
	struct hostent *hp;

	for( hi = 0; hi < NHosts; hi++ ){
		Hp = HostsCache[hi];
		hp = &Hp->hc_hostent;
		if( name ){
			if( findName1(hp,name) )
				goto found;
		}else{
			if( findAddr1(hp,addr,len,type) )
				goto found;
		}
	}
	return 0;
found:
	freq = Hp->hc_freq += 1;
/*
	if( name )
		Verbose("*** HIT[%d] gethostbyname(%s)\n",freq,name);
	else	Verbose("*** HIT[%d] gethostbyaddr(): %s\n",freq,hp->h_name);
*/
	return Hp;
}
static const char **addAliases(struct hostent *hp,int mac,const char *aliasesb[],PCStr(name))
{	int ai;
	const char *name1;

	if( name == 0 )
		return (const char**)hp->h_aliases;

	if( findName1(hp,name) )
		return (const char**)hp->h_aliases;

	for( ai = 0; name1 = hp->h_aliases[ai]; ai++ ){
		if( mac-1 <= ai )
			break;
		aliasesb[ai] = (char*)name1;
	}
	aliasesb[ai++] = (char*)name;
	aliasesb[ai] = 0;
	return aliasesb;
}

/*
 * TODO: chache should be normalized so that only N to 1 correspondence
 *       (N names to an address) are included, to make update easy ???
 */
static char *dump_HOST1(PVStr(hosts),struct hostent *hp);
static struct hostent *addHostCache(PCStr(name),const char *const*aliases,int type,int len,const char *const*addrlist)
{	struct hostent *chp;
	int na,ai;
	Hostent *He;
	CStr(hosts,2048);

	chp = NULL;

	/*
	 *  chp = first occurence of entry which include
	 *        name, aliases, or addrlist in it, if exists.
	 */

	if( chp == NULL && NHosts < NHOSTS ){
		He = NewStruct(Hostent);
		He->hc_index = NHosts;
		HostsCache[NHosts++] = He;
		He->hc_predef = HOSTS_PREDEF;
		He->hc_mtime = time(NULL);
		chp = &He->hc_hostent;
	}
	if( chp != NULL ){
		chp->h_name = stralloc(name);
		chp->h_aliases = (char**)dupv((const char**)aliases,0);
		chp->h_addrtype = type;
		chp->h_length = len;
		chp->h_addr_list = (char**)dupv((const char**)addrlist,len);
		dump_HOST1(AVStr(hosts),chp);
		Verbose("HOSTS[%d]=%s %s\n",He->hc_index,hosts,He->hc_predef?"(PREDEF)":"");
		return chp;
	}
	return 0;
}
static int replaceHostCache(PCStr(name),PCStr(addr),int len,int type, int now,Hostent *Hp,struct hostent *hp)
{	const char *hname;
	const char *addrlistb[2]; /**/
	const char **addrlist;
	int addrleng;
	int addrtype;
	struct hostent *chp = &Hp->hc_hostent;
	int replaced;

	if( hp ){
		if( name && hp->h_name )
		if( strcmp(name,hp->h_name) != 0 ){
			sv1log("HOSTS[%d] cache can't be overwritten: %s->%s\n",
				Hp->hc_index,name,hp->h_name);
			Hp->hc_mtime = now;
			return 0;
		}
		hname = hp->h_name;
		addrlist = (const char**)hp->h_addr_list;
		addrleng = hp->h_length;
		addrtype = hp->h_addrtype;
	}else{
		addrlist = addrlistb;
		if( name ){
			hname = name;
			addrlist[0] = 0;
			addrleng = 4;
			addrtype = AF_INET;
		}else{
			hname = "";
			addrlist[0] = (char*)addr;
			addrlist[1] = 0;
			addrleng = len;
			addrtype = len==4?AF_INET:AF_INET6;
		}
	}
	replaced = 0;
	if( name ){
		/*
		if( chp->h_addr_list[0] && addrlist[0] == 0 ){
			sv1log("#### INCONSISTENT but don't clear cache: %s\n",name);
		}else
		*/
		if( cmpv((const char**)chp->h_addr_list,addrlist,addrleng) ){
			freev(chp->h_addr_list);
			chp->h_addr_list = (char**)dupv(addrlist,addrleng);
			chp->h_addrtype = addrtype;
			chp->h_length = addrleng;
			replaced = 1;
		}
	}else{
		if( strcmp(chp->h_name,hname) != 0 ){
			free(chp->h_name);
			chp->h_name = stralloc(hname);
			replaced = 1;
		}
	}
	if( replaced ){
		sv1log("HOSTS[%d] cache by-%s of '%s' replaced (age=%d)\n",
			Hp->hc_index,
			name?"name":"addr",name?name:hname,now-Hp->hc_mtime);
	}
	Hp->hc_mtime = now;
	return 1;
}

static struct hostent *addHostCacheOk(struct hostent *hp,PCStr(name),PCStr(func),double Start)
{	const char **aliases;
	const char *aliasesb[1024]; /**/

	daemonlog("D","*** %s: %s / %4.2f secs. has_alias:%d\n",
		func,hp->h_name,Time()-Start,
		(hp->h_aliases[0] ? 1:0));

	aliases = addAliases(hp,elnumof(aliasesb),aliasesb,name);
	return addHostCache(hp->h_name,aliases,hp->h_addrtype,hp->h_length,(const char**)hp->h_addr_list);
}
/*
static char *dumpAddr(PVStr(aaddr),PCStr(sba))
{	const unsigned char *ba = (unsigned char*)sba;
	return Sprintf(BVStr(aaddr),"%d.%d.%d.%d",ba[0],ba[1],ba[2],ba[3]);
}
*/
static char *dumpAddr(PVStr(aaddr),PCStr(sba),int len,int type){
	Sprintf(BVStr(aaddr),"%s",VSA_ltoa((unsigned char*)sba,len,type));
	return Sprintf(BVStr(aaddr),"%s",VSA_ltoa((unsigned char*)sba,len,type));
}
static char *scanAddrX(PCStr(aaddr),char ba[],int *lenp,int *typp){
	int typ,len;
	char bab[IPV6_ADDRLENG];
	len = VSA_atob(aaddr,bab,&typ);
	if( len <= 0 )
		return 0;
	bcopy(bab,ba,len);
	*lenp = len;
	*typp = typ;
	return ba;
}
/*
static char *scanAddr(PCStr(aaddr),char ba[])
{	int a0,a1,a2,a3;

	if( sscanf(aaddr,"%d.%d.%d.%d",&a0,&a1,&a2,&a3) != 4 )
		return 0;

	ba[0] = a0;
	ba[1] = a1;
	ba[2] = a2;
	ba[3] = a3;
	return ba;
}
*/

static void dumpAddrs(struct hostent *hp,PVStr(addrlist))
{
	const char *addr;
	int ai;

	setVStrEnd(addrlist,0);
	if( hp->h_addr_list[0] ){
		refQStr(lp,addrlist); /**/
		if( hp->h_addr_list[1] )
			lp = Sprintf(AVStr(lp),"{");
		for( ai = 0; addr = hp->h_addr_list[ai]; ai++ ){ 
			if( 0 < ai )
				lp = Sprintf(AVStr(lp),",");
			/*
			lp = dumpAddr(AVStr(lp),hp->h_addr_list[ai]);
			*/
			lp = dumpAddr(AVStr(lp),hp->h_addr_list[ai],hp->h_length,hp->h_addrtype);
		}
		if( hp->h_addr_list[1] )
			lp = Sprintf(AVStr(lp),"}");
	}
}
static char *dump_HOST1(PVStr(hosts),struct hostent *hp)
{	int ai;
	const char *name;
	refQStr(sp,hosts); /**/

	if( hp->h_aliases[0] ){
		sp = Sprintf(AVStr(sp),"{");
		sp = Sprintf(AVStr(sp),"%s",hp->h_name);
		for( ai = 0; name = hp->h_aliases[ai]; ai++ )
		sp = Sprintf(AVStr(sp),",%s",name);
		sp = Sprintf(AVStr(sp),"}");
	}else	sp = Sprintf(AVStr(sp),"%s",hp->h_name);
	sp = Sprintf(AVStr(sp),"/");
	dumpAddrs(hp,AVStr(sp));
	return (char*)sp + strlen(sp);
}
int dump_HOSTS(PVStr(hosts))
{	int hi;
	refQStr(sp,hosts); /**/

	setVStrEnd(hosts,0);
	for( hi = 0; hi < NHosts; hi++ ){
		if( 0 < hi )
			sp = Sprintf(AVStr(sp),",");
		sp = dump_HOST1(AVStr(sp),&HostsCache[hi]->hc_hostent);
	}
	if( ADDRLIST_RR ){
		if( 0 < NHosts )
			sp = Sprintf(AVStr(sp),",");
		strcpy(sp,"*/*/RR");
	}
	return NHosts;
}
static int find_HOSTS(PCStr(hosts))
{	int hi;
	CStr(hosts1,2048);

	for( hi = 0; hi < NHosts; hi++ ){
		dump_HOST1(AVStr(hosts1),&HostsCache[hi]->hc_hostent);
		if( strcmp(hosts,hosts1) == 0 )
			return 1;
	}
	return 0;
}
/*
static int list2v(xPVStr(slist),int mac,const char *vlist[],int isaddr)
*/
static int list2v(xPVStr(slist),int mac,const char *vlist[],int *isaddr)
{	int ni = 0;
	const char *dp;
	const char *tp;
	int len;
	int typ;

	if( slist[0] == '{' || strchr(slist,',') ){
		refQStr(np,slist); /**/
		if( slist[0] == '{' ){
			np = slist + 1;
			if( tp = strchr(np,'}') )
				truncVStr(tp);
		}else	np = slist;

		for(; np; np = (char*)dp){
			if( mac-1 <= ni ){
				fprintf(stderr,"list2v:too many elements\n");
				break;
			}
			if( dp = strchr(np,',') ){
				truncVStr(dp); dp++;
			}
			Verbose("[%d] %s\n",ni,np);
			if( isaddr )
			{
				np = scanAddrX(np,(char*)np,&len,&typ);
				*isaddr = (len << 16) | typ;
				/*
				np = scanAddr(np,(char*)np);
				*/
			}
			vlist[ni++] = np;
		}
		vlist[ni] = 0;
	}else{
		Verbose("[-] %s\n",slist);
		if( isaddr )
		{
			slist = scanAddrX(slist,(char*)slist,&len,&typ);
			*isaddr = (len << 16) | typ;
			/*
			slist = scanAddr(slist,(char*)slist);
			*/
		}
		vlist[0] = slist;
		vlist[1] = 0;
		ni = 1;
	}
	return ni;
}

static scanListFunc gethostbyname1(PCStr(name),xPVStr(addrb))
{	struct hostent *hp;

	if( hp = Dgethostbyname(name) ){
		if( *addrb != 0 ){
			addrb += strlen(addrb);
			setVStrElem(addrb,0,',');
			addrb++;
		}
		dumpAddrs(hp,AVStr(addrb));
		if( *addrb == 0 ){
			fprintf(stderr,"gethostbyname1:overlfow?\n");
			return -1;
		}
	}
	return 0;
}
static void gethostbynames(PCStr(names),PVStr(addrb))
{	CStr(nameb,0x4000);

	setVStrEnd(addrb,0);
	strcpy(nameb,names);
	scan_commaListL(nameb,0,scanListCall gethostbyname1,AVStr(addrb));
}
static scanListFunc addhost1(PCStr(nameaddr))
{	CStr(namesb,512);
	refQStr(names,namesb); /**/
	refQStr(addrs,namesb);
	CStr(addrb,512);
	const char *opts;
	const char *addrlist[64]; /**/
	const char *namelist[64]; /**/
	const char **aliases;
	int lentyp,len,typ;

	if( find_HOSTS(nameaddr) )
		return 0;

	if( strcmp(nameaddr,"CACHE_ONLY") == 0){
		CACHE_ONLY = 1;
		goto EXIT;
	}

	if( strlen(nameaddr) < sizeof(namesb) ){
		strcpy(names,nameaddr);
	}else{
		setQStr(names,stralloc(nameaddr),strlen(nameaddr)+1);
		cpyQStr(addrs,names);
	}
	if( addrs = strchr(names,'/') ){
		setVStrPtrInc(addrs,0);
		if( opts = strchr(addrs+1,'/') ){
			truncVStr(opts); opts++;
		}
	}else	opts = 0;
	if( strcmp(nameaddr,"*/*/RR") == 0 ){
		ADDRLIST_RR = 1;
		goto EXIT;
	}

	if( addrs == 0 ){
		gethostbynames(names,AVStr(addrb));
		if( addrb[0] == 0 )
			goto EXIT;
		addrs = addrb;
	}

	if( list2v(AVStr(names),elnumof(namelist),namelist,0) <= 0 )
		goto EXIT;
	/*
	if( list2v(AVStr(addrs),elnumof(addrlist),addrlist,1) <= 0 )
	*/
	lentyp = 0;
	if( list2v(AVStr(addrs),elnumof(addrlist),addrlist,&lentyp) <= 0 )
		goto EXIT;

	if( namelist[0] )
		aliases = &namelist[1];
	else	aliases = &namelist[0];
	if( lentyp ){
		typ = 0xFFFF & lentyp;
		len = 0xFFFF & (lentyp >> 16);
		addHostCache(namelist[0],aliases,typ,len,addrlist);
	}else
	addHostCache(namelist[0],aliases,AF_INET,4,addrlist /*,opts*/);

EXIT:
	if( names != namesb )
		free((char*)names);
	return 0;
}
void scan_HOSTS(DGC*_,PCStr(hosts))
{
	HOSTS_PREDEF = 1;
	scan_commaList(hosts,0,scanListCall addhost1);
	HOSTS_PREDEF = 0;
}

static struct hostent *gethostbyNameAddrNocache(PCStr(name),PCStr(addr),int len,int type)
{	struct hostent *hp;

	if( 0 < RES_timeout(DNS_TIMEOUT) ){
		hp = Dgethostbynameaddr(name,addr,len,type);
	}else{
		vfuncp sPIPE;
		int timer;

		sPIPE = Vsignal(SIGPIPE,sigPIPE);
		timer = pushTimer("gethostbyNameAddr",sigALRM,DNS_TIMEOUT);
		if( (gotsig = sigsetjmp(jmpEnv,1)) == 0 )
			hp = Dgethostbynameaddr(name,addr,len,type);
		else	hp = 0;
		signal(SIGPIPE,sPIPE);
		popTimer(timer);
	}
	return hp;

}
int RES_CACHEONLY(int flag)
{	int oflag;

	oflag = CACHE_ONLY;
	CACHE_ONLY = flag;
	return oflag;
}

int IsInetaddr(PCStr(addr))
{
	return addr != NULL && VSA_strisaddr(addr);
}

static struct hostent *gethostbyNameAddr(int cache_only,PCStr(name),PCStr(aaddr),int alen,int atype)
{	struct hostent *hp;
	struct hostent *chp;
	Hostent *Hp;
	double Start;
	CStr(func,1024);
	int nocache;
	int rexpire;
	int now;
	const char *addr = (char*)aaddr; /* VC++ does not allocate omitted argument */
	int len = alen;
	int type = atype;

	if( name != NULL && *name == 0 ){
		Verbose("gethostbyNameAddr(empty)\n");
		return NULL;
	}
	if( name != NULL && strtailstr(name,VSA_hostlocal()) )
		name = VSA_hostlocal();

	if( name && isinetAddr(name) ){
		VSAddr sab;
		VSA_atosa(&sab,0,name);
		len = VSA_decomp(&sab,&addr,&type,NULL);
		daemonlog("D","*** gethostbyname(%s) -> byaddr(%d,%d)\n",
			name,len,type);
		name = 0;
	}

	nocache = RES_CACHE_DISABLE;
	if( cache_only || CACHE_ONLY )
		nocache = 0;

	now = time(NULL);
	if( Hp = findHostCache(name,addr,len,type) ){
		int expired = 0;
		int age = 0;

		if( !Hp->hc_predef ){
			age = now - Hp->hc_mtime;
			if( nocache ){
				if( HOSTS_CACHE_LIFE_MIN < age )
					expired = 1;
			}else{
				if( HOSTS_CACHE_LIFE_MAX )
				if( HOSTS_CACHE_LIFE_MAX < age )
					expired = 1;
			}
		}
		if( !expired ){
			hp = &Hp->hc_hostent;
			if( hp->h_name[0] == 0 || hp->h_addr_list[0] == 0 )
			{
				hp = NULL;
				goto EXIT;
				/*
				return 0;
				*/
			}
/*
			else	return hp;
*/
			else{
				if( DO_SHUFFLE )
				if( ADDRLIST_RR && Hp->hc_shuffled == 0 )
				{
					shift_addrlist(hp);
					Hp->hc_shuffled = 1;
				}
				/*
				return hp;
				*/
				goto EXIT;
			}
		}
	}
	if( cache_only || CACHE_ONLY )
	{
		/*
		return 0;
		*/
		hp = NULL;
		goto EXIT;
	}

	Start = Time();
	setVStrEnd(resolv_errmsg.resolv_errmsg,0);

	if( nocache ){
		/* disalbling DNS cache for HTTP reload might be too heavy
		 * for large number of inline images loaded parallelly
		 */
		rexpire = RES_HC_EXPIRE;
		RES_HC_EXPIRE = 5;
		RES_CACHE_DISABLE = 0;
	}
	hp = gethostbyNameAddrNocache(name,addr,len,type);
	if( nocache ){
		RES_HC_EXPIRE = rexpire;
		RES_CACHE_DISABLE = nocache;
	}

	if( name != NULL )
		sprintf(func,"gethostbyname(%s)",name);
	else	sprintf(func,"gethostbyaddr(%s)",VSA_ltoa((unsigned char*)addr,len,type));

	if( hp == NULL )
	if( name != NULL && !IsInetaddr(name) || 1 < Time()-Start )
		daemonlog("E","%s unknown[%4.2fs] %s\n",func,
			Time()-Start,resolv_errmsg.resolv_errmsg);

	if( gotsig ){
		if( gotsig == SIGALRM )
			sv1log("*** TIMEOUT %s: %d secs.\n",func,DNS_TIMEOUT);
		else	sv1log("*** SIGPIPE on %s to DNS.\n",func);
/*
endhostent();
hostent_init = 0;
*/
	}else{
		if( Hp && replaceHostCache(name,addr,len,type, now,Hp,hp) )
		{
			/*
			return hp;
			*/
			goto EXIT;
		}

		if( hp == 0 ){
			const char *aliases[2]; /**/
			const char *addrlist[2]; /**/
			int addrleng;

			if( name ){
				addrlist[0] = 0;
				addrleng = 4;
			}else{
				addrlist[0] = (char*)addr;
				addrleng = len;
				name = "";
			}
			aliases[0] = 0;
			addrlist[1] = 0;
			chp = addHostCache(name,aliases,type,addrleng,addrlist);
		}else{
			chp = addHostCacheOk(hp,name,func,Start);
		}
	}
EXIT:
	if( hp == NULL ){
		CONNERR_CANTRESOLV = 1;
	}
	return hp;
}

static char *satoa(VSAddr *sa,PVStr(host))
{	const char *addr;

	if( addr = VSA_ntoa(sa) )
		return strcpy(host,addr);
	else	return strcpy(host,"(AF_UNIX)");
}
static char *saton(VSAddr *sa,PVStr(host))
{	struct hostent *hp;
	const char *baddr;
	int blen,btype;

	if( VSA_afunix(sa,AVStr(host),128) )
		return (char*)host;

	blen = VSA_decomp(sa,&baddr,&btype,NULL);
	hp = gethostbyNameAddr(0,NULL,baddr,blen,btype);
	if( hp != 0 )
		return strcpy(host,hp->h_name);
	else	return satoa(sa,AVStr(host));
}
void printSock(VSAddr *sa,PVStr(sockname),PCStr(form))
{	const char *addr;
	const char *fp;
	char fc;
	CStr(host,512);
	refQStr(sp,sockname); /**/

	for( fp = form; fc = *fp; fp++ ){
	    assertVStr(sockname,sp+1);
	    if( fc != '%' ){
		setVStrPtrInc(sp,fc);
		continue;
	    }
	    fp++;
	    switch( *fp ){
		default: sp = Sprintf(AVStr(sp),"%%%c",*fp); break;
		case '%': setVStrPtrInc(sp,fc); break;
		case 'A': sp = Sprintf(AVStr(sp),"%s",satoa(sa,AVStr(host))); break;
		case 'H': sp = Sprintf(AVStr(sp),"%s",saton(sa,AVStr(host))); break;
		case 'P': sp = Sprintf(AVStr(sp),"%d",VSA_port(sa)); break;
	    }
	}
	XsetVStrEnd(AVStr(sp),0);
}

const char *gethostbyAddr(PCStr(addr),PVStr(host))
{	VSAddr sab;

	VSA_atosa(&sab,0,addr);
	return saton(&sab,AVStr(host));
}
static void setFIFOaddr(VSAddr *sap)
{
	VSA_atosa(sap,1,"127.0.0.1");
}

int sockAFUNIX(int sock)
{	VSAddr name;
	int leng;

	leng = sizeof(VSAddr);
	if( getsockname(sock,(SAP)&name,&leng) != 0 )
		return 0;
	return VSA_afunix(&name,VStrNULL,0);
}
static int xgetpeername(int sock,SAP name,int *lenp)
{	int slen,rcode;

	slen = *lenp;
	rcode = getpeername(sock,(SAP)name,lenp);
	if( rcode == 0 && *lenp <= 2 && VSA_afunix((VSAddr*)name,VStrNULL,0) )
	{
		*lenp = slen;
		rcode = getsockname(sock,(SAP)name,lenp);
	}
	return rcode;
}
#undef getpeername
/*
#ifdef __cplusplus
#define getpeername(s,n,l) xgetpeername(s,n,l)
#else
*/
#define getpeername xgetpeername
/*
#endif
*/

typedef int (*NFUNCP)(int,struct sockaddr*,int*);
static int gethostpeerName(int sock,PVStr(sockname),PCStr(form),NFUNCP func)
{	VSAddr sab;
	int rcode;
	int addrlen;

	VSA_atosa(&sab,0,"0.0.0.0");
	addrlen = sizeof(VSAddr);

	if( (*func)(sock,(struct sockaddr*)&sab,&addrlen) == 0 ){
		if( addrlen == 0 && file_isfifo(sock) )
			setFIFOaddr(&sab);

		printSock(&sab,AVStr(sockname),form);
		return 1;
	}else{
		strcpy(sockname,"?");
		return 0;
	}
}
int VA_gethostpeerNAME(int sock,PVStr(name),VAddr *Vaddr,NFUNCP func)
{	VSAddr sab;
	int addrlen;

	VSA_atosa(&sab,0,"0.0.0.0");
	addrlen = sizeof(VSAddr);

	if( (*func)(sock,(struct sockaddr*)&sab,&addrlen) == 0 ){
		if( addrlen == 0 && file_isfifo(sock) )
			setFIFOaddr(&sab);

		if(Vaddr){
			*Vaddr = AddrZero;
			/*
			Vaddr->I3 = VSA_addr(&sab);
			*/
			Vaddr->a_type = VSA_addrX(&sab,Vaddr->a_ints.a_int);
			Vaddr->a_port = VSA_port(&sab);
		}
		if(name) printSock(&sab,AVStr(name),"%H");
		return 1;
	}else{
		sv1tlog("FATAL: get{host|peer}name(%d) failed, errno=%d\n",
			sock,errno);
		if(Vaddr) *Vaddr = AddrNull;
		if(name) strcpy(name,"?");
		return 0;
	}
}
int gethostName(int sock,PVStr(sockname),PCStr(form))
{
	return gethostpeerName(sock,AVStr(sockname),form,getsockname);
}
int getpeerName(int sock,PVStr(sockname),PCStr(form))
{	int rcode;
	int sresolv;
	CStr(porder,RESOLVERS_SIZ);
	CStr(torder,RESOLVERS_SIZ);

	RES_order("",AVStr(porder));
	if( strchr(porder,'D') == 0 ){
		sprintf(torder,"%sD",porder); /* use DNS anyway */
		RES_order(torder,VStrNULL);
	}else	RES_order(porder,VStrNULL);

	rcode = gethostpeerName(sock,AVStr(sockname),form,getpeername);

	RES_order(porder,VStrNULL);
	return rcode;
}
int getpeersNAME(int sock,PVStr(name),PVStr(saddr),int *portp);
int getpeerAddr(int sock,PVStr(saddr))
{	int port;

	if( getpeersNAME(sock,VStrNULL,AVStr(saddr),&port) )
		return port;
	strcpy(saddr,"255.255.255.255");
	return -1;
}
int VA_getpeerNAME(int sock,VAddr *Vaddr)
{
	return VA_gethostpeerNAME(sock,AVStr(Vaddr->a_name),Vaddr,getpeername);
}
int gethostAddr(int sock,PVStr(saddr))
{
	if( gethostName(sock,AVStr(saddr),"%A") )
		return sockPort(sock);
	else	return 0;
}
int VA_gethostNAME(int sock,VAddr *Vaddr)
{
	return VA_gethostpeerNAME(sock,AVStr(Vaddr->a_name),Vaddr,getsockname);
}
int gethostNAME(int sock,PVStr(name))
{	VAddr addr;

	if( VA_gethostpeerNAME(sock,AVStr(name),&addr,getsockname) )
		return addr.a_port;
	else	return 0;
}
int getpeerNAME(int sock,PVStr(name))
{	int rcode;
	int sresolv;
	CStr(porder,RESOLVERS_SIZ);
	CStr(torder,RESOLVERS_SIZ);
	VAddr addr;

	RES_order("",AVStr(porder));
	if( strchr(porder,'D') == 0 ){
		sprintf(torder,"%sD",porder); /* use DNS anyway */
		RES_order(torder,VStrNULL);
	}else	RES_order(porder,VStrNULL);

	rcode = VA_gethostpeerNAME(sock,AVStr(name),&addr,getpeername);

	RES_order(porder,VStrNULL);

	if( rcode )
		return addr.a_port;
	else	return 0;
}
int getpeersNAME(int sock,PVStr(name),PVStr(saddr),int *portp)
{	int rcode;
	VAddr addr;

	rcode = VA_gethostpeerNAME(sock,AVStr(name),&addr,getpeername);
	if( rcode ){
		if( portp ) *portp = addr.a_port;
		inetNtoa(htonl(addr.I3),AVStr(saddr));
	}
	return rcode;
}
void VA_inetNtoah(VAddr *Vaddr,PVStr(saddr))
{
	if( Vaddr->a_type == AF_INET6 || Vaddr->I0 || Vaddr->I1 || Vaddr->I2 ){
		strcpy(saddr,VSA_ltoa((const unsigned char*)&Vaddr->a_ints,16,AF_INET6));
	}else
	inetNtoa(htonl(Vaddr->I3),AVStr(saddr));
}

static int Accept(int sock,int isServer,int lockfd,PVStr(sockname))
{	int clsock;
	VSAddr sab;
	int addrlen;

	addrlen = sizeof(VSAddr);
	clsock =  accept(sock,(SAP)&sab,&addrlen);

	if( 0 <= clsock && addrlen == 0 ){
		sv1log("#### accept addrlen==0 [%d]\n",clsock);
		close(clsock);
		clsock = -1;
	}else
	if( sockname ){
		VSA_xtoap(&sab,AVStr(sockname),128);
	}
	return clsock;
}
/*
 *	a valid (non-negative) lockfd means that parallel accept() should
 *	be mutually excluded, and accept() should be protected from
 *	(SIGALRM) interrupt.
 */
int ACCEPT1(int sock,int isServer,int lockfd,int timeout,PVStr(sockname))
{	int clsock;
	int NB;
	CStr(sockport,32);

	if( lockfd < 0 && timeout == 0 )
		return Accept(sock,isServer,lockfd,AVStr(sockname));

	clsock = -1;
	sprintf(sockport,"[%d]:%d",sock,sockPort(sock));

	if( 0 <= lockfd && lock_exclusiveTO(lockfd,timeout*1000,NULL) != 0 ){
		sv1log("## accept(%s) failed locking, errno=%d\n",sockport,errno);
		goto EXIT;
	}

	if( PollIn(sock,timeout*1000) <= 0 )
		sv1log("## accept(%s) failed polling, errno=%d\n",sockport,errno);
	else{
		clsock = Accept(sock,isServer,lockfd,AVStr(sockname));
		Verbose("## accept(%s)=%d\n",sockport,clsock);
	}

	if( 0 <= lockfd )
		lock_unlock(lockfd);

EXIT:
	return clsock;
}
int ACCEPT(int sock,int isServer,int lockfd,int timeout)
{
	return ACCEPT1(sock,isServer,lockfd,timeout,VStrNULL);
}

static int newsocket(PCStr(what),int d,int t,int p)
{	int sock;

	sock = socket(d,t,p);
	if( sock < 0 ){
		int serrno;
		serrno = errno;
		sv1tlog("FATAL: socket(%s) failed, errno=%d\n",what,errno);
		errno = serrno;
	}
	return sock;
}

void set_SRCPORT(PCStr(host),int port)
{
	if( streq(host,"*") )
		SRCHOST = "";
	else	SRCHOST = host;
	SRCPORT = port;
}
static int bind_inets(int sock,VSAddr *sap,int nlisten,int lport);
void bind_SRCPORT(int sock)
{	CStr(sockname,256);
	VSAddr Vaddr;

	if( SRCHOST == 0 )
		return;
	if( SRCHOST[0] == 0 && SRCPORT == 0 )
		return;

	setsockREUSE(sock,1);
/*
	bind_insock(sock,SRCHOST,SRCPORT);
*/
	if( *SRCHOST )
		VSA_atosa(&Vaddr,0,gethostaddr(SRCHOST));
	else	VSA_atosa(&Vaddr,0,"0.0.0.0");
	bind_inets(sock,&Vaddr,0,SRCPORT);

	gethostName(sock,AVStr(sockname),"%A:%P");
	sv1log("[%d] source port = %s:%d = %s\n",sock,SRCHOST,SRCPORT,sockname);
	/*
	int on = 1;
	rcode = SETsockopt(sock, SOL_SOCKET, SO_DONTROUTE, &on, sizeof(on));
	Verbose("#### [%s] dontroute = %d\n",sockname,rcode);
	*/
}
double SVHELLO_TIMEOUT;
static int sockopen1(int asock,VSAddr *sap,PCStr(what),PCStr(portname),PCStr(hostname))
{	int sock;
	int rcode;
	CStr(aaddr,256);
	int iport,salen;
	CStr(remote,256);
	CStr(local,256);
	double Time(),Start;
	int af;

	af = AF_INET;
	if( VSA_strisaddr(VSA_ntoa(sap)) == AF_INET6 ){
		af = AF_INET6;
	}

	if( 0 <= asock )
		sock = asock;
	else	sock = newsocket(what,af,SOCK_STREAM,0);
/*
	else	sock = newsocket(what,AF_INET,SOCK_STREAM,0);
*/
	if( sock < 0 )
		return -1;

	strcpy(aaddr,VSA_ntoa(sap));
	iport = VSA_port(sap);
	salen = VSA_size(sap);

	Verbose("%s connect %s://%s:%d\n",what,portname,hostname,iport);
	Start = Time();

	bind_SRCPORT(sock);

	rcode = Bconnect(sock,sap,salen);
	inets_errmsg[0] = 0;
	if( rcode != 0 ){
		if( errno == ECONNREFUSED) CONNERR_REFUSED = 1;
		if( errno == ENETUNREACH ) CONNERR_UNREACH = 1;
		if( errno == EHOSTUNREACH) CONNERR_UNREACH = 1;
		if( errno == ETIMEDOUT   ) CONNERR_TIMEOUT = 1;
		
		if( errno == EISCONN || errno == EINPROGRESS )
			return sock;
		sprintf(inets_errmsg,
			"[%d] %s connect failed %s:%d [%4.2fs] errno=%d",
			sock,what,aaddr,iport, Time()-Start,errno);
		sv1log("%s\n",inets_errmsg);
		if( sock != asock )
			close(sock);
		return -1;
	}
	getpeerName(sock,AVStr(remote),"%A:%P");
	gethostName(sock,AVStr(local),"%A:%P");
	daemonlog("I","%s connected [%d] {%s <- %s} [%4.3fs]\n",
		what,sock,remote,local, Time()-Start);

	if( 0 < SVHELLO_TIMEOUT ){
		int timeout = (int)(SVHELLO_TIMEOUT*1000);
		if( timeout == 0 )
			timeout = 1;
		if( PollIn(sock,timeout) <= 0 ){
			close(sock);
			sock = -1;
			daemonlog("E","%s hello from server timedout\n",remote);
		}
	}

	return sock;
}
static int sockopens(int sock,int port,struct hostent *hp,PCStr(what),PCStr(portname),PCStr(hostname))
{	int hi;
	VSAddr sab;
	const char *haddr;

	shuffle_addrlist(hp);
	for( hi = 0; haddr = hp->h_addr_list[hi]; hi++ ){
		VSA_htosa(&sab,port,hp,hi);
		sock = sockopen1(sock,&sab,what,portname,hostname);
		if( 0 <= sock )
			return sock;
	}
	return -1;
}

int gethostintMin(PCStr(host))
{	struct hostent *hp;
	VSAddr sab;
	const char *baddr;
	int btype,bsize;
	int ai;
	unsigned int addr,addr1;

	if( VSA_strisaddr(host) ){
		VSA_atosa(&sab,0,host);
		bsize = VSA_decomp(&sab,&baddr,&btype,NULL);
		hp = gethostbyNameAddr(0,NULL,baddr,bsize,btype);
	}else{
		hp = gethostbyNameAddr(0,host,NULL,0,0);
	}
	if( hp != NULL ){
		addr = 0xFFFFFFFF;
		for( ai = 0; hp->h_addr_list[ai]; ai++ ){
			VSA_htosa(&sab,0,hp,ai);
			addr1 = VSA_addr(&sab);
			if( addr1 < addr )
				addr = addr1;
		}
		return htonl(addr);
	}
	return -1;
}
static const char *_gethostaddr(PCStr(host),int cache_only)
{	struct hostent *hp;

	if( VSA_strisaddr(host) )
		return host;

	if( hp = gethostbyNameAddr(cache_only,host,NULL,0,0) )
		return VSA_htoa(hp);

	return 0;
}
const char *gethostaddr(PCStr(host)){
	return _gethostaddr(host,0);
}
const char *gethostaddr_fromcache(PCStr(host)){
	return _gethostaddr(host,1);
}

static int getHost_nbo(int cacheonly,PCStr(host),PVStr(primname),VSAddr*vsa);
static int __gethostint_nbo(int cacheonly,PCStr(host),PVStr(primname))
{
	return getHost_nbo(cacheonly,host,BVStr(primname),NULL);
}
static int getHost_nbo(int cacheonly,PCStr(host),PVStr(primname),VSAddr*vsa)
{	struct hostent *hp;
	VSAddr sab;
	int iaddr;
	int isAddr;
	int found;

/*
	iaddr = inet_addrV4(host);
	if( iaddr != -1 && primname == NULL )
		return iaddr;
*/

	isAddr = VSA_strisaddr(host);
	found = 0;
	if( isAddr && primname == NULL ){
		VSA_atosa(&sab,0,host);
		found = 1;
	}else
	if( hp = gethostbyNameAddr(cacheonly,host,NULL,0,0) ){
		if( primname != NULL )
			strcpy(primname,hp->h_name);
		VSA_htosa(&sab,0,hp,0);
		/*
		iaddr = htonl(VSA_addr(&sab));
		*/
		found = 2;
	}
	else
	if( isAddr ){
		/* leave primname unchanged ? */
		VSA_atosa(&sab,0,host);
		found = 3;
	}
	if( vsa ){
		if( found ){
			*vsa = sab;
		}
		return found;
	}
	if( found )
		return htonl(VSA_addr(&sab));
	else	return -1;
	/*
	return iaddr;
	*/
}

int gethostint_nboV4(PCStr(host))
{
	return __gethostint_nbo(0,host,VStrNULL);
}
int VA_gethostint_nbo(PCStr(host),VAddr *Vaddr);
int strNetaddr(PCStr(host),PVStr(net))
{	VAddr Hosta;
	int hosti;

	VA_gethostint_nbo(host,&Hosta);
	hosti = ntohl(Hosta.I3);
	switch( (hosti >> 24) & 0xC0 ){
		case 0x00: hosti &= 0xFF000000; break;
		case 0x80: hosti &= 0xFFFF0000; break;
		case 0xC0: hosti &= 0xFFFFFF00; break;
	}
	if( net != NULL )
		sprintf(net,"%d.%d.%d.%d",
			0xFF&(hosti>>24),
			0xFF&(hosti>>16),
			0xFF&(hosti>>8),
			0xFF&(hosti));

	return htonl(hosti);
}

/*
 * true only when gethostbyXXX() is OK
 */
int hostIsResolvable(PCStr(host))
{
	return gethostintMin(host) != -1;
}
/*
 * true also when the host name is IP-address string
 */
int IsResolvable(PCStr(host))
{
	return VA_gethostint_nbo(host,NULL);
}
int VA_gethostint_nbo(PCStr(host),VAddr *Vaddr)
{	int a1;
	VAddr vab;
	VSAddr sab;
	int found;

	if( Vaddr == 0 )
		Vaddr = &vab;
	if( found = getHost_nbo(0,host,VStrNULL,&sab) ){
		*Vaddr = AddrZero;
		Vaddr->a_type = VSA_addrX(&sab,Vaddr->a_ints.a_int);
	}else	*Vaddr = AddrNull;
	return found;
/*
	a1 = __gethostint_nbo(0,host,VStrNULL);
	if( a1 == -1 ){
		if( Vaddr )
			*Vaddr = AddrNull;
		return 0;
	}else{
		if( Vaddr ){
			*Vaddr = AddrZero;
			Vaddr->I3 = a1;
		}
		return 1;
	}
*/
}

int VA_atoVAddr(PCStr(aaddr),VAddr *Vaddr){
	VAddr Vaddrb;
	if( Vaddr == NULL )
		Vaddr = &Vaddrb;
	*Vaddr = AddrZero;
	if( xinet_pton(AF_INET6,aaddr,&Vaddr->a_ints.a_int) == 1 ){
		Vaddr->I0 = ntohl(Vaddr->I0);
		Vaddr->I1 = ntohl(Vaddr->I1);
		Vaddr->I2 = ntohl(Vaddr->I2);
		Vaddr->I3 = ntohl(Vaddr->I3);
		Vaddr->a_type = AF_INET6;
		return 1;
	}
	return 0;
}

int VA_gethostVAddr(int cacheonly,PCStr(host),PVStr(primname),VAddr *Vaddr)
{	int a1;
	VAddr vab;
	VSAddr sab;
	int found;

	if( Vaddr == 0 )
		Vaddr = &vab;
	found = getHost_nbo(cacheonly,host,AVStr(primname),&sab);
	if( found ){
		*Vaddr = AddrZero;
		Vaddr->a_type = VSA_addrX(&sab,Vaddr->a_ints.a_int);
	}else	*Vaddr = AddrNull;
	return found;
/*
	a1 = __gethostint_nbo(cacheonly,host,AVStr(primname));
	if( a1 == -1 ){
		if( VA_atoVAddr(host,Vaddr) ){
			return 1;
		}
		if( Vaddr )
			*Vaddr = AddrNull;
		return 0;
	}else{
		if( Vaddr ){
			*Vaddr = AddrZero;
			Vaddr->I3 = ntohl(a1);
		}
		return 1;
	}
*/
}
int VA_strtoVAddr(PCStr(saddr),VAddr *Vaddr)
{	int a1;

	a1 = inet_addrV4(saddr);
	if( a1 == -1 ){
		if( VA_atoVAddr(saddr,Vaddr) ){
			return 1;
		}
		if( Vaddr )
			*Vaddr = AddrNull;
		return 0;
	}else{
		if( Vaddr ){
			*Vaddr = AddrZero;
			Vaddr->I3 = ntohl(a1);
		}
		return 1;
	}
}

void VA_setVAddr(VAddr *Vaddr,PCStr(addr),int port,int remote)
{
	VA_strtoVAddr(addr,Vaddr);
	wordscanX(addr,AVStr(Vaddr->a_name),sizeof(Vaddr->a_name));
	Vaddr->a_port = port;
	if( remote )
		Vaddr->a_flags |= VA_REMOTE;
}

static int ipv4cmp(PCStr(a1),PCStr(a2))
{	int ai;

	for( ai = 0; ai < 4; ai++ )
		if( a1[ai] != a2[ai] )
			return 1;
	return 0;
}

/*
 * return non-zero if hp2 includes some element which is not
 * included in hp1.
 */
int hostentcmp(struct hostent *hp1,struct hostent *hp2)
{	const char *a1;
	const char *a2;
	int n1,n2;
	int diff;

	for( n1 = 0; hp1->h_addr_list[n1]; n1++ );
	for( n2 = 0; hp2->h_addr_list[n2]; n2++ );
	if( n1 < n2 )
		return 1;

	for( n2 = 0; a2 = hp2->h_addr_list[n2]; n2++ ){
		for( n1 = 0; a1 = hp1->h_addr_list[n1]; n1++ )
			if( ipv4cmp(a2,a1) == 0 )
				break;
		if( a1 == NULL )
			return 1;
	}
	return 0;
}

int __connectServer(int sock,PCStr(what),PCStr(portname),PCStr(hostname),int iport)
{	struct hostent *hp;
	VSAddr sab,*sap = &sab;
	CStr(hostnameb,256);
	const char *aaddr;
	CStr(path,1024);

	if( hostlocal2path(hostname,AVStr(path),sizeof(path)) ){
		sv1log("## connect %s ...\n",path);
		hostname = path;
	}

	/*
	if( hostname != NULL && hostname[0] == '/' )
		return client_open_un(what,hostname,0);
	*/
	if( hostname != NULL && isFullpath(hostname) ){
		sock = client_open_unX(what,sock,hostname,0);
		return sock;
	}

/*
	if( sock < 0 && ViaVSAPassociator(-1) && strncmp(portname,"VSAP",4) != 0 ){
		CStr(sockname,256);
		CStr(peername,256);
		sockname[0] = 0;
		sprintf(peername,"%s:%d",hostname,iport);
		sock = VSAPconnect(AVStr(sockname),AVStr(peername));
		if( 0 <= sock ){
			sv1log("#### connected via TELEPORT\n");
			return sock;
		}
		sv1log("#### connection via TELEPORT failed.\n");
	}
*/

	VSA_atosa(sap,iport,"0.0.0.0");
	inets_errmsg[0] = 0;

	if( hostname == NULL || hostname[0] == 0 ){
		hostname = hostnameb;
		strcpy(hostnameb,"localhost");
		if( !IsResolvable(hostnameb) )
			gethostname(hostnameb,sizeof(hostnameb));
	}

	if( VSA_strisaddr(hostname) ){
		VSA_atosa(sap,iport,hostname);
		return sockopen1(sock,sap,what,portname,hostname);
	}

/*
	if( hp = gethostbyNameAddr(0,hostname,NULL,0,0) ){
*/
	DO_SHUFFLE = 1;
	hp = gethostbyNameAddr(0,hostname,NULL,0,0);
	DO_SHUFFLE = 0;
	if( hp ){
		int nsock;
		struct hostent *nhp;

		nsock = sockopens(sock,iport,hp,what,portname,hostname);
		if( 0 <= nsock )
			return nsock;
/*
if( !nonblocking ){
	nhp = gethostbyNameAddrNocache(hostname);
	if( 0 < hostentcmp(hp,nhp) ){
		nsock = sockopens(sock,iport,nhp,what,portname,hostname);
		sv1log("## connect(%s) retried without hosts cache = %d\n",
			hostname,nsock);
		return nsock;
	}
}
*/
		return -1;
	}else
	if( aaddr = gethostaddr(hostname) ){
		VSA_atosa(sap,iport,aaddr);
		return sockopen1(sock,sap,what,portname,hostname);
	}else{
		CONNERR_CANTRESOLV = 1;
		sprintf(inets_errmsg,"%s unknown host '%s'",what,hostname);
		sv1log( "%s\n",inets_errmsg);
		return -1;
	}
}
int connectServer(PCStr(what),PCStr(portname),PCStr(hostname),int iport)
{
	return __connectServer(-1,what,portname,hostname,iport);
}
int client_open(PCStr(what),PCStr(portname),PCStr(hostname),int iport)
{
	return __connectServer(-1,what,portname,hostname,iport);
}

int hostaf(PCStr(hostname)){
	VSAddr sab;
	int af;

	if( isFullpath(hostname) )
		af = AF_UNIX;
	if( getHost_nbo(0,hostname,VStrNULL,&sab) ){
		af = VSA_af(&sab);
	}else	af = AF_INET;
	return af;
}

int bind_insock(int sock,PCStr(host),int port);
int UDP_client_open1(PCStr(what),PCStr(portname),PCStr(hostname),int iport,PCStr(lhost),int lport)
{	int asock,rsock;
	CStr(path,256);

	if( hostlocal2path(hostname,AVStr(path),sizeof(path)) ){
		sv1log("## UDP connect %s = %s ...\n",hostname,path);
		hostname = path;
	}
	asock = socket(hostaf(hostname),SOCK_DGRAM,0);
/*
	if( isFullpath(hostname) )
		asock = socket(AF_UNIX,SOCK_DGRAM,0);
	else
	asock = socket(AF_INET,SOCK_DGRAM,0);
*/
	sv1log("UDP_client_open[%d] %s://%s:%d ...\n",asock,portname,hostname,iport);
	if( 0 <= lport )
		bind_insock(asock,lhost,lport);
	rsock = __connectServer(asock,what,portname,hostname,iport);
	if( rsock < 0 )
		close(asock);
	return rsock;
}
int UDP_client_open(PCStr(what),PCStr(portname),PCStr(hostname),int iport)
{
	return UDP_client_open1(what,portname,hostname,iport,NULL,-1);
}

int hostIFfor1(PVStr(hostIF),int udp,PCStr(proto),PCStr(rhost),int rport);
int hostIFfor(PCStr(rhost),PVStr(hostIF))
{
	if( hostIFfor1(AVStr(hostIF),1,"time",rhost,37) )
		return 1;
	if( hostIFfor1(AVStr(hostIF),0,"time",rhost,37) )
		return 1;
	if( hostIFfor1(AVStr(hostIF),0,"echo",rhost,7) )
		return 1;
	if( hostIFfor1(AVStr(hostIF),0,"domain",rhost,53) )
		return 1;
	if( hostIFfor1(AVStr(hostIF),0,"http",rhost,80) )
		return 1;
	return 0;
}
int hostIFfor1(PVStr(hostIF),int udp,PCStr(proto),PCStr(rhost),int rport)
{	int sock;

	setVStrEnd(hostIF,0);
	if( udp )
		sock = UDP_client_open("checkIF-UDP",proto,rhost,rport);
	else	sock = client_open("checkIF-TCP",proto,rhost,rport);

	if( 0 <= sock ){
		gethostNAME(sock,AVStr(hostIF));
		close(sock);
		if( hostIF[0] && strcmp(hostIF,"0.0.0.0") != 0 )
			return 1;
	}
	return 0;
}

int hostIFfor0(PVStr(hostIF),int udp,PCStr(proto),PCStr(rhost),int rport,int dontroute)
{	int sock,on;
	VSAddr sab;
	const char *aaddr;
	int alen,got;

	aaddr = gethostaddr(rhost);
	if( aaddr == NULL )
		return 0;
	alen = VSA_atosa(&sab,rport,aaddr);

	got = 0;
	sock = socket(AF_INET,udp?SOCK_DGRAM:SOCK_STREAM,0);

	if( dontroute ){
		on = 1;
		SETsockopt(sock, SOL_SOCKET, SO_DONTROUTE, &on, sizeof(on));
	}
	if( connect(sock,(SAP)&sab,alen) == 0 )
		got = gethostAddr(sock,AVStr(hostIF));
	close(sock);
	return got;
}

int MAX_BUFF_SOCKSEND = 0x4000;
int MAX_BUFF_SOCKRECV = 0x4000;
void std_setsockopt(int sock)
{	int bsize;
	int On = 1, No = 0;

	SETsockopt(sock, SOL_SOCKET, SO_REUSEADDR, &No, sizeof(No));
	bsize = MAX_BUFF_SOCKRECV;
	SETsockopt(sock, SOL_SOCKET, SO_RCVBUF, &bsize,sizeof(bsize));
	bsize = MAX_BUFF_SOCKSEND;
	SETsockopt(sock, SOL_SOCKET, SO_SNDBUF, &bsize,sizeof(bsize));
}

const char *ext_binder = "dgbind";
const char *binder_path;

int Bind(int sock,VSAddr *sap,int len)
{	const char *av[8]; /**/
	CStr(ab,256);
	refQStr(ap,ab); /**/
	CStr(path,1024);
	const char *host;
	int port,ac,rcode;

	rcode = bind(sock,(SAP)sap,len);
	if( rcode != 0 && errno == EACCES && INHERENT_fork() ){
		int serrno;
		serrno = errno;

		if( binder_path == 0 ){
			strcpy(path,ext_binder);
			/*
			fullpathSUCOM(ext_binder,"r",path);
			*/
			if( fullpathSUCOM(ext_binder,"r",AVStr(path)) == 0 ){
				sv1log("## command not found: %s\n",ext_binder);
				errno = serrno;
				return rcode;
			}
			sv1log("## dgbind = %s\n",path);
			binder_path = stralloc(path);
		}

		ac = 0;
		host = VSA_ntoa(sap);
		port = VSA_port(sap);
		av[ac++] = ap; strcpy(ap,ext_binder); ap += strlen(ap)+1;
		av[ac++] = ap; sprintf(ap,"%d",sock); ap += strlen(ap)+1;
		av[ac++] = ap; sprintf(ap,"%d",port); ap += strlen(ap)+1;
		av[ac++] = ap; strcpy(ap,host); ap += strlen(ap)+1;
		av[ac] = 0;

		if( fork() == 0 ){
			Execvp("Bind",binder_path,av);
			exit(-1);
		}
		wait(0);
		if( 0 < sockPort(sock) ){
			rcode = 0;
			errno = 0;
		}
		else	errno = serrno;
	}
	return rcode;
}
#undef bind
#define bind(s,n,l)	Bind(s,(VSAddr*)n,l)

static int ftp_conndata0(VSAddr *src,VSAddr *dst,VSAddr *laddr,int lport)
{	int sock;
	CStr(sockname,256);
	CStr(peername,256);
	int iport;
	int salen;
	int af;

	if( VSA_size(src) == sizeof(struct sockaddr_in6) )
		af = AF_INET6;
	else	af = AF_INET;
	sock = newsocket("ftp-data-con",af,SOCK_STREAM,0);
	/*
	sock = newsocket("ftp-data-con",AF_INET,SOCK_STREAM,0);
	*/
	if( sock == -1 ){
		sv1log("ftp_conndata: cannot create socket: %d.\n",errno);
		return -1;
	}

	if( src && (VSA_addr(src) || VSA_port(src)) ){
		setsockREUSE(sock,1);
		setsockSHARE(sock,1);
		salen = VSA_size(src);
		if( laddr == NULL || bind_inets(sock,laddr,0,lport) != 0 )
		if( bind(sock,(SAP)src,salen) != 0 ){
			sv1log("## ftp-conndata: NOT bound#1 err=%d\n",errno);
			VSA_setport(src,0);
			if( bind(sock,(SAP)src,salen) != 0 )
			sv1log("## ftp-conndata: NOT bound#2 err=%d\n",errno);
		}
	}

	printSock(dst,AVStr(peername),"%H/%A:%P");
	salen = VSA_size(dst);
	gethostName(sock,AVStr(sockname),"%A:%P");
	if( Bconnect(sock,dst,salen) != 0 ){
		close(sock);
		sv1log("ftp_conndata: connection refused %s->%s, errno=%d\n",
			sockname,peername,errno);
		return -1;
	}
	gethostName(sock,AVStr(sockname),"%A:%P");
	sv1log("ftp_conndata: connected %s->%s [%d]\n",sockname,peername,sock);
	return sock;
}
static int ftp_conndata(VSAddr *src,VSAddr *dst,VSAddr *laddr,int lport)
{	int rcode;

	rcode = ftp_conndata0(src,dst,laddr,lport);
	if( rcode == -1 && src && VSA_port(src) )
	/*if( errno == ECONNREFUSED )*/
	{
		sv1log("ftp_conndata: retry without port# (%d)\n",
			VSA_port(src));
		VSA_setport(src,0);
		rcode = ftp_conndata0(src,dst,laddr,lport);
	}
	return rcode;
}

/*
 *	REUSE ON to restart server immediately.
 */

int S_ADDRNOTAVAIL;
int set_listenX(int sock,int nlisten);
static int bind_inet(int sock,VSAddr *sap,int nlisten)
{	int salen,rcode;
	const char *msg;
	CStr(hp,512);

	SETsockopt(sock,SOL_SOCKET,SO_REUSEADDR,&REUSE,sizeof(REUSE));
	if( REUSEPORT )
		setsockSHARE(sock,1);
	salen = VSA_size(sap);
	rcode = bind(sock,(SAP)sap,salen);

	S_ADDRNOTAVAIL = 0;
	if( rcode != 0 ){
		switch( errno ){
		case EADDRINUSE: msg = "(the port is used by others)"; break;
		case EACCES:	 msg = "(you are not permitted user)"; break;
		case EADDRNOTAVAIL:
				S_ADDRNOTAVAIL = 1;
				msg = "(not a local port)";
				break;
		default:	 msg = ""; break;
		}
		VSA_xtoap(sap,AVStr(hp),sizeof(hp));
		svlog("bind_inet(%d,%s) failed: ERRNO=%d %s\n",sock,hp,errno,msg);
		return -1;
	}
	if( nlisten < 0 ) /* UDP bind */
		return rcode;

	if( nlisten == 0 ) /* don't start listen here */
		return 0;

	return set_listenX(sock,nlisten);
}

static int bind_inets(int sock,VSAddr *sap,int nlisten,int lport)
{	int p1,p2,inc,xtry;
	int rcode = -1;

	if( lport == 0xFFFF0000 ){
		p1 = p2 = 0;
	}else
	if( lport & 0xFFFF0000 ){
		p1 = (lport >> 16) & 0xFFFF;
		p2 = lport & 0xFFFF;
	}else{
		p1 = p2 = lport;
	}
	inc = p1 < p2 ? 1 : -1;

	for( xtry = 0; xtry < 128; xtry++ ){
		VSA_setport(sap,p1);
		if( (rcode = bind_inet(sock,sap,nlisten)) == 0 )
			return 0;
		if( p1 == p2 )
			break;
		p1 += inc;
	}
	return rcode;
}

int set_listenX(int sock,int nlisten)
{	int rcode;

	if( nlisten <= 0 )
		return -1;

	rcode = listen(sock,nlisten);

	if( rcode == 0 )
		Verbose("listen(%d,%d) OK.\n",sock,nlisten);
	else	svlog("listen(%d,%d) failed: ERRNO=%d\n",sock,nlisten,errno);
	return rcode;
}

int bind_insock(int sock,PCStr(host),int port)
{	VSAddr sab;
	int rcode;
	const char *aaddr;
	int salen;

	if( host != NULL && host[0] != 0 )
		aaddr = gethostaddr(host);
	else	aaddr = NULL;
	if( aaddr == NULL )
		aaddr = "0.0.0.0";

	VSA_atosa(&sab,port,aaddr);
	salen = VSA_size(&sab);
	errno = 0;
	rcode = bind(sock,(SAP)&sab,salen);
	sv1log("bind_insock(%d,%s,%d) = %d, errno=%d\n",sock,host?host:"",port,
		rcode,errno);
	return rcode;
}

int connectTimeout(int sock,PCStr(host),int port,int timeout)
{	struct hostent *hp;
	VSAddr sab;
	int salen;
	int rcode;

	VSA_atosa(&sab,0,"255.255.255.255");
	if( VSA_strisaddr(host) ){
		VSA_atosa(&sab,port,host);
	}else{
		if( hp = gethostbyNameAddr(0,host,NULL,0,0) )
			VSA_htosa(&sab,port,hp,0);
		else	sv1log("ERROR: connectTimeout(%s) unknown host\n",host);
	}
	if( VSA_isaddr(&sab)  ){
		salen = VSA_size(&sab);
		rcode = connectTO(sock,(SAP)&sab,salen,timeout);
		return rcode;
	}
	close(sock);
	return -1;
}

typedef int (*isFUNC)(PCStr(fmt),...);
int server_open(PCStr(portname),xPVStr(hostname),int portnum,int nlisten)
{	isFUNC logf;
	int rcode;
	int sock;
	struct hostent *hp;
	VSAddr sab;
	int salen;
	CStr(path,1024);
	int af;

	if( hostlocal2path(hostname,AVStr(path),sizeof(path)) ){
		sv1log("## bind %s ...\n",path);
		setPStr(hostname,path,sizeof(path));
	}

	if( hostname != NULL && hostname[0] == '/' )
	{
		if( REUSE )
			unlink(path);
		return server_open_un(portname,AVStr(hostname),nlisten);
	}

	/* dolog = streq(portname,"RESPDIST"); */
	if( hostname && strcmp(hostname,"localhost") == 0 && portnum == 0 )
		logf = sv1vlog;
	else	logf = sv1log;

	(*logf)("server_open(%s,%s:%d,listen=%d)\n",
		portname,hostname?hostname:"*",portnum,nlisten);

	af = AF_INET;
	if( 0 < AF_INET6 ){
		if( streq(hostname,"*")
		 || IPV6_v6also
		 || VSA_strisaddr(hostname) == AF_INET6
		 || hostaf(hostname) == AF_INET6
		){
			af = AF_INET6;
		}
	}

RETRY:
	switch( nlisten ){
	/*
		case -1: sock = newsocket(portname,AF_INET,SOCK_DGRAM,0); break;
		default: sock = newsocket(portname,AF_INET,SOCK_STREAM,0);
	*/
		case -1: sock = newsocket(portname,af,SOCK_DGRAM,0); break;
		default: sock = newsocket(portname,af,SOCK_STREAM,0);
	}

	if( sock < 0 )
	{
		if( af == AF_INET6 )
		if( streq(hostname,"*") ){
			af = AF_INET;
			goto RETRY;
		}
		return -1;
	}
	if( af == AF_INET6 ){
		int on,err;
		if( streq(hostname,"*") )
			on = 0;
		else
		if( streq(hostname,IPV4MAPV6) )
			on = 0;
		else
		if( IPV6_v4also || IPV6_v6also )
			on = 0;
		else	on = 1;
		err = SETsockopt(sock,IPPROTO_IPV6,IPV6_V6ONLY,&on,sizeof(on));
		sv1log("## V6ONLY=%s %s\n",on?"ON":"OFF",err?"ERROR":"OK");
	}
	if( streq(hostname,"*") )
		setVStrEnd(hostname,0);

	if( af == AF_INET6 )
		VSA_atosa(&sab,0,"::");
	else
	VSA_atosa(&sab,0,"0.0.0.0");
	if( hostname != NULL && hostname[0] != 0 ){
		if( VSA_strisaddr(hostname) ){
			VSA_atosa(&sab,0,hostname);
			(*logf)("server_open: %s:%d\n",hostname,portnum);
		}else
		if( hp = gethostbyNameAddr(0,hostname,NULL,0,0) ){
			VSA_htosa(&sab,0,hp,0);
			(*logf)("server_open: %s:%d\n",hostname,portnum);
		}
		else{
			if( !VSA_strisaddr(hostname) ){
				sv1log("ERROR: hostname unknown: %s\n",hostname);
				close(sock);
				return -1;
			}
			VSA_atosa(&sab,0,hostname);
		}
	}
	VSA_setport(&sab,portnum);
	if( bind_inets(sock,&sab,nlisten,portnum) != 0 ){
		close(sock);
		sv1log("server_open() failed\n");
		return -1;
	}
	(*logf)("server_open(%s,%s:%d) BOUND\n",portname,hostname?hostname:"*",portnum);
	return sock;
}

int find_openport(PCStr(what),PCStr(host),int port,int nlisten)
{	int fd,portx;
	CStr(hostx,256);
	const char *addr;
	CStr(hostb,64);

	if( *host == 0 )
		host = "0.0.0.0";
	else{
		if( addr = gethostaddr(host) ){
			strcpy(hostb,addr);
			/*
			host = addr;
			*/
			host = hostb;
		}else	host = "0.0.0.0";
	}
	for( fd = 0; fd < FD_SETSIZE; fd++ ){
		if( (portx = gethostAddr(fd,AVStr(hostx))) <= 0 )
			continue;

		if( portx == port && hostcmp(host,hostx) == 0 ){
			int isudp = isUDPsock(fd);
			if( (nlisten<0 && !isudp) || (0<nlisten && isudp) )
				continue;
			sv1log("FOUND: %s [%d] %s:%d\n",what,fd,hostx,port);
			return fd;
		}
	}
	return -1;
}
int findopen_port(PCStr(what),PVStr(host),int port,int nlisten)
{	int sock;

	sock = find_openport(what,host,port,nlisten);
	if( sock < 0 )
		sock = server_open(what,AVStr(host),port,nlisten);
	return sock;
}

void adduniqlist(int mac,const char *names[],PCStr(name1))
{	int nx;
	const char *cname;

	for( nx = 0; cname = names[nx] ; nx++ ){
		if( strcasecmp(cname,name1) == 0 )
			return;
	}
	if( mac <= nx ){
		return;
	}
	names[nx++] = stralloc(name1);
	names[nx] = NULL;
}
static void adduniqlist_host(int mac,const char *names[],struct hostent *hp)
{	int nx;

	if( hp->h_name )
		adduniqlist(mac,names,hp->h_name);

	if( hp->h_aliases )
	for( nx = 0; hp->h_aliases[nx]; nx++ )
		adduniqlist(mac,names,hp->h_aliases[nx]);
}

int sethostcache(PCStr(host),int mark_predef)
{	VSAddr sab;
	const char *aaddr;
	const char *baddr;
	int blen,btype;
	struct hostent *chp,*hp;
	CStr(sorder,RESOLVERS_SIZ);
	CStr(porder,RESOLVERS_SIZ);
	CStr(order1,RESOLVERS_SIZ);
	int ox;
	const char *aliases[128]; /**/
	int found,nx;
	int predef_sav;

	found = -1;
	predef_sav = HOSTS_PREDEF;
	HOSTS_PREDEF = mark_predef;

	aaddr = gethostaddr(host);
	if( aaddr == NULL )
		goto EXIT;
	VSA_atosa(&sab,0,aaddr);
	blen = VSA_decomp(&sab,&baddr,&btype,NULL);

	chp = gethostbyNameAddr(1,NULL,baddr,blen,btype);
	if( chp == NULL )
		goto EXIT;

	aliases[0] = aliases[1] = 0;
	adduniqlist_host(elnumof(aliases),aliases,chp);

	found = 0;
	RES_order("",AVStr(sorder));

	/*
	 * Try gather host name aliases in all of available resolvers.
	 * Maybe this is necessary to make revese-MOUNT work well...
	 */
	for( ox = 0; ox = RES_next_res(sorder,ox,AVStr(order1),VStrNULL); ){
		if( order1[0] == 'C' /* cache */ ){
			/* Maybe cache is the first alternative in resolvers
			 * so the result found above is that of the cache ...
			 */
			continue;
		}
		if( order1[0] == 'S' /* sys */ ){
			/* Some system (Windows, Solaris, ...) would block
			 * long time in system's standard gethostbyXXXX() ...
			 */
			continue;
		}

		RES_order(order1,AVStr(porder));

		hp = gethostbyNameAddrNocache(NULL,baddr,blen,btype);

		if( hp != NULL ){
			adduniqlist_host(elnumof(aliases),aliases,hp);
			found++;
		}
	}

	chp->h_aliases = (char**)dupv((const char**)&aliases[1],0);

	for( nx = 0; aliases[nx]; nx++ )
		free((char*)aliases[nx]);

	RES_order(sorder,AVStr(porder));

/*{ CStr(hosts,4096); dump_HOSTS(hosts); fprintf(stderr,"%s\n",hosts); }*/

EXIT:
	HOSTS_PREDEF = predef_sav;
	return found;
}
void sethostcache_predef(PCStr(name),PCStr(addr),int len,int type)
{	Hostent *Hp;
	CStr(hosts,2048);

	if( Hp = findHostCache(name,addr,len,type) )
	if( !Hp->hc_predef ){
		dump_HOST1(AVStr(hosts),&Hp->hc_hostent);
		Verbose("HOSTS[%d]=%s marked PREDEF\n",Hp->hc_index,hosts);
		Hp->hc_predef = 1;
	}
}

int sockHostport(int sock,int *portp)
{	int addrlen,addr;
	VSAddr sab;

	addrlen = sizeof(VSAddr);
	bzero(&sab,sizeof(VSAddr));
	if( getsockname(sock,(SAP)&sab,&addrlen) == 0 ){
		if( addrlen == 0 && file_isfifo(sock) )
			setFIFOaddr(&sab);
		if( portp != 0 )
			*portp = VSA_port(&sab);
		addr = VSA_addr(&sab);
		return addr;
	}
	if( portp != 0 )
		*portp = 0;
	return -1;
}
int sockPort(int sock)
{	int port;

	if( sockHostport(sock,&port) != -1 )
		return port;
	else	return 0;
}
int peerHostport(int sock,int *portp)
{	int addrlen;
	int addr;
	VSAddr sab;

	addrlen = sizeof(VSAddr);
	if( getpeername(sock,(SAP)&sab,&addrlen) == 0 ){
		if( addrlen == 0 && file_isfifo(sock) )
			setFIFOaddr(&sab);
		if( portp != 0 )
			*portp = VSA_port(&sab);
		addr = VSA_addr(&sab);
		return addr;
	}
	return -1;
}
int peerPort(int sock)
{	int port;

	if( peerHostport(sock,&port) != -1 )
		return port;
	else	return 0;
}
void peerHostaddrV4(int sock,unsigned char *rhost)
{	int ai;
	int iaddr;

	iaddr = peerHostport(sock,NULL);
	for( ai = 0; ai < 4; ai++ )
		rhost[ai] = (iaddr >> (3-ai)*8) & 0xFF;
}
int sockFromMyself(int sock)
{
	return sockHostport(sock,NULL) == peerHostport(sock,NULL);
}
void flush_socket(int fd)
{
	send(fd,"",0,MSG_OOB);  /* push packets before the timeout */
}

/*
 * Data connection should be via Socks if the control connection is via Socks.
 * Source IP address of data connection should be same with that of control
 * connection, and source port number should be be L-1 where the port number
 * of control connection is L.
 */
int connect_ftp_data(DGC*Conn,PCStr(port),int cntrlsock,PCStr(lhost),int lport)
{	VSAddr ldata_addr;
	int lsock;
	CStr(hostnam,128);
	int portnum;
	int r_ina,c_ina,trydirect;
	int addrlen;
	VSAddr srcport_buff,*srcport;
	VSAddr laddrb,*laddr;

	addrlen = sizeof(VSAddr);
	getpeername(cntrlsock,(SAP)&ldata_addr,&addrlen); /* for |||PORT| */
	VSA_ftptosa(&ldata_addr,port);
	strcpy(hostnam,VSA_ntoa(&ldata_addr));
	portnum = VSA_port(&ldata_addr);

	if( toTunnel(Conn) ){
		lsock = connectViaTunnel(Conn,"ftp-data",hostnam,portnum);
		if( 0 <= lsock ){
			return lsock;
		}
	}

	srcport = NULL;
	if( cntrlsock < 0 ){
		trydirect = 1;
	}else{
		r_ina = inet_addrV4(hostnam);
		c_ina = peerHostport(cntrlsock,NULL);
		if( r_ina == c_ina )
			trydirect = 1;
		else	trydirect = 0; /* maybe via Socks */
/* the control connection can be connected via a proxy other than Socks,
 * for example, via CONNECT/HTTP, thus the data connections should be
 * routed following CONNECT parameter like the routing of control
 * connections. 
 */

		addrlen = sizeof(VSAddr);
		if( getsockname(cntrlsock,(SAP)&srcport_buff,&addrlen) == 0 )
		if( addrlen != 0 ){
			srcport = &srcport_buff;
			VSA_setport(srcport,VSA_port(srcport)-1);
		}
	}

	laddr = NULL;
	if( *lhost != 0 || lport != 0 ){
		laddr = &laddrb;
		if( *lhost ){
			VSA_atosa(laddr,0,gethostaddr(lhost));
		}else
		if( srcport )
			*laddr = *srcport;
		else	VSA_atosa(laddr,0,"0.0.0.0");

		if( lport == 0 && srcport )
			lport = VSA_port(srcport);
	}

	lsock = -1;
	if( lsock == -1 && ViaVSAPassociator(cntrlsock) ){
		CStr(sockname,256);
		CStr(peername,256);
		sockname[0] = 0;

		if( VSAPgetsockname(cntrlsock,AVStr(sockname)) == 0 ){
			refQStr(dp,sockname); /**/
			int port;
			if( dp = strchr(sockname,':') ){
				dp++;
				/*if( port = atoi(dp) )
					sprintf(dp,"%d",port-1);
				else*/	sprintf(dp,"0");
			}
			sv1log("## FTP/VSAP CONNECT SOCK=%s\n",sockname);
		}

		sprintf(peername,"%s:%d",hostnam,portnum);
		lsock = CTX_VSAPconnect(Conn,AVStr(sockname),AVStr(peername));
	}

	if( lsock == -1 && trydirect )
		lsock = ftp_conndata(srcport,&ldata_addr,laddr,lport);

	if( lsock == -1 && GetViaSocks(Conn,hostnam,portnum) )
		lsock = connectViaSocks(Conn,hostnam,portnum,VStrNULL,NULL);

	if( lsock == -1 && !trydirect )
		lsock = ftp_conndata(srcport,&ldata_addr,laddr,lport);

	return lsock;
}

int bind_ftp_dataX(DGC*Conn,PVStr(mport),PCStr(server),int iport,int cntrlsock,int PASV,PCStr(lhost),int lport);
int bind_ftp_data(DGC*Conn,PVStr(mport),PCStr(server),int iport,int cntrlsock,int PASV,PCStr(lhost),int lport)
{	int sock,sREUSE,sREUSEPORT;

	if( isWindows() ){
	sREUSE = REUSE; REUSE = 0;
	}
	sREUSEPORT = REUSEPORT; REUSEPORT = 0;

	sock = bind_ftp_dataX(Conn,AVStr(mport),server,iport,cntrlsock,PASV,lhost,lport);

	if( isWindows() ){
	REUSE = sREUSE;
	}
	REUSEPORT = sREUSEPORT;
	return sock;
}
int bind_ftp_dataX(DGC*Conn,PVStr(mport),PCStr(server),int iport,int cntrlsock,int PASV,PCStr(lhost),int lport)
{	int dsock;
	const char *aaddr;
	VSAddr svhost,svsock,svpeer,svdata;
	int addrlen;
	CStr(remote,256);
	CStr(local,256);
	int af;

	if( fromTunnel(Conn,cntrlsock) ){
		VSA_atosa(&svsock,0,"127.0.0.1");
		goto BIND;
	}

	if( ViaVSAPassociator(cntrlsock) ){
		CStr(sockname,256);
		int ax[4],bport;

		sockname[0] = 0;
		if( VSAPgetsockname(cntrlsock,AVStr(sockname)) == 0 ){
			refQStr(dp,sockname); /**/
			if( dp = strchr(sockname,':') )
				Xstrcpy(QVStr(dp+1,sockname),"0");
		}
		sv1log("## FTP/VSAP BIND SOCK=%s\n",sockname);
		dsock = CTX_VSAPbind(Conn,AVStr(sockname),1);
		if( 0 <= dsock ){
			sscanf(sockname,"%d.%d.%d.%d:%d",
				&ax[0],&ax[1],&ax[2],&ax[3],&bport);
			sprintf(mport,"%d,%d,%d,%d,%d,%d",
				ax[0],ax[1],ax[2],ax[3],
				(bport>>8)&0xFF,bport&0xFF);
			return dsock;
		}
	}

	if( aaddr = gethostaddr(server) ){
		VSA_atosa(&svhost,iport,aaddr);
		VSA_xtoap(&svhost,AVStr(remote),sizeof(remote));
		sv1log("FTP-control-remote: %s\n",remote);
	}

	addrlen = sizeof(VSAddr);
	if( getsockname(cntrlsock,(SAP)&svsock,&addrlen) != 0 || addrlen == 0 ){
		sv1log("cannot make FTP data port: no control conn-1.\n");
		return -1;
	}
	addrlen = sizeof(VSAddr);
	if( getpeername(cntrlsock,(SAP)&svpeer,&addrlen) != 0 || addrlen == 0 ){
		sv1log("cannot make FTP data port: no control conn-2.\n");
		return -1;
	}

	if( VSA_comp(&svhost,&svpeer) != 0 ){
		/* not connected directly */
		VSAddr vlocal;
		if( VSA_getViaSocks(Conn,server,0,&vlocal) )
		{	CStr(bhost,64);
			int bport;
			VSAddr ba;

			dsock = bindViaSocks(Conn,server,iport,AVStr(bhost),&bport);
			if( 0 <= dsock ){
				if( streq(bhost,"0.0.0.0") ){ /* wild card */
					strcpy(bhost,VSA_ntoa(&vlocal));
					sv1log("BIND 0.0.0.0 -> %s\n",bhost);
				}
				VSA_atosa(&ba,bport,bhost);
				VSA_prftp(&ba,AVStr(mport));
				return dsock;
			}
		}
	}


BIND:
	if( addrlen == sizeof(struct sockaddr_in6) ) /*addrlen of client-sock*/
		af = AF_INET6;
	else	af = AF_INET;
	dsock = newsocket("ftp-data-acc",af,SOCK_STREAM,0);
	/*
	dsock = newsocket("ftp-data-acc",AF_INET,SOCK_STREAM,0);
	*/
	if( dsock < 0 )
		return -1;
	if( *lhost != 0 || lport != 0 ){
		if( *lhost )
			VSA_atosa(&svdata,0,gethostaddr(lhost));
		else{
			svdata = svsock;
			VSA_setport(&svdata,0);
		}
		if( bind_inets(dsock,&svdata,1,lport) == 0 )
			goto BOUND;
	}
	svdata = svsock;

/*
## BUG ? ###################################
this seems the missunderstanding of specification?
this is capable on FreeBSD,
but repetitive lport usage makes remote server wait timeout...
*/
/* V8.0.0 don't use L-1 for PASV
if( VSA_port(&svdata) != 0 )
if( PASV ){
VSA_setport(&svdata,VSA_port(&svdata)-1);
if( bind_inet(dsock,&svdata,1) == 0 ) goto BOUND;
 }
*/
	VSA_setport(&svdata,0);
	if( bind_inet(dsock,&svdata,1) == 0 )
		goto BOUND;

	VSA_atosa(&svdata,0,"0.0.0.0");
	/*
	if( bind_inet(dsock,NULL,1) != 0 ){
	*/
	if( bind_inet(dsock,&svdata,1) != 0 ){
		sv1log("ERROR: Cannot bind.\n");
		close(dsock);
		return -1;
	}
BOUND:
	addrlen = sizeof(VSAddr);
	getsockname(dsock,(SAP)&svdata,&addrlen);

	{	const char *claddr;
		CStr(gwhost,256);
		int clport,gwport;
 
		claddr = VSA_ntoa(&svpeer);
		clport = VSA_port(&svpeer);
		if( SRCIFfor(Conn,"tcpbound",claddr,clport,AVStr(gwhost),&gwport) ){
			VSA_prftp(&svsock,AVStr(mport));
			VSA_atosa(&svsock,0,gethostaddr(gwhost));
		}
	}

	VSA_setport(&svsock,VSA_port(&svdata));
	VSA_prftp(&svsock,AVStr(mport));
	VSA_xtoap(&svsock,AVStr(local),sizeof(local));
	sv1log("FTP-data-local[%d]: %s\n",dsock,local);
	return dsock;
}

int UDPaccept(int svsock,int lockfd,int timeout)
{	VSAddr from,svme,xme,peer;
	int salen;
	int clsock;
	int xsock;
	int addrlen;
	int rcc,wcc;
	CStr(buf,0x8000);
	CStr(sfrom,128);
	CStr(speer,128);
	CStr(sme,128);
	int rcode,xtry,rbind,nsvsock;
	int af;

	if( sock_isv6(svsock) )
		af = AF_INET6;
	else	af = AF_INET;

	if( 0 <= lockfd && lock_exclusiveTO(lockfd,timeout*1000,NULL) != 0 ){
		sv1log("## UDP accept failed locking [%d]\n",errno);
		return -1;
	}
	if( PollIn(svsock,1) <= 0 ){
		sv1log("## UDP accept failed polling [%d]\n",errno);
		clsock = -1;
		goto EXIT;
	}

	addrlen = sizeof(VSAddr);
	rcc = Recvfrom(svsock,buf,sizeof(buf),0,(SAP)&from,&addrlen);
	if( rcc <= 0 ){
		sv1log("## UDP accept failed receiving [%d]\n",errno);
		clsock = -1;
		goto EXIT;
	}

	printSock(&from,AVStr(sfrom),"%A:%P");
	sv1log("UDP-SV[%d] ready=%d from=%s\n",svsock,rcc,sfrom);

	addrlen = sizeof(VSAddr);
	rcode = getsockname(svsock,(SAP)&svme,&addrlen);
	setsockREUSE(svsock,1);
	close(svsock);

	/*
	clsock = socket(AF_INET,SOCK_DGRAM,0);
	*/
	clsock = socket(af,SOCK_DGRAM,0);
	if( clsock == svsock ){
		clsock = dup(clsock);
		close(svsock);
	}
	setsockREUSE(clsock,1);

	xme = svme;

	for( xtry = 0; xtry < 10; xtry++ ){
		salen = VSA_size(&xme);
		rcode = bind(clsock,(SAP)&xme,salen);
		if( rcode == 0 )
			break;
		sleep(1);
	}
	if( rcode != 0 ){
		sv1log("UDP accept failed in bind %d\n",errno);
		close(clsock);
		clsock = -1;
		goto EXIT;
	}

	addrlen = sizeof(VSAddr);
	rcode = getsockname(clsock,(SAP)&xme,&addrlen);

	/*
	xsock = socket(AF_INET,SOCK_DGRAM,0);
	*/
	xsock = socket(af,SOCK_DGRAM,0);
	salen = VSA_size(&xme);
	wcc = sendto(xsock,buf,rcc,0,(SAP)&xme,salen);
	close(xsock);

	salen = VSA_size(&from);
	rcode = connect(clsock,(SAP)&from,salen);
	addrlen = sizeof(VSAddr);
	rcode = getpeername(clsock,(SAP)&peer,&addrlen);
	printSock(&peer,AVStr(speer),"%A:%P");

	addrlen = sizeof(VSAddr);
	rcc = Recvfrom(clsock,buf,sizeof(buf),MSG_PEEK,(SAP)&from,&addrlen);
	sv1log("UDP-CL[%d] ready=%d peer=%s\n",clsock,rcc,speer);

	/*
	nsvsock = socket(AF_INET,SOCK_DGRAM,0);
	*/
	nsvsock = socket(af,SOCK_DGRAM,0);
	setsockREUSE(nsvsock,1);
	for( xtry = 0; xtry < 10; xtry++ ){
		errno = 0;
		salen = VSA_size(&svme);
		rbind = bind(nsvsock,(SAP)&svme,salen);
		if( rbind == 0 )
			break;
		sleep(1);
	}
	if( nsvsock != svsock ){
		dup2(nsvsock,svsock);
		close(nsvsock);
	}

	addrlen = sizeof(VSAddr);
	getsockname(svsock,(SAP)&svme,&addrlen);
	printSock(&svme,AVStr(sme),"%A:%P");
	setsockREUSE(svsock,1);
	sv1log("UDP-SV[%d]: NEW bind=%d %s\n",svsock,rbind,sme);

EXIT:
	if( 0 < lockfd )
		lock_unlock(lockfd);
	return clsock;
}

int SOCKS_udpassoc(int msock,VSAddr *me,VSAddr *rme);
int SOCKS_udpassocsock(int sock,PCStr(lhost),int lport,PVStr(rhost),int *rport)
{	VSAddr me,rme;
	int melen;
	const char *aaddr;

	aaddr = gethostaddr(lhost);
	if( aaddr == NULL )
		return -1;
	VSA_atosa(&me,lport,aaddr);
	if( SOCKS_udpassoc(sock,&me,&rme) != 0 )
		return -1;
	
	strcpy(rhost,VSA_ntoa(&rme));
	*rport = VSA_port(&rme);
	return 0;
}
int sendTo(int sock,PCStr(sto),PCStr(msg),int len)
{	VSAddr sab;
	int salen;
	CStr(aaddr,64);
	int port;
	int wcc;

	port = 0;
	Xsscanf(sto,"%[^:]:%d",AVStr(aaddr),&port);
	if( port == 0 ){
		sv1log("sendTo(%s:%d) ? \n",aaddr,port);
		return -1;
	}

	salen = VSA_atosa(&sab,port,aaddr);
	wcc = sendto(sock,msg,len,0,(SAP)&sab,salen);
	return wcc;
}
int peekfrom(int sock,PVStr(sfrom))
{	CStr(buf,2048);
	VSAddr sab;
	int fromlen;
	int rcc;

	strcpy(sfrom,"0.0.0.0:0");
	fromlen = sizeof(VSAddr);
	rcc = Recvfrom(sock,buf,sizeof(buf),MSG_PEEK,(SAP)&sab,&fromlen);
	if( rcc <= 0 )
		return rcc;

	printSock(&sab,AVStr(sfrom),"%A:%P");
	return rcc;
}
int readfrom(int sock,void *buff,int size,PVStr(sfrom))
{	VSAddr sab;
	int fromlen;
	int rcc;

	strcpy(sfrom,"0.0.0.0:0");
	fromlen = sizeof(VSAddr);
	rcc = Recvfrom(sock,buff,size,0,(SAP)&sab,&fromlen);
	if( rcc <= 0 )
		return rcc;

	printSock(&sab,AVStr(sfrom),"%A:%P");
	return rcc;
}

void GetHostname(PVStr(name),int size)
{	struct hostent *hp;
	CStr(host,256);

	if( myFQDN == NULL ){
		gethostname(host,sizeof(host));
		if( hp = gethostbyNameAddr(0,host,NULL,0,0) )
			myFQDN = stralloc(hp->h_name);
		else{
			strcpy(myFQDN_unknown,host);
			myFQDN = myFQDN_unknown;
		}
	}
	strncpy(name,myFQDN,size);
}
int IsMyself(PCStr(host))
{	CStr(myhost,256);
	int hosti;

	hosti = gethostintMin(host);
	if( hosti == -1 )
		return 0;

	if( hosti == gethostintMin("localhost") )
		return 1;

	gethostname(myhost,sizeof(myhost));
	if( hosti == gethostintMin(myhost) )
		return 1;

	return 0;
}

int localsocket(int sock)
{	int phosti,pporti;
	int mhosti,mporti;

	phosti = peerHostport(sock,&pporti);
	if( phosti == -1 )
		return 1;

	mhosti = sockHostport(sock,&mporti);
	if( mhosti == -1 )
		return 1;

	if( phosti == mhosti )
		return 1;

	return 0;
}

int hostismyself(PCStr(host),FILE *sockfp)
{	VSAddr sab;
	int salen;
	const char *aaddr;
	int sock,rcode;

	if( __gethostint_nbo(0,"localhost",VStrNULL) == __gethostint_nbo(0,host,VStrNULL) )
		return 1;

	if( sockfp != NULL )
		if( localsocket(fileno(sockfp)) )
			return 1;

	aaddr = gethostaddr(host);
	if( aaddr == NULL )
		return 0;

	sock = socket(AF_INET,SOCK_STREAM,0);
	salen = VSA_atosa(&sab,0,aaddr);
	rcode = bind(sock,(SAP)&sab,salen);
	close(sock);

	if( rcode == 0 )
		return 1;

	return 0;
}

int hostcmp(PCStr(host1),PCStr(host2))
{	int hi1,hi2;

	if( strcasecmp(host1,host2) == 0 )
		return 0;

	if( (hi1 = gethostintMin(host1)) != -1 )
	if( (hi2 = gethostintMin(host2)) != -1 )
		if( hi1 == hi2 )
			return 0;
	return 1;
}
int hostcmp_incache(PCStr(host1),PCStr(host2))
{	int co,rcode;

	co = RES_CACHEONLY(1);
	rcode = hostcmp(host1,host2);
	RES_CACHEONLY(co);
	return rcode;
}

const char *VA_inAddr(VAddr *Ia)
{	int ia;

	ia = Ia->I3;
	inAddrx = (inAddrx+1) % 8;
	if( Ia->I0 || Ia->I1 || Ia->I2 ){
		int i4[4];
		i4[0] = htonl(Ia->I0);
		i4[1] = htonl(Ia->I1);
		i4[2] = htonl(Ia->I2);
		i4[3] = htonl(Ia->I3);
		Xstrcpy(EVStr(inAddrs[inAddrx]),
			VSA_ltoa((unsigned char*)&i4,16,AF_INET6));
		return inAddrs[inAddrx];
	}
	Xsprintf(EVStr(inAddrs[inAddrx]),"%d.%d.%d.%d",
		0xFF&(ia>>24),0xFF&(ia>>16),0xFF&(ia>>8),0xFF&ia);
	return inAddrs[inAddrx];
}

void getpairName(int clsock,PVStr(sockname),PVStr(peername))
{
	gethostName(clsock,AVStr(sockname),"%A:%P");
	getpeerName(clsock,AVStr(peername),"%A:%P");
}

int Socket1(PCStr(what), int sock,PCStr(domain),PCStr(type),PCStr(proto),PVStr(lhost),int lport,PCStr(rhost),int rport, int nlisten,PCStr(opts),int NB)
{	int Domain,Type,Proto;

	if( sock < 0 ){
		if( domain && strcasecmp(domain,"unix") == 0
		 || lhost != NULL && lhost[0] == '/'  )
			Domain = AF_UNIX;
		else	Domain = AF_INET;
		if( type && (strcaseeq(type,"udp")||strcaseeq(type,"dgram")||strcaseeq(proto,"udp")) )
			Type = SOCK_DGRAM;
		else	Type = SOCK_STREAM;
		Proto = 0;
		sock = newsocket(what,Domain,Type,Proto);
		if( sock < 0 )
			return -1;
	}
	if( lhost != NULL && lhost[0] == '/' ){
	}else
	if( lhost != NULL || 0 < lport ){
		if( strcmp(lhost,"*") == 0 )
			setVStrEnd(lhost,0);
		setsockREUSE(sock,1);
		setsockSHARE(sock,1);
		if( bind_insock(sock,lhost,lport) != 0 ){
			close(sock);
			return -1;
		}
	}
	if( 0 < nlisten ){
		if( listen(sock,nlisten) != 0 ){
			close(sock);
			return -1;
		}
	}
	if( rhost != NULL || 0 < rport
	 || rhost != NULL && rhost[0] == '/' ){
		if( NB ) setNonblockingIO(sock,1);
		if( __connectServer(sock,"Socket",what,rhost,rport) < 0 ){
			if( !NB ){
				close(sock);
				return -1;
			}
		}
	}
else{
/* for non-connect operation */
if( NB ) setNonblockingIO(sock,1);
}
	return sock;
}
int Listen(int sock,int backlog)
{
	return listen(sock,backlog);
}

int VA_hostIFto(VAddr *destp,VAddr *maskp,VAddr *Vaddr)
{	CStr(desthost,128);
	CStr(hostif,128);
	VAddr dest0,dest1,hostaddr;
	VAddr host;
	int ii;

	if( iftoV == NULL ){
		iftoV = (IfTo**)StructAlloc(NIFTO*sizeof(IfTo*));
	}
	AddrAND(dest0,(*destp),(*maskp));
	for( ii = 0; ii < iftoN; ii++ ){
		dest1 = iftoV[ii]->if_dest;
		if( AddrEQ(dest1,dest0) ){
			*Vaddr = iftoV[ii]->if_ifto;
			return 1;
		}
	}
	inet_itoaV4(destp->I3,AVStr(desthost));

	if( hostIFfor0(AVStr(hostif),1,"time",desthost,37,0) == 0 ){
		strcpy(hostif,"?");
		host = AddrNull;
	}else{
		host = AddrZero;
		host.I3 = ntohl(inet_addrV4(hostif));
	}

	if( ii < NIFTO ){
		iftoV[ii] = NewStruct(IfTo);
		iftoV[ii]->if_dest = dest0;
		iftoV[ii]->if_ifto = host;
		iftoN = ii+1;
	}
	sv1log("## hostIFto %s < %s (%x)\n",desthost,hostif,maskp->I3);
	*Vaddr = host;
	return 0;
}

int make_HOSTS(PVStr(hosts),PCStr(hostname),int cacheonly)
{	struct hostent *hp;

	if( hp = gethostbyNameAddr(cacheonly,hostname,NULL,0,0) ){
		dump_HOST1(AVStr(hosts),hp);
		return 1;
	}
	return 0;
}

int RES_order_default(PVStr(dorder),PCStr(myname),struct hostent *me);
void init_myname(PCStr(RESOLV))
{	CStr(order,RESOLVERS_SIZ);
	CStr(porder,RESOLVERS_SIZ);
	CStr(dresolv,RESOLVERS_SIZ);
	CStr(env,RESOLVERS_SIZ);
	CStr(myname,256);
	Hostent *Me;
	struct hostent *me;

	scan_HOSTS(0,"localhost/127.0.0.1");
	scan_HOSTS(0,"localhost/__1");

	/* put myname by SYS into HOSTS cache */
	gethostname(myname,sizeof(myname));
	if( Me = findHostCache(myname,NULL,0,0) )
		me = &Me->hc_hostent;
	else	me = NULL;
	if( me == NULL ){
		me = EX_GETHOSTBYNAME(myname);
		if( me != NULL ){
			me = addHostCacheOk(me,myname,"GETHOSTBYNAME",Time());
		}
	}

	/* V8.0.0 setup default RESOLV */
	if( RESOLV == NULL ){
		RES_order_default(AVStr(order),myname,me);
		RES_prorder(order,AVStr(dresolv));
		sprintf(env,"RESOLV=%s",dresolv);
		sv1log("export %s (set by default)\n",env);
		putenv(stralloc(env));
	}
}

int RES_order_default(PVStr(dorder),PCStr(myname),struct hostent *me)
{	CStr(order,RESOLVERS_SIZ);
	CStr(porder,RESOLVERS_SIZ);
	const char *rp;
	CStr(resolv,RESOLVERS_SIZ);
	CStr(env,RESOLVERS_SIZ);
	const char *op;
	CStr(myaddr,64);
	struct hostent *me_dns;
	const char *name;
	const char *ypdomain;
	const char *addr;
	int hi,ai;

	strcpy(porder,"");
	op = getenv("RES_ORDER");
	if( op ){
		RES_order(op,AVStr(porder));
		strcpy(dorder,op);
		return 0;
	}
	sv1log("configuring default RESOLV ...\n");
	me_dns = 0;
	if( me ){
		/*
		dumpAddr(AVStr(myaddr),me->h_addr_list[0]);
		*/
		dumpAddr(AVStr(myaddr),me->h_addr_list[0],me->h_length,me->h_addrtype);
		sv1log("... SYS: %s -> %s\n",myname,myaddr);
		RES_order("D",AVStr(porder));
		for( ai = 0; addr = me->h_addr_list[ai]; ai++ ){
			me_dns = gethostbyaddr(addr,
				me->h_length,me->h_addrtype);
			if( me_dns ){
				/*
				dumpAddr(AVStr(myaddr),addr);
				*/
				dumpAddr(AVStr(myaddr),addr,me->h_length,me->h_addrtype);
				break;
			}
		}
		RES_order(porder,AVStr(order));
	}else{
		RES_order(porder,VStrNULL);
	}
	if( me_dns ){
		if( rp = strchr(porder,'S') )
			ovstrcpy((char*)rp,rp+1);
		RES_order(porder,AVStr(order));
		sv1log("... DNS: %s -> %s\n",myaddr,me_dns->h_name);
		sv1log("... DNS available\n");
	}
	if( yp_get_default_domain((char**)&ypdomain) == 0 && *ypdomain != 0 ){
		sv1log("... NIS domain: %s\n",ypdomain);
	}else{
		if( rp = strchr(porder,'N') )
			ovstrcpy((char*)rp,rp+1);
		RES_order(porder,AVStr(order));
		sv1log("... NIS not available (no default domain)\n");
	}
	strcpy(dorder,porder);
	sprintf(env,"RES_ORDER=%s",dorder);
	putenv(stralloc(env));
	sv1log("... export %s\n",env);
	return 1;
}
#endif /* !LIBRARY */
