/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994-1999 Yutaka Sato
Copyright (c) 1994-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	access.c (Access Control)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:

  AUTH = what : authProto : valid-user@host-list

    AUTH=manager:*:user@host
    AUTH=anonftp:*:user@host
    AUTH=anonftp:smtp-vrfy:user@host
    AUTH=proxy:{auth,pauth}  ... authorization is done by RELIABLE/PREMIT

    AUTH=authgen:basic:authString
    AUTH=fromgen:fromString
    AUTH=forward:paramList
    AUTH=log:remoteHost:Ident:authUser

History:
	940303	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdlib.h>
#include <ctype.h>
#include <errno.h>
#include "ystring.h"
#include "hostlist.h"
#include "vaddr.h"
#include "delegate.h"
#include "file.h"
#include "credhy.h"
#include "auth.h"

HostList *ReliableHosts();
HostList *ReachableHosts();
int notREMITTABLE(PCStr(proto),int port);
HostList *NotifyPltfrmHosts();

int ftp_auth(FILE *ts,FILE *fs,PVStr(resp),int rsize,PCStr(user),PCStr(pass));
int connect_to_servX(Connection *Conn, int fromC,int toC, int relay_input, int do_filter);
void VA_HL_pushClientInfo(double Now,VAddr *peerhost,VAddr *sockhost);
int HTTP_authorize_Digest(Connection *Conn,AuthInfo *ident,PCStr(dom),PCStr(user),PCStr(dpass),PVStr(serv),int port);
int pam_service(Connection *ctx,int forbidden,PVStr(req),PVStr(user),int *stcodep);
int pam_checkPasswd(Connection *ctx,PCStr(host),int port,PCStr(service),PCStr(user),PCStr(pass));
int get_MYAUTH(Connection *Conn,PVStr(myauth),PCStr(proto),PCStr(dhost),int dport);
int DELEGATE_permitM(Connection *Conn,PCStr(proto),PCStr(method),PCStr(dsthost),int dport,PCStr(srchost),int sport);
int DELEGATE_rejectM(Connection *Conn,PCStr(proto),PCStr(method),PCStr(dsthost),int dport,PCStr(srchost),int sport);
void putRejectList(PCStr(what),PCStr(dproto),PCStr(dhost),int dport,PCStr(dpath),PCStr(referer),PCStr(sproto),PCStr(shost),int sport,PCStr(suser),PCStr(auser),PCStr(apass),PCStr(reason));

int getEKey(Connection *ctx,FILE *tc,int com,PCStr(proto),PCStr(host),PCStr(port),PCStr(user),PCStr(pass),PVStr(ekey));

#define Ident()	getClientUserC(Conn)

#define A_MANAGER	"manager"
#define A_ADMIN		"admin"
#define A_ANONFTP	"anonftp"
#define A_ORIGIN	"origin"
#define A_PROXY		"proxy"
#define A_LOG		"log"
#define A_FORWARD	"forward"
#define A_VIAGEN	"viagen"
#define A_FROMGEN	"fromgen"
#define A_AUTHGEN	"authgen"
#define A_PAUTHGEN	"pauthgen"

#define AP_SMTP_VERIFY	"smtp-vrfy"
#define AP_REQ_AUTH	"auth"	/* use auth. info. in request message */
#define AP_REQ_PAUTH	"pauth"	/* use proxy auth. info. in req. message */

typedef struct {
	MStr(	a_authority,1024);
	defQStr(a_authp); /**/
  const	char   *a_authv[32]; /**/
	int	a_authx;
} AuthEnv;
static AuthEnv *authEnv;
#define Auth	authEnv[0]
void minit_access()
{
	if( authEnv == 0 )
		authEnv = NewStruct(AuthEnv);
}
#define Authority	Auth.a_authority
/**/
#define Authp		Auth.a_authp
#define Authv		Auth.a_authv
#define Authx		Auth.a_authx

void scan_AUTH(Connection *Conn,PCStr(auth))
{
	if( elnumof(Authv) <= Authx ){
		daemonlog("F","ERROR: ignored too many AUTH -- %s\n",auth);
		return;
	}
	if( Authp == 0 )
		McpyQStr(Authp,Authority);
	Authv[Authx++] = Authp;
	strcpy(Authp,auth);
	Authp += strlen(Authp) + 1;
}
static const char *find_auth(PCStr(what),PCStr(val))
{	int ai;
	int len,vlen;
	const char *auth1;
	const char *val1;

	len = strlen(what);
	if( val )
		vlen = strlen(val);
	else	vlen = 0;
	for( ai = 0; ai < Authx; ai++ ){
		auth1 = Authv[ai];
		if( strncmp(auth1,what,len) != 0 )
			continue;
		if( auth1[len] == 0 )
			val1 = &auth1[len];
		else
		if( auth1[len] == ':' )
			val1 = &auth1[len+1];
		else	continue;

		if( val == NULL )
			return val1;
		if( strncmp(val1,val,vlen) == 0 ){
			if( val1[vlen] == 0 )
				return &val1[vlen];
			if( val1[vlen] == ':' )
				return &val1[vlen+1];
		}
	}
	return 0;
}
static int findAuth(Connection *Conn,PCStr(what),PCStr(proto),PCStr(auth))
{	CStr(xauth,1024);

	if( strcasecmp(proto,AP_SMTP_VERIFY) != 0 )
		proto = "*";

	sprintf(xauth,"%s:%s",proto,auth);
	if( find_auth(what,xauth) )
		return 1;

	sprintf(xauth,"%s:*",proto);
	if( find_auth(what,xauth) )
		return 1;

	return 0;
}
int CTX_with_auth_admin(Connection *Conn)
{
	if( find_auth(A_ADMIN,NULL) )
		return 1;
	else	return 0;
}
int CTX_auth_admin(Connection *Conn,PCStr(what),PCStr(proto),PCStr(userhost))
{
	if( findAuth(Conn,A_ADMIN,proto,userhost) )
		return 1;
	return findAuth(Conn,A_MANAGER,proto,userhost);
}
int CTX_with_auth_anonftp(Connection *Conn)
{
	if( find_auth(A_ANONFTP,NULL) )
		return 1;
	else	return 0;
}
int CTX_auth_anonftp(Connection *Conn,PCStr(proto),PCStr(user),PCStr(pass))
{
	if( find_auth(A_ANONFTP,NULL) == 0 )
		return 1;

	if( is_anonymous(user) || user[0] == 0 )
		return 0;
	if( strchr(user,'@') == 0 )
		return 0;
	return findAuth(Conn,A_ANONFTP,proto,pass);
}
int auth_origin_auth()
{
	if( find_auth(A_ORIGIN,AP_REQ_AUTH) )
		return 1;
	else	return 0;
}
int auth_proxy_auth()
{
	if( find_auth(A_PROXY,AP_REQ_AUTH) )
		return 1;
	else	return 0;
}
int auth_proxy_pauth()
{
	if( find_auth(A_PROXY,AP_REQ_PAUTH) )
		return 1;
	else	return 0;
}

int NotifyPlatform(Connection *Conn,int isreq)
{	const char *host;
	CStr(hostb,256);
	const char *user;
	int port,match;
	HostList *notplat;

	notplat = NotifyPltfrmHosts();
	if( isreq ){
		host = DST_HOST;
		port = DST_PORT;
		user = "-";
	}else{
		host = hostb;
		port = getClientHostPort(Conn,AVStr(hostb));
		user = "-";
	}
	match = hostIsinList(notplat,DST_PROTO,host,port,user);
	return match;
}
void makeVia(Connection *Conn,PVStr(via))
{	const char *fmt;

	if( fmt = find_auth(A_VIAGEN,NULL) ){
		if( strcmp(fmt,"-") == 0 ){
			setVStrEnd(via,0);
		}else
		if( *fmt == 0 )
			ClientIF_HP(Conn,AVStr(via));
		else	strfConnX(Conn,fmt,AVStr(via),256);
	}else{
		strcpy(via,"-");
	}
}
int makeForwarded(Connection *Conn,PVStr(forwarded))
{	CStr(myuri,256);
	CStr(client,256);
	CStr(myhp,256);

	if( find_auth(A_FORWARD,NULL) ){
		ClientIF_HP(Conn,AVStr(myhp));
		sprintf(myuri,"http://%s/",myhp);
		getClientHostPort(Conn,AVStr(client));
	}else{
		return 0;
		/*
		strcpy(myuri,"-");
		strcpy(client,"-");
		*/
	}
	sprintf(forwarded,"by %s (DeleGate/%s) for %s",
		myuri,(char*)DELEGATE_ver(),client);

	return 1;
}

int makeAuthorization(Connection *Conn,PVStr(genauth),int proxy)
{	const char *fmt;
	CStr(atype,128);
	const char *afmt;
	CStr(gauth,256);
	CStr(eauth,256);
	CStr(host,128);
	int port;
	const char *dp;
	CStr(authb,256);
	CStr(fmtb,256);

	authb[0] = 0;
	/*
	if( ClientAuth.i_stat == AUTH_FORW ){
	*/
	if( !proxy && ClientAuth.i_stat == AUTH_FORW ){
		sprintf(authb,"%s:%s",ClientAuth.i_user,ClientAuth.i_pass);
	}else
	if( streq(GatewayProto,"ssltunnel") ){
		get_MYAUTH(Conn,AVStr(authb),"ssltunnel",GatewayHost,GatewayPort);
		if( authb[0] == 0 )
		get_MYAUTH(Conn,AVStr(authb),"http-proxy",GatewayHost,GatewayPort);
	}else
	if( proxy ){
		if( toProxy && streq(GatewayProto,"http") )
		get_MYAUTH(Conn,AVStr(authb),"http-proxy",GatewayHost,GatewayPort);
	}else{
		get_MYAUTH(Conn,AVStr(authb),"http",DST_HOST,DST_PORT);
	}
	if( authb[0] ){
		sprintf(fmtb,"basic:%s",authb);
		fmt = fmtb;
	}else{
	if( proxy ){
	if( (fmt = find_auth(A_PAUTHGEN,NULL)) == NULL )
		return 0;
	}else
	if( (fmt = find_auth(A_AUTHGEN,NULL)) == NULL )
		return 0;
	}
	strcpy(atype,fmt);
	if( afmt = strchr(atype,':') ){
		truncVStr(afmt); afmt++;
	}else	afmt = "";
	atype[0] = toupper(atype[0]);

	strfConnX(Conn,afmt,AVStr(gauth),sizeof(gauth));
	if( gauth[0] == 0 )
		return 0;

	if( authb[0] == 0 )
	if( !proxy ){
	gethostname(host,sizeof(host));
	strcat(gauth,"/");
	strcat(gauth,host);
	}

	str_to64(gauth,strlen(gauth),AVStr(eauth),512,1);
	if( dp = strpbrk(eauth,"\r\n") )
		truncVStr(dp);

	sprintf(genauth,"%s %s",atype,eauth);
	return 1;
}

int makeFrom(Connection *Conn,PVStr(genfrom))
{	const char *fmt;

	setVStrEnd(genfrom,0);
	if( (fmt = find_auth(A_FROMGEN,NULL)) == NULL )
		return 0;

	if( *fmt == 0 )
		fmt = "%u@%h";
	strfConnX(Conn,fmt,AVStr(genfrom),256);
	return 1;
}

void makeClientLog(Connection *Conn,PVStr(clientlog))
{	CStr(host,256);
	CStr(iuser,256);
	CStr(auser,256);
	const char *hfmt;
	const char *ifmt;
	const char *afmt;
	CStr(xhfmt,128);
	CStr(xifmt,128);
	CStr(xafmt,128);
	const char *fmt;

	hfmt = "%h";
	ifmt = "%u";
	afmt = "%U";
	if( fmt = find_auth(A_LOG,NULL) ){
		xhfmt[0] = xifmt[0] = xafmt[0] = 0;
		scan_Listlist(fmt,':',AVStr(xhfmt),AVStr(xifmt),AVStr(xafmt),VStrNULL,VStrNULL);
		if( xhfmt[0] ) hfmt = xhfmt;
		if( xifmt[0] ) ifmt = xifmt;
		if( xafmt[0] ) afmt = xafmt;
	}

	strfConnX(Conn,hfmt,AVStr(host),sizeof(host));  if(host[0] ==0) strcpy(host,"-");
	strfConnX(Conn,ifmt,AVStr(iuser),sizeof(iuser)); if(iuser[0]==0) strcpy(iuser,"-");
	strfConnX(Conn,afmt,AVStr(auser),sizeof(auser)); if(auser[0]==0) strcpy(auser,"-");

	sprintf(clientlog,"%s %s %s",host,iuser,auser);
}

/*
 *	If no RELIABLE host is specified explicitly, then suppose that any
 *	hosts is relaible.  Typical case is that the DeleGate is running
 *	on the host which belongs to a secure network within a firewall.
 */
extern const char *hostmatch_ignauth;
static int RELIABLE_HOST(Connection *Conn,HostList *hostlist,PCStr(srchost),int srcport)
{	const char *suser;
	int ac;
	AuthInfo *av[4]; /**/

	if( hostlist->hl_cnt == 0 )
		return 1;

	suser = Ident();
	if( suser == 0 && Conn->no_authcheck )
		suser = hostmatch_ignauth;
	ac = getClientAuthList(Conn,4,av);
	HLdebug("{HL} RELIABLE\n");
	return hostIsinListX(hostlist,DFLT_PROTO,srchost,srcport,suser,ac,av);
/*
{
CStr(ohost,128);
getOriginator(ohost);
printf("ROUTE: %s [%s]\n",CTX_get_PATH(Conn),ohost);
}
*/
/*
		if( suser == NULL ){
			CStr(qhost,128);
			CStr(quser,128);
			if( get_equiv_user(srchost,srcport,qhost,quser) ){
				suser = quser;
				srchost = qhost;
				srcport = 0;
			}
		}
*/
}
static int REACHABLE_HOST(Connection *Conn,HostList *hostlist,PCStr(proto),PCStr(hostname),int dstport)
{	const char *duser = Conn ? DST_USER : NULL;

	if( hostlist->hl_cnt == 0 )
		return 1;
	if( Conn != NULL && Conn->no_dstcheck )
		return 1;

	return hostIsinList(hostlist,proto,hostname,dstport,duser);
}
int source_permitted(Connection *Conn)
{	int ok;

	Conn->no_dstcheck = 1;
	ok = service_permitted2(Conn,DST_PROTO,1);
	Conn->no_dstcheck = 0;
	return ok;
}
int source_permittedX(Connection *Conn)
{	int ok;

	Conn->no_authcheck = 1;
	ok = source_permitted(Conn);
	Conn->no_authcheck = 0;
	return ok;
}
int service_permitted0(PCStr(clhost),int clport,PCStr(svproto),PCStr(svhost),int svport)
{	Connection ConnBuf, *Conn = &ConnBuf;
	int ok;

	ConnInit(Conn);
	if( clhost ){
		strcpy(Client_Host,clhost);
	}else{
		Client_Host[0] = 0;
	}
	Client_Port = clport;
	set_realsite(Conn,svproto,svhost,svport);
	ok = service_permitted2(Conn,svproto,1);
	if( !ok ){
		daemonlog("E","No permission: %s:%d > %s://%s:%d\n",
			clhost,clport,svproto,svhost,svport);
	}
	return ok;
}
int method_permitted0()
{
	return 1;
}

/*
 *	Not implemented yet
 *	(This is done in RELIABLE_HOST() ?)
 */
static int PERMITTED_USER(Connection *Conn,HostList *hostlist,PCStr(hostname),int lport,int stdport)
{
	if( hostlist->hl_cnt == 0 )
		return 1;
	return 1;
}

static int PERMITTED_PORT(Connection *Conn,PCStr(proto),PCStr(host),int port)
{	int stdport;

	if( streq(proto,"telnet") ){
	    stdport = serviceport("telnet");

if( getenv("ANYPORT") == 0 )
	    if( port != 0 && port != stdport ){
		if( ImProxy )
			sv1log("Proxy telnet follows PERMIT parameter\n");
		else
		if( streq(iSERVER_PROTO,"telnet") && port==iSERVER_PORT )
			sv1log("TELNET to non-standard port: %d %d/%d\n",
				port,DFLT_PORT,iSERVER_PORT);
		else{
			Verbose("cannot TELNET to non-standard port %d\n",
				DFLT_PORT);
			return 0;
		}
	    }
	}
	if( port == 19 ){
		if( streq(proto,"http") || streq(proto,"gopher") ){
			sv1log("HTTP,Gopher to 19(chargen) is inhibited.\n");
			return 0;
		}
	}
	return 1;
}
static int PERMITTED_PAIR(Connection *Conn,PCStr(proto),PCStr(dhost),int dport,PCStr(shost),int sport)
{
	return DELEGATE_permitM(Conn,proto,NULL,dhost,dport,shost,sport);
}

int PERMITTED_ACCESS(Connection *Conn,PCStr(shost),int sport,int stdport)
{	int permitted = 0;

	Conn->reject_reason[0] = 0;
	if(!RELIABLE_HOST(Conn,ReliableHosts(),shost,sport))
	{
		sprintf(Conn->reject_reason,"'%s' not RELIABLE",shost);
		Verbose("not RELIABLE\n");
	}
	else
	if(!PERMITTED_USER(Conn,ReliableHosts(),shost,sport,stdport))
	{
		sprintf(Conn->reject_reason,"not PERMITTED_USER");
		Verbose("not PERMITTED_USER\n");
	}
	else
	if(!REACHABLE_HOST(Conn,ReachableHosts(),DST_PROTO,DST_HOST,DST_PORT))
	{
		sprintf(Conn->reject_reason,"'%s' not REACHABLE",DST_HOST);
		Verbose("not REACHABLE\n");
	}
	else
	if(!PERMITTED_PORT(Conn,DST_PROTO,DST_HOST,DST_PORT))
	{
		sprintf(Conn->reject_reason,"not PERMITTED_PORT");
		Verbose("not PERMITTED_PORT\n");
	}
	else
	if( DELEGATE_rejectM(Conn,DST_PROTO,NULL,DST_HOST,DST_PORT,shost,sport) ){
		Verbose("REJECTED_PAIR\n");
		sprintf(Conn->reject_reason,"matched REJECT");
	}else
	if(!PERMITTED_PAIR(Conn,DST_PROTO,DST_HOST,DST_PORT,shost,sport))
	{
		Verbose("not PERMITTED_PAIR\n");
		if( Conn->reject_reason[0] == 0 )
		sprintf(Conn->reject_reason,"unmatch PERMIT");
	}
	else
		permitted = 1;

if(!permitted)
if(LOG_GENERIC){
const char *user;
if( (user = getClientUserC(Conn)) == NULL )
	user = "-";
fputLog(Conn,"Reject","%s@%s:%d; to=%s://%s:%d\n",
user,shost,sport,
DST_PROTO,DST_HOST,DST_PORT);
}

	return permitted;
}

void VA_setClientAddr(Connection *Conn,PCStr(addr),int port,int remote)
{
	VA_setVAddr(Client_VAddr,addr,port,remote);
}
int VA_getClientAddr(Connection *Conn)
{
	if( 0 <= ClientSock )
	if( Client_Port == 0 ){
		VA_getpeerNAME(ClientSock,Client_VAddr);
	}
	return 0 < Client_Port;
}
int getClientHostPortAddr(Connection *Conn,PVStr(rhost),PVStr(raddr))
{
	VA_getClientAddr(Conn);

	if( Client_Port <= 0 ){
		if( rhost != NULL ) strcpy(rhost,"--Cant-GetPeerName");
		if( raddr != NULL ) strcpy(raddr,"255.255.255.255");
		return 0;
	}

	if( rhost != NULL ) strcpy(rhost,Client_Host);
	if( raddr != NULL ) VA_inetNtoah(Client_VAddr,AVStr(raddr));
	return Client_Port;
}
int getClientHostPort(Connection *Conn,PVStr(rhost))
{
	return getClientHostPortAddr(Conn,AVStr(rhost),VStrNULL);
}


/*
 *	PERMIT about RELAY function
 *	control accessibility of relay function
 */
static scanListFunc scan_relay1(PCStr(r1),int *maskp)
{
	if( streq(r1,"novhost")  ) *maskp &= ~RELAY_VHOST;
	if( streq(r1,"vhost")    ) *maskp |= RELAY_VHOST;
	if( streq(r1,"tproxy")   ) *maskp |= RELAY_VHOST;
	if( streq(r1,"proxy")    ) *maskp |= RELAY_PROXY;
	if( streq(r1,"delegate") ) *maskp |= RELAY_DELEGATE;
	if( streq(r1,"noapplet") ) *maskp &= ~RELAY_APPLET;
	if( streq(r1,"nojava")   ) *maskp &= ~RELAY_JAVA;
	return 0;
}
static int scan_relay(PCStr(realm))
{	int mask;

/*
	mask = RELAY_VHOST | RELAY_JAVA | RELAY_APPLET;
*/
	mask = RELAY_JAVA | RELAY_APPLET;
	scan_List(realm,',',0,scanListCall scan_relay1,&mask);
	return mask;
}
scanListFunc scan_RELAY1(PCStr(relay1),Connection *Conn)
{
	scan_CMAP2(Conn,"relay",relay1);
	return 0;
}
void scan_RELAY(Connection *Conn,PCStr(relay))
{
	scan_List(relay,';',0,scanListCall scan_RELAY1,Conn);
}
int do_RELAY(Connection *Conn,int what)
{	CStr(realm,128);
	int found;
	int caps,relay;

	/* this function should be unified with service_permitted() ... */
	if( Conn->from_myself )
		return 1;

	CTX_pushClientInfo(Conn);
	relay = 0;
	for( found = 0;; found++){
		found = find_CMAPi(Conn,"relay",found,AVStr(realm));
		if( found < 0 )
			break;
		caps = scan_relay(realm);
		if( (caps & what) == what ){
			relay = caps;
			break;
		}
	}
	HL_popClientInfo();
	return relay;
}

Connection *FORCE_REWRITE = (Connection*)-1;
/*
it's too heavy to be checked for each embedded URL in HTML...

int isRELAYABLE(Connection *Conn,PCStr(proto),PCStr(hostport))
{
	if( Conn == FORCE_REWRITE )
		return 1;
	return do_RELAY(Conn,RELAY_DELEGATE);
}
*/

int isREACHABLE(PCStr(proto),PCStr(hostport))
{	CStr(host,512);
	int port;
	int svf,yes;

	port = scan_hostport(proto,hostport,AVStr(host));
	svf = RES_CACHEONLY(1);
	yes = REACHABLE_HOST(NULL,ReachableHosts(),ANYP,host,port);
	RES_CACHEONLY(svf);
	return yes;
}

int NotREACHABLE(Connection *Conn,PCStr(proto),PCStr(host),int port)
{	int reach;

	if( Conn != NULL
	 && Conn->no_dstcheck_proto
	 && Conn->no_dstcheck_proto == serviceport(proto) )
		return 0;

	if( notREMITTABLE(proto,port) )
		return 1;

	CTX_pushClientInfo(Conn);
	reach = REACHABLE_HOST(NULL,ReachableHosts(),proto,host,port);
	HL_popClientInfo();
	if( !reach )
		return 1;

	return 0;
}

void addRejectList(Connection *Conn,PCStr(what),PCStr(dpath),PCStr(referer),PCStr(auser),PCStr(apass),PCStr(reason))
{	CStr(src_host,256);
	const char *src_user;
	int src_port;

	src_user = getClientHostPortUser(Conn,AVStr(src_host),&src_port);
	if( src_user == NULL )
		src_user = "-";

	if( *apass != 0 )
	if( !strcaseeq(auser,"anonymous") )
	if( !strcaseeq(auser,"ftp") || !strcaseeq(DST_PROTO,"ftp") )
		apass = "*";

	if( *referer == 0 )
		referer = "-";

	putRejectList(what,
		DST_PROTO, DST_HOST,DST_PORT, dpath, referer,
		DFLT_PROTO,src_host,src_port, src_user,
		auser,apass,reason);
}
static void local_auth(PVStr(path),PVStr(uh),PCStr(proto),PCStr(user),PCStr(host),int port)
{	CStr(uh_md5,64);

	if( host[0] == 0 ) Xstrcpy(ZVStr((char*)host,16),"localhost"); /* not "const" but fixed */
	if( port == 0 ) port = serviceport(proto);

	sprintf(uh,"%s://%s@%s:%d",proto,user,host,port);
	toMD5(uh,uh_md5);
	sprintf(path,"${ADMDIR}/authorizer/%s/%s",host,uh_md5);
	DELEGATE_substfile(AVStr(path),"",VStrNULL,VStrNULL,VStrNULL);
}
void DGAuth_file(PVStr(path),PVStr(uh),PCStr(proto),PCStr(user),PCStr(host),int port)
{
	local_auth(AVStr(path),AVStr(uh),proto,user,host,port);
}

/*
 * AUTHORIZER=-dgauth[.realm][//server..port]
 */
int scanAuthServPort(PCStr(domain),PVStr(serv))
{	int port;
	const char *dp;

	setVStrEnd(serv,0);
	port = 0;
	if( dp = strstr(domain,"//") ){
		truncVStr(dp);
		wordscanX(dp+2,AVStr(serv),64);
		if( dp = strstr(serv,"..") ){
			truncVStr(dp);
			port = atoi(dp+2);
		}
	}
	return port;
}

extern char DGAUTHpro[];
extern char DGAUTHdom[];

int authEdit(int detail,FILE *tc,int com,PCStr(proto),PCStr(host),int port,PCStr(user),PCStr(pass),PCStr(ekey),int expire);
int authedit_main(int ac,const char *av[],Connection *ctx)
{	const char *userpass;
	CStr(user,64);
	CStr(pass,64);
	const char *hostport;
	CStr(host,64);
	CStr(port,64);
	const char *dp;
	int expire;
	FILE *afp,*tc;
	int com;
	CStr(ekey,64);
	int elen;
	int remote;
	const char *proto;

	tc = stdout;
	if( ac < 4 || av[1][0] != '-' ){
		fprintf(tc,
		"-USAGE: %s -{a|d|v} user[:pass] host[:port] [expire]\r\n",
			av[0]);
		return -1;
	}
	userpass = av[2];
	hostport = av[3];
	scan_namebody(userpass,AVStr(user),sizeof(user),":",AVStr(pass),sizeof(pass),NULL);
	scan_namebody(hostport,AVStr(host),sizeof(host),":",AVStr(port),sizeof(port),NULL);
	expire = 0;

	com = av[1][1];
	ekey[0] = 0;
	if( com == 'a' ){
		const char *dp;
		if( pass[0] == 0 ){
			fprintf(tc,"Password (not hidden): ");
			fflush(tc);
			fgets(pass,sizeof(pass),stdin);
			if( dp = strpbrk(pass,"\r\n") )
				truncVStr(dp);
		}
	}

	if( strneq(host,DGAUTHdom,7) )
		proto = DGAUTHpro;
	else	proto = "ftp";
	remote = strstr(host,"//") != 0;
	if( com == 'a' || remote ){
		if( remote || ekey[0] == 0 && streq(proto,DGAUTHpro) ){
			elen = getEKey(ctx,tc,com,proto,host,port,user,pass,AVStr(ekey));
			if( elen <= 0 )
				return 0;
		}
	}

	authEdit(1,tc,com,proto,host,atoi(port),user,pass,ekey,expire);
	return 0;
}
int authEdit0(Connection *ctx,int detail,FILE *tc,int com,PCStr(host),PCStr(user),PCStr(pass))
{	const char *proto;
	CStr(ekey,256);
	int elen,rcode;

	if( strneq(host,DGAUTHdom,7) ){
		proto = DGAUTHpro;
		elen = getCKey(AVStr(ekey),sizeof(ekey));
		/*
		elen = getEKey(ctx,tc,com,proto,host,"",user,pass,ekey);
		*/
	}else	proto = "ftp";
	rcode = authEdit(detail,tc,com,proto,host,0,user,pass,ekey,0);
	bzero(ekey,sizeof(ekey));
	return rcode;
}
int authEdit(int detail,FILE *tc,int com,PCStr(proto),PCStr(host),int port,PCStr(user),PCStr(pass),PCStr(ekey),int expire)
{	CStr(uh,256);
	CStr(epass,128);
	CStr(pw_md5,64);
	CStr(path,1024);
	FILE *afp;
	int rcode;

	local_auth(AVStr(path),AVStr(uh),proto,user,host,port);
	rcode = 0;

	switch( com ){
	  case 'v':
	  default:
		if( File_is(path) ){
			fprintf(tc,"+OK current auth. for %s follows:\r\n",uh);
		}else{
			fprintf(tc,"-ERROR no auth. for %s\r\n",uh);
			rcode = -1;
		}
		break;
	  case 'd':
		rcode = unlink(path);
		if( rcode == 0 )
			fprintf(tc,"+OK removed the auth.\r\n");
		else	fprintf(tc,"-ERROR could not remove the auth. (errno=%d)\r\n",errno);
		break;

	  case 'a':
		if( File_is(path) ){
			fprintf(tc,"-ERROR the auth. exists already, remove it first by `-d' option\r\n");
			rcode = -1;
			break;
		}
		if( afp = dirfopen("AUTH",AVStr(path),"w") ){
			toMD5(pass,pw_md5);
			if( *ekey ){
			aencrypty(ekey,strlen(ekey),pass,strlen(pass),epass);
			fprintf(afp,"%s %s\r\n%d\r\n",pw_md5,epass,expire);
			}else{
			fprintf(afp,"%s\r\n%d\r\n",pw_md5,expire);
			}
			fprintf(tc,"+OK added the auth.\r\n");
			fclose(afp);
		}else{
			fprintf(tc,"-ERROR could not add the auth. (errno=%d)\r\n",errno);
			rcode = -1;
		}
		break;
	}
	if( detail ){
		fprintf(tc,"PATH: %s\r\n",path);
		fprintf(tc,"AUTH: %s\r\n",uh);
		if( afp = dirfopen("AUTH",AVStr(path),"r") ){
			CStr(tmp,128);
			strcpy(tmp,"\n");
			fgets(tmp,sizeof(tmp),afp);
			fprintf(tc,"PASS: %s",tmp);
			tmp[0] = 0;
			fgets(tmp,sizeof(tmp),afp);
			fprintf(tc,"EXPIRE: %s",atoi(tmp)==0?"never\r\n":tmp);
			fclose(afp);
		}
		fprintf(tc,"\r\n");
	}
	return rcode;
}
int CTX_auth_cache(Connection *ctx,int store,int expire,PCStr(proto),PCStr(user),PCStr(pass),PCStr(host),int port)
{	CStr(uh,512);
	CStr(uh_md5,128);
	CStr(pw_md5,128);
	CStr(apath,1024);
	CStr(cpass,128);
	FILE *afp;
	CStr(hostb,128);
	const char *dp;
	CStr(lapath,1024);

	if( strchr(host,'/') ){
		/* set by AUTHORIZER=host/port */
		dp = wordscanY(host,AVStr(hostb),sizeof(hostb),"^/");
		host = hostb;
		port = atoi(dp+1);
	}

	sprintf(uh,"%s://%s@%s:%d",proto,user,host,port);
	Verbose("AUTH_CACHE %d %s\n",store,uh);

	toMD5(uh,uh_md5);
	toMD5(pass,pw_md5);

	/*
	SPRINTF(rpath,"%d/%s",SERVER_PORT(),uh_md5);
	CTX_cache_path(ctx,"delegate","auth",9999,rpath,apath);
	*/
	local_auth(AVStr(lapath),AVStr(uh),proto,user,host,port);
	sprintf(apath,"%s-cache",lapath);

	if( store ){
		if( afp = dirfopen("AUTH",AVStr(apath),"w") ){
			fprintf(afp,"%s\n",pw_md5);
			fclose(afp);
			return 0;
		}else	return -1;
	}else{
		if( afp = fopen(lapath,"r") )
			sv1log("persistent auth: %s %s\n",uh,lapath);
		else	afp = expfopen("AUTH",expire,AVStr(apath),"r",NULL);
		if( afp ){
			cpass[0] = 0;
			Fgets(AVStr(cpass),sizeof(cpass),afp);
			fclose(afp);
			if( strcmp(pw_md5,cpass) == 0 ){
				Verbose("cached auth OK: %s@%s\n",user,host);
				return 1;
			}
		}
		return 0;
	}
}

#define IDENTIFY_MAP	"Identifier"
#define AUTHORIZE_MAP	"Authorizer"
#define AUTHSERV_MAP	"AuthServer"
const char *MAP_AUTHSERV = AUTHSERV_MAP;

#define I_IDENT		"?"
#define I_FTP		"&"
#define I_ANY		"*"
#define AUTH_VDOM	"-AUTH"

void scan_AUTHORIZER(Connection *Conn,PCStr(authserv))
{	CStr(vauthserv,256);
	CStr(aserv,256);
	CStr(proto,256);
	CStr(dhost,256);

/*
	if( !streq(authserv,I_IDENT) && !streq(authserv,I_FTP) ){
		if( num_ListElems(authserv,':') == 1 ){
			sprintf(vauthserv,"%s.%s",authserv,AUTH_VDOM);
			scan_RELIABLE(Conn,vauthserv);
		}else{
			scan_Listlist(authserv,':',aserv,proto,dhost,0);
			if( aserv[0] == 0 ) strcpy(aserv,"*");
			if( proto[0] == 0 ) strcpy(proto,"*");
			if( dhost[0] == 0 ) strcpy(dhost,"*");
			sprintf(vauthserv,"%s:%s:%s.%s",
				proto,dhost,aserv,AUTH_VDOM);
			scan_PERMIT(Conn,vauthserv);
		}
	}
*/
	scan_CMAP2(Conn,AUTHSERV_MAP,authserv);
}

int AuthenticateY(Connection *Conn,PVStr(host),PCStr(user),PCStr(pass),PCStr(path),AuthInfo *ident);

static int Identify(Connection *Conn,int identonly,FILE *fc,FILE *tc,PCStr(authserv),xPVStr(user),PVStr(host),PVStr(phost),iFUNCP func,AuthInfo *arg)
{	int ci;
	CStr(userhost,1024);
	CStr(pass,256);
	CStr(aproto,64);
	CStr(ahost,256);
	int aport;
	CStr(clhost,256);
	const char *iuser;
	CStr(userb,256);
	UTag Tuserhost,Tpass;

	setQStr(Tuserhost.ut_addr,userhost,sizeof(userhost));
	Tuserhost.ut_size = sizeof(userhost);
	setQStr(Tpass.ut_addr,pass,sizeof(pass));
	Tpass.ut_size = sizeof(pass);

	if( strchr(user,':') ){
		scan_namebody(user,AVStr(userb),128,":",AVStr(pass),128,"\r\n");
		setPStr(user,userb,sizeof(userb));
	}else	pass[0] = 0;

	getpeerNAME(FromC,AVStr(clhost));

	if( wordIsinList(authserv,I_IDENT) )
	if( iuser = getClientHostPortUser(Conn,AVStr(clhost),NULL) ){
		strcpy(user,iuser);
		strcpy(host,clhost);
		strcpy(phost,host);
		goto EXIT;
	}
 if( fc != NULL ){
	if( strcmp(authserv,"&") == 0 )
	fprintf(tc,">>>>>>>> login with your account at <%s>\r\n",clhost);

	fprintf(tc,">>>>>>>> Username: ");
	fflush(tc);
	setVStrEnd(host,0);
	setVStrEnd(user,0);
	setVStrEnd(userhost,0);

	ci = (*func)((void*)1,fc,tc,&Tuserhost,arg);
	if( userhost[0]  == 0 )
		return 0;
	if( ci == EOF )
		return 0;

	scan_namebody(userhost,AVStr(user),128,"@",AVStr(host),128," \t\r\n");
 }
	strcpy(phost,"******");

	if( host[0] ){
		if( wordIsinList(authserv,host) ){ 
			/* authorized */
		}else
		if( wordIsinList(authserv,I_FTP) && hostcmp(host,clhost) == 0 ){
			/* not authorized */
		}else
		if( wordIsinList(authserv,I_ANY) ){
			/* not authorized */
		}else{
			fprintf(tc,"!!!!!!!! %s: not authentiation server\r\n",
				host);
			fflush(tc);
			return 0;
		}
		strcpy(phost,host);
	}else
	if( 1 ){
		int ac,ai;
		CStr(udhost,64);
		CStr(ab,256);
		const char *av[8]; /**/
		const char *a1;
		const char *ao;
		refQStr(ap,host); /**/

		wordScan(host,udhost);
		lineScan(authserv,ab);
		ac = list2vect(ab,',',8,av);
		setVStrEnd(host,0);
		for( ai = 0; ai < ac; ai++ ){
			a1 = ao = av[ai];
			if( streq(a1,I_FTP)   ) ao = clhost; else
			if( streq(a1,I_IDENT) ) ao = clhost; else
			if( streq(a1,I_ANY)   ) ao = udhost;
			if( ao != a1 )
				strcpy(phost,ao);

			if( host[0] == 0 )
				strcpy(ap,ao);
			else	sprintf(ap,",%s",ao);
			ap += strlen(ap);
		}
	}else{
		if( wordIsinList(authserv,I_FTP) ){
			/* authorized */
			strcpy(host,clhost);
			strcpy(phost,host);
		}else{
			/* authorized */
			Xsscanf(authserv,"%[^,]",AVStr(host));
		}
	}
	if( streq(host,I_ANY) ){
		fprintf(tc,"!!!!!!!! enter user@yourAuthHost\r\n");
		fflush(tc);
		return 0;
	}
/*
	if( !identonly && !service_authorized(Conn,user,host) ){
		fprintf(tc,"<<<<<<<< No, <%s@%s> is not an authorized user\r\n",
			user,phost);
		fflush(tc);
		return 0;
	}
*/

if( fc != NULL ){
	fprintf(tc,">>>>>>>> Password: ");
/*
	ci = (*func)(0,fc,tc,pass,arg);
*/
	ci = (*func)((void*)0,fc,tc,&Tpass,arg);
	if( ci == EOF )
		return 0;
	fflush(tc);
}

	/*
	if( Authenticate(Conn,host,user,pass,"/") < 0 ){
	*/
	if( AuthenticateX(Conn,host,user,pass,"/",arg) < 0 ){
		if( user[0] || pass[0] )
		fprintf(tc,
		"!!!!!!!! USER <%s@%s> authentication failed\r\n",user,phost);
		fflush(tc);
		return 0;
	}

EXIT:
	return 1;
}

void setServerCert(Connection *Conn,PCStr(what),PCStr(mbox))
{	AuthInfo ident;
	const char *dp;

	bzero(&ident,sizeof(AuthInfo));
	dp = wordscanY(mbox,AVStr(ident.i_user),sizeof(ident.i_user),"^@");
	if( *dp == '@' )
		wordscanX(dp+1,AVStr(ident.i_Host),sizeof(ident.i_Host));
	sv1log("##[%s] set ServerAuth [%s@%s]\n",what,ident.i_user,ident.i_Host);
	Conn->sv_certauth = ident;
}
void setClientCert(Connection *Conn,PCStr(what),PCStr(mbox))
{	AuthInfo ident;
	const char *dp;

	bzero(&ident,sizeof(AuthInfo));
	dp = wordscanY(mbox,AVStr(ident.i_user),sizeof(ident.i_user),"^@");
	if( *dp == '@' )
		wordscanX(dp+1,AVStr(ident.i_Host),sizeof(ident.i_Host));
	else	ident.i_Host[0] = 0;

	if( dp = strchr(ident.i_Host,':') ){
		truncVStr(dp); dp++;
		ident.i_Port = atoi(dp);
	}else	ident.i_Port = 0;

	/*
	sv1log("##[%s] set ClientAuth [%s@%s]\n",what,ident.i_user,ident.i_Host);
	*/
	sv1log("##[%s] set ClientAuth [%s@%s]:%d\n",what,ident.i_user,
		ident.i_Host,ident.i_Port);
	/*
	Conn->cl_certauth = ident;
	*/
	ClientCert = ident;
}

static
void setClientAuth(Connection *Conn,PCStr(what),PCStr(auser),PCStr(ahost))
{	const char *user;
	CStr(userb,64);
	const char *dp;

	if( strchr(auser,':') ){
		wordscanY(auser,AVStr(userb),sizeof(userb),"^:");
		user = userb;
	}else	user = auser;
	sv1log("##[%s] set ClientAuth [%s@%s]\n",what,user,ahost);

	ClientAuth.i_stat = AUTH_SET;
	/*
	wordScan(auser,ClientAuthUser);
	wordScan(ahost,ClientAuthHost);
	*/
	dp = wordscanY(auser,AVStr(ClientAuthUser),sizeof(ClientAuthUser),"^:");
	if( *dp == ':' )
		wordscanY(dp+1,AVStr(ClientAuthPass),sizeof(ClientAuthPass),"^\r\n");
	else	ClientAuthPass[0] = 0;
	dp = wordscanY(ahost,AVStr(ClientAuthHost),sizeof(ClientAuthHost),"^/");
	if( *dp == '/' )
		ClientAuthPort = atoi(dp+1);
	else
	ClientAuthPort = 0;

	reset_MOUNTconds(); /* reset cond. by FROM */
}
int getClientAuthList(Connection *Conn,int ax,AuthInfo *av[])
{	int ac;

	ac = 0;
	if( ClientAuthUser[0] ){
		av[ac++] = &ClientAuth;
	}
	/*
	if( Conn->cl_certauth.i_user[0] ){
		av[ac++] = &Conn->cl_certauth;
	}
	*/
	if( ClientCert.i_user[0] ){
		av[ac++] = &ClientCert;
	}
	return ac;
}

int service_authorized(Connection *Conn,PCStr(user),PCStr(host))
{	int ok;
	AuthInfo sauth;
	CStr(ahost,256);

	sauth = ClientAuth;
	sprintf(ahost,"%s.%s",host,AUTH_VDOM);
	wordscanX(ahost,AVStr(ClientAuthHost),sizeof(ClientAuthHost));
	wordscanX(user, AVStr(ClientAuthUser),sizeof(ClientAuthUser));

	Conn->auth_check = 1;
	ok = service_permitted2(Conn,DST_PROTO,1);
	Conn->auth_check = 0;

	ClientAuth = sauth;
	return ok;
}

int CTX_auth(Connection *Conn,PCStr(user),PCStr(pass))
{	AuthInfo ident;

	bzero(&ident,sizeof(ident));
	if( user ) wordscanX(user,AVStr(ident.i_user),sizeof(ident.i_user));
	if( pass ) wordscanX(pass,AVStr(ident.i_pass),sizeof(ident.i_pass));
	return doAuth(Conn,&ident);
}
const char *getMountAuthorizer(Connection *Conn,PVStr(authserv),int size)
/*
{	const char *authopt;
*/
{

	if( !IsMounted || MountOptions == 0 )
		return 0;

	if( *MO_Authorizer != 0 )
		goto EXIT;

	getOpt1(MountOptions,"AUTHORIZER",AVStr(MO_Authorizer));
	/*
	if( authopt = strcasestr(MountOptions,"AUTHORIZER=") )
		wordscanY(authopt+11,AVStr(MO_Authorizer),sizeof(MO_Authorizer),"^,");
	}
	*/
	if( *MO_Authorizer == 0 )
		strcpy(MO_Authorizer,"-");

EXIT:
	if( strcmp(MO_Authorizer,"-") == 0 )
		return 0;
	if( authserv )
		wordscanX(MO_Authorizer,AVStr(authserv),size);
	return MO_Authorizer;
}
int withMountAUTHORIZER(Connection *Conn)
{ 
	if( MO_Authorizer[0] && strcmp(MO_Authorizer,"-") != 0 )
		return 1;
	if( getMountAuthorizer(Conn,VStrNULL,0) )
		return 1;
	return 0;
}

int CTX_withAuth(Connection *Conn){
	CStr(authserv,256);
	if( getMountAuthorizer(Conn,AVStr(authserv),sizeof(authserv)) ){
		return 1;
	}else
	if( 0 <= find_CMAP(Conn,AUTHSERV_MAP,AVStr(authserv)) )
		return 2;
	return 0;
}

int doAuth(Connection *Conn,AuthInfo *ident)
{	int rcode;
	CStr(authserv,256);
	CStr(userpass,256);
	const char *dp;

	if( ident->i_stat & AUTH_MAPPED ){
		syslog_ERROR("??? AUTHORIZED ALREADY %X [%s][%s]\n",
			ident->i_stat,ident->i_user,ident->i_Host);
		/* return 1; */
	}

	if( getMountAuthorizer(Conn,AVStr(authserv),sizeof(authserv)) ){
	}else
	if( find_CMAP(Conn,AUTHSERV_MAP,AVStr(authserv)) < 0 )
		return 0;
	sprintf(userpass,"%s:%s",ident->i_user,ident->i_pass);
	/*
	rcode = doAUTH(Conn,NULL,NULLFP(),DST_PROTO,DST_HOST,0,
			AVStr(userpass),ident->i_Host,NULL,NULL);
	*/
	rcode = doAUTH(Conn,NULL,NULLFP(),DST_PROTO,DST_HOST,0,
			AVStr(userpass),AVStr(ident->i_Host),NULL,ident);

	if( rcode == 0 && streq(ident->i_Host,"-none") ){
		sv1log("## -none : emulate no AUTHORIZER\n");
		return 0;
	}
	if( rcode == -1 && streq(ident->i_Host,"-never") ){
		sv1log("## -never: reject regardless of AUTHORIZER\n");
		return -1;
	}

	if( dp = strchr(ident->i_Host,'/') ){
		/* set by AUTHORIZER=host/port */
		truncVStr(dp);
		ident->i_Port = atoi(dp+1);
	}

	if( rcode != 0 ){
		if( ident->i_error == 0 )
			ident->i_error = AUTH_EBADPASS;
	}
	if( ident->i_stat & AUTH_MAPPED ){
		setClientAuth(Conn,"doAuth-MAPPED",ident->i_user,"");
		ClientAuth.i_stat |= AUTH_MAPPED;
	}

	if( strcmp(userpass,":") != 0 )
	sv1log("AUTHORIZER=%s host=[%s] user=[%s] -> %s\n",
		authserv,ident->i_Host,ident->i_user,rcode==0?"OK":"NO");
	if( rcode == 0 )
		return 1;
	else	return -1;
}
int doAUTH(Connection *Conn,FILE *fc,FILE *tc,PCStr(dstproto),PCStr(dsthost),int dstport,PVStr(auser),PVStr(ahost),iFUNCP func,AuthInfo *arg)
{	int da;
	Port dflt;

	dflt = Conn->sv_dflt;
	da = doAUTH0(Conn,fc,tc,dstproto,dsthost,dstport,AVStr(auser),AVStr(ahost),func,arg);
	Conn->sv_dflt = dflt;
	return da;
}
int doAUTH0(Connection *Conn,FILE *fc,FILE *tc,PCStr(dstproto),PCStr(dsthost),int dstport,PVStr(auser),PVStr(ahost),iFUNCP func,AuthInfo *arg)
{	CStr(authserv,1024);
	CStr(phost,256);
	int identonly;
	int authorized;

/*
	if( ClientAuthUser[0] != 0 )
	if( source_permitted(Conn) )
*/
	if( streq(DST_PROTO,dstproto) )
	if( streq(DST_HOST,dsthost) )
	if( DST_PORT == dstport )
	{
		sv1log("#### already authorized\n");
		return 0;
	}
	set_SERVER(Conn,dstproto,dsthost,dstport);

	if( getMountAuthorizer(Conn,AVStr(authserv),sizeof(authserv)) ){
		identonly = 0;
	}else
	if( 0 <= find_CMAP(Conn,IDENTIFY_MAP,AVStr(authserv)) ){
		identonly = 1;
	}else
	if( 0 <= find_CMAP(Conn,AUTHSERV_MAP,AVStr(authserv)) ){
		identonly = 0;
	}else{
		sv1log("#### no authorization required\n");
		return 0;
	}

	fprintf(tc,
		"<<<<<<<< Authorization for this proxy required.\r\n");

	for(;;){
		if( Identify(Conn,identonly,fc,tc,authserv,AVStr(auser),AVStr(ahost),AVStr(phost),func,arg) )
			break;
		if( auser[0] == 0 )
			return EOF;
		if( fc == NULL )
			return EOF;
	}

	if( identonly ){
		fprintf(tc,
		"<<<<<<<< Ok, You are identified as <%s@%s>\r\n",auser,phost);
		authorized = service_authorized(Conn,auser,ahost);
	}else	authorized = 1;

	if( authorized ){
		fprintf(tc,
		"<<<<<<<< Ok, you <%s@%s> are an authorized user :-)\r\n",
			auser,phost);

		setClientAuth(Conn,"doAUTH",auser,ahost);
		return 0;
	}else{
		fprintf(tc,
		"!!!!!!!! USER <%s@%s> not permitted by DeleGate.\r\n",
			auser,phost);
		fflush(tc);
		return EOF;
	}
}

static int connect_auth(Connection *OrigConn,PCStr(proto),PCStr(host),int port,PCStr(user),PCStr(pass),PCStr(path),FILE *svfp[])
{	int svsock,io[2];
	Connection ConnBuf,*Conn = &ConnBuf;
	const char *dp;
	CStr(hostb,256);
	int xport;

	if( strchr(host,'/') ){
		wordScan(host,hostb);
		dp = strchr(hostb,'/');
		truncVStr(dp); dp++;
		if( 0 < (xport = atoi(dp)) ){
			sv1log("Authorizer: ftp://%s:%d -> xxx://%s:%d\n",
				host,port,hostb,xport);
			host = hostb;
			port = xport;
		}
	}

	if( CTX_auth_cache(OrigConn,0,180,proto,user,pass,host,port) )
		return 1;

	if( host[0] == '-' ){
		/* virtual auth host */
		return -1;
	}

	ConnInit(Conn);
	Conn->from_myself = 1;
	Conn->co_mask |= CONN_NOPROXY;

	set_realserver(Conn,proto,host,port);
	Socketpair(io);

	svsock = connect_to_servX(Conn,io[0],io[1],0,0);
	close(io[0]);
	close(io[1]);
	if( svsock < 0 ){
		sv1tlog("cannot connect: %s://%s@%s/\n",proto,user,host);
		return -1;
	}

	svfp[0] = fdopen(svsock,"r");
	svfp[1] = fdopen(svsock,"w");
	return 0;
}

int authenticate_by_FTP(Connection *Conn,PVStr(host),PCStr(user),PCStr(pass),PCStr(path))
{	FILE *svfp[2];
	CStr(resp,1024);
	int rcode;

	if( rcode = connect_auth(Conn,"ftp", host,21,user,pass,path,svfp) )
		return rcode;

	rcode = ftp_auth(svfp[1],svfp[0],AVStr(resp),sizeof(resp),user,pass);
	fclose(svfp[0]);
	fclose(svfp[1]);

	if( rcode == EOF )
		return -1;
	else{
		CTX_auth_cache(Conn,1,180,"ftp",user,pass,host,21);
		return 0;
	}
}

/*
 * -auth.passwd.host.pam/port
 * -auth.passwd.pam = auth.passwd.-.pam/0
 * -passwd.pam
 * -.pam
 *
 * -pam//host..port/passwd.auth
 * -pam//host/passwd.auth
 * -pam/passwd.auth = -pam///passwd.auth = -pam//-..0/passwd.auth
 * -pam/passwd
 * -pam
*
 * => auth.passwd.host.pam:port
 *
 * -pam.host/port.passwd.auth
 * -pam.passwd
 */

extern int START_TIME;
extern const char *PAMbaseurl;
extern const char *PAMurl;
int PAMport;
void scan_PAMCONF(Connection *Conn,PCStr(conf))
{	CStr(name,64);
	CStr(value,64);

	scan_field1(conf,AVStr(name),sizeof(name),AVStr(value),sizeof(value));
	if( streq(name,"baseurl") )
		PAMbaseurl = stralloc(value);
	else
	if( streq(name,"url") )
		PAMurl = stralloc(value);
	else
	if( streq(name,"port") )
		PAMport = atoi(value);
}

int authenticate_by_PAM(Connection *Conn,xPVStr(host),PCStr(user),PCStr(pass),PCStr(path))
{	int rcode;
	CStr(servb,128);
	CStr(svhost,128);
	CStr(svdom,128);
	const char *dp;
	int svport;
	int expire;
	Connection *appConn = Conn;

	if( *host == '-' )
		host++;

	svhost[0] = 0;
	svport = 0;
	servb[0] = 0;

	if( strncmp(host,"pam/",4) == 0 ){
		if( host[4]=='/' ){
			dp = wordscanY(host+5,AVStr(svhost),sizeof(svhost),"^/");
			if( *dp == '/' ){
				wordScan(dp+1,servb);
			}
			if( dp = strstr(svhost,"..") ){
				truncVStr(dp);
				svport = atoi(dp+2);
			}else	svport = serviceport("pam");
		}else{
			wordScan(host+4,servb);
		}
	}else
	if( strtailstr(host,".pam") ){
		wordScan(host,servb);
		*strtailstr(servb,".pam") = 0;
	}
	if( servb[0] == 0 )
		strcpy(servb,"passwd");
	if( svhost[0] == 0 )
		strcpy(svhost,"-");

	sprintf(svdom,"%s.%s.pam",servb,svhost);
	/* rewrite "host" as "what.service.host.pam" */
	if( svport )
		sprintf(host,"%s/%d",svdom,svport);
	else	strcpy(host,svdom);

/* don't use cache for PAM */
/* if(0) */
{
	expire = time(0) - START_TIME;
	if( 180 < expire )
		expire = 180;

	if( CTX_auth_cache(Conn,0,expire,"pam",user,pass,svdom,svport) )
		return 1;
}

	/* Conn might be rewritten if remote PAM-server is used */
	{
		Connection ConnBuf, *Conn = &ConnBuf;
		*Conn = *appConn;
		Conn->no_dstcheck = 1;
		ToS = ToSX = FromS = FromSX = -1;

		rcode = pam_checkPasswd(Conn,svhost,svport,servb,user,pass);

		if( 0 <= ToS ){
			Verbose("## ToS=%d ToSX=%d\n",ToS,ToSX);
			close(ToS);
			if( 0 <= ToSX ) close(ToSX);
		}
		if( 0 <= FromS ){
			Verbose("## FromS=%d FromSX=%d\n",FromS,FromSX);
			if( FromS != ToS ) close(FromS);
			if( 0 <= FromSX ) close(FromSX);
		}
	}

	if( 0 < rcode ){
		CTX_auth_cache(Conn,1,180,"pam",user,pass,svdom,svport);
		return 0;
	}
	return -1;
}
int service_pam(Connection *Conn)
{	int forbidden,stcode;
	CStr(request,128);
	CStr(user,128);
	CStr(clhost,128);

	dup2(FromC,0);
	dup2(ToC,1);
	forbidden = !source_permitted(Conn);
	pam_service(Conn,forbidden,AVStr(request),AVStr(user),&stcode);

	getClientHostPort(Conn,AVStr(clhost));
	if( user[0] == 0 )
		strcpy(user,"-");
	sv1log("## PAM/HTTP: %s - %s \"%s\" %d\n",clhost,user,request,stcode);
	/* should output HTTP compatible log */
	return 0;
}

static int authenticate_by_Digest(Connection *Conn,PVStr(domain),PCStr(user),PCStr(dpass),PCStr(path),AuthInfo *ident)
{	CStr(dom,128);
	CStr(serv,128);
	int port;

	if( ident == 0 || *ident->i_atyp == 0 )
		return -1;
	if( strcasecmp(ident->i_atyp,"Digest") != 0 ){
		sv1log("Unexpected Auth.type[%s] for Digest\n",ident->i_atyp);
		return -1;
	}

	wordScan(domain,dom);
	if( port = scanAuthServPort(dom,AVStr(serv)) ){
		/* return "-dgauth[.realm]" stripped "//host..port" off */
		strcpy(domain,dom);
	}

	return HTTP_authorize_Digest(Conn,ident,dom,user,dpass,AVStr(serv),port);
}

extern const char *HTTP_AUTHBASE;

int authenticate_by_HTTP(Connection *Conn,PVStr(host),PCStr(user),PCStr(pass),PCStr(path))
{	FILE *svfp[2];
	int rcode;
	CStr(buff,1024);
	CStr(authBASIC,1024);
	CStr(authMD5,1024);
	CStr(resp,1024);
	const char *dp;
	CStr(me,256);
	int scode;
	CStr(authpath,1024);

	sprintf(buff,"%s:%s",user,pass);
	toMD5(buff,authMD5);
	str_to64(buff,strlen(buff),AVStr(authBASIC),sizeof(authBASIC),1);
	if( dp = strpbrk(authBASIC,"\r\n") )
		truncVStr(dp);
	ClientIF_name(Conn,ClientSock,AVStr(me));

	if( rcode = connect_auth(Conn,"http",host,80,user,pass,path,svfp) )
		return rcode;
sprintf(authpath,"%s/%s/%s",HTTP_AUTHBASE,me,authMD5);
	fprintf(svfp[1],"HEAD %s HTTP/1.0\r\n",authpath);
	fprintf(svfp[1],"\r\n");
	fflush(svfp[1]);
	sv1log("HTTP-AUTH << path=%s user=%s\n",authpath,user);
	rcode = -1;
	if( fgets(resp,sizeof(resp),svfp[0]) != NULL ){
		sv1log("HTTP-AUTH >> %s",resp);
		if( sscanf(resp,"HTTP/%*s %d",&scode) )
			if( scode == 200 ){
				rcode = 0;
				goto EXIT;
			}
	}

	fclose(svfp[0]);
	fclose(svfp[1]);
	if( rcode = connect_auth(Conn,"http",host,80,user,pass,path,svfp) )
		return rcode;

sprintf(authpath,"%s/%s/%s",HTTP_AUTHBASE,me,user);
	fprintf(svfp[1],"HEAD %s HTTP/1.0\r\n",authpath);
	fprintf(svfp[1],"Authorization: Basic %s\r\n",authBASIC);
	fprintf(svfp[1],"\r\n");
	fflush(svfp[1]);
	sv1log("HTTP-AUTH << path=%s user=%s\n",authpath,user);
	rcode = -1;
	if( fgets(resp,sizeof(resp),svfp[0]) != NULL ){
		sv1log("HTTP-AUTH >> %s",resp);
		if( sscanf(resp,"HTTP/%*s %d",&scode) )
			if( scode == 200 ){
				rcode = 0;
				goto EXIT;
			}
	}

EXIT:
	fclose(svfp[0]);
	fclose(svfp[1]);
	return rcode;
}

typedef struct {
  const	char	*a_name;
	iFUNCP	a_func;
} AuthServ;
static AuthServ authenticators[] = {
	{"PAM", (iFUNCP)authenticate_by_PAM	},
	{"FTP",  (iFUNCP)authenticate_by_FTP	},
	/*{"HTTP", (iFUNCP)authenticate_by_HTTP	},*/
	/*{"RADIUS", (iFUNCP)authenticate_by_RADIUS },*/
	0
};

int Authenticate(Connection *Conn,PCStr(host),PCStr(user),PCStr(pass),PCStr(path))
{
	return AuthenticateX(Conn,host,user,pass,path,NULL);
}
int AuthenticateX(Connection *Conn,PCStr(host),PCStr(user),PCStr(pass),PCStr(path),AuthInfo *ident)
{	CStr(servs,1024);
	const char *sv[8]; /**/
	int sc,si,rcode;
	const char *realm;
	CStr(dom,128);
	const char *dp;
	CStr(serv,512);
	const char *muser;

	lineScan(host,servs);
	if( dp = strchr(servs,'{') ){ /* treat -list{user@host:pass} */
		if( dp = strchr(dp+1,'}') ){
			if( realm = strchr(dp+1,'@') ){
				truncVStr(realm); realm++;
			}
		}
	}else
	if( realm = strchr(servs,'@') ){
		truncVStr(realm); realm++;
	}
	sc = list2vect(servs,',',8,(const char**)sv);
	muser = 0;
	for( si = 0; si < sc; si++ ){
		muser = 0;
		if( strtailchr(sv[si]) == ')' ){
			if( dp = strrchr(sv[si],'(') ){
				strcpy(serv,sv[si]);
				muser = strrchr(serv,'(');
				truncVStr(muser);
				muser++;
				sv[si] = serv;
			}
		}
		if( realm && strneq(sv[si],DGAUTHdom,7) ){
			sprintf(dom,"%s@%s",sv[si],realm);
			rcode = AuthenticateY(Conn,AVStr(dom),user,pass,path,ident);
		}else
		rcode = AuthenticateY(Conn,QVStr((char*)sv[si],servs),user,pass,path,ident);
		if( 0 <= rcode )
		{
			if( ident && muser ){
				QStrncpy(ident->i_user,muser,strlen(muser));
				ident->i_stat |=  AUTH_MAPPED;
			}
			return rcode;
		}
	}
	if( ident && realm ){
		linescanX(realm,AVStr(ident->i_realm),sizeof(ident->i_realm));
	}
	return -1;
}
static int authenticate_by_list(Connection *Conn,PCStr(list),PCStr(user),PCStr(pass),PCStr(path),AuthInfo *ident)
{	CStr(up,256);
	CStr(xlist,1024);

	sprintf(up,"%s:%s",user,pass);
	strfConnX(Conn,list,AVStr(xlist),sizeof(xlist));
	list = xlist;
	if( isinList(list,up) )
		return 1;
	else	return -1;
}
int AuthenticateY(Connection *Conn,PVStr(host),PCStr(user),PCStr(pass),PCStr(path),AuthInfo *ident)
{	int rcode;
	int ai;
	iFUNCP afunc;
	iFUNCP xfunc;

	rcode = -1;
	if( streq(host,"-none") ){
		sv1log("## Auth/none = 0 <%s:%s>\n",user,*pass?"****":"");
		return 0;
	}
	if( streq(host,"-never") ){
		sv1log("## Auth/never = -1 <%s:%s>\n",user,*pass?"****":"");
		return -1;
	}
	if( streq(host,"-any") ){
		sv1log("## Auth/any = 0 <%s:%s>\n",user,*pass?"****":"");
		return 0;
	}
	if( streq(host,"-anonftp") ){
		if( is_anonymous(user) ){
			if( strchr(pass,'@') )
				rcode = 0;
		}
		sv1log("## Auth/anonftp = %d <%s:%s>\n",rcode,user,pass);
		return rcode;
	}
	if( streq(host,"-smtp-vrfy") ){
		if( validateEmailAddr(pass,0) == 0 ){
			return 1;
		}
		return -1;
	}
	if( streq(host,"-ident") ){
	}
	if( strneq(host,DGAUTHdom,7) ){
		rcode = authenticate_by_Digest(Conn,AVStr(host),user,pass,path,ident);
		return rcode;
	}
	if( strneq(host,"-passwd/",8) ){
		/* /etc/passwd format */
	}
	if( strneq(host,"-list{",6) ){
		/* followed by a list of {user:pass} */
		rcode = authenticate_by_list(Conn,host+5,user,pass,path,ident);
		return rcode;
	}
	if( strneq(host,"-exec/",6) ){
		/* execute specified program which get environment var.
		 * USER and PASS then outputs "0" or "1"
		 */
	}
	if( strneq(host,"-hash/",6) ){
		/*
		 * pass == MD5(key:user)
		 */
	}

	xfunc = 0;
	if( *host == '-' )
	if( streq(host,"-pam")||strneq(host,"-pam/",4)||strtailstr(host,".pam"))
		xfunc = (iFUNCP)authenticate_by_PAM;

	rcode = -1;
	for( ai = 0; afunc = authenticators[ai].a_func; ai++ ){
		if( xfunc != 0 && xfunc != afunc )
			continue;
		if( afunc == (iFUNCP)authenticate_by_PAM ){
			if( xfunc != (iFUNCP)authenticate_by_PAM )
				continue;
		}
		if( *user == 0 && *pass == 0 )
			continue;
		rcode = (*afunc)(Conn,BVStr(host),user,pass,path);
		/*
		sv1log("## Auth/%s = %d\n",authenticators[ai].a_name,rcode);
		*/
		sv1log("## Auth/%s = %d <%s:%s@%s>\n",
			authenticators[ai].a_name,
			/*
			rcode,user,*pass?"****":"",host);
			*/
			rcode,user,streq(user,"guest")?pass:(*pass?"****":""),host);
		if( 0 <= rcode )
			return rcode;
	}
	return rcode;
}

int CTX_preset_loginX(Connection *Conn,PCStr(method),PVStr(vurl),AuthInfo *ident,PVStr(path))
{	CStr(proto,128);
	CStr(site,1024);
	CStr(pb,1024);

	if( CTX_mount_url_to(Conn,NULL,method,AVStr(vurl)) ){
		decomp_absurl(vurl,AVStr(proto),AVStr(site),AVStr(pb),sizeof(pb));
		if( strchr(site,'@') ){
			/* with USER:PASS@SERVER */
			if( ident ) decomp_siteX("ftp",site,ident);
			if( path ) strcpy(path,pb);
			return 1;
		}
	}
	return 0;
}

int unescape_user_at_host(PVStr(email))
{	const char *dp;

	if( strchr(email,'@') == 0 )
	if( dp = strrpbrk(email,"%") ){
		*(char*)dp = '@';
		return 1;
	}
	return 0;
}

void CTX_pushClientInfo(Connection *Conn)
{	VAddr sockhost;

	if( ClientSock < 0 ){
		bzero(&sockhost,sizeof(sockhost));
		/* maybe in UDP, thus it should be given in another way...
		 * as ClientIF_VAddr for example similarly to Client_VAddr.
		 */
	}else
	VA_HostPortIFclnt(Conn,ClientSock,VStrNULL,VStrNULL,&sockhost);
	/*
	VA_HL_pushClientInfo(Time(),Client_VAddr,&sockhost);
	*/
	VA_HL_pushClientInfo(Time(),Client_VAddr,&sockhost /*,&ClientAuth,&ClientCert*/);
}

/*
 * MYAUTH=username:password[:proto[:dst[:src]]]
 * generating my (DeleGate's) authorization as a client of server/proxy
 */
void scan_MYAUTH(Connection *Conn,PCStr(myauth))
{	CStr(myauthx,256);
	CStr(user,256);
	CStr(pass,256);
	CStr(proto,256);
	CStr(dst,256);
	CStr(src,256);

	user[0] = pass[0] = 0;
	strcpy(proto,"*");
	strcpy(dst,"*");
	strcpy(src,"*");
	scan_Listlist(myauth,':',AVStr(user),AVStr(pass),AVStr(proto),AVStr(dst),AVStr(src));
	InitLog("MYAUTH=%s:****:%s:%s:%s\n",user,proto,dst,src);
	sprintf(myauthx,"{%s:%s}:%s:%s:%s",user,pass,proto,dst,src);
	scan_CMAP2(Conn,"MyAuth",myauthx);
}
void getREALPort(Connection *Conn,Port *dst);
void setREALPort(Connection *Conn,Port *src);
void setREALPortl(Connection *Conn,PCStr(proto),PCStr(host),int port);
int get_MYAUTH(Connection *Conn,PVStr(myauth),PCStr(proto),PCStr(dhost),int dport)
{	CStr(xproto,256);
	CStr(xhost,256);
	CStr(user,256);
	Port sv;
	int xport;
	int mx;

	if( proto ){
		getREALPort(Conn,&sv);
		setREALPortl(Conn,proto,dhost,dport);
	}

	if( 0 <= (mx = find_CMAP(Conn,"MyAuth",AVStr(myauth))) ){
		nonxalpha_unescape(myauth,AVStr(myauth),1);
		wordscanY(myauth,AVStr(user),sizeof(user),"^:");
		sv1log("MYAUTH=%s:**** for %s:%s:%d\n",user,
			REAL_PROTO,REAL_HOST,REAL_PORT);
	}

	if( proto )
		setREALPort(Conn,&sv);
	return 0 <= mx;
}

void cpyPort(Port *dst,Port *src)
{
	strcpy(dst->p_proto,src->p_proto);
	strcpy(dst->p_host, src->p_host);
	dst->p_port = src->p_port;
}
void getREALPort(Connection *Conn,Port *dst)
{
	cpyPort(dst,&Conn->sv);
}
void setREALPort(Connection *Conn,Port *src)
{
	cpyPort(&Conn->sv,src);
}
void setPort(Port *dst,PCStr(proto),PCStr(host),int port)
{
	wordscanX(proto,AVStr(dst->p_proto),sizeof(dst->p_proto));
	wordscanX(host, AVStr(dst->p_host), sizeof(dst->p_host));
	dst->p_port = port;
}
void setREALPortl(Connection *Conn,PCStr(proto),PCStr(host),int port)
{
	setPort(&Conn->sv,proto,host,port);
}
