/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1996-1999 Yutaka Sato
Copyright (c) 1996-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	htmlgen.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	960126	extracted from httpd.c
//////////////////////////////////////////////////////////////////////#*/
#include <ctype.h>
#include "delegate.h"
#include "ystring.h"
#include "file.h"
#include "url.h"

int HTTP_originalURLx(Connection *Conn,PVStr(url),int siz);
void HTTP_redirect_HTML0(Connection *Conn,PCStr(proto),PCStr(host),int port,PCStr(req),PCStr(src),PVStr(dst));
int putDeleGateInline(Connection *Conn,FILE *tc,PCStr(align));
int putFrogVer(Connection *Conn,FILE *tc);
void DHTML_printNoRobots(Connection *Conn,FILE *fp,PCStr(fmt),PCStr(name),PCStr(arg),PCStr(value));
int DHTML_printMount(Connection *Conn,FILE *fp,PCStr(fmt),PCStr(name),PCStr(param));
int DHTML_printAuth(Connection *Conn,FILE *fp,PCStr(fmt),PCStr(name),PCStr(arg),const void *value);
int DHTML_printAdmin(Connection *Conn,FILE *fp,PCStr(fmt),PCStr(name),PCStr(param));
int DHTML_pringGenAuth(Connection *Conn,FILE *fp,PCStr(fmt),PCStr(name),PCStr(arg),PCStr(value));
void HTTP_fprintmsg(Connection *Conn,FILE *fp,PCStr(fmt));
const char *start_time();

static const char *home_page = "/-/";

static const char *msg_not_found = "\
<TITLE> Builtin Message %s Not Found </TITLE>\n\
Builtin message %s not found.\n\
";

typedef struct {
	int	 when;
  const	char	*url;
  const	char	*rurl;
	int	 size;
	int	 time;
	char	 data[1];
} Cache;

#define NUMCACHE	128
typedef struct {
	Cache  *he_caches[NUMCACHE]; /**/
	int	he_cachex;
} HtmlGenEnv;
static HtmlGenEnv *htmlGenEnv;
#define caches	htmlGenEnv->he_caches
#define cachex	htmlGenEnv->he_cachex
void minit_htmlgen()
{
	if( htmlGenEnv == 0 ){
		htmlGenEnv = NewStruct(HtmlGenEnv);
	}
}

static int putCache(PCStr(url),PCStr(rurl),PCStr(data),int size)
{	Cache *cp,*ocp;
	int cx;

	minit_htmlgen();

	if( elnumof(caches) <= cachex )
		return -1;

	cp = (Cache*)malloc(sizeof(Cache)+size-1);
	cp->when = MySeqNum();
	cp->url = stralloc(url);
	cp->rurl = stralloc(rurl);
	cp->size = size;
	cp->time = time(0);
	bcopy(data,cp->data,size);

	for( cx = 0; cx < cachex; cx++ ){
	    ocp = caches[cx];
	    if( streq(url,ocp->url) ){
		free((char*)ocp->url);
		free((char*)ocp->rurl);
		free(ocp);
		break;
	    }
	}
	caches[cx] = cp;
	if( cx == cachex )
		cachex++;
	else	sv1log("####[%d][reloaded] %s\n",cx,url);
	return cx;
}
static int getCache(PCStr(url),PVStr(rurl),char data[],int size,int reload)
{	int cx,rcc;
	Cache *cp;

	minit_htmlgen();

	for( cx = 0; cx < cachex; cx++ ){
	    cp = caches[cx];
	    if( streq(url,cp->url) || streq(url,cp->rurl) ){
		if( reload && cp->when != MySeqNum() ){
			sv1log("####[%d][to be reloaded] %s\n",cx,url);
			break;
		}
		if( size < cp->size )
			rcc = size;
		else	rcc = cp->size;
		strcpy(rurl,cp->rurl);
		bcopy(cp->data,data,rcc);
		return rcc;
	    }
	}
	return -1;
}
int getBuiltinData(Connection *Conn,PCStr(what),PCStr(aurl),PVStr(buf),int size,PVStr(rurl))
{	int rcc;
	FILE *mfp;
	CStr(murl,1024);
	const char *iurl;
	const char *data;

	if( 0 <= (rcc = getCache(aurl,AVStr(rurl),(char*)buf,size,DontReadCache)) ){
		Verbose("####[reuse] %s\n",rurl);
		setVStrEnd(buf,rcc);
		return rcc;
	}

	setVStrEnd(rurl,0);
	strcpy(murl,aurl);
	CTX_mount_url_to(Conn,NULL,"GET",AVStr(murl));

	if( strstr(murl,"://") != NULL ){
		mfp = (FILE*)TMPFILE("MountedBuiltinData");
		CTX_URLget(Conn,0,murl,0,mfp);
		alertVStr(buf,size);
		rcc = fread((char*)buf,1,size,mfp);
		fclose(mfp);
		sv1log("%s (%d bytes) MOUNTED: %s\n",what,rcc,murl);
		if( 0 < rcc ){
			sv1log("####[loaded] %s\n",murl);
			putCache(aurl,murl,buf,rcc);
			setVStrEnd(buf,rcc);
			strcpy(rurl,murl);
			return rcc;
		}
	}

	rcc = 0;
	if( strncmp(aurl,home_page,strlen(home_page)) == 0 ){
		iurl = aurl+strlen(home_page);
		if( data = getMssg(iurl,&rcc) ){
			Verbose("####[builtin] %s\n",aurl);
			Bcopy(data,buf,rcc);
			setVStrEnd(buf,rcc);
			putCache(aurl,aurl,buf,rcc);
		}
	}
	return rcc;
}

int eval_DHTML(Connection *Conn,PCStr(curl),FILE *outfp,PCStr(str),iFUNCP func,const void *farg,int *exitlevp);
int putBuiltinHTML(Connection *Conn,FILE *tc,PCStr(what),PCStr(purl),PCStr(desc),iFUNCP func,const void *arg)
{	int leng;
	CStr(buf1,0x8000);
	const char *buf;
	defQStr(buf2); /*alloc*/
	CStr(murl,256);
	const char *curl;
	CStr(curlb,1024);
	int exitlev;
	const void *xarg;
setQStr(buf2,NULL,0);

	if( purl[0] == '/' || strstr(purl,"://") != 0 )
		curl = purl;
	else{
		sprintf(curlb,"%s%s%s",home_page,"builtin/mssgs/",purl);
		curl = curlb;
	}

	murl[0] = 0;
	leng = getBuiltinData(Conn,what,curl,AVStr(buf1),sizeof(buf1),AVStr(murl));
	if( leng == 0 ){
		if( desc == NULL )
			return 0;
		sprintf(buf1,msg_not_found,purl,purl);
		leng = strlen(buf1);
	}

	if( murl[0] && strcmp(murl,curl) != 0 && desc != NULL ){
		CStr(proto,64);
		CStr(server,256);
		int port;
		CStr(req,256);
		int dont_REWRITE;
		UrlX vb;
		defQStr(bp); /*alloc*//**/

/*
		buf2 = (char*)malloc(sizeof(buf1));
*/
setQStr(buf2,(char*)malloc(sizeof(buf1)),sizeof(buf1));
		cpyQStr(bp,buf2);
		proto[0] = server[0] = 0;
		port = 0;
		Xsscanf(murl,"%[^:]://%[^:/]:%d",AVStr(proto),AVStr(server),&port);
		strcpy(req,"GET ");
		linescanX(murl,TVStr(req),sizeof(req)-strlen(req));

/*
sv1log("##### clear DONT_REWRITE:%d %s\n",DONT_REWRITE,murl);
DONT_REWRITE = 0;

must virtualize the URL of message itself and URLs contained in it
regardless of "DONT_REWRITE" (== true if working as a proxy)
*/
		if( dont_REWRITE = DONT_REWRITE ){
			CStr(base,128);
			DONT_REWRITE = 0;
			vb = Conn->my_vbase;
			sprintf(base,"%s://-.-",CLNT_PROTO);
			set_BASEURL(Conn,base);
		}
		setToInternal(); /* use Host: as BASEURL */
		redirect_url(Conn,murl,AVStr(murl));

		bp = Sprintf(AVStr(bp),"<HEAD><BASE HREF=\"%s\"></HEAD>\n",murl);
		bp = Sprintf(AVStr(bp),"%s<HR>\n",desc);
		bp = Sprintf(AVStr(bp),"<!-- begin redirected %s -->\n\n",what);
		HTTP_redirect_HTML0(Conn,proto,server,port,req,buf1,AVStr(bp));
		bp += strlen(bp);
		bp = Sprintf(AVStr(bp),"\n<!-- end redirected %s -->\n",what);

		if( DONT_REWRITE = dont_REWRITE ){
			Conn->my_vbase = vb;
		}
		buf = buf2;
	}else	buf = buf1;

	if( murl[0] )
		curl = murl;
	exitlev = 0;

	if( func == NULL ){
		func = (iFUNCP)DHTML_printConn;
		/*
		arg = NULL;
		 arg might be omitted (not allocated on the stack)
		 when func==NULL
		*/
		xarg = NULL;
	}
	else	xarg = arg;

	/*
	leng = eval_DHTML(Conn,curl,tc,buf,func,arg,&exitlev);
	*/
	leng = eval_DHTML(Conn,curl,tc,buf,func,xarg,&exitlev);
	if( buf2 != 0 ){
		free((char*)buf2);
	}
	return leng;
}

static int ENCODE_ENT1;
int HTML_put1s(FILE *fp,PCStr(fmt),PCStr(val));
#define put1s	HTML_put1s

static int put_host(Connection *Conn,FILE *fp,PCStr(what)){
	CStr(host,256);

	if( streq(what,"W=MYSELF") ) gethostName(ClientSock,AVStr(host),PN_HOST); else
	if( streq(what,"W=CLIENT") ) getpeerName(ClientSock,AVStr(host),PN_HOST); else
	if( streq(what,"W=SERVER") ) sprintf(host,"%s",DST_HOST); else
		return -1;

	put1s(fp,"%s",host);
	return strlen(host);
}
static int put_hostport(Connection *Conn,FILE *fp,PCStr(what)){
	CStr(hp,512);

	if( streq(what,"W=MYSELF") )gethostName(ClientSock,AVStr(hp),PN_HOSTPORT); else
	if( streq(what,"W=CLIENT") )getpeerName(ClientSock,AVStr(hp),PN_HOSTPORT); else
	if( streq(what,"W=SERVER") ){
		if( REAL_HOST[0] )
			sprintf(hp,"%s:%d",REAL_HOST,REAL_PORT);
		else	sprintf(hp,"%s:%d",DFLT_HOST,DFLT_PORT);
	}
	else return -1;

	put1s(fp,"%s",hp);
	return strlen(hp);
}
static int put_protocol(Connection *Conn,FILE *fp,PCStr(what)){
	const char *proto;
	if( streq(what,"W=CLIENT") ) proto = "http"; else
	if( streq(what,"W=SERVER") ){
		if( REAL_PROTO[0] )
			proto = REAL_PROTO;
		else	proto = DFLT_PROTO;
	}
	else return -1;

	put1s(fp,"%s",proto);
	return strlen(proto);
}
static int put_logomark(Connection *Conn,FILE *fp,PCStr(align)){
	if( strncasecmp(align,"A=",2) == 0 )
		align += 2;
	else	align = "BOTTOM";
	return putDeleGateInline(Conn,fp,align);
}
static int put_frog_ver(Connection *Conn,FILE *fp,PCStr(form)){
	return putFrogVer(Conn,fp);
}
int put_manager(Connection *Conn,FILE *fp,PCStr(arg)){
	fputs(DELEGATE_ADMIN,fp);
	return strlen(DELEGATE_ADMIN);
}
static int put_icon(Connection *Conn,FILE *fp,PCStr(icon)){
	fprintf(fp,"<IMG SRC=%s>",icon);
	return 0;
}

typedef struct {
  const	char	*tag;
	int	(*dt_func)(Connection *Conn,FILE *fp,PCStr(arg));
} DTag;
static DTag dhtml_tags[] = {
	{"T=LOGOMARK",	put_logomark},
	{"T=FROG_VER",	put_frog_ver},
	{"T=HOSTPORT",	put_hostport},
	{"T=HOST",	put_host},
	{"T=PROTOCOL",	put_protocol},
	{"T=ADMIN",	put_manager},
	{"T=MANAGER",	put_manager},
	{"T=ICON",	put_icon},
	0
};

static const char *scanitem(PCStr(str))
{	const char *sp;
	int lev;

	lev = 1;
	for( sp = str; *sp; sp++ ){
		if( *sp == '{' )
			lev++;
		else
		if( *sp == '}' ){
			if( --lev == 0 )
				return sp;
		}
	}
	return NULL;
}

#define RESERVED_CH(c) (c=='$'||c=='{'||c=='?'||c==':'||c=='}'||c=='"'||c=='\\')

static const char *scanchr(PCStr(str),int chr,PVStr(dstr))
{	const char *sp;
	char ch;
	char nch;
	int lev;
	int lit;
	refQStr(dp,dstr); /**/

	setVStrEnd(dstr,0);
	lev = 0;
	lit = 0;
	for( sp = str; ch = *sp; sp++ ){
		assertVStr(dstr,dp+1);
		if( ch == '"' && lit == 0 ){
			lit = 1;
		}else
		if( ch == '"' && lit == 1 ){
			lit = 0;
		}else
		if( ch == '{' )
			lev++;
		else
		if( ch == '}' )
			lev--;

		if( lit == 0 )
		if( ch == '\\' && (nch = sp[1]) && RESERVED_CH(nch) ){
		}else
		if( lev < 0 || lev == 0 && ch == chr ){
			setVStrEnd(dp,0);
			return sp + 1;
		}

		setVStrPtrInc(dp,ch);
	}
	setVStrEnd(dp,0);
	return NULL;
}

static void scanatom(PCStr(itemexp),PVStr(name),PVStr(param))
{	const char *p;

	setVStrEnd(param,0);
	setVStrEnd(name,0);
	if( p = scanchr(itemexp,':',AVStr(name)) )
		scanchr(p,'\0',AVStr(param));
}

int HTML_put1s(FILE *fp,PCStr(fmt),PCStr(val))
{	CStr(buf,4096);

	dumpstacksize("HTML_put1s","%s",fmt);
	if( fp != NULL ){
		if( ENCODE_ENT1 ){
			encodeEntitiesX(val,AVStr(buf),sizeof(buf));
			val = buf;
		}
		if( fmt[0] == '%' && fmt[1] == 's' && fmt[2] == 0 )
			fputs(val,fp);
		else	fprintf(fp,fmt,val);
	}
	return val[0];
}
int HTML_put1d(FILE *fp,PCStr(fmt),int iv)
{	CStr(buf,32);
	CStr(fmt1,8);

	if( fp != NULL ){
		if( fmt[0]=='%' && fmt[1]=='0' && isdigit(fmt[2]) ){
			sprintf(fmt1,"%%0%dd",atoi(&fmt[2]));
			sprintf(buf,fmt1,iv);
		}else	sprintf(buf,"%d",iv);
		put1s(fp,fmt,buf);
	}
	return iv;
}
static int call_func(Connection *Conn,PCStr(curl),FILE *outfp,PCStr(item),iFUNCP func,const void *arg)
{	CStr(name,1024);
	const char *param;
	CStr(fmtb,128);
	refQStr(fmt,fmtb); /**/
	int fi;
	int rcode;

	if( item[0] == '=' ){
		fputs(item+1,outfp);
		return strlen(item+1);
	}

	param = scanchr(item,':',AVStr(name));
	if( streq(name,"include") || streq(name,"include.silent") ){
		CStr(ncurl,1024);
		CStr(what,128);
		const char *dp;
		int leng;

		sprintf(what,"eval:%s",param);
		strcpy(ncurl,curl);
		curl = ncurl;
		if( dp = strrchr(curl,'/') )
			truncVStr(dp);
		chdir_cwd(QVStr((char*)curl,ncurl),param,0); /* ncurl is not "const" */

		leng = putBuiltinHTML(Conn,outfp,what,curl,NULL,func,arg);
		if( leng <= 0 )
		if( streq(name,"include") )
			fprintf(outfp,"(cannot include %s, %s)",param,curl);
		return 0 < leng;
	}

	param = scanchr(item,'.',AVStr(name));
	if( param == 0 )
		param = "";

	if( name[0] == '%' ){
		fmt = fmtb;
		setVStrElem(fmt,0,'%');
		for( fi = 1; fi < sizeof(fmtb)-2; fi++ ){
			if( name[fi] < '0' || '9' < name[fi] )
				break;
		setVStrElem(fmt,fi,name[fi]);
		}
		setVStrElem(fmt,fi,'s');
		setVStrEnd(fmt,fi+1);
		ovstrcpy(name,name+fi);
	}else{
		fmt = "%s";
	}

	if( name[0] == '_' ){
		ENCODE_ENT1 = 1;
		ovstrcpy(name,name+1);
	}else	ENCODE_ENT1 = 0;

	rcode = (*func)(Conn,outfp,fmt,name,param,arg);

	ENCODE_ENT1 = 0;
	return rcode;
}

static void scancond(PCStr(condexp),PVStr(conds),PVStr(trues),PVStr(falses))
{	const char *p;

	setVStrEnd(falses,0);
	setVStrEnd(trues,0);
	setVStrEnd(conds,0);
	if( p = scanchr(condexp,'?',AVStr(conds)) )
	if( p = scanchr(p,':',AVStr(trues)) )
		scanchr(p,'\0',AVStr(falses));
}
static void scanexp2(PCStr(exp),int dch,PVStr(left),PVStr(right))
{	const char *p;

	setVStrEnd(right,0);
	setVStrEnd(left,0);
	if( p = scanchr(exp,dch,AVStr(left)) )
		scanchr(p,'\0',AVStr(right));
}
static int cond1(Connection *Conn,PCStr(curl),FILE *outfp,PCStr(conds),iFUNCP func,const void *arg)
{	const char *dp;
	char dch;
	CStr(val1s,1024);
	CStr(val2s,1024);
	int val1,val2;

	if( dp = strpbrk(conds,"<=") ){
		dch = *dp;
		scanexp2(conds,dch,AVStr(val1s),AVStr(val2s));
		if( isdigits(val1s) )
			val1 = atoi(val1s);
		else	val1 = call_func(Conn,curl,NULL,val1s,func,arg);
		if( isdigits(val2s) )
			val2 = atoi(val2s);
		else	val2 = call_func(Conn,curl,NULL,val2s,func,arg);
		switch( dch ){
			case '<': return val1 < val2;
			case '=': return val1 == val2;
		}
		return 0;
	}else	return call_func(Conn,curl,NULL,conds,func,arg);
}

static int eval1(Connection *Conn,PCStr(curl),FILE *outfp,PCStr(item),iFUNCP func,const void *arg,int *exitlevp)
{	const char *dp;
	CStr(conds,4096);
	CStr(trues,4096);
	CStr(falses,4096);

	if( dp = strchr(item,'?') ){
		scancond(item,AVStr(conds),AVStr(trues),AVStr(falses));
		if( cond1(Conn,curl,outfp,conds,func,arg) )
			eval_DHTML(Conn,curl,outfp,trues,func,arg,exitlevp);
		else	eval_DHTML(Conn,curl,outfp,falses,func,arg,exitlevp);
		return 0;
	}else{
		return call_func(Conn,curl,outfp,item,func,arg /*,exitlevp*/);
	}
}

int eval_DHTML(Connection *Conn,PCStr(curl),FILE *outfp,PCStr(str),iFUNCP func,const void *farg,int *exitlevp)
{	const char *sp;
	const char *dp;
	const char *ctag;
	int pch,ch;
	int leng = 0;
	int col;
	int tlen,len1;
	DTag *dt;
	const char *arg = "";
	CStr(argb,0x8000);

	col = 0;
	pch = 0;
	for( sp = str; ch = *sp; sp++ ){
		if( col == 0 && ch == '#' ){
			for( sp++; sp[1]; sp++ ){
				ch = *sp;
				if( ch == '\n' )
					break;
				if( ch == '\r' && sp[1] == '\n' ){
					sp++;
					break;
				}
			}
			continue;
		}
		col++;

		if( ch == '\\' && RESERVED_CH(sp[1]) ){
			ch = sp[1];
			sp += 1;
			goto PUT1;
		}else
		if( ch == '\\' && sp[1] == '\n' ){
			sp += 1;
			continue;
		}else
		if( ch == '\\' && sp[1] == '\r' && sp[2] == '\n' ){
			sp += 2;
			continue;
		}else
		if( ch == '$' && sp[1] == '{' ){
		    if( strncmp(sp,"${exit}",7) == 0 ){
			*exitlevp = 1;
			break;
		    }else
		    if( strncmp(sp,"${NL}",5) == 0 ){
			ch = '\n';
			sp += 4;
		    }else
		    if( dp = scanitem(sp+2) ){
			truncVStr(dp);
			if( func != NULL ){
				eval1(Conn,curl,outfp,sp+2,func,farg,exitlevp);
				if( 0 < *exitlevp ){
					*exitlevp -= 1;
					break;
				}
			}
			sp = dp;
			continue;
		    }
		}else
		if( ch == '<' && strncasecmp(sp+1,"X-D ",4) == 0 ){
		    ctag = sp+5;
		    if( dp = strchr(ctag,'>') ){
			int ti;
			const char *tag;
			for( ti = 0; tag = dhtml_tags[ti].tag; ti++ ){
				tlen = strlen(tag);
				if( strncasecmp(ctag,tag,tlen) == 0 ){
					arg = ctag+tlen;
					while( *arg == ' ' )
						*arg++;
			strncpy(argb,arg,dp-arg); setVStrEnd(argb,dp-arg);
					break;
				}
			}
			if( tag ){
				dt = &dhtml_tags[ti];
				ENCODE_ENT1 = 1;
				len1 = (*dt->dt_func)(Conn,outfp,argb);
				ENCODE_ENT1 = 0;
				if( 0 <= len1 ){
					leng += len1;
					sp = dp;
					continue;
				}
			}
		    }
		}
		if( ch == '\n' && pch != '\r' ){
			putc('\r',outfp);
			leng += 1;
			col = 0;
		}
PUT1:
		putc(ch,outfp);
		pch = ch;
		leng += 1;
	}
	return leng;
}


extern int TOTAL_SERVED;

int DHTML_printConn(Connection *Conn,FILE *fp,PCStr(fmt),PCStr(name),PCStr(arg),PCStr(value))
{	CStr(hostport,256);
	CStr(stime,128);
	CStr(url,URLSZ);

	if( streq(name,"no-robots") ){
		DHTML_printNoRobots(Conn,fp,fmt,name,arg,value);
	}else
	if( streq(name,"services") ){
		prservices(fp);
	}else
	if( streq(name,"mtab") ){
		return DHTML_printMount(Conn,fp,fmt,name,arg /*,value*/);
	}else
	if( streq(name,"auth") ){
		return DHTML_printAuth(Conn,fp,fmt,name,arg,value);
	}else
	if( streq(name,"admin") ){
		return DHTML_printAdmin(Conn,fp,fmt,name,arg /*,value*/);
	}else
	if( streq(name,"genauth") ){
		return DHTML_pringGenAuth(Conn,fp,fmt,name,arg,value);
	}else
	if( streq(name,"client") ){
		if( streq(arg,"host") ){
			getpeerName(ClientSock,AVStr(hostport),PN_HOST);
			fputs(hostport,fp);
		}else
		if( streq(arg,"ident") ){
			const char *ouser;
			AuthInfo ident;
			if( ouser = VA_getOriginatorIdent(Conn,&ident) )
				fputs(ouser,fp);
		}else
		if( streq(arg,"ifhp") ){
			ClientIF_HPname(Conn,AVStr(hostport));
			fputs(hostport,fp);
		}else
		if( streq(arg,"peersessions") ){
			fprintf(fp,"%d",Conn->cl_count);
		}else
		if( streq(arg,"requestserno") ){
			fprintf(fp,"%d",RequestSerno);
		}else
		if( streq(arg,"useragent") ){
			const char *dp;
			HTTP_getRequestField(Conn,"User-Agent",AVStr(url),sizeof(url));
			if( dp = strstr(url,"MSIE ") )
			if( dp != url ){
				strcpy(url,dp);
				if( dp = strrchr(url,')') )
					truncVStr(dp);
			}
			fputs(url,fp);
		}
	}else
	if( streq(name,"moved") ){ /* printMoved */
		if( streq(arg,"url") )
			if( value != NULL )
				fputs(value,fp);
	}else
	if( streq(name,"ver") ){
		fputs(DELEGATE_ver(),fp);
	}else
	if( streq(name,"verdate") ){
		fprintf(fp,"%s",DELEGATE_verdate());
	}else
	if( streq(name,"Version") ){
		fputs(DELEGATE_Version(),fp);
	}else
	if( streq(name,"copyright") ){
		fputs(DELEGATE_copyright(),fp);
	}else
	if( streq(name,"homepage") ){
		fputs(DELEGATE_homepage(),fp);
	}else
	if( streq(name,"icon") ){
		if( streq(arg,"delegate") )
			fprintf(fp,"%s%s",HTTP_getIconBase(Conn),
				"ysato/DeleGateLogoTrans.gif");
		else
		if( streq(arg,"frog") )
			fprintf(fp,"%s%s",HTTP_getIconBase(Conn),
				"ysato/frog.gif");
		else
		if( streq(arg,"froghead") )
			fprintf(fp,"%s%s",HTTP_getIconBase(Conn),
				"ysato/frogHead.gif");
		else{
			fprintf(fp,"%sysato/%s.gif",HTTP_getIconBase(Conn),arg);
		}
	}else
	if( streq(name,"time") ){
		if( streq(arg,"now") ){
			StrftimeLocal(AVStr(stime),sizeof(stime),TIMEFORM_HTTPD,time(0),0);
			fputs(stime,fp);
		}else
		if( streq(arg,"start") )
			fputs(start_time(),fp);
	}else
	if( streq(name,"load") ){
		if( streq(arg,"total") )
			strfLoadStat(AVStr(url),128,"%L",time(NULL));
		else
		if( streq(arg,"recent") )
			strfLoadStat(AVStr(url),128,"%l",time(NULL));
		else	url[0] = 0;
		fputs(url,fp);
	}else
	if( streq(name,"num") ){
		if( streq(arg,"serno") )
			fprintf(fp,"%d",SERNO());
		else
		if( streq(arg,"peers") )
			fprintf(fp,"%d",alive_peers());
		else
		if( streq(arg,"served") )
			fprintf(fp,"%d",TOTAL_SERVED);
	}else
	if( streq(name,"host") ){
		if( streq(arg,"clif") ){
			ClientIF_name(Conn,FromC,AVStr(hostport));
			fputs(hostport,fp);
		}
	}else
	if( streq(name,"hostport") ){
		if( streq(arg,"client") ){
			strfConnX(Conn,"%h:%p",AVStr(hostport),sizeof(hostport));
			fputs(hostport,fp);
		}else
		if( streq(arg,"vhost") ){
			HTTP_ClientIF_HP(Conn,AVStr(hostport));
			fputs(hostport,fp);
		}else
		if( streq(arg,"clif") ){
			ClientIF_HPname(Conn,AVStr(hostport));
			fputs(hostport,fp);
		}
	}else
	if( streq(name,"request") ){
		if( streq(arg,"mssg") )
			HTTP_fprintmsg(Conn,fp,"om");
		else
		if( streq(arg,"line") )
			HTTP_fprintmsg(Conn,fp,"ol");
		else
		if( streq(arg,"url") ){
			HTTP_originalURLx(Conn,AVStr(url),sizeof(url));
			if( strncmp(url,"/-_-",4) == 0 )
				put1s(fp,"%s",url+4);
			else	put1s(fp,"%s",url);
		}
	}else
	if( streq(name,"server") ){
		const char *server;
		server = D_SERVER;
		if( streq(arg,"proto") )
			put1s(fp,"%s",DFLT_PROTO);
		else
		if( streq(arg,"name") )
			put1s(fp,"%s",server);
		else
		if( streq(arg,"host") )
			put1s(fp,"%s",DST_HOST);
		else
		if( streq(arg,"port") )
			fprintf(fp,"%d",DST_PORT);
		else
		if( streq(arg,"url") ){
			redirect_url(Conn,server,AVStr(url));
			put1s(fp,"%s",url);
		}
	}else
	if( streq(name,"expire") )
		fprintf(fp,"%d",http_EXPIRE(Conn,""));
	else
	if( streq(name,"getccx") ){
		CStr(code,128);
		if( CTX_cur_codeconvCL(Conn,AVStr(code)) )
			return 1;
		else	return 0;
	}else
	if( streq(name,"setccx") ){
		CStr(code,128);
		CStr(stat,128);
		if( CTX_cur_codeconvCL(Conn,AVStr(code)) ){
			global_setCCX(Conn,AVStr(code),AVStr(stat));
			fprintf(fp,"\"%s\" %s",code,stat);
		}
	}else
	if( streq(name,"codeconv") ){
		CStr(cvenv,128);
		CTX_cur_codeconvCL(Conn,AVStr(cvenv));
		fprintf(fp,"%s",cvenv);
	}else
	if( streq(name,"ADMIN") )
		fprintf(fp,"%s",DELEGATE_ADMIN);
	else
	if( streq(name,"forbidden") ){
		if( streq(arg,"reason") ){
			fprintf(fp,"%s",Conn->reject_reason);
		}
	}else
	if( streq(name,"cantconn") ){
		if( streq(arg,"rejected") )
			return ConnError & CO_REJECTED;
		if( streq(arg,"unknown") )
			return ConnError & CO_CANTRESOLV;
		if( streq(arg,"timeout") )
			return ConnError & CO_TIMEOUT;
		if( streq(arg,"refused") )
			return ConnError & CO_REFUSED;
		if( streq(arg,"unreach") )
			return ConnError & CO_UNREACH;
		if( streq(arg,"noroute") )
			return ConnError & CO_NOROUTE;
		return 0;
	}
	else
	if( streq(name,"delegate") ){
		if( streq(arg,"icons") ){
			redirect_url(Conn,(char*)HTTP_getIconBase(Conn),AVStr(url));
			fputs(url,fp);
		}else
		if( streq(arg,"home") ){
			fputs(DELEGATE_homepage(),fp);
		}else
		if( streq(arg,"homeurl") ){
			redirect_url(Conn,DELEGATE_homepage(),AVStr(url));
			fputs(url,fp);
		}else
		if( streq(arg,"ftp") ){
			fputs(DELEGATE_Distribution(),fp);
		}else
		if( streq(arg,"ftpurl") ){
			redirect_url(Conn,DELEGATE_Distribution(),AVStr(url));
			fputs(url,fp);
		}
	}
	return 0;
}
int put_eval_dhtml(Connection *Conn,PCStr(url),FILE *outfp,PCStr(instr))
{	int exitlev;

	exitlev = 0;
	return eval_DHTML(Conn,url,outfp,instr,(iFUNCP)DHTML_printConn,NULL,&exitlev);
}
