/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1997-1999 Yutaka Sato
Copyright (c) 1997-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	process.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	970117	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include "delegate.h"
#include "fpoll.h"
#include "param.h"
#include "file.h"
#include "proc.h"

extern const char **main_argv;

#define CLEAR(m) (Conn->m = 0)

static void clearConnPTR(Connection *Conn)
{
	CLEAR(sv_toServ);
	CLEAR(cl_user);
	CLEAR(cl_FromCbuff);
	CLEAR(gw_path);
	CLEAR(ht_LockedByClient);
	/*
	UTfree(&D_REQUESTtag);
	*/
if( D_REQUESTtag.ut_addr ) sv1log("#### clearConnPTR: clearing D_REQUEST\n");
	UTclear(&D_REQUESTtag);
}

int callFilter(Connection *Conn,int ac,const char *av[])
{	int ein,eout,rcc;
	FILE *in,*out;
	const char *args;
	int sock;
	int rcode;

	sscanf(av[2],"%d/%d",&ein,&eout);
	in = fdopen(ein,"r");

	rcc = fread(Conn,1,sizeof(Connection),in);
	if( Conn->cl_reqbuf ){
		Conn->cl_reqbuf = (char*)malloc(Conn->cl_reqbufsize);
		fread(Conn->cl_reqbuf,1,Conn->cl_reqbufsize,in);
	}
	clearConnPTR(Conn);
	fdopenLogFile(Conn->fi_logfd);

	if( 0 < Conn->fi_arglen ){
		args = (char*)malloc(Conn->fi_arglen);
		rcc = fread((char*)args,1,Conn->fi_arglen,in);
	}else{
		args = NULL;
		rcc = 0;
	}

	ClientSock = -1;
	if( Conn->fi_issock ){
		if( (sock = getclientsock()) < 0 )
		sock = Conn->fi_topeer;
		if( Conn->fi_dupclsock )
			ClientSock = sock;
	}else	sock = Conn->fi_topeer;

	if( Conn->fi_iomode & 1 ){
		close(eout);
		out = fdopen(sock,"w");
	}else{
		fclose(in);
		in = fdopen(sock,"r");
		out = fdopen(eout,"w");
	}

	Verbose("## callFilter: %x[%d,%d]\n",Conn->fi_func,fileno(in),fileno(out));
	rcode = (*Conn->fi_func)(Conn,in,out,args,rcc);
	Finish(rcode?1:0);
	return -1;
}

int spawnFilter(Connection *Conn,int iomode,int tofil[],int sock,iFUNCP func,PCStr(args))
{	CStr(ein,32);
	int ac;
	const char *av[256]; /**/
	CStr(epath,1024);
	CStr(logtype,64);
	int fin; /* input at the filter side */
	int fout; /* output at the DeleGate side */
	int pid;
	int wcc;
	int wi;

	fin = tofil[0];
	fout = tofil[1];
	sprintf(ein,"%d/%d",fin,fout);

	sprintf(epath,"%s=%s",P_EXEC_PATH,EXEC_PATH);
	ac = 0;
	av[ac++] = /*DeleGate1*/ "DeleGate";
	av[ac++] = /*FuncFILTER*/ "(Filter)";
	av[ac++] = ein;
	av[ac++] = epath;

	/*
	sprintf(logtype,"-L0x%x",LOG_type);
	*/
	sprintf(logtype,"-L0x%x/%d",LOG_type,curLogFd());
	av[ac++] = logtype;
	ac += copy_param("f",elnumof(av)-ac,&av[ac],&main_argv[1]);
	av[ac] = NULL;

	Conn->fi_func = func;
	if( args == NULL )
		Conn->fi_arglen = 0;
	else	Conn->fi_arglen = strlen(args)+1;
	Conn->fi_iomode = iomode;
	Conn->fi_logfd  = curLogFd();

	Conn->fi_topeer = sock;
	Conn->fi_dupclsock = 0;
	if( Conn->fi_issock = file_ISSOCK(sock) ){
		setclientsock(sock);
		if( sock == ClientSock
		 || SocketOf(sock) == SocketOf(ClientSock) )
			Conn->fi_dupclsock = 1;
			
	}

	pid = Spawnvp("openFilter",EXEC_PATH,av);
	Verbose("## spawnFilter: %d -> %d\n",getpid(),pid);

	wcc = write(fout,Conn,sizeof(Connection));
	if( Conn->cl_reqbuf )
		write(fout,Conn->cl_reqbuf,Conn->cl_reqbufsize);
	if( args != NULL )
		write(fout,args,strlen(args)+1);

	/* If the iomode == READ then
	 * must wait till the client finish to read the written environment
	 * not to read it by myself.
	 * (in the case of FFROMCL, payload data may be ready, but cannot
	 *  identify whether or not it is env. data or payload data ...)
	 * If the iomode == WRITE and filter is direct system-command then
	 * must wait not to make buffered data be not passed to the filter.
	 */
	if( iomode == 0 || iomode != 0 && 0 < PollIn(fin,1) ){
		sv1log("## wait the filter finish reading enviroment\n");
		msleep(100);
	}

	return pid;
}

FILE *openFilter(Connection *Conn,PCStr(fname),iFUNCP func,FILE *out,PCStr(args))
{	int pid;
	int toc[2];
	FILE *ioin;

	pipe(toc);
	if( INHERENT_fork() ){
		/*
		if( Fork("openFilter") == 0 ){
		*/
		if( (pid = Fork("openFilter")) == 0 ){
			close(toc[1]);
			ioin = fdopen(toc[0],"r");
			(*func)(Conn,ioin,out,args);
			Finish(0);
		}
	}else{
		fflush(out);
		pid = spawnFilter(Conn,1,toc,fileno(out),func,args);
	}
	Conn->fi_pid = pid;
	close(toc[0]);
	return fdopen(toc[1],"w");
}
