/*////////////////////////////////////////////////////////////////////////
Copyright (c) 2005 National Institute of Advanced Industrial Science and Technology (AIST)

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.
AIST MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	gzip.c
Author:		Yutaka Sato <ysato@delegate.org>
Description:

History:
	050501	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include <stdlib.h>
#include "ystring.h"

/*BEGIN_STAB(zlib)*/
typedef void *gzFile;
gzFile gzopen(const char *path,const char *mode);
gzFile gzdopen(int fd,const char *mode);
int gzwrite(gzFile file,const void *buf,unsigned len);
int gzread(gzFile file,void *buf,unsigned len);
int gzclose(gzFile file);
/*END_STAB*/

int dl_library(const char *libname,DLMap *dlmap,const char *mode);
int gzipInit(){
	int code;
	code = dl_library("z",dlmap_zlib,"");
	return code;
}

int gzipFilter(FILE *in,FILE *out){
	gzFile gz;
	int len,rcc;
	char buf[1024];
	int size;
	double Start = Time();

	len = 0;
	if( gz = gzdopen(dup(fileno(out)),"w") ){
		while( rcc = fread(buf,1,sizeof(buf),in) ){
			gzwrite(gz,buf,rcc);
			len += rcc;
		}
		gzclose(gz);
		fseek(out,0,2);
		size = ftell(out);
		fseek(out,0,0);
		syslog_DEBUG("(%f)gzipFilter %d -> %d\n",Time()-Start,len,size);
		return len;
	}
	return 0;
}
int gunzipFilter(FILE *in,FILE *out){
	gzFile gz;
	int rcc;
	char buf[1024];
	int size;
	double Start = Time();

	size = 0;
	if( gz = gzdopen(dup(fileno(in)),"r") ){
		while( rcc = gzread(gz,buf,sizeof(buf)) ){
			fwrite(buf,1,rcc,out);
			size += rcc;
		}
		gzclose(gz);
		fseek(out,0,0);
		syslog_DEBUG("(%f)gunzipFilter -> %d\n",Time()-Start,size);
		return size;
	}
	return 0;
}
