#include <stdio.h>
#include <stdlib.h>
#include "yalloca.h"
#include "ystring.h"

int alloca_call(AllocaArg *ap)
{	char *buff;
	int size;

	buff = (char*)alloca(ap->s_size * ap->s_unit);
	if( buff == NULL ){
		porting_dbg("#### FATAL: alloca_call() failed (no more stack)");
		exit(-1);
	}
	addStrBuffer(ap->s_level,buff,ap->s_size*ap->s_unit);

	if( ap->s_trace ){
		size = ap->s_sp0 - buff;
		porting_dbg("%s (%4d) = %5d [%08lX - %08lX]",
			ap->s_what,ap->s_size,size,(char*)&ap,ap->s_sp0);
	}
	buff = 0;
	size = 0;
	return (*ap->s_func)(ap->s_av[0],ap->s_av[1],ap->s_av[2],ap->s_av[3]);
}
int INHERENT_alloca(){ return 1; }
