/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1997-1999 Yutaka Sato
Copyright (c) 1997-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	env.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	970814	extracted from delegated.c
//////////////////////////////////////////////////////////////////////#*/
#include "config.h"
#include "delegate.h"
#include "param.h"
#include "fpoll.h"
#include "file.h"
#include <stdlib.h>

int  main_argc;
const char **main_argv;
extern char **environ;

scanPFUNCP param_scanner(PCStr(param));
const char *scan_arg1(PCStr(ext_base),PCStr(arg));

typedef struct {
	int   ee_ext_argc;
  const	char *ee_ext_argv[MAX_ARGC]; /**/
	int   ee_extovw_argc;
  const	char *ee_extovw_argv[MAX_ARGC]; /**/
	int   ee_gen_envx;
  const	char *ee_gen_environ[32]; /**/
  const	char *ee_ext_environ[MAX_ARGC]; /**/
} Envs;
static Envs *envs;
#define ext_argc	envs->ee_ext_argc
#define ext_argv	envs->ee_ext_argv
#define extovw_argc	envs->ee_extovw_argc
#define extovw_argv	envs->ee_extovw_argv
#define gen_envx	envs->ee_gen_envx
#define gen_environ	envs->ee_gen_environ
#define ext_environ	envs->ee_ext_environ
void minit_envs(){
	if( envs == 0 )
		envs = NewStruct(Envs);
}

int DELEGATE_EXTOVW;
void DELEGATE_clearEnv()
{
	extovw_argc = 0;
}
const char *DELEGATE_getEnv(PCStr(name))
{	const char *value;
	CStr(xname,64);

	if( value = getv(gen_environ,name) )
		return value;
	if( value = getv(extovw_argv,name) )
		return value;
	if( value = getv(main_argv,name) )
		return value;
	if( value = getv(ext_argv,name) )
		return value;
	sprintf(xname,"DG_%s",name);
	if( value = getenv(xname) )
		return value;
	return getenv(name);
}
void dumpEnv(){
	int ai;
	for( ai = 0; gen_environ[ai]; ai++ )
		printf("GEN[%d] %s\n",ai,gen_environ[ai]);
	for( ai = 0; ai < extovw_argc; ai++ )
		printf("OVW[%d] %s\n",ai,extovw_argv[ai]);
	for( ai = 0; ai < main_argc; ai++ )
		printf("MAI[%d] %s\n",ai,main_argv[ai]);
	for( ai = 0; ai < ext_argc; ai++ )
		printf("EXT[%d] %s\n",ai,ext_argv[ai]);
	for( ai = 0; environ[ai]; ai++ )
		printf("ENV[%d] %s\n",ai,environ[ai]);
}
int DELEGATE_copyEnv(int mac,const char *av[],int ac,PCStr(path),PVStr(abuff))
{	int ai;
	CStr(hosts,0x4000);
	CStr(port,256);
	refQStr(ap,abuff); /**/

	if( mac-1 <= ac )
		goto EXIT;
	if( lVERB() ){
		av[ac++] = "-vv";
	}else{
		printServPort(AVStr(port),"",0);
		sprintf(ap,"%s=%s",P_LOGFILE,port);
		av[ac++] = ap;  ap += strlen(ap) + 1;
	}

	if( mac-1 <= ac )
		goto EXIT;
	sprintf(ap,"%s=%s",P_EXEC_PATH,path);
	av[ac++] = ap; ap += strlen(ap) + 1;

	for( ai = 0; ai < ext_argc; ai++ ){
		if( mac-1 <= ac )
			goto EXIT;
		av[ac++] = ext_argv[ai];
	}

	for( ai = 1; ai < main_argc; ai++ ){
		if( mac-1 <= ac )
			goto EXIT;
		if( main_argv[ai] )
			av[ac++] = main_argv[ai];
	}

	for( ai = 0; ai < extovw_argc; ai++ ){
		if( mac-1 <= ac )
			goto EXIT;
		av[ac++] = extovw_argv[ai];
	}

	for( ai = 0; ai < gen_envx; ai++ ){
		if( mac-1 <= ac )
			goto EXIT;
		av[ac++] = gen_environ[ai];
	}

	if( mac-1 <= ac )
		goto EXIT;
	if( dump_HOSTS(AVStr(hosts)) ){
		sprintf(ap,"%s=%s",P_HOSTS,hosts);
		Verbose("%s\n",ap);
		av[ac++] = ap; ap += strlen(ap) + 1;
	}
EXIT:
	return ac;
}
int DELEGATE_copyEnvPM(int mac,const char *dav[],PCStr(name))
{	int ac;

	ac = 0;
	ac += copy_param(name,mac-ac,&dav[ac],(const char**)environ);
	ac += copy_param(name,mac-ac,&dav[ac],ext_argv);
	ac += copy_param(name,mac-ac,&dav[ac],&main_argv[1]);
	ac += copy_param(name,mac-ac,&dav[ac],gen_environ);
	return ac;
}

int dump_main(int ac,const char *av[])
{	int ai;
	const char *nam;
	const char *val;
	CStr(valb,256);

	for( ai = 1; ai < ac; ai++ ){
		nam = av[ai];
		if( strcmp(nam,"DGROOT") == 0 ){
			val = DELEGATE_DGROOT;
		}else
		if( strcmp(nam,"OWNER") == 0 ){
			sprintf(valb,"#%d/#%d",getuid(),getgid());
			val = valb;
		}else
		if( strcmp(nam,"ADMIN") == 0 ){
			val = getADMIN();
		}else{
			val = DELEGATE_getEnv(nam);
		}
		printf("%s\n",val?val:"(none)");
	}
	exit(0);
	return 0;
}

/*
static const char *getEnvT(PCStr(name))
{	const char *body;
	if( body = getEnv(name) )
		if( body[-1] == '=' )
			return body - strlen(name) - 1;
		else	return body - strlen(name);
	return 0;
}
*/

void DELEGATE_addEnvExt(PCStr(env))
{
	if( lVERB() || lARGDUMP() ){
		if( DELEGATE_EXTOVW )
			fprintf(stderr,"<%d> %s\n",extovw_argc,env);
		else	fprintf(stderr,"<%d> %s\n",ext_argc,env);
	}
	if( DELEGATE_EXTOVW ){
		if( elnumof(extovw_argv) <= extovw_argc ){
			syslog_ERROR("too many args: %s\n",env);
		}else{
			extovw_argv[extovw_argc++] = StrAlloc(env);
		}
	}else{
		if( elnumof(ext_argv) <= ext_argc ){
			syslog_ERROR("too many args: %s\n",env);
		}else{
			ext_argv[ext_argc++] = StrAlloc(env);
		}
	}
}
void DELEGATE_pushEnv(PCStr(name),PCStr(value))
{	CStr(env,1024);

	sprintf(env,"%s=%s",name,value);
	if( elnumof(gen_environ) <= gen_envx ){
		syslog_ERROR("too many args: %s\n",env);
	}else{
		gen_environ[gen_envx++] = StrAlloc(env);
	}
}
typedef struct {
	Connection *sv_Conn;
	IFUNCP	sv_func;
  const char	*sv_arg;
	int	sv_ign_include;
} SvArg;
static int scanenv1(SvArg *sva,PCStr(val))
{
	if( strncmp(val,INC_SYM,INC_SYM_LEN) == 0 )
		return 0;
	if( strstr(val,":+=") || strstr(val,",+=") )
		return 0;
	else	return (*sva->sv_func)(sva->sv_Conn,val,sva->sv_arg);
}
int DELEGATE_scanEnv(Connection *Conn,PCStr(name),scanPFUNCP func,...)
{	int nhit;
	SvArg sva;
	const char *arg;
	VARGS(1,func);
	arg = va[0];

	nhit = 0;
	sva.sv_Conn = Conn;
	sva.sv_func = (IFUNCP)func;
	sva.sv_arg = arg;
	nhit += scanv((const char**)environ,name,(iFUNCP)scanenv1,(void*)&sva);
	nhit += scanv(ext_argv,name,(iFUNCP)scanenv1,(void*)&sva);
	nhit += scanv(main_argv,name,(iFUNCP)scanenv1,(void*)&sva);
	nhit += scanv(extovw_argv,name,(iFUNCP)scanenv1,(void*)&sva);
	nhit += scanv(gen_environ,name,(iFUNCP)scanenv1,(void*)&sva);
	return nhit;
}

#define CFput(fp,fmt,ai,msg) {\
	if( fp != NULL ) fprintf(fp,fmt,ai,msg); else sv0log(fmt,ai,msg); \
	leng += strlen(msg); \
}
int DELEGATE_dumpEnv(FILE *fp,int genalso,int imPM)
{	int ai;
	const char *env;
	int leng = 0;

	if( fp != NULL && !imPM ){
		CStr(port,128);
		printServPort(AVStr(port),"-P",genalso);
		fprintf(fp,"%s\n",port);
	}

	for( ai = 0; env = environ[ai]; ai++ )
	if( 0 <= check_param(env,0) )
		CFput(fp,"env[%d] %s\n",ai,env);

	for( ai = 0; ai < ext_argc; ai++ )
		CFput(fp,"ext[%d] %s\n",ai,ext_argv[ai]);

	for( ai = 1; ai < main_argc; ai++ )
	if( 0 <= check_param(main_argv[ai],0) )
		CFput(fp,"arg[%d] %s\n",ai,main_argv[ai]);

	if( genalso )
	for( ai = 0; gen_environ[ai]; ai++ )
		CFput(fp,"gen[%d] %s\n",ai,gen_environ[ai]);

	return leng;
}


/*
 * inporting configuration parameters
 */
int param_file = -1;
int param_mtime = 0;

void new_param_file(PCStr(path))
{	FILE *fp;

	if( 0 <= param_file )
		return;
	fp = TMPFILE("PARAM_FILE");
	/*
	 * it should be a visible file under ETCDIR or ADMDIR ...
	 */
	param_file = dup(fileno(fp));
	fclose(fp);
	param_mtime = file_mtime(param_file);
}
int add_params(Connection *Conn,FILE *tc,PCStr(command))
{	FILE *fp;
	int pid;
	CStr(com,1024);
	CStr(param,1024);

	/*
	 * must check accees right here...
	 */

	if( param_file < 0 ){
		fprintf(tc,"500 no parameter file\r\n");
		return -1;
	}

	com[0] = param[0] = 0;
	Xsscanf(command,"%s %[^\r\n]",AVStr(com),AVStr(param));

	/*
	 * param may be +=URL
	 */

	if( com[0] == 0 || param[0] == 0 ){
		fp = fdopen(dup(param_file),"r");
		fseek(fp,0,0);
		fputs("200 list of inported parameters follows:\r\n",tc);
		copyfile1(fp,tc);
		fputs(".\r\n",tc);
		fclose(fp);
		return 0;
	}
	if( check_param(param,0) < 0 ){
		fprintf(tc,"500 unknown parameter: %s\r\n",param);
		return -1;
	}
	if( lock_exclusiveTO(param_file,2000,NULL) != 0 ){
		fprintf(tc,"500 cannot lock parameter file\r\n");
		return -1;
	}
	pid = getpid();
	fp = fdopen(dup(param_file),"w");
	fprintf(fp,"%d %s\r\n",pid,param);
	fclose(fp);

	sv1log("#### PARAM INPORTED: %d %s\n",pid,param);
	fprintf(tc,"200 ok.\r\n");
	return 0;
}
void load_params(Connection *Conn)
{	FILE *fp;
	CStr(line,1024);
	CStr(param,1024);
	int mtime,pid;

	if( param_file < 0 )
		return;
	mtime = file_mtime(param_file);
	if( mtime == param_mtime )
		return;
	param_mtime = mtime;
	sv1log("#### PARAM updated\n");

	fp = fdopen(dup(param_file),"r");
	fseek(fp,0,0);
	while( fgets(line,sizeof(line),fp) ){
		Xsscanf(line,"%d %[^\r\n]",&pid,AVStr(param));
		sv1log("#### %d %s\n",pid,param);
		if( strncmp(param,"MOUNT=",6) == 0 ){
			scan_MOUNT(Conn,param+6);
			init_mtab();
		}
	}
	fclose(fp);
}


extern int DELAY_REJECT_S;
extern int DELAY_UNKNOWN_S;
extern int DELAY_REJECT_P;
extern int DELAY_UNKNOWN_P;
extern int DELAY_ERROR;

static scanListFunc delay1(PCStr(dspec))
{	CStr(what,128);
	int delay;
	int *iaddr;

	delay = 0;
	Xsscanf(dspec,"%[^:]:%d",AVStr(what),&delay);

	iaddr = 0;
	if( strcaseeq(what,"reject")    ) iaddr = &DELAY_REJECT_S; else
	if( strcaseeq(what,"unknown")   ) iaddr = &DELAY_UNKNOWN_S; else
	if( strcaseeq(what,"reject_p")  ) iaddr = &DELAY_REJECT_P; else
	if( strcaseeq(what,"unknown_p") ) iaddr = &DELAY_UNKNOWN_P; else
	if( strcaseeq(what,"error")     ) iaddr = &DELAY_ERROR; else
	{
		sv1tlog("ERROR: unknown DELAY=%s\n",what);
	}
	if( iaddr ){
		xmem_push(iaddr,sizeof(int),"DELAY",NULL);
		*iaddr = delay;
	}
	return 0;
}
void scan_DELAY(Connection *Conn,PCStr(sdelay))
{
	scan_commaList(sdelay,0,scanListCall delay1);
}

extern int MAX_ERESTART;
extern int MAX_DELEGATE;
extern int MAX_SERVICE;
extern int STANDBY_MAX;
extern int FDSET_MAX;
extern int HTTP_CKA_MAXREQ;
extern int HTTP_CKA_PERCLIENT;
extern int MAX_CC;
extern int MAXCONN_PCH;
extern int MAX_BUFF_SOCKRECV;
extern int MAX_BUFF_SOCKSEND;
extern int RANDSTACK_RANGE;
extern int RANDSTACK_UNIT;
extern int RANDFD_RANGE;
extern int RANDENV_RANGE;
extern int UDPRELAY_MAXASSOC;
extern int WIN_MTU;

static scanListFunc maxima1(PCStr(maxima))
{	CStr(name,128);
	int num;
	int *addr;

	if( Xsscanf(maxima,"%[^:]:%d",AVStr(name),&num) != 2 ){
		ERRMSG("DeleGate/%s: ERROR syntax MAXIMA=%s\n",
			DELEGATE_ver(),maxima);
		return 0;
	}

	addr = 0;
	if( streq(name,"erestart") )	addr = &MAX_ERESTART; else
	if( streq(name,"randstack") )	addr = &RANDSTACK_RANGE; else
	if( streq(name,"randfd") )	addr = &RANDFD_RANGE; else
	if( streq(name,"randenv") )	addr = &RANDENV_RANGE; else
	if( streq(name,"fdset") )	addr = &FDSET_MAX; else
	if( streq(name,"delegated") )	addr = &MAX_DELEGATE; else
	if( streq(name,"standby") )     addr = &STANDBY_MAX; else
	if( streq(name,"ftpcc") )	addr = &MAX_CC; else
	if( streq(name,"nntpcc") )	addr = &MAX_CC; else
	if( streq(name,"svcc") )	addr = &MAX_CC; else
	if( streq(name,"listen") )	addr = &DELEGATE_LISTEN; else
	if( streq(name,"sockrecv") )	addr = &MAX_BUFF_SOCKRECV; else
	if( streq(name,"socksend") )	addr = &MAX_BUFF_SOCKSEND; else
	if( streq(name,"winmtu") )	addr = &WIN_MTU; else
	if( streq(name,"service") )	addr = &MAX_SERVICE; else
	if( streq(name,"conpch") )	addr = &MAXCONN_PCH; else
	if( streq(name,"http-cka") )	addr = &HTTP_CKA_MAXREQ; else
	if( streq(name,"http-ckapch") )	addr = &HTTP_CKA_PERCLIENT; else
	if( streq(name,"udprelay") )	addr = &UDPRELAY_MAXASSOC; else
	{

		ERRMSG("DeleGate/%s: ERROR unknown MAXIMA=%s\n",
			DELEGATE_ver(),maxima);
	}

	if( addr ){
		xmem_push(addr,sizeof(int),"MAXIMA",NULL);
		*addr = num;
	}
	return 0;
}
void scan_MAXIMA(Connection *Conn,PCStr(maxima))
{
	scan_commaList(maxima,0,scanListCall maxima1);
}

extern int SHUTOUT_TIMEOUT;
extern int DNS_TIMEOUT;
extern int ACC_TIMEOUT;
extern int CON_TIMEOUT;
extern int LIN_TIMEOUT;
extern int IO_TIMEOUT;
extern int CC_TIMEOUT_FTP;
extern int CC_TIMEOUT_NNTP;
extern int CACHE_TAKEOVER;
extern int RSLV_INV_TIMEOUT;
extern int SILENCE_TIMEOUT; /* no transmission from server or client */
extern int HELLO_TIMEOUT;
extern int VSAP_TIMEOUT;
extern int ERROR_RESTART;
extern int SERVER_RESTART;
extern int SERVER_TIMEOUT;
extern int STANDBY_TIMEOUT;
extern int NONCE_TIMEOUT;
extern double HTTP_WAIT_REQBODY;
extern double HTTP_TOUT_IN_REQBODY;
extern double HTTP_TOUT_CKA;
extern double HTTP_TOUT_CKA_MARGIN;
extern double SVHELLO_TIMEOUT;
extern double IDENT_TIMEOUT;
extern double CFISTAT_TIMEOUT;

static scanListFunc timeout1(PCStr(to))
{	CStr(name,128);
	CStr(period,128);
	double secs;
	double *daddr;
	int *iaddr;

	if( Xsscanf(to,"%[^:]:%s",AVStr(name),AVStr(period)) == 2 ){
		secs = Scan_period(period,'s',(double)0);
		daddr = 0;
		iaddr = 0;

		if( streq(name,"shutout"))   iaddr = &SHUTOUT_TIMEOUT; else
		if( streq(name,"hello"))     iaddr = &HELLO_TIMEOUT; else
		if( streq(name,"login"))     iaddr = &LOGIN_TIMEOUT; else
		if( streq(name,"dns") )	     iaddr = &DNS_TIMEOUT; else
		if( streq(name,"dnsinv") )   iaddr = &RSLV_INV_TIMEOUT; else
		if( streq(name,"vsapacc"))   iaddr = &VSAP_TIMEOUT; else
		if( streq(name,"acc") )	     iaddr = &ACC_TIMEOUT; else
		if( streq(name,"con") )	     iaddr = &CON_TIMEOUT; else
		if( streq(name,"lin") )	     iaddr = &LIN_TIMEOUT; else
		if( streq(name,"greeting"))  daddr = &SVHELLO_TIMEOUT; else
		if( streq(name,"ident"))     daddr = &IDENT_TIMEOUT; else
		if( streq(name,"rident"))    daddr = &RIDENT_TIMEOUT; else
		if( streq(name,"cfistat"))   daddr = &CFISTAT_TIMEOUT; else
		if( streq(name,"silence"))   iaddr = &SILENCE_TIMEOUT; else
		if( streq(name,"io") )	     iaddr = &IO_TIMEOUT; else
		if( streq(name,"idle"))	     iaddr = &IO_TIMEOUT; else
		if( streq(name,"restart"))   iaddr = &SERVER_RESTART; else
		if( streq(name,"erestart"))  iaddr = &ERROR_RESTART; else
		if( streq(name,"daemon"))    iaddr = &SERVER_TIMEOUT; else
		if( streq(name,"standby")  ) iaddr = &STANDBY_TIMEOUT; else
		if( streq(name,"dgnonce")  ) iaddr = &NONCE_TIMEOUT; else
		if( streq(name,"takeover"))  iaddr = &CACHE_TAKEOVER; else
		if( streq(name,"ftpcc"))     iaddr = &CC_TIMEOUT_FTP; else
		if( streq(name,"nntpcc"))    iaddr = &CC_TIMEOUT_NNTP; else

	if( streq(name,"http-wait-qbody"))   daddr = &HTTP_WAIT_REQBODY; else
	if( streq(name,"http-poll-qbody"))   daddr = &HTTP_TOUT_IN_REQBODY; else
	if( streq(name,"http-cka"))          daddr = &HTTP_TOUT_CKA; else
	if( streq(name,"http-ckamg"))        daddr = &HTTP_TOUT_CKA_MARGIN; else
		{
			sv1tlog("ERROR: unknown TIMEOUT=%s\n",name);
		}

		if( daddr ){
			xmem_push(daddr,sizeof(double),"TIMEOUT",NULL);
			*daddr = secs;
		}
		if( iaddr ){
			xmem_push(iaddr,sizeof(int),"TIMEOUT",NULL);
			*iaddr = (int)secs;
		}
	}
	if( SERVER_TIMEOUT )
	if( SERVER_TIMEOUT < ACC_TIMEOUT || ACC_TIMEOUT == 0 )
		ACC_TIMEOUT = SERVER_TIMEOUT;

	return 0;
}
void scan_TIMEOUT(Connection *Conn,PCStr(timeouts))
{
	scan_commaList(timeouts,0,scanListCall timeout1);
}

typedef struct {
	char	*m_addr; /**/
	int	 m_size;
	char	*m_save; /**/
  const char	*m_what;
	iFUNCP	 m_func;
} Memory;

#define MAXLEV 8
typedef struct {
	Memory	*s_mem;
	int	 s_siz;
	int	 s_top;
} Stack;

static Stack mstack[MAXLEV]; /**/

#define mdebug	!lMEMPUSH() ? 0 : putLog0

int mem_push(int lev,PCStr(addr),int size,PCStr(what),iFUNCP func)
{	Stack *St;
	Memory *Me;
	int siz,top,mi;

	St = &mstack[lev];
	if( St->s_siz <= St->s_top ){
		siz = St->s_siz = St->s_siz + 32;
		if( St->s_siz ){
			St->s_mem = (Memory*)realloc(St->s_mem,siz*sizeof(Memory));
			for( mi = St->s_top; mi < siz; mi++ )
				St->s_mem[mi].m_save = 0;
		}else	St->s_mem = (Memory*)calloc(siz,sizeof(Memory));
	}
	top = St->s_top++;
	Me = &St->s_mem[top];
	if( Me->m_save != 0 ){
		if( Me->m_size < size ){
			free(Me->m_save);
			Me->m_save = 0;
		}
	}
	if( Me->m_save == 0 )
		Me->m_save = (char*)malloc(size);
	Me->m_addr = (char*)addr;
	Me->m_size = size;
	Me->m_what = what;
	Me->m_func = func;
	bcopy(addr,Me->m_save,size);

	mdebug("{m} PUSH[%d][%d] %X -> %X (%d) %s\n",lev,top,
		Me->m_addr,Me->m_save,Me->m_size,Me->m_what);
	return top;
}
void mem_pop1(int lev)
{	Stack *St;
	Memory *Me;
	int mi;
	iFUNCP func;
	int diff;

	St = &mstack[lev];
	for( mi = St->s_top-1; 0 <= mi; mi-- ){
		Me = &St->s_mem[mi];
		diff = bcmp(Me->m_save,Me->m_addr,Me->m_size);
		if( func = Me->m_func )
			(*func)(Me->m_save,Me->m_addr,Me->m_size,Me->m_what);
		else	bcopy(Me->m_save,Me->m_addr,Me->m_size);

		mdebug("{m} POP%s[%d][%d] %X <- %X (%d) %s\n",diff?"!":"=",
			lev,mi,Me->m_addr,Me->m_save,Me->m_size,Me->m_what);
	}
	St->s_top = 0;
}
void mem_pops(int lev)
{	int li;

	mdebug("{m} POPS[%d]\n",lev);
	for( li = MAXLEV-1; lev <= li; li-- ){
		mem_pop1(li);
	}
}

/*
 * "(" [srcHostList] [":"[dstHostList] [":"[protList]]] ")"argument
 * AMAP=[srcHostList]:[dstHostList]:[protoList]:argument
 * conditional argument
 */

const char *skip_argcond(PCStr(arg))
{
	if( strncmp(arg,"(",1) == 0 ){
		if( arg = strstr(arg,")") )
			arg++;
	}
	return arg;
}

typedef struct {
  const	char	*ca_cond;
  const	char	*ca_arg;
  scanPFUNCP	 ca_scan; /* function to interpret the argument */
	int	 ca_src;
	int	 ca_dst;
} CondArg;
static CondArg condArg[32]; /**/
static int condArgX;

int add_condarg(PCStr(arg))
{	const char *dp;
	CStr(cond,1024);
	int cai;
	CondArg *Cp;

	if( *arg != '(' )
		return 0;
	dp = wordscanY(arg+1,AVStr(cond),sizeof(cond),"^)");
	if( *dp++ != ')' )
		return 0;
	if( *dp == 0 )
		return 0;
	if( elnumof(condArg) <= condArgX ){
		return 0;
	}
	cai = condArgX++;
	Cp = &condArg[cai];
	Cp->ca_cond = stralloc(cond);
	Cp->ca_src = makePathList("condarg",cond);
	Cp->ca_arg = stralloc(dp);
	Cp->ca_scan = param_scanner(dp);

	mdebug("{m} INIT[%s](%d) %s\n",cond,Cp->ca_src,dp);
	return 1;
}

extern int DGLEV;
extern int BREAK_STICKY;
extern int (*evalarg_func)(const char*,const char*);
static Connection *evalarg_Conn;

static int exec_condarg(PCStr(base),PCStr(arg),scanPFUNCP func)
{	const char *dp;

	if( func ){
		if( dp = strchr(arg,'=') ){
			(*func)(evalarg_Conn,dp+1);
		}
		return 1;
	}else
	if( strneq(arg,"-v",2)
	 || strneq(arg,"-d",2)
	 || strneq(arg,"-W",2)
	){
		xmem_push(&LOG_type,sizeof(LOG_type),"-vX",NULL);
		xmem_push(&LOG_VERBOSE,sizeof(LOG_VERBOSE),"-vv",NULL);
		scan_arg1(NULL,arg);
		return 1;
	}
	return 0;
}
static int scan1(PCStr(base),PCStr(arg))
{	scanPFUNCP func;

	func = param_scanner(arg);
	exec_condarg(base,arg,func);
	return 0;
}
void scan_condargs(Connection *Conn)
{	CondArg *Cp;
	const char *arg;
	int cai;
	int match;

	match = 0;
	for( cai = 0; cai < condArgX; cai++ ){
		Cp = &condArg[cai];
		arg = Cp->ca_arg;
		if( Cp->ca_src )
		if( !matchPath1(Cp->ca_src,"-",Client_Host,Client_Port) )
			continue;

		if( strneq(arg,"+=",2) ){
			evalarg_func = scan1;
			evalarg_Conn = Conn;
			load_script(NULL,NULL,arg+2);
			evalarg_func = 0; 
			continue;
		}

		if( match == 0 ){
			const char **sp;
			xmem_push(&extovw_argc,sizeof(int),"ext_argc",NULL);
			sp = &extovw_argv[extovw_argc]; /* end of array */
			xmem_push(sp,sizeof(char*),"ext_argv",NULL);
		}
		mdebug("{m} [%d]MATCH [%s]%s\n",extovw_argc,Client_Host,arg);
		match++;
		if( elnumof(extovw_argv) <= extovw_argc )
			syslog_ERROR("too many extovw_arg\n");
		else	extovw_argv[extovw_argc++] = (char*)arg;

		if( exec_condarg(NULL,arg,Cp->ca_scan) ){
		}else{
			sv1log("{m} Not supported (%s)%s\n",
				Cp->ca_cond,Cp->ca_arg);
			BREAK_STICKY = 1;
		}
	}
}
