/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1998-1999 Yutaka Sato
Copyright (c) 1998-1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	socks5.c (RFC1928 SocksV5 server and client)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
	Authentication is not supported yet.
History:
	980211	created
//////////////////////////////////////////////////////////////////////#*/
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include "ystring.h"
#include "vsocket.h"
#include "fpoll.h"

#define Send(s,b,l,f)	send(s,(char*)b,l,f)
#define Recv(s,b,l,f)	recv(s,(char*)b,l,f)
#define Sendto(s,b,l,f,a,n)	sendto(s,(char*)b,l,f,a,n)
#define Recvfrom(s,b,l,f,a,n)	recvfrom(s,(char*)b,l,f,a,n)

int VSA_comp(VSAddr*,VSAddr*);
int setCloseOnExec(int);
int CTX_auth(DGC*ctx,PCStr(user),PCStr(pass));
void tcp_relay2(int timeout,int s1,int d1,int s2,int d2);
int CTX_ToS(DGC*ctx);
int CTX_FromS(DGC*ctx);


static int recv_mssg(int sock,char sbuf[],int siz)
{	unsigned char *buf = (unsigned char*)sbuf; /**/
	int rcc,rcc1,alen;

	rcc = Recv(sock,buf,10,0);
	if( rcc < 10 ) return rcc;
	if( buf[0] != 5 ) return rcc; /* VER */
	alen = 0;
	switch( buf[3] ){ /* ATYP, common(4)+addr(4)+port(2) has got */
		case 3: alen = 1+buf[4] - 4; break;
		case 4: alen = 16 - 4; break;
	}
	if( siz < rcc+alen ){
		syslog_ERROR("recv_mssg: too long addr (%d %d/%d)\n",
			buf[4],rcc+alen,siz);
		return rcc;
	}
	if( alen )
		rcc1 = Recv(sock,&buf[rcc],alen,0);
	else	rcc1 = 0;
	return rcc + rcc1;
}

static const char *socks_host = NULL;
static int   socks_port = 1080;
static int   socks_sock = -1;

typedef struct {
	int	s_ssock;	/* socket connected by TCP to sockd */
	VSAddr	s_rme;		/* remote UDP port on the sockd */
	int	s_msock;	/* local UDP socket for reception */
	VSAddr	s_me;		/* local UDP port */
} SocksServ;
typedef struct {
	SocksServ se_socksServ[32]; /**/
	int	se_socksServN;
	VSAddr	se_to_socksV[8]; /**/
	int	se_to_socksN;
} Socks5Env;
static Socks5Env *socks5Env;
#define socksServ	socks5Env[0].se_socksServ
#define socksServN	socks5Env[0].se_socksServN
#define to_socksV	socks5Env[0].se_to_socksV
#define to_socksN	socks5Env[0].se_to_socksN
void minit_socks5()
{
	if( socks5Env == 0 ){
		socks5Env = NewStruct(Socks5Env);
	}
}

static int fixed_udp_address = 0;

#define ltob(l,b) {(b)[0]=l>>24;(b)[1]=l>>16;(b)[2]=l>>8;(b)[3]=l;}
#define stob(s,b) {(b)[0]=s>>8; (b)[1]=s;}

#define btol(b)   (((b)[0]<<24)|((b)[1]<<16)|((b)[2]<<8)|(b)[3])
#define btos(b)   (((b)[0]<<8) | (b)[1])

void SOCKS_udpclose(int msock)
{	int si,sj;

	for( si = 0; si < socksServN; si++ )
	if( socksServ[si].s_msock == msock ){
		for( sj = si; sj < socksServN; sj++ )
			socksServ[sj] = socksServ[sj+1];
		socksServN--;
		break;
	}
}

#define AUTH_M_NONE	0 /* NO AUTHENTICATION REQUIRED */
#define AUTH_M_USERPASS	2 /* USERNAME/PASSWORD */
#define AUTH_M_ERROR	0xFF /* NO ACCEPTABLE METHODS */

#define AUTH_R_OK	0
#define AUTH_R_ERR	1

/*
 * declare the socket is a local UDP socket to be used for
 * UDP communication throught the socks server
 */
int SOCKS_udpassocX(DGC*ctx,int msock,VSAddr *me,VSAddr *rme);
int SOCKS_udpassoc(int msock,VSAddr *me,VSAddr *rme)
{
	return SOCKS_udpassocX(NULL,msock,me,rme);
}
int SOCKS_udpassocX(DGC*ctx,int msock,VSAddr *me,VSAddr *rme)
{	int sock;
	CStr(req,512);
	unsigned char resp[512];
	const char *baddr;
	const char *bport;
	int bleng,btype;
	int rcc,ri;
	int rcode;
	VSAddr sab;
	int salen;
	int si;
	SocksServ *ssp;
	int qc;

	if( socks_host == NULL ){
		syslog_ERROR("SocksV5_udpassoc: NO socks.\n");
		return -1;
	}
	for( si = 0; si < socksServN; si++ ){
		if( VSA_comp(&socksServ[si].s_me,me) == 0 ){
			syslog_DEBUG("SocksV5_udpassoc[%d]: already done\n",si);
			ssp = &socksServ[si];
			goto EXIT;
		}
	}

	if( elnumof(socksServ) <= socksServN ){
		return -1;
	}

	ssp = &socksServ[socksServN];
	ssp->s_msock = msock;
	ssp->s_me = *me;

	sock = socket(AF_INET,SOCK_STREAM,0);
	setCloseOnExec(sock);

	ssp->s_ssock = sock;
	salen = VSA_atosa(&sab,socks_port,socks_host);
	syslog_DEBUG("SocksV5_connect [%x]%s:%d ...\n",
		VSA_addr(&sab),socks_host,socks_port);

	if( ctx ){
		CStr(remote,256);
		CStr(local,256);
		int osock;
		strcpy(local,"*:*");
		sprintf(remote,"%s:%d",socks_host,socks_port);
		osock = sock;
		sock = VSocket(ctx,"CNCT/SocksV5",sock,AVStr(local),AVStr(remote),"proto=socks");
		if( 0 <= sock )
			rcode = 0;
		else	rcode = -1;
		if( sock != osock ){
			/* may be replaced with the socket to MASTER */
			close(osock);
		}
	}else
	rcode = connect(sock,(SAP)&sab,salen);

	if( rcode < 0 ){
		syslog_ERROR("SocksV5_udpassoc: connect error\n");
		close(sock);
		return -1;
	}

	req[0] = 5; /* VERSION */
	req[1] = 1; /* leng */
	req[2] = 0; /* NO AUTH */
	Send(sock,req,3,0);
	rcc = Recv(sock,resp,2,0);
	if( rcc < 2 || resp[1] != 0 ){
		syslog_ERROR("SocksV5_udpassoc: AUTH error (V%d %d) rcc=%d\n",
			resp[0],resp[1],rcc);
		close(sock);
		return -1;
	}

	if( fixed_udp_address && VSA_addr(me) == 0 ){
		VSAddr xme;
		int port;
		int addrlen = sizeof(VSAddr);
		getsockname(sock,(SAP)&xme,&addrlen);
		port = VSA_port(me);
		*me = xme;
		VSA_setport(me,port);
	}

	bleng = VSA_decomp(me,&baddr,&btype,&bport);
	qc = 0;
	req[qc++] = 5; /* VERSION */
	req[qc++] = 3; /* CMD = UDP ASSOCIATE */
	req[qc++] = 0; /* reserved */
	req[qc++] = 1; /* ATYP = IP V4 address type */
	bcopy(baddr,&req[qc],bleng); /* DST.ADDR */
	qc += bleng;
	bcopy(bport,&req[qc],2); /* DST.PORT */
	qc += 2;
	Send(sock,req,qc,0);

	rcc = recv_mssg(sock,(char*)resp,sizeof(resp));
	if( rcc < 10 || resp[1] != 0 ){
		syslog_ERROR("SocksV5_udpassoc: UDP ASSOC error(V%d %d)\n",
			resp[0],resp[1]);
		close(sock);
		return -1;
	}

	VSA_stosa(&ssp->s_rme,AF_INET,(char*)&resp[4]);
	syslog_ERROR("SocksV5_udpassoc[%d]: OK (%x:%d/%x:%d)\n",
		socksServN,
		VSA_addr(&ssp->s_rme),VSA_port(&ssp->s_rme),
		VSA_addr(me),VSA_port(me));
	socksServN++;

EXIT:
	if( rme ){
		*rme = ssp->s_rme;
	}
	socks_sock = sock;
	return 0;
}

int SOCKS_Sendto(int sock,PCStr(msg),int len,int flags,VSAddr *to,int tolen)
{	CStr(buf,8*1024);
	int wcc;
	const char *baddr;
	const char *bport;
	int bleng,btype;
	VSAddr me,rme;
	int salen;
	int si;
	int qc;

	for( si = 0; si < socksServN; si++ )
		if( socksServ[si].s_msock == sock ){
			rme = socksServ[si].s_rme;
			break;
		}
	if( socksServN <= si ){
		int len = sizeof(me);
		getsockname(sock,(SAP)&me,&len);
		if( SOCKS_udpassoc(sock,&me,&rme) < 0 )
			return -1;
	}

	bleng = VSA_decomp(to,&baddr,&btype,&bport);

	qc = 0;
	buf[qc++] = 0; /* reserved */
	buf[qc++] = 0; /* reserved */
	buf[qc++] = 0; /* FRAGment number */
	buf[qc++] = 1; /* ATYP = IP V4 address type */
	bcopy(baddr,&buf[qc],bleng); /* DST.ADDR */
	qc += bleng;
	bcopy(bport,&buf[qc],2); /* DST.PORT */
	qc += 2;
	bcopy(msg,&buf[qc],len);

	salen = VSA_size(&rme);
	wcc = Sendto(sock,buf,qc+len,flags,(SAP)&rme,salen);

	syslog_DEBUG("SocksV5_sendto[%d](%x:%d/%x:%d) = %d\n",si,
		VSA_addr(to),VSA_port(to), VSA_addr(&rme),VSA_port(&rme),wcc);

	return wcc - qc;
}
int SOCKS_Recvfrom(int sock,char msg[],int len,int flags,VSAddr *from,int *fromlen)
{	int rcc;
	VSAddr sab;
	int addrlen;

	addrlen = sizeof(VSAddr);
	rcc = Recvfrom(sock,msg,len,flags,(SAP)&sab,&addrlen);
	if( rcc <= 0 )
		return rcc;
	if( msg[0] != 0 || msg[1] != 0 )
		return rcc;

	*fromlen = VSA_stosa(from,AF_INET,&msg[4]);
	syslog_DEBUG("SocksV5_recvfrom(%x:%d/%x:%d) = %d\n",
		VSA_addr(from),VSA_port(from),
		VSA_addr(&sab),VSA_port(&sab),rcc);

	bcopy(10+msg,msg,rcc-10);
	return rcc - 10;
}


void SOCKS_addserv(PCStr(dhost),int dport,PCStr(shost),int sport)
{	VSAddr *to;
	int si;

	socks_host = stralloc(shost);
	socks_port = sport;
	if( strcmp(dhost,"*") == 0 )
		dhost = "255.255.255.255"; /* use it for wild card */
	else{
		if( !VSA_strisaddr(dhost) ){
			syslog_ERROR("SocksV5_addrserv(%s) host ERROR\n",dhost);
			return; 
		}
	}
	if( elnumof(to_socksV) <= to_socksN ){
		return;
	}
	to = &to_socksV[to_socksN];
	VSA_atosa(to,dport,dhost);
	for( si = 0; si < to_socksN; si++ ){
		if( VSA_comp(to,&to_socksV[si]) == 0 ){
			return;
		}
	}
	syslog_DEBUG("SocksV5_addrserv[%d](%x/%s:%d,%s:%d)\n",
		to_socksN,VSA_addr(to),dhost,dport,shost,sport);
	to_socksN++;
}
int SOCKS_via_socks(VSAddr *dist)
{	int ni;
	VSAddr *can1;

	for( ni = 0; ni < to_socksN; ni++ ){
		can1 = &to_socksV[ni];
		if( VSA_addr(can1) == -1 )
			return 1; /* "host=*" (255.255.255.255) */
		if( VSA_comp(can1,dist) == 0 )
			return 1;
	}
	return 0;
}
static int UDPviaSocks(PCStr(host))
{
	if( host == 0 )
		return 0;
	if( !VSA_strisaddr(host) ) /* can be -.- */
		return 0;
	return 1;
}
int SOCKS_sendto(int sock,PCStr(buf),int len,int flags,SAP to,int tolen)
{
	/*
	if( socks_host && SOCKS_via_socks(to) )
	*/
	if( UDPviaSocks(socks_host) && SOCKS_via_socks((VSAddr*)to) )
		return SOCKS_Sendto(sock,buf,len,flags,(VSAddr*)to,tolen);
	else	return       Sendto(sock,buf,len,flags,to,tolen);
}
int SOCKS_recvfrom(int sock,char buf[],int len,int flags,SAP from,int *fromlen)
{
	/*
	if( socks_host )
	*/
	if( UDPviaSocks(socks_host) )
		return SOCKS_Recvfrom(sock,buf,len,flags,(VSAddr*)from,fromlen);
	else	return       Recvfrom(sock,buf,len,flags,from,fromlen);
}


int SOCKS_recvResponseV5(int sock,int command,PVStr(rhost),int *rport);
int SOCKS_startV5(int sock,int command,PCStr(host),int port,PCStr(user),PCStr(pass),PVStr(rhost),int *rport)
{	CStr(qbuf,512);
	unsigned char rbuf[512];
	int qcc,rcc,wcc;
	int ulen,plen;
	int nlen;
	const char *hp;
	VSAddr sab;
	const char *baddr;
	int bleng,btype;
	int qauth,rauth;

errno = 0;

	if( pass != NULL )
		qauth = AUTH_M_USERPASS;
	else	qauth = AUTH_M_NONE;

	qbuf[0] = 5;
	qbuf[1] = 1;
	qbuf[2] = qauth;
	rbuf[0] = rbuf[1] = 0;

	wcc = Send(sock,qbuf,3,0);
	rcc = Recv(sock,rbuf,2,0);
	rauth = rbuf[1];

	if( 1 < rcc && rauth == 4 )
		return 4;

	if( rcc < 2 || rauth != qauth && rauth != AUTH_M_NONE ){
		syslog_ERROR("SocksV5_start: AUTH error (V%d %d) %d,errno=%d\n",
			rbuf[0],rbuf[1],rcc,errno);
		return -1;
	}

	if( rauth == AUTH_M_USERPASS ){
		ulen = strlen(user);
		plen = strlen(pass);
		qcc = 0;
		qbuf[qcc++] = 1;
		qbuf[qcc++] = ulen; Xstrcpy(DVStr(qbuf,qcc),user); qcc += ulen;
		qbuf[qcc++] = plen; Xstrcpy(DVStr(qbuf,qcc),pass); qcc += plen;
		wcc = Send(sock,qbuf,qcc,0);
		rcc = Recv(sock,rbuf,2,0);
		syslog_ERROR("SocksV5_start: %d VER[%d] AUTH-STATUS[%d]\n",
			rcc,rbuf[0],rbuf[1]);
		if( rbuf[1] != 0 ){
			return -1;
		}
	}

	qcc = 0;
	qbuf[qcc++] = 5; /* VERSION */
	qbuf[qcc++] = command; /**//* CMD = CONNECT:1,BIND:2 */
	qbuf[qcc++] = 0; /* reserved */
	if( VSA_strisaddr(host) ){
		VSA_atosa(&sab,0,host);
		bleng = VSA_decomp(&sab,&baddr,&btype,NULL);
		qbuf[qcc++] = 1; /* ATYP = IP V4 address type */
		bcopy(baddr,&qbuf[qcc],bleng); /* DST.ADDR */
		qcc += bleng;
	}else{
		qbuf[qcc++] = 3; /* ATYP = host name */
		nlen = strlen(host);
		qbuf[qcc++] = nlen;
		Xstrcpy(DVStr(qbuf,qcc),host);
		qcc += nlen;
	}
	stob(port,&qbuf[qcc]); qcc += 2; /* DST.PORT */
	wcc = Send(sock,qbuf,qcc,0);
	return SOCKS_recvResponseV5(sock,command,AVStr(rhost),rport);
}

int SOCKS_recvResponseV5(int sock,int command,PVStr(rhost),int *rport)
{	int rcc;
	int addr,port;
	unsigned char rbuf[512];
	int ratyp;

	rbuf[0] = rbuf[1] = 0;
	rcc = recv_mssg(sock,(char*)rbuf,sizeof(rbuf));
	if( rcc < 10 || rbuf[1] != 0 ){
		syslog_ERROR("SocksV5_resp: cmd=%d error=%x rcc=%d\n",
			command,rbuf[1],rcc);
		return -1;
	}

	ratyp = rbuf[3];
	if( ratyp == 1 ){
		addr = btol(&rbuf[4]);
		port = btos(&rbuf[8]);
		if( rhost ) sprintf(rhost,"%d.%d.%d.%d",
				rbuf[4],rbuf[5],rbuf[6],rbuf[7]);
		if( rport ) *rport = port;
	}else{
		addr = -1;
		port = 0;
		if( rhost ) sprintf(rhost,"255.255.255.255");
		if( rport ) *rport = port;
	}

	syslog_ERROR("[SocksV5-clnt] start: OK CMD=%d ATYP=%d %x:%d\n",
		command,ratyp,addr,port);
	return 0;
}

#define F_USECLIENTSPORT 0x4 /* share a UDP port between client and server */
int SOCKS_QFLAGS = F_USECLIENTSPORT;

#define Q_VER		qbuf[0]
#define Q_NMETHODS	qbuf[1]
#define Q_METHODS	&qbuf[2]
#define Q_CMD		qbuf[1]
#define Q_RSV		qbuf[2]
#define Q_ATYP		qbuf[3]
#define Q_HOST		&qbuf[4]

#define S_CNTL	0
#define S_CLNT	1
#define S_SERV	2

static int udp_relay_socks(DGC*ctx,int cntlsock,int clsock,PCStr(clname),int flags,VSAddr *viaSocks)
{	CStr(clhost,256);
	int clport;
	unsigned char rbuf[8*1024];
	unsigned char *data; /**/
	int svsock;
	int rcc,wcc;
	int sockV[3],sockR[3],sentN[3],xi;
	int ns;
	VSAddr clnt,from,to;
	VSAddr serv;
	const char *baddr;
	const char *bport;
	int btype,bleng,clntleng;
	int len,fromlen,tolen;
	int nready;
	CStr(froms,256);
	int qc;
	int pi;

	clhost[0] = 0;
	clport = 0;
	Xsscanf(clname,"%[^:]:%d",AVStr(clhost),&clport);
	if( clport != 0 && strcmp(clhost,"0.0.0.0") == 0 ){
		CStr(local,256);
		CStr(remote,256);
		CStr(options,256);
		*local = *remote = 0;
		VSocket(ctx,"Q/SocksV5",cntlsock,AVStr(local),AVStr(remote),options);
		wordscanY(remote,AVStr(clhost),sizeof(clhost),"^:");
	}
	if( clhost[0] == 0 )
		strcpy(clhost,"0.0.0.0");
	VSA_atosa(&clnt,clport,clhost);

	sockV[S_CNTL] = cntlsock;
	sockV[S_CLNT] = clsock;

	if( (flags | SOCKS_QFLAGS) & F_USECLIENTSPORT ){
		/*
		 * this is bad when the socket for the client is bound to
		 * an interface which is not reachable to the server...
		 */
		svsock = clsock;
		ns = 2;
	}else{
		CStr(local,256);
		strcpy(local,"*:*");
		svsock = VSocket(ctx,"BIND/SocksV5",-1,AVStr(local),CVStr("*:*"),"protocol=udp");
		ns = 3;
	}
	sockV[S_SERV] = svsock;

	if( viaSocks ){
		int xcode;
		if( SOCKS_udpassocX(ctx,svsock,viaSocks,&serv) < 0 )
			return -1;
		/*
		xcode = connect(svsock,(SAP)&serv,VSA_size(&serv));
		*/
	}

	if( flags != 0 )
		syslog_ERROR("UDP/SocksV5 flags=%X\n",flags);

	for( xi = 0; xi < 3; xi++ )
		sentN[xi] = 0;

	data = &rbuf[10];
	len = sizeof(rbuf) - 10;

	for( pi = 0; ; pi++ ){
	    nready = PollIns(0,ns,sockV,sockR);
	    if( nready <= 0 ){
		syslog_ERROR("UDP/SocksV5 POLL ERROR (%d)\n",errno);
		break;
	    }
	    if( 0 < sockR[S_CNTL] ){
		syslog_ERROR("UDP/SocksV5 GOT CONTROL\n");
		break;
	    }
	    if( 0 < sockR[S_CLNT] ){
		fromlen = sizeof(VSAddr);
		rcc = Recvfrom(clsock,rbuf,sizeof(rbuf),0,(SAP)&from,&fromlen);
	sprintf(froms,"%s:%d",VSA_ntoa(&from),VSA_port(&from));

		if( VSA_addr(&clnt) == 0
		 || pi == 0 && rbuf[0] == 0 && rbuf[1] == 0
		){
			if( clport = VSA_port(&clnt) )
			if( VSA_port(&from) != clport )
			    syslog_ERROR("## BAD PORT ? %d != %d\n",
				VSA_port(&from),clport);
			clnt = from;
			syslog_ERROR("UDP/SocksV5 C-S client set < %s\n",froms);
		}else
		if( VSA_comp(&clnt,&from) != 0 ){
			if( ns == 2 /* USECLIENTPORT */
			 || rbuf[0] != 0 || rbuf[1] != 0 /* nonSOCKSUDP pack */
			){
				bcopy(rbuf,data,rcc);
				goto SV2CL;
			}
			syslog_ERROR("## BAD CLIENT: %s %s\n",froms,clname);
			continue;
		}
		if( viaSocks ){ /* relay SOCKS packet as is */
			tolen = VSA_size(&serv);
			wcc = Sendto(svsock,rbuf,rcc,0,(SAP)&serv,tolen);
			if( sentN[S_CLNT] == 0 ){
				syslog_ERROR("C-S forw %d/%d > %s:%d\n",
				wcc,rcc,VSA_ntoa(&serv),VSA_port(&serv));
			}
			sentN[S_CLNT] += wcc;
			continue;
		}
		tolen = VSA_stosa(&to,AF_INET,(char*)&rbuf[4]);
		syslog_ERROR("UDP/SocksV5 C-S %d ATYP[%d] > %s:%d\n",
			rcc,rbuf[3],VSA_ntoa(&to),VSA_port(&to));
		wcc = Sendto(svsock,data,rcc-10,0,(SAP)&to,tolen);
		sentN[S_CLNT] += wcc;
	    }

	if( 2 < ns )
	    if( 0 < sockR[S_SERV] ){
		fromlen = sizeof(VSAddr);
		rcc = Recvfrom(svsock,data,len,0,(SAP)&from,&fromlen);
	SV2CL:
		if( viaSocks ){ /* relay SOCKS packet as is */
			clntleng = VSA_size(&clnt);
			wcc = Sendto(clsock,data,rcc,0,(SAP)&clnt,clntleng);
			if( sentN[S_SERV] == 0 ){
				syslog_ERROR("S-C forw %d/%d > %s:%d\n",
				wcc,rcc,VSA_ntoa(&clnt),VSA_port(&clnt));
			}
			sentN[S_SERV] += rcc;
			continue;
		}
		bleng = VSA_decomp(&from,&baddr,&btype,&bport);
		syslog_DEBUG("UDP/SocksV5 S-C %d < %s:%d\n",rcc,
			VSA_ntoa(&from),VSA_port(&from));
		qc = 0;
		rbuf[qc++] = 0;
		rbuf[qc++] = 0;
		rbuf[qc++] = 0; /* FRAGment not suppported */
		rbuf[qc++] = 1; /* IPv4 */
		bcopy(baddr,&rbuf[qc],bleng);
		qc += bleng;
		bcopy(bport,&rbuf[qc],2);
		qc += 2;
		clntleng = VSA_size(&clnt);
		wcc = Sendto(clsock,rbuf,qc+rcc,0,(SAP)&clnt,clntleng);
		sentN[S_SERV] += rcc;
	    }
	}
	syslog_ERROR("UDP/SocksV5 C-S:%d S-C:%d\n",
		sentN[S_CLNT],sentN[S_SERV]);
	if( viaSocks ){
		SOCKS_udpclose(svsock);
	}
	return 0;
}

static void send_resp(FILE *tc,int rep,PCStr(bound))
{	CStr(rbuf,512);
	CStr(bhost,256);
	const char *bp;
	const char *baddr;
	int btype,bleng;
	int port;
	int rcc,hlen;
	VSAddr sab;

	rbuf[0] = 5;
	rbuf[1] = rep;
	rbuf[2] = 0; /* RSV */
	rcc = 3;

	strcpy(bhost,bound);
	if( bp = strrchr(bhost,':') ){
		truncVStr(bp); bp++;
		port = atoi(bp);
	}else	port = -1;
	if( VSA_strisaddr(bhost) ){
		VSA_atosa(&sab,port,bhost);
		bleng = VSA_decomp(&sab,&baddr,&btype,NULL);
		rbuf[rcc++] = 1; /* IPv4 */
		bcopy(baddr,&rbuf[rcc],bleng);
		rcc += bleng;
	}else{
		rbuf[rcc++] = 3; /* DOMAINNAME */
		rbuf[rcc++] = hlen = strlen(bhost);
		bcopy(bhost,&rbuf[rcc],hlen);
rcc += hlen;
	}
	stob(port,&rbuf[rcc]);
	rcc += 2;
	fwrite(rbuf,1,rcc,tc);
	fflush(tc);

	syslog_ERROR("[SocksV5-serv] resp %d [%s]\n",rep,bound);
}
int SOCKS_serverV5(DGC*ctx,int fromcl,int tocl,int timeout_ms)
{	FILE *fc,*tc;
	unsigned char qbuf[512];
	unsigned char rbuf[512];
	const unsigned char *qh;
	CStr(host,256);
	int aleng,port,rep;
	int svsock,bsock;
	CStr(remote,256);
	CStr(local,256);
	const char *bound;
	int qauth,rauth;
	int ai;
	CStr(rhost,256);
	int rport,viasocks;
	VSAddr qp;
	const char *opt;

	bound = "";
	fc = fdopen(fromcl,"r");
	tc = fdopen(tocl,"w");
	Q_VER = getc(fc);
	Q_NMETHODS = getc(fc);
	qbuf[2] = qbuf[3] = 0;
	fread(Q_METHODS,1,Q_NMETHODS,fc);
	qauth = qbuf[2];
	syslog_ERROR("[SocksV5-serv] VER[%x] NMETHODS[%d] [%x][%x]\n",
		Q_VER,Q_NMETHODS,qbuf[2],qbuf[3]);

	rauth = AUTH_M_NONE;
	if( CTX_auth(ctx,NULL,NULL) ){
		rauth = AUTH_M_ERROR;
		for( ai = 0; ai < Q_NMETHODS; ai++ ){
			if( (Q_METHODS)[ai] == AUTH_M_USERPASS ){
				rauth = AUTH_M_USERPASS;
				break;
			}
		}
	}
	rbuf[0] = 5;
	rbuf[1] = rauth;
	fwrite(rbuf,1,2,tc);
	fflush(tc);

	if( rauth == AUTH_M_ERROR ){
		syslog_ERROR("[SocksV5-serv] WITH AUTHORIZER, NO METHOD\n");
		return -1;
	}

	if( rauth == AUTH_M_USERPASS ){
		unsigned int ver,ulen,plen;
		CStr(user,256);
		CStr(pass,256);
		int rcode;
		int rcc;

		ver = getc(fc);
		ulen = getc(fc);
		if( ulen < 0 || sizeof(user) <= ulen ) rcc = -1; else
		if( ulen == 0 ) rcc = 0; else
		rcc = fread(user,1,ulen,fc);
		/*
		if( ver == EOF || ulen == EOF || rcc <= 0 ){
		*/
		if( ver == EOF || ulen == EOF || rcc < ulen ){
			syslog_ERROR("EOF in user [%d %d %d]\n",ver,ulen,rcc);
			goto ERREXIT;
		}
		user[ulen] = 0;
		plen = getc(fc);
		if( plen < 0 || sizeof(pass) <= plen ) rcc = -1; else
		if( plen == 0 ) rcc = 0; else
		rcc = fread(pass,1,plen,fc);
		/*
		if( plen == EOF || rcc <= 0 ){
		*/
		if( plen == EOF || rcc < plen ){
			syslog_ERROR("EOF in pass [%d %d]\n",plen,rcc);
			goto ERREXIT;
		}
		pass[plen] = 0;

		rcode = CTX_auth(ctx,user,pass);
		syslog_ERROR("[SocksV5-serv] auth USER:[%s] PASS:*%d => %d\n",
			user,plen,rcode);

		rbuf[0] = 1;
		if( rcode < 0 )
			rbuf[1] = AUTH_R_ERR;
		else	rbuf[1] = AUTH_R_OK;
		fwrite(rbuf,1,2,tc);
		fflush(tc);

		if( rcode < 0 )
			return -1;
	}

	rep = 0;
	svsock = -1;
	bound = "";
	Q_VER = getc(fc);
	Q_CMD = getc(fc);
	Q_RSV = getc(fc);
	Q_ATYP = getc(fc);
	*(Q_HOST) = 0;
	aleng = 0;
	switch( Q_ATYP ){
		case 1: aleng = 4; break; /* IPv4 */
		case 3: aleng = getc(fc); break; /* DOMAIN NAME */
		case 4: aleng = 16; break; /* IPv6 */ break;
	}
	if( 0 < aleng )
		fread(Q_HOST,1,aleng,fc);
	qh = Q_HOST;
	switch( Q_ATYP ){
		case 1: sprintf(host,"%d.%d.%d.%d",qh[0],qh[1],qh[2],qh[3]);
			break;
		case 3: QStrncpy(host,(char*)qh,aleng+1); break;
		case 4: host[0] = 0; rep = 0x08; break;
		default: host[0] = 0; break;
	}
	port = (getc(fc) << 8) | getc(fc);
	syslog_ERROR("[SocksV5-serv] VER[%x] CMD[%x] ATYP[%x] %s:%d\n",
		Q_VER,Q_CMD,Q_ATYP,host,port);

	strcpy(local,"*:*");
	sprintf(remote,"%s:%d",host,port);

	switch( Q_CMD ){
	    case 1: /* CONNECT */

/* MUST CHECK access right to remote */

		svsock = VSocket(ctx,"CNCT/SocksV5",-1,AVStr(local),AVStr(remote),"");
		if( svsock < 0 ){ rep = 0x01; goto ERREXIT; }
		send_resp(tc,rep,bound=local);
/*
		tcp_relay2(timeout_ms,fromcl,svsock,svsock,tocl);
*/
		tcp_relay2(timeout_ms,fromcl,CTX_ToS(ctx),CTX_FromS(ctx),tocl);
		if( CTX_ToS(ctx) != svsock ) close(CTX_ToS(ctx));
		if( CTX_FromS(ctx) != svsock ) close(CTX_FromS(ctx));
		close(svsock);
		break;

	    case 2: /* BIND */
		viasocks = 0;
		if( GetViaSocks(ctx,host,port) ){
			/*
			syslog_ERROR("#### MUST DO bindViaSocks... %s:%d\n",
				host,port);
			*/
			bsock = bindViaSocks(ctx,host,port,AVStr(rhost),&rport);
			if( bsock < 0 ){
				syslog_ERROR("##bindViaSocks(%s) ERROR\n",
					remote);
			}else{
				viasocks = 1;
				sprintf(local,"%s:%d",rhost,rport);
				syslog_ERROR("##bindViaSocks(%s)=%d [%s]\n",
					remote,bsock,local);
			}
		}
		else
		{
		/*
		 * local port must be derived from DST.PORT, in new protocol ?
		 */
		bsock = VSocket(ctx,"BIND/SocksV5",-1,AVStr(local),AVStr(remote),"listen=1");
		}
		if( bsock < 0 ){ rep = 0x01; goto ERREXIT; }
		send_resp(tc,rep,bound=local);

/* MUST POLL {fromcl,bsock} */

		if( viasocks ){
			if( acceptViaSocks(bsock,AVStr(rhost),&rport) < 0 ){
				svsock = -1;
				syslog_ERROR("##acceptViaSocks() ERROR\n");
			}else{
				svsock = bsock;
				sprintf(remote,"%s:%d",rhost,rport);
				syslog_ERROR("##acceptViaSocks() = [%s]\n",
					remote);
			}
		}else{
		svsock = VSocket(ctx,"ACPT/SocksV5",bsock,AVStr(local),AVStr(remote),"");
		close(bsock);
		}
		if( svsock < 0 ){ rep = 0x01; goto ERREXIT; }

		send_resp(tc,rep,bound=remote);
		tcp_relay2(timeout_ms,fromcl,svsock,svsock,tocl);
		close(svsock);
		break;

	    case 3: /* UDP ASSOCIATE */
		bsock = -1;
		opt = "protocol=udp,noreuseaddr";
		if( viasocks = GetViaSocks(ctx,host,port) ){
			syslog_ERROR("UDP ASSOC via upstream Socks: %s:%d\n",
				host,port);
			VSA_atosa(&qp,port,host);
		}
		if( bsock < 0 && port != 0 ){
			sprintf(local,"%s:%d",host,port);
			bsock = VSocket(ctx,"BIND/SocksV5",-1,AVStr(local),CVStr("*:*"),opt);
		}
		if( bsock < 0 && port != 0 ){
			sprintf(local,"%s:*",host);
			bsock = VSocket(ctx,"BIND/SocksV5",-1,AVStr(local),CVStr("*:*"),opt);
		}
		if( bsock < 0 ){
			sprintf(local,"*:*");
			bsock = VSocket(ctx,"BIND/SocksV5",-1,AVStr(local),AVStr(remote),opt);
			/* BUG: binding local=127.0.0.1:N for
			 * remote=0.0.0.0:0 by hostIFfor() is bad
			 */
		}
		if( bsock < 0 ){ rep = 0x01; goto ERREXIT; }
		if( strncmp(local,"0.0.0.0:",8) == 0 ){
			CStr(clifhp,256);
			CStr(dummy,256);
			CStr(options,256);
			int port;
			port = atoi(local+8);
			*clifhp = *dummy = 0;
			VSocket(ctx,"Q/SocksV5",fromcl,AVStr(clifhp),AVStr(dummy),options);
			wordscanY(clifhp,AVStr(host),sizeof(host),"^:");
			sprintf(local,"%s:%d",host,port);
		}
		send_resp(tc,rep,bound=local);
		udp_relay_socks(ctx,fromcl,bsock,remote,Q_RSV,viasocks?&qp:0);
		close(bsock);
		if( 0 <= socks_sock ){
			close(socks_sock);
			socks_sock = -1;
		}
		break;

	    default:
		syslog_ERROR("## Command not supported: %x\n",Q_CMD);
		rep = 0x07;
		goto ERREXIT;
	}
	return 0;

ERREXIT:
	send_resp(tc,rep,bound);
	return -1;
}


int RecvFrom(int sock,char buf[],int len,PVStr(froma),int *fromp)
{	VSAddr from;
	int rcc,fromlen;

	fromlen = sizeof(from);
	rcc = SOCKS_recvfrom(sock,buf,len,0,(SAP)&from,&fromlen);
	strcpy(froma,VSA_ntoa(&from));
	*fromp = VSA_port(&from);
	return rcc;
}
int SendTo(int sock,PCStr(buf),int len,PCStr(host),int port)
{	VSAddr to;
	int tolen;

	tolen = VSA_atosa(&to,port,host);
	return SOCKS_sendto(sock,buf,len,0,(SAP)&to,tolen);
}
