/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1995 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	strid.c (NNTP proxy)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	951211	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include "ystring.h"

static struct { defQStr(gnstrbuff); } gnstrbuff;
static int gnstrsize;
static int gnstridx;
static int gnstrtotal;
static int gnstrrem;
static char *newStr(PCStr(group))
{	int len;
	defQStr(strp); /*alloc*//**/

	len = strlen(group) + 1;
	if( gnstrsize <= gnstridx+len ){
		gnstrrem += gnstrsize - gnstridx;
		gnstrsize = 0x8000;
		setQStr(gnstrbuff.gnstrbuff,(char*)StructAlloc(gnstrsize),gnstrsize);
		gnstridx = 0;
		gnstrtotal += gnstrsize;
	}
	strp = (char*)&gnstrbuff.gnstrbuff[gnstridx];
	Xstrcpy(QVStr(strp,gnstrbuff.gnstrbuff),group);
	gnstridx += len;
	return (char*)strp;
}
static int s_new,s_full,s_dup,s_uni;

void strid_stat(int tab)
{
	syslog_DEBUG("Strid NEW:%d FULL:%d UNI:%d DUP:%d\n",
		s_new,s_full,s_uni,s_dup);
}

#define NULLVAL	((char*)-1)

int strid_create(int nelem)
{	int htid;

	htid = Hcreate(nelem,NULLVAL);
	return htid;
}
int strid(int tab,PCStr(str),int id)
{	const char *sid;

	if( tab <= 0 )
		return id;

	sid = Hsearch(tab,str,NULLVAL);
	if( sid != NULLVAL ){
		if( (int)sid == id )
			s_uni++;
		else	s_dup++;
		return (int)sid;
	}
	if( Hsearch(tab,newStr(str),(char*)id) != NULLVAL )
		s_new++;
	else	s_full++;

	return id;
}
int strid_next(int tab,int hx,const char **strp,int *idp)
{
	return Hnext(tab,hx,strp,(const char**)idp);
}
const char *strid_find(int tab,int hx,int id)
{	int nhx,id1;
	const char *str;

	for( hx = 0; ; hx = nhx ){
		nhx = strid_next(tab,hx,&str,&id1);
		if( nhx < 0 )
			break;
		if( str == NULL )
			break;
		if( id1 == id ){
			return str;
		}
	}
	return 0;
}
