/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1999 Electrotechnical Laboratry (ETL), AIST, MITI
Copyright (c) 1999 Yutaka Sato

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	ins.c (INET socket)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	991112	extracted from inets.c, nbio.c
//////////////////////////////////////////////////////////////////////#*/
#include <errno.h>
#include <stdio.h>
#include "ystring.h"
#include "vsocket.h"

typedef struct sockaddr_in SIN;
typedef struct sockaddr_un SUN;
typedef struct sockaddr SA;

int VSA_port(VSAddr *sap);
int VSA_decomp(VSAddr *sap,const char **baddr,int *btype,const char **bport);
void path2hostlocal(PCStr(path),PVStr(host),int size);

int sock_isconnected(int sock){
	int len;
	VSAddr sin;

	len = sizeof(sin);
	if( getpeername(sock,(SAP)&sin,&len) == 0 )
	if( len == sizeof(SIN) )
	{
		if( VSA_port(&sin) != 0 )
			return 1;
	}
	return 0;
}

static const char VSA_afunixdom[] = ".af-local";
static const char VSA_afunixaddr[] = "127.0.0.127";
int VSA_afunixport = 0xFFFF;

const char *VSA_afunixroot = 0;  /* can be like "/tmp" */
const char *VSA_hostlocal(){ return VSA_afunixdom; }
const char *VSA_hostlocaladdr(){ return VSA_afunixaddr; }
int VSA_hostlocalport(){ return VSA_afunixport; }

int VSA_afunix(VSAddr *sap,PVStr(host),int size)
{	SUN *sup;

	sup = (SUN*)sap;
	if( sup->sun_family != AF_UNIX )
		return 0;

	if( host != NULL ){
		path2hostlocal(sup->sun_path,BVStr(host),size);
		syslog_DEBUG("#### [%s]<-[%s]\n",host,sup->sun_path);
	}
	return 1;
}
void path2hostlocal(PCStr(path),PVStr(host),int size)
{	const char *sp;
	refQStr(dp,host); /**/
	CStr(buf,256);
	const char *root;

	sp = path;
	if( root = VSA_afunixroot ){
		if( strncmp(sp,root,strlen(root)) == 0 )
			sp += strlen(root);
	}
	if( *sp == '/' )
		sp++;
	reverseDomainX(sp,AVStr(buf),'/',"/");
	for( sp =  buf; *sp; sp++ ){
		assertVStr(host,dp+1);
		if( *sp == '/' )
			setVStrPtrInc(dp,'.');
		else
		if( *sp == '.' ){
			setVStrPtrInc(dp,'.');
			setVStrPtrInc(dp,'.');
		}else{
			setVStrPtrInc(dp,*sp);
		}
	}
	setVStrEnd(dp,0);
	wordscanX(VSA_afunixdom,TVStr(host),size-strlen(host));
}
int hostlocal2path(PCStr(host),PVStr(path),int size)
{	const char *sp;
	CStr(buf,256);
	refQStr(dp,buf); /**/
	const char *xp = &buf[sizeof(buf)-1];
	char ch;

	if( host == NULL )
		return 0;
	if( strtailstr(host,VSA_afunixdom) == NULL )
		return 0;

	wordscanX(host,BVStr(path),size);
	strtailstr(path,VSA_afunixdom)[1] = 0;
	for( sp = path; ch = *sp; sp++ ){
		if( xp <= dp ){
			break;
		}
		if( ch == '.' ){
			if( sp[1] == '.' )
				sp++;
			else	ch = '/';
		}
		setVStrPtrInc(dp,ch);
	}
	setVStrEnd(dp,0);
	reverseDomainX(buf,BVStr(path),'/',"/");

	if( VSA_afunixroot )
		Strins(BVStr(path),VSA_afunixroot);

	syslog_DEBUG("#### [%s]->[%s]\n",host,path);
	return 1;
}

int VSA_addrisANY(VSAddr *sap)
{	SIN *sip;

	sip = (SIN*)sap;
	return sip->sin_addr.s_addr == INADDR_ANY;
}
int VSA_addr(VSAddr *sap)
{	SIN *sip;
	SUN *sup;

	sup = (SUN*)sap;
	if( sup->sun_family == AF_UNIX )
		return inet_addr(VSA_afunixaddr);

	sip = (SIN*)sap;
	return ntohl(sip->sin_addr.s_addr);
}
const char *VSA_ntoa(VSAddr *sap)
{	SIN *sip;
	const char *addr;
	SUN *sup;

	sup = (SUN*)sap;
	if( sup->sun_family == AF_UNIX )
		return VSA_afunixaddr;

	sip = (SIN*)sap;
	addr = inet_ntoa(sip->sin_addr);
	return addr;
}
const char *VSA_htoa(struct hostent *hp)
{	SIN sin;

	sin.sin_family = hp->h_addrtype;
	bcopy(hp->h_addr,&sin.sin_addr,hp->h_length);
	return VSA_ntoa((VSAddr*)&sin);
}
const char *VSA_ltoa(unsigned char *baddr,int len,int type)
{	SIN sin;

	sin.sin_family = type;
	bcopy(baddr,&sin.sin_addr,len);
	return VSA_ntoa((VSAddr*)&sin);
}
int VSA_port(VSAddr *sap)
{	SIN *sip;
	SUN *sup;

	sup = (SUN*)sap;
	if( sup->sun_family == AF_UNIX )
		return VSA_afunixport;

	sip = (SIN*)sap;
	return ntohs(sip->sin_port);
}
char *VSA_xtoap(VSAddr *sa,PVStr(buf),int siz)
{
	sprintf(buf,"%s:%d",VSA_ntoa(sa),VSA_port(sa));
	return (char*)buf;
}
int VSA_strisaddr(PCStr(addr))
{
	/*
	if( inet_addr(addr) != -1 )
	*/
	struct in_addr ina;
	if( inet_aton(addr,&ina) )
		return 1;
	return 0;
}
int VSA_isaddr(VSAddr *sap)
{	SIN *sip;

	sip = (SIN*)sap;
	if( sip->sin_family == AF_INET )
		return sip->sin_addr.s_addr != -1;
	return 0;
}
int VSA_stosa(VSAddr *sap,int atype,PCStr(socks))
{	SIN *sip;

	sip = (SIN*)sap;
	bzero(sip,sizeof(SIN));
	sip->sin_family = atype;
	bcopy(socks,&sip->sin_addr,4);
	bcopy(socks+4,&sip->sin_port,2);
	return sizeof(SIN);
}
int VSA_btosa(VSAddr *sap,int atype,unsigned char *baddr,int port)
{	SIN *sip;

	sip = (SIN*)sap;
	bzero(sip,sizeof(SIN));
	sip->sin_family = atype;
	bcopy(baddr,&sip->sin_addr,4);
	sip->sin_port = htons(port);
	return sizeof(SIN);
}
void VSA_setport(VSAddr *sap,int port)
{	SIN *sip;
	SUN *sup;

	sup = (SUN*)sap;
	if( sup->sun_family == AF_UNIX )
		return;

	sip = (SIN*)sap;
	sip->sin_port = htons(port);
}
int VSA_atosa(VSAddr *sa,int port,PCStr(addr))
{	SIN *sip;

	sip = (SIN*)sa;
	bzero(sip,sizeof(SIN));
	sip->sin_family = AF_INET;
	if( addr == NULL ){
		syslog_ERROR("#### ERROR VSA_atosa(addr=NULL)\n");
		sip->sin_addr.s_addr = INADDR_None;
	}else	sip->sin_addr.s_addr = inet_addrV4(addr); 
	sip->sin_port = htons(port);
	return sizeof(SIN);
}
int VSA_htosa(VSAddr *sap,int port,struct hostent *hp,int hi)
{	SIN *sip;
	const char *baddr;

	sip = (SIN*)sap;
	bzero(sip,sizeof(SIN));
	sip->sin_family = hp->h_addrtype;
	baddr = hp->h_addr_list[hi];
	bcopy(baddr,&sip->sin_addr,hp->h_length);
	sip->sin_port = htons(port);
	return sizeof(SIN);
}
int VSA_size(VSAddr *sap)
{	SIN *sip;

	return sizeof(SIN);
}
int VSA_atob(PCStr(aaddr),char baddrb[],int *btypep)
{	VSAddr Addr;
	const char *baddr;
	int bleng;

	bzero(&Addr,sizeof(Addr));
	VSA_atosa(&Addr,0,aaddr);
	bleng = VSA_decomp(&Addr,&baddr,btypep,NULL);
	bcopy(baddr,baddrb,bleng);
	return bleng;
}
int VSA_decomp(VSAddr *sap,const char **baddr,int *btype,const char **bport)
{	SIN *sip;

	sip = (SIN*)sap;
	if(btype) *btype = sip->sin_family;
	if(baddr) *baddr = (char*)&sip->sin_addr;
	if(bport) *bport = (char*)&sip->sin_port;
	return 4;
}
void VSA_prftp(VSAddr *sap,PVStr(mport))
{	SIN *sip;
	const unsigned char *sa;
	const unsigned char *sp; 
	SUN *sup;

	sup = (SUN*)sap;
	if( sup->sun_family == AF_UNIX ){
		sprintf(mport,"%s:%d",VSA_afunixaddr,VSA_afunixport);
		return;
	}

	sip = (SIN*)sap;
	sa = (unsigned char*)&sip->sin_addr.s_addr;
	sp = (unsigned char*)&sip->sin_port;
	sprintf(mport,"%d,%d,%d,%d,%d,%d",sa[0],sa[1],sa[2],sa[3],sp[0],sp[1]);
}
void VSA_ftptosa(void *sap,PCStr(port))
{	SIN *sip;
	unsigned char *sa; /**/
	unsigned char *sp; /**/
	int ia[4],ip[2];

	sip = (SIN*)sap;
	bzero(sip,sizeof(SIN));
	sip->sin_family = AF_INET;
	sscanf(port,"%d,%d,%d,%d,%d,%d",&ia[0],&ia[1],&ia[2],&ia[3],&ip[0],&ip[1]);
	sa = (unsigned char*)&sip->sin_addr;
	sp = (unsigned char*)&sip->sin_port;
	sa[0] = ia[0]; sa[1] = ia[1]; sa[2] = ia[2]; sa[3] = ia[3];
	sp[0] = ip[0]; sp[1] = ip[1];
}
int VSA_dnstosa(void *sap,int port,PCStr(revaddr))
{	SIN *sip;
	int ip[4];
	char *bp; /**/

	sip = (SIN*)sap;
	if( sscanf(revaddr,"%d.%d.%d.%d",&ip[0],&ip[1],&ip[2],&ip[3]) != 4 )
		return 0;
	bp = (char*)&sip->sin_addr;
	bp[0] = ip[3];
	bp[1] = ip[2];
	bp[2] = ip[1];
	bp[3] = ip[0];
	sip->sin_family = AF_INET;
	sip->sin_port = port;
	return sizeof(SIN);
}

void inet_itoaV4(int iaddr,PVStr(saddr))
{	SIN sin;

	sin.sin_addr.s_addr = htonl(iaddr);
	strcpy(saddr,inet_ntoa(sin.sin_addr));
}
void VSA_zero(VSAddr *sap)
{
	bzero(sap,sizeof(SIN));
}
void VSA_copy(VSAddr *dst,VSAddr *src)
{
	bcopy((SIN*)src,(SIN*)dst,sizeof(SIN));
}
int VSA_comp(VSAddr *vsa1,VSAddr *vsa2)
{	SIN *sa1 = (SIN*)vsa1;
	SIN *sa2 = (SIN*)vsa2;

	if( sa1->sin_family != sa2->sin_family )
		return 1;
	if( sa1->sin_port != sa2->sin_port )
		return 2;
	if( sa1->sin_addr.s_addr != sa2->sin_addr.s_addr )
		return 3;
	return 0;
}


void inetNtoa(int addr,PVStr(saddr))
{	SIN sin;

	sin.sin_family = AF_INET;
	sin.sin_addr.s_addr = addr;
	strcpy(saddr,inet_ntoa(sin.sin_addr));
}

int SocketPair(int d,int type,int protocol,int sv[2])
{	SIN ina;
	int asock,len;
	SAP sa;
	int salen;
	int rcode = 0;

	sv[0] = sv[1] = -1;
	if( d != AF_INET )
		return -1;

	errno = 0;
	asock = socket(d,type,protocol);
	if( asock < 0 )
	{
		syslog_ERROR("SocketPair:A socket(),errno=%d\n",errno);
		return -1;
	}

	sa = (SAP)&ina;
	salen = sizeof(ina);
	ina.sin_family = AF_INET;
	ina.sin_addr.s_addr = INADDR_ANY;
	ina.sin_port = 0;

	rcode |= bind(asock,sa,salen);
	if( rcode != 0 ){
		syslog_ERROR("SocketPair:A bind(%d),errno=%d\n",asock,errno);
		goto EXIT;
	}
	rcode |= listen(asock,2);
	if( rcode != 0 ){
		syslog_ERROR("SocketPair:A listn(%d),errno=%d\n",asock,errno);
		goto EXIT;
	}

	len = salen;
	getsockname(asock,sa,&len);
	if( d == AF_INET )
		ina.sin_addr.s_addr = inet_addrV4("127.0.0.1");

	sv[1] = socket(d,type,protocol);
	if( sv[1] < 0 ){
		syslog_ERROR("SocketPair:C socket(),errno=%d\n",errno);
		goto EXIT;
	}
	rcode |= connect(sv[1],sa,salen);
	if( rcode != 0 ){
		syslog_ERROR("SocketPair:C connect(),errno=%d\n",errno);
		goto EXIT;
	}

	len = salen;
	sv[0] = accept(asock,sa,&len);
	if( sv[0] < 0 ){
		syslog_ERROR("SocketPair:A accept(),errno=%d\n",errno);
		goto EXIT;
	}
EXIT:
	close(asock);

	if( sv[0] < 0 && 0 <= sv[1] )
		close(sv[1]);
	syslog_ERROR("SocketPair()=%d [%d,%d] %d\n",rcode,sv[0],sv[1],errno);
	return rcode;
}
char *_inet_ntoaV4I(INETADDRV4 ia)
{	struct in_addr in;

	in.s_addr = ia;
	return inet_ntoa(in);
}
INETADDRV4 _inet_addrV4(PCStr(cp))
{
	return inet_addr(cp);
}
int isinetAddr(PCStr(saddr))
{
	if( inet_addrV4(saddr) != -1 )
		return 4;
	return 0;
}

int Inet_aton(PCStr(addr),struct in_addr *inap)
{	unsigned int rcode;

	inap->s_addr = rcode = inet_addr(addr);
	if( rcode == (unsigned int)-1 )
		return 0;
	return 1;
}
