/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1999 Yutaka Sato
Copyright (c) 1999 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	ssi.c (SSI and META processor)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:

	<META HTTP-EQUIV="Status" content=status-line> ... for CGI compati.
	<!--#include file=requeste/response> ... for CFI

	original-SSI = http://hoohoo.ncsa.uiuc.edu/docs/tutorials/includes.html
	SSI+ = http://www.carleton.ca/~dmcfet/html/ssi3.html
	SPML = http://www.apache.org/docs/mod/mod_include.html

History:
	990802	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include <ctype.h>
#include "ystring.h"
#include "dglib.h"
#include "fpoll.h"
#include "file.h"
#include "url.h"
#define MY_HTTPVER "1.1"

extern int URICONV_nFULL;
extern int TAGCONV_SSI;
extern int TAGCONV_META;

typedef struct {
	MStr(	f_timefmt,64);
	MStr(	f_sizefmt,32);
	MStr(	h_status,1024);
	MStr(	h_contype,128);
	MStr(	h_header,4096);
	MStr(	h_incctype,128); /* HTTP Content-Type of included data */
	FILE   *m_body;
} Mssg;

#define ssi_timefmt (mssg->f_timefmt[0]?mssg->f_timefmt:TIMEFORM_RFC822)
#define ssi_sizefmt mssg->f_sizefmt

/*
static struct {
} SSIenvs[] = {
};
*/

static struct {
  const	char	*n_ssi;
  const	char	*n_cgi;
} cgi_equiv[] = {
	{"REFERRER",		"HTTP_REFERER"	},
	{"DOCUMENT_NAME",	"SCRIPT_NAME"	},
	{"DOCUMENT_URI",	"REQUEST_URI"	},
	0,
};

void SSI_config(DGC*ctx,const char *ev[],PCStr(tag),PCStr(type),PCStr(fmt),FILE *htfp,Mssg *mssg)
{
	if( strcaseeq(type,"timefmt") )
		lineScan(fmt,mssg->f_timefmt);
	else
	if( strcaseeq(type,"sizefmt") )
		lineScan(fmt,mssg->f_sizefmt);
	else{
		fprintf(mssg->m_body,"(SSI-UNKNOWN-config-%s)",type);
	}
}
static int SSI_getenv(DGC*ctx,const char *ev[],PCStr(tag),PCStr(type),PCStr(ename),FILE *htfp,Mssg *mssg,PVStr(buff),int size)
{	const char *sname;
	const char *cname;
	const char *eval;
	int ni;

	setVStrEnd(buff,0);
	if( strcaseeq(ename,"DATE_GMT") ){
		StrftimeGMT(AVStr(buff),size,ssi_timefmt,time(0),0);
	}else
	if( strcaseeq(ename,"DATE_LOCAL") ){
		StrftimeLocal(AVStr(buff),size,ssi_timefmt,time(0),0);
	}else
	if( strcaseeq(ename,"LAST_MODIFIED") ){
		StrftimeGMT(AVStr(buff),size,ssi_timefmt,file_mtime(fileno(htfp)),0);
	}else
	if( strcaseeq(ename,"PAGE_COUNT") ){
		strcpy(buff,"(SSI-NOTSUPPORTED-ENV-PAGE_COUNT)");
	}else
	if( strcaseeq(ename,"TOTAL_HITS") ){
		strcpy(buff,"(SSI-NOTSUPPORTED-TOTAL_HITS)");
	}else
	if( eval = getv(ev,ename) ){
		linescanX(eval,AVStr(buff),size);
	}else{
		cname = 0;
		for( ni = 0; sname = cgi_equiv[ni].n_ssi; ni++ ){
			if( strcaseeq(ename,sname) ){
				cname = cgi_equiv[ni].n_cgi;
				break;
			}
		}
		if( cname ){
			if( eval = getv(ev,cname) )
				linescanX(eval,AVStr(buff),size);
		}else{
			sprintf(buff,"(SSI-UNKNOWN-ECHO-%s)",ename);
			sv1tlog("SSI ECHO ERROR: unknown <%s>\n",ename);
		}
	}
	return strlen(buff);
}
int SSI_echo(DGC*ctx,const char *ev[],PCStr(tag),PCStr(type),PCStr(ename),FILE *htfp,Mssg *mssg)
{	CStr(buf,1024);
	const char *eval;
	FILE *body = mssg->m_body;

	if( strcaseeq(ename,"*") ){
		int ei;
		for( ei = 0; eval = ev[ei]; ei++ )
			fprintf(body,"%s\r\n",ev[ei]);
		return 1;
	}

	SSI_getenv(ctx,ev,tag,type,ename,htfp,mssg,AVStr(buf),sizeof(buf));
	fputs(buf,body);
	return 2;
}
static void basedir(PCStr(path))
{	const char *tp;

	for( tp = path+strlen(path)-1; path < tp; tp-- ){
		if( *tp == '/' )
			break;
		else	*(char*)tp = 0; /* not "const" but fixed */
	}
}
void SSI_file(DGC*ctx,const char *ev[],PCStr(tag),PCStr(type),PCStr(file),PCStr(np),FILE *htfp,Mssg *mssg)
{	CStr(url,URLSZ);
	CStr(lurl,URLSZ);
	CStr(temp,URLSZ);
	CStr(root,URLSZ);
	const char *base;
	FILE *body = mssg->m_body;
	FILE *fp;
	int fsize,mtime,direct,xoff,exec;

	syslog_DEBUG("## SSI %s %s=\"%s\"\n",tag,type,file);

	if( streq(type,"file")
	 || streq(type,"virtual") ){
	}else{
		fprintf(body,"(SSI-MISSING-virtual)");
		return;
	}

	lineScan(file,url);
	if( url[0] != '/' && !isFullURL(url) ){
		lineScan(url,temp);
		if( base = getv(ev,"SCRIPT_NAME") ){
			lineScan(base,url);
		}else
		if( base = getv(ev,"REQUEST_URI") ){
			url[0] = '/';
			decomp_absurl(base,VStrNULL,VStrNULL,QVStr(url+1,url),sizeof(url));
		}
		if( base ){
			basedir(url);
			chdir_cwd(AVStr(url),temp,0);
		}
	}
	strcpy(lurl,url);
	CTX_mount_url_to(ctx,NULL,"GET",AVStr(lurl));
	if( strncmp(lurl,"file://localhost/",17) == 0 ){
		if( isFullpath(lurl+17) )
			file = lurl+17;
		else	file = lurl+16;
	}else	file = lurl;

	/*
	 * return meta information if the target is a local file
	 */
	exec = isExecutableURL(file);
	syslog_DEBUG("## exec=%d %s [%s]\n",exec,file,url);

	if( strcaseeq(tag,"fsize") ){
		if( !exec )
		if( 0 <= (fsize = File_size(file)) ){
			fprintf(body,"%d",fsize);
			return;
		}
		sv1log("SSI ERROR %s %s %s %X/%d\n",tag,type,file,fsize,exec);
		return;
	}else
	if( strcaseeq(tag,"flastmod") ){
		if( !exec )
		if( 0 <= (mtime = File_mtime(file)) ){
			StrftimeLocal(AVStr(temp),sizeof(temp),ssi_timefmt,mtime,0);
			fprintf(body,"%s",temp);
			return;
		}
		sv1log("SSI ERROR %s %s %s %X/%d\n",tag,type,file,mtime,exec);
		return;

	}else
	if( strcaseeq(tag,"include") ){
	}else{
		fprintf(body,"(SSI-UNKNOWN-%s)",tag);
		return;
	}

	/*
	 * open target (possibly remote) data
	 */
	fp = NULL;
	if( !exec )
		fp = fopen(file,"r");
	if( fp == NULL ){
		CStr(nam,64);
		CStr(val,128);
		fflush(body);  /* necessary not to duplicate buffered data
				* in fork() in responseFilter()
				* for CTX_URLget()
				*/
		xoff = ftell(htfp);

		while( *np && isspace(*np) ) np++;
		scan_namebody(np,AVStr(nam),sizeof(nam),"=>",AVStr(val),sizeof(val),">");

		/* to suppress duplicated rewriting of request */
		if( strneq(lurl,"file:",5) ){
			strcpy(url,lurl);
		}
		if( !strcaseeq(nam,"localize") ){
			URICONV_nFULL |= 0x8000;
			fp = CTX_URLget(ctx,1,url,0,NULL);
			URICONV_nFULL &= ~0x8000;
		}else
		fp = CTX_URLget(ctx,1,url,0,NULL);

		if( fp != NULL && 0 < ftell(fp) ){
			CStr(ct,128);
			int off = ftell(fp);
			fseek(fp,0,0);
			ct[0] = 0;
			fgetsHeaderField(fp,"Content-Type",AVStr(ct),sizeof(ct));
			fseek(fp,off,0);
			FStrncpy(mssg->h_incctype,ct);
		}

		if( ftell(htfp) != xoff ){
			/* On Solaris2, the offset is moved mysteriously,
			 * in wait(0) for fork()ed responseFilter()
			 * which do exit() (not _exit()) at the end.
			 * This causes duplicated SHTML reading...
			 */
			sv1log("## fseeked ? %d -> %d\n",xoff,ftell(htfp));
			fseek(htfp,xoff,0);
		}
	}
	if( fp == NULL ){
		fprintf(body,"(SSI-UNKNOWN-%s-%s)",tag,url);
		return;
	}

	if( strcaseeq(tag,"fsize") ){
		fsize = file_size(fileno(fp)) - ftell(fp);
		fprintf(body,"%d",fsize);
	}else
	if( strcaseeq(tag,"flastmod") ){
		fseek(fp,0,0);
		mtime = HTTP_getLastModInCache(AVStr(temp),sizeof(temp),fp,"(tmp)");
		StrftimeLocal(AVStr(temp),sizeof(temp),ssi_timefmt,mtime,0);
		fprintf(body,"%s",temp);
	}else
	if( strcaseeq(tag,"include") ){
		if(strcasestr(mssg->h_incctype,"text/plain")){
			int ch;
			fputs("<PRE>\n",body);
			while( (ch = getc(fp)) != EOF ){
				if( ch == '<' )
					fputs("&lt;",body);
				else	putc(ch,body);
			}
			fputs("</PRE>\n",body);
		}else
		copyfile1(fp,body);
	}
	fclose(fp);
}
void SSI_exec(DGC*ctx,const char *ev[],PCStr(tag),PCStr(type),PCStr(command),FILE *htfp,Mssg *mssg)
{	FILE *body = mssg->m_body;

	if( streq(type,"cmd") ){
	}else
	if( streq(type,"cgi") ){
	}else
	if( streq(type,"virtual") ){
	}else{
		fprintf(body,"(SSI-UNKNOWN-%s-%s)",tag,type);
	}
}
static void eval_paramvalue(DGC*ctx,const char *ev[],PCStr(tagp),PCStr(type),PCStr(fname),FILE *htfp,Mssg *mssg,PCStr(str),PVStr(val),int siz)
{	FILE *body = mssg->m_body;
	int off,rcc;
	char fc;
	const char *fp;
	refQStr(vp,val); /**/
	const char *xp;
	const char *tp;
	CStr(fmt,256);
	CStr(xtag,256);
	CStr(xtype,256);
	CStr(xval,256);

	valuescanX(str,AVStr(fmt),sizeof(fmt));
	cpyQStr(vp,val);
	xp = val + siz - 1;
	for( fp = fmt; vp < xp && (fc = *fp); ){
		xtag[0] = 0;
		if( fc == '$' && strncmp(fp,"${",2) == 0 ){
			tp = wordscanY(fp+2,AVStr(fmt),sizeof(fmt),"^}");
			if( *tp == '}' ){
				if( strchr(fmt,':') ){
					scan_field1(fmt,AVStr(xtag),sizeof(xtag),
						AVStr(xval),sizeof(xval));
					strcpy(xtype,"virtual");
				}else{
					strcpy(xtag,"echo");
					strcpy(xtype,"var");
					strcpy(xval,fmt);
				}
			}
		}else
		if( fc == '<' && strncmp(fp,"<!--#",5) == 0 ){
			tp = wordscanY(fp+5,AVStr(fmt),sizeof(fmt),"^>");
			if( *tp == '>' ){
				xp = wordScan(fmt,xtag);
				while( isspace(*xp) ) xp++;
				xp = wordscanY(xp,AVStr(xtype),sizeof(xtype),"^=");
				if( *xp == '=' ) xp++;
				xp = valuescanX(xp,AVStr(xval),sizeof(xval));
			}
		}
		if( xtag[0] ){
			if( strcaseeq(xtag,"echo") ){
				SSI_getenv(ctx,ev,tagp,type,xval,
					htfp,mssg,QVStr(vp,val),siz-(vp-val));
			}else
			if( strcaseeq(xtag,"fsize")
			 || strcaseeq(xtag,"flastmod")
			 || strcaseeq(xtag,"include") ){
				off = ftell(body);
				SSI_file(ctx,ev,xtag,xtype,xval,"",htfp,mssg);
				fseek(body,off,0);
				rcc = fread((char*)vp,1,siz-(vp-val),body);
				setVStrEnd(vp,rcc);
				fseek(body,off,0);
				Ftruncate(body,off,0);
			}
			fp = tp + 1;
			vp += strlen(vp);
		}else{
			setVStrPtrInc(vp,*fp++);
		}
	}
	setVStrEnd(vp,0);
}

/*
 * <META HTTP-EQUIV=Date content="${DATE_GMT}">
 * <META HTTP-EQUIV=Date content="${flastmod:URL}">
 * <META HTTP-EQUIV=Content-Length content="<!--#fsize virtual=URL -->">
 */
void META_eval(DGC*ctx,const char *ev[],PCStr(tagp),PCStr(type),PCStr(fname),FILE *htfp,Mssg *mssg)
{	const char *cp;
	CStr(fvalue,256);
	char fc;
	const char *sp;
	refQStr(dp,fvalue); /**/

	if( !strcaseeq(type,"HTTP-EQUIV") ){
		return;
	}

	fvalue[0] = 0;
	if( cp = strcasestr(tagp,"content=") ){
		cp += 8;
		eval_paramvalue(ctx,ev,tagp,type,fname,htfp,mssg,
			cp,AVStr(fvalue),sizeof(fvalue));
	}

	cpyQStr(dp,fvalue);
	for( sp = fvalue; fc = *sp; sp++ ){
		if( fc == '\r' || fc == '\n' ){
			setVStrPtrInc(dp,' ');
			while( isspace(sp[1]) )
				sp++;
		}else	setVStrPtrInc(dp,fc);
	}
	setVStrEnd(dp,0);

	if( strcaseeq(fname,"Status") )
		sprintf(mssg->h_status,"%s\r\n",fvalue);
	else
	if( strcaseeq(fname,"Content-Type") )
		sprintf(mssg->h_contype,"%s\r\n",fvalue);
	else	Xsprintf(TVStr(mssg->h_header),"%s: %s\r\n",
			fname,fvalue);
}

typedef const char *(*scanMetaFuncP)(DGC*ctx,PCStr(attr),PVStr(cont),PCStr(tagp),PVStr(contp),PCStr(nextp));
void scan_metahttp(DGC*ctx,PVStr(line),scanMetaFuncP func)
{	int uconv;
	const char *sp;
	const char *np;
	const char *ep;
	const char *tag;
	refQStr(attr,line); /**/
	const char *cont;
	CStr(attrb,32);
	CStr(contb,128);

	sp = line;
	while( sp ){
		uconv = TAGCONV_META;
		np = html_nextTagAttrX(NULL,sp,"",VStrNULL,&tag,(const char**)&attr,&uconv);
		if( np == NULL )
			break;

		if( ep = strpbrk(np,">") )	sp = ep + 1; else
		if( ep = strpbrk(np," \t\r\n"))	sp = ep + 1; else
			sp = np;

		if( tag && strncasecmp(tag,"<META",5) == 0 )
		if( attr && strncasecmp(attr,"HTTP-EQUIV=",11) == 0 )
		if( cont = strcasestr(np,"content=") ){
			valuescanX(attr+11,AVStr(attrb),sizeof(attrb));
			valuescanX(cont+ 8,AVStr(contb),sizeof(contb));
			sp = (*func)(ctx,attrb,AVStr(contb),tag,AVStr(attr),sp);
			continue;
		}

		if( sp == np )
			break;
	}
}

static const char *seekeot(PCStr(tagp),PCStr(np),int ignspace)
{	const char *sp;
	char sc;
	const char *xp;

	xp = NULL;
	for( sp = np; sc = *sp; sp++ ){
		if( sc == '"' ){
			for( sp++; *sp && *sp != '"'; sp++ );
			if( *sp == 0 )
				break;
			continue;
		}
		if( sc == '-' && strncmp(sp,"-->",3) == 0 )
				 { xp = sp + 3; break; }
		if( sc == '>'   ){ xp = sp + 1; break; }
		if( isspace(sc) ){ xp = sp + 1; }
	}
	if( xp == NULL )
		xp = np;

	if( ignspace ){
		while( isspace(*xp) )
			xp++;
	}
	return xp;
}
int exec_metassi(DGC*ctx,const char *av[],const char *ev[],FILE *fc,FILE *tc,FILE *htfp)
{	int leng;
	CStr(line,1024);
	CStr(xline,0x10000);
	const char *sp;
	const char *np;
	refQStr(xp,xline); /**/
	const char *tagp;
	const char *attrp;
	CStr(tag,256);
	CStr(aname,256);
	CStr(avalue,1024);
	int uconv0,uconv;
	CStr(Status,256);
	CStr(Header,2048);
	int ignspace;
	Mssg mssg;
	int cleng;

	sv1log("## eval META & SSI\n");
	leng = 0;

	uconv0 = TAGCONV_SSI | TAGCONV_META;

	strcpy(mssg.f_timefmt,TIMEFORM_RFC822);
	mssg.h_status[0] = 0;
	mssg.h_contype[0] = 0;
	mssg.h_header[0] = 0;
	mssg.h_incctype[0] = 0;
	mssg.m_body = TMPFILE("SSI");

	while( fgets(line,sizeof(line),htfp) != NULL ){
		sp = line;
		xp = xline;
		for(;;){
			uconv = uconv0;
			np = html_nextTagAttrX(NULL,sp,"",VStrNULL,&tagp,&attrp,&uconv);
			if( np == NULL )
				break;

			if( tagp == NULL ){
				fwrite(sp,1,np-sp,mssg.m_body);
				sp = np;
				continue;
			}

			fwrite(sp,1,tagp-sp,mssg.m_body);
			ignspace = 0;

			wordScan(tagp,tag);
			aname[0] = 0;
			wordscanY(attrp,AVStr(aname),sizeof(aname),"^=");
			if( np[-1] == '"' ){
				np = valuescanX(np-1,AVStr(avalue),sizeof(avalue));
				if( *np == '"' )
					np++;
			}else	np = valuescanX(np,AVStr(avalue),sizeof(avalue));

			if( strcaseeq(tag,"<!--#echo") ){
				SSI_echo(ctx,ev,tag+5,aname,avalue,htfp,&mssg);
			}else
			if( strcaseeq(tag,"<!--#config") ){
				SSI_config(ctx,ev,tag+5,aname,avalue,htfp,&mssg);
			}else
			if( strcaseeq(tag,"<!--#include")
			 || strcaseeq(tag,"<!--#fsize")
			 || strcaseeq(tag,"<!--#flastmod")
			){
				SSI_file(ctx,ev,tag+5,aname,avalue,np,htfp,&mssg);
			}else
			if( strcaseeq(tag,"<!--#exec") ){
				SSI_exec(ctx,ev,tag+5,aname,avalue,htfp,&mssg);
			}else
			if( strcaseeq(tag,"<META") ){
				ignspace = 1;
				META_eval(ctx,ev,tagp+1,aname,avalue,htfp,&mssg);
			}

			sp = seekeot(tagp,np,ignspace);
		}
		strcpy(xp,sp);
		fputs(xline,mssg.m_body);
		leng += strlen(xline);
	}

	fflush(mssg.m_body);
	cleng = ftell(mssg.m_body);
	fseek(mssg.m_body,0,0);

	fprintf(tc,"HTTP/%s ",MY_HTTPVER);
	if( mssg.h_status[0] == 0 )
		fprintf(tc,"200 OK\r\n");
	else	fputs(mssg.h_status,tc);

	if( getKeepAlive(ctx,AVStr(line)) )
		fprintf(tc,"%s",line);
	else	fprintf(tc,"Connection: close\r\n");

	fprintf(tc,"Content-Type: ");
	if( mssg.h_contype[0] == 0 )
		fprintf(tc,"text/html\r\n");
	else	fputs(mssg.h_contype,tc);

	fprintf(tc,"Content-Length: %d\r\n",cleng);

	fputs(mssg.h_header,tc);
	fputs("\r\n",tc);
	if( strstr(mssg.h_contype," charset=") ){
		const char *dp;
		CStr(ocharset,64);
		CStr(icharset,64);
		dp = strstr(mssg.h_contype," charset=");
		wordscanY(dp+9,AVStr(ocharset),sizeof(ocharset),"^;\r\n");
		strcpy(icharset,"*");
		if( dp = strstr(mssg.h_incctype," charset=") ){
			wordscanY(dp+9,AVStr(icharset),sizeof(icharset),"^;\r\n");
			if( strcaseeq(icharset,"ISO-2022-JP") )
				strcpy(icharset,"*");
		}
		CCXfile(icharset,ocharset,mssg.m_body,tc);
	}else
	copyfile1(mssg.m_body,tc);
	fclose(mssg.m_body);

	sv1log("SSI %do / %di\n",cleng,leng);
	return cleng;
}
