dnl
dnl Call it like this:
dnl 
dnl REPLACE_WITH_STATIC_LIB( VARIABLE_name , minus_l_option , static_lib_name )
dnl
AC_DEFUN([REPLACE_WITH_STATIC_LIB],
  [
    ac_rwsl_var_name="$1"
    ac_rwsl_minus_l="$2"
    ac_rwsl_static_lib="$3"

    if test "Z${ac_rwsl_static_lib}" == "Z"; then
      ac_rwsl_v=`echo ${ac_rwsl_minus_l} | sed 's#-l##'`
      ac_rwsl_static_lib="lib"${ac_rwsl_v}".a"
    fi

    ac_rwsl_var_name=`echo ${ac_rwsl_var_name} | tr -d " "`
    ac_rwsl_minus_l=`echo ${ac_rwsl_minus_l} | tr -d " "`
    ac_rwsl_static_lib=`echo ${ac_rwsl_static_lib} | tr -d " "`

    cmd="\${$ac_rwsl_var_name}"
    eval "ac_rwsl_orig_val=\"$cmd\""

    if test "Z${ac_rwsl_static_lib}" == "Z"; then
      ac_rwsl_v=`echo "$ac_rwsl_orig_val" | sed "s#${ac_rwsl_minus_l}##"`
      eval "$ac_rwsl_var_name=\"$ac_rwsl_v\""
    else
      AC_CHECK_FILES(/usr/lib/${ac_rwsl_static_lib} , [
        ac_rwsl_v=`echo "$ac_rwsl_orig_val" | sed "s#${ac_rwsl_minus_l}#/usr/lib/${ac_rwsl_static_lib}#"`
        eval "$ac_rwsl_var_name=\"$ac_rwsl_v\""
      ] , [
        AC_CHECK_FILES(/usr/local/lib/${ac_rwsl_static_lib} , [
          ac_rwsl_v=`echo "$ac_rwsl_orig_val" | sed "s#${ac_rwsl_minus_l}#/usr/local/lib/${ac_rwsl_static_lib}#"`
          eval "$ac_rwsl_var_name=\"$ac_rwsl_v\""
        ] , [

          AC_CHECK_FILES(/usr/X11R6/lib/${ac_rwsl_static_lib} , [
            ac_rwsl_v=`echo "$ac_rwsl_orig_val" | sed "s#${ac_rwsl_minus_l}#/usr/X11R6/lib/${ac_rwsl_static_lib}#"`
            eval "$ac_rwsl_var_name=\"$ac_rwsl_v\""
          ])
        ])
      ])
    fi

  ]
)

dnl
dnl this macro removes flags and options from the variable var1 if they
dnl are present in the variable var2. 'var1' and 'var2' should be names 
dnl of the variables. Call:
dnl
dnl REMOVE_DUPLICATES(var1,var2)
dnl
AC_DEFUN([REMOVE_DUPLICATES],
[
    ac_str1_name="$1"
    ac_str2_name="$2"

    ac_str1_var="echo $"$ac_str1_name
    ac_str1_val=`eval $ac_str1_var`

    ac_str2_var="echo $"$ac_str2_name
    ac_str2_val=`eval $ac_str2_var`

    ac_tmp_var=""
    for w in ${ac_str1_val}; do
      case " ${ac_str2_val} " in
        *\ $w\ *) ;;
        *) ac_tmp_var="$ac_tmp_var $w" ;;
      esac
    done
    eval "$ac_str1_name=\"$ac_tmp_var\""
])
