#!/bin/sh

function die {
   echo $1
   exit 1
}

CONFIGURE_ARGS=$*

RPMROOT=/var/tmp/fwbuilder
EXPORTDIR=`pwd`/export

cd OS
./configure --prefix=/usr
cd ..

mkdir -p ${EXPORTDIR}

SPECFILE=fwbuilder.spec

source VERSION

TAR_FILE=fwbuilder-${VERSION}.tar.gz
SNAPSHOT_DIR=fwbuilder-${VERSION}

echo " === Building RPM for ${PACKAGE_NAME} version $VERSION === "

mkdir -p ${RPMROOT}
mkdir -p ${RPMROOT}/SOURCES
mkdir -p ${RPMROOT}/BUILD
mkdir -p ${RPMROOT}/SPECS
mkdir -p ${RPMROOT}/SRCS
mkdir -p ${RPMROOT}/RPMS
mkdir -p ${RPMROOT}/RPMS/i386
mkdir -p ${RPMROOT}/SRPMS

if [ ! -d $EXPORTDIR ]; then
    echo "Can't find export directory"
    exit 1
else

    make tar

    cp ${EXPORTDIR}/${TAR_FILE} ${RPMROOT}/SOURCES
    cp OS/Linux/RPM/${SPECFILE} ${RPMROOT}/SPECS 
    cd ${RPMROOT}/SPECS

    DISTRO=`cat /etc/issue|grep release|sed 's/Linux.*$//; s/ //g'`
    if test "x${DISTRO}" == "xMandrake"; then
        ARCH=`uname -m`
        if [ "X$ARCH" = "Xi686" ]; then
                RPMARCH="--target i586"
        fi
    fi

    rm -f .rpmmacros
    echo "%_topdir ${RPMROOT}" > .rpmmacros
    echo "%_unpackaged_files_terminate_build 0" >> .rpmmacros


    export HOME=`pwd`
    F=`which rpmbuild 2>/dev/null`
    if test -x "$F"; then rpmbuild -ba $RPMARCH ${SPECFILE}
    else rpm -ba $RPMARCH ${SPECFILE}
    fi
fi

