#!/bin/sh

if [ -x /bin/bash ];           then BASH="/bin/bash";           fi
if [ -x /usr/bin/bash ];       then BASH="/usr/bin/bash";       fi
if [ -x /usr/local/bin/bash ]; then BASH="/usr/local/bin/bash"; fi
if [ -z "$BASH" ]; then
  echo "Could not find bash."
  exit 1
fi

PACKAGE_NAME="$1"
VERSION="$2"
RPMROOT=/var/tmp/${PACKAGE_NAME}
EXPORTDIR=`pwd`/export
TAR_FILE=${PACKAGE_NAME}-${VERSION}.tar.gz
SNAPSHOT_DIR=${PACKAGE_NAME}-${VERSION}

TMP_FILE=${EXPORTDIR}/.maketar.tmp.sh

RPMFILES=""

#
# files regenerated by autogen.sh
GENFILES="aclocal.m4"

for f in ${GENFILES}; do
    test -f $f && RPMFILES="${RPMFILES} $f"
done


mkdir -p ${EXPORTDIR}

cat > ${TMP_FILE} << EOF

function die {
   echo $1
   exit 1
}

if test -z ${PACKAGE_NAME} -o -z ${VERSION}; then
  echo Usage: maketar.sh package_name version
  exit 1
fi

# make distclean

RPMFILES="${RPMFILES}              \
          VERSION                  \
          printversion.sh          \
          autogen.sh               \
	  maketar.sh               \
	  mkinstalldirs            \
          acinclude.m4             \
          aclocal.m4               \
          config.guess             \
          config.sub               \
          configure                \
          ltmain.sh                \
	  config.h.in              \
	  Makefile                 \
	  Main.make.in             \
	  install.sh               \
	  configure.in             \
	  build_rpm.sh             \
          listicons.sh             \
          missing                  \
          intl/config.charset      \
          intl/*.in                \
          intl/*.c                 \
          intl/*.h                 \
          intl/*.y                 \
          intl/*.sin               \
          intl/VERSION             \
          po/*.po                  \
          po/*.gmo                 \
          po/*.pot                 \
          po/*.in                  \
	  doc                      \
	  etc                      \

	  src/*.in                 \

          src/filters/*.in         \
          src/filters/*.xs*        \

          src/gui/*.in             \
          src/gui/*.cc             \
          src/gui/*.glade          \
          src/gui/*.hh             \
          src/gui/*.pl             \
          src/gui/*.timestamp      \
          src/gui/icons            \

          src/ipt/*.in             \
          src/ipt/*.cc             \
          src/ipt/*.glade          \
          src/ipt/*.hh             \
          src/ipt/*.pl             \
          src/ipt/*.timestamp      \

          src/pf/*.in              \
          src/pf/*.cc              \
          src/pf/*.glade           \
          src/pf/*.hh              \
          src/pf/*.pl              \
          src/pf/*.timestamp       \

          src/pix/*.in              \
          src/pix/*.cc              \
          src/pix/*.glade           \
          src/pix/*.hh              \
          src/pix/*.pl              \
          src/pix/*.timestamp       \

          src/migration/*.in       \
          src/migration/[.0-9]*/*.xslt \

          src/tools/*.cc           \
          src/tools/*.hh           \
          src/tools/*.sh           \
          src/tools/*.xslt         \
          src/tools/*.in           \
          src/tools/*.pl           \
          src/tools/*.glade        \
          src/tools/fwb_install    \
          src/tools/fwb_compile_all"


cd ${EXPORTDIR}
rm -rf ${SNAPSHOT_DIR}
ln -s .. ${SNAPSHOT_DIR}

FILELIST=\`for f in \${RPMFILES}; do echo ${SNAPSHOT_DIR}/\$f; done\`

tar -ch  --exclude CVS --exclude api --exclude Tutorial --exclude *.bak -f - \${FILELIST}  | gzip > ${TAR_FILE} 
cd ..

EOF

$BASH $TMP_FILE

# rm -f $TMP_FILE

