<!--
  Filename: print-html.xsl
  Author:  Vadim Kurland
  Build date: 04/21/2001
  Revision:   12/20/2001 
  Revision:   10/16/2002
 
  $Id  $

  Description: translates fwbuilder data file into html presentation,
               suitable for publishing on the web or printing


   12/20/2001:  added namespace; made it work with latest DTD;
		added support for negation in src/dst/srv
               
   12/25/2001:  added printing of Hosts and Networks. Changed layout.

   10/16/2002:  made changes to take into account new DTD (IPv4 element);
                checking for firewall platform since some platforms
                do not support logging and some others do not support time.


  test command (I can't use two minuses in "param" in this comment
  because of syntax restrictions):

   xsltproc \-\-param PrintFrom "'_FIREWALL_OBJ_ID_'" policy-html.xsl x.xml'

  note doubled quotes around firewall element's ID

-->

<xsl:stylesheet 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:fwbuilder="http://www.fwbuilder.org/1.0/"
    version="1.0"
>

<xsl:output method="html"/>
<xsl:param name="PrintFrom" select="''"/>

<xsl:strip-space elements="*"/>




<xsl:template match="fwbuilder:*" mode="print-element">
<xsl:value-of select="@name"/>
</xsl:template>


<xsl:template match="fwbuilder:ObjectRef|fwbuilder:ServiceRef|fwbuilder:IntervalRef" 
                 mode="rule-element">
<xsl:param name="neg"/>
<xsl:choose>
  <xsl:when test="$neg='True'">
    <xsl:text>! </xsl:text>
  </xsl:when>
</xsl:choose>
<xsl:apply-templates select="id(@ref)" mode="print-element"/>
<br></br>
</xsl:template>

<xsl:template match="fwbuilder:Option" mode="prule"></xsl:template>
<xsl:template match="fwbuilder:Option" mode="nrule"></xsl:template>

<xsl:template match="fwbuilder:OSrc" mode="nrule">
<td>
<xsl:apply-templates mode="rule-element"/>
</td>
</xsl:template>

<xsl:template match="fwbuilder:ODst" mode="nrule">
<td>
<xsl:apply-templates mode="rule-element"/>
</td>
</xsl:template>

<xsl:template match="fwbuilder:OSrv" mode="nrule">
<td>
<xsl:apply-templates mode="rule-element"/>
</td>
</xsl:template>

<xsl:template match="fwbuilder:TSrc" mode="nrule">
<td>
<xsl:apply-templates mode="rule-element"/>
</td>
</xsl:template>

<xsl:template match="fwbuilder:TDst" mode="nrule">
<td>
<xsl:apply-templates mode="rule-element"/>
</td>
</xsl:template>

<xsl:template match="fwbuilder:TSrv" mode="nrule">
<td>
<xsl:apply-templates mode="rule-element"/>
</td>
</xsl:template>


<xsl:template match="fwbuilder:Src" mode="prule">
<td>
<xsl:apply-templates mode="rule-element">
  <xsl:with-param name="neg" select="@neg"/>
</xsl:apply-templates>
</td>
</xsl:template>

<xsl:template match="fwbuilder:Dst" mode="prule">
<td>
<xsl:apply-templates mode="rule-element">
  <xsl:with-param name="neg" select="@neg"/>
</xsl:apply-templates>
</td>
</xsl:template>

<xsl:template match="fwbuilder:Srv" mode="prule">
<td>
<xsl:apply-templates mode="rule-element">
  <xsl:with-param name="neg" select="@neg"/>
</xsl:apply-templates>
</td>
</xsl:template>


<xsl:template match="fwbuilder:When" mode="prule">
<xsl:choose>
<xsl:when test="local-name(../..)='InterfacePolicy'"></xsl:when>
<xsl:otherwise>

<xsl:choose>
<xsl:when test="../../../attribute::platform='pix'"></xsl:when>
<xsl:when test="../../../attribute::platform='ipf'"></xsl:when>
<xsl:when test="../../../attribute::platform='pf'"></xsl:when>
<xsl:otherwise>
<td>
<xsl:apply-templates mode="rule-element">
  <xsl:with-param name="neg" select="@neg"/>
</xsl:apply-templates>
</td>
</xsl:otherwise>
</xsl:choose>

</xsl:otherwise>
</xsl:choose>
</xsl:template>

<!-- ******* prints comment, replacing '\n' with <br> **** -->
<xsl:template name="print-comment" mode="pcm">
<xsl:param name="comment"/>
<xsl:choose>
<xsl:when test="contains($comment,'\n')">
  <xsl:value-of select="substring-before($comment,'\n')"/>
<br/>
  <xsl:call-template name="print-comment" mode="pcm">
    <xsl:with-param name="comment" select="substring-after($comment,'\n')"/>
  </xsl:call-template>
</xsl:when>
<xsl:otherwise>
  <xsl:value-of select="$comment"/>
<br/>
</xsl:otherwise>
</xsl:choose>
</xsl:template>




<!--  ******  NAT rule  *****  -->
<xsl:template match="fwbuilder:NATRule[@disabled='False']" mode="fw">
<tr>
<td><xsl:value-of select="@position"/></td>
<xsl:apply-templates mode="nrule"/>
</tr>
</xsl:template>




<!--  ******  Policy rule  *****  -->
<xsl:template match="fwbuilder:PolicyRule[@disabled='False']" mode="policy">
<xsl:param name="interface_policy"/>

<tr>
<td><xsl:value-of select="@position"/></td>

<xsl:apply-templates mode="prule"/>

<td><xsl:value-of select="@action"/></td>

<xsl:choose>
<xsl:when test="../../attribute::platform='pix'"></xsl:when>
<xsl:otherwise>
<td>

<xsl:choose>
<xsl:when test="@log='True'">
Log
</xsl:when>
<xsl:otherwise>.</xsl:otherwise>
</xsl:choose>

</td>
</xsl:otherwise>
</xsl:choose>
<td>

<xsl:call-template name="print-comment" mode="pcm">
  <xsl:with-param name="comment" select="@comment"/>
</xsl:call-template>

</td>
</tr>
</xsl:template>


<!--  ******  Interface Policy rule  *****  -->
<xsl:template match="fwbuilder:PolicyRule[@disabled='False']" mode="iface_policy">
<xsl:param name="interface_policy"/>

<tr>
<td><xsl:value-of select="@position"/></td>

<xsl:apply-templates mode="prule"/>

<td><xsl:value-of select="@action"/></td>

<td><xsl:value-of select="@direction"/></td>

<xsl:choose>
<xsl:when test="../../../attribute::platform='pix'"></xsl:when>
<xsl:otherwise>
<td>
<xsl:choose>
<xsl:when test="@log='True'">
Log
</xsl:when>
<xsl:otherwise>.</xsl:otherwise>
</xsl:choose>
</td>
</xsl:otherwise>
</xsl:choose>


<td>

<xsl:call-template name="print-comment" mode="pcm">
  <xsl:with-param name="comment" select="@comment"/>
</xsl:call-template>

</td>
</tr>
</xsl:template>





<!--  ******  NAT  *****  -->
<xsl:template match="fwbuilder:NAT" mode="fw">
<br></br>
<table border="1" width="95%" cellspacing="0">
<caption align="left"><b><font size="+1">NAT rules</font></b></caption>
<tr>
<th width="20" bgcolor="#009900"><font color="#ffffff">Num</font></th>
<th bgcolor="#009900"><font color="#ffffff">OSrc</font></th>
<th bgcolor="#009900"><font color="#ffffff">ODst</font></th>
<th bgcolor="#009900"><font color="#ffffff">OSrv</font></th>
<th bgcolor="#009900"><font color="#ffffff">TSrc</font></th>
<th bgcolor="#009900"><font color="#ffffff">TDst</font></th>
<th bgcolor="#009900"><font color="#ffffff">TSrv</font></th>
</tr>
<xsl:apply-templates mode="fw"/>
</table>
</xsl:template>





<!--  ******  Policy  *****  -->
<xsl:template match="fwbuilder:Policy" mode="fw">
<br></br>
<table border="1" width="95%" cellspacing="0">
<caption align="left"><b><font size="+1">Policy Rules</font></b></caption>
<tr>
<th width="20" bgcolor="#009900"><font color="#ffffff">Num</font></th>
<th bgcolor="#009900"><font color="#ffffff">Src</font></th>
<th bgcolor="#009900"><font color="#ffffff">Dst</font></th>
<th bgcolor="#009900"><font color="#ffffff">Srv</font></th>

<xsl:choose>
<xsl:when test="../attribute::platform='pix'"></xsl:when>
<xsl:when test="../attribute::platform='ipf'"></xsl:when>
<xsl:when test="../attribute::platform='pf'"></xsl:when>
<xsl:otherwise>
<th bgcolor="#009900"><font color="#ffffff">Time</font></th>
</xsl:otherwise>
</xsl:choose>

<th bgcolor="#009900"><font color="#ffffff">Action</font></th>

<xsl:choose>
<xsl:when test="../attribute::platform='pix'"></xsl:when>
<xsl:otherwise>
<th bgcolor="#009900"><font color="#ffffff">Logging</font></th>
</xsl:otherwise>
</xsl:choose>

<th bgcolor="#009900"><font color="#ffffff">Comment</font></th>

</tr>
<xsl:apply-templates mode="policy"/>
</table>
</xsl:template>



<!--  ******  InterfacePolicy  *****  -->
<xsl:template match="fwbuilder:InterfacePolicy" mode="fw">
<br></br>
<table border="1" width="100%" cellspacing="0">
<caption align="left"><b><font size="+1">Interface Policy Rules</font></b></caption>
<tr>
<th width="20" bgcolor="#009900"><font color="#ffffff">Num</font></th>
<th bgcolor="#009900"><font color="#ffffff">Src</font></th>
<th bgcolor="#009900"><font color="#ffffff">Dst</font></th>
<th bgcolor="#009900"><font color="#ffffff">Srv</font></th>
<th bgcolor="#009900"><font color="#ffffff">Action</font></th>
<th bgcolor="#009900"><font color="#ffffff">Direction</font></th>

<xsl:choose>
<xsl:when test="../../attribute::platform='pix'"></xsl:when>
<xsl:otherwise>
<th bgcolor="#009900"><font color="#ffffff">Logging</font></th>
</xsl:otherwise>
</xsl:choose>

<th bgcolor="#009900"><font color="#ffffff">Comment</font></th>
</tr>
<xsl:apply-templates mode="iface_policy"/>
</table>
</xsl:template>




<!--  ******  Firewall  *****  -->
<xsl:template match="fwbuilder:Firewall" mode="node">
<br></br>
<br></br>
<!-- <hr></hr> -->

<table border="1" cellspacing="0" width="%95"><tr><td>
<table border="0" cellspacing="2" width="%100">
<tr><th colspan="2" bgcolor="#CCCCCC">Firewall</th></tr>
<tr><th colspan="2"></th></tr>
<tr><th align="left" width="20%">Name:</th>     <td align="left"><xsl:value-of select="@name"/></td></tr>
<tr><th align="left" width="20%">Platform:</th> <td align="left"><xsl:value-of select="@platform"/></td></tr>
<tr><th align="left" width="20%">Host OS:</th>  <td align="left"><xsl:value-of select="@host_OS"/></td></tr>
<tr><th align="left" width="20%">Comment:</th>  <td align="left"><xsl:value-of select="@comment"/></td></tr>
<tr><th colspan="2"></th></tr>
<tr><th colspan="2"></th></tr>
<tr><td colspan="2"><xsl:apply-templates mode="fw"/></td></tr>
</table>
</td></tr></table>
</xsl:template>




<!--  ******  Host  *****  -->
<xsl:template match="fwbuilder:Host" mode="node">
<br></br>
<br></br>
<!-- <hr></hr> -->

<table border="1" cellspacing="0" width="%95"><tr><td>
<table border="0" cellspacing="2" width="%100">
<tr><th colspan="2" bgcolor="#CCCCCC">Host</th></tr>
<tr><th colspan="2"></th></tr>
<tr><th align="left" width="150">Name:</th>     <td align="left"><xsl:value-of select="@name"/></td></tr>
<tr><th align="left" width="150">Comment:</th>  <td align="left"><xsl:value-of select="@comment"/></td></tr>
<tr><th colspan="2"></th></tr>
<tr><th colspan="2"></th></tr>
<tr><td colspan="2">
<!-- <xsl:apply-templates mode="fw"/> -->

<table border="0" cellspacing="4">
<tr>
<xsl:for-each select="fwbuilder:Interface" mode="fw">
<td align="left">  <xsl:call-template name="Interface" mode="fw"/> </td>
</xsl:for-each>
</tr>
</table>

</td></tr>
</table>
</td></tr></table>
</xsl:template>




<!--  ******  Network  *****  -->
<xsl:template match="fwbuilder:Network" mode="node">
<br></br>
<br></br>
<!-- <hr></hr> -->

<table border="1" cellspacing="0" width="%95"><tr><td>
<table border="0" cellspacing="2" width="%100">
<tr><th colspan="2" bgcolor="#CCCCCC">Network</th></tr>
<tr><th colspan="2"></th></tr>
<tr><th align="left" width="150">Name:</th>     <td align="left"><xsl:value-of select="@name"/></td></tr>
<tr><th align="left" width="150">Address:</th>  <td align="left"><xsl:value-of select="@address"/></td></tr>
<tr><th align="left" width="150">Netmask:</th>  <td align="left"><xsl:value-of select="@netmask"/></td></tr>
<tr><th align="left" width="150">Comment:</th>  <td align="left"><xsl:value-of select="@comment"/></td></tr>
<tr><th colspan="2"></th></tr>
<tr><th colspan="2"></th></tr>
<tr><td colspan="2"><xsl:apply-templates mode="fw"/></td></tr>
</table>
</td></tr></table>
</xsl:template>




<!--  ******  IPv4       *****  -->
<xsl:template name="IPv4" match="fwbuilder:IPv4" mode="address">
<tr><th align="left" width="150">Address:</th>  <td align="left"><xsl:value-of select="@address"/>/<xsl:value-of select="@netmask"/></td></tr>
</xsl:template>




<!--  ******  Interface  *****  -->
<xsl:template name="Interface" match="fwbuilder:Interface" mode="fw">
<p></p>
<table border="0" cellspacing="0" bgcolor="#CCCCCC" width="%95">
<tr><th colspan="2">Interface</th></tr>
<tr><th colspan="2"></th></tr>
<tr><th align="left" width="150">Name:</th>     <td align="left"><xsl:value-of select="@name"/></td></tr>

<xsl:choose>
  <xsl:when test="@dyn='True'">
<tr><th align="left" width="150">Address:</th>  <td align="left">Dynamic</td></tr>
  </xsl:when>	    
  <xsl:otherwise>   
<xsl:for-each select="fwbuilder:IPv4" mode="address">
<xsl:call-template name="IPv4" mode="fw"/>
</xsl:for-each>
  </xsl:otherwise>  
</xsl:choose>	    
		    
<tr><th align="left" width="150">MAC:</th>      <td align="left"><xsl:value-of select="@physAddress"/></td></tr>
<tr><th align="left" width="150">Security_level:</th>
<td align="left">
<xsl:variable name="nbsp" select="''"/>

<xsl:choose>
<xsl:when test="../attribute::platform='pix'">
<xsl:value-of select="@security_level"/>
</xsl:when>
<xsl:otherwise>
 <xsl:choose>
  <xsl:when test="@security_level='0'">External<xsl:value-of select="$nbsp"/>(Insecure)</xsl:when>
  <xsl:when test="@security_level='100'">Internal<xsl:value-of select="$nbsp"/>(Secure)</xsl:when>
  <xsl:otherwise><xsl:value-of select="@security_level"/></xsl:otherwise>
 </xsl:choose>
</xsl:otherwise>
</xsl:choose>
</td></tr>

<tr><th align="left" width="150">Comment:</th>  <td align="left"><xsl:value-of select="@comment"/></td></tr>
<tr><th colspan="2"></th></tr>
<tr><td colspan="2"><xsl:apply-templates mode="fw"/></td></tr>
</table>

</xsl:template>




<!--  ******  FirewallOptions  *****  -->
<xsl:template match="fwbuilder:Option" mode="fw"></xsl:template>
<xsl:template match="fwbuilder:Option" mode="node"></xsl:template>
<xsl:template match="fwbuilder:Option" mode="firewall"></xsl:template>
<xsl:template match="fwbuilder:CustomServiceCommand" mode="node"></xsl:template>
<xsl:template match="fwbuilder:CustomServiceCommand" mode="firewall"></xsl:template>


<xsl:template match="/">
<html>
<head>
</head>
<xsl:text>
</xsl:text>
<body bgcolor="#ffffff" link="#0000ee" vlink="#551a8b" alinlk="#0000ee">
<xsl:text>

</xsl:text>

  <xsl:choose>
    <xsl:when test="$PrintFrom">
      <xsl:apply-templates select="id($PrintFrom)" mode="node"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:apply-templates mode="node"/>
    </xsl:otherwise>
  </xsl:choose>

<xsl:text>

</xsl:text>
</body>
</html>
</xsl:template>


</xsl:stylesheet>





