/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: DiscoveryDruidP10Dialog.cc,v 1.14 2002/08/29 00:34:47 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "DiscoveryDruidP10Dialog.hh"
#include "FileSel.hh"
#include "Preferences.hh"
#include "fwbuilder/HostsFile.hh"
#include "MessageDialog.hh"
#include "helpers.hh"

using namespace libfwbuilder;


DiscoveryDruidP10Dialog::DiscoveryDruidP10Dialog()
{
    p10_txt->set_line_wrap(true);

#ifdef __MINGW32__
    hosts_file_name->set_text(__fwb_win32_getWinDir()+"\\system32\\drivers\\etc\\hosts");
#else
    hosts_file_name->set_text("/etc/hosts");
#endif

}

void DiscoveryDruidP10Dialog::prepare()
{
    hosts_file_name->grab_focus();
}


void DiscoveryDruidP10Dialog::on_browse_clicked()
{


    FileSel *fs=new FileSel(_("Find file"),Preferences::global_prefs->getWdir(),"");


    string f=fs->run();
    delete fs;
    if (f!="")
	hosts_file_name->set_text(f);
}

void DiscoveryDruidP10Dialog::scanHostsFile()   throw (FWException)
{
    map<IPAddress, vector<string> > reverse_hosts;
    HostsFile *hf;

/*
 *    read hosts file here 
 */
    hf=new HostsFile();
    try {
	hf->parse( hosts_file_name->get_text() );
    } catch ( FWException &ex ) {
	delete hf;
	throw;
	return;
    }
    reverse_hosts=hf->getAll();
    delete hf;

/*
 *    convert map format
 */
    hosts.clear();

    map<IPAddress,vector<string> >::iterator i;
    for (i=reverse_hosts.begin(); i!=reverse_hosts.end(); ++i) {

	ObjectDescriptor od;
	od.addr    = (*i).first;
	od.sysname = ((*i).second).front();
	
	hosts.push_back( od );
    }
}

