/* 

                          Firewall Builder

                 Copyright (C) 2001 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: DiscoveryDruidP40Dialog.cc,v 1.53 2003/11/03 06:52:55 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "DiscoveryDruidP40Dialog.hh"

#include "FWObjectDatabaseGUI.hh"
#include "fwbuilder/Host.hh"
#include "fwbuilder/Network.hh"
#include "fwbuilder/Firewall.hh"
#include "fwbuilder/FWOptions.hh"
#include "fwbuilder/Policy.hh"
#include "fwbuilder/InterfacePolicy.hh"
#include "fwbuilder/NAT.hh"
#include "fwbuilder/Group.hh"

#include "TableOfObjectsWithTypeChoice.hh"
#include "FilterDialog.hh"

#include "helpers.hh"

#include "SimpleProgressDialog.hh"

#include "glademm_support.hh"


#include <string>
#include <unistd.h>
#include <assert.h>


using namespace libfwbuilder;


DiscoveryDruidP40Dialog::DiscoveryDruidP40Dialog()
{
    p40_txt->set_line_wrap(true);
    tbl=NULL;

    on_selection_changed();
}

void DiscoveryDruidP40Dialog::prepare()
{
    scrolledwindow->grab_focus();
}


void DiscoveryDruidP40Dialog::addTypeChoice(const string& _type)
{
    type_choices.push_back(_type);
}

void DiscoveryDruidP40Dialog::on_filter_clicked()
{
    FilterDialog *fd=new FilterDialog( tbl->getAddressFilter(),
				       tbl->getNameFilter() );
    if ( fd->run() ) { 
	    
	tbl->filter( fd->getAddressFilter() , fd->getNameFilter() );
    }
    delete fd;

    if (tbl->isFilterActive())

	tbl_frame->set_label(_("New Objects (Filter active):"));


    else

	tbl_frame->set_label(_("New Objects: "));


}

void DiscoveryDruidP40Dialog::on_remove_filter_clicked()
{
    tbl->filter("","");


    tbl_frame->set_label(_("New Objects: "));


}


void  DiscoveryDruidP40Dialog::fillListOfObjects(const vector<ObjectDescriptor>& ah,
						 const string& domain,
						 bool fqdn)
{
    unsigned  row;

    all_hosts=ah;

    if (tbl!=NULL) {
	scrolledwindow->remove();
	tbl=NULL;
    }

    tbl   = manage( new TableOfObjectsWithTypeChoice( ah.size() ) );

    tbl->addTypeChoices(type_choices);

    SimpleProgressDialog* progr=new SimpleProgressDialog();


    progr->setText(_("Filling the table... "));
    progr->setTitle("");


    progr->setProgressBarRange(0.0 , gfloat(all_hosts.size()) );

    progr->show();

    while ( gtk_events_pending() )
	gtk_main_iteration();

    for (row=0; row<all_hosts.size(); ++row) 
    {
	progr->setProgressBarValue( gfloat(row) );

	ObjectDescriptor* od = &all_hosts[row];
	IPAddress         a = od->addr;

	set<string> names(od->dns_info.aliases);
	string     n;

	if ( ! od->sysname.empty())       names.insert(od->sysname);
	if ( ! od->dns_info.name.empty()) names.insert(od->dns_info.name);

	if ( ! fqdn ) 
        {
	    set<string>::iterator si, so;
	    for (si=names.begin(); si!=names.end(); ) 
            {
		string::size_type i=(*si).rfind(domain);
		if (i!=string::npos) 
                {
		    n= (*si).substr(0,i-1);
		    so=si;
		    ++si;
		    names.erase(so);
		    names.insert(n);
		    continue;
		}
		++si;
	    }
	}
/* 
 * using address as unique identifier to reference objects in the table widget 
 */
	tbl->addObject( row , a.toString() , names , a.toString() , od );
    }

    progr->hide();

    delete progr;

    tbl->selectAll();

    scrolledwindow->add_with_viewport( *tbl );

    on_selection_changed();

    tbl->show_all();

    tbl->changed.connect(SigC::slot(this, 
			   &DiscoveryDruidP40Dialog::on_selection_changed));
}

void DiscoveryDruidP40Dialog::on_selection_changed()
{
    int   n;

    n=(tbl)?tbl->getNumOfSelected():0;
    char  s[80];

    sprintf(s,
        ngettext("Selected:\n  %d object", "Selected:\n  %d objects", n), 
            n);

    table33->remove( *number_of_selected_objects );

    number_of_selected_objects=manage( new Gtk::Label(s) );
    number_of_selected_objects->set_alignment(0, 0);
    number_of_selected_objects->set_padding(0, 10);
/*    widgetModifyFont (number_of_selected_objects,
		      "-*-helvetica-bold-o-*-*-14-*-*-*-*-*-*-*");
*/
    table33->attach(*number_of_selected_objects, 1, 2, 8, 9, GTK_FILL, GTK_EXPAND|GTK_FILL, 0, 0);

    number_of_selected_objects->show();
}

void DiscoveryDruidP40Dialog::clearList()
{
    scrolledwindow->remove();
    tbl=NULL;

    type_choices.clear();
}

void DiscoveryDruidP40Dialog::on_select_all_clicked()
{   
    tbl->selectAll();
}

void DiscoveryDruidP40Dialog::on_unselect_all_clicked()
{   
    tbl->unselectAll();
}

void DiscoveryDruidP40Dialog::createObjects()
{
    SimpleProgressDialog* progr=new SimpleProgressDialog();


    progr->setText(_("Creating Hosts "));
    progr->setTitle("");


    progr->setProgressBarRange(0.0 , gfloat(all_hosts.size()) );

    progr->show();

    while ( gtk_events_pending() )
	gtk_main_iteration();

    for (unsigned row=0; row<all_hosts.size(); ++row) 
    {
	progr->setProgressBarValue( gfloat(row) );

	string a = all_hosts[row].addr.toString();

	if (tbl->isObjectChecked(a)) 
        {
	    string type=tbl->getTypeChoice(a);
	    string name=tbl->getObjectName(a);
	    const ObjectDescriptor *od=tbl->getDescriptor(a);

	    all_hosts[row].sysname=name;

	    if (type==_("Host") || type==_("Firewall")) 
            {
                FWObject *o=NULL;

                if (type==_("Host")) 
                    o=FWObjectDatabaseGUI::newHost();

                if (type==_("Firewall"))
                    o=FWObjectDatabaseGUI::newFirewall();

		o->setName(name);

		if (all_hosts[row].interfaces.size()==0) 
                {
                    Interface *itf= Interface::cast(FWObjectDatabaseGUI::newInterface(o->getId()));
                    itf->setName("nic1");
                    itf->setAddress(a);
                    itf->setNetmask("255.255.255.255");
                } else
                {
		    map<int,Interface>::const_iterator i;
		    for (i=all_hosts[row].interfaces.begin(); i!=all_hosts[row].interfaces.end(); ++i)
                    {
                        Interface *itf= Interface::cast(FWObjectDatabaseGUI::newInterface(o->getId()));
                        itf->duplicate( &(i->second) );
/*
 * duplicate wiped out all children of interface itf, including InterfacePolicy
 * object
 */
                        if (type==_("Firewall"))
                            itf->add(new InterfacePolicy());

/*
 * let's assign default names to IPv4 and physAddress objects
 */
                        FWObjectTypedChildIterator j=itf->findByType(IPv4::TYPENAME);
                        for ( ; j!=j.end(); ++j ) 
                            FWObjectDatabaseGUI::defaultNamingScheme( (*j) );

                        j=itf->findByType(physAddress::TYPENAME);
                        for ( ; j!=j.end(); ++j ) 
                            FWObjectDatabaseGUI::defaultNamingScheme( (*j) );

		    }
		}
		if (od)
                {
		    FWOptions* opt=(dynamic_cast<Host*>(o))->getOptionsObject();
		    opt->setStr("snmp_description",od->descr);
		    opt->setStr("snmp_location",   od->location);
		    opt->setStr("snmp_contact",    od->contact);
		}
	    }

	    if (type==_("Network"))
            {
		Network *net=dynamic_cast<Network*>( FWObjectDatabaseGUI::newNetwork() );
		assert(net!=NULL);
		net->setName(name);
		net->setAddress(IPAddress(a));
		net->setNetmask(Netmask(IPAddress(a)));
	    }


	}
    }

    progr->hide();

    delete progr;
}
