/* 

                          Firewall Builder

                 Copyright (C) 2001 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: DiscoveryDruidP70Dialog.hh,v 1.11 2002/08/29 00:34:48 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef _DISCOVERYDRUIDP70DIALOG_HH
#  include "DiscoveryDruidP70Dialog_glade.hh"
#  define _DISCOVERYDRUIDP70DIALOG_HH
#include "glademm_support.hh"

#include "TableOfObjects.hh"

#include "fwbuilder/IPAddress.hh"

#include <vector>

class DiscoveryDruidP70Dialog : public DiscoveryDruidP70Dialog_glade
{   

    friend class DiscoveryDruidP70Dialog_glade;

    void on_select_all_clicked();
    void on_unselect_all_clicked();
    void on_filter_clicked();
    void on_remove_filter_clicked();
    void on_selection_changed();

    TableOfObjects                    *tbl;
    vector<libfwbuilder::IPNetwork>    all_nets;

    void newNet(string name, libfwbuilder::IPNetwork& net );

    public:

    DiscoveryDruidP70Dialog();

    void prepare();

    void fillListOfNetworks( const vector<libfwbuilder::IPNetwork>& );
    void clearList();

    void createObjects();
};

#endif
