/* 

                          Firewall Builder

                 Copyright (C) 2001 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: FilterDialog.cc,v 1.12 2002/09/06 23:44:03 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#include "config.h"
#include "FilterDialog.hh"
#include "PixmapButton.hh"
#include "helpers.hh"

#include <gtk--.h>

#include <stack>

using namespace libfwbuilder;


FilterDialog::FilterDialog() 
{
    choice=false;

    txt_1->set_line_wrap(true);
    txt_1->set_alignment(0.0,0.5);

    txt_2->set_line_wrap(true);
    txt_2->set_alignment(0.0,0.5);


    PixmapButton::addPixmapAndText( *button33 , "Apply"        , _("Apply")  );
    PixmapButton::addPixmapAndText( *clear_filter_btn , "Undo" , _("Clear")  );
    PixmapButton::addPixmapAndText( *button34 , "Cancel"       , _("Cancel") );

    show_all();
#ifdef __MINGW32__
    __fwb_win32_loadIcon("FWBuilderWin32Ico",this);
#endif
}

FilterDialog::FilterDialog(const string& addr_filter,const string& n)
{
    name_filter->set_text(n);

    choice=false;

    txt_1->set_line_wrap(true);
    txt_1->set_alignment(0.0,0.5);

    txt_2->set_line_wrap(true);
    txt_2->set_alignment(0.0,0.5);


    PixmapButton::addPixmapAndText( *button33 , _("Apply")        , _("Apply")  );

    PixmapButton::addPixmapAndText( *clear_filter_btn , _("Undo") , _("Clear")  );

    PixmapButton::addPixmapAndText( *button34 , _("Cancel")       , _("Cancel") );



}

bool FilterDialog::run()
{
    show();
#ifdef __MINGW32__
    __fwb_win32_loadIcon("FWBuilderWin32Ico",this);
#endif

    address->grab_focus();

    Gtk::Main::grab_add(*this);
    Gtk::Main::run();
    Gtk::Main::grab_remove(*this);
    hide();
    return choice;
}

string FilterDialog::getAddressFilter()
{
    return address->get_text();
}

string FilterDialog::getNameFilter()
{
    return name_filter->get_text();
}

void FilterDialog::on_apply_clicked()
{
    choice=true;
    Gtk::Main::quit();
}

void FilterDialog::on_cancel_clicked()
{
    choice=false;
    Gtk::Main::quit();
}

void FilterDialog::on_clear_filter_btn_clicked()
{
    address->set_text("");
    name_filter->set_text("");
}

