/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: ICMPServiceDialog.cc,v 1.18 2003/04/07 01:04:40 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "fwbuilder/libfwbuilder-config.h"

#include "ICMPServiceDialog.hh"
#include "fwbuilder/FWObject.hh"
#include "MessageDialog.hh"
#include "helpers.hh"


using namespace libfwbuilder;



struct icmp_type_and_code {
    int    type_val;
    int    code_val;
    char*  type_desc;
    char*  code_desc;;
};

/* 
 * ICMP types and codes assigned by IANA:
 *
 * http://www.iana.org/assignments/icmp-parameters
 */
static const struct icmp_type_and_code icmp_types[] = {

    { 0,0, _("0: Echo reply"),_("0") },
    { 3,-1, _("3: Destination unreachable"),_("   Any") },
    { 3, 0, _("3: Destination unreachable"),_("0: Network unreachable") },
    { 3, 1, _("3: Destination unreachable"),_("1: Host unreachable") },
    { 3, 2, _("3: Destination unreachable"),_("2: Protocol unreachable") },
    { 3, 3, _("3: Destination unreachable"),_("3: Port unreachable") },
    { 3, 4, _("3: Destination unreachable"),_("4: Fragmentation needed") },
    { 3, 5, _("3: Destination unreachable"),_("5: Source route failed") },
    { 3, 6, _("3: Destination unreachable"),_("6: Destination network unknown") },
    { 3, 7, _("3: Destination unreachable"),_("7: Destination host unknown") },
    { 3, 8, _("3: Destination unreachable"),_("8: Source host isolated") },
    { 3, 9, _("3: Destination unreachable"),_("9: Dest. net adm. prohibited") },
    { 3, 10,_("3: Destination unreachable"),_("10: Dest. host adm. prohibited") },
    { 3, 11,_("3: Destination unreachable"),_("11: Network unreachable for TOS") },
    { 3, 12,_("3: Destination unreachable"),_("12: Host unreachable for TOS") },
    { 3, 13,_("3: Destination unreachable"),_("13: Admin. prohibited by filtering") },
    { 3, 14,_("3: Destination unreachable"),_("14: Host precedence violation") },
    { 3, 15,_("3: Destination unreachable"),_("15: Precedence cutoff") },

    { 4,0, _("4: Source quench"),_("0") },

    { 5,-1, _("5: Redirect"),_("   Any") },
    { 5, 0, _("5: Redirect"),_("0: Redirect for network") },
    { 5, 1, _("5: Redirect"),_("1: Redirect for host") },
    { 5, 2, _("5: Redirect"),_("2: Redirect for TOS and network") },
    { 5, 3, _("5: Redirect"),_("3: Redirect for TOS and host") },

    { 8,0, _("8: Echo request"),_("0") },

    { 9,0, _("9: Router advertisiment"),_("0") },

    {10,0, _("10: Router solicitation"),_("0") },

    {11,-1, _("11: Time exceeded"),_("   Any") },
    {11, 0, _("11: Time exceeded"),_("0: TTL equals 0 in transit") },
    {11, 1, _("11: Time exceeded"),_("1: TTL equals 0 in reassembly") },

    {12,-1, _("12: Parameter problem"),_("   Any") },
    {12, 0, _("12: Parameter problem"),_("0: IP header bad") },
    {12, 1, _("12: Parameter problem"),_("1: Option missing") },

    {13,0, _("13: Timestamp request"),_("0") },

    {14,0, _("14: Timestamp reply"),  _("0") },

    {15,0, _("15: Information request"),_("0") },

    {16,0, _("16: Information reply"),_("0") },


    {17,0, _("17: Address mask request"),_("0") },

    {18,0, _("18: Address mask reply"),_("0") },

    {30,0, _("30: Traceroute"),_("0") },

    {31,0, _("31: Datagram Conversion Error"),_("0") },

    {32,0, _("32: Mobile Host Redirect"),_("0") },

    {33,0, _("33: IPv6 Where-Are-You"),_("0") },

    {34,0, _("34: IPv6 I-Am-Here"),_("0") },

    {35,0, _("35: Mobile Registration Request"),_("0") },

    {36,0, _("36: Mobile Registration Reply"),_("0") },

    {37,0, _("37: Domain Name Request"),_("0") },

    {38,0, _("38: Domain Name Reply"),_("0") },

    {39,0, _("39: SKIP"),_("0") },

    {40,0, _("40: Photuris"),_("0: Bad SPI") },
    {40,1, _("40: Photuris"),_("1: Authentication Failed") },
    {40,2, _("40: Photuris"),_("2: Decompression Failed") },
    {40,3, _("40: Photuris"),_("3: Decryption Failed") },
    {40,4, _("40: Photuris"),_("4: Need Authentication") },
    {40,5, _("40: Photuris"),_("5: Need Authorization") },

    { -1,-1,"","" }

};


ICMPServiceDialog::ICMPServiceDialog(FWObject *obj)
{
    object=obj;
//    type->set_digits(0);
//    code->set_digits(0);

    block_type_change=block_code_change=false;
}

void ICMPServiceDialog::wrk2dlg()
{
    int t,c;

    t=object->getInt("type");
    c=object->getInt("code");

    name->set_text(object->getName());

//    type->set_value( object->getInt("type"));
//    code->set_value( object->getInt("code"));

    if (t==-1) {
	_fill_type( true );
	any_type->set_active(true);
	type->set_sensitive( false ); type_combo->set_sensitive( false );
	code->set_sensitive( false ); code_combo->set_sensitive( false );
    } else {
	_fill_type( false );
	_set_type( t );
	_fill_code( t );
	_set_code( t,c );
	any_type->set_active(false);
	type->set_sensitive( true ); type_combo->set_sensitive( true );
	code->set_sensitive( true ); code_combo->set_sensitive( true );
    }
    comment->set_point(0);
    comment->forward_delete( comment->get_length() );
    comment->insert(object->getComment());

    name->grab_focus();
}

bool ICMPServiceDialog::dlg2wrk()
{
    object->setName( name->get_text() );
    object->setComment( comment->get_chars(0,comment->get_length()) );

    if ( any_type->get_active() ) {
	object->setInt( "type" , -1 );
	object->setInt( "code" , -1 );
    } else {
	object->setInt( "type" , type->get_value_as_int() );
	object->setInt( "code" , code->get_value_as_int() );
    }

    return(true);
}

void ICMPServiceDialog::on_any_type_toggled()
{   
    type->set_sensitive( ! any_type->get_active() );
    code->set_sensitive( ! any_type->get_active() );
    type_combo->set_sensitive( ! any_type->get_active() );
    code_combo->set_sensitive( ! any_type->get_active() );

    _fill_type( any_type->get_active() );
}

void ICMPServiceDialog::on_type_combo_changed()
{   
    Gtk::Entry     *entry;
    int             t;

    entry=type_combo->get_entry();
    t=_get_type_by_desc( entry->get_text() );

    if ( ! block_type_change && t!=-1) 
    {
        type->set_value(t);
	_fill_code( t );
	_set_code( t,0 );
        data_changed_flag(true);
    }
}

void ICMPServiceDialog::on_code_combo_changed()
{   
    Gtk::Entry     *entry;
    int             c;

    entry=code_combo->get_entry();
    c=_get_code_by_desc( entry->get_text() );

//    if (c!=-1) {
    if ( ! block_code_change )
    {
        code->set_value(c);
        data_changed_flag(true);
    }
}


void ICMPServiceDialog::on_type_changed()
{   
    int           t;
    string        desc;

    string txt=type->get_text();
    if (txt=="") return;

    t=type->get_value_as_int();
//    t=atoi(txt.c_str());

    block_type_change=true;
    desc=_get_type_desc(t);

    type_combo->get_entry()->set_text( desc );
    _fill_code( t );
    _set_code( t,0 );

    block_type_change=false;

    data_changed_flag(true);
}

void ICMPServiceDialog::on_code_changed()
{   
    int           t,c;
    string        desc;

    t=type->get_value_as_int();
    c=code->get_value_as_int();

    desc=_get_code_desc(t,c);

    block_code_change=true;
    code_combo->get_entry()->set_text( desc );
    block_code_change=false;

    data_changed_flag(true);
}


void ICMPServiceDialog::_fill_type(bool empty_type)
{
    list<string>  strings;
    string        desc;

    int i, j;
    j=-1;

    if (empty_type) {
	type_combo->get_entry()->set_text( "" );
    } else {
        strings.push_back(string(""));
	for (i=0; icmp_types[i].type_val!=-1; i++) {
	    if (icmp_types[i].type_val==j) continue;

	    strings.push_back( icmp_types[i].type_desc );
	    j=icmp_types[i].type_val;
	}
    } 
    type_combo->set_popdown_strings( strings );
}

void ICMPServiceDialog::_fill_code(int t)
{
    list<string>  strings;
    string        desc;

    int i,j;

    i=_get_table_entry_for_type(t);

    if ( icmp_types[i].type_val!=-1 ) {
//        strings.push_back(string(""));
	for (j=i; icmp_types[j].type_val==t && icmp_types[j].type_val!=-1;
	     j++) {
	    strings.push_back( icmp_types[j].code_desc );
	}
    }
    code_combo->set_popdown_strings( strings );
}

void ICMPServiceDialog::_set_type(int t)
{
    string        desc;
    desc=_get_type_desc(t);
    type_combo->get_entry()->set_text( desc );
    type->set_value(t);
}

void ICMPServiceDialog::_set_code(int t,int c)
{
    string        desc;
    desc=_get_code_desc(t,c);
    code_combo->get_entry()->set_text( desc );
    code->set_value(c);
}

string ICMPServiceDialog::_get_type_desc(int t)
{
    int i;

    i=_get_table_entry_for_type(t);
    if ( icmp_types[i].type_val!=-1 )
	return icmp_types[i].type_desc;
    return string("");
}

string ICMPServiceDialog::_get_code_desc(int t,int c)
{
    int i,j;

//    if (c==-1) return "";

    i=_get_table_entry_for_type(t);
    if ( icmp_types[i].type_val!=-1 ) {
	for (j=i; icmp_types[j].code_val!=c && icmp_types[j].type_val!=-1; 
	 j++);
	return icmp_types[j].code_desc;
    }
    return string("");
}


int ICMPServiceDialog::_get_table_entry_for_type(int t)
{
    int i;

    for (i=0; icmp_types[i].type_val!=t && icmp_types[i].type_val!=-1; 
	 i++);

    return i;
}

int ICMPServiceDialog::_get_type_by_desc(string desc)
{
    int i;

    for (i=0; icmp_types[i].type_val!=-1; i++) {
	if ( desc==icmp_types[i].type_desc ) break;
    }
    return icmp_types[i].type_val;
}


int ICMPServiceDialog::_get_code_by_desc(string desc)
{
    int i;

    for (i=0; icmp_types[i].type_val!=-1; i++) {
	if ( desc==icmp_types[i].code_desc ) break;
    }
    return icmp_types[i].code_val;
}

void ICMPServiceDialog::on_changed()
{
  data_changed_flag(true);
}

