/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: InterfacePolicyDialog.hh,v 1.3 2002/08/29 00:34:49 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef __InterfacePolicyDialog_HH
#  include "InterfacePolicyDialog_glade.hh"
#  define __InterfacePolicyDialog_HH
#include "glademm_support.hh"

#include "fwbuilder/FWObject.hh"
#include "fwbuilder/Policy.hh"
#include "fwbuilder/Firewall.hh"

#include "PolicyList.hh"
#include "TMPGroupObject.hh"

class InterfacePolicyDialog : public InterfacePolicyDialog_glade
{   
        
    friend class InterfacePolicyDialog_glade;

    void on_policy_line_add();
    void on_policy_line_remove();

    TMPGroupObject                 *tmpgrp;
    libfwbuilder::InterfacePolicy  *tmp_copy;
    libfwbuilder::Firewall         *fw;

    Gtk::ScrolledWindow    *sw;
    InterfacePolicyList    *policylist_ptr;

public:

    InterfacePolicyDialog(libfwbuilder::FWObject *obj);
    ~InterfacePolicyDialog();

    virtual void wrk2dlg();
    virtual bool dlg2wrk();

//  void insertRuleBefore(gint row_n=-1);
//  void appendRuleAfter(gint row_n=-1);
//  void delRule(gint row_n=-1);

    InterfacePolicyList* getPolicyList() { return policylist_ptr; }

    virtual void updateMainMenu();

    /**
     *  refreshes dialog, but only if it shows object obj
     */
    virtual void conditionalRefresh(libfwbuilder::FWObject *obj=NULL);

    /**
     *  returns true of object obj is part of this dialog (either
     *  directly being edited in this dialog, or is somehow part of
     *  it. Example of the latter case would be an object which is a
     *  part of the rule set displayed in the dialog).
     */
    virtual bool isPartOfDialog(libfwbuilder::FWObject *obj);
};
#endif
