/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: ListOfIcons.hh,v 1.15 2002/09/01 04:31:17 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/




#ifndef _LIST_OF_ICONS_HH
#define _LIST_OF_ICONS_HH

#include <gtk--.h>
#include <IconList.hh>

#include "fwbuilder/FWObject.hh"

/**
 *  class ListOfIcons is an extension of widget IconList. It adds
 *  support for FWObject, so we can eliminate dependency on FWObject
 *  in IconList and make the latter a universal widget class.
 *  ListOfIcons also allows user to turn popup menu support on and off
 *  and to limit number of icons in the list.
 *
 */
class ListOfIcons : public IconList 
{
    gint    count;
    gint    max_count;
    bool    popup;

    virtual gint button_press_event_impl(GdkEventButton* p0);
    virtual gint button_release_event_impl(GdkEventButton* p0);
    virtual gint key_press_event_impl(GdkEventKey* p0);
    
    void set_data_changed_flag(bool flag);
  
public:

    ListOfIcons(gint icon_with,
		gint icon_height,
		bool allow_popup_menu,
		int max_no_of_icons=0);
    ~ListOfIcons();

    void    clear();

    void    addObject(libfwbuilder::FWObject *obj,bool ref=false);
    void    removeObject(const string& id);

    string  getObjectId(int no);
    int     findIcon(const string& id);

    bool    checkObjectId(const string& id);

    gint    getCount();
	  
    void    enableMenu()  { popup=true;  }
    void    disableMenu() { popup=false; }

    SigC::Signal1<void,void*>open_item;
    SigC::Signal1<void,void*>popup_menu;

};


#endif
