/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: NetworkDialog.cc,v 1.29 2003/09/22 05:12:40 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "helpers.hh"

#include "NetworkDialog.hh"
#include "fwbuilder/Network.hh"
#include "MessageDialog.hh"
#include "helpers.hh"
#include "fwbuilder/dns.hh"
#include "IPAddressWidget.hh"


using namespace libfwbuilder;


NetworkDialog::NetworkDialog(Network *obj) 
{ 
    object=obj;

    obj_addr=manage(new IPAddressWidget());
    obj_addr->showAllZeroes(true);
    table20->attach(*obj_addr, 1, 2, 1, 2, GTK_FILL, 0, 0, 0);
    obj_addr->changed.connect(SigC::slot(this,&NetworkDialog::on_changed));

    obj_netmask=manage(new IPAddressWidget());
    obj_netmask->showAllZeroes(true);
    table20->attach(*obj_netmask, 1, 2, 2, 3, GTK_FILL, 0, 0, 0);
    obj_netmask->changed.connect(SigC::slot(this,&NetworkDialog::on_changed));

//    obj_addr->setAssociatedNetmaskWidget( obj_netmask );
}

Network *NetworkDialog::getNetwork() 
{ 
    return static_cast<Network*>(object); 
}

void NetworkDialog::wrk2dlg()
{
    obj_name->set_text(object->getName());

    obj_addr->setAddress(getNetwork()->getAddress());
    obj_netmask->setAddress(getNetwork()->getNetmask());
    
    comment->set_point(0);
    comment->forward_delete( comment->get_length() );
    comment->insert(object->getComment());

    obj_name->grab_focus();
}

bool NetworkDialog::dlg2wrk()
{
    /*
     *  check if name is valid
     */

    try
    {
        checkIPaddress( obj_addr->getAsString() );
        checkNetmask(   obj_netmask->getAsString() );
    } catch(FWException &ex)
    {
        MessageDialog::Error(ex.toString(),find_my_toplevel_window(this));
        return true;
    }


    object->setName( obj_name->get_text() );
    object->setComment( comment->get_chars(0,comment->get_length()) );
    
    try
    {
        getNetwork()->setAddress( obj_addr->getAsIPAddress() );
        getNetwork()->setNetmask( Netmask(obj_netmask->getAsString()) );
    } catch(const FWException &ex)
    {
        return false;
    }

    return true;
}

gint NetworkDialog::on_obj_addr_focus_out_event(GdkEventFocus *ev)
{
    return (1);
/*
    if (obj_netmask->get_text()=="") {
	string netm=Netmask( obj_addr->getAsIPAddress() );
	obj_netmask->set_text(netm);
    }
    return(1);
*/
}

void NetworkDialog::on_changed()
{
    data_changed_flag(true);
}


void NetworkDialog::on_dns_lookup()
{
    vector<IPAddress> addr;

    try {
	addr=DNS::getHostByName( obj_name->get_text() );
    } catch (FWException &e)
    {
	MessageDialog::Error( e.toString() , this);
	return;
    }

    obj_addr->setAddress( addr.front() );
    data_changed_flag(true);
}


