/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: NewFirewallDruid.hh,v 1.8 2003/05/02 06:10:55 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef _NEWFIREWALL_DRUID_HH
#define _NEWFIREWALL_DRUID_HH

#include <Druid.hh>

#include "fwbuilder/FWObject.hh"
#include "fwbuilder/IPAddress.hh"
#include "fwbuilder/Host.hh"

#include "InterfaceData.hh"

#include <vector>

class NewFirewallDruidP10Dialog;
class NewFirewallDruidP12Dialog;
class NewFirewallDruidP15Dialog;
class NewFirewallDruidP17Dialog;
class NewFirewallDruidP20Dialog;
class NewFirewallDruidP30Dialog;

class main_window;

class NewFirewallDruid : public Druid {

    NewFirewallDruidP10Dialog  *p10;
    NewFirewallDruidP12Dialog  *p12;
    NewFirewallDruidP15Dialog  *p15;
    NewFirewallDruidP17Dialog  *p17;
    NewFirewallDruidP20Dialog  *p20;
    NewFirewallDruidP30Dialog  *p30;

    main_window                *main_w;
    std::list<InterfaceData>    ilist;

    std::list<InterfaceData> getInterfacesDataViaSNMP();

    public:

    NewFirewallDruid(main_window *mw,const string &t, const string& l);

    virtual void     on_prepare();
    virtual gboolean on_next();
    virtual gboolean on_back();
    virtual gboolean on_cancel();
    virtual void     on_finish();
};

#endif
