/* 

                          Firewall Builder

                 Copyright (C) 2001 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: PixmapButton.cc,v 1.8 2003/04/26 07:39:39 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "fwbuilder/Resources.hh"

#include "PixmapButton.hh"

#include "helpers.hh"

PixmapButton::PixmapButton() : Gtk::Button()
{
    hb=NULL;
    pixmap=NULL;
    label=NULL;
}

PixmapButton::PixmapButton(const string &icn) : Gtk::Button()
{
    hb=NULL;
    pixmap=NULL;
    label=NULL;
    addPixmapAndText(icn,"");
}

PixmapButton::PixmapButton(const string &icn, const string &text) : Gtk::Button()
{
    hb=NULL;
    pixmap=NULL;
    label=NULL;
    addPixmapAndText(icn,text);
}

PixmapButton::~PixmapButton()
{
//    clear();
}

void PixmapButton::clear()
{
    remove();
    if (hb)
    {
        if (label) 
        {
            hb->remove(*label);
            delete label;
            label=NULL;
        }
        if (pixmap)
        {
            hb->remove(*pixmap);
            delete pixmap;
            pixmap=NULL;
        }
        delete hb;
    }
}

void PixmapButton::addPixmapAndText(const string &icn, const string &text)
{
    clear();

    string icn_path;
    if (icn.find("/")==string::npos)
	icn_path=Resources::global_res->getIconPath(icn);
    else
	icn_path=icn;

    hb=new Gtk::HBox();

    pixmap= new SimplePixmap(icn_path);
    hb->pack_start(*pixmap, true,true,false);

    if (!text.empty()) 
    {
	label = new Gtk::Label(text);
	hb->pack_start(*label , true,true,false);
    }


    add(*hb);

    hb->show_all();

//    addPixmapAndText(*this,icn,text);
}

void PixmapButton::addPixmapAndText(Gtk::Button &btn,const string &icn, const string &text)
{
}
