/* 

                          Firewall Builder

                 Copyright (C) 2001 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: PixmapButton.hh,v 1.5 2003/04/26 07:39:39 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef _PIXMAP_BUTTON_HH_
#define _PIXMAP_BUTTON_HH_

#include <gtk--.h>

#include "config.h"

#include "SimplePixmap.hh"

class PixmapButton : public Gtk::Button {

    Gtk::HBox    *hb;
    SimplePixmap *pixmap;
    Gtk::Label   *label;

    void clear();

    public:

    PixmapButton();
    virtual ~PixmapButton();
    PixmapButton(const string &icn);
    PixmapButton(const string &icn, const string &text);

    void addPixmapAndText(const string &icn, const string &text);

    static void addPixmapAndText(Gtk::Button &btn,
				 const string &icn, const string &text);
};


#endif
