/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: Preferences.hh,v 1.29 2003/01/01 04:18:59 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef __PREFERENCES_HH__
#define __PREFERENCES_HH__

#include "config.h"

#include <map>
#include <string>

#include <gtk--.h>

#include <libxml/parser.h>
#include <libxml/tree.h>

#include "fwbuilder/FWObject.hh"
#include "fwbuilder/XMLTools.hh"
#include "fwbuilder/FWException.hh"
#include "fwbuilder/crypto.hh"

class Preferences 
{
    xmlDocPtr  doc;
    xmlNodePtr root;

    string prefsFile;

    static const string PREFS_DIR_NIX            ;
    static const string PREFS_DIR_WIN            ;
    static const string OLD_PREFS_FILE_NAME      ;
    static const string NEW_PREFS_FILE_NAME      ;
    static const string PREFS_TEMPLATE_FILE_NAME ;
    static const string DTD_FILE_NAME            ;
    static const string TYPENAME                 ;

public:

    Preferences() throw(libfwbuilder::FWException);

    void loadPrefs() throw(libfwbuilder::FWException);
    void savePrefs() throw(libfwbuilder::FWException);

    xmlNodePtr getXmlNode(const string& path);

    void   setOpt(const string& name,const string &val);
    void   setOpt(const string& name,const char* val);
    void   setOptInt(const string& name,int val);
    void   setOptBool(const string& name,bool val);

    string getOptStr(const string& name);
    int    getOptInt(const string& name);
    int    getOptInt(const string& name, int default_value);
    bool   getOptBool(const string& name);

    void   setProp(const string& path,const char* attrname,const char* val);
    string getPropStr(const string& path,const char* attrname);

    void   setProp(xmlNodePtr node,const char* attrname,const char* val);
    gchar* getProp(xmlNodePtr node,const char* attrname);
    string getPropStr(xmlNodePtr node,const char* attrname);

    /**
     * This method is just an algorithm to chose work directory from
     * preferences parameter "working directory" or directory where 
     * last object data file has been loaded from
     * 
     * We use directory set in preferences if there was no object file
     * loaded yet, and directory where it was loaded from otherwise
     */
    string getWdir();

    /**
     * Reads list of availiable certificates. 
     * Returns ('description', 'data') pairs indexed by 'id'.
     */
    map<string, pair<string, string> > getCerificates();
    
    void addKeyAndCert(const string &id, const string &description, const libfwbuilder::KeyAndCert &c,
                       const string &password) throw(libfwbuilder::FWException);

    void removeKeyAndCert(const string &id) throw(libfwbuilder::FWException);

    libfwbuilder::KeyAndCert getKeyAndCert(const string &id, const string &password) throw(libfwbuilder::FWException);

    void exportPKCS12(const string &id, const string &filename) throw(libfwbuilder::FWException);

    string importPKCS12(const string &filename, const string &description) throw(libfwbuilder::FWException);

    void exportPublicKey(const string &id, const string &password, const string &filename) throw(libfwbuilder::FWException);
    
    static Preferences   *global_prefs;

    private:

    xmlNodePtr findCert(const string &id) throw(libfwbuilder::FWException);
};


#endif // __PREFERENCES_HH__



