/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: PrintDialog.hh,v 1.12 2002/10/17 07:12:30 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef __PRINTDIALOG_HH
#  include "PrintDialog_glade.hh"
#  define __PRINTDIALOG_HH
#include "glademm_support.hh"

#include <gtk--.h>

#include "fwbuilder/FWException.hh"


class PrintDialog : public PrintDialog_glade
{          
    friend class PrintDialog_glade;
    void on_ok_clicked();
    void on_cancel_clicked();
    void on_choose_file_clicked();
    void on_printer_toggled();
    void on_file_toggled();

    public:

    PrintDialog(const gchar *id);
    virtual ~PrintDialog();
    
    static const string FILTERS_DIR;

    void run() throw(libfwbuilder::FWException);;
    
    private:
    
    void savePrefs();
    void loadPrefs();    
    
    bool choice;
    const gchar *current_node;
    
    // Data
    string command  ;
    string filename ;
    bool to_file    ;
    string filter   ;
    

};



#endif



