
/* 

                          Firewall Builder

                 Copyright (C) 2001 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: RuleOptionsDialog.cc,v 1.35 2003/10/10 07:01:56 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "fwbuilder/libfwbuilder-config.h"

#include "RuleOptionsDialog.hh"

#include "fwbuilder/FWOptions.hh"
#include "fwbuilder/Firewall.hh"
#include "helpers.hh"

#include "PixmapButton.hh"

#include <gtk--.h>

#include <assert.h>
#include <iostream>

using namespace libfwbuilder;


void RuleOptionsDialog::on_ok_clicked()
{   
    choice=true;
    Gtk::Main::quit();
}

void RuleOptionsDialog::on_cancel_clicked()
{   
    choice=false;
    Gtk::Main::quit();
}

RuleOptionsDialog::RuleOptionsDialog(FWOptions *opt) 
{
    choice=false;
    options=opt;

    notebook_pages["ipchains"]=     0;
    notebook_pages["ipfilter"]=     1;
    notebook_pages["iptables"]=     2;
    notebook_pages["pix"]=          3;
    notebook_pages["pf"]=           4;
    notebook_pages["ipf"]=          5;
    notebook_pages["ipfw"]=         6;
    notebook_pages["cisco"]=        99;

//    ((Gtk::Label*)(ipfilter_log_or_block->get_child()))->set_alignment(0.0,0.5);
//    ((Gtk::Label*)(ipfilter_log_body->get_child()))->set_alignment(0.0,0.5);
//    ((Gtk::Label*)(ipfilter_log_first->get_child()))->set_alignment(0.0,0.5);
//    ((Gtk::Label*)(ipfilter_reject_icmp_as_dest->get_child()))->set_alignment(0.0,0.5);

    iptables_lbl1->set_line_wrap(true);
    iptables_lbl2->set_line_wrap(true);
    iptables_lbl3->set_line_wrap(true);
    iptables_lbl4->set_line_wrap(true);

    ((Gtk::Label*)(iptables_no_state->get_child()))->set_alignment(0.0,0.5);

    limit_suffixes.push_back("");
    limit_suffixes.push_back("/second");
    limit_suffixes.push_back("/minute");
    limit_suffixes.push_back("/hour");
    limit_suffixes.push_back("/day");

    actions_on_reject.push_back("");
    actions_on_reject.push_back("ICMP net unreachable");
    actions_on_reject.push_back("ICMP host unreachable");
    actions_on_reject.push_back("ICMP port unreachable");
    actions_on_reject.push_back("ICMP proto unreachable");
    actions_on_reject.push_back("ICMP net prohibited");
    actions_on_reject.push_back("ICMP host prohibited");
    actions_on_reject.push_back("ICMP admin prohibited");
    actions_on_reject.push_back("TCP RST");

    pf_lbl2->set_line_wrap(true);
    pf_lbl3->set_line_wrap(true);

    ipf_lbl1->set_line_wrap(true);
    ipf_lbl2->set_line_wrap(true);
    ipf_lbl3->set_line_wrap(true);
    ipf_lbl4->set_line_wrap(true);

    ipfw_lbl_1->set_line_wrap(true);
    ipfw_lbl_2->set_line_wrap(true);

    PixmapButton::addPixmapAndText( *button19 , "Ok"     , _("OK")     );
    PixmapButton::addPixmapAndText( *button20 , "Cancel" , _("Cancel") );


    button19->set_flags(GTK_CAN_FOCUS|GTK_CAN_DEFAULT);
    button20->set_flags(GTK_CAN_FOCUS|GTK_CAN_DEFAULT);
    button19->grab_default();
    button19->grab_focus();

}


Gtk::Menu* RuleOptionsDialog::addOptionsMenu( vector<string> &items , 
					      string &active_item)
{
    return createOptionsMenu(items,active_item,NULL);
}

void RuleOptionsDialog::run()
{   
    FWObject *p;

    p=options;
    do {
	p=p->getParent();
    } while ( p!=NULL && Firewall::cast(p)==NULL );
    assert(p!=NULL);

    string platform = p->getStr("platform");

    map<string,string>   log_levels;

    log_levels[""       ]="        "  ;
    log_levels["alert"  ]="1: alert"  ;
    log_levels["crit"   ]="2: crit"   ;
    log_levels["error"  ]="3: error"  ;
    log_levels["warning"]="4: warning";
    log_levels["notice" ]="5: notice" ;
    log_levels["info"   ]="6: info"   ;
    log_levels["debug"  ]="7: debug"  ;

    map<string,string>        log_facilities_full;

    log_facilities_full[""         ]="             "  ;
    log_facilities_full["kern"     ]=" 0: kern     "  ;
    log_facilities_full["user"     ]=" 1: user     "  ;
    log_facilities_full["mail"     ]=" 2: mail     "  ;
    log_facilities_full["daemon"   ]=" 3: daemon   "  ;
    log_facilities_full["auth"     ]=" 4: auth     "  ;
    log_facilities_full["syslog"   ]=" 5: syslog   "  ;
    log_facilities_full["lpr"      ]=" 6: lpr      "  ;
    log_facilities_full["news"     ]=" 7: news     "  ;
    log_facilities_full["uucp"     ]=" 8: uucp     "  ;
    log_facilities_full["cron"     ]=" 9: cron     "  ;
    log_facilities_full["authpriv" ]="10: authpriv "  ;
    log_facilities_full["ftp"      ]="11: ftp      "  ;
    log_facilities_full["local0"   ]="16: local0   "  ;
    log_facilities_full["local1"   ]="17: local1   "  ;
    log_facilities_full["local2"   ]="18: local2   "  ;
    log_facilities_full["local3"   ]="19: local3   "  ;
    log_facilities_full["local4"   ]="20: local4   "  ;
    log_facilities_full["local5"   ]="21: local5   "  ;
    log_facilities_full["local6"   ]="22: local6   "  ;
    log_facilities_full["local7"   ]="23: local7   "  ;


    if (platform=="ipchains") 
    {

    }
/*
    if (platform=="ipfilter") 
    {
	ipfilter_log_or_block->set_active( options->getBool("log_or_block") );
	ipfilter_log_body->set_active( options->getBool("log_body") );
	ipfilter_log_first->set_active( options->getBool("log_first") );

	ipfilter_reject_icmp_as_dest->set_active( options->getBool("icmp_as_dest") );

	string aor=options->getStr("action_on_reject");
	ipfilter_action_on_reject->remove_menu();
	ipfilter_action_on_reject->set_menu(addOptionsMenu(actions_on_reject,aor));
    }
*/
    if (platform=="iptables") 
    {
	iptables_log_prefix->set_text( options->getStr("log_prefix") );

	string level=options->getStr("log_level");
        iptables_log_level->set_menu(log_levels);
        iptables_log_level->set_active_item_by_value(level);

	iptables_ulog_nlgroup->set_value( options->getInt("ulog_nlgroup") );

	string aor=options->getStr("action_on_reject");
	iptables_action_on_reject->remove_menu();
	iptables_action_on_reject->set_menu(addOptionsMenu(actions_on_reject,aor));
        
	iptables_limit_value->set_value( options->getInt("limit_value") );
	iptables_limit_burst->set_value( options->getInt("limit_burst") );

	string ls=options->getStr("limit_suffix");
	iptables_limit_suffix->remove_menu();
	iptables_limit_suffix->set_menu( addOptionsMenu(limit_suffixes,ls) );

	iptables_no_state->set_active( options->getBool("stateless") );

    }

    if (platform=="pix") 
    {
        string vers="version_"+p->getStr("version");
        if ( Resources::platform_res["pix"]->getResourceBool(
              "/FWBuilderResources/Target/options/"+vers+"/pix_rule_syslog_settings"))
        {
            pix_disable_rule_log->set_sensitive(true);
            pix_log_level->set_sensitive(true);
            pix_log_interval->set_sensitive(true);

            pix_disable_rule_log->set_active( options->getBool("disable_logging_for_this_rule") );
            string level=options->getStr("log_level");
            pix_log_level->set_menu(log_levels);
            if (level!="") pix_log_level->set_active_item_by_value(level);
            else           pix_log_level->set_active_item_by_value("info");
            if ( options->getInt("log_interval")>1)
                pix_log_interval->set_value( options->getInt("log_interval") );
        } else
        {
            pix_disable_rule_log->set_sensitive(false);
            pix_log_level->set_sensitive(false);
            pix_log_interval->set_sensitive(false);
        }
    }

    if (platform=="pf") 
    {
	pf_log_prefix->set_text( options->getStr("log_prefix") );

	string aor=options->getStr("action_on_reject");
	pf_action_on_reject->remove_menu();
	pf_action_on_reject->set_menu(addOptionsMenu(actions_on_reject,aor));

	pf_no_state->set_active( options->getBool("stateless") );
    }

    if (platform=="ipf") 
    {
	string level=options->getStr("log_level");
        ipf_log_level->set_menu(log_levels);
        ipf_log_level->set_active_item_by_value(level);

	string facility=options->getStr("ipf_log_facility");
        ipf_log_facility->set_menu(log_facilities_full);
        ipf_log_facility->set_active_item_by_value(facility);

	string aor=options->getStr("action_on_reject");
	ipf_action_on_reject->remove_menu();
	ipf_action_on_reject->set_menu(addOptionsMenu(actions_on_reject,aor));
	ipf_return_icmp_as_dest->set_active( options->getBool("ipf_return_icmp_as_dest") );

	ipf_no_state->set_active( options->getBool("stateless") );
	ipf_keep_frags->set_active( options->getBool("ipf_keep_frags") );
    }

    if (platform=="ipfw") 
    {
	string aor=options->getStr("action_on_reject");
	ipfw_action_on_reject->remove_menu();
	ipfw_action_on_reject->set_menu(addOptionsMenu(actions_on_reject,aor));

	ipfw_no_state->set_active( options->getBool("stateless") );
    }



    show_all();

    for (unsigned i=0; i<notebook_pages.size(); ++i) {
	Gtk::Widget *w=notebook300->get_nth_page(i);
	if (w) w->hide();
    }

    notebook300->get_nth_page( notebook_pages[platform] )->show();

    Gtk::Main::grab_add(*this);
    Gtk::Main::run();
    Gtk::Main::grab_remove(*this);

    hide();

    if (choice) {

	if (platform=="ipchains") 
        {


	}
/*
	if (platform=="ipfilter") 
        {
	    options->setBool("log_or_block",ipfilter_log_or_block->get_active());
	    options->setBool("log_or_block",ipfilter_log_or_block->get_active());
	    options->setBool("log_or_block",ipfilter_log_or_block->get_active());
	    options->setBool("log_body",ipfilter_log_body->get_active());
	    options->setBool("log_first",ipfilter_log_first->get_active());
	    options->setBool("icmp_as_dest",ipfilter_reject_icmp_as_dest->get_active());

	    string *aor=(string*)(ipfilter_action_on_reject->get_menu()->get_active()->get_user_data());
	    options->setStr("action_on_reject"  , *aor );
	}
*/
	if (platform=="iptables") 
        {
	    options->setStr("log_prefix" ,   iptables_log_prefix->get_text() );
            options->setStr("log_level",     iptables_log_level->get_value() );
            options->setInt("ulog_nlgroup",  iptables_ulog_nlgroup->get_value_as_int() );

	    string *aor=(string*)(iptables_action_on_reject->get_menu()->get_active()->get_user_data());
	    options->setStr("action_on_reject"  , *aor );

	    options->setInt("limit_value",
			    iptables_limit_value->get_value_as_int() );
	    options->setInt("limit_burst",
			    iptables_limit_burst->get_value_as_int() );

	    string *ls=(string*)(iptables_limit_suffix->get_menu()->get_active()->get_user_data());
	    options->setStr("limit_suffix"  , *ls );

	    options->setBool("stateless", iptables_no_state->get_active() );

	}

	if (platform=="pix") 
        {
            string vers="version_"+p->getStr("version");
            if ( Resources::platform_res["pix"]->getResourceBool(
               "/FWBuilderResources/Target/options/"+vers+"/pix_rule_syslog_settings"))
            {
                options->setBool("disable_logging_for_this_rule", pix_disable_rule_log->get_active() );
                options->setStr("log_level",                      pix_log_level->get_value() );
                options->setInt("log_interval",                   pix_log_interval->get_value_as_int() );
            }
        }

	if (platform=="pf") 
        {
	    options->setStr("log_prefix" ,   pf_log_prefix->get_text() );

	    string *aor=(string*)(pf_action_on_reject->get_menu()->get_active()->get_user_data());
	    options->setStr("action_on_reject"  , *aor );

	    options->setBool("stateless", pf_no_state->get_active() );

	}

	if (platform=="ipf") 
        {
            options->setStr("log_level",        ipf_log_level->get_value() );
            options->setStr("ipf_log_facility", ipf_log_facility->get_value() );

	    string *aor=(string*)(ipf_action_on_reject->get_menu()->get_active()->get_user_data());
	    options->setStr("action_on_reject"  , *aor );
	    options->setBool("ipf_return_icmp_as_dest", ipf_return_icmp_as_dest->get_active() );

	    options->setBool("stateless", ipf_no_state->get_active() );
	    options->setBool("ipf_keep_frags", ipf_keep_frags->get_active() );
	}

	if (platform=="ipfw") 
        {
	    string *aor=(string*)(ipfw_action_on_reject->get_menu()->get_active()->get_user_data());
	    options->setStr("action_on_reject"  , *aor );

	    options->setBool("stateless", ipfw_no_state->get_active() );
	}

    }
}









