/* 

                          Firewall Builder

                 Copyright (C) 2001 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: StockButton.cc,v 1.6 2002/09/01 05:49:32 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "fwbuilder/Resources.hh"

#include "StockButton.hh"


StockButton::StockButton(stock_button_type t) : PixmapButton()
{
    string icn;
    string text;

    switch (t) {
    case 	OK:  
	icn=Resources::global_res->getIconPath("Ok");
	text=_("OK");
	break;
    case	CANCEL:
	icn=Resources::global_res->getIconPath("Cancel");
	text=_("Cancel");
	break;
    case	YES:
	icn=Resources::global_res->getIconPath("Yes");
	text=_("Yes");
	break;
    case	NO:
	icn=Resources::global_res->getIconPath("No");
	text=_("No");
	break;
    case	APPLY:
	icn=Resources::global_res->getIconPath("Apply");
	text=_("Apply");
	break;
    case	REDO:
	icn=Resources::global_res->getIconPath("Redo");
	text=_("Redo");
	break;
    case	UNDO:
	icn=Resources::global_res->getIconPath("Undo");
	text=_("Undo");
	break;
    case	CLOSE:
	icn=Resources::global_res->getIconPath("Close");
	text=_("Close");
	break;
    case	STOP:
	icn=Resources::global_res->getIconPath("Stop");
	text=_("Stop");
	break;
    case	BACK:
	icn=Resources::global_res->getIconPath("BigLeftArrow");
	text=_("Back");
	break;
    case	NEXT:
	icn=Resources::global_res->getIconPath("BigRightArrow");
	text=_("Next");
	break;
    case	FINISH:
	icn=Resources::global_res->getIconPath("Apply");
	text=_("Finish");
	break;
    }

    addPixmapAndText(icn,text);

}

