/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: TCPServiceDialog.hh,v 1.6 2002/11/24 20:37:14 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef _TCP_SERVICEDIALOG_HH
#  include "TCPServiceDialog_glade.hh"
#  define _TCP_SERVICEDIALOG_HH
#include "glademm_support.hh"

#include "fwbuilder/TCPService.hh"

class TCPServiceDialog : public TCPServiceDialog_glade
{   
        
    friend class TCPServiceDialog_glade;

    void on_urg_mask_toggled();
    void on_ack_mask_toggled();
    void on_psh_mask_toggled();
    void on_rst_mask_toggled();
    void on_syn_mask_toggled();
    void on_fin_mask_toggled();

    void on_changed();

    void update_flags();

    std::vector<class DialogOption> object_parameters;
    std::map<libfwbuilder::TCPService::TCPFlag, Gtk::CheckButton*> flag_widgets;
    std::map<libfwbuilder::TCPService::TCPFlag, Gtk::CheckButton*> mask_widgets;

public:

    TCPServiceDialog(libfwbuilder::FWObject *obj);

    virtual void wrk2dlg();
    virtual bool dlg2wrk();

};
#endif

