/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: main_window.hh,v 1.57 2003/06/02 07:41:46 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef _MAIN_WINDOW_HH
#define _MAIN_WINDOW_HH

#include <gtk--.h>

#include "helpers.hh"
#include "BuiltinDialog.hh"
#include "Navbar.hh"
#include "FWObjectBook.hh"

class RuleSetList;
class ObjectTree;

class main_window : public Gtk::Window
{   
    Gtk::Style  *window_style;

    friend void destroy_handler();
    friend class ObjectTree;

    gint on_delete_event(GdkEventAny* ev);

    void on_new1_activate();
    void on_new_wnd_activate();
    void on_open1_activate();
    void on_open_recent_file1_activate();
    void on_open_recent_file2_activate();
    void on_open_recent_file3_activate();
    void on_open_recent_file4_activate();
    void on_save1_activate();
    void on_saveas1_activate();
    void on_close_activate();
    void on_exit1_activate();
    void on_print_activate();

    void on_edit1_activate();
    
    void on_options_activate();
    void on_about1_activate();
    void on_release_notes_activate();

    void on_policy_line_add();
    void on_policy_line_remove();

    void on_insert_top();
    void on_append_bottom();
    void on_add_rule();
    void on_remove_rule();
    void on_move_up();
    void on_move_down();

    void on_tools_scan();

    void on_build_autorules();

    void on_compile();
    void on_install();

    void  on_new_fw();
    void  on_new_host();
    void  on_new_net();
    void  on_new_addr_range();
    void  on_new_obj_group();
    void  on_new_ip();
    void  on_new_icmp();
    void  on_new_tcp();
    void  on_new_udp();
    void  on_new_custom();
    void  on_new_srv_group();
    void  on_new_time();
    void  on_new_ipv4();
    void  on_new_physaddress();
    void  on_new_interface();
    void  on_new_interface_via_snmp();

    void  on_find();


/**
 * this method is used in implementation of "Paste" and "Duplicate"
 * functions. If object with ID equal to that of obj aready exists in
 * the tree, it creates and adds its copy with different ID and
 * name. 
 */
    void insertCopy(libfwbuilder::FWObject *target, libfwbuilder::FWObject *obj);


    void on_left_pane_size_allocate_event(GtkAllocation *all);
    void on_right_pane_size_allocate_event(GtkAllocation *all);

    struct windowGeometry {
	Gdk_Rectangle wnd;
	Gdk_Rectangle trwnd;
	Gdk_Rectangle objwnd;
	int           divider;
    };

/**
 * reads geometry from preferences file
 */
    void readGeometry(windowGeometry &c);
/**
 * writes geometry to the preferences file
 */
    void writeGeometry(windowGeometry &c);



/**
 *  get and set window position and size on a screen. "get" works only
 *  if window is visible, "set" works for invisilbe window, too. 
 */
    void getWindowConfiguration(Gdk_Rectangle &r);
    void setWindowConfiguration(Gdk_Rectangle &r);
    void setWindowPosition(gint16 x , gint16 y);

    int  getDividerPosition();
    void setDividerPosition(int w);

    static main_window *createNewMainWindow();

    string              active_tree_item;

    Gtk::MenuBar       *main_menubar1;
    Gtk::Menu          *recent_files_menu;

    Gtk::Table         *main_tbl;
    Gtk::VBox          *main_vb;
    Gtk::HPaned        *hpaned;
    Gtk::HBox          *statusbar_hbox;
    Gtk::Viewport      *save_statusbar;
    Gtk::Viewport      *main_statusbar;
    Gtk::Pixmap        *needs_saving_icon;
    Gtk::Label         *main_statusbar_txt;

    Navbar             *navbar;
    BuiltinDialog      *current_right_pane_dialog;
    Gtk::MenuItem      *custom_item;
    FWObjectBook       *obook;
    bool                policy_in_right_pane;

    Gtk::Widget        *left_pane_port;
    Gtk::Bin           *right_pane_port;

    Gtk::VBox          *right_vb;

    //  data for delayed OpenObject method
    string              oo_obj;
    string              oo_lib;
    SigC::Connection    open_obj_conn;
    

    Gtk::AccelGroup    *agr;

    bool                pane_docked;

    int                 left_pane_width;
    int                 left_pane_height;
    int                 right_pane_width;
    int                 right_pane_height;
    int                 stored_divider_pos;

    // helper functions

    gint open_object_when_idle();

    void build_menu();
    RuleSetList* getRuleSetListWidget();

public:

    main_window();
    virtual ~main_window();

    void  on_duplicate();
    void  on_copyobj();
    void  on_cutobj();
    void  on_pasteobj();
    void  on_delobj();

    void  on_copy();
    void  on_cut();
    void  on_paste();

    gint  emit_copy();
    gint  emit_cut();
    gint  emit_paste();

    void  on_where_used();

    void  on_sort_by_name();
    void  on_sort_by_prop();

    bool  safe_to_close_right_pane();

    bool confirm_remove_object(const string &id);
    bool confirm_remove_object(libfwbuilder::FWObject *obj);

    void LoadObjDB(const string& data_file,bool check_perm=true);
    void openFile(const string &file,bool update_recent);

    void schedule_open_object(const string &id,const string &lib);

    bool      isDialogDocked()    { return pane_docked; }

    string    nowShowingObjectId();
    libfwbuilder::FWObject* nowShowingObject();
    bool      OpenObject (const string &id,const string &lib);
    void      ClearRightPane(bool logo=false);
    void      RefreshRightPane();

    /**
     * unconditionally refreshes all windows
     */
    static void  refreshAllWindows();

    /**
     * redraws object book widget in all windows
     */
    static void  refreshAllObjectBooks();

    /**
     * redraws object book widget in all windows
     */
    static void  sortSubtreeInAllObjectBooks(const string &id,int col=0);

    /**
     * inserts new object in the tree in all windows
     */
    static void  insertInAllObjectBooks(libfwbuilder::FWObject *o);

    /**
     * removes new object from the tree in all windows
     */
    static void  removeFromAllObjectBooks(libfwbuilder::FWObject *o);

    /**
     * changes label for the object with Id 'id' in object book widget
     * in all windows
     */
    static void  changeLabelInAllObjectBooks(const std::string &id);

    /**
     *  refreshes right panel in all windows, but only if
     *  window is not mwin and shows object obj 
     */
    static void  conditionalRefreshAllDialogs(libfwbuilder::FWObject* obj,
                                              main_window *mwin=NULL);

    static void  showSaveStatusbar(bool needs_saving);
    static void  showStatusbarMsg(const string &msg);
    static void  clearStatusbar();

    static void  setTitle(const string &msg);
    static void  updateRecentlyOpenedFiles(const string &new_file);


    static main_window* getMainWindowForWidget(Gtk::Widget *w);
    static main_window* getAnotherMainWindowForWidget(Gtk::Widget *w);

    void showNavbar();
    void hideNavbar();
    void updateNavbar(libfwbuilder::FWObject* obj);
    void updateNavbar(const std::string &id);


    BuiltinDialog* getRightPaneDialog() { return current_right_pane_dialog; }
    Gtk::MenuBar*  getMainMenuBar()     { return main_menubar1; }
    FWObjectBook*  getObjectBook()      { return obook; }


    bool      checkAndSaveData();

   /**
    *  restoreWindowConfiguration restores window size.  It works on
    *  invisible window. It can not restore window position on the
    *  screen if it is invisible
    */
    void restoreWindowConfiguration();

   /**
    *  restores window's position on the screen. Works if window is already
    *  visible. 
    */

    void restoreWindowPosition();

    /**
     *  saves window's size and position
     */
    void saveWindowConfiguration();

    virtual void show_impl();
    virtual void show_all_impl();

    static std::list<main_window*> windows;


};


#endif

