/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: physAddressDialog.cc,v 1.4 2003/06/21 07:27:55 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "fwbuilder/physAddress.hh"
#include "fwbuilder/Management.hh"
#include "fwbuilder/Firewall.hh"


#include "physAddressDialog.hh"
#include "helpers.hh"
#include "MessageDialog.hh"
#include "main_window.hh"


using namespace libfwbuilder;
using namespace std;

physAddressDialog::physAddressDialog(FWObject *obj)
{
    object=obj; 

    object_parameters.push_back( DialogOption( pa_name     , "name"     ) );
    object_parameters.push_back( DialogOption( comment     , "comment"  ) );
}

physAddressDialog::~physAddressDialog()
{
}


void physAddressDialog::on_changed()
{  
    data_changed_flag(true);
}

void physAddressDialog::wrk2dlg()
{
    loadPageOptions(object,  object_parameters );

    physAddress *pa=physAddress::cast(object);
    pa_address->set_text( pa->getPhysAddress() );
    pa_name->grab_focus();
}

bool physAddressDialog::dlg2wrk()
{
/*
 *  physAddress is not necessarily MAC address ... May be we should
 *  not bother to check it here and defer this to compiler.
 */
    try
    {
        checkMACAddress(pa_address->get_text());
    } catch(FWException &ex)
    {
        MessageDialog::Error(ex.toString(),find_my_toplevel_window(this));
        return true;
    }

    savePageOptions(object,  object_parameters );

    physAddress *pa=physAddress::cast(object);
    pa->setPhysAddress( pa_address->get_text() );

    return(true);
}

/**
 *  enable and disable menu items which make sence only for this object
 */
void physAddressDialog::updateMainMenu()
{
    Gtk::MenuBar *main_menubar=main_w->getMainMenuBar();
    Gtk::Widget *itm;

    DialogPlugin::updateMainMenu();

    FWObject *p=object;
    while (p!=NULL && !Firewall::isA(p)) p=p->getParent();

    if (p!=NULL && Firewall::isA(p))
    {
        itm=find_widget("policy",main_menubar);
        if (itm) itm->set_sensitive(true);

        itm=find_widget("rules_druid",main_menubar);
        if (itm) itm->set_sensitive(true);

        itm=find_widget("compile_policy",main_menubar);
        if (itm) itm->set_sensitive(true);

        Management *mgmt=(Firewall::cast(p))->getManagementObject();
        assert(mgmt!=NULL);
        PolicyInstallScript *pis   = mgmt->getPolicyInstallScript();

        itm=find_widget("install_policy",main_menubar);
        if (itm) itm->set_sensitive( pis->isEnabled() && pis->getCommand()!="" );
    }
}


