/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: popupMenu.cc,v 1.2 2002/08/29 00:34:51 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"

#include "popupMenu.hh"

#include <gtk--.h>


popupMenu::popupMenu(const char **i)
{
    using Gtk::Menu_Helpers::MenuElem;
    using Gtk::Menu_Helpers::SeparatorElem;
    using SigC::slot;

    const char     **cptr;
    Gtk::MenuItem  *mi;
    int             n;
    choice=-1;

    
    for (n=0,cptr=i; *cptr!=NULL; n++,cptr++)  {
	if (**cptr=='\0') {
	    items().push_back( SeparatorElem() );
	} else {
	    items().push_back( MenuElem(*cptr));
            mi=items().back();
            menu_items[n]=mi;
            mi->activate.connect(
                SigC::slot((popupMenu*)this, &popupMenu::on_item_activate));
	    mi->set_name(*cptr);
	    mi->set_user_data( (void*)n );
	}
	items().back()->show();
    }
    
    cancel.connect(slot(this, &popupMenu::on_menu_cancel));
    deactivate.connect(slot(this, &popupMenu::on_menu_deactivate));
    show();
}

popupMenu::~popupMenu(){}

void popupMenu::set_sensitive(int n,bool flag)
{
    Gtk::MenuItem *mi=menu_items[n];
    if (mi) mi->set_sensitive(flag);
}

Gtk::MenuItem* popupMenu::get_item(int n)
{
    return menu_items[n];
}

void popupMenu::on_item_activate()
{
    Gtk::MenuItem *active_item = get_active();
    choice=(int)(active_item->get_user_data());
    menu_select( choice );  // callback
}

void popupMenu::on_menu_cancel()
{   
    choice=-1;
}

void popupMenu::on_menu_deactivate()
{   
    choice=-1;
}

