/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: TargetDialog_iptables.cc,v 1.19 2003/11/03 06:52:55 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"

#include "fwbuilder/FWObject.hh"
#include "fwbuilder/Firewall.hh"

#include "TargetDialog_iptables.hh"
#include "fwbuilder/Resources.hh"

#include <assert.h>

using namespace libfwbuilder;

DialogPlugin* create_dialog_iptables(FWObject *o)
{
    return new TargetDialog_iptables(o);
}

TargetDialog_iptables::TargetDialog_iptables(FWObject *obj)
{
    object=obj;

    fwoptions=(Firewall::cast(object))->getOptionsObject();
    assert(fwoptions!=NULL);

    ((Gtk::Label*)(iptables_firewall_is_in_any->get_child()))->set_alignment( 0.0 , 0.0 );

    ((Gtk::Label*)(iptables_log_tcp_seq->get_child()))->set_alignment(0.0,0.5);
    ((Gtk::Label*)(iptables_log_tcp_opt->get_child()))->set_alignment(0.0,0.5);
    ((Gtk::Label*)(iptables_log_ip_opt->get_child()))->set_alignment(0.0,0.5);
    ((Gtk::Label*)(iptables_numeric_log_levels->get_child()))->set_alignment(0.0,0.5);

    ((Gtk::Label*)(iptables_debug->get_child()))->set_alignment(0.0,0.5);
    ((Gtk::Label*)(iptables_load_modules->get_child()))->set_alignment(0.0,0.5);
//    ((Gtk::Label*)(iptables_no_optimisation->get_child()))->set_alignment(0.0,0.5);

    ((Gtk::Label*)(iptables_firewall_is_in_any->get_child()))->set_alignment(0.0,0.5);
    ((Gtk::Label*)(iptables_configure_interfaces->get_child()))->set_alignment(0.0,0.5);
    ((Gtk::Label*)(iptables_manage_virtual_addr->get_child()))->set_alignment(0.0,0.5);
    ((Gtk::Label*)(iptables_log_all_dropped->get_child()))->set_alignment(0.0,0.5);
    ((Gtk::Label*)(iptables_clamp_MSS_to_MTU->get_child()))->set_alignment(0.0,0.5);

    ((Gtk::Label*)(iptables_accept_new_tcp_with_no_syn->get_child()))->set_alignment(0.0,1.0);
    ((Gtk::Label*)(iptables_accept_new_tcp_with_no_syn->get_child()))->set_justify(GTK_JUSTIFY_LEFT);

    ((Gtk::Label*)(iptables_accept_established->get_child()))->set_alignment(0.0,1.0);
    ((Gtk::Label*)(iptables_accept_established->get_child()))->set_justify(GTK_JUSTIFY_LEFT);

    ((Gtk::Label*)(iptables_log_all->get_child()))->set_justify(GTK_JUSTIFY_LEFT);

    ((Gtk::Label*)(iptables_verify_interfaces->get_child()))->set_alignment(0.0,1.0);
    ((Gtk::Label*)(iptables_verify_interfaces->get_child()))->set_justify(GTK_JUSTIFY_LEFT);


    map<string,string>   log_levels;

    log_levels[""       ]="        "  ;
    log_levels["alert"  ]="1: alert"  ;
    log_levels["crit"   ]="2: crit"   ;
    log_levels["error"  ]="3: error"  ;
    log_levels["warning"]="4: warning";
    log_levels["notice" ]="5: notice" ;
    log_levels["info"   ]="6: info"   ;
    log_levels["debug"  ]="7: debug"  ;

    iptables_log_level->set_menu(log_levels);
    iptables_log_level->changed.connect(SigC::slot(this,&TargetDialog_iptables::on_iptables_log_level_changed));
    iptables_log_level->show_all();

    vector<string>  limit_suffixes;

    limit_suffixes.push_back("");
    limit_suffixes.push_back("/second");
    limit_suffixes.push_back("/minute");
    limit_suffixes.push_back("/hour");
    limit_suffixes.push_back("/day");

    iptables_limit_suffix->set_menu(limit_suffixes);
    iptables_limit_suffix->changed.connect( SigC::slot(this,&TargetDialog_iptables::on_iptables_limit_suffix_changed));
    iptables_limit_suffix->show_all();

    vector<string>  actions_on_reject;

    actions_on_reject.push_back("ICMP net unreachable");
    actions_on_reject.push_back("ICMP host unreachable");
    actions_on_reject.push_back("ICMP port unreachable");
    actions_on_reject.push_back("ICMP proto unreachable");
    actions_on_reject.push_back("ICMP net prohibited");
    actions_on_reject.push_back("ICMP host prohibited");
    actions_on_reject.push_back("ICMP admin prohibited");
    actions_on_reject.push_back("TCP RST");

    iptables_action_on_reject->set_menu(actions_on_reject);
    iptables_action_on_reject->changed.connect(SigC::slot(this,&TargetDialog_iptables::on_iptables_action_on_reject_changed));
    iptables_action_on_reject->show_all();


    options.push_back( DialogOption( iptables_log_tcp_seq         , "log_tcp_seq"    ));
    options.push_back( DialogOption( iptables_log_tcp_opt         , "log_tcp_opt"    ));
    options.push_back( DialogOption( iptables_log_ip_opt          , "log_ip_opt"     ));
    options.push_back( DialogOption( iptables_numeric_log_levels  , "use_numeric_log_levels" ));
                                                                  
    options.push_back( DialogOption( iptables_log_level           , "log_level"       ));
                                                                  
    options.push_back( DialogOption( iptables_use_ULOG            , "use_ULOG"        ));
    options.push_back( DialogOption( iptables_ulog_cprange        , "ulog_cprange"    ));
    options.push_back( DialogOption( iptables_ulog_qthr           , "ulog_qthreshold" ));
    options.push_back( DialogOption( iptables_ulog_nlgroup        , "ulog_nlgroup"    ));
                                                                  
    options.push_back( DialogOption( iptables_log_prefix          , "log_prefix"      ));

    options.push_back( DialogOption( iptables_limit_suffix        , "limit_suffix"    ));
    options.push_back( DialogOption( iptables_limit_value         , "limit_value"     ));
                                                                  
    options.push_back( DialogOption( iptables_log_all_dropped     , "log_all_dropped"));
                                                                  
    options.push_back( DialogOption( iptables_log_all             , "log_all"         ));
                                                                  
                                                                  
                                                                  
    options.push_back( DialogOption( iptables_load_modules        , "load_modules"    ));
       			      		                          
    options.push_back( DialogOption( iptables_debug               , "debug"           ));
       			                                          
    options.push_back( DialogOption( iptables_action_on_reject    , "action_on_reject"));
       			                                          
    options.push_back( DialogOption( iptables_firewall_is_in_any  , "firewall_is_part_of_any_and_networks"));
//    options.push_back( DialogOption( iptables_no_optimisation     , "no_optimisation"));

    options.push_back( DialogOption( iptables_configure_interfaces, "configure_interfaces"     ));

    options.push_back( DialogOption( iptables_manage_virtual_addr , "manage_virtual_addr"     ));

    options.push_back( DialogOption( iptables_verify_interfaces   , "verify_interfaces"     ));
                                                                  
    options.push_back( DialogOption( iptables_clamp_MSS_to_MTU    , "clamp_mss_to_mtu"));
    
    options.push_back( DialogOption( iptables_accept_new_tcp_with_no_syn,
                                     "accept_new_tcp_with_no_syn"));
       			     
    options.push_back( DialogOption( iptables_accept_established  , "accept_established"  ));
    options.push_back( DialogOption( iptables_bridging_fw         , "bridging_fw"         ));

    options.push_back( DialogOption( ipt_check_shadowing          , "check_shading"       ));
    options.push_back( DialogOption( ipt_ignore_empty_groups      , "ignore_empty_groups" ));

    options.push_back( DialogOption( ipt_local_nat                , "local_nat"           ));
}

void TargetDialog_iptables::LOG_ULOG_state()
{  
    bool r=iptables_use_ULOG->get_active();

    iptables_log_tcp_seq->set_sensitive(!r);
    iptables_log_tcp_opt->set_sensitive(!r);
    iptables_log_ip_opt->set_sensitive(!r);
    iptables_numeric_log_levels->set_sensitive(!r);
    iptables_log_level->set_sensitive(!r);
    iptables_log_level_label->set_sensitive(!r);

    iptables_ulog_cprange->set_sensitive(r);
    iptables_ulog_cprange_label->set_sensitive(r);
    iptables_ulog_qthr->set_sensitive(r);
    iptables_ulog_qthr_label->set_sensitive(r);
    iptables_ulog_nlgroup->set_sensitive(r);
    iptables_ulog_nlgroup_label->set_sensitive(r);
}

void TargetDialog_iptables::on_LOG_ULOG_clicked()
{  
    LOG_ULOG_state();
    on_changed();
}


void TargetDialog_iptables::on_changed()
{   
    DialogPlugin::data_changed_flag(true);	
}

void TargetDialog_iptables::on_iptables_log_level_changed()
{
    string nl=iptables_log_level->get_value();
    string ol=fwoptions->getStr("log_level" );
    if (nl!=ol) on_changed();
}

void TargetDialog_iptables::on_iptables_limit_suffix_changed()
{
    string nl=iptables_limit_suffix->get_value();
    string  ol=fwoptions->getStr("limit_suffix" );
    if (nl!=ol) on_changed();
}

void TargetDialog_iptables::on_iptables_action_on_reject_changed()
{
    string naor=iptables_action_on_reject->get_value();
    string oaor=fwoptions->getStr("action_on_reject" );
    if (naor!=oaor) on_changed();
}

void TargetDialog_iptables::readDefaults()
{
    iptables_load_modules->set_active(
        Resources::platform_res["iptables"]->getResourceBool(
            "/FWBuilderResources/Target/options/load_modules"));

    iptables_firewall_is_in_any->set_active(
        Resources::platform_res["iptables"]->getResourceBool(
            "/FWBuilderResources/Target/options/firewall_is_part_of_any_and_networks"));

    iptables_accept_new_tcp_with_no_syn->set_active(
        Resources::platform_res["iptables"]->getResourceBool(
            "/FWBuilderResources/Target/options/accept_new_tcp_with_no_syn"));

    iptables_accept_established->set_active(
        Resources::platform_res["iptables"]->getResourceBool(
            "/FWBuilderResources/Target/options/accept_established"));

    iptables_configure_interfaces->set_active(
        Resources::platform_res["iptables"]->getResourceBool(
            "/FWBuilderResources/Target/options/configure_interfaces"));

    iptables_manage_virtual_addr->set_active(
        Resources::platform_res["iptables"]->getResourceBool(
            "/FWBuilderResources/Target/options/manage_virtual_addr"));

    iptables_log_level->set_active_item_by_value(
        Resources::platform_res["iptables"]->getResourceStr(
            "/FWBuilderResources/Target/options/log_level"));

    iptables_log_prefix->set_text(
        Resources::platform_res["iptables"]->getResourceStr(
            "/FWBuilderResources/Target/options/log_prefix"));

    iptables_ulog_nlgroup->set_value(
        Resources::platform_res["iptables"]->getResourceInt(
            "/FWBuilderResources/Target/options/ulog_nlgroup"));

    iptables_limit_value->set_value(
        Resources::platform_res["iptables"]->getResourceInt(
            "/FWBuilderResources/Target/options/limit_value"));

}

void TargetDialog_iptables::wrk2dlg()
{
    map<string,string>        fw_versions_menu;

    fw_versions_menu.clear();

    fw_versions_menu[DialogPlugin::magic_empty_option] = "";
    fw_versions_menu["lt_1.2.6"] = " 1.2.6";
    fw_versions_menu["ge_1.2.6"] = "1.2.6 to 1.2.8";
    fw_versions_menu["1.2.9"]    = "1.2.9";

    fw_version->set_menu(fw_versions_menu);
    fw_version->changed.connect(SigC::slot(this,&TargetDialog_iptables::on_changed));
    fw_version->show_all();

    loadOptionMenu (object,fw_version,"version");

    loadPageOptions(fwoptions,  options);

    LOG_ULOG_state();
}

bool TargetDialog_iptables::dlg2wrk()
{
    saveOptionMenu(object,fw_version,"version");

    savePageOptions(fwoptions,  options );
    return true;
}
