<!--
   Filename: translate087preferences.xsl
   Author: Friedhelm Duesterhoeft
   Build date: 04/16/2001
   Last changed: 04/16/2001
   Version: 1.4.1
   Description: translates old style fwbuilder user preferences according to new DTD (1.40)
   Caveates: none known
-->
<xsl:stylesheet version="1.0"
       xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
>

<xsl:output method="xml" version="1.0" doctype-system="fwbuilder_preferences.dtd" indent="yes" encoding="utf-8"/>

<xsl:template name="Print">
   <Print>
      <Command>lpr</Command>
      <Filter>null.xsl</Filter>
      <ToFile>false</ToFile>
   </Print>
</xsl:template>

<xsl:template match="Paths">
   <Paths>
   <xsl:choose>
      <xsl:when test="Wdir">
         <xsl:copy-of select="Wdir"/>
      </xsl:when>
      <xsl:otherwise>
         <Wdir/>
      </xsl:otherwise>
   </xsl:choose>
   <xsl:choose>
      <xsl:when test="SNMPget">
        <xsl:copy-of select="SNMPget"/>
      </xsl:when>
      <xsl:otherwise>
        <SNMPget>/usr/bin/snmpget</SNMPget>
      </xsl:otherwise>
   </xsl:choose>
   <xsl:choose>
      <xsl:when test="SNMPwalk">
        <xsl:copy-of select="SNMPwalk"/>
      </xsl:when>
      <xsl:otherwise>
        <SNMPwalk>/usr/bin/snmpwalk</SNMPwalk>
      </xsl:otherwise>
   </xsl:choose>
   </Paths>
</xsl:template>

<xsl:template match="UI">
   <UI>
   <xsl:choose>
      <xsl:when test="ShowIconsInPolicy='1'"> 
        <ShowIconsInPolicy>true</ShowIconsInPolicy>
      </xsl:when>
      <xsl:when test="ShowIconsInPolicy='0'"> 
        <ShowIconsInPolicy>false</ShowIconsInPolicy>
      </xsl:when>
      <xsl:otherwise>
        <ShowIconsInPolicy>true</ShowIconsInPolicy>
      </xsl:otherwise>
   </xsl:choose>
   <xsl:choose>
      <xsl:when test="LargeIconsInGroups='1'"> 
        <LargeIconsInGroups>true</LargeIconsInGroups>
      </xsl:when>
      <xsl:when test="LargeIconsInGroups='0'"> 
        <LargeIconsInGroups>false</LargeIconsInGroups>
      </xsl:when>
      <xsl:otherwise>
        <LargeIconsInGroups>true</LargeIconsInGroups>
      </xsl:otherwise>
   </xsl:choose>
   <xsl:choose>
      <xsl:when test="ShowHidden='1'"> 
        <ShowHidden>true</ShowHidden>
      </xsl:when>
      <xsl:when test="ShowHidden='0'"> 
        <ShowHidden>false</ShowHidden>
      </xsl:when>
      <xsl:otherwise>
        <ShowHidden>true</ShowHidden>
      </xsl:otherwise>
   </xsl:choose>
   <ObjectQuickView>popup</ObjectQuickView>
   <ObjectQuickViewTimeout>2</ObjectQuickViewTimeout>
   </UI>
</xsl:template>

<xsl:template match="/FWBuilderPreferences">
   <FWBuilderPreferences version="0.9.0">
       <xsl:call-template name="Print"/>
       <xsl:apply-templates select="Paths"/>
       <xsl:apply-templates select="UI"/>
   </FWBuilderPreferences>
</xsl:template>

</xsl:stylesheet>
