/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: TargetDialog_ipf.cc,v 1.16 2003/11/30 20:59:02 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"
#include "fwbuilder/Firewall.hh"

#include "TargetDialog_ipf.hh"
#include "fwbuilder/Resources.hh"

using namespace libfwbuilder;

DialogPlugin* create_dialog_ipf(FWObject *o)
{
    return new TargetDialog_ipf(o);
}


TargetDialog_ipf::TargetDialog_ipf(FWObject *obj) 
{ 
    object=obj;

    fwoptions=(Firewall::cast(object))->getOptionsObject();
    assert(fwoptions!=NULL);

    ((Gtk::Label*)(ipf_accept_new_tcp_with_no_syn->get_child()))->set_alignment(0.0,1.0);
    ((Gtk::Label*)(ipf_accept_new_tcp_with_no_syn->get_child()))->set_justify(GTK_JUSTIFY_LEFT);

    ((Gtk::Label*)(ipf_log_or_block->get_child()))->set_alignment(0.0,0.5);
    ((Gtk::Label*)(ipf_log_body->get_child()))->set_alignment(0.0,0.5);

    ((Gtk::Label*)(ipf_nat_ftp_proxy->get_child()))->set_alignment(0.0,0.5);
    ((Gtk::Label*)(ipf_nat_rcmd_proxy->get_child()))->set_alignment(0.0,0.5);
    ((Gtk::Label*)(ipf_nat_raudio_proxy->get_child()))->set_alignment(0.0,0.5);

    label557->set_line_wrap(true);


    vector<string>  actions_on_reject;

    actions_on_reject.push_back("ICMP net unreachable");
    actions_on_reject.push_back("ICMP host unreachable");
    actions_on_reject.push_back("ICMP port unreachable");
    actions_on_reject.push_back("ICMP proto unreachable");
    actions_on_reject.push_back("ICMP net prohibited");
    actions_on_reject.push_back("ICMP host prohibited");
    actions_on_reject.push_back("TCP RST");

    ipf_action_on_reject->set_menu(actions_on_reject);
    ipf_action_on_reject->changed.connect(SigC::slot(this,&TargetDialog_ipf::on_ipf_action_on_reject_changed));
    ipf_action_on_reject->show_all();


    map<string,string>        log_facilities_full;

    log_facilities_full[""         ]="             "  ;
    log_facilities_full["kern"     ]=" 0: kern     "  ;
    log_facilities_full["user"     ]=" 1: user     "  ;
    log_facilities_full["mail"     ]=" 2: mail     "  ;
    log_facilities_full["daemon"   ]=" 3: daemon   "  ;
    log_facilities_full["auth"     ]=" 4: auth     "  ;
    log_facilities_full["syslog"   ]=" 5: syslog   "  ;
    log_facilities_full["lpr"      ]=" 6: lpr      "  ;
    log_facilities_full["news"     ]=" 7: news     "  ;
    log_facilities_full["uucp"     ]=" 8: uucp     "  ;
    log_facilities_full["cron"     ]=" 9: cron     "  ;
    log_facilities_full["authpriv" ]="10: authpriv "  ;
    log_facilities_full["ftp"      ]="11: ftp      "  ;
    log_facilities_full["local0"   ]="16: local0   "  ;
    log_facilities_full["local1"   ]="17: local1   "  ;
    log_facilities_full["local2"   ]="18: local2   "  ;
    log_facilities_full["local3"   ]="19: local3   "  ;
    log_facilities_full["local4"   ]="20: local4   "  ;
    log_facilities_full["local5"   ]="21: local5   "  ;
    log_facilities_full["local6"   ]="22: local6   "  ;
    log_facilities_full["local7"   ]="23: local7   "  ;

    map<string,string>        log_levels;
    log_levels[""       ]="        "  ;
    log_levels["alert"  ]="1: alert"  ;
    log_levels["crit"   ]="2: crit"   ;
    log_levels["error"  ]="3: error"  ;
    log_levels["warning"]="4: warning";
    log_levels["notice" ]="5: notice" ;
    log_levels["info"   ]="6: info"   ;
    log_levels["debug"  ]="7: debug"  ;



    ipf_log_facility->set_menu(log_facilities_full);
    ipf_log_facility->changed.connect(SigC::slot(this,&TargetDialog_ipf::on_ipf_log_facility_changed));
    ipf_log_facility->show_all();

    ipf_log_level->set_menu(log_levels);
    ipf_log_level->changed.connect(SigC::slot(this,&TargetDialog_ipf::on_ipf_log_level_changed));
    ipf_log_level->show_all();

    label571->set_line_wrap(true);
    label572->set_line_wrap(true);

    ((Gtk::Label*)(ipf_in_out_code->get_child()))->set_alignment(0.0,0.5);
    ((Gtk::Label*)(ipf_pass_all_out->get_child()))->set_alignment(0.0,0.5);

    options.push_back( DialogOption( ipf_in_out_code      , "in_out_code"   ));
    options.push_back( DialogOption( ipf_pass_all_out     , "pass_all_out"  ));

    options.push_back( DialogOption( ipf_accept_new_tcp_with_no_syn,
                                     "accept_new_tcp_with_no_syn"));       			     
    options.push_back( DialogOption( ipf_eliminate_duplicates , "eliminate_duplicates" ));
    options.push_back( DialogOption( ipf_check_shadowing      , "check_shading"        ));
    options.push_back( DialogOption( ipf_ignore_empty_groups  , "ignore_empty_groups"  ));
    
    options.push_back( DialogOption( ipf_log_level           , "ipf_log_level"       ));
    options.push_back( DialogOption( ipf_log_facility        , "ipf_log_facility"    ));
    options.push_back( DialogOption( ipf_log_or_block        , "ipf_log_or_block"    ));
    options.push_back( DialogOption( ipf_log_body            , "ipf_log_body"        ));

    ((Gtk::Label*)(ipf_debug->get_child()))->set_alignment(0.0,0.5);

    ((Gtk::Label*)(ipf_manage_virtual_addr->get_child()))->set_alignment(0.0,0.5);
    ((Gtk::Label*)(ipf_manage_virtual_addr->get_child()))->set_justify(GTK_JUSTIFY_LEFT);

    ((Gtk::Label*)(ipf_configure_interfaces->get_child()))->set_alignment(0.0,0.5);
    ((Gtk::Label*)(ipf_configure_interfaces->get_child()))->set_justify(GTK_JUSTIFY_LEFT);


    options.push_back( DialogOption( ipf_action_on_reject     , "action_on_reject"     ));
    options.push_back( DialogOption( ipf_return_icmp_as_dest  , "ipf_return_icmp_as_dest"     ));


    options.push_back( DialogOption( ipf_nat_ftp_proxy        , "ipf_nat_ftp_proxy"    ));
    options.push_back( DialogOption( ipf_nat_rcmd_proxy       , "ipf_nat_rcmd_proxy"   ));
    options.push_back( DialogOption( ipf_nat_raudio_proxy     , "ipf_nat_raudio_proxy" ));
    options.push_back( DialogOption( ipf_nat_h323_proxy       , "ipf_nat_h323_proxy" ));
    options.push_back( DialogOption( ipf_nat_ipsec_proxy      , "ipf_nat_ipsec_proxy" ));

    options.push_back( DialogOption( ipf_debug                , "debug"                ));
    options.push_back( DialogOption( ipf_configure_interfaces , "configure_interfaces"  ));
    options.push_back( DialogOption( ipf_manage_virtual_addr  , "manage_virtual_addr"  ));
    options.push_back( DialogOption( ipf_optimize             , "optimize"  ));

    options.push_back( DialogOption( ipf_fw_dir               , "firewall_dir"         ));
}

void TargetDialog_ipf::on_ipf_action_on_reject_changed()
{
    string naor=ipf_action_on_reject->get_value();
    string oaor=fwoptions->getStr("action_on_reject" );
    if (naor!=oaor) on_changed();
}


void TargetDialog_ipf::on_ipf_log_facility_changed()
{
    string nl=ipf_log_facility->get_value();
    string ol=fwoptions->getStr("ipf_log_facility" );
    if (nl!=ol) on_changed();
}

void TargetDialog_ipf::on_ipf_log_level_changed()
{
    string nl=ipf_log_level->get_value();
    string ol=fwoptions->getStr("ipf_log_level" );
    if (nl!=ol) on_changed();
}



void TargetDialog_ipf::on_changed()
{   
    DialogPlugin::data_changed_flag(true);
}

void TargetDialog_ipf::readDefaults()
{
    ipf_fw_dir->set_text(
        Resources::platform_res["ipf"]->getResourceStr(
            "/FWBuilderResources/Target/options/firewall_dir"));
}

void TargetDialog_ipf::wrk2dlg()
{
    map<string,string>        fw_versions_menu;

    fw_versions_menu.clear();

    fw_versions_menu[DialogPlugin::magic_empty_option] = "";

    fw_version->set_menu(fw_versions_menu);
    fw_version->changed.connect(SigC::slot(this,&TargetDialog_ipf::on_changed));
    fw_version->show_all();

    loadOptionMenu (object,fw_version,"version");

    loadPageOptions(fwoptions,  options);
}

bool TargetDialog_ipf::dlg2wrk()
{
    saveOptionMenu(object,fw_version,"version");

    savePageOptions(fwoptions,  options );
    return true;
}
