/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: TargetDialog_ipfw.cc,v 1.2 2003/11/03 06:52:55 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "fwbuilder/Firewall.hh"

#include "TargetDialog_ipfw.hh"
#include "fwbuilder/Resources.hh"

using namespace libfwbuilder;

DialogPlugin* create_dialog_ipfw(FWObject *o)
{
    return new TargetDialog_ipfw(o);
}

TargetDialog_ipfw::TargetDialog_ipfw(FWObject *obj) 
{ 
    object=obj;

    fwoptions=(Firewall::cast(object))->getOptionsObject();
    assert(fwoptions!=NULL);

    ((Gtk::Label*)(ipfw_configure_interfaces->get_child()))->set_alignment(0.0,0.5);
    ((Gtk::Label*)(ipfw_configure_interfaces->get_child()))->set_justify(GTK_JUSTIFY_LEFT);

    ((Gtk::Label*)(ipfw_manage_virtual_addr->get_child()))->set_alignment(0.0,0.5);
    ((Gtk::Label*)(ipfw_manage_virtual_addr->get_child()))->set_justify(GTK_JUSTIFY_LEFT);

    ((Gtk::Label*)(ipfw_debug->get_child()))->set_alignment(0.0,0.5);

    options.push_back( DialogOption( ipfw_check_shadowing       , "check_shading"        ));
    options.push_back( DialogOption( ipfw_ignore_empty_groups   , "ignore_empty_groups"  ));
    
    options.push_back( DialogOption( ipfw_debug                 , "debug"                ));
    options.push_back( DialogOption( ipfw_configure_interfaces  , "configure_interfaces"  ));
    options.push_back( DialogOption( ipfw_manage_virtual_addr   , "manage_virtual_addr"  ));
    options.push_back( DialogOption( ipfw_fw_dir                , "firewall_dir"         ));
}

void TargetDialog_ipfw::on_changed()
{   
    DialogPlugin::data_changed_flag(true);
}

void TargetDialog_ipfw::readDefaults()
{
    ipfw_fw_dir->set_text(
        Resources::platform_res["ipfw"]->getResourceStr(
            "/FWBuilderResources/Target/options/firewall_dir"));
}

void TargetDialog_ipfw::wrk2dlg()
{
    loadPageOptions(fwoptions,  options);
}

bool TargetDialog_ipfw::dlg2wrk()
{
    savePageOptions(fwoptions,  options );
    return true;
}


